-- C:\Users\rboric\Desktop\IRN\4111\vfr.pkb
--
-- Generated for Oracle 10g on Fri Oct 17  09:33:37 2025 by Server Generator 6.5.96.5.6
 

PROMPT Creating Package Body 'VFR'
CREATE OR REPLACE PACKAGE BODY VFR IS

FUNCTION R_KASE
 RETURN SYS_REFCURSOR
 IS



 l_rc SYS_REFCURSOR;
BEGIN
   /* Valjane kase vrste VGE */
   OPEN l_rc FOR
      SELECT kase.id          AS id,
             kase.sifra       AS sifra,
             kase.naziv       AS naziv,
             oj.sifra         AS sifra_rc,
             kase.izmjena_dat AS izmjena_dat
        FROM mgmp_kase kase, m_kasa_np kasanp, m_oj oj
       WHERE metapl_sifra = 'VFR'
         AND kase.id      = kasanp.kase_id
         AND kasanp.oj_id = oj.id(+)
         AND (((pra_zmp_zaj.zmppar_vrijednost ('GAS', '1004') = '1')  AND oj.sifra is NOT NULL)
                OR oj.sifra IS NULL)
         AND NVL(kase.dat_ponisten, TRUNC (SYSDATE)) > TRUNC (SYSDATE - 1);
   RETURN l_rc;
END;
FUNCTION R_KNJIGOVODSTVENE_GRUPE
 RETURN SYS_REFCURSOR
 IS

 l_rc SYS_REFCURSOR;
BEGIN
   /* Knjigovodstvene grupe proizvoda  */
   OPEN l_rc FOR
      SELECT DISTINCT(gknji.id) AS id,
             gknji.sifra        AS sifra,
             gknji.naziv        AS naziv,
             gknji.izmjena_dat  AS izmjena_dat
        FROM m_proizvodi pro,
             m_gknjigo gknji
       WHERE pro.gknji_id    = gknji.id;
   RETURN l_rc;
END;
FUNCTION R_POREZNE_GRUPE
 RETURN SYS_REFCURSOR
 IS



 l_rc SYS_REFCURSOR;
BEGIN
    /* Porezne grupe proizvoda  */
  OPEN l_rc FOR
      SELECT DISTINCT(gpor.id) AS id,
             gpor.sifra        AS sifra,
             gpor.naziv        AS naziv,
             vpispz.stopa      AS stopa_pdv,
             gpor.ppot         AS stopa_ppot,
             gpor.izmjena_dat  AS izmjena_dat
        FROM m_proizvodi pro,
             m_gporez gpor,
             mgas_gpor_raz gporraz,
             s_vpisporukap vpispp,
             s_vpisporukaz vpispz
       WHERE pro.gpor_id      = gpor.ID
         AND gpor.ID =  gporraz.gpor_id
         AND SYSDATE BETWEEN gporraz.dat_valjan AND NVL(gporraz.dat_ponisten, SYSDATE)
         AND gporraz.vpispp_id   = vpispp.id
         AND vpispp.vpispz_id = vpispz.id;
   RETURN l_rc;
END;
FUNCTION R_VPLACANJA
 (KASE_ID_P m_kase.id%TYPE
 )
 RETURN SYS_REFCURSOR
 IS



l_rc SYS_REFCURSOR;
BEGIN
    /* Vrste pla?ja za kasu (parametar kasa) */
   OPEN l_rc FOR
      SELECT DISTINCT(vpla.id) AS id,
             vpla.sifra        AS sifra,
             vpla.naziv        AS naziv,
             vppla.sifra       AS fis_oznaka,
             vpla.izmjena_dat  AS izmjena_dat
        FROM mgmp_kase kase,
             m_kasa_np kasanp,
             m_nac_vpla nacvpla,
             s_vplacanja vpla,
             s_vpplacanja vppla
       WHERE kase.id       = kase_id_p
         AND kasanp.kase_id  = kase.id
         AND kasanp.nac_id   = nacvpla.nac_id
         AND nacvpla.vpla_id = vpla.id
         AND vpla.vppla_id   = vppla.id;
   RETURN l_rc;
 END;
FUNCTION R_PROIZVODI
 (KASE_ID_P m_kase.id%TYPE
 ,PRO_SIFRA_P m_proizvodi.sifra%TYPE
 )
 RETURN SYS_REFCURSOR
 IS



l_rc SYS_REFCURSOR;
BEGIN
   /* Proizvod po ?ifri za kasu iz asortimana kase */
   OPEN l_rc FOR
      SELECT DISTINCT(pro.id)    AS id,
             pro.sifra           AS sifra,
             pro.naziv           AS naziv,
             pra_pos_gas.br_subtotal (UPPER (SUBSTR (gknji.naziv, 1, 2)) || ' '|| vpispz.stopa || '+' || gpor.ppot) AS subtotal,
                                      UPPER (SUBSTR (gknji.naziv, 1, 2)) || ' '|| vpispz.stopa || '+' || gpor.ppot  AS opera_sub,
             pro.gknji_id        AS gknji_id,
             pro.gpor_id         AS gpor_id,
             asokase.pc          AS cijena,
             asokase.izmjena_dat AS izmjena_dat
        FROM m_aso_kase asokase,
             m_proizvodi pro,
             m_gporez gpor,
             mgas_gpor_raz gporraz,
             s_vpisporukap vpispp,
             s_vpisporukaz vpispz,
             m_gknjigo gknji
       WHERE asokase.kase_id   = kase_id_p
         AND pro.sifra         = NVL(pro_sifra_p, pro.sifra)
         AND asokase.pro_id    = pro.id
         AND pro.gpor_id       = gpor.ID
         AND pro.gpor_id       = gporraz.gpor_id
         AND SYSDATE BETWEEN gporraz.dat_valjan AND NVL(gporraz.dat_ponisten, SYSDATE)
         AND pro.gknji_id      = gknji.ID
         AND gporraz.vpispp_id    = vpispp.id
         AND vpispp.vpispz_id  = vpispz.id
         AND NVL (pro.dat_ponisten, TRUNC (SYSDATE)) > TRUNC (SYSDATE - 1);

      RETURN l_rc;
END;
FUNCTION GET_RNKASE
 (GODINA_P IN t_rnkase.godina%TYPE
 ,KASE_ID_P IN mgmp_kase.id%TYPE
 )
 RETURN SYS_REFCURSOR
 IS



  l_rc SYS_REFCURSOR;
BEGIN
  /* TEST*/
  -- dodati da je kasa 'VGE' da podaci ne bi mogli biti dostupni svima

  OPEN L_RC FOR
     SELECT t.id,
            t.godina,
            t.kase_id,
            t.rbr,
            T.DATUM AS DATUM_BLAGAJNE,
            T.DATUM_IZDAVANJA AS DATUM_VRIJEME_RACUNA,
            t.vpla_id,
            t.zastitni_kod AS zki,
            t.jir,
            t.paragon AS opera_podaci
       FROM t_rnkase t,
            mgmp_kase k
      WHERE k.metapl_sifra = 'VFR'
        AND t.godina  = NVL(godina_p, TO_CHAR(SYSDATE, 'YYYY'))
        AND t.kase_id = k.id
        AND t.kase_id = kase_id_p;

  RETURN l_rc;
END;
FUNCTION GET_RNSTAVKE
 (RN_ID_P IN T_RNKASE.ID%TYPE
 )
 RETURN SYS_REFCURSOR
 IS



  l_rc SYS_REFCURSOR;
BEGIN
  -- dodati da je kasa 'VGE' da podaci ne bi mogli biti dostupni svima
  -- OPEN L_RC FOR SELECT * FROM T_RNKASE_PRO T WHERE T.RN_ID = RN_ID_P;
  /* TEST*/

OPEN l_rc FOR
   SELECT t.rn_id,
          t.rbr_stavke,
          t.pro_id,
          t.cijena,
          t.kolicina,
          t.pdv  AS stopa_pdv,
          t.ppot AS stopa_ppot,
          t.iznos_pdv,
          t.iznos_ppot,
          t.iznos_popust,
          t.iznos
     FROM t_rnkase_pro t
    WHERE t.rn_id = rn_id_p;

  RETURN l_rc;
END;
PROCEDURE RNKASE
 (GODINA_P IN t_rnkase.godina%TYPE
 ,KASE_ID_P IN mgmp_kase.ID%TYPE
 ,RBR_P IN t_rnkase.rbr%TYPE
 ,DATUM_BLAGAJNE_P IN t_rnkase.datum%TYPE
 ,DATUM_VRIJEME_RACUNA_P t_rnkase.datum_izdavanja%TYPE
 ,VPLA_ID_P IN t_rnkase.vpla_id%TYPE
 ,ZKI_P IN t_rnkase.zastitni_kod%TYPE
 ,JIR_P IN t_rnkase.jir%TYPE
 ,OPERA_PODACI_P IN t_rnkase.paragon%TYPE
 ,RN_ID_P OUT t_rnkase.id%TYPE
 ,OZNAKA_ZAPOSLENIKA_P VARCHAR2
 ,NAPOMENA_P t_rnkase.opis%TYPE
 ,RBR_FISK_P IN t_rnkase.rbr_fisk%TYPE
 )
 IS


/* Uzima se prvi konobar, svi ra?i su vezani samo na jednog konobara */
  CURSOR kon_id_C (kase_id_p VARCHAR2)IS
      SELECT kon.id
        FROM m_kon_kase konkase, m_konobari kon
       WHERE konkase.kase_id = kase_id_p
         AND konkase.kon_id = kon.id
       ORDER BY kon.sifra;

/* Uzima se prvi na? potro?nje, dogovorno je samo jedan */
  CURSOR nac_id_C (kase_id_p VARCHAR2)IS
      SELECT nac.id
        FROM m_kasa_np kasanp, m_nacpot nac
       WHERE kasanp.kase_id = kase_id_p
         AND kasanp.nac_id = nac.id
       ORDER BY nac.sifra;

  CURSOR vpla_id_C (vpla_id_p VARCHAR2)IS
      SELECT vpla.ozn_irn
        FROM s_vplacanja vpla
       WHERE id = vpla_id_p;

  kon_id_l    m_konobari.id%TYPE;
  nac_id_l    m_nacpot.id%TYPE;
  rn_id_l     t_rnkase.id%TYPE;
  oj_id_l     m_oj.id%TYPE;
  ozn_irn_l   s_vplacanja.ozn_irn%TYPE;
  ozn_valjanosti_l  t_rnkase.ozn_valjanosti%TYPE;
  opis_l t_rnkase.opis%TYPE;
BEGIN
   OPEN kon_id_C (kase_id_p);
   FETCH kon_id_C INTO kon_id_l ;
   CLOSE kon_id_C;

    OPEN nac_id_C (kase_id_p);
   FETCH nac_id_C INTO nac_id_l;
   CLOSE nac_id_C;

   OPEN vpla_id_C (vpla_id_p);
   FETCH vpla_id_C INTO ozn_irn_l ;
   CLOSE vpla_id_C;

   /* U oznaci zaposlenika e biti OIB ili neka druga indentifikacijska oznaka
      Ako je zapisna oznaka zaposlenika nadjaava napomenu */
   IF oznaka_zaposlenika_p IS NOT NULL AND pra_zmp_zaj.zmppar_vrijednost ('VFR', '1001') <> 'nebitno'  THEN
      SELECT id INTO nac_id_l    
        FROM m_nacpot 
       WHERE sifra = pra_zmp_zaj.zmppar_vrijednost ('VFR', '1001');  
        opis_l := oznaka_zaposlenika_p;
   ELSE  
     opis_l := napomena_p;
   END IF;
   
   /* Za gotovinske (fiskalne) vrste pla?ja ra?i (ozn_valjanosti = 'P') se u Operu ?alju preko paketa OPERA_PSM */
   IF ozn_irn_l IS NULL THEN
      ozn_valjanosti_l := 'P';
   ELSE
      ozn_valjanosti_l := 'V';
   END IF;

   /* Ako je u parametru GAS '1004' upisano 1, tada se radi sa Opera sustavom */
   IF pra_zmp_zaj.zmppar_vrijednost ('GAS', '1004') = '1'  THEN
      /*
      Kod ra?a na sobu, polje PARAGON sadr?i podatke: BROJ SJ, ?IFRA SO, HOTELID (Opera)
      sa grani?kom to?-zarez, npr.: "Opera: 1234;56;78;
      */
      IF opera_podaci_p LIKE ('Opera: %')
      THEN
         DECLARE
            -- pozicije znaka to?-zarez u polju PARAGON
            pozicija_1_l INTEGER := INSTR (opera_podaci_p, ';', 1, 1);
            pozicija_2_l INTEGER := INSTR (opera_podaci_p, ';', 1, 2);
            oj_sifra_l m_oj.sifra%TYPE;
         --   oj_id_l m_oj.id%TYPE;
         BEGIN
            oj_sifra_l := SUBSTR (opera_podaci_p, pozicija_1_l + 1, pozicija_2_l - 1 - pozicija_1_l);

            SELECT id INTO oj_id_l
              FROM m_oj
             WHERE sifra = oj_sifra_l;
         EXCEPTION
            WHEN NO_DATA_FOUND THEN NULL;
         END;
      END IF;
   END IF;
   
   /* izmjena JF 03.12.2018 dodano polje izn_placanja koje ?se napuniti sumom iznosa iz stavaka u proceduri RNKASE_PRO */
   INSERT INTO t_rnkase
       (godina, kase_id, rbr, datum, kon_id, nac_id,
        vpla_id, popust, vrijeme, jir, zastitni_kod, 
        paragon, ozn_valjanosti, datum_izdavanja, oj_id, izn_placanja, opis, rbr_fisk)
      VALUES
       (godina_p, kase_id_p, LPAD(rbr_p, 6,'0'), datum_blagajne_p, kon_id_l,
        nac_id_l, vpla_id_p, 0, TO_CHAR(SYSDATE,'HH24MI'), jir_p, zki_p, 
        opera_podaci_p, ozn_valjanosti_l, datum_vrijeme_racuna_P, oj_id_l, 0, opis_l, rbr_fisk_p) 
      RETURN id INTO rn_id_l;

 rn_id_p := rn_id_l;
END;
PROCEDURE RNKASE_PRO
 (RN_ID_P IN t_rnkase_pro.rn_id%type
 ,RBR_STAVKE_P IN t_rnkase_pro.rbr_stavke%TYPE
 ,PRO_ID_P IN t_rnkase_pro.pro_id%TYPE
 ,CIJENA_P IN t_rnkase_pro.cijena%TYPE
 ,KOLICINA_P IN t_rnkase_pro.kolicina%TYPE
 ,STOPA_PDV_P IN t_rnkase_pro.pdv%TYPE
 ,STOPA_PPOT_P IN t_rnkase_pro.ppot%TYPE
 ,IZNOS_PDV_P IN t_rnkase_pro.iznos%TYPE
 ,IZNOS_PPOT_P IN t_rnkase_pro.iznos%TYPE
 ,IZNOS_POPUST_P IN t_rnkase_pro.iznos%type
 ,IZNOS_P IN t_rnkase_pro.iznos%type
 ,IZNOS_MARZE_P IN t_rnkase_pro.iznos_marze%TYPE
 ,IZNOS_PDV_MARZE_P IN t_rnkase_pro.iznos_pdv_marze%TYPE
 ,STOPA_PDV_MARZE_P IN t_rnkase_pro.stopa_pdv_marze%TYPE
 )
 IS

CURSOR pro_id_C (pro_id_p NUMBER, datum_p DATE) IS
      SELECT pro.gpor_id,
             pro.gknji_id,
             pro.gtehpro_id,
             vpispp.vpispz_id,
             pro.zad_nab_cijena,
             pro.pros_nab_cijena
        FROM m_proizvodi pro,
             m_gporez gpor,
             mgas_gpor_raz gporraz,
             s_vpisporukap vpispp,
             s_vpisporukaz vpispz
       WHERE pro.id = pro_id_p
         AND pro.gpor_id   = gpor.ID
         AND gpor.ID = gporraz.gpor_id
         AND datum_p BETWEEN gporraz.dat_valjan AND NVL(gporraz.dat_ponisten, SYSDATE)
         AND gporraz.vpispp_id   = vpispp.id
         AND vpispp.vpispz_id   = vpispz.id;

   CURSOR kase_id_c (rn_id_p NUMBER) IS
     SELECT kase_id, datum
       FROM t_rnkase
      WHERE id = rn_id_p;

   /* Na? potro?nje  ne ?aljmo, dogovorno je samo 1  */
    CURSOR mt_id_c (kase_id_l NUMBER, pro_id_p NUMBER) IS
     SELECT asokase.mt_id
       FROM m_aso_kase asokase
      WHERE kase_id = kase_id_l
        AND pro_id  = pro_id_p;

  gpor_id_l         t_rnkase_pro.gpor_id%type;
  gknji_id_l        t_rnkase_pro.gknji_id%TYPE;
  gtehpro_id_l      t_rnkase_pro.gtehpro_id%TYPE;
  mt_id_l           m_mt.id%type;
  vpispz_id_l       t_rnkase_pro.vpispz_id%type;
  pros_nab_cijena_l m_proizvodi.pros_nab_cijena%type;
  zad_nab_cijena_l  m_proizvodi.zad_nab_cijena%type;
  kase_id_l         t_rnkase.kase_id%TYPE;
 datum_l  t_rnkase.datum%TYPE;
BEGIN
  OPEN kase_id_C (rn_id_p);
    FETCH kase_id_c INTO kase_id_l, datum_l;
  CLOSE kase_id_c;

  OPEN pro_id_c (pro_id_p,  datum_l);
    FETCH pro_id_C INTO  gpor_id_l, gknji_id_l, gtehpro_id_l,vpispz_id_l, zad_nab_cijena_l, pros_nab_cijena_l;
  CLOSE pro_id_c;

  IF gpor_id_l IS NULL THEN
    RAISE_APPLICATION_ERROR (-20000, 'U GAS ne postoji proizvod sa ID: ' || pro_id_p);
  END IF;

  OPEN mt_id_C (kase_id_l, pro_id_p);
    FETCH mt_id_C INTO mt_id_l;
  CLOSE mt_id_c;

  IF mt_id_l IS NULL THEN
    RAISE_APPLICATION_ERROR (-20000, 'Proizvod sa ID: ' || pro_id_p || ' nije u GAS asortimanu kase sa ID: ' || kase_id_l);
  END IF;

  INSERT INTO t_rnkase_pro
     (rn_id, rbr_stavke, pro_id, sifgr_id, gpor_id, gknji_id, gtehpro_id, mt_id,
      kolicina, cijena, pdv, ppot, iznos_popust, iznos, iznos_pdv,
      iznos_ppot, zad_nab_cijena, pros_nab_cijena, vpispz_id,
      iznos_marze, iznos_pdv_marze, stopa_pdv_marze)
    VALUES
      (rn_id_p,  rbr_stavke_p, pro_id_p, NULL, gpor_id_l, gknji_id_l, gtehpro_id_l, mt_id_l,
       kolicina_p, cijena_p, stopa_pdv_p, stopa_ppot_p, iznos_popust_p, iznos_p, iznos_pdv_p,
       iznos_ppot_p, zad_nab_cijena_l, pros_nab_cijena_l,  vpispz_id_l,
       iznos_marze_p, iznos_pdv_marze_p, stopa_pdv_marze_p);

  /* izmjena JF 03.12.2018 a?urira izn_placanja iz iznosa stavaka u T_RNKASE za isti rn_id_p  */
  UPDATE t_rnkase t
     SET t.izn_placanja = t.izn_placanja + iznos_p
   WHERE t.id = rn_id_p;
END;
PROCEDURE DELETE_RACUN_STAVKE_BY_KASE
 (GODINA_P IN t_rnkase.godina%TYPE
 ,KASE_ID_P IN mgmp_kase.id%TYPE
 )
 IS
BEGIN
  /* TEST*/
  FOR rn_kase IN  (
   SELECT t.id,
          t.godina,
          t.kase_id,
          t.rbr,
          t.datum,
          t.vpla_id ,
          t.zastitni_kod AS zki,
          t.jir,
          t.paragon AS opera_podaci
     FROM t_rnkase t
    WHERE t.godina = godina_p
      AND t.kase_id  = kase_id_p
  )
  LOOP
    DELETE FROM t_rnkase_pro WHERE rn_id = rn_kase.id;
    DELETE FROM t_rnkase WHERE id = rn_kase.id;
  END LOOP;

END;
PROCEDURE DELETE_RACUN_STAVKE_BY_ID
 (RN_ID t_rnkase.id%TYPE
 )
 IS
BEGIN
  /* TEST*/
  DELETE FROM t_rnkase_pro WHERE rn_id = rn_id;
  DELETE FROM t_rnkase WHERE id = rn_id;
END;
FUNCTION R_SO
 RETURN SYS_REFCURSOR
 IS



 l_rc SYS_REFCURSOR;
naredba_l VARCHAR2 (32000);

/* dinamki SQL jer se TCP adrese za SO itaju sa eme RIVGE iz tablice(mop_proxy) koje nije replikacijska
*/
BEGIN
  naredba_l := 
    'SELECT oj.id, oj.sifra, oj.naziv, oppro.tcpip AS  OPERA_URL_ADRESA, oppro.izmjena_dat AS izmjena_dat
       FROM m_oj oj,
            mzmp_ojr zmpojr,
            mop_proxy@rivge oppro
      WHERE oj.id = zmpojr.id
        AND TRUNC (SYSDATE) BETWEEN zmpojr.dat_valjan AND (NVL (zmpojr.dat_ponisten, TO_DATE (''31.12.9999'', ''DD.MM.RRRR'')) - 1)
        AND zmpojr.metcvor_sifra IS NOT NULL
        AND zmpojr.id = oppro.zmpojr_id
      ORDER BY oj.sifra';
  OPEN l_rc FOR naredba_l;
  RETURN l_rc;  
END;
END;
/
SHOW ERROR

