PROMPT Creating View 'V_PCAM_REG_VOZILA'
CREATE OR REPLACE FORCE VIEW V_PCAM_REG_VOZILA
 (NAME_ID
 ,FIRST_NAME
 ,LAST_NAME
 ,NATIONALITY
 ,CONTACT1
 ,CONTACT2
 ,CONTACT3
 ,REG
 ,CARD_NUMBER
 ,CHECK_IN_DATE
 ,CHECK_OUT_DATE
 ,RESV_STATUS
 ,MODIFIED_DATE)
 AS SELECT id, ime, prezime, zem_sifra_2a, br_telefona, email, so_sifra || ' - ' || NVL (sj_broj, '<not specified>'), reg_vozila, card_number, dat_dolaska, dat_odlaska, opis, izmjena_dat FROM
(
-- IRN 4026; rezervacije
SELECT
  rez2.id,
  rez2.ime,
  rez2.prezime,
  zem.sifra_2a AS zem_sifra_2a,
  rez2.br_telefona,
  rez2.email,
  so.sifra AS so_sifra,
  rez2.sj_broj,
  rez2.reg_vozila,
  NULL AS card_number,
  DECODE (rez2.dat_dolaska, rez2.dat_odlaska, -- IRN 4026
    TO_DATE (TO_CHAR (rez2.dat_dolaska, 'DD.MM.RRRR') || ' ' || zmppar.sat_dolaska_db, 'DD.MM.RRRR HH24:MI'),
    TO_DATE (TO_CHAR (rez2.dat_dolaska, 'DD.MM.RRRR') || ' ' || zmppar.sat_dolaska, 'DD.MM.RRRR HH24:MI')
    )
    AS dat_dolaska,
  DECODE (rez2.dat_dolaska, rez2.dat_odlaska, -- IRN 4026
    TO_DATE (TO_CHAR (rez2.dat_odlaska, 'DD.MM.RRRR') || ' ' || zmppar.sat_odlaska_db, 'DD.MM.RRRR HH24:MI'),
    TO_DATE (TO_CHAR (rez2.dat_odlaska, 'DD.MM.RRRR') || ' ' || zmppar.sat_odlaska, 'DD.MM.RRRR HH24:MI')
    )
    AS dat_odlaska,
  'RESERVED' AS opis,
  rez2.izmjena_dat
FROM
  (
  SELECT -- IRN 3268; rezervacije
    rez.id AS id,
    rez.ime AS ime,
    rez.prezime AS prezime,
    NVL (rez.zem_id, rez.zemd_id) AS zem_id,
    rez.br_telefona AS br_telefona,
    rez.email AS email,
    rez.so_id AS so_id,
    rezsj.sj_broj AS sj_broj,
    rez.reg_vozila AS reg_vozila,
    rez.dat_dolaska AS dat_dolaska,
    rez.dat_odlaska AS dat_odlaska,
    rez.izmjena_dat AS izmjena_dat -- IRN 3772
  FROM
    t_rezervacije rez,
    (
    SELECT rez_id, MIN (sj_broj) AS sj_broj
      FROM (
           SELECT rezvsj.rez_id, MIN (sj.broj) AS sj_broj
             FROM t_rez_vsj rezvsj, m_sj sj
            WHERE rezvsj.sj_id = sj.id
              AND (rezvsj.kol_sj > NVL (rezvsj.kol_sjz, 0) OR rezvsj.br_osoba > NVL (rezvsj.br_osobaz, 0))
            GROUP BY rezvsj.rez_id
           UNION ALL
           SELECT rezvsj.rez_id, MIN (sj.broj)
             FROM trec_rez_sj recrezsj, t_rez_vsj rezvsj, m_sj sj
            WHERE recrezsj.rezvsj_id = rezvsj.id
              AND recrezsj.sj_id = sj.id
              AND recrezsj.br_osoba > NVL (recrezsj.br_osobaz, 0)
              AND (rezvsj.kol_sj > NVL (rezvsj.kol_sjz, 0) OR rezvsj.br_osoba > NVL (rezvsj.br_osobaz, 0))
            GROUP BY rezvsj.rez_id
           )
     WHERE sj_broj IS NOT NULL
     GROUP BY rez_id
    ) rezsj
  WHERE
    rez.oznaka = 'V'
    AND rez.ozn_vstorna IS NULL
    AND (
        SELECT COUNT(1)
          FROM t_rez_vsj
         WHERE rez_id = rez.id
           AND (kol_sj > NVL (kol_sjz, 0) OR br_osoba > NVL (br_osobaz, 0)) -- neiskoritene
        ) > 0
    AND rez.id = rezsj.rez_id(+)
    AND rez.reg_vozila IS NOT NULL
    AND rez.dat_dolaska = TRUNC (SYSDATE) -- IRN 4026
  UNION ALL
  SELECT -- IRN 3268; t_rez_gost
    rezgost.id,
    rezgost.ime,
    rezgost.prezime,
    COALESCE (rezgost.zem_id, rez.zem_id, rez.zemd_id) AS zem_id, -- IRN 4026
    TO_CHAR (NULL), -- br_telefona
    rezgost.email,
    rez.so_id,
    CASE
      WHEN rezgost.sj_id IS NOT NULL THEN
        (SELECT MIN (broj) FROM m_sj WHERE id = rezgost.sj_id)
      WHEN rezvsj.sj_id IS NOT NULL THEN
        (SELECT MIN (broj) FROM m_sj WHERE id = rezvsj.sj_id)
      ELSE
        (
        SELECT MIN (sj.broj)
          FROM trec_rez_sj recrezsj, m_sj sj
         WHERE recrezsj.rezvsj_id = rezvsj.id
           AND recrezsj.sj_id = sj.id
        )
    END, -- sj_broj
    rezgost.reg_vozila,
    rez.dat_dolaska AS dat_dolaska,
    rez.dat_odlaska AS dat_odlaska,
    GREATEST (rez.izmjena_dat, rezgost.izmjena_dat) AS izmjena_dat -- IRN 3772
  FROM
    t_rez_gost rezgost,
    t_rez_vsj rezvsj,
    t_rezervacije rez
  WHERE
    rezgost.rezvsj_id = rezvsj.id
    AND (rezvsj.kol_sj > NVL (rezvsj.kol_sjz, 0) OR rezvsj.br_osoba > NVL (rezvsj.br_osobaz, 0)) -- rezervacija nije iskoritena
    AND (SELECT COUNT(1) FROM t_gosti WHERE rezgost_id = rezgost.id) = 0 -- osoba nije prijavljena
    AND rezvsj.rez_id = rez.id
    AND rez.oznaka = 'V'
    AND rez.ozn_vstorna IS NULL
    AND rezgost.reg_vozila IS NOT NULL
    AND rezgost.reg_vozila <> NVL (rez.reg_vozila, '')
    AND rez.dat_dolaska = TRUNC (SYSDATE) -- IRN 4026
  )
  rez2,
  s_zemlje zem,
  m_so so,
  (
  SELECT
    TO_CHAR (TO_DATE (sat_dolaska, 'HH24:MI'), 'HH24:MI') AS sat_dolaska,
    TO_CHAR (TO_DATE (sat_dolaska_db, 'HH24:MI'), 'HH24:MI') AS sat_dolaska_db,
    TO_CHAR (TO_DATE (sat_odlaska, 'HH24:MI'), 'HH24:MI') AS sat_odlaska,
    TO_CHAR (TO_DATE (sat_odlaska_db, 'HH24:MI'), 'HH24:MI') AS sat_odlaska_db
  FROM
    (
    SELECT
      DECODE (sat_dolaska2, 'nebitno', DECODE (sat_dolaska, 'nebitno', '0', sat_dolaska), sat_dolaska2) AS sat_dolaska,
      DECODE (sat_dolaska2_db, 'nebitno', DECODE (sat_dolaska_db, 'nebitno', '0', sat_dolaska_db), sat_dolaska2_db) AS sat_dolaska_db,
      DECODE (sat_odlaska2, 'nebitno', DECODE (sat_odlaska, 'nebitno', '0', sat_odlaska), sat_odlaska2) AS sat_odlaska,
      DECODE (sat_odlaska2_db, 'nebitno', DECODE (sat_odlaska_db, 'nebitno', '0', sat_odlaska_db), sat_odlaska2_db) AS sat_odlaska_db
    FROM
      (
      SELECT
        pra_rec_zaj.vrijednost_parametra ('1184') sat_dolaska,
        pra_rec_zaj.vrijednost_parametra ('1186') sat_dolaska_db,
        pra_rec_zaj.vrijednost_parametra ('1185') sat_odlaska,
        pra_rec_zaj.vrijednost_parametra ('1187') sat_odlaska_db,
        -- IRN 4026; PCAM parametri
        pra_rec_zaj.vrijednost_parametra ('1240') sat_dolaska2,
        pra_rec_zaj.vrijednost_parametra ('1242') sat_dolaska2_db,
        pra_rec_zaj.vrijednost_parametra ('1241') sat_odlaska2,
        pra_rec_zaj.vrijednost_parametra ('1243') sat_odlaska2_db
      FROM dual
      )
    )
  ) zmppar
WHERE
  rez2.zem_id = zem.id(+)
  AND rez2.so_id = so.id
UNION ALL
SELECT -- gosti
  gost.id,
  gost.ime,
  gost.prezime,
  zem.sifra_2a,
  NVL (kgost.br_telefona, rez.br_telefona),
  NVL (kgost.email, rez.email),
  so.sifra,
  sj.broj,
  COALESCE (kgost.reg_vozila, kckar.reg_vozila, rezgost.reg_vozila, rez.reg_vozila), -- IRN 4026
  NVL (kckar.broj, pkakar.broj), -- card_number
  CASE -- IRN 4026
    WHEN (
         -- IRN 3772; gosti koji su obavili self-check-in ranije od sata iz parametra 1184/1240
         kgost.unos_korisnik = 'SELF-CHECK-IN'
         AND TO_CHAR (kgost.sat_dolaska, 'HH24:MI') < DECODE (gost.dat_dolaska, gost.dat_odlaska, zmppar.sat_dolaska_db, zmppar.sat_dolaska)
         )
         OR kgost.sat_dolaska IS NULL
    THEN
      TO_DATE (TO_CHAR (gost.dat_dolaska, 'DD.MM.RRRR') || ' ' ||
        DECODE (gost.dat_dolaska, gost.dat_odlaska, zmppar.sat_dolaska_db, zmppar.sat_dolaska), 'DD.MM.RRRR HH24:MI')
    ELSE
      TO_DATE (TO_CHAR (gost.dat_dolaska, 'DD.MM.RRRR') || ' ' ||
        DECODE (zmppar.sat_dolaska2, 'nebitno', TO_CHAR (kgost.sat_dolaska, 'HH24:MI'),
          DECODE (gost.dat_dolaska, gost.dat_odlaska, zmppar.sat_dolaska_db, zmppar.sat_dolaska)), 'DD.MM.RRRR HH24:MI')
  END AS dat_dolaska,
  CASE -- IRN 4026
    WHEN zmppar.br_minuta <> 'nebitno'
      AND gost.ozn_prisutnosti = 'O'
    THEN
      gost.sat_odjave + zmppar.br_minuta / 24 / 60
    WHEN kgost.sat_odlaska IS NULL THEN
      TO_DATE (TO_CHAR (gost.dat_odlaska, 'DD.MM.RRRR') || ' ' ||
        DECODE (gost.dat_dolaska, gost.dat_odlaska, zmppar.sat_odlaska_db, zmppar.sat_odlaska), 'DD.MM.RRRR HH24:MI')
    ELSE
      TO_DATE (TO_CHAR (gost.dat_odlaska, 'DD.MM.RRRR') || ' ' ||
        DECODE (zmppar.sat_odlaska2, 'nebitno', TO_CHAR (kgost.sat_odlaska, 'HH24:MI'),
          DECODE (gost.dat_dolaska, gost.dat_odlaska, zmppar.sat_odlaska_db, zmppar.sat_odlaska)), 'DD.MM.RRRR HH24:MI')
  END AS dat_odlaska,
  DECODE (gost.ozn_prisutnosti, 'P', 'CHECKED IN', 'CHECKED OUT'),
  GREATEST (
    gost.izmjena_dat,
    NVL (kgost.izmjena_dat, gost.izmjena_dat),
    NVL (kckar.izmjena_dat, gost.izmjena_dat),
    NVL (pkakar.izmjena_dat, gost.izmjena_dat),
    NVL (rez.izmjena_dat, gost.izmjena_dat),
    NVL (rezgost.izmjena_dat, gost.izmjena_dat)) -- IRN 3772; IRN 4026; dodan NVL
FROM
  t_gosti gost,
  t_kgostiju kgost,
  (SELECT gost_id, broj, reg_vozila, izmjena_dat FROM tkc_kartice WHERE oznaka = 'V' AND gost_id IS NOT NULL AND TRUNC (SYSDATE) BETWEEN TRUNC (dat_poc) AND TRUNC (dat_zav)) kckar,
  (SELECT gost_id, broj, izmjena_dat FROM tpka_kartice WHERE oznaka = 'V' AND gost_id IS NOT NULL AND TRUNC (SYSDATE) BETWEEN TRUNC (NVL (dat_poc, SYSDATE)) AND TRUNC (NVL (dat_zav, SYSDATE))) pkakar,
  s_zemlje zem,
  m_sj sj,
  m_so so,
  t_rez_gost rezgost,
  t_rez_vsj rezvsj,
  t_rezervacije rez,
  (
  SELECT
    TO_CHAR (TO_DATE (sat_dolaska, 'HH24:MI'), 'HH24:MI') AS sat_dolaska,
    TO_CHAR (TO_DATE (sat_dolaska_db, 'HH24:MI'), 'HH24:MI') AS sat_dolaska_db,
    TO_CHAR (TO_DATE (sat_odlaska, 'HH24:MI'), 'HH24:MI') AS sat_odlaska,
    TO_CHAR (TO_DATE (sat_odlaska_db, 'HH24:MI'), 'HH24:MI') AS sat_odlaska_db,
    -- IRN 4026; PCAM parametri
    sat_dolaska2,
    sat_odlaska2,
    pra_rec_zaj.vrijednost_parametra ('1244') AS br_minuta
  FROM
    (
    SELECT
      DECODE (sat_dolaska2, 'nebitno', DECODE (sat_dolaska, 'nebitno', '0', sat_dolaska), sat_dolaska2) AS sat_dolaska,
      DECODE (sat_dolaska2_db, 'nebitno', DECODE (sat_dolaska_db, 'nebitno', '0', sat_dolaska_db), sat_dolaska2_db) AS sat_dolaska_db,
      DECODE (sat_odlaska2, 'nebitno', DECODE (sat_odlaska, 'nebitno', '0', sat_odlaska), sat_odlaska2) AS sat_odlaska,
      DECODE (sat_odlaska2_db, 'nebitno', DECODE (sat_odlaska_db, 'nebitno', '0', sat_odlaska_db), sat_odlaska2_db) AS sat_odlaska_db,
      sat_dolaska2,
      sat_odlaska2
    FROM
      (
      SELECT
        pra_rec_zaj.vrijednost_parametra ('1184') sat_dolaska,
        pra_rec_zaj.vrijednost_parametra ('1186') sat_dolaska_db,
        pra_rec_zaj.vrijednost_parametra ('1185') sat_odlaska,
        pra_rec_zaj.vrijednost_parametra ('1187') sat_odlaska_db,
        -- IRN 4026; PCAM parametri
        pra_rec_zaj.vrijednost_parametra ('1240') sat_dolaska2,
        pra_rec_zaj.vrijednost_parametra ('1242') sat_dolaska2_db,
        pra_rec_zaj.vrijednost_parametra ('1241') sat_odlaska2,
        pra_rec_zaj.vrijednost_parametra ('1243') sat_odlaska2_db
      FROM dual
      )
    )
  ) zmppar
WHERE
  kgost.gost_id(+) = gost.id
  AND kgost.oznaka(+) = 'V'
  AND kckar.gost_id(+) = gost.id
  AND pkakar.gost_id(+) = gost.id
  AND NVL (gost.ozn_brisano, 0) = 0
  AND gost.zem_id = zem.id
  AND gost.sj_id = sj.id
  AND sj.so_id = so.id
  AND COALESCE (kgost.reg_vozila, kckar.reg_vozila, rezgost.reg_vozila, rez.reg_vozila) IS NOT NULL
  AND gost.rezgost_id = rezgost.id(+)
  AND gost.rezvsj_id = rezvsj.id(+)
  AND rezvsj.rez_id = rez.id(+)
  AND TRUNC (SYSDATE) BETWEEN gost.dat_dolaska AND gost.dat_odlaska
UNION ALL
SELECT  -- Key Card
  kckar.id,
  NVL (kckar.ime, NVL (pkaadr.naz_poduzeca, pkaadr.ime)),
  NVL (kckar.prezime, NVL (age.naziv, NVL (pkaadr.naz_poduzeca, pkaadr.prezime))),
  (SELECT sifra_2a FROM s_zemlje WHERE id = NVL (age.zem_id, pkaadr.zem_id)),
  NVL (age.br_telefona, pkaadr.br_telefona),
  NVL (age.email, pkaadr.email),
  DECODE (so.sifra, NULL, oj.sifra || '*', so.sifra),
  DECODE (sj.broj, NULL, tcopro.sifra || '*', sj.broj),
  kckar.reg_vozila,
  kckar.broj,
  kckar.dat_poc,
  kckar.dat_zav,
  DECODE (kckar.ozn_prisutnosti, 'P', 'KEY CARD IN', 'KEY CARD OUT'),
  kckar.izmjena_dat -- IRN 3772
FROM
  tkc_kartice kckar,
  mkc_jedinice kcjed,
  m_sj sj,
  m_so so,
  mtco_prostori tcopro,
  m_oj oj,
  m_agencije age,
  mpka_adrese pkaadr
WHERE
  kckar.kcjed_id = kcjed.id
  AND kcjed.sj_id = sj.id(+)
  AND sj.so_id = so.id(+)
  AND kcjed.tcopro_id = tcopro.id(+)
  AND tcopro.oj_id = oj.id(+)
  AND kckar.age_id = age.id(+)
  AND kckar.pkaadr_id = pkaadr.id(+)
  AND kckar.oznaka = 'V'
  AND kckar.reg_vozila IS NOT NULL
  AND kckar.gost_id IS NULL
  AND TRUNC (SYSDATE) BETWEEN TRUNC (kckar.dat_poc) AND TRUNC (kckar.dat_zav)
UNION ALL
SELECT  -- zakup
  zak.id,
  zakkor.ime,
  zakkor.prezime,
  zem.sifra_2a,
  NVL (recagost.br_telefona, NVL (pkaadr.br_telefona, age.br_telefona)),
  NVL (recagost.email, NVL (pkaadr.email, age.email)),
  so.sifra,
  sj.broj,
  zakkor.reg_vozila,
  TO_CHAR (NULL), -- card_number
  zak.dat_poc,
  zak.dat_zav,
  'RENTED',
  GREATEST (zak.izmjena_dat, zakkor.izmjena_dat) -- IRN 3772
FROM
  t_zak_korisnici zakkor,
  t_zak_sj zaksj,
  t_zakup zak,
  mpka_adrese pkaadr,
  m_agencije age,
  s_zemlje zem,
  m_sj sj,
  m_so so,
  trec_agostiju recagost
WHERE
  zakkor.zaksj_id = zaksj.id
  AND zaksj.zak_id = zak.id
  AND zak.oznaka = 'V'
  AND zak.pkaadr_id = pkaadr.id(+)
  AND zak.age_id = age.id(+)
  AND zakkor.recagost_id = recagost.id(+)
  AND NVL (recagost.zem_id, NVL (pkaadr.zem_id, age.zem_id)) = zem.id
  AND zaksj.sj_id = sj.id
  AND sj.so_id = so.id
  AND zakkor.reg_vozila IS NOT NULL
  AND TRUNC (SYSDATE) BETWEEN zak.dat_poc AND zak.dat_zav
)
WITH READ ONLY
/
