PROMPT Creating View 'V_IREC_ZURDW_SZURU'
CREATE OR REPLACE FORCE VIEW V_IREC_ZURDW_SZURU
 (DATUM
 ,SO_ID
 ,MS_ID
 ,AGE_ID
 ,PONSO_ID
 ,AGEP_ID
 ,ZEM_ID
 ,SJ_ID
 ,RECGDGOST_ID
 ,RECVPRO_ID
 ,USL_ID
 ,USL_ID1
 ,OZN_USL1
 ,SAS_ID
 ,SZUR_ID
 ,RAC_ID
 ,RECNREZ_ID
 ,IZNN_PRIHOD_BODB
 ,IZNN_PRIHODZ_BODB
 ,IZNN_ODBITAKZ
 ,IZNN_PDV
 ,IZNB_PRIHOD_BPDV_BODB
 ,IZNB_ODBITAK_BPDV
 ,IZNB_PRIHODZ_BPDV
 ,IZNB_PDV_BODB
 ,IZNB_PDV_U_ODBITKU
 ,IZN_PDVZ
 ,IZN_PRIHODA_KNJ
 ,IZN_PRIHODA_IZV)
 AS SELECT datum,
  so_id,
  ms_id,
  age_id,
  ponso_id,
  agep_id,
  zem_id,
  sj_id,
  recgdgost_id,
  recvpro_id,
  usl_id,
  usl_id1,
  ozn_usl1,
  sas_id,
  szur_id,
  rac_id,
  recnrez_id, -- IRN 4011
  iznn_prihod_bodb,
  iznn_prihodz_bodb,
  iznn_odbitakz,
  iznn_pdv,
  iznb_prihod_bpdv_bodb,
  iznb_odbitak_bpdv,
  iznb_prihodz_bpdv,
  iznb_pdv_bodb,
  iznb_pdv_u_odbitku,
  izn_pdvz,
  izn_prihoda_knj,
  izn_prihoda_izv
FROM
  (
  SELECT
    datum,
    so_id,
    ms_id,
    age_id,
    ponso_id,
    agep_id,
    zem_id,
    sj_id,
    recgdgost_id,
    recvpro_id,
    usl_id,
    usl_id1,
    ozn_usl1,
    sas_id,
    szur_id,
    rac_id,
    recnrez_id, -- IRN 4011
    SUM (iznn_prihod_bodb) iznn_prihod_bodb,
    SUM (iznn_prihodz_bodb) iznn_prihodz_bodb,
    SUM (iznn_odbitakz) iznn_odbitakz, -- SUM (iznn_odbitak) iznn_odbitak,
    SUM (iznn_pdv) iznn_pdv,
    SUM (iznb_prihod_bpdv_bodb) iznb_prihod_bpdv_bodb,
    SUM (iznb_odbitak_bpdv) iznb_odbitak_bpdv,
    SUM (iznb_prihodz_bpdv) iznb_prihodz_bpdv,
    SUM (iznb_pdv_bodb) iznb_pdv_bodb,
    SUM (iznb_pdv_u_odbitku) iznb_pdv_u_odbitku,
    SUM (izn_pdvz) izn_pdvz,
    SUM (izn_prihoda_knj) izn_prihoda_knj,
    SUM (izn_prihoda_izv) izn_prihoda_izv
  FROM
    (
    -- prihod iz t_troskovi, svi trokovi za gosta i tro za age/adr koji nisu vezani na zakup
    SELECT
      zur.datum datum,
      zur.so_id so_id,
      tro.ms_id ms_id, /* uzima se iz tro jer se tako rauna urnal ali se moe desiti da su noenja (gost.ms) pod jednim a prihod (tro.ms) drugim ms */
      NVL (gost.age_id, tro.age_id) age_id,
      tro.ponso_id ponso_id,
      tro.agep_id agep_id,
      NVL (gost.zem_id, NVL (age.zem_id, pkaadr.zem_id)) zem_id,
      NVL (pra_rec_s2.sj_id_recgostbor (gost.id, zur.datum), gost.sj_id) sj_id,
      pra_rec_s2.gdgost_id (
        pra_rec_s2.dat_rodjenja (gost.id),
        gost.dat_dolaska,
        NULL,
        zur.datum) -- IRN 4023
        AS recgdgost_id,
      gost.recvpro_id recvpro_id,
      tro.usl_id usl_id,
      tro.usl_id1 usl_id1,
      zurusltro.ozn_usl1,
      zurusltro.sas_id,
      zurusl.szur_id szur_id,
      rac.id rac_id,
      rez.recnrez_id, -- IRN 4011
      pra_rec_zur.zurn_prihod_bodb (
        zurusltro.izn_prihoda_nz,
        zurusltro.izn_pdv_nz,
        zurusltro.izn_prihoda_z,
        zurusltro.izn_pdv_z,
        zurusltro.izn_prihoda_uz,
        zurusltro.izn_pdv_uz,
        zurusltro.izn_odbitka_nz,
        zurusltro.izn_odbitka_pdv_nz,
        zurusltro.izn_odbitka_z,
        zurusltro.izn_odbitka_pdv_z,
        zurusltro.izn_odbitka_uz,
        zurusltro.izn_odbitka_pdv_uz)
        AS iznn_prihod_bodb,
      pra_rec_zur.zurn_prihodz_bodb (
        zurusltro.izn_prihoda_nz,
        zurusltro.izn_pdv_nz,
        zurusltro.izn_prihoda_z,
        zurusltro.izn_pdv_z,
        zurusltro.izn_prihoda_uz,
        zurusltro.izn_pdv_uz,
        zurusltro.izn_odbitka_nz,
        zurusltro.izn_odbitka_pdv_nz,
        zurusltro.izn_odbitka_z,
        zurusltro.izn_odbitka_pdv_z,
        zurusltro.izn_odbitka_uz,
        zurusltro.izn_odbitka_pdv_uz)
        AS iznn_prihodz_bodb,
      pra_rec_zur.zurn_odbitakz (
        zurusltro.izn_prihoda_nz,
        zurusltro.izn_pdv_nz,
        zurusltro.izn_prihoda_z,
        zurusltro.izn_pdv_z,
        zurusltro.izn_prihoda_uz,
        zurusltro.izn_pdv_uz,
        zurusltro.izn_odbitka_nz,
        zurusltro.izn_odbitka_pdv_nz,
        zurusltro.izn_odbitka_z,
        zurusltro.izn_odbitka_pdv_z,
        zurusltro.izn_odbitka_uz,
        zurusltro.izn_odbitka_pdv_uz)
        AS iznn_odbitakz,
      pra_rec_zur.zurn_pdv (
        zurusltro.izn_prihoda_nz,
        zurusltro.izn_pdv_nz,
        zurusltro.izn_prihoda_z,
        zurusltro.izn_pdv_z,
        zurusltro.izn_prihoda_uz,
        zurusltro.izn_pdv_uz,
        zurusltro.izn_odbitka_nz,
        zurusltro.izn_odbitka_pdv_nz,
        zurusltro.izn_odbitka_z,
        zurusltro.izn_odbitka_pdv_z,
        zurusltro.izn_odbitka_uz,
        zurusltro.izn_odbitka_pdv_uz)
        AS iznn_pdv,
      pra_rec_zur.zurb_prihod_bpdv_bodb (
        zurusltro.izn_prihoda_nz,
        zurusltro.izn_pdv_nz,
        zurusltro.izn_prihoda_z,
        zurusltro.izn_pdv_z,
        zurusltro.izn_prihoda_uz,
        zurusltro.izn_pdv_uz,
        zurusltro.izn_odbitka_nz,
        zurusltro.izn_odbitka_pdv_nz,
        zurusltro.izn_odbitka_z,
        zurusltro.izn_odbitka_pdv_z,
        zurusltro.izn_odbitka_uz,
        zurusltro.izn_odbitka_pdv_uz)
        AS iznb_prihod_bpdv_bodb,
      pra_rec_zur.zurb_odbitak_bpdv (
        zurusltro.izn_prihoda_nz,
        zurusltro.izn_pdv_nz,
        zurusltro.izn_prihoda_z,
        zurusltro.izn_pdv_z,
        zurusltro.izn_prihoda_uz,
        zurusltro.izn_pdv_uz,
        zurusltro.izn_odbitka_nz,
        zurusltro.izn_odbitka_pdv_nz,
        zurusltro.izn_odbitka_z,
        zurusltro.izn_odbitka_pdv_z,
        zurusltro.izn_odbitka_uz,
        zurusltro.izn_odbitka_pdv_uz)
        AS iznb_odbitak_bpdv,
      pra_rec_zur.zurb_prihodz_bpdv (
        zurusltro.izn_prihoda_nz,
        zurusltro.izn_pdv_nz,
        zurusltro.izn_prihoda_z,
        zurusltro.izn_pdv_z,
        zurusltro.izn_prihoda_uz,
        zurusltro.izn_pdv_uz,
        zurusltro.izn_odbitka_nz,
        zurusltro.izn_odbitka_pdv_nz,
        zurusltro.izn_odbitka_z,
        zurusltro.izn_odbitka_pdv_z,
        zurusltro.izn_odbitka_uz,
        zurusltro.izn_odbitka_pdv_uz)
        AS iznb_prihodz_bpdv,
      pra_rec_zur.zurb_pdv_bodb (
        zurusltro.izn_prihoda_nz,
        zurusltro.izn_pdv_nz,
        zurusltro.izn_prihoda_z,
        zurusltro.izn_pdv_z,
        zurusltro.izn_prihoda_uz,
        zurusltro.izn_pdv_uz,
        zurusltro.izn_odbitka_nz,
        zurusltro.izn_odbitka_pdv_nz,
        zurusltro.izn_odbitka_z,
        zurusltro.izn_odbitka_pdv_z,
        zurusltro.izn_odbitka_uz,
        zurusltro.izn_odbitka_pdv_uz)
        AS iznb_pdv_bodb,
      pra_rec_zur.zurb_pdv_u_odbitku (
        zurusltro.izn_prihoda_nz,
        zurusltro.izn_pdv_nz,
        zurusltro.izn_prihoda_z,
        zurusltro.izn_pdv_z,
        zurusltro.izn_prihoda_uz,
        zurusltro.izn_pdv_uz,
        zurusltro.izn_odbitka_nz,
        zurusltro.izn_odbitka_pdv_nz,
        zurusltro.izn_odbitka_z,
        zurusltro.izn_odbitka_pdv_z,
        zurusltro.izn_odbitka_uz,
        zurusltro.izn_odbitka_pdv_uz)
        AS iznb_pdv_u_odbitku,
      pra_rec_zur.zur_pdvz (
        zurusltro.izn_prihoda_nz,
        zurusltro.izn_pdv_nz,
        zurusltro.izn_prihoda_z,
        zurusltro.izn_pdv_z,
        zurusltro.izn_prihoda_uz,
        zurusltro.izn_pdv_uz,
        zurusltro.izn_odbitka_nz,
        zurusltro.izn_odbitka_pdv_nz,
        zurusltro.izn_odbitka_z,
        zurusltro.izn_odbitka_pdv_z,
        zurusltro.izn_odbitka_uz,
        zurusltro.izn_odbitka_pdv_uz)
        AS izn_pdvz,
      pra_rec_zur.izn_prihoda_knj (
        zurusltro.izn_prihoda_nz,
        zurusltro.izn_pdv_nz,
        zurusltro.izn_prihoda_z,
        zurusltro.izn_pdv_z,
        zurusltro.izn_prihoda_uz,
        zurusltro.izn_pdv_uz,
        zurusltro.izn_odbitka_nz,
        zurusltro.izn_odbitka_pdv_nz,
        zurusltro.izn_odbitka_z,
        zurusltro.izn_odbitka_pdv_z,
        zurusltro.izn_odbitka_uz,
        zurusltro.izn_odbitka_pdv_uz)
        AS izn_prihoda_knj,
      pra_rec_zur.izn_prihoda_izv (
        zurusltro.izn_prihoda_nz,
        zurusltro.izn_pdv_nz,
        zurusltro.izn_prihoda_z,
        zurusltro.izn_pdv_z,
        zurusltro.izn_prihoda_uz,
        zurusltro.izn_pdv_uz,
        zurusltro.izn_odbitka_nz,
        zurusltro.izn_odbitka_pdv_nz,
        zurusltro.izn_odbitka_z,
        zurusltro.izn_odbitka_pdv_z,
        zurusltro.izn_odbitka_uz,
        zurusltro.izn_odbitka_pdv_uz)
        AS izn_prihoda_izv
    FROM
      (
      SELECT id, so_id, zur.datum
        FROM i_zurnali zur, v_zmp_kalendar kal
       WHERE zur.datum = kal.datum
      ) zur,
      i_zur_usl zurusl,
      irec_zurusl_tro zurusltro,
      t_troskovi tro,
      s_szurnala szur,
      t_gosti gost, t_rez_vsj rezvsj, t_rezervacije rez, -- IRN 4011
      m_agencije age,
      mpka_adrese pkaadr,
      t_racuni rac
    WHERE
      zurusl.zur_id = zur.id
      AND zurusltro.zurusl_id = zurusl.id
      AND szur.id = zurusl.szur_id
      AND tro.id1 = zurusltro.id1_tro
      AND gost.id(+) = tro.gost_id
      AND gost.rezvsj_id = rezvsj.id (+)
      AND rezvsj.rez_id = rez.id (+)
      AND age.id(+) = tro.age_id
      AND pkaadr.id(+) = tro.pkaadr_id
      AND rac.id(+) = tro.rac_id -- ne gleda se da li je raun u pripremi
      AND (NVL (tro.zak_id, rac.zak_id) IS NULL OR tro.gost_id IS NOT NULL) -- svi trokovi za gosta i tro za age/adr koji nisu vezani na zakup
    UNION ALL
    -- prihod iz t_troskovi i to samo trokovi koji su naplaeni po zakupu i korisnik je adresa ili agencija
    -- ako ima u zakupu vie sj kreirat e se toliko redaka koliko je SJ pa prihod treba podijeliti sa brojem sj
    SELECT
      zur.datum datum,
      zur.so_id so_id,
      tro.ms_id ms_id, /* uzima se iz tro jer se tako rauna urnal ali se moe desiti da su noenja (gost.ms) pod jednim a prihod (tro.ms) drugim ms */
      tro.age_id age_id,
      tro.ponso_id ponso_id,
      tro.agep_id agep_id,
      NVL (age.zem_id, pkaadr.zem_id) zem_id,
      zaksj.sj_id sj_id,
      TO_NUMBER (NULL) recgdgost_id,
      TO_NUMBER (NULL) recvpro_id,
      tro.usl_id usl_id,
      tro.usl_id1 usl_id1,
      zurusltro.ozn_usl1,
      zurusltro.sas_id,
      zurusl.szur_id szur_id,
      rac.id rac_id,
      TO_NUMBER (NULL) recnrez_id, -- IRN 4011
      pra_rec_zur.zurn_prihod_bodb (
        zurusltro.izn_prihoda_nz,
        zurusltro.izn_pdv_nz,
        zurusltro.izn_prihoda_z,
        zurusltro.izn_pdv_z,
        zurusltro.izn_prihoda_uz,
        zurusltro.izn_pdv_uz,
        zurusltro.izn_odbitka_nz,
        zurusltro.izn_odbitka_pdv_nz,
        zurusltro.izn_odbitka_z,
        zurusltro.izn_odbitka_pdv_z,
        zurusltro.izn_odbitka_uz,
        zurusltro.izn_odbitka_pdv_uz)
        / zak.br_sjedinica
        AS iznn_prihod_bodb,
      pra_rec_zur.zurn_prihodz_bodb (
        zurusltro.izn_prihoda_nz,
        zurusltro.izn_pdv_nz,
        zurusltro.izn_prihoda_z,
        zurusltro.izn_pdv_z,
        zurusltro.izn_prihoda_uz,
        zurusltro.izn_pdv_uz,
        zurusltro.izn_odbitka_nz,
        zurusltro.izn_odbitka_pdv_nz,
        zurusltro.izn_odbitka_z,
        zurusltro.izn_odbitka_pdv_z,
        zurusltro.izn_odbitka_uz,
        zurusltro.izn_odbitka_pdv_uz)
        / zak.br_sjedinica
        AS iznn_prihodz_bodb,
      pra_rec_zur.zurn_odbitakz (
        zurusltro.izn_prihoda_nz,
        zurusltro.izn_pdv_nz,
        zurusltro.izn_prihoda_z,
        zurusltro.izn_pdv_z,
        zurusltro.izn_prihoda_uz,
        zurusltro.izn_pdv_uz,
        zurusltro.izn_odbitka_nz,
        zurusltro.izn_odbitka_pdv_nz,
        zurusltro.izn_odbitka_z,
        zurusltro.izn_odbitka_pdv_z,
        zurusltro.izn_odbitka_uz,
        zurusltro.izn_odbitka_pdv_uz)
        / zak.br_sjedinica
        AS iznn_odbitakz,
      pra_rec_zur.zurn_pdv (
        zurusltro.izn_prihoda_nz,
        zurusltro.izn_pdv_nz,
        zurusltro.izn_prihoda_z,
        zurusltro.izn_pdv_z,
        zurusltro.izn_prihoda_uz,
        zurusltro.izn_pdv_uz,
        zurusltro.izn_odbitka_nz,
        zurusltro.izn_odbitka_pdv_nz,
        zurusltro.izn_odbitka_z,
        zurusltro.izn_odbitka_pdv_z,
        zurusltro.izn_odbitka_uz,
        zurusltro.izn_odbitka_pdv_uz)
        / zak.br_sjedinica
        AS iznn_pdv,
      pra_rec_zur.zurb_prihod_bpdv_bodb (
        zurusltro.izn_prihoda_nz,
        zurusltro.izn_pdv_nz,
        zurusltro.izn_prihoda_z,
        zurusltro.izn_pdv_z,
        zurusltro.izn_prihoda_uz,
        zurusltro.izn_pdv_uz,
        zurusltro.izn_odbitka_nz,
        zurusltro.izn_odbitka_pdv_nz,
        zurusltro.izn_odbitka_z,
        zurusltro.izn_odbitka_pdv_z,
        zurusltro.izn_odbitka_uz,
        zurusltro.izn_odbitka_pdv_uz)
        / zak.br_sjedinica
        AS iznb_prihod_bpdv_bodb,
      pra_rec_zur.zurb_odbitak_bpdv (
        zurusltro.izn_prihoda_nz,
        zurusltro.izn_pdv_nz,
        zurusltro.izn_prihoda_z,
        zurusltro.izn_pdv_z,
        zurusltro.izn_prihoda_uz,
        zurusltro.izn_pdv_uz,
        zurusltro.izn_odbitka_nz,
        zurusltro.izn_odbitka_pdv_nz,
        zurusltro.izn_odbitka_z,
        zurusltro.izn_odbitka_pdv_z,
        zurusltro.izn_odbitka_uz,
        zurusltro.izn_odbitka_pdv_uz)
        / zak.br_sjedinica
        AS iznb_odbitak_bpdv,
      pra_rec_zur.zurb_prihodz_bpdv (
        zurusltro.izn_prihoda_nz,
        zurusltro.izn_pdv_nz,
        zurusltro.izn_prihoda_z,
        zurusltro.izn_pdv_z,
        zurusltro.izn_prihoda_uz,
        zurusltro.izn_pdv_uz,
        zurusltro.izn_odbitka_nz,
        zurusltro.izn_odbitka_pdv_nz,
        zurusltro.izn_odbitka_z,
        zurusltro.izn_odbitka_pdv_z,
        zurusltro.izn_odbitka_uz,
        zurusltro.izn_odbitka_pdv_uz)
        / zak.br_sjedinica
        AS iznb_prihodz_bpdv,
      pra_rec_zur.zurb_pdv_bodb (
        zurusltro.izn_prihoda_nz,
        zurusltro.izn_pdv_nz,
        zurusltro.izn_prihoda_z,
        zurusltro.izn_pdv_z,
        zurusltro.izn_prihoda_uz,
        zurusltro.izn_pdv_uz,
        zurusltro.izn_odbitka_nz,
        zurusltro.izn_odbitka_pdv_nz,
        zurusltro.izn_odbitka_z,
        zurusltro.izn_odbitka_pdv_z,
        zurusltro.izn_odbitka_uz,
        zurusltro.izn_odbitka_pdv_uz)
        / zak.br_sjedinica
        AS iznb_pdv_bodb,
      pra_rec_zur.zurb_pdv_u_odbitku (
        zurusltro.izn_prihoda_nz,
        zurusltro.izn_pdv_nz,
        zurusltro.izn_prihoda_z,
        zurusltro.izn_pdv_z,
        zurusltro.izn_prihoda_uz,
        zurusltro.izn_pdv_uz,
        zurusltro.izn_odbitka_nz,
        zurusltro.izn_odbitka_pdv_nz,
        zurusltro.izn_odbitka_z,
        zurusltro.izn_odbitka_pdv_z,
        zurusltro.izn_odbitka_uz,
        zurusltro.izn_odbitka_pdv_uz)
        / zak.br_sjedinica
        AS iznb_pdv_u_odbitku,
      pra_rec_zur.zur_pdvz (
        zurusltro.izn_prihoda_nz,
        zurusltro.izn_pdv_nz,
        zurusltro.izn_prihoda_z,
        zurusltro.izn_pdv_z,
        zurusltro.izn_prihoda_uz,
        zurusltro.izn_pdv_uz,
        zurusltro.izn_odbitka_nz,
        zurusltro.izn_odbitka_pdv_nz,
        zurusltro.izn_odbitka_z,
        zurusltro.izn_odbitka_pdv_z,
        zurusltro.izn_odbitka_uz,
        zurusltro.izn_odbitka_pdv_uz)
        / zak.br_sjedinica
        AS izn_pdvz,
      pra_rec_zur.izn_prihoda_knj (
        zurusltro.izn_prihoda_nz,
        zurusltro.izn_pdv_nz,
        zurusltro.izn_prihoda_z,
        zurusltro.izn_pdv_z,
        zurusltro.izn_prihoda_uz,
        zurusltro.izn_pdv_uz,
        zurusltro.izn_odbitka_nz,
        zurusltro.izn_odbitka_pdv_nz,
        zurusltro.izn_odbitka_z,
        zurusltro.izn_odbitka_pdv_z,
        zurusltro.izn_odbitka_uz,
        zurusltro.izn_odbitka_pdv_uz)
        / zak.br_sjedinica
        AS izn_prihoda_knj,
      pra_rec_zur.izn_prihoda_izv (
        zurusltro.izn_prihoda_nz,
        zurusltro.izn_pdv_nz,
        zurusltro.izn_prihoda_z,
        zurusltro.izn_pdv_z,
        zurusltro.izn_prihoda_uz,
        zurusltro.izn_pdv_uz,
        zurusltro.izn_odbitka_nz,
        zurusltro.izn_odbitka_pdv_nz,
        zurusltro.izn_odbitka_z,
        zurusltro.izn_odbitka_pdv_z,
        zurusltro.izn_odbitka_uz,
        zurusltro.izn_odbitka_pdv_uz)
        / zak.br_sjedinica
        AS izn_prihoda_izv
    FROM
      (
      SELECT id, so_id, zur.datum
        FROM i_zurnali zur, v_zmp_kalendar kal
       WHERE zur.datum = kal.datum
      ) zur,
      i_zur_usl zurusl,
      irec_zurusl_tro zurusltro,
      t_troskovi tro,
      s_szurnala szur,
      m_agencije age,
      mpka_adrese pkaadr,
      t_racuni rac,
      (
      SELECT zak.id zak_id,
             DECODE (COUNT (zaksj.id), 0, 1, COUNT (zaksj.id)) br_sjedinica
        FROM t_zakup zak, t_zak_sj zaksj
       WHERE zak.id = zak_id(+)
       GROUP BY zak.id
      ) zak,
     (
     SELECT zak.id zak_id, zaksj.sj_id
       FROM t_zakup zak, t_zak_sj zaksj
      WHERE zak.id = zaksj.zak_id(+)
     ) zaksj -- ako za zakup nema zaksj a neto je ipak naplaeno po zakupu ii e u negrupirano
    WHERE
      zurusl.zur_id = zur.id
      AND zurusltro.zurusl_id = zurusl.id
      AND szur.id = zurusl.szur_id
      AND tro.id1 = zurusltro.id1_tro
      AND tro.gost_id IS NULL
      AND age.id(+) = tro.age_id
      AND pkaadr.id(+) = tro.pkaadr_id
      AND rac.id(+) = tro.rac_id -- ne gleda se da li je raun u pripremi
      AND NVL (tro.zak_id, rac.zak_id) = zak.zak_id
      AND NVL (tro.zak_id, rac.zak_id) = zaksj.zak_id
    UNION ALL
    -- prihod iz l_troskovi, u istom select-u za usl sa zak_id i bez.
    -- Za usluge koje nisu od gosta i za koje ima br_sjedinica iz zaksj treba dijeli iznose sa br_jedinica
    SELECT
      zur.datum datum,
      zur.so_id so_id,
      ltro.ms_id ms_id,
      NVL (gost.age_id, ltro.age_id) age_id,
      ltro.ponso_id ponso_id,
      ltro.agep_id agep_id,
      NVL (gost.zem_id, NVL (age.zem_id, pkaadr.zem_id)) zem_id,
      DECODE (gost.id, NULL,
        zaksj.sj_id,
        NVL (pra_rec_s2.sj_id_recgostbor (gost.id, zur.datum), gost.sj_id)
        ) AS sj_id,
      pra_rec_s2.gdgost_id (
        pra_rec_s2.dat_rodjenja (gost.id),
        gost.dat_dolaska,
        NULL,
        zur.datum) -- IRN 4023
        AS recgdgost_id,
      gost.recvpro_id recvpro_id,
      ltro.usl_id usl_id,
      ltro.usl_id1 usl_id1,
      zurusltro.ozn_usl1,
      zurusltro.sas_id,
      zurusl.szur_id szur_id,
      NULL rac_id,
      rez.recnrez_id, -- IRN 4011
      pra_rec_zur.zurn_prihod_bodb (
        zurusltro.izn_prihoda_nz,
        zurusltro.izn_pdv_nz,
        zurusltro.izn_prihoda_z,
        zurusltro.izn_pdv_z,
        zurusltro.izn_prihoda_uz,
        zurusltro.izn_pdv_uz,
        zurusltro.izn_odbitka_nz,
        zurusltro.izn_odbitka_pdv_nz,
        zurusltro.izn_odbitka_z,
        zurusltro.izn_odbitka_pdv_z,
        zurusltro.izn_odbitka_uz,
        zurusltro.izn_odbitka_pdv_uz)
        / DECODE (gost.id, NULL, NVL (br_sjedinica, 1), 1)
        AS iznn_prihod_bodb,
      pra_rec_zur.zurn_prihodz_bodb (
        zurusltro.izn_prihoda_nz,
        zurusltro.izn_pdv_nz,
        zurusltro.izn_prihoda_z,
        zurusltro.izn_pdv_z,
        zurusltro.izn_prihoda_uz,
        zurusltro.izn_pdv_uz,
        zurusltro.izn_odbitka_nz,
        zurusltro.izn_odbitka_pdv_nz,
        zurusltro.izn_odbitka_z,
        zurusltro.izn_odbitka_pdv_z,
        zurusltro.izn_odbitka_uz,
        zurusltro.izn_odbitka_pdv_uz)
        / DECODE (gost.id, NULL, NVL (br_sjedinica, 1), 1)
        AS iznn_prihodz_bodb,
      pra_rec_zur.zurn_odbitakz (
        zurusltro.izn_prihoda_nz,
        zurusltro.izn_pdv_nz,
        zurusltro.izn_prihoda_z,
        zurusltro.izn_pdv_z,
        zurusltro.izn_prihoda_uz,
        zurusltro.izn_pdv_uz,
        zurusltro.izn_odbitka_nz,
        zurusltro.izn_odbitka_pdv_nz,
        zurusltro.izn_odbitka_z,
        zurusltro.izn_odbitka_pdv_z,
        zurusltro.izn_odbitka_uz,
        zurusltro.izn_odbitka_pdv_uz)
        / DECODE (gost.id, NULL, NVL (br_sjedinica, 1), 1)
        AS iznn_odbitakz,
      pra_rec_zur.zurn_pdv (
        zurusltro.izn_prihoda_nz,
        zurusltro.izn_pdv_nz,
        zurusltro.izn_prihoda_z,
        zurusltro.izn_pdv_z,
        zurusltro.izn_prihoda_uz,
        zurusltro.izn_pdv_uz,
        zurusltro.izn_odbitka_nz,
        zurusltro.izn_odbitka_pdv_nz,
        zurusltro.izn_odbitka_z,
        zurusltro.izn_odbitka_pdv_z,
        zurusltro.izn_odbitka_uz,
        zurusltro.izn_odbitka_pdv_uz)
        / DECODE (gost.id, NULL, NVL (br_sjedinica, 1), 1)
        AS iznn_pdv,
      pra_rec_zur.zurb_prihod_bpdv_bodb (
        zurusltro.izn_prihoda_nz,
        zurusltro.izn_pdv_nz,
        zurusltro.izn_prihoda_z,
        zurusltro.izn_pdv_z,
        zurusltro.izn_prihoda_uz,
        zurusltro.izn_pdv_uz,
        zurusltro.izn_odbitka_nz,
        zurusltro.izn_odbitka_pdv_nz,
        zurusltro.izn_odbitka_z,
        zurusltro.izn_odbitka_pdv_z,
        zurusltro.izn_odbitka_uz,
        zurusltro.izn_odbitka_pdv_uz)
        / DECODE (gost.id, NULL, NVL (br_sjedinica, 1), 1)
        AS iznb_prihod_bpdv_bodb,
      pra_rec_zur.zurb_odbitak_bpdv (
        zurusltro.izn_prihoda_nz,
        zurusltro.izn_pdv_nz,
        zurusltro.izn_prihoda_z,
        zurusltro.izn_pdv_z,
        zurusltro.izn_prihoda_uz,
        zurusltro.izn_pdv_uz,
        zurusltro.izn_odbitka_nz,
        zurusltro.izn_odbitka_pdv_nz,
        zurusltro.izn_odbitka_z,
        zurusltro.izn_odbitka_pdv_z,
        zurusltro.izn_odbitka_uz,
        zurusltro.izn_odbitka_pdv_uz)
        / DECODE (gost.id, NULL, NVL (br_sjedinica, 1), 1)
        AS iznb_odbitak_bpdv,
      pra_rec_zur.zurb_prihodz_bpdv (
        zurusltro.izn_prihoda_nz,
        zurusltro.izn_pdv_nz,
        zurusltro.izn_prihoda_z,
        zurusltro.izn_pdv_z,
        zurusltro.izn_prihoda_uz,
        zurusltro.izn_pdv_uz,
        zurusltro.izn_odbitka_nz,
        zurusltro.izn_odbitka_pdv_nz,
        zurusltro.izn_odbitka_z,
        zurusltro.izn_odbitka_pdv_z,
        zurusltro.izn_odbitka_uz,
        zurusltro.izn_odbitka_pdv_uz)
        / DECODE (gost.id, NULL, NVL (br_sjedinica, 1), 1)
        iznb_prihodz_bpdv,
      pra_rec_zur.zurb_pdv_bodb (
        zurusltro.izn_prihoda_nz,
        zurusltro.izn_pdv_nz,
        zurusltro.izn_prihoda_z,
        zurusltro.izn_pdv_z,
        zurusltro.izn_prihoda_uz,
        zurusltro.izn_pdv_uz,
        zurusltro.izn_odbitka_nz,
        zurusltro.izn_odbitka_pdv_nz,
        zurusltro.izn_odbitka_z,
        zurusltro.izn_odbitka_pdv_z,
        zurusltro.izn_odbitka_uz,
        zurusltro.izn_odbitka_pdv_uz)
        / DECODE (gost.id, NULL, NVL (br_sjedinica, 1), 1)
        AS iznb_pdv_bodb,
      pra_rec_zur.zurb_pdv_u_odbitku (
        zurusltro.izn_prihoda_nz,
        zurusltro.izn_pdv_nz,
        zurusltro.izn_prihoda_z,
        zurusltro.izn_pdv_z,
        zurusltro.izn_prihoda_uz,
        zurusltro.izn_pdv_uz,
        zurusltro.izn_odbitka_nz,
        zurusltro.izn_odbitka_pdv_nz,
        zurusltro.izn_odbitka_z,
        zurusltro.izn_odbitka_pdv_z,
        zurusltro.izn_odbitka_uz,
        zurusltro.izn_odbitka_pdv_uz)
        / DECODE (gost.id, NULL, NVL (br_sjedinica, 1), 1)
        AS iznb_pdv_u_odbitku,
      pra_rec_zur.zur_pdvz (
        zurusltro.izn_prihoda_nz,
        zurusltro.izn_pdv_nz,
        zurusltro.izn_prihoda_z,
        zurusltro.izn_pdv_z,
        zurusltro.izn_prihoda_uz,
        zurusltro.izn_pdv_uz,
        zurusltro.izn_odbitka_nz,
        zurusltro.izn_odbitka_pdv_nz,
        zurusltro.izn_odbitka_z,
        zurusltro.izn_odbitka_pdv_z,
        zurusltro.izn_odbitka_uz,
        zurusltro.izn_odbitka_pdv_uz)
        / DECODE (gost.id, NULL, NVL (br_sjedinica, 1), 1)
        AS izn_pdvz,
      pra_rec_zur.izn_prihoda_knj (
        zurusltro.izn_prihoda_nz,
        zurusltro.izn_pdv_nz,
        zurusltro.izn_prihoda_z,
        zurusltro.izn_pdv_z,
        zurusltro.izn_prihoda_uz,
        zurusltro.izn_pdv_uz,
        zurusltro.izn_odbitka_nz,
        zurusltro.izn_odbitka_pdv_nz,
        zurusltro.izn_odbitka_z,
        zurusltro.izn_odbitka_pdv_z,
        zurusltro.izn_odbitka_uz,
        zurusltro.izn_odbitka_pdv_uz)
        / DECODE (gost.id, NULL, NVL (br_sjedinica, 1), 1)
        AS izn_prihoda_knj,
      pra_rec_zur.izn_prihoda_izv (
        zurusltro.izn_prihoda_nz,
        zurusltro.izn_pdv_nz,
        zurusltro.izn_prihoda_z,
        zurusltro.izn_pdv_z,
        zurusltro.izn_prihoda_uz,
        zurusltro.izn_pdv_uz,
        zurusltro.izn_odbitka_nz,
        zurusltro.izn_odbitka_pdv_nz,
        zurusltro.izn_odbitka_z,
        zurusltro.izn_odbitka_pdv_z,
        zurusltro.izn_odbitka_uz,
        zurusltro.izn_odbitka_pdv_uz)
        / DECODE (gost.id, NULL, NVL (br_sjedinica, 1), 1)
        AS izn_prihoda_izv
    FROM
      (
      SELECT id, so_id, zur.datum
        FROM i_zurnali zur, v_zmp_kalendar kal
       WHERE zur.datum = kal.datum
      ) zur,
      i_zur_usl zurusl,
      s_szurnala szur,
      irec_zurusl_tro zurusltro,
      l_troskovi ltro,
      t_gosti gost,
      t_rez_vsj rezvsj,  -- IRN 4011
      t_rezervacije rez, -- IRN 4011
      m_agencije age,
      mpka_adrese pkaadr,
      (
      SELECT zak.id zak_id,
             DECODE (COUNT (zaksj.id), 0, 1, COUNT (zaksj.id)) br_sjedinica
        FROM t_zakup zak, t_zak_sj zaksj
       WHERE zak.id = zak_id(+)
       GROUP BY zak.id
      ) zak,
      (
      SELECT zak.id zak_id, zaksj.sj_id
        FROM t_zakup zak, t_zak_sj zaksj
       WHERE zak.id = zaksj.zak_id(+)
      ) zaksj -- ako za zakup nema zaksj usluge vezane na njega ii e u negrupirano
    WHERE
      zurusl.zur_id = zur.id
      AND zurusltro.zurusl_id = zurusl.id
      AND szur.id = zurusl.szur_id
      AND ltro.id1 = zurusltro.id1_tro
      AND gost.id(+) = ltro.gost_id
      AND gost.rezvsj_id = rezvsj.id (+) -- IRN 4011
      AND rezvsj.rez_id = rez.id (+)     -- IRN 4011
      AND age.id(+) = ltro.age_id
      AND pkaadr.id(+) = ltro.pkaadr_id
      AND ltro.zak_id = zak.zak_id(+)
      AND ltro.zak_id = zaksj.zak_id(+)
    ) -- KRAJ unije
  GROUP BY
    datum,
    so_id,
    ms_id,
    age_id,
    ponso_id,
    agep_id,
    zem_id,
    sj_id,
    recgdgost_id,
    recvpro_id,
    usl_id,
    usl_id1,
    ozn_usl1,
    sas_id,
    szur_id,
    rac_id,
    recnrez_id -- IRN 4011
  )
WITH READ ONLY
/
