PROMPT Creating View 'V_CRM_RNK_ISP_CVOR'
CREATE OR REPLACE FORCE VIEW V_CRM_RNK_ISP_CVOR
 AS SELECT mish_shema.rbr || '-' || pkarnkisp.id AS uidc,  -- IRN 4108
  mish_shema.rbr || '-' || pkarnk.id AS rnk_uidc, -- IRN 4108
  pkarnk.id AS rnk_id,
  pkarnk.god_poslovna AS rnk_god_poslovna,
  gmpkas.sifra AS gmpkas_sifra,
  pkarnk.rbr AS rnk_rbr,
  mish_shema.rbr AS mish_shema_rbr,
  pkarnkisp.sifra AS sifra,
  pkarnkisp.naziv AS naziv,
  isp.popust_max AS popust_max,
  isp.gknji_sifra AS gknji_sifra,
  pkarnkisp.kolicina AS kolicina,
  pkarnkisp.jm AS jm,
  pkarnkisp.cijena AS cijena,
  pkarnkisp.stopa_popusta AS stopa_popusta,
  pkarnkisp.stopa_pdv AS stopa_pdv,
  pkarnkisp.izn_pdv AS izn_pdv,
  pkarnkisp.izn_ppot AS izn_ppot,
  pkarnkisp.izmjena_dat AS izmjena_dat
FROM
  tpka_rnk_isp pkarnkisp,
  tpka_rnkasa pkarnk,
  mgmp_kase gmpkas,
  (
  SELECT
    NVL (pro.sif_proizvoda_kasa, pro.sifra) AS sifra,
    pro.popust_max AS popust_max,
    gknji.sifra AS gknji_sifra
  FROM
    m_proizvodi pro,
    m_gknjigo gknji
  WHERE
    pro.gknji_id = gknji.id
  UNION ALL
  SELECT
    sifgr.sif_proizvoda_kasa,
    100,
    gknji.sifra
  FROM
    m_sif_grupa sifgr,
    m_gknjigo gknji
  WHERE
    sifgr.gknji_id = gknji.id
   ) isp,
  (
  SELECT
    DECODE (pra_zmp_zaj.zmppar_vrijednost ('CRM', '1001'), 'nebitno',
      LEAST (TRUNC (SYSDATE, 'RRRR'), SYSDATE - 200),
      TO_DATE (pra_zmp_zaj.zmppar_vrijednost ('CRM', '1001'), 'DD.MM.RRRR')
    ) AS dat_poc
  FROM dual
  ) param,
  (
  SELECT
    pra_zmp_zaj.tekuci_cvor_rbr AS rbr
  FROM
    dual
  ) mish_shema
WHERE
  pkarnkisp.pkarnk_id = pkarnk.id
  AND pkarnk.gmpkas_id = gmpkas.id
  AND pkarnk.rac_id IS NOT NULL
  AND pkarnkisp.sifra = isp.sifra(+)
  AND pkarnk.datum >= param.dat_poc
  AND pra_zmp_s.oznaka ('V0035') = -1
WITH READ ONLY
/
