PROMPT Creating View 'V_CRM_REZ_VSJ_CVOR'
CREATE OR REPLACE FORCE VIEW V_CRM_REZ_VSJ_CVOR
 AS SELECT mish_shema.rbr || '-' || rezvsj.id AS uidc, -- IRN 4108
  rezvsj.id AS id,
  rez.crmid AS rez_crmid,
  rez.god_poslovna || '-' || so.sifra || '-' || rez.rbr AS rez_uidc, -- IRN 4108
  rez.god_poslovna AS rez_god_poslovna,
  so.sifra AS so_sifra,
  rez.rbr AS rez_rbr,
  vsj.sifra AS vsj_sifra,
  vsj.naziv AS vsj_naziv,
  vsjc.sifra AS vsjc_sifra,
  vsjc.naziv AS vsjc_naziv,
  sj.broj AS sj_broj,
  rezvsj.kol_sj AS kol_sj,
  rezvsj.br_osoba AS br_osoba,
  rezvsj.izmjena_dat AS izmjena_dat
FROM
  t_rez_vsj rezvsj,
  t_rezervacije rez,
  m_so so,
  s_vsj vsj,
  s_vsj vsjc,
  m_sj sj,
  (
  SELECT
    DECODE (pra_zmp_zaj.zmppar_vrijednost ('CRM', '1001'), 'nebitno',
      LEAST (TRUNC (SYSDATE, 'RRRR'), SYSDATE - 200),
      TO_DATE (pra_zmp_zaj.zmppar_vrijednost ('CRM', '1001'), 'DD.MM.RRRR')
    ) AS dat_poc
  FROM
    dual
  ) param,
  ( -- IRN 4108
  SELECT
    pra_zmp_zaj.tekuci_cvor_rbr AS rbr
  FROM
    dual
  ) mish_shema
WHERE
  rezvsj.rez_id = rez.id
  AND rez.so_id = so.id
  AND rezvsj.vsj_id = vsj.id
  AND rezvsj.vsjc_id = vsjc.id
  AND rezvsj.sj_id = sj.id (+)
  AND rez.dat_dolaska >= param.dat_poc
  AND pra_zmp_s.oznaka ('V0031') = -1
WITH READ ONLY
/
