PROMPT Creating View 'V_CRM_REZ_USL_CVOR'
CREATE OR REPLACE FORCE VIEW V_CRM_REZ_USL_CVOR
 AS SELECT mish_shema.rbr || '-' || rezusl.id AS uidc, -- IRN 4108
  rezusl.id AS id,
  rez.crmid AS rez_crmid,
  rez.god_poslovna || '-' || so.sifra || '-' || rez.rbr AS rez_uidc, -- IRN 4108
  rez.god_poslovna AS rez_god_poslovna,
  so.sifra AS so_sifra,
  rez.rbr AS rez_rbr,
  usl.sifra AS usl_sifra,
  sas.sifra AS sas_sifra,
  recara.id AS recara_id,
  recara.sifra AS recara_sifra,
  uslc.sifra AS uslc_sifra,
  rezusl.dat_poc AS dat_poc,
  rezusl.dat_zav AS dat_zav,
  rezusl.ozn_ugo AS ozn_ugo,
  rezusl.ozn_platitelja AS ozn_platitelja,
  rezusl.izmjena_dat AS izmjena_dat
FROM
  t_rez_usl rezusl,
  t_rezervacije rez,
  m_so so,
  s_usluge usl,
  s_sastojci sas,
  mrec_aranzmani recara,
  s_usluge uslc,
  (
  SELECT
    DECODE (pra_zmp_zaj.zmppar_vrijednost ('CRM', '1001'), 'nebitno',
      LEAST (TRUNC (SYSDATE, 'RRRR'), SYSDATE - 200),
      TO_DATE (pra_zmp_zaj.zmppar_vrijednost ('CRM', '1001'), 'DD.MM.RRRR')
    ) AS dat_poc
  FROM
    dual
  ) param,
  ( -- IRN 4108
  SELECT
    pra_zmp_zaj.tekuci_cvor_rbr AS rbr
  FROM
    dual
  ) mish_shema
WHERE
  rezusl.rez_id = rez.id
  AND rez.so_id = so.id
  AND rezusl.usl_id = usl.id
  AND rezusl.sas_id = sas.id (+)
  AND rezusl.recara_id = recara.id (+)
  AND rezusl.usl_id1 = uslc.id (+)
  AND rez.dat_dolaska >= param.dat_poc
  AND pra_zmp_s.oznaka ('V0030') = -1
WITH READ ONLY
/
