PROMPT Creating View 'V_CRM_REZ_GUSL_CVOR'
CREATE OR REPLACE FORCE VIEW V_CRM_REZ_GUSL_CVOR
 AS SELECT mish_shema.rbr || '-' || rezgusl.id AS uidc, -- IRN 4108
  rezgusl.id AS id,
  rezgost.id AS rezgost_id,
  rez.crmid AS rez_crmid,
  rez.god_poslovna AS rez_god_poslovna,
  so.sifra AS so_sifra,
  rez.rbr AS rez_rbr,
  mish_shema.rbr || '-' || rezvsj.id AS rezvsj_uidc, -- IRN 4108
  vsjc.sifra AS vsjc_sifra,
  usl.sifra AS usl_sifra,
  sas.sifra AS sas_sifra,
  recara.id AS recara_id,
  recara.sifra AS recara_sifra,
  uslc.sifra AS uslc_sifra,
  rezgusl.dat_poc AS dat_poc,
  rezgusl.dat_zav AS dat_zav,
  rezgusl.stopa_placanja AS stopa_placanja,
  rezgusl.ozn_ugo AS ozn_ugo,
  rezgusl.ozn_platitelja AS ozn_platitelja,
  rezgusl.izmjena_dat AS izmjena_dat
FROM
  t_rez_gusl rezgusl,
  t_rez_gost rezgost,
  t_rez_vsj rezvsj,
  s_vsj vsjc,
  t_rezervacije rez,
  m_so so,
  s_usluge usl,
  s_sastojci sas,
  mrec_aranzmani recara,
  s_usluge uslc,
  (
  SELECT
    DECODE (pra_zmp_zaj.zmppar_vrijednost ('CRM', '1001'), 'nebitno',
      LEAST (TRUNC (SYSDATE, 'RRRR'), SYSDATE - 200),
      TO_DATE (pra_zmp_zaj.zmppar_vrijednost ('CRM', '1001'), 'DD.MM.RRRR')
    ) AS dat_poc
  FROM
    dual
  ) param,
  ( -- IRN 4108
  SELECT
    pra_zmp_zaj.tekuci_cvor_rbr AS rbr
  FROM
    dual
  ) mish_shema
WHERE
  rezgusl.rezgost_id = rezgost.id
  AND rezgost.rezvsj_id = rezvsj.id
  AND rezvsj.rez_id = rez.id
  AND rezvsj.vsjc_id = vsjc.id
  AND rez.so_id = so.id
  AND rezgusl.usl_id = usl.id
  AND rezgusl.sas_id = sas.id (+)
  AND rezgusl.recara_id = recara.id (+)
  AND rezgusl.usl_id1 = uslc.id (+)
  AND rez.dat_dolaska >= param.dat_poc
  AND pra_zmp_s.oznaka ('V0029') = -1
WITH READ ONLY
/
