-- C:\Radni\trec_rez_sj.trg
--
-- Generated for Oracle 10g on Tue May 06  14:07:33 2025 by Server Generator 6.5.96.5.6
 
PROMPT Creating Trigger 'ADS_TREC_REZ_SJ'
CREATE OR REPLACE TRIGGER ADS_TREC_REZ_SJ
 AFTER DELETE
 ON TREC_REZ_SJ
DECLARE

  zapis_flex_l pra_flexkeeping.rezsj_rec_type;
  zapis_dom_l  pra_dom_api.rezsj_rec_type;
BEGIN

  -- IRN 3625
  tab_trec_rez_sj_flex.postavi_iterator;
  WHILE tab_trec_rez_sj_flex.ima_jos LOOP
    zapis_flex_l := tab_trec_rez_sj_flex.sljedeci_red;
    pra_flexkeeping.post_booking_rezsj (zapis_flex_l);
  END LOOP;

  -- IRN 3860
  tab_trec_rez_sj_dom.postavi_iterator;
  WHILE tab_trec_rez_sj_dom.ima_jos LOOP
    zapis_dom_l := tab_trec_rez_sj_dom.sljedeci_red;
    pra_dom_api.dom_post_booking_rezsj (zapis_dom_l, 'TREC_REZ_SJ'); -- IRN 4030	
  END LOOP;
END;
/
SHOW ERROR


PROMPT Creating Trigger 'AIS_TREC_REZ_SJ'
CREATE OR REPLACE TRIGGER AIS_TREC_REZ_SJ
 AFTER INSERT
 ON TREC_REZ_SJ
DECLARE

  zapis_l      tab_trec_rez_sj.recrezsj_rec_type;
  zapis_flex_l pra_flexkeeping.rezsj_rec_type;
  zapis_dom_l  pra_dom_api.rezsj_rec_type;
BEGIN
  tab_trec_rez_sj.postavi_iterator;
  WHILE tab_trec_rez_sj.ima_jos LOOP
    zapis_l := tab_trec_rez_sj.slijedeci_red;
    pra_t_rezervacije.provjeri_rezvsj_kol_sj (zapis_l.rezvsj_id);
    pra_t_rezervacije.provjeri_rezvsj_br_osoba (zapis_l.rezvsj_id);
  END LOOP;

  -- IRN 3625
  tab_trec_rez_sj_flex.postavi_iterator;
  WHILE tab_trec_rez_sj_flex.ima_jos LOOP
    zapis_flex_l := tab_trec_rez_sj_flex.sljedeci_red;
    pra_flexkeeping.post_booking_rezsj (zapis_flex_l);
  END LOOP;

  -- IRN 3860
  tab_trec_rez_sj_dom.postavi_iterator;
  WHILE tab_trec_rez_sj_dom.ima_jos LOOP
    zapis_dom_l := tab_trec_rez_sj_dom.sljedeci_red;
    pra_dom_api.dom_post_booking_rezsj (zapis_dom_l, 'TREC_REZ_SJ'); -- IRN 4030
  END LOOP;

END;
/
SHOW ERROR


PROMPT Creating Trigger 'ARL_TREC_REZ_SJ'
CREATE OR REPLACE TRIGGER ARL_TREC_REZ_SJ
 AFTER DELETE OR INSERT OR UPDATE
 ON TREC_REZ_SJ
 FOR EACH ROW
BEGIN
  -- IRN 2888
  IF SYS_CONTEXT ('LOGINFO_CTX', 'SSOUSER') = 'ITNEW'
    AND SYS_CONTEXT ('LOGINFO_CTX', 'VLASNIKPODATKA') = pra_zmp_zaj.vrijednost_parametra ('0999')
  THEN
    RETURN;  -- izlaz iz trigera
  END IF;

  replikacija2.napuni_tab (:OLD.id, :NEW.id);
END;
/
SHOW ERROR


PROMPT Creating Trigger 'ASL_TREC_REZ_SJ'
CREATE OR REPLACE TRIGGER ASL_TREC_REZ_SJ
 AFTER DELETE OR INSERT OR UPDATE
 ON TREC_REZ_SJ
BEGIN
  replikacija2.upisi_u_log (
    aplikacija_p => 'REC',
    tablica_p    => 'TREC_REZ_SJ');
END;
/
SHOW ERROR


PROMPT Creating Trigger 'AUS_TREC_REZ_SJ'
CREATE OR REPLACE TRIGGER AUS_TREC_REZ_SJ
 AFTER UPDATE
 ON TREC_REZ_SJ
DECLARE

  zapis_l      tab_trec_rez_sj.recrezsj_rec_type;
  zapis_flex_l pra_flexkeeping.rezsj_rec_type;
  zapis_dom_l  pra_dom_api.rezsj_rec_type;
BEGIN
  tab_trec_rez_sj.postavi_iterator;
  WHILE tab_trec_rez_sj.ima_jos LOOP
    zapis_l := tab_trec_rez_sj.slijedeci_red;
    pra_t_rezervacije.provjeri_rezvsj_br_osoba (zapis_l.rezvsj_id);
  END LOOP;

  -- IRN 3625
  tab_trec_rez_sj_flex.postavi_iterator;
  WHILE tab_trec_rez_sj_flex.ima_jos LOOP
    zapis_flex_l := tab_trec_rez_sj_flex.sljedeci_red;
    pra_flexkeeping.post_booking_rezsj (zapis_flex_l);
    pra_rec_iud4.puni_pkaoba_overbooking ( -- IRN 3977
      zapis_flex_l.sj_id_old,
      zapis_flex_l.sj_id_new,
      zapis_flex_l.rez_row.rbr,
      zapis_flex_l.rez_row.god_poslovna,
      zapis_flex_l.rez_row.prezime,
      zapis_flex_l.rez_row.dat_dolaska,
      zapis_flex_l.rez_row.dat_odlaska);
  END LOOP;

  -- IRN 3860
  tab_trec_rez_sj_dom.postavi_iterator;
  WHILE tab_trec_rez_sj_dom.ima_jos LOOP
    zapis_dom_l := tab_trec_rez_sj_dom.sljedeci_red;
    pra_dom_api.dom_post_booking_rezsj (zapis_dom_l, 'TREC_REZ_SJ'); -- IRN 4030
  END LOOP;

END;
/
SHOW ERROR


PROMPT Creating Trigger 'BDR_TREC_REZ_SJ'
CREATE OR REPLACE TRIGGER BDR_TREC_REZ_SJ
 BEFORE DELETE
 ON TREC_REZ_SJ
 FOR EACH ROW
DECLARE

  rez_id_l     t_rez_vsj.rez_id%TYPE;
  vsj_id_l     t_rez_vsj.vsj_id%TYPE;
  rez_row_l    t_rezervacije%ROWTYPE;
  zapis_flex_l pra_flexkeeping.rezsj_rec_type;
  zapis_dom_l  pra_dom_api.rezsj_rec_type;
BEGIN

  -- 14.08.2007. G.J.
  pra_t_rezervacije.provjeri_rezgost_sj_id (:OLD.rezvsj_id, :OLD.sj_id);

  -- vrati zaglavlje
  SELECT rez_id, vsj_id
    INTO rez_id_l, vsj_id_l
    FROM t_rez_vsj
   WHERE id = :OLD.rezvsj_id;

  /*
  izdvojeno iz "vrati zaglavlje" da se ne javlja greka
  PLS-00494: coercion into multiple record targets not supported
  */
  SELECT * INTO rez_row_l FROM t_rezervacije WHERE id = rez_id_l;  

  pra_t_rezervacije.azuriraj_book_recrezsj (
    rez_row_l.oznaka,
    rez_row_l.ozn_vstorna,
    rez_row_l.so_id,
    rez_row_l.ms_id,
    rez_row_l.age_id,
    vsj_id_l,
    rez_row_l.ponso_id,
    rez_row_l.recvpro_id,
    rez_row_l.dat_dolaska,
    rez_row_l.dat_odlaska,
    rez_row_l.ozn_B,
    rez_row_l.ozn_F,
    :OLD.br_osoba,
    :OLD.br_osobaZ,
    :OLD.sj_id,
    -1);  -- ozn_PlusMinus = oduzmi_booking za staro

  -- Auriraj status SJ
  pra_t_rez_vsj.oduzmi_statussj (
    rez_row_l.oznaka,
    rez_row_l.ozn_vstorna,
    :OLD.sj_id,
    rez_row_l.dat_dolaska,
    rez_row_l.dat_odlaska,
    :OLD.br_osoba,
    :OLD.br_osobaZ);

  -- Otkai najavu prema Key Card sustavu
  pra_rec_kc_iud.puni_kczah_rezvsj (
    rez_row_l.oznaka,
    rez_row_l.ozn_vstorna,
    :OLD.sj_id,
    32,
    rez_row_l.dat_dolaska);

  -- IRN 3625
  IF :OLD.br_osobaz IS NULL THEN
    zapis_flex_l.rez_row := rez_row_l;
    zapis_flex_l.id := :OLD.id;
    zapis_flex_l.sj_id_old := :OLD.sj_id;
    zapis_flex_l.br_osoba := :OLD.br_osoba;
    tab_trec_rez_sj_flex.puni_tablicu (zapis_flex_l);
  END IF;

  -- IRN 3860
  IF :OLD.br_osobaz IS NULL THEN
    zapis_dom_l.rez_row := rez_row_l;
    zapis_dom_l.id := :OLD.id;
    zapis_dom_l.sj_id_old := :OLD.sj_id;
    zapis_dom_l.br_osoba := :OLD.br_osoba;
	zapis_dom_l.rezvsj_id := :OLD.rezvsj_id; -- IRN 4030
    tab_trec_rez_sj_dom.puni_tablicu (zapis_dom_l);
  END IF;
END;
/
SHOW ERROR


PROMPT Creating Trigger 'BDS_TREC_REZ_SJ'
CREATE OR REPLACE TRIGGER BDS_TREC_REZ_SJ
 BEFORE DELETE
 ON TREC_REZ_SJ
BEGIN
  tab_trec_rez_sj_flex.brisi_tablicu;
  tab_trec_rez_sj_dom.brisi_tablicu;
END;
/
SHOW ERROR


PROMPT Creating Trigger 'BIR_TREC_REZ_SJ'
CREATE OR REPLACE TRIGGER BIR_TREC_REZ_SJ
 BEFORE INSERT
 ON TREC_REZ_SJ
 FOR EACH ROW
DECLARE

  rez_id_l     t_rez_vsj.rez_id%TYPE;
  vsj_id_l     t_rez_vsj.vsj_id%TYPE;
  sj_id_l      t_rez_vsj.sj_id%TYPE;
  rez_row_l    t_rezervacije%ROWTYPE;

  zapis_l      tab_trec_rez_sj.recrezsj_rec_type;
  zapis_flex_l pra_flexkeeping.rezsj_rec_type;
  zapis_dom_l  pra_dom_api.rezsj_rec_type;

  ozn_r_l      NUMBER;
BEGIN
  -- IRN 2888
  IF SYS_CONTEXT ('LOGINFO_CTX', 'SSOUSER') = 'ITNEW'
    AND SYS_CONTEXT ('LOGINFO_CTX', 'VLASNIKPODATKA') = pra_zmp_zaj.vrijednost_parametra ('0999')
  THEN
    RETURN;  -- izlaz iz trigera
  END IF;

  :NEW.id := pra_zmp_zaj.i3_sekvenca (:NEW.id);

  -- vrati zaglavlje
  SELECT rez_id, vsj_id, sj_id
    INTO rez_id_l, vsj_id_l, sj_id_l
    FROM t_rez_vsj
   WHERE id = :NEW.rezvsj_id;

  /*
  izdvojeno iz "vrati zaglavlje" da se ne javlja greka
  PLS-00494: coercion into multiple record targets not supported
  */
  SELECT * INTO rez_row_l FROM t_rezervacije WHERE id = rez_id_l;  

  IF pra_zmp_s.vsj_je_sastavljena (vsj_id_l) = 0 THEN
    IF sj_id_l IS NOT NULL THEN
      -- Smjetajna jedinica ve je upisana u rezervirane vrste SJ!
      pra_rec_zaj.vrati_poruku (-20458);
    END IF;
  ELSE
    IF sj_id_l IS NULL THEN
      -- Ne moe se upisati rezervirana smjetajna jedinica za sastavljenu VSJ ako nije upisana sastavljena SJ u rezervirane vrste SJ.
      pra_rec_zaj.vrati_poruku (-20617);
    END IF;
  END IF;

  pra_rec_s2.provjeri_sj (:NEW.sj_id, rez_row_l.so_id, vsj_id_l, rez_row_l.dat_dolaska, rez_row_l.dat_odlaska - 1, 2, sj_id_l);
  pra_t_rezervacije.provjeri_sj_zakupljena (rez_row_l.oznaka, rez_row_l.ozn_vstorna, :NEW.sj_id, rez_row_l.dat_dolaska, rez_row_l.dat_odlaska);
  fm_rec2120.provjeri_status_sj (rez_row_l.dat_dolaska, rez_row_l.dat_odlaska, :NEW.rezvsj_id, :NEW.id, :NEW.sj_id);

  IF NVL (:NEW.ozn_fiksna_sj, 0) <> 0 THEN
    pra_t_rez_vsj.upisi_promjenu_zastite_sj (
      rez_row_l.id,
      vsj_id_l,
      :NEW.sj_id,
      :NEW.ozn_fiksna_sj);
  END IF;

  -- Auriraj booking
  pra_t_rezervacije.azuriraj_book_recrezsj (
    rez_row_l.oznaka,
    rez_row_l.ozn_vstorna,
    rez_row_l.so_id,
    rez_row_l.ms_id,
    rez_row_l.age_id,
    vsj_id_l,
    rez_row_l.ponso_id,
    rez_row_l.recvpro_id,
    rez_row_l.dat_dolaska,
    rez_row_l.dat_odlaska,
    rez_row_l.ozn_B,
    rez_row_l.ozn_F,
    :NEW.br_osoba,
    :NEW.br_osobaZ, -- kod inserta u pravilu = NULL
    :NEW.sj_id,
    1);  -- ozn_PlusMinus = dodaj_booking

  -- Auriraj status SJ
  IF :NEW.br_osoba > NVL (:NEW.br_osobaZ, 0) -- IRN 1237
    OR :NEW.br_osoba = 0
  THEN
    SELECT DECODE (rez_row_l.ozn_F, 0, 1, 3) - NVL (:NEW.ozn_fiksna_sj, 0)
      INTO ozn_r_l
      FROM dual;
    pra_t_rez_vsj.dodaj_statussj (
      rez_row_l.oznaka,
      rez_row_l.ozn_vstorna,
      :NEW.sj_id,
      rez_row_l.dat_dolaska,
      rez_row_l.dat_odlaska,
      :NEW.br_osoba,
      :NEW.br_osobaZ,
      ozn_r_l);
  END IF;

  -- Najavi dolazak prema Key Card sustavu
  pra_rec_kc_iud.puni_kczah_rezvsj (rez_row_l.oznaka, rez_row_l.ozn_vstorna, :NEW.sj_id, 31, rez_row_l.dat_dolaska);

  -- za AIS pra_t_rezervacije.provjeri_rezvsj_kol_sj, ..., br_osoba
  zapis_l.rezvsj_id := :NEW.rezvsj_id;
  tab_trec_rez_sj.puni_tablicu (zapis_l);

  -- IRN 3625
  IF :NEW.br_osoba <> 0 AND :NEW.br_osobaz IS NULL THEN
    zapis_flex_l.rez_row := rez_row_l;
    zapis_flex_l.id := :NEW.id;
    zapis_flex_l.sj_id_new := :NEW.sj_id;
    zapis_flex_l.br_osoba := :NEW.br_osoba;
    tab_trec_rez_sj_flex.puni_tablicu (zapis_flex_l);
  END IF;

  -- IRN 3860
  IF :NEW.br_osoba <> 0 AND :NEW.br_osobaz IS NULL THEN
    zapis_dom_l.rez_row := rez_row_l;
    zapis_dom_l.id := :NEW.id;
    zapis_dom_l.sj_id_new := :NEW.sj_id;
    zapis_dom_l.br_osoba := :NEW.br_osoba;
    zapis_dom_l.rezvsj_id := :NEW.rezvsj_id; -- IRN 4030
    tab_trec_rez_sj_dom.puni_tablicu (zapis_dom_l);
  END IF;

  pra_rec_zaj.upisi_audit (:NEW.unos_korisnik, :NEW.unos_dat, :NEW.izmjena_korisnik, :NEW.izmjena_dat);
END;
/
SHOW ERROR


PROMPT Creating Trigger 'BIS_TREC_REZ_SJ'
CREATE OR REPLACE TRIGGER BIS_TREC_REZ_SJ
 BEFORE INSERT
 ON TREC_REZ_SJ
BEGIN
  tab_trec_rez_sj.brisi_tablicu;
  tab_trec_rez_sj_flex.brisi_tablicu;
  tab_trec_rez_sj_dom.brisi_tablicu;
END;
/
SHOW ERROR


PROMPT Creating Trigger 'BSL_TREC_REZ_SJ'
CREATE OR REPLACE TRIGGER BSL_TREC_REZ_SJ
 BEFORE DELETE OR INSERT OR UPDATE
 ON TREC_REZ_SJ
BEGIN
  -- IRN 2680 prebaeno na replikacija2 jer se kreiranje trec_rez_sj pokree iz trigera na t_rez_vsj koja se logira preko replikacije
  replikacija2.brisi_tab;
END;
/
SHOW ERROR


PROMPT Creating Trigger 'BUR_TREC_REZ_SJ'
CREATE OR REPLACE TRIGGER BUR_TREC_REZ_SJ
 BEFORE UPDATE
 ON TREC_REZ_SJ
 FOR EACH ROW
DECLARE

  rez_id_l     t_rez_vsj.rez_id%TYPE;
  vsj_id_l     t_rez_vsj.vsj_id%TYPE;
  sj_id_l      t_rez_vsj.sj_id%TYPE;
  rez_row_l    t_rezervacije%ROWTYPE;

  zapis_l      tab_trec_rez_sj.recrezsj_rec_type;
  zapis_flex_l pra_flexkeeping.rezsj_rec_type;
  zapis_dom_l  pra_dom_api.rezsj_rec_type;

  ozn_r_l      NUMBER;
BEGIN
  IF :NEW.rezvsj_id <> :OLD.rezvsj_id THEN
    pra_rec_zaj.vrati_poruku (-20364);
  END IF;

  -- vrati zaglavlje
  SELECT rez_id, vsj_id, sj_id
    INTO rez_id_l, vsj_id_l, sj_id_l
    FROM t_rez_vsj
   WHERE id = :NEW.rezvsj_id;

  /*
  izdvojeno iz "vrati zaglavlje" da se ne javlja greka
  PLS-00494: coercion into multiple record targets not supported
  */
  SELECT * INTO rez_row_l FROM t_rezervacije WHERE id = rez_id_l;  

  IF pra_zmp_s.vsj_je_sastavljena (vsj_id_l) = 0 THEN
    IF sj_id_l IS NOT NULL THEN
      -- Smjetajna jedinica ve je upisana u rezervirane vrste SJ!
      pra_rec_zaj.vrati_poruku (-20458);
    END IF;
  ELSE
    IF sj_id_l IS NULL THEN
      -- Ne moe se upisati rezervirana smjetajna jedinica za sastavljenu VSJ ako nije upisana sastavljena SJ u rezervirane vrste SJ.
      pra_rec_zaj.vrati_poruku (-20617);
    END IF;
    IF :NEW.sj_id <> :OLD.sj_id THEN
      -- Ne moe se promijeniti smjetajna jedinica ako je vrsta SJ sastavljena!
      pra_rec_zaj.vrati_poruku (-20618);
    END IF;
  END IF;
  pra_rec_s2.provjeri_sj (:NEW.sj_id, rez_row_l.so_id, vsj_id_l, rez_row_l.dat_dolaska, rez_row_l.dat_odlaska - 1, 2, sj_id_l);

  IF :NEW.sj_id <> :OLD.sj_id THEN
    pra_t_rezervacije.provjeri_rezgost_sj_id (:NEW.rezvsj_id, :OLD.sj_id);
    pra_t_rezervacije.provjeri_sj_zakupljena (rez_row_l.oznaka, rez_row_l.ozn_vstorna, :NEW.sj_id, rez_row_l.dat_dolaska, rez_row_l.dat_odlaska);
    fm_rec2120.provjeri_status_sj (rez_row_l.dat_dolaska, rez_row_l.dat_odlaska, :NEW.rezvsj_id, :NEW.id, :NEW.sj_id);
    -- Otkai najavu prema Key Card sustavu
    pra_rec_kc_iud.puni_kczah_rezvsj (rez_row_l.oznaka, rez_row_l.ozn_vstorna, :OLD.sj_id, 32, rez_row_l.dat_dolaska);
    -- Najavi dolazak prema Key Card sustavu
    pra_rec_kc_iud.puni_kczah_rezvsj (rez_row_l.oznaka, rez_row_l.ozn_vstorna, :NEW.sj_id, 31, rez_row_l.dat_dolaska);
  END IF;

  IF NVL (:NEW.ozn_fiksna_sj, 0) <> NVL (:OLD.ozn_fiksna_sj, 0) THEN
    pra_t_rez_vsj.upisi_promjenu_zastite_sj (
      rez_row_l.id,
      vsj_id_l,
      :NEW.sj_id,
      :NEW.ozn_fiksna_sj);
  END IF;

  IF :NEW.br_osoba <> :OLD.br_osoba THEN
    pra_t_rezervacije.provjeri_rezgost_br_redaka (:NEW.rezvsj_id, :NEW.sj_id, :NEW.br_osoba);
  END IF;

  -- Auriraj booking
  IF NVL (:NEW.sj_id, 0) <> NVL (:OLD.sj_id, 0) -- ako se mijenjala SJ moda je druge vrste
    OR (:NEW.br_osoba <> :OLD.br_osoba) -- ako se mijenjao broj osoba
    -- za sada zanemarujemo auriranje bookinga prilikom izmjene br_osobaZ pa izbacujem ostatak uvjeta
    -- prilikom auriranja bookinga za gosta izmijeniti ako je potrebno
    --    OR ((:OLD.br_osoba - NVL (:OLD.br_osobaZ, 0)) = 0
    --      AND (:NEW.br_osoba - NVL (:NEW.br_osobaZ, 0)) <> 0)
    --    OR ((:OLD.br_osoba - NVL (:OLD.br_osobaZ, 0)) <> 0
    --      AND (:NEW.br_osoba - NVL (:NEW.br_osobaZ, 0)) = 0)
  THEN
    pra_t_rezervacije.azuriraj_book_recrezsj (
      rez_row_l.oznaka,
      rez_row_l.ozn_vstorna,
      rez_row_l.so_id,
      rez_row_l.ms_id,
      rez_row_l.age_id,
      vsj_id_l,
      rez_row_l.ponso_id,
      rez_row_l.recvpro_id,
      rez_row_l.dat_dolaska,
      rez_row_l.dat_odlaska,
      rez_row_l.ozn_B,
      rez_row_l.ozn_F,
      :OLD.br_osoba,
      :OLD.br_osobaZ,
      :OLD.sj_id,
      -1);  -- ozn_PlusMinus = oduzmi_booking za staro
    pra_t_rezervacije.azuriraj_book_recrezsj (
      rez_row_l.oznaka,
      rez_row_l.ozn_vstorna,
      rez_row_l.so_id,
      rez_row_l.ms_id,
      rez_row_l.age_id,
      vsj_id_l,
      rez_row_l.ponso_id,
      rez_row_l.recvpro_id,
      rez_row_l.dat_dolaska,
      rez_row_l.dat_odlaska,
      rez_row_l.ozn_B,
      rez_row_l.ozn_F,
      :NEW.br_osoba,
      :NEW.br_osobaZ,
      :NEW.sj_id,
      1);  -- ozn_PlusMinus = dodaj_booking za novo
  END IF;
  -- kraj auriranja bookinga

  -- Auriraj status SJ
  IF NVL (:NEW.sj_id, 0) <> NVL (:OLD.sj_id, 0)
    OR NVL (:NEW.ozn_fiksna_sj, 0) <> NVL (:OLD.ozn_fiksna_sj, 0)
    OR ((:OLD.br_osoba - NVL (:OLD.br_osobaZ, 0)) = 0 AND (:NEW.br_osoba - NVL (:NEW.br_osobaZ, 0)) <> 0)
    OR ((:OLD.br_osoba - NVL (:OLD.br_osobaZ, 0)) <> 0 AND (:NEW.br_osoba - NVL (:NEW.br_osobaZ, 0)) = 0)
  THEN
    pra_t_rez_vsj.oduzmi_statussj (
      rez_row_l.oznaka,
      rez_row_l.ozn_vstorna,
      :OLD.sj_id,
      rez_row_l.dat_dolaska,
      rez_row_l.dat_odlaska,
      :OLD.br_osoba,
      :OLD.br_osobaZ);

    IF :NEW.br_osoba > NVL (:NEW.br_osobaZ, 0) -- IRN 1237
      OR :NEW.br_osoba = 0 AND NVL (:NEW.br_osobaZ, 0) = 0
    THEN
      SELECT DECODE (rez_row_l.ozn_F, 0, 1, 3) - NVL (:NEW.ozn_fiksna_sj, 0)
        INTO ozn_r_l
        FROM dual;
      pra_t_rez_vsj.dodaj_statussj (
        rez_row_l.oznaka,
        rez_row_l.ozn_vstorna,
        :NEW.sj_id,
        rez_row_l.dat_dolaska,
        rez_row_l.dat_odlaska,
        :NEW.br_osoba,
        :NEW.br_osobaZ,
        ozn_r_l);
    END IF;
  END IF;

  -- za AUS pra_t_rezervacije.provjeri_rezvsj_br_osoba
  zapis_l.rezvsj_id := :NEW.rezvsj_id;
  tab_trec_rez_sj.puni_tablicu (zapis_l);

  -- IRN 3625
  IF (:NEW.sj_id <> :OLD.sj_id OR :NEW.br_osoba <> :OLD.br_osoba)
    AND :NEW.br_osobaz IS NULL
  THEN
    zapis_flex_l.rez_row := rez_row_l;
    zapis_flex_l.id := :NEW.id;
    zapis_flex_l.sj_id_new := :NEW.sj_id;
    zapis_flex_l.sj_id_old := :OLD.sj_id;
    zapis_flex_l.br_osoba := :NEW.br_osoba;
    tab_trec_rez_sj_flex.puni_tablicu (zapis_flex_l);
  END IF;

  -- IRN 3860
  IF (:NEW.sj_id <> :OLD.sj_id OR :NEW.br_osoba <> :OLD.br_osoba)
    AND :NEW.br_osobaz IS NULL
  THEN
    zapis_dom_l.rez_row := rez_row_l;
    zapis_dom_l.id := :NEW.id;
    zapis_dom_l.sj_id_new := :NEW.sj_id;
    zapis_dom_l.sj_id_old := :OLD.sj_id;
    zapis_dom_l.br_osoba := :NEW.br_osoba;
    zapis_dom_l.rezvsj_id := :NEW.rezvsj_id; -- IRN 4030
    tab_trec_rez_sj_dom.puni_tablicu (zapis_dom_l);
  END IF;

  pra_rec_zaj.upisi_audit (:NEW.unos_korisnik, :NEW.unos_dat, :NEW.izmjena_korisnik, :NEW.izmjena_dat);
END;
/
SHOW ERROR


PROMPT Creating Trigger 'BUS_TREC_REZ_SJ'
CREATE OR REPLACE TRIGGER BUS_TREC_REZ_SJ
 BEFORE UPDATE
 ON TREC_REZ_SJ
BEGIN
  tab_trec_rez_sj.brisi_tablicu;
  tab_trec_rez_sj_flex.brisi_tablicu;
  tab_trec_rez_sj_dom.brisi_tablicu;
END;
/
SHOW ERROR



