PROMPT Creating Trigger 'BDR_TREC_PON2_USL'
CREATE OR REPLACE TRIGGER BDR_TREC_PON2_USL
 BEFORE DELETE
 ON TREC_PON2_USL
 FOR EACH ROW
BEGIN
  pra_trec_pon2_usl.provjeri_recpon2 (:OLD.recpon2_id);
END;
/
SHOW ERROR


PROMPT Creating Trigger 'BIR_TREC_PON2_USL'
CREATE OR REPLACE TRIGGER BIR_TREC_PON2_USL
 BEFORE INSERT
 ON TREC_PON2_USL
 FOR EACH ROW
BEGIN
  -- IRN 2888
  IF SYS_CONTEXT ('LOGINFO_CTX', 'SSOUSER') = 'ITNEW'
    AND SYS_CONTEXT ('LOGINFO_CTX', 'VLASNIKPODATKA') = pra_zmp_zaj.vrijednost_parametra ('0999')
  THEN
    RETURN;  -- izlaz iz trigera
  END IF;

  :NEW.id := pra_rec_zaj.sekvenca (:NEW.id);
  :NEW.dat_poc := TRUNC (:NEW.dat_poc);
  :NEW.dat_zav := TRUNC (:NEW.dat_zav);

  pra_trec_pon2_usl.provjeri_recpon2 (:NEW.recpon2_id);
  pra_trec_pon2_usl.puni_obr (
    :NEW.usl_id,
    :NEW.obr_zdana,
    :NEW.obr_smjesta,
    :NEW.obr_popusta1,
    :NEW.obr_popusta2,
    :NEW.obr_popusta3,
    :NEW.obr_popusta4,
    :NEW.obr_po_danu);

  IF :NEW.vpispz_id IS NULL OR :NEW.stopa_pdv IS NULL THEN
    -- Nedostaju podaci o porezu na dodanu vrijednost.
    pra_rec_zaj.vrati_poruku (-20494);
  END IF;

  -- IRN 4118
  FOR recpon2_c IN (SELECT so_id FROM trec_ponude2 WHERE id = :NEW.recpon2_id)
  LOOP
    pra_rec_s5.provjeri_recsousl (recpon2_c.so_id, :NEW.usl_id);
  END LOOP;

  pra_rec_zaj.upisi_audit (:NEW.unos_korisnik, :NEW.unos_dat, :NEW.izmjena_korisnik, :NEW.izmjena_dat);
END;
/
SHOW ERROR


PROMPT Creating Trigger 'BUR_TREC_PON2_USL'
CREATE OR REPLACE TRIGGER BUR_TREC_PON2_USL
 BEFORE UPDATE
 ON TREC_PON2_USL
 FOR EACH ROW
BEGIN
  :NEW.dat_poc := TRUNC (:NEW.dat_poc);
  :NEW.dat_zav := TRUNC (:NEW.dat_zav);

  -- Zabrani promjenu roditelja
  IF :NEW.recpon2_id <> :OLD.recpon2_id THEN 
    pra_rec_zaj.vrati_poruku (-20096);
  END IF;

  pra_trec_pon2_usl.provjeri_recpon2 (:NEW.recpon2_id);
  pra_trec_pon2_usl.puni_obr (
    :NEW.usl_id,
    :NEW.obr_zdana,
    :NEW.obr_smjesta,
    :NEW.obr_popusta1,
    :NEW.obr_popusta2,
    :NEW.obr_popusta3,
    :NEW.obr_popusta4,
    :NEW.obr_po_danu);

  IF :NEW.vpispz_id IS NULL OR :NEW.stopa_pdv IS NULL THEN
    -- Nedostaju podaci o porezu na dodanu vrijednost.
    pra_rec_zaj.vrati_poruku (-20494);
  END IF;

  -- IRN 4118
  IF :NEW.usl_id <> :OLD.usl_id THEN
    FOR recpon2_c IN (SELECT so_id FROM trec_ponude2 WHERE id = :NEW.recpon2_id)
    LOOP
      pra_rec_s5.provjeri_recsousl (recpon2_c.so_id, :NEW.usl_id);
    END LOOP;
  END IF;

  pra_rec_zaj.upisi_audit (:NEW.unos_korisnik, :NEW.unos_dat, :NEW.izmjena_korisnik, :NEW.izmjena_dat);
END;
/
SHOW ERROR
