-- C:\mish_cvs\misH_skripte\tpso_narudzbe.trg
--
-- Generated for Oracle 10g on Thu May 08  13:18:43 2025 by Server Generator 6.5.96.5.6
 
PROMPT Creating Trigger 'BIR_TPSO_NARUDZBE'
CREATE OR REPLACE TRIGGER BIR_TPSO_NARUDZBE
 BEFORE INSERT
 ON TPSO_NARUDZBE
 FOR EACH ROW
DECLARE


	kase_id_l mpso_lokacije.kase_id%TYPE;
BEGIN
	-- IRN 02888
	IF sys_context('LOGINFO_CTX', 'SSOUSER') = 'ITNEW'
		AND sys_context('LOGINFO_CTX', 'VLASNIKPODATKA') =
		pra_zmp_zaj.vrijednost_parametra('0999')
	THEN
		RETURN; -- izlaz iz trigera
	END IF;

	:new.id := gas_zaj.sekvenca(:new.id);

	pra_ozn_valjanosti.provjeri_ozn_valjanosti(NULL, :new.ozn_valjanosti);

	:new.datum := trunc(:new.datum);

	/* Datumi ne smiju biti manji od sistemskog */
	pra_pso_narudzbe.provjeri_datum(:new.datum);
	pra_pso_narudzbe.provjeri_datum(trunc(:new.vrijeme_isporuke));

	-- iz lokacije definira kasu za rbr
	SELECT t.kase_id
	  INTO kase_id_l
	  FROM mpso_lokacije t
	 WHERE t.id = :new.psolok_id;

    IF :NEW.rbr IS NULL THEN -- ako ne predaje rbr generira se iz brojaa
      pra_rbr.racunaj_novi_rbr_kase (
          :NEW.id, 'TPSO_NARUDZBE', :NEW.godina,
          kase_id_l, NULL,
          :NEW.ozn_valjanosti,:OLD.rbr, :NEW.rbr);
    END IF;
	gas_zaj.upisi_audit(:new.unos_korisnik,
							  :new.unos_dat,
							  :new.izmjena_korisnik,
							  :new.izmjena_dat);
END;
/
SHOW ERROR


PROMPT Creating Trigger 'BUR_TPSO_NARUDZBE'
CREATE OR REPLACE TRIGGER BUR_TPSO_NARUDZBE
 BEFORE UPDATE
 ON TPSO_NARUDZBE
 FOR EACH ROW
DECLARE


  kase_id_l mpso_lokacije.kase_id%TYPE;
BEGIN
  :NEW.datum := TRUNC (:NEW.datum);

  IF :NEW.datum <> :OLD.datum THEN
      pra_pso_narudzbe.provjeri_datum (:NEW.datum);
  END IF;

  IF :NEW.vrijeme_isporuke <> :OLD.vrijeme_isporuke THEN
    pra_pso_narudzbe.provjeri_datum(trunc(:NEW.vrijeme_isporuke));
  END IF; 

  pra_ozn_valjanosti.provjeri_ozn_valjanosti
    (:OLD.ozn_valjanosti, :NEW.ozn_valjanosti);

  -- iz lokacije definira kasu za rbr
  SELECT t.kase_id
    INTO kase_id_l
    FROM mpso_lokacije t
   WHERE t.id = :new.psolok_id;

  pra_rbr.racunaj_novi_rbr_kase (
      :NEW.id, 'TPSO_NARUDZBE', :NEW.godina,
      kase_id_l, NULL,
      :NEW.ozn_valjanosti,:OLD.rbr, :NEW.rbr);

  gas_zaj.upisi_audit (
    :NEW.unos_korisnik, :NEW.unos_dat,
    :NEW.izmjena_korisnik, :NEW.izmjena_dat);
END;
/
SHOW ERROR


PROMPT Creating Trigger 'AUR_TPSO_NARUDZBE'
CREATE OR REPLACE TRIGGER AUR_TPSO_NARUDZBE
 AFTER UPDATE
 ON TPSO_NARUDZBE
 FOR EACH ROW
BEGIN
 
   pra_pso_apex.pso_notifikacija(
    :new.id,
    :new.psolok_id,
    :new.datum_preuzimanja,
    :new.pos_broj,
    :new.br_sobe,
    :new.gost_id,
    :new.jez_id
  );
END;
/
SHOW ERROR





