-- C:\mish_cvs\misH_skripte\tmob_prijelaz.trg
--
-- Generated for Oracle 8 on Fri May 16  14:24:29 2025 by Server Generator 6.5.96.5.6
 

PROMPT Creating Trigger 'BIR_TMOB_PRIJELAZ'
CREATE OR REPLACE TRIGGER BIR_TMOB_PRIJELAZ
 BEFORE INSERT
 ON TMOB_PRIJELAZ
 FOR EACH ROW
BEGIN
  -- IRN 02888
  IF SYS_CONTEXT ('LOGINFO_CTX', 'SSOUSER') = 'ITNEW'
    AND SYS_CONTEXT ('LOGINFO_CTX', 'VLASNIKPODATKA') = pra_zmp_zaj.vrijednost_parametra ('0999')
  THEN
    RETURN;  -- izlaz iz trigera
  END IF;

  pra_ozn_valjanosti.provjeri_ozn_valjanosti
    (NULL, :NEW.ozn_valjanosti);

  :NEW.datum := TRUNC (:NEW.datum);
  :NEW.godina := to_char(:NEW.datum,'yyyy');

  :NEW.id := gas_zaj.sekvenca (:NEW.id);

  /*
  RBR davatelja rauna se samo ako je :NEW.rbr_daje IS NULL.
  Ako nije NULL, dobijen je sa centra ili drugog objekta, pa mora ostati isti.
  */
  IF :NEW.rbr_daje IS NULL THEN
    pra_rbr.racunaj_novi_rbr (
      :NEW.id, 'TMOB_PRIJELAZ_DAJE', :NEW.godina,
      :NEW.mt_id_daje, NULL,
      NULL, :NEW.ozn_valjanosti, :NEW.rbr_daje);
  END IF;

  pra_rbr.racunaj_novi_rbr (
    :NEW.id, 'TMOB_PRIJELAZ_PRIMA', :NEW.godina,
    :NEW.mt_id_prima, NULL,
    NULL, :NEW.ozn_valjanosti, :NEW.rbr_prima);

 
  gas_zaj.upisi_audit (
    :NEW.unos_korisnik, :NEW.unos_dat,
    :NEW.izmjena_korisnik, :NEW.izmjena_dat);
END;
/
SHOW ERROR


PROMPT Creating Trigger 'BUR_TMOB_PRIJELAZ'
CREATE OR REPLACE TRIGGER BUR_TMOB_PRIJELAZ
 BEFORE UPDATE
 ON TMOB_PRIJELAZ
 FOR EACH ROW
BEGIN
  :NEW.datum := TRUNC (:NEW.datum);
  IF :OLD.ozn_valjanosti IN ('V', 'P') AND TO_CHAR (:NEW.datum, 'YYYY') <> TO_CHAR (:OLD.datum, 'YYYY') THEN
     gas_zaj.vrati_poruku (-20311);
  END IF;

  pra_ozn_valjanosti.provjeri_ozn_valjanosti
   (:OLD.ozn_valjanosti, :NEW.ozn_valjanosti);

  pra_mt_id.provjeri_mt_id
    (:NEW.mt_id_daje, :OLD.mt_id_daje, :NEW.ozn_valjanosti);

  pra_mt_id.provjeri_mt_id
    (:NEW.mt_id_prima, :OLD.mt_id_prima,:NEW.ozn_valjanosti);

  pra_rbr.racunaj_novi_rbr (
    :NEW.id, 'TMOB_PRIJELAZ_DAJE', :NEW.godina,
    :NEW.mt_id_daje, NULL,
    :OLD.ozn_valjanosti, :NEW.ozn_valjanosti, :NEW.rbr_daje);

  pra_rbr.racunaj_novi_rbr (
    :NEW.id, 'TMOB_PRIJELAZ_PRIMA', :NEW.godina,
    :NEW.mt_id_prima, NULL,
    :OLD.ozn_valjanosti, :NEW.ozn_valjanosti, :NEW.rbr_prima);

  gas_zaj.upisi_audit (
    :NEW.unos_korisnik, :NEW.unos_dat,
    :NEW.izmjena_korisnik, :NEW.izmjena_dat);

END;
/
SHOW ERROR







