-- C:\Radni\t_rez_vsj.trg
--
-- Generated for Oracle 10g on Wed May 07  08:26:54 2025 by Server Generator 6.5.96.5.6
 







PROMPT Creating Trigger 'ADS_T_REZ_VSJ'
CREATE OR REPLACE TRIGGER ADS_T_REZ_VSJ
 AFTER DELETE
 ON T_REZ_VSJ
DECLARE

  zapis_l      tab_t_rez_vsj.rezvsj_rec_type;
  zapis_flex_l pra_flexkeeping.rezsj_rec_type;
  zapis_dom_l  pra_dom_api.rezsj_rec_type;
BEGIN

  tab_t_rez_vsj.postavi_iterator;
  WHILE tab_t_rez_vsj.ima_jos LOOP
    zapis_l := tab_t_rez_vsj.slijedeci_red;
    pra_t_rezervacije.brisi_recrezsj_za_sjs (zapis_l.rezvsj_id);
  END LOOP;

  -- IRN 3625
  tab_t_rez_vsj_flex.postavi_iterator;
  WHILE tab_t_rez_vsj_flex.ima_jos LOOP
    zapis_flex_l := tab_t_rez_vsj_flex.sljedeci_red;
    pra_flexkeeping.post_booking_rezsj (zapis_flex_l);
  END LOOP;

  -- IRN 3860
  tab_t_rez_vsj_dom.postavi_iterator;
  WHILE tab_t_rez_vsj_dom.ima_jos LOOP
    zapis_dom_l := tab_t_rez_vsj_dom.sljedeci_red;
    pra_dom_api.dom_post_booking_rezsj (zapis_dom_l, 'T_REZ_VSJ'); -- IRN 4030
  END LOOP;

END;
/
SHOW ERROR


PROMPT Creating Trigger 'AIS_T_REZ_VSJ'
CREATE OR REPLACE TRIGGER AIS_T_REZ_VSJ
 AFTER INSERT
 ON T_REZ_VSJ
DECLARE

  zapis_l      tab_t_rez_vsj.rezvsj_rec_type;
  zapis_flex_l pra_flexkeeping.rezsj_rec_type;
  zapis_dom_l  pra_dom_api.rezsj_rec_type;
BEGIN

  tab_t_rez_vsj.postavi_iterator;
  WHILE tab_t_rez_vsj.ima_jos LOOP
    zapis_l := tab_t_rez_vsj.slijedeci_red;

    pra_t_rezervacije.upisi_recrezsj_za_sjs (
      zapis_l.rezvsj_id,
      zapis_l.vsj_id,
      zapis_l.br_osoba,
      zapis_l.sj_id,
      zapis_l.ozn_fiksna_sj);

    pra_rez_rasporedi.puni_rezgost (
      zapis_l.rez_id,
      -1,
      zapis_l.rezvsj_id);
  END LOOP;

  -- IRN 3625
  tab_t_rez_vsj_flex.postavi_iterator;
  WHILE tab_t_rez_vsj_flex.ima_jos LOOP
    zapis_flex_l := tab_t_rez_vsj_flex.sljedeci_red;
    pra_flexkeeping.post_booking_rezsj (zapis_flex_l);
  END LOOP;

  -- IRN 3860
  tab_t_rez_vsj_dom.postavi_iterator;
  WHILE tab_t_rez_vsj_dom.ima_jos LOOP
    zapis_dom_l := tab_t_rez_vsj_dom.sljedeci_red;
    pra_dom_api.dom_post_booking_rezsj (zapis_dom_l, 'T_REZ_VSJ'); -- IRN 4030
  END LOOP;
END;
/
SHOW ERROR


PROMPT Creating Trigger 'ARL_T_REZ_VSJ'
CREATE OR REPLACE TRIGGER ARL_T_REZ_VSJ
 AFTER DELETE OR INSERT OR UPDATE
 ON T_REZ_VSJ
 FOR EACH ROW
BEGIN
  -- IRN 2888
  IF SYS_CONTEXT ('LOGINFO_CTX', 'SSOUSER') = 'ITNEW'
    AND SYS_CONTEXT ('LOGINFO_CTX', 'VLASNIKPODATKA') = pra_zmp_zaj.vrijednost_parametra ('0999')
  THEN
    RETURN;  -- izlaz iz trigera
  END IF;

  replikacija.napuni_tab (:OLD.id, :NEW.id);
END;
/
SHOW ERROR


PROMPT Creating Trigger 'ASL_T_REZ_VSJ'
CREATE OR REPLACE TRIGGER ASL_T_REZ_VSJ
 AFTER DELETE OR INSERT OR UPDATE
 ON T_REZ_VSJ
BEGIN
  replikacija.upisi_u_log (
    aplikacija_p => 'REC',
    tablica_p    => 'T_REZ_VSJ');
END;
/
SHOW ERROR


PROMPT Creating Trigger 'AUS_T_REZ_VSJ'
CREATE OR REPLACE TRIGGER AUS_T_REZ_VSJ
 AFTER UPDATE
 ON T_REZ_VSJ
DECLARE

  zapis_l       tab_t_rez_vsj.rezvsj_rec_type;
  zapis_flex_l  pra_flexkeeping.rezsj_rec_type;
  zapis_dom_l   pra_dom_api.rezsj_rec_type;

  dat_dolaska_l t_rezervacije.dat_dolaska%TYPE;
  dat_odlaska_l t_rezervacije.dat_odlaska%TYPE;
BEGIN

  tab_t_rez_vsj.postavi_iterator;
  WHILE tab_t_rez_vsj.ima_jos LOOP
    zapis_l := tab_t_rez_vsj.slijedeci_red;

    SELECT dat_dolaska, dat_odlaska
      INTO dat_dolaska_l, dat_odlaska_l
      FROM t_rezervacije
     WHERE id = zapis_l.rez_id;

    fm_rec2120.provjeri_status_sj (
      dat_dolaska_l,
      dat_odlaska_l,
      zapis_l.rezvsj_id,
      TO_NUMBER (NULL),
      zapis_l.sj_id);

    IF zapis_l.ozn_azuriranja = 'D' THEN
      pra_t_rezervacije.brisi_recrezsj_za_sjs (zapis_l.rezvsj_id);
    ELSIF zapis_l.ozn_azuriranja = 'I' THEN
      pra_t_rezervacije.upisi_recrezsj_za_sjs (
        zapis_l.rezvsj_id,
        zapis_l.vsj_id,
        zapis_l.br_osoba,
        zapis_l.sj_id,
        zapis_l.ozn_fiksna_sj);
      pra_rez_rasporedi.puni_rezgost (
        zapis_l.rez_id,
        -1,
        zapis_l.rezvsj_id);
    ELSIF zapis_l.ozn_azuriranja = 'A' THEN
      pra_t_rezervacije.brisi_recrezsj_za_sjs (zapis_l.rezvsj_id);
      pra_t_rezervacije.upisi_recrezsj_za_sjs (
        zapis_l.rezvsj_id,
        zapis_l.vsj_id,
        zapis_l.br_osoba,
        zapis_l.sj_id,
        zapis_l.ozn_fiksna_sj);
      pra_rez_rasporedi.puni_rezgost (
        zapis_l.rez_id,
        -1,
        zapis_l.rezvsj_id);
    ELSIF zapis_l.ozn_azuriranja = 'U' THEN
      pra_t_rezervacije.promijeni_recrezsj_za_sjs (
        zapis_l.rezvsj_id,
        zapis_l.vsj_id,
        zapis_l.br_osoba,
        zapis_l.sj_id,
        zapis_l.ozn_fiksna_sj);
    END IF;
  END LOOP;

  -- IRN 3625
  tab_t_rez_vsj_flex.postavi_iterator;
  WHILE tab_t_rez_vsj_flex.ima_jos LOOP
    zapis_flex_l := tab_t_rez_vsj_flex.sljedeci_red;
    pra_flexkeeping.post_booking_rezsj (zapis_flex_l);
    pra_rec_iud4.puni_pkaoba_overbooking ( -- IRN 3977
      zapis_flex_l.sj_id_old,
      zapis_flex_l.sj_id_new,
      zapis_flex_l.rez_row.rbr,
      zapis_flex_l.rez_row.god_poslovna,
      zapis_flex_l.rez_row.prezime,
      zapis_flex_l.rez_row.dat_dolaska,
      zapis_flex_l.rez_row.dat_odlaska);
  END LOOP;

  -- IRN 3860
  tab_t_rez_vsj_dom.postavi_iterator;
  WHILE tab_t_rez_vsj_dom.ima_jos LOOP
    zapis_dom_l := tab_t_rez_vsj_dom.sljedeci_red;
    pra_dom_api.dom_post_booking_rezsj (zapis_dom_l, 'T_REZ_VSJ'); -- IRN 4030
  END LOOP;
END;
/
SHOW ERROR


PROMPT Creating Trigger 'BDR_T_REZ_VSJ'
CREATE OR REPLACE TRIGGER BDR_T_REZ_VSJ
 BEFORE DELETE
 ON T_REZ_VSJ
 FOR EACH ROW
DECLARE

  rez_row_l    t_rezervacije%ROWTYPE;
  zapis_l      tab_t_rez_vsj.rezvsj_rec_type;
  zapis_flex_l pra_flexkeeping.rezsj_rec_type;
  zapis_dom_l  pra_dom_api.rezsj_rec_type;
BEGIN
  IF :OLD.kol_sj <> 0
    OR :OLD.br_osoba <> 0
    OR :OLD.sj_id IS NOT NULL
  THEN

    SELECT * INTO rez_row_l FROM t_rezervacije WHERE id = :OLD.rez_id;

    -- IRN 3625
    IF :OLD.sj_id IS NOT NULL THEN
      zapis_flex_l.rez_row := rez_row_l;
      zapis_flex_l.id := :OLD.id;
      zapis_flex_l.sj_id_old := :OLD.sj_id;
      zapis_flex_l.br_osoba := :OLD.br_osoba;
      tab_t_rez_vsj_flex.puni_tablicu (zapis_flex_l);

      -- IRN 3860
      zapis_dom_l.rez_row := rez_row_l;
      zapis_dom_l.id := :OLD.id;
      zapis_dom_l.sj_id_old := :OLD.sj_id;
      zapis_dom_l.br_osoba := :OLD.br_osoba;
      tab_t_rez_vsj_dom.puni_tablicu (zapis_dom_l);
    END IF;

    IF :OLD.kol_sj <> 0
      OR :OLD.br_osoba <> 0
    THEN
      /*
      Auriraj booking
      Napomena: booking se aurira za kol_sj jer ako je kol_sjZ <> 0
      onda je na taj redak vezan neki gost i redak se ne moe brisati
      */
      IF rez_row_l.ponso_id IS NOT NULL THEN
        -- Ako je rez vezana na ponso mora se aurirati booking C/W i to prema podacima iz rezvsj bez obzira na recrezsj i kol_sjz
        pra_t_rezervacije.azuriraj_book_rezvsj_cw (
          rez_row_l.oznaka,
          rez_row_l.ozn_vstorna,
          rez_row_l.so_id,
          rez_row_l.ms_id,
          rez_row_l.age_id,
          :OLD.vsj_id,
          rez_row_l.ponso_id,
          rez_row_l.recvpro_id,
          rez_row_l.dat_dolaska,
          rez_row_l.dat_odlaska,
          rez_row_l.ozn_B,
          rez_row_l.ozn_F,
          :OLD.kol_sj,
          :OLD.br_osoba,
          :OLD.vsjp_id,
          -1);  -- ozn_PlusMinus = oduzmi_booking
      END IF;
      pra_t_rezervacije.azuriraj_book_rezvsj_bxf (
        rez_row_l.oznaka,
        rez_row_l.ozn_vstorna,
        rez_row_l.so_id,
        rez_row_l.ms_id,
        rez_row_l.age_id,
        :OLD.vsj_id,
        rez_row_l.ponso_id,
        rez_row_l.recvpro_id,
        rez_row_l.dat_dolaska,
        rez_row_l.dat_odlaska,
        rez_row_l.ozn_B,
        rez_row_l.ozn_F,
        :OLD.kol_sj,
        :OLD.br_osoba,
        :OLD.sj_id,
        -1);  -- ozn_PlusMinus = dodaj_booking
    END IF;

    IF :OLD.sj_id IS NOT NULL THEN
      IF pra_zmp_s.vsj_je_sastavljena (:OLD.vsj_id) = 0 THEN
        -- Auriraj status SJ
        pra_t_rez_vsj.oduzmi_statussj (
          rez_row_l.oznaka,
          rez_row_l.ozn_vstorna,
          :OLD.sj_id,
          rez_row_l.dat_dolaska,
          rez_row_l.dat_odlaska,
          :OLD.br_osoba,
          :OLD.br_osobaz);

        -- Otkai najavu prema Key Card sustavu
        pra_rec_kc_iud.puni_kczah_rezvsj (
          rez_row_l.oznaka, rez_row_l.ozn_vstorna, :OLD.sj_id, 32, rez_row_l.dat_dolaska);
      ELSE
        zapis_l.rezvsj_id := :OLD.id;
        zapis_l.vsj_id := :OLD.vsj_id;
        zapis_l.ozn_azuriranja := 'D';
        tab_t_rez_vsj.puni_tablicu (zapis_l);
      END IF;
    END IF;

  END IF;
END;
/
SHOW ERROR


PROMPT Creating Trigger 'BDS_T_REZ_VSJ'
CREATE OR REPLACE TRIGGER BDS_T_REZ_VSJ
 BEFORE DELETE
 ON T_REZ_VSJ
BEGIN
  tab_t_rez_vsj.brisi_tablicu;
  tab_t_rez_vsj_flex.brisi_tablicu;
  tab_t_rez_vsj_dom.brisi_tablicu;
END;
/
SHOW ERROR


PROMPT Creating Trigger 'BIR_T_REZ_VSJ'
CREATE OR REPLACE TRIGGER BIR_T_REZ_VSJ
 BEFORE INSERT
 ON T_REZ_VSJ
 FOR EACH ROW
DECLARE

  rez_row_l t_rezervacije%ROWTYPE;

  ozn_sastavljena_new_l s_vsj.ozn_sastavljena%TYPE;
  tip_l NUMBER;

  zapis_l      tab_t_rez_vsj.rezvsj_rec_type;
  zapis_flex_l pra_flexkeeping.rezsj_rec_type;
  zapis_dom_l  pra_dom_api.rezsj_rec_type;
BEGIN
  -- IRN 2888
  IF SYS_CONTEXT ('LOGINFO_CTX', 'SSOUSER') = 'ITNEW'
    AND SYS_CONTEXT ('LOGINFO_CTX', 'VLASNIKPODATKA') = pra_zmp_zaj.vrijednost_parametra ('0999')
  THEN
    RETURN;  -- izlaz iz trigera
  END IF;

  :NEW.id := pra_rec_zaj.sekvenca (:NEW.id);

  pra_t_rez_vsj.provjeri_vsj (:NEW.rez_id, :NEW.vsj_id);
  pra_t_rez_vsj.provjeri_vsjc (:NEW.rez_id, :NEW.vsjc_id);
  pra_t_rez_vsj.provjeri_sj (:NEW.rez_id, :NEW.sj_id, :NEW.vsj_id, :NEW.id);

  ozn_sastavljena_new_l := pra_zmp_s.vsj_je_sastavljena (:NEW.vsj_id);
  IF ozn_sastavljena_new_l <> 0 AND :NEW.kol_sj <> 1 THEN
    -- Ako je VSJ sastavljena onda mora biti koliina SJ jednaka 1.
    pra_rec_zaj.vrati_poruku (-20634);
  END IF;

  IF :NEW.kol_sj <> 0
    OR :NEW.br_osoba <> 0
    OR :NEW.sj_id IS NOT NULL
  THEN
    SELECT * INTO rez_row_l FROM t_rezervacije WHERE id = :NEW.rez_id;
    -- IRN 3625
    IF :NEW.sj_id IS NOT NULL THEN
      zapis_flex_l.rez_row := rez_row_l;
      zapis_flex_l.id := :NEW.id;
      zapis_flex_l.sj_id_new := :NEW.sj_id;
      zapis_flex_l.br_osoba := :NEW.br_osoba;
      tab_t_rez_vsj_flex.puni_tablicu (zapis_flex_l);

      -- IRN 3860
      zapis_dom_l.rez_row := rez_row_l;
      zapis_dom_l.id := :NEW.id;
      zapis_dom_l.sj_id_new := :NEW.sj_id;
      zapis_dom_l.br_osoba := :NEW.br_osoba;
      tab_t_rez_vsj_dom.puni_tablicu (zapis_dom_l);

    END IF;
  END IF;

  /*
  Auriraj booking
  Napomena: kod unosa retka bi trebali biti kol_sjz i br_osobaZ NULL,
  oni se mogu aurirati samo preko gosta
  */
  IF :NEW.kol_sj <> 0
    OR :NEW.br_osoba <> 0
  THEN

    -- Ako je rez vezana na ponso mora se aurirati booking C/W i to prema podacima iz rezvsj bez obzira na recrezsj i kol_sjz
    IF rez_row_l.ponso_id IS NOT NULL THEN
      pra_t_rezervacije.azuriraj_book_rezvsj_cw (
        rez_row_l.oznaka,
        rez_row_l.ozn_vstorna,
        rez_row_l.so_id,
        rez_row_l.ms_id,
        rez_row_l.age_id,
        :NEW.vsj_id,
        rez_row_l.ponso_id,
        rez_row_l.recvpro_id,
        rez_row_l.dat_dolaska,
        rez_row_l.dat_odlaska,
        rez_row_l.ozn_B,
        rez_row_l.ozn_F,
        :NEW.kol_sj,
        :NEW.br_osoba,
        :NEW.vsjp_id,
        1);  -- ozn_PlusMinus = dodaj_booking
    END IF;

    pra_t_rezervacije.azuriraj_book_rezvsj_bxf (
      rez_row_l.oznaka,
      rez_row_l.ozn_vstorna,
      rez_row_l.so_id,
      rez_row_l.ms_id,
      rez_row_l.age_id,
      :NEW.vsj_id,
      rez_row_l.ponso_id,
      rez_row_l.recvpro_id,
      rez_row_l.dat_dolaska,
      rez_row_l.dat_odlaska,
      rez_row_l.ozn_B,
      rez_row_l.ozn_F,
      :NEW.kol_sj,
      :NEW.br_osoba,
      :NEW.sj_id,
      1);  -- ozn_PlusMinus = dodaj_booking

    /*
    ako je VSJ sastavljena i upisana SJ se booking aurira preko recrezsj,
    to se provjerava u samoj proceduri
    */

  END IF;

  IF :NEW.sj_id IS NOT NULL THEN
    IF ozn_sastavljena_new_L = 0 THEN
      -- za sastavljenu VSJ e se sve to raditi kod upisa u rezrezsj
      pra_t_rezervacije.provjeri_sj_zakupljena (
        rez_row_l.oznaka, rez_row_l.ozn_vstorna, :NEW.sj_id, rez_row_l.dat_dolaska, rez_row_l.dat_odlaska);
      fm_rec2120.provjeri_status_sj (
        rez_row_l.dat_dolaska, rez_row_l.dat_odlaska, :NEW.id, TO_NUMBER (NULL), :NEW.sj_id);

      SELECT DECODE (rez_row_l.ozn_F, 0, 1, 3) - NVL (:NEW.ozn_fiksna_sj, 0)
        INTO tip_l
        FROM dual;

      -- Auriraj status SJ
      pra_t_rez_vsj.dodaj_statussj (
        rez_row_l.oznaka,
        rez_row_l.ozn_vstorna,
        :NEW.sj_id,
        rez_row_l.dat_dolaska,
        rez_row_l.dat_odlaska,
        :NEW.br_osoba,
        :NEW.br_osobaZ,
        tip_l);

      -- Najavi dolazak prema Key Card sustavu
      IF (:NEW.kol_sj - NVL (:NEW.kol_sjz, 0)) > 0 THEN
        pra_rec_kc_iud.puni_kczah_rezvsj (
          rez_row_l.oznaka, rez_row_l.ozn_vstorna, :NEW.sj_id, 31, rez_row_l.dat_dolaska);
      END IF;
    ELSE
      -- za sastavljenu SJ e se u AIS-u kreirati recrezsj
      zapis_l.rez_id := :NEW.rez_id;
      zapis_l.rezvsj_id := :NEW.id;
      zapis_l.vsj_id := :NEW.vsj_id;
      zapis_l.br_osoba := :NEW.br_osoba;
      zapis_l.sj_id := :NEW.sj_id;
      zapis_l.ozn_fiksna_sj := :NEW.ozn_fiksna_sj;
      zapis_l.ozn_azuriranja := 'I';
      tab_t_rez_vsj.puni_tablicu (zapis_l);
    END IF;

    IF NVL (:NEW.ozn_fiksna_sj, 0) <> 0 THEN
      pra_t_rez_vsj.upisi_promjenu_zastite_sj (
        :NEW.rez_id,
        :NEW.vsj_id,
        :NEW.sj_id,
        :NEW.ozn_fiksna_sj);
    END IF;
  END IF;

  IF :NEW.sj_id IS NULL THEN  -- osobito zbog kopiranja
    :NEW.ozn_fiksna_sj := 0;
  END IF;

  pra_rec_zaj.upisi_audit (:NEW.unos_korisnik, :NEW.unos_dat, :NEW.izmjena_korisnik, :NEW.izmjena_dat);
END;
/
SHOW ERROR


PROMPT Creating Trigger 'BIS_T_REZ_VSJ'
CREATE OR REPLACE TRIGGER BIS_T_REZ_VSJ
 BEFORE INSERT
 ON T_REZ_VSJ
BEGIN
  tab_t_rez_vsj.brisi_tablicu;
  tab_t_rez_vsj_flex.brisi_tablicu;
  tab_t_rez_vsj_dom.brisi_tablicu;
END;
/
SHOW ERROR


PROMPT Creating Trigger 'BSL_T_REZ_VSJ'
CREATE OR REPLACE TRIGGER BSL_T_REZ_VSJ
 BEFORE DELETE OR INSERT OR UPDATE
 ON T_REZ_VSJ
BEGIN
  replikacija.brisi_tab;
END;
/
SHOW ERROR


PROMPT Creating Trigger 'BUR_T_REZ_VSJ'
CREATE OR REPLACE TRIGGER BUR_T_REZ_VSJ
 BEFORE UPDATE
 ON T_REZ_VSJ
 FOR EACH ROW
DECLARE

  rez_row_l t_rezervacije%ROWTYPE;

  ozn_sastavljena_old_l s_vsj.ozn_sastavljena%TYPE;
  ozn_sastavljena_new_l s_vsj.ozn_sastavljena%TYPE;
  tip_l NUMBER;

  zapis_l      tab_t_rez_vsj.rezvsj_rec_type;
  zapis_flex_l pra_flexkeeping.rezsj_rec_type;
  zapis_dom_l  pra_dom_api.rezsj_rec_type;
BEGIN
  IF :NEW.rez_id <> :OLD.rez_id THEN
    pra_rec_zaj.vrati_poruku (-20096);
  END IF;
  ozn_sastavljena_old_l := pra_zmp_s.vsj_je_sastavljena (:OLD.vsj_id);
  ozn_sastavljena_new_l := pra_zmp_s.vsj_je_sastavljena (:NEW.vsj_id);

  pra_t_rez_vsj.provjeri_br_osoba (:NEW.id, :NEW.vsj_id, :NEW.kol_sj, :NEW.br_osoba);
  pra_t_rez_vsj.provjeri_kol_sj (:NEW.id, :NEW.vsj_id, :NEW.kol_sj);
  IF ozn_sastavljena_new_l = 0 THEN
    pra_t_rez_vsj.provjeri_recrezsj (:NEW.id, :NEW.sj_id);
  ELSIF :NEW.kol_sj <> 1 THEN
    -- Ako je VSJ sastavljena onda mora biti koliina SJ jednaka 1.
    pra_rec_zaj.vrati_poruku (-20634);
  END IF;
  pra_t_rez_vsj.provjeri_vsj (:NEW.rez_id, :NEW.vsj_id);
  pra_t_rez_vsj.provjeri_vsjc (:NEW.rez_id, :NEW.vsjc_id);
  pra_t_rez_vsj.provjeri_sj (:NEW.rez_id, :NEW.sj_id, :NEW.vsj_id, :NEW.id);

  -- Ne moete promijeniti sastavljenu VSJ u nesastavljenu ili obrnuto ako je (ili je bila) upisana SJ. Briite SJ, spremite promjenu pa promijenite VSJ.
  pra_t_rez_vsj.provjeri_izmjenu_vsjs (:NEW.id, :OLD.sj_id, :NEW.sj_id, ozn_sastavljena_old_l, ozn_sastavljena_new_l);

  IF :NEW.ozn_fiksna_sj = -1 THEN
    IF :NEW.sj_id IS NULL THEN
      pra_rec_zaj.vrati_poruku (-20613);
    ELSIF :NEW.sj_id IS NOT NULL
      AND :OLD.ozn_fiksna_sj = -1
      AND :NEW.sj_id <> :OLD.sj_id
    THEN
      pra_rec_zaj.vrati_poruku (-20612);
    END IF;
  END IF;

  IF NVL (:NEW.ozn_fiksna_sj, 0) <> NVL (:OLD.ozn_fiksna_sj, 0) THEN
    pra_t_rez_vsj.upisi_promjenu_zastite_sj (
      :NEW.rez_id,
      :NEW.vsj_id,
      :NEW.sj_id,
      :NEW.ozn_fiksna_sj);
  END IF;

  IF :NEW.vsj_id <> :OLD.vsj_id
    OR :NEW.kol_sj <> :OLD.kol_sj
    OR :NEW.br_osoba <> :OLD.br_osoba
    OR NVL (:NEW.br_osobaZ, 0) <> NVL (:OLD.br_osobaZ, 0)
    OR NVL (:NEW.sj_id, 0) <> NVL (:OLD.sj_id, 0)
    OR NVL (:NEW.ozn_fiksna_sj, 0) <> NVL (:OLD.ozn_fiksna_sj, 0)
    OR NVL (:NEW.vsjp_id, 0) <> NVL (:OLD.vsjp_id, 0)
  THEN
    SELECT * INTO rez_row_l FROM t_rezervacije WHERE id = :NEW.rez_id;

    -- IRN 3625
    IF :NEW.br_osobaZ IS NULL
      AND (
          NVL (:NEW.sj_id, 0) <> NVL (:OLD.sj_id, 0)
          OR
          :NEW.br_osoba <> :OLD.br_osoba
          )
    THEN
      zapis_flex_l.rez_row := rez_row_l;
      zapis_flex_l.id := :NEW.id;
      zapis_flex_l.sj_id_new := :NEW.sj_id;
      zapis_flex_l.sj_id_old := :OLD.sj_id;
      zapis_flex_l.br_osoba := :NEW.br_osoba;
      tab_t_rez_vsj_flex.puni_tablicu (zapis_flex_l);

      -- IRN 3860
      zapis_dom_l.rez_row := rez_row_l;
      zapis_dom_l.id := :NEW.id;
      zapis_dom_l.sj_id_new := :NEW.sj_id;
      zapis_dom_l.sj_id_old := :OLD.sj_id;
      zapis_dom_l.br_osoba := :NEW.br_osoba;
      tab_t_rez_vsj_dom.puni_tablicu (zapis_dom_l);
    END IF;

    IF NVL (:NEW.sj_id, 0) <> NVL (:OLD.sj_id, 0)
    THEN
      IF :OLD.sj_id IS NOT NULL AND ozn_sastavljena_old_l = 0 THEN
        -- Otkai najavu prema Key Card sustavu
        pra_rec_kc_iud.puni_kczah_rezvsj (
          rez_row_l.oznaka, rez_row_l.ozn_vstorna, :OLD.sj_id, 32, rez_row_l.dat_dolaska);
      END IF;
      IF :NEW.sj_id IS NOT NULL AND ozn_sastavljena_new_l = 0 THEN
        pra_t_rezervacije.provjeri_sj_zakupljena (
          rez_row_l.oznaka, rez_row_l.ozn_vstorna, :NEW.sj_id, rez_row_l.dat_dolaska, rez_row_l.dat_odlaska);
        -- Najavi dolazak prema Key Card sustavu
        IF (:NEW.kol_sj - NVL (:NEW.kol_sjz, 0)) > 0 THEN
          pra_rec_kc_iud.puni_kczah_rezvsj (
            rez_row_l.oznaka, rez_row_l.ozn_vstorna, :NEW.sj_id, 31, rez_row_l.dat_dolaska);
        END IF;
      END IF;
    END IF;

    -- Auriraj booking
    DECLARE
      kol_sj_l   NUMBER := 0;
      br_osoba_l NUMBER := 0;
      kol_sj_rezsj_l   NUMBER := 0;
      br_osoba_rezsj_l NUMBER := 0;
      kol_sjz_rezsj_l   NUMBER := 0;
      br_osobaz_rezsj_l NUMBER := 0;
      CURSOR c IS
        SELECT SUM (1) kol_sj_rezsj,
               SUM (br_osoba) br_osoba,
               SUM (DECODE (NVL (br_osobaZ, 0), 0, 0, 1)) kol_sjz_rezsj,
               SUM (NVL (br_osobaZ, 0)) br_osobaz_rezsj
          FROM trec_rez_sj
         WHERE rezvsj_id = :NEW.id;
    BEGIN
      OPEN c;
      FETCH c INTO kol_sj_rezsj_l, br_osoba_rezsj_l, kol_sjz_rezsj_l, br_osobaz_rezsj_l;
      CLOSE c;

      -- Ako je rez vezana na ponso mora se aurirati booking C/W i to prema podacima iz rezvsj bez obzira na recrezsj i kol_sjz
      IF rez_row_l.ponso_id IS NOT NULL
        AND (NVL (:OLD.vsjp_id, :OLD.vsj_id) <> NVL (:NEW.vsjp_id, :NEW.vsj_id)
             OR :OLD.kol_sj <> :NEW.kol_sj OR :OLD.br_osoba <> :NEW.br_osoba)
      THEN
        pra_t_rezervacije.azuriraj_book_rezvsj_cw (
          rez_row_l.oznaka,
          rez_row_l.ozn_vstorna,
          rez_row_l.so_id,
          rez_row_l.ms_id,
          rez_row_l.age_id,
          :OLD.vsj_id,
          rez_row_l.ponso_id,
          rez_row_l.recvpro_id,
          rez_row_l.dat_dolaska,
          rez_row_l.dat_odlaska,
          rez_row_l.ozn_B,
          rez_row_l.ozn_F,
          :OLD.kol_sj,
          :OLD.br_osoba,
          :OLD.vsjp_id,
          -1);  -- ozn_PlusMinus = oduzmi_booking

        pra_t_rezervacije.azuriraj_book_rezvsj_cw (
          rez_row_l.oznaka,
          rez_row_l.ozn_vstorna,
          rez_row_l.so_id,
          rez_row_l.ms_id,
          rez_row_l.age_id,
          :NEW.vsj_id,
          rez_row_l.ponso_id,
          rez_row_l.recvpro_id,
          rez_row_l.dat_dolaska,
          rez_row_l.dat_odlaska,
          rez_row_l.ozn_B,
          rez_row_l.ozn_F,
          :NEW.kol_sj,
          :NEW.br_osoba,
          :NEW.vsjp_id,
          1);  -- ozn_PlusMinus = dodaj_booking
      END IF;

      IF :OLD.vsj_id <> :NEW.vsj_id
        OR NVL (:OLD.sj_id, 0) <> NVL (:NEW.sj_id, 0)
        OR :OLD.kol_sj <> :NEW.kol_sj
        OR :OLD.br_osoba <> :NEW.br_osoba
      THEN
        -- Tu se nita ne radi ako se mijenjao kol_sjz ili br_osobaz, to se rjeava zajedno sa upisom O(stvareno)
        -- Ne treba aurirati booking ako je vsj sastavljena i SJ upisana (jer se aurira preko recrezsj), to se kontrolira u proceduri
        -- Ako je vsj sastavljena ne smije se umanjivati rezvsj za recrezsj ( u BUR recrezsj ne moraju biti usklaene sa rezvsj jer e se uskladiti tek u AUS)
        IF ozn_sastavljena_old_l = 0 THEN
          kol_sj_l := GREATEST (:OLD.kol_sj - NVL (kol_sj_rezsj_l, 0) - (NVL (:OLD.kol_sjZ, 0) -   NVL (kol_sjZ_rezsj_l, 0)) , 0);
          br_osoba_l := GREATEST (:OLD.br_osoba - NVL (br_osoba_rezsj_l, 0) - (NVL (:OLD.br_osobaZ, 0)- NVL (br_osobaZ_rezsj_l, 0)), 0);
        ELSE
          kol_sj_l := GREATEST (:OLD.kol_sj - (NVL (:OLD.kol_sjZ, 0)) , 0);
          br_osoba_l := GREATEST (:OLD.br_osoba - (NVL (:OLD.br_osobaZ, 0)), 0);
        END IF;
        pra_t_rezervacije.azuriraj_book_rezvsj_bxf (
          rez_row_l.oznaka,
          rez_row_l.ozn_vstorna,
          rez_row_l.so_id,
          rez_row_l.ms_id,
          rez_row_l.age_id,
          :OLD.vsj_id,
          rez_row_l.ponso_id,
          rez_row_l.recvpro_id,
          rez_row_l.dat_dolaska,
          rez_row_l.dat_odlaska,
          rez_row_l.ozn_B,
          rez_row_l.ozn_F,
          -- uzimamo broj sj koje nisu u rezsj umanjen za broj zauzetih sj s time da ne smijemo oduzeti zauzete iz rezsj
          kol_sj_l, -- GREATEST (:OLD.kol_sj - NVL (kol_sj_rezsj_l, 0) - (NVL (:OLD.kol_sjZ, 0) -   NVL (kol_sjZ_rezsj_l, 0)) , 0),
          br_osoba_l, -- GREATEST (:OLD.br_osoba - NVL (br_osoba_rezsj_l, 0) - (NVL (:OLD.br_osobaZ, 0)- NVL (br_osobaZ_rezsj_l, 0)), 0),
          :OLD.sj_id,
          -1);  -- ozn_PlusMinus = oduzmi_booking

        IF ozn_sastavljena_new_l = 0 THEN
          kol_sj_l := GREATEST (:NEW.kol_sj - NVL (kol_sj_rezsj_l, 0) - (NVL (:NEW.kol_sjZ, 0) -   NVL (kol_sjZ_rezsj_l, 0)) , 0);
          br_osoba_l := GREATEST (:NEW.br_osoba - NVL (br_osoba_rezsj_l, 0) - (NVL (:NEW.br_osobaZ, 0)- NVL (br_osobaZ_rezsj_l, 0)), 0);
        ELSE
          kol_sj_l := GREATEST (:NEW.kol_sj - (NVL (:NEW.kol_sjZ, 0)) , 0);
          br_osoba_l := GREATEST (:NEW.br_osoba - (NVL (:NEW.br_osobaZ, 0)), 0);
        END IF;
        pra_t_rezervacije.azuriraj_book_rezvsj_bxf (
          rez_row_l.oznaka,
          rez_row_l.ozn_vstorna,
          rez_row_l.so_id,
          rez_row_l.ms_id,
          rez_row_l.age_id,
          :NEW.vsj_id,
          rez_row_l.ponso_id,
          rez_row_l.recvpro_id,
          rez_row_l.dat_dolaska,
          rez_row_l.dat_odlaska,
          rez_row_l.ozn_B,
          rez_row_l.ozn_F,
          -- uzimamo broj sj koje nisu u rezsj umanjen za broj zauzetih sj s time da ne smijemo oduzeti zauzete iz rezsj
          kol_sj_l, -- GREATEST (:NEW.kol_sj - NVL (kol_sj_rezsj_l, 0) - (NVL (:NEW.kol_sjZ, 0) -   NVL (kol_sjZ_rezsj_l, 0)) , 0),
          br_osoba_l, -- GREATEST (:NEW.br_osoba - NVL (br_osoba_rezsj_l, 0) - (NVL (:NEW.br_osobaZ, 0)- NVL (br_osobaZ_rezsj_l, 0)), 0),
          :NEW.sj_id,
          1);  -- ozn_PlusMinus = dodaj_booking
      END IF;
    END;
    -- kraj auriranja bookinga

    /*
    Auriraj status SJ (na nain makni staro, stavi novo):
    - kod promjene SJ, oznake fiksna sj
    - ako se mijenja odnos u broju osoba koje su rezervirale i koje su ve zauzele SJ (kada se smjeste sve
      rezervirane osobe treba maknuti ozn_R)
    - za sastavljene SJ ide auriranje preko recrezsj
    */

    IF ozn_sastavljena_old_l = 0 THEN -- ozn_sastavljena se nije mogla mijenjati ako je old ili new sj upisana pa provjera moe biti preko old
      IF NVL (:NEW.sj_id, 0) <> NVL (:OLD.sj_id, 0)
        OR NVL (:NEW.ozn_fiksna_sj, 0) <> NVL (:OLD.ozn_fiksna_sj, 0)
        OR (:OLD.br_osoba - NVL (:OLD.br_osobaZ, 0) = 0 AND :NEW.br_osoba - NVL (:NEW.br_osobaZ, 0) <> 0)
        OR (:OLD.br_osoba - NVL (:OLD.br_osobaZ, 0) <> 0 AND :NEW.br_osoba - NVL (:NEW.br_osobaZ, 0) = 0)
      THEN
        IF :OLD.sj_id IS NOT NULL THEN
          pra_t_rez_vsj.oduzmi_statussj (
            rez_row_l.oznaka,
            rez_row_l.ozn_vstorna,
            :OLD.sj_id,
            rez_row_l.dat_dolaska,
            rez_row_l.dat_odlaska,
            :OLD.br_osoba,
            :OLD.br_osobaZ);
        END IF;
        IF :NEW.sj_id IS NOT NULL THEN
          SELECT DECODE (rez_row_l.ozn_F, 0, 1, 3) - NVL (:NEW.ozn_fiksna_sj, 0)
            INTO tip_l
            FROM dual;
          pra_t_rez_vsj.dodaj_statussj (
            rez_row_l.oznaka,
            rez_row_l.ozn_vstorna,
            :NEW.sj_id,
            rez_row_l.dat_dolaska,
            rez_row_l.dat_odlaska,
            :NEW.br_osoba,
            :NEW.br_osobaZ,
            tip_l);
        END IF;
      END IF;
    ELSE -- ozn_sastavljena <> 0
      -- status e se aurirati iz recrezsj, ovdje se treba pobrinuti da se promjena odrazi na recrezsj
      -- posebno se obrauje promjena SJ koja uzrokuje brisanje iz recrezsj i ostale promjene koje auriraju recrezsj
      IF :OLD.sj_id IS NULL AND :NEW.sj_id IS NULL THEN
        NULL;
      ELSIF :OLD.sj_id IS NOT NULL AND :NEW.sj_id IS NULL THEN
        -- u AUS-u brisati recrezsj i time status
        zapis_l.rez_id := :OLD.rez_id;
        zapis_l.rezvsj_id := :OLD.id;
        zapis_l.ozn_azuriranja := 'D';
        tab_t_rez_vsj.puni_tablicu (zapis_l);
      ELSIF :OLD.sj_id IS NULL AND :NEW.sj_id IS NOT NULL THEN
        -- za sastavljenu SJ e se u AUS-u kreirati recrezsj
        zapis_l.rez_id := :NEW.rez_id;
        zapis_l.rezvsj_id := :NEW.id;
        zapis_l.vsj_id := :NEW.vsj_id;
        zapis_l.br_osoba := :NEW.br_osoba;
        zapis_l.sj_id := :NEW.sj_id;
        zapis_l.ozn_fiksna_sj := :NEW.ozn_fiksna_sj;
        zapis_l.ozn_azuriranja := 'I';
        tab_t_rez_vsj.puni_tablicu (zapis_l);
      ELSIF :OLD.sj_id <> :NEW.sj_id THEN
        -- U AUS-u e se brisati recrezsj za rezvsj i kreirati za novu SJ
        zapis_l.rez_id := :NEW.rez_id;
        zapis_l.rezvsj_id := :NEW.id;
        zapis_l.vsj_id := :NEW.vsj_id;
        zapis_l.br_osoba := :NEW.br_osoba;
        zapis_l.sj_id := :NEW.sj_id;
        zapis_l.ozn_fiksna_sj := :NEW.ozn_fiksna_sj;
        zapis_l.ozn_azuriranja := 'A';
        tab_t_rez_vsj.puni_tablicu (zapis_l);
      -- ELSIF  :OLD.sj_id = :NEW.sj_id AND
      ELSIF :NEW.br_osoba <> :OLD.br_osoba OR :NEW.ozn_fiksna_sj <> :OLD.ozn_fiksna_sj THEN
        zapis_l.rez_id := :NEW.rez_id;
        zapis_l.rezvsj_id := :NEW.id;
        zapis_l.vsj_id := :NEW.vsj_id;
        zapis_l.br_osoba := :NEW.br_osoba;
        zapis_l.sj_id := :NEW.sj_id;
        zapis_l.ozn_fiksna_sj := :NEW.ozn_fiksna_sj;
        zapis_l.ozn_azuriranja := 'U';
        tab_t_rez_vsj.puni_tablicu (zapis_l);
      END IF;
    END IF;
    -- kraj auriranja statusa SJ
  END IF;

  pra_rec_zaj.upisi_audit (:NEW.unos_korisnik, :NEW.unos_dat, :NEW.izmjena_korisnik, :NEW.izmjena_dat);
END;
/
SHOW ERROR


PROMPT Creating Trigger 'BUS_T_REZ_VSJ'
CREATE OR REPLACE TRIGGER BUS_T_REZ_VSJ
 BEFORE UPDATE
 ON T_REZ_VSJ
BEGIN
  tab_t_rez_vsj.brisi_tablicu;
  tab_t_rez_vsj_flex.brisi_tablicu;
  tab_t_rez_vsj_dom.brisi_tablicu;
END;
/
SHOW ERROR





