PROMPT Creating Trigger 'ARL_T_REZ_USL'
CREATE OR REPLACE TRIGGER ARL_T_REZ_USL
 AFTER DELETE OR INSERT OR UPDATE
 ON T_REZ_USL
 FOR EACH ROW
BEGIN
  -- IRN 2888
  IF SYS_CONTEXT ('LOGINFO_CTX', 'SSOUSER') = 'ITNEW'
    AND SYS_CONTEXT ('LOGINFO_CTX', 'VLASNIKPODATKA') = pra_zmp_zaj.vrijednost_parametra ('0999')
  THEN
    RETURN;  -- izlaz iz trigera
  END IF;

  replikacija4.napuni_tab (:OLD.id, :NEW.id);
END;
/
SHOW ERROR


PROMPT Creating Trigger 'ASL_T_REZ_USL'
CREATE OR REPLACE TRIGGER ASL_T_REZ_USL
 AFTER DELETE OR INSERT OR UPDATE
 ON T_REZ_USL
BEGIN
  replikacija4.upisi_u_log (
    aplikacija_p => 'REC',
    tablica_p    => 'T_REZ_USL');
END;
/
SHOW ERROR


PROMPT Creating Trigger 'BIR_T_REZ_USL'
CREATE OR REPLACE TRIGGER BIR_T_REZ_USL
 BEFORE INSERT
 ON T_REZ_USL
 FOR EACH ROW
BEGIN
  -- IRN 2888
  IF SYS_CONTEXT ('LOGINFO_CTX', 'SSOUSER') = 'ITNEW'
    AND SYS_CONTEXT ('LOGINFO_CTX', 'VLASNIKPODATKA') = pra_zmp_zaj.vrijednost_parametra ('0999')
  THEN
    RETURN;  -- izlaz iz trigera
  END IF;

  :NEW.id := pra_zmp_zaj.i3_sekvenca (:NEW.id);

  :NEW.dat_poc := TRUNC (:NEW.dat_poc);
  :NEW.dat_zav := TRUNC (:NEW.dat_zav);

  FOR rez_c IN ( -- IRN 3332
    SELECT dat_dolaska, dat_odlaska, ponso_id, so_id
      FROM t_rezervacije
     WHERE id = :NEW.rez_id)
  LOOP
    IF :NEW.dat_poc IS NOT NULL
      AND :NEW.dat_poc NOT BETWEEN rez_c.dat_dolaska AND rez_c.dat_odlaska
    THEN
      -- Poetak usluge ne moe biti izvan razdoblja boravka.
      pra_rec_zaj.vrati_poruku (-20030);
    END IF;
    IF :NEW.dat_zav IS NOT NULL
      AND :NEW.dat_zav NOT BETWEEN rez_c.dat_dolaska AND rez_c.dat_odlaska
    THEN
      -- Zavretak usluge ne moe biti izvan razdoblja boravka.
      pra_rec_zaj.vrati_poruku (-20031);
    END IF;
    IF :NEW.ozn_ugo IN (-1)
      AND pra_rec_s4.usl_je_ponudena (rez_c.ponso_id, :NEW.usl_id) = 0
    THEN
      -- Usluga nije vezana za rezerviranu ponudu/ugovor.
      pra_rec_zaj.vrati_poruku (-20655);
    END IF;
    pra_rec_s5.provjeri_recsousl (rez_c.so_id, :NEW.usl_id); -- IRN 4118
  END LOOP;

  pra_rec.provjeri_sastojak (:NEW.usl_id, :NEW.sas_id);
  pra_rec_s2.provjeri_usl_ara (:NEW.usl_id, :NEW.recara_id);

  pra_rec_zaj.upisi_audit (:NEW.unos_korisnik, :NEW.unos_dat, :NEW.izmjena_korisnik, :NEW.izmjena_dat);
END;
/
SHOW ERROR


PROMPT Creating Trigger 'BSL_T_REZ_USL'
CREATE OR REPLACE TRIGGER BSL_T_REZ_USL
 BEFORE DELETE OR INSERT OR UPDATE
 ON T_REZ_USL
BEGIN
  replikacija4.brisi_tab;
END;
/
SHOW ERROR


PROMPT Creating Trigger 'BUR_T_REZ_USL'
CREATE OR REPLACE TRIGGER BUR_T_REZ_USL
 BEFORE UPDATE
 ON T_REZ_USL
 FOR EACH ROW
BEGIN
  :NEW.dat_poc := TRUNC (:NEW.dat_poc);
  :NEW.dat_zav := TRUNC (:NEW.dat_zav);

  IF :NEW.rez_id <> :OLD.rez_id THEN
    pra_rec_zaj.vrati_poruku (-20096);
  END IF;

  FOR rez_c IN ( -- IRN 3332
    SELECT dat_dolaska, dat_odlaska, ponso_id, so_id
      FROM t_rezervacije
     WHERE id = :NEW.rez_id)
  LOOP
    IF :NEW.dat_poc IS NOT NULL
      AND :NEW.dat_poc NOT BETWEEN rez_c.dat_dolaska AND rez_c.dat_odlaska
    THEN
      -- Poetak usluge ne moe biti izvan razdoblja boravka.
      pra_rec_zaj.vrati_poruku (-20030);
    END IF;
    IF :NEW.dat_zav IS NOT NULL
      AND :NEW.dat_zav NOT BETWEEN rez_c.dat_dolaska AND rez_c.dat_odlaska
    THEN
      -- Zavretak usluge ne moe biti izvan razdoblja boravka.
      pra_rec_zaj.vrati_poruku (-20031);
    END IF;
    IF :NEW.ozn_ugo IN (-1)
      AND pra_rec_s4.usl_je_ponudena (rez_c.ponso_id, :NEW.usl_id) = 0
    THEN
      -- Usluga nije vezana za rezerviranu ponudu/ugovor.
      pra_rec_zaj.vrati_poruku (-20655);
    END IF;
    -- IRN 4118
    IF :NEW.usl_id <> :OLD.usl_id THEN 
      pra_rec_s5.provjeri_recsousl (rez_c.so_id, :NEW.usl_id);
    END IF;
  END LOOP;

  pra_rec.provjeri_sastojak (:NEW.usl_id, :NEW.sas_id);
  pra_rec_s2.provjeri_usl_ara (:NEW.usl_id, :NEW.recara_id);

  pra_rec_zaj.upisi_audit (:NEW.unos_korisnik, :NEW.unos_dat, :NEW.izmjena_korisnik, :NEW.izmjena_dat);
END;
/
SHOW ERROR
