-- C:\Radni\t_racuni.trg
--
-- Generated for Oracle 10g on Fri Oct 03  09:32:03 2025 by Server Generator 6.5.96.5.6
 





































PROMPT Creating Trigger 'AUS_T_RACUNI'
CREATE OR REPLACE TRIGGER AUS_T_RACUNI
 AFTER UPDATE
 ON T_RACUNI
DECLARE

  zapis_l tab_t_racuni.rac_rec_type;
BEGIN
  -- ponitavanje rauna
  tab_t_racuni.postavi_iterator;
  WHILE tab_t_racuni.ima_jos LOOP
    zapis_l := tab_t_racuni.sljedeci_red;
    IF zapis_l.oznaka_old = 'V' AND zapis_l.oznaka_new = 'P' THEN
      pra_t_racuni.ponisti_racun (zapis_l.id);
    END IF;
    -- IRN 3184
    IF zapis_l.vapldok_id_old <> zapis_l.vapldok_id_new
      AND pra_rec2.racun_je_u_pripremi (zapis_l.vapldok_id_old) = -1
    THEN
      FOR racpred_c IN (
        SELECT pkaracp_id, iznos
          FROM t_rac_pred
         WHERE rac_id = zapis_l.id)
      LOOP 
        pra_tpka_racuni.izradi_iskoristeni_predujam (
          racpred_c.pkaracp_id,
          zapis_l.id,
          NULL,
          racpred_c.iznos,
          zapis_l.datum);
      END LOOP;
    END IF;
  END LOOP;
END;
/
SHOW ERROR


PROMPT Creating Trigger 'BIR_T_RACUNI'
CREATE OR REPLACE TRIGGER BIR_T_RACUNI
 BEFORE INSERT
 ON T_RACUNI
 FOR EACH ROW
DECLARE
 
  dat_erac_obveze_l DATE := pra_zmp_s.dat_erac_obveze; -- IRN 4098
BEGIN
  IF SYS_CONTEXT ('LOGINFO_CTX', 'SSOUSER') = 'ITNEW'
    AND SYS_CONTEXT ('LOGINFO_CTX', 'VLASNIKPODATKA') = pra_zmp_zaj.vrijednost_parametra ('0999')
  THEN
    RETURN; -- izlaz iz trigera
  END IF;

  :NEW.id := pra_rec_zaj.sekvenca (:NEW.id);

  :NEW.datum := TRUNC (:NEW.datum);
  pra_t_racuni.provjeri_rac_datum (:NEW.vapldok_id, :NEW.datum, NULL); -- IRN 1846
  pra_pka_s.provjeri_dat_zabranjen (:NEW.oj_id, 'T_RACUNI', :NEW.datum); -- IRN 3561
  -- IRN 3565; Datum dokumenta na arhivskoj shemi mora biti manji od datuma primjene domae valute.
  pra_pka_domval.provjeri_arh_datum (:NEW.datum);

  :NEW.dat_pripreme := TRUNC (:NEW.dat_pripreme);
  :NEW.dat_dospijeca := TRUNC (:NEW.dat_dospijeca);
  :NEW.ozn_valjanosti := UPPER (:NEW.ozn_valjanosti);
  pra_rec_zaj.upisi_audit (:NEW.unos_korisnik, :NEW.unos_dat, :NEW.izmjena_korisnik, :NEW.izmjena_dat); -- IRN 4098
  :NEW.god_poslovna := TO_CHAR (:NEW.unos_dat, 'RRRR'); -- IRN 4098

  pra_zmp.vrati_vdok (:NEW.vapldok_id, :NEW.unos_dat, :NEW.vdok_id, :NEW.vdok_sifra2N, dat_erac_obveze_l); -- IRN 2439, IRN 4098
  :NEW.oj_sifra := pra_zmp.oj_sifra (:NEW.oj_id);

  pra_rec.provjeri_na_dat_zurnala (:NEW.datum, :NEW.so_id);
  pra_t_racuni.provjeri_valjanost_zakupa (:NEW.oznaka, :NEW.zak_id);

  pra_rec.izracunaj_redni_broj (
    'T_RACUNI',
    :NEW.god_poslovna,
    :NEW.oj_id,
    :NEW.vdok_id,  -- IRN 2439
    6,
    :NEW.rbr);

  :NEW.guid := pra_zmp_zaj.formatted_guid (:NEW.guid);

  -- Raun u pripremi ne moe biti poniten
  IF pra_rec2.racun_je_u_pripremi (:NEW.vapldok_id) = '-1'
    AND :NEW.oznaka <> 'V'
  THEN
    -- Nedoputena tranzicija oznake dokumenata
    pra_rec_zaj.vrati_poruku (-20056);
  END IF;

  :NEW.poziv_na_broj := pra_t_racuni.poziv_na_broj ( -- IRN 2439
    :NEW.oj_sifra,
    :NEW.vdok_id,
    :NEW.vdok_sifra2N,
    :NEW.age_id,
    :NEW.agep_id,
    :NEW.vpdog_id,
    :NEW.god_poslovna,
    :NEW.rbr);

  pra_t_racuni.provjeri_bezgotovinski_racun (
    :NEW.vapldok_id,
    :NEW.dat_dospijeca,
    :NEW.urac_id);

  pra_t_racuni.upisi_promjenu_datuma (
    :NEW.god_poslovna,
    :NEW.oj_id,
    NULL, -- :OLD.vapldok_id
    :NEW.vapldok_id,
    :NEW.rbr,
    NULL, -- :OLD.datum
    :NEW.datum);

END;
/
SHOW ERROR


PROMPT Creating Trigger 'BUR_T_RACUNI'
CREATE OR REPLACE TRIGGER BUR_T_RACUNI
 BEFORE UPDATE
 ON T_RACUNI
 FOR EACH ROW
DECLARE

  zapis_l tab_t_racuni.rac_rec_type;
BEGIN
  :NEW.datum := TRUNC (:NEW.datum);
  pra_t_racuni.provjeri_rac_datum (:OLD.vapldok_id, :NEW.datum, :OLD.datum); -- IRN 1846

  -- IRN 3561
  pra_pka_s.provjeri_dat_zabranjen (:OLD.oj_id, 'T_RACUNI', :OLD.datum);
  pra_pka_s.provjeri_dat_zabranjen (:NEW.oj_id, 'T_RACUNI', :NEW.datum);

  :NEW.dat_pripreme := TRUNC (:NEW.dat_pripreme);
  :NEW.dat_dospijeca := TRUNC (:NEW.dat_dospijeca);
  :NEW.ozn_valjanosti := UPPER (:NEW.ozn_valjanosti);

  -- Zabrani izmjenu UK osim kod prelaska RP u dokument kada treba izraunati novi rbr i popuniti vdok i oj_sifru
  pra_t_racuni.zabrani_izmjenu_uk (
    :OLD.god_poslovna,
    :OLD.oj_id,
    :OLD.vapldok_id,
    :OLD.rbr,
    :NEW.datum,
    :NEW.god_poslovna,
    :NEW.oj_id,
    :NEW.vapldok_id,
    :NEW.rbr,
    :NEW.vdok_id,
    :NEW.vdok_sifra2N,
    :NEW.oj_sifra);

  /*
  30.01.2008 MK
  Raun u pripremi ne moe biti P(oniten) niti N(ovi)
  niti se moe u istom koraku pretvoriti u neRP i ponititi.
  */
  IF (pra_rec2.racun_je_u_pripremi (:OLD.vapldok_id) = '-1'
      OR pra_rec2.racun_je_u_pripremi (:NEW.vapldok_id) = '-1')
    AND :NEW.oznaka <> 'V'
  THEN
    -- Nedoputena tranzicija oznake dokumenata
    pra_rec_zaj.vrati_poruku (-20056);
  END IF;

  IF (pra_rec2.racun_je_u_pripremi (:OLD.vapldok_id) = '-1'
      AND pra_rec2.racun_je_u_pripremi (:NEW.vapldok_id) <> '-1')
    OR NVL (:OLD.agep_id, -1) <> NVL (:NEW.agep_id, -1)
  THEN
    :NEW.poziv_na_broj := pra_t_racuni.poziv_na_broj ( -- IRN 2439
      :NEW.oj_sifra,
      :NEW.vdok_id,
      :NEW.vdok_sifra2N,
      :NEW.age_id,
      :NEW.agep_id,
      :NEW.vpdog_id,
      :NEW.god_poslovna,
      :NEW.rbr);
  END IF;

  pra_t_racuni.provjeri_na_dat_zurnala (:OLD.vapldok_id, :NEW.vapldok_id, :NEW.datum, :NEW.so_id);
  pra_t_racuni.zabrani_izmjenu_racuna (:OLD.oznaka);
  pra_t_racuni.provjeri_pkaobr (:NEW.id, :NEW.oznaka);
  pra_t_racuni.provjeri_valjanost_zakupa (:NEW.oznaka, :NEW.zak_id);
  pra_t_racuni.provjeri_bezgotovinski_racun (:NEW.vapldok_id, :NEW.dat_dospijeca, :NEW.urac_id);
  IF :NEW.oznaka = 'V' THEN -- IRN 3544
    pra_t_racuni.provjeri_racnap (:OLD.id, :NEW.vapldok_id, :NEW.oj_id); -- 20.02.2007. G.J.
  END IF;
  IF NVL (:NEW.zak_id, 0) <> NVL (:OLD.zak_id, 0) THEN -- IRN 1861
    pra_t_racuni.provjeri_tro_zak_id (:NEW.id, :NEW.zak_id);
  END IF;

  pra_t_racuni.upisi_promjenu_datuma (
    :NEW.god_poslovna,
    :NEW.oj_id,
    :OLD.vapldok_id,
    :NEW.vapldok_id,
    :NEW.rbr,
    :OLD.datum,
    :NEW.datum);

  /*
  puni PL/SQL tablicu za ponitavanje rauna i
  izradu rauna za iskoriteni predujam
  */
  zapis_l.id := :NEW.id;
  zapis_l.oznaka_new := :NEW.oznaka;
  zapis_l.oznaka_old := :OLD.oznaka;
  -- IRN 3184
  zapis_l.vapldok_id_new := :NEW.vapldok_id;
  zapis_l.vapldok_id_old := :OLD.vapldok_id;
  zapis_l.datum := :NEW.datum;
  tab_t_racuni.puni_tablicu (zapis_l);

  IF :NEW.vapldok_id <> :OLD.vapldok_id
    AND :NEW.unos_korisnik <> 'IT_API'
  THEN
    :NEW.unos_korisnik := NULL;
    :NEW.unos_dat := NULL;
  END IF;

  pra_rec_zaj.upisi_audit (:NEW.unos_korisnik, :NEW.unos_dat, :NEW.izmjena_korisnik, :NEW.izmjena_dat);
END;
/
SHOW ERROR


PROMPT Creating Trigger 'BUS_T_RACUNI'
CREATE OR REPLACE TRIGGER BUS_T_RACUNI
 BEFORE UPDATE
 ON T_RACUNI
BEGIN
  tab_t_racuni.brisi_tablicu;
END;
/
SHOW ERROR







