PROMPT Creating Trigger 'AIS_T_PON_SOUSL'
CREATE OR REPLACE TRIGGER AIS_T_PON_SOUSL
 AFTER INSERT
 ON T_PON_SOUSL
DECLARE

  zapis_l tab_t_pon_sousl.pon_sousl_rec_type;
BEGIN
  tab_t_pon_sousl.postavi_iterator;
  WHILE tab_t_pon_sousl.ima_jos LOOP
    zapis_l := tab_t_pon_sousl.slijedeci_red;
    pra_t_pon_sousl.provjeri_razdoblje (
      zapis_l.ponso_id,
      zapis_l.usl_id,
      zapis_l.recara_id,
      zapis_l.usl_id1,
      TRUNC (zapis_l.dat_poc),
      TRUNC (zapis_l.dat_zav));
  END LOOP;
END;
/
SHOW ERROR


PROMPT Creating Trigger 'AR_T_PON_SOUSL'
CREATE OR REPLACE TRIGGER AR_T_PON_SOUSL
 AFTER DELETE OR INSERT OR UPDATE
 ON T_PON_SOUSL
 FOR EACH ROW
DECLARE

  ponso_id_l t_ponude.id%TYPE;
  pon_id_l   t_ponude.id%TYPE;
BEGIN
  /* Samo centar aurira po mrei */
  IF pra_zmp_zaj.centar = 0 THEN
    RETURN;
  END IF;

  IF INSERTING THEN
    ponso_id_l := :NEW.ponso_id;
  ELSE
    ponso_id_l := :OLD.ponso_id;
  END IF;

  SELECT pon_id INTO pon_id_l
    FROM t_pon_ojr
   WHERE id = (SELECT ponojr_id FROM t_pon_so WHERE id = ponso_id_l);

  IF replikacija.ponuda_provjerena (pon_id_l) THEN
    replikacija.napuni_tab (:OLD.id, :NEW.id);
  END IF;
END;
/
SHOW ERROR


PROMPT Creating Trigger 'AS_T_PON_SOUSL'
CREATE OR REPLACE TRIGGER AS_T_PON_SOUSL
 AFTER DELETE OR INSERT OR UPDATE
 ON T_PON_SOUSL
BEGIN
  replikacija.azuriraj_retke (
    aplikacija_p => 'REC',
    tablica_p    => 'T_PON_SOUSL');
END;
/
SHOW ERROR


PROMPT Creating Trigger 'AUS_T_PON_SOUSL'
CREATE OR REPLACE TRIGGER AUS_T_PON_SOUSL
 AFTER UPDATE
 ON T_PON_SOUSL
DECLARE

  zapis_l tab_t_pon_sousl.pon_sousl_rec_type;
BEGIN
  tab_t_pon_sousl.postavi_iterator;
  WHILE tab_t_pon_sousl.ima_jos LOOP
    zapis_l := tab_t_pon_sousl.slijedeci_red;
    pra_t_pon_sousl.provjeri_razdoblje (
      zapis_l.ponso_id,
      zapis_l.usl_id,
      zapis_l.recara_id,
      zapis_l.usl_id1,
      TRUNC (zapis_l.dat_poc),
      TRUNC (zapis_l.dat_zav));
  END LOOP;
END;
/
SHOW ERROR


PROMPT Creating Trigger 'BDR_T_PON_SOUSL'
CREATE OR REPLACE TRIGGER BDR_T_PON_SOUSL
 BEFORE DELETE
 ON T_PON_SOUSL
 FOR EACH ROW
BEGIN
  pra_t_pon_sousl.provjeri_pon_oznaka (:OLD.ponso_id);
END;
/
SHOW ERROR


PROMPT Creating Trigger 'BIR_T_PON_SOUSL'
CREATE OR REPLACE TRIGGER BIR_T_PON_SOUSL
 BEFORE INSERT
 ON T_PON_SOUSL
 FOR EACH ROW
DECLARE

  zapis_l tab_t_pon_sousl.pon_sousl_rec_type;
BEGIN
  -- IRN 2888
  IF SYS_CONTEXT ('LOGINFO_CTX', 'SSOUSER') = 'ITNEW'
    AND SYS_CONTEXT ('LOGINFO_CTX', 'VLASNIKPODATKA') = pra_zmp_zaj.vrijednost_parametra ('0999')
  THEN
    RETURN;  -- izlaz iz trigera
  END IF;

  :NEW.dat_poc := TRUNC (:NEW.dat_poc);
  :NEW.dat_zav := TRUNC (:NEW.dat_zav);
  :NEW.id := pra_rec_zaj.sekvenca (:NEW.id);

  pra_t_pon_sousl.provjeri_pon_oznaka (:NEW.ponso_id);
  pra_t_pon_sousl.provjeri_pocetak_usluge (:NEW.ponso_id, :NEW.dat_poc);
  pra_t_pon_sousl.provjeri_zavrsetak_usluge (:NEW.ponso_id, :NEW.dat_zav);
  pra_rec_s2.provjeri_usl_ara (:NEW.usl_id, :NEW.recara_id);

  -- IRN 4118
  FOR ponso_c IN (SELECT so_id FROM t_pon_so WHERE id = :NEW.ponso_id)
  LOOP
    pra_rec_s5.provjeri_recsousl (ponso_c.so_id, :NEW.usl_id);
  END LOOP;

  zapis_l.ponso_id := :NEW.ponso_id;
  zapis_l.ponsousl_id := :NEW.id;
  zapis_l.usl_id := :NEW.usl_id;
  zapis_l.recara_id := :NEW.recara_id;
  zapis_l.usl_id1 := :NEW.usl_id1;
  zapis_l.dat_poc := :NEW.dat_poc;
  zapis_l.dat_zav := :NEW.dat_zav;
  zapis_l.ozn_prihoda := :NEW.ozn_prihoda;
  tab_t_pon_sousl.puni_tablicu (zapis_l);

  pra_rec_zaj.upisi_audit (:NEW.unos_korisnik, :NEW.unos_dat, :NEW.izmjena_korisnik, :NEW.izmjena_dat);
END;
/
SHOW ERROR


PROMPT Creating Trigger 'BIS_T_PON_SOUSL'
CREATE OR REPLACE TRIGGER BIS_T_PON_SOUSL
 BEFORE INSERT
 ON T_PON_SOUSL
BEGIN
  tab_t_pon_sousl.brisi_tablicu;
END;
/
SHOW ERROR


PROMPT Creating Trigger 'BS_T_PON_SOUSL'
CREATE OR REPLACE TRIGGER BS_T_PON_SOUSL
 BEFORE DELETE OR INSERT OR UPDATE
 ON T_PON_SOUSL
BEGIN
  replikacija.brisi_tab;
END;
/
SHOW ERROR


PROMPT Creating Trigger 'BUR_T_PON_SOUSL'
CREATE OR REPLACE TRIGGER BUR_T_PON_SOUSL
 BEFORE UPDATE
 ON T_PON_SOUSL
 FOR EACH ROW
DECLARE

  zapis_l tab_t_pon_sousl.pon_sousl_rec_type;
BEGIN
  :NEW.dat_poc := TRUNC (:NEW.dat_poc);
  :NEW.dat_zav := TRUNC (:NEW.dat_zav);

  IF :NEW.ponso_id <> :OLD.ponso_id THEN
    pra_rec_zaj.vrati_poruku (-20096);
  END IF;

  pra_t_pon_sousl.provjeri_pon_oznaka (:NEW.ponso_id);
  pra_t_pon_sousl.provjeri_pocetak_usluge (:NEW.ponso_id, :NEW.dat_poc);
  pra_t_pon_sousl.provjeri_zavrsetak_usluge (:NEW.ponso_id, :NEW.dat_zav);
  pra_rec_s2.provjeri_usl_ara (:NEW.usl_id, :NEW.recara_id);

  -- IRN 4118
  IF :NEW.usl_id <> :OLD.usl_id THEN
    FOR ponso_c IN (SELECT so_id FROM t_pon_so WHERE id = :NEW.ponso_id)
    LOOP
      pra_rec_s5.provjeri_recsousl (ponso_c.so_id, :NEW.usl_id);
    END LOOP;
  END IF;

  zapis_l.ponso_id := :NEW.ponso_id;
  zapis_l.ponsousl_id := :NEW.id;
  zapis_l.usl_id := :NEW.usl_id;
  zapis_l.usl_id1 := :NEW.usl_id1;
  zapis_l.recara_id := :NEW.recara_id;
  zapis_l.dat_poc := :NEW.dat_poc;
  zapis_l.dat_zav := :NEW.dat_zav;
  zapis_l.ozn_prihoda := :NEW.ozn_prihoda;
  tab_t_pon_sousl.puni_tablicu (zapis_l);

  pra_rec_zaj.upisi_audit (:NEW.unos_korisnik, :NEW.unos_dat, :NEW.izmjena_korisnik, :NEW.izmjena_dat);
END;
/
SHOW ERROR


PROMPT Creating Trigger 'BUS_T_PON_SOUSL'
CREATE OR REPLACE TRIGGER BUS_T_PON_SOUSL
 BEFORE UPDATE
 ON T_PON_SOUSL
BEGIN
  tab_t_pon_sousl.brisi_tablicu;
END;
/
SHOW ERROR
