PROMPT Creating Trigger 'BIS_S_KPD'
CREATE OR REPLACE TRIGGER BIS_S_KPD
 BEFORE INSERT
 ON S_KPD
BEGIN
  tab_s_kpd.brisi_tablicu;
END;
/
SHOW ERROR


PROMPT Creating Trigger 'BIR_S_KPD'
CREATE OR REPLACE TRIGGER BIR_S_KPD
 BEFORE INSERT
 ON S_KPD
 FOR EACH ROW
DECLARE

  zapis_l tab_s_kpd.kpd_rec_type;
BEGIN
  IF SYS_CONTEXT ('LOGINFO_CTX', 'SSOUSER') = 'ITNEW'
    AND SYS_CONTEXT ('LOGINFO_CTX', 'VLASNIKPODATKA') = pra_zmp_zaj.vrijednost_parametra ('0999')
  THEN
    RETURN;  -- izlaz iz trigera
  END IF;

  :NEW.id := pra_zmp_zaj.i3_sekvenca (:NEW.id);

  IF :NEW.dat_valjan IS NULL THEN
    :NEW.dat_valjan := TRUNC (SYSDATE, 'RRRR');
  END IF;
  :NEW.dat_valjan := TRUNC (:NEW.dat_valjan);
  :NEW.dat_ponisten := TRUNC (:NEW.dat_ponisten);

  zapis_l.id := :NEW.id;
  zapis_l.kpd_id := :NEW.kpd_id;
  tab_s_kpd.puni_tablicu (zapis_l);

  pra_zmp_zaj.upisi_audit (:NEW.unos_korisnik, :NEW.unos_dat, :NEW.izmjena_korisnik, :NEW.izmjena_dat);
END;
/
SHOW ERROR


PROMPT Creating Trigger 'BUR_S_KPD'
CREATE OR REPLACE TRIGGER BUR_S_KPD
 BEFORE UPDATE
 ON S_KPD
 FOR EACH ROW
DECLARE

  zapis_l tab_s_kpd.kpd_rec_type;
BEGIN

  :NEW.dat_valjan := TRUNC (:NEW.dat_valjan);
  :NEW.dat_ponisten := TRUNC (:NEW.dat_ponisten);

  IF NVL (:NEW.kpd_id, 0) <> NVL (:OLD.kpd_id, 0) THEN
    zapis_l.id := :NEW.id;
    zapis_l.kpd_id := :NEW.kpd_id;
    tab_s_kpd.puni_tablicu (zapis_l);
  END IF;

  pra_zmp_zaj.upisi_audit (:NEW.unos_korisnik, :NEW.unos_dat, :NEW.izmjena_korisnik, :NEW.izmjena_dat);
END;
/
SHOW ERROR


PROMPT Creating Trigger 'AR_S_KPD'
CREATE OR REPLACE TRIGGER AR_S_KPD
 AFTER DELETE OR INSERT OR UPDATE
 ON S_KPD
 FOR EACH ROW
BEGIN
  replikacija.napuni_tab (:OLD.id, :NEW.id);
END;
/
SHOW ERROR


PROMPT Creating Trigger 'AUS_S_KPD'
CREATE OR REPLACE TRIGGER AUS_S_KPD
 AFTER UPDATE
 ON S_KPD
DECLARE

  zapis_l tab_s_kpd.kpd_rec_type;
BEGIN
  tab_s_kpd.postavi_iterator;
  WHILE tab_s_kpd.ima_jos LOOP
    zapis_l := tab_s_kpd.sljedeci_red;
    pra_zmp_s2.provjeri_ciklus_kpd (zapis_l.id, zapis_l.kpd_id);
  END LOOP;
END;
/
SHOW ERROR


PROMPT Creating Trigger 'AS_S_KPD'
CREATE OR REPLACE TRIGGER AS_S_KPD
 AFTER DELETE OR INSERT OR UPDATE
 ON S_KPD
BEGIN
  replikacija.azuriraj_retke (
    aplikacija_p => 'ZMP',
    tablica_p    => 'S_KPD');
END;
/
SHOW ERROR


PROMPT Creating Trigger 'BUS_S_KPD'
CREATE OR REPLACE TRIGGER BUS_S_KPD
 BEFORE UPDATE
 ON S_KPD
BEGIN
  tab_s_kpd.brisi_tablicu;
END;
/
SHOW ERROR


PROMPT Creating Trigger 'AIS_S_KPD'
CREATE OR REPLACE TRIGGER AIS_S_KPD
 AFTER INSERT
 ON S_KPD
DECLARE

  zapis_l tab_s_kpd.kpd_rec_type;
BEGIN
  tab_s_kpd.postavi_iterator;
  WHILE tab_s_kpd.ima_jos LOOP
    zapis_l := tab_s_kpd.sljedeci_red;
    pra_zmp_s2.provjeri_ciklus_kpd (zapis_l.id, zapis_l.kpd_id);
  END LOOP;
END;
/
SHOW ERROR


PROMPT Creating Trigger 'BS_S_KPD'
CREATE OR REPLACE TRIGGER BS_S_KPD
 BEFORE DELETE OR INSERT OR UPDATE
 ON S_KPD
BEGIN
  replikacija.brisi_tab;
END;
/
SHOW ERROR
