-- D:\mish_CVS\misH_skripte\rm_gas5324.pkb
--
-- Generated for Oracle 10g on Tue Jul 01  09:45:00 2025 by Server Generator 6.5.96.5.6
 

PROMPT Creating Package Body 'RM_GAS5324'
CREATE OR REPLACE PACKAGE BODY RM_GAS5324 IS

FUNCTION LIMIT
 (PKAADR_ID_P IN tpka_kartice.pkaadr_id%TYPE
 ,DATUM_P IN DATE
 ,VRSTA_SUBVENCIJE_P IN VARCHAR2
 )
 RETURN NUMBER
 IS
  
  izn_limita_l t_rnkase.izn_placanja%TYPE := 0;
  dat_poc_l tpka_kartice.dat_poc%TYPE;
  dat_zav_l tpka_kartice.dat_zav%TYPE;
  dat_poc_god_l tpka_kartice.dat_poc%TYPE;
  dat_poc_mje_l tpka_kartice.dat_poc%TYPE;
  br_mjeseci_l NUMBER;
  mj_poc_l NUMBER;
  mj_zav_l NUMBER;

  CURSOR c_pkakar IS
   SELECT dat_poc, dat_zav
     FROM tpka_kartice
    WHERE id = (SELECT MAX(id)
                              FROM tpka_kartice
                           WHERE NVL(pkaadr_id,0) = NVL(pkaadr_id_p,0));
BEGIN  
  IF pkaadr_id_p IS NULL
     OR pra_pka_zaj.vrijednost_parametra ('1080') = 'nebitno' -- Mjeseni neoporezivi prenosivi iznos
     OR pra_pka_zaj.vrijednost_parametra ('1096') = 'nebitno' -- Mjeseni oporezivi iznos
  THEN
    GOTO kraj;
  END IF;

  IF datum_p < '01.06.2025' and vrsta_subvencije_p = 'O' 
     THEN GOTO kraj;
  END IF;
  
  dat_poc_god_l := TRUNC (datum_p, 'RRRR');
  dat_poc_mje_l := TO_DATE('01.'||TO_CHAR (TO_DATE(datum_p), 'MM.RRRR')) -1;  

  OPEN c_pkakar;
  FETCH c_pkakar INTO  dat_poc_l, dat_zav_l;
  IF c_pkakar%NOTFOUND THEN
    CLOSE c_pkakar;
    izn_limita_l := 0;
   RETURN izn_limita_l;
  END IF;

  CLOSE c_pkakar;

  /* Kraj kartice prije traenog razdoblja */
  IF NVL(dat_zav_l, dat_poc_god_l ) <  dat_poc_god_l THEN
     GOTO kraj;
  END IF;

  /* Poetak kartice nakon traenog razdoblja */
  IF NVL(dat_poc_l, dat_poc_god_l ) >  LAST_DAY(datum_p) THEN
     GOTO kraj;
  END IF;

  IF vrsta_subvencije_p = 'N' THEN
     BEGIN
       izn_limita_l := pra_pka_zaj.vrijednost_parametra ('1080');
     EXCEPTION
       WHEN OTHERS THEN
       GOTO kraj;
    END;
  ELSIF vrsta_subvencije_p = 'O' THEN
    dat_poc_l := '01.06.2025';  -- poetak primjene oporezive subvencije
    BEGIN
      
      izn_limita_l := pra_pka_zaj.vrijednost_parametra ('1096');
    EXCEPTION
      WHEN OTHERS THEN
      GOTO kraj;
    END;
  END IF;

  IF dat_poc_l IS NULL OR dat_poc_l < dat_poc_god_l THEN
    mj_poc_l := 1;
  ELSE
    mj_poc_l := TO_NUMBER (TO_CHAR (dat_poc_l, 'MM'));
  END IF;

  IF dat_zav_l IS NULL OR dat_zav_l > datum_p THEN
    mj_zav_l := TO_NUMBER (TO_CHAR (datum_p, 'MM'));
  ELSE
    mj_zav_l := TO_NUMBER (TO_CHAR (dat_zav_l, 'MM'));
  END IF;

  IF mj_zav_l < mj_poc_l THEN
     GOTO kraj;
  END IF;
  
  br_mjeseci_l := mj_zav_l - mj_poc_l + 1;
  izn_limita_l := (izn_limita_l * br_mjeseci_l); 
  
  <<kraj>>
  RETURN izn_limita_l;
END;
FUNCTION OPOREZ_OSTATAK
 (PKAADR_ID_P IN TPKA_KARTICE.PKAADR_ID%TYPE
 ,DATUM_P IN DATE
 )
 RETURN NUMBER
 IS
CURSOR c_pkakar IS
   SELECT dat_zav
     FROM tpka_kartice
    WHERE id = (SELECT MAX(id)
                  FROM tpka_kartice
                 WHERE NVL(pkaadr_id,0) = NVL(pkaadr_id_p,0));
 
 pkakarrnk_izn_popusta_l tpka_kar_rnk.izn_popusta%TYPE :=0;
 datum_1_l tpka_kar_rnk.datum%TYPE ; 
 izn_limita_l t_rnkase.izn_placanja%TYPE := 0;
 dat_zav_l tpka_kartice.dat_zav%TYPE;
 ostatak_l t_rnkase.izn_placanja%TYPE := 0;
BEGIN
 
  IF datum_p <  '01.06.2025'   THEN 
     GOTO kraj;
  END IF;
  
  datum_1_l := TO_DATE('01.'||TO_CHAR(datum_p, ' MM.RRRR'));
   
   OPEN c_pkakar;
  FETCH c_pkakar INTO  dat_zav_l;
  IF c_pkakar%NOTFOUND THEN
    CLOSE c_pkakar;
     GOTO kraj;
  END IF;
  CLOSE c_pkakar;
  
  /* Ako je kartica istekla nema ostatka neoporezive subvencije
  */
  IF dat_zav_l <= datum_1_l THEN 
     GOTO kraj;
  END IF;
 
  IF pra_pka_zaj.vrijednost_parametra ('1096') = 'nebitno' 
     THEN GOTO kraj; 
  ELSE
     izn_limita_l := pra_pka_zaj.vrijednost_parametra ('1096');
  END IF;
  
  SELECT  SUM(NVL(izn_popusta2, 0)) INTO pkakarrnk_izn_popusta_l
  FROM
  (SELECT NVL (pkakarrnk.izn_popusta2,0) izn_popusta2   
    FROM tpka_kar_rnk pkakarrnk,
         tpka_kartice pkakar
   WHERE pkakarrnk.pkakar_id = pkakar.id
     AND pkakar.pkaadr_id = pkaadr_id_p
     AND pkakarrnk.datum BETWEEN   datum_1_l AND datum_p
     AND pkakarrnk.oznaka = 2 -- 2 = iskoritenje
   UNION ALL
   SELECT  NVL(pkarn.izn_popusta2, 0) izn_popusta2
    FROM tpka_rnkasa pkarn
   WHERE pkarn.pkaadr_id = pkaadr_id_p
     AND pkarn.datum BETWEEN   datum_1_l AND datum_p);   
   
   <<kraj>>
   
   ostatak_l := (izn_limita_l - NVL(pkakarrnk_izn_popusta_l,0)); 
   
   RETURN ostatak_l;
 END;
FUNCTION NOPOREZ_OSTATAK
 (PKAADR_ID_P IN TPKA_KARTICE.PKAADR_ID%TYPE
 ,DATUM_P IN DATE
 )
 RETURN NUMBER
 IS
CURSOR c_pkakar IS
   SELECT dat_zav
     FROM tpka_kartice
    WHERE id = (SELECT MAX(id)
                  FROM tpka_kartice
                 WHERE NVL(pkaadr_id,0) = NVL(pkaadr_id_p,0));

 pkakarrnk_izn_popusta_l tpka_kar_rnk.izn_popusta%TYPE :=0;
 datum_1_l tpka_kar_rnk.datum%TYPE ;
 dat_zav_l tpka_kartice.dat_zav%TYPE;
BEGIN


  datum_1_l := TO_DATE('01.01'||TO_CHAR(datum_p, ' .RRRR'));

   OPEN c_pkakar;
  FETCH c_pkakar INTO  dat_zav_l;
  IF c_pkakar%NOTFOUND THEN
    CLOSE c_pkakar;
     GOTO kraj;
  END IF;
  CLOSE c_pkakar;

  /* Ako je kartica istekla nema ostatka neoporezive subvencije
  */
  IF dat_zav_l <= datum_1_l THEN
     GOTO kraj;
  END IF;

  SELECT SUM(NVL(izn_popusta, 0)) INTO pkakarrnk_izn_popusta_l
  FROM
  (SELECT NVL (pkakarrnk.izn_popusta,0) izn_popusta 
    FROM tpka_kar_rnk pkakarrnk,
         tpka_kartice pkakar
   WHERE pkakarrnk.pkakar_id = pkakar.id
     AND pkakar.pkaadr_id = pkaadr_id_p
     AND pkakarrnk.datum BETWEEN   datum_1_l AND datum_p
     AND pkakarrnk.oznaka = 2 -- 2 = iskoritenje
   UNION ALL
   SELECT  NVL(pkarn.izn_popusta, 0) izn_popusta 
    FROM tpka_rnkasa pkarn
   WHERE pkarn.pkaadr_id = pkaadr_id_p
     AND pkarn.datum BETWEEN datum_1_l AND datum_p);

   <<kraj>>

   RETURN pkakarrnk_izn_popusta_l;
 END;
END RM_GAS5324;
/
SHOW ERROR

