-- D:\z_tekuce\replikacija.pkb
--
-- Generated for Oracle 10g on Thu Oct 16  12:34:02 2025 by Server Generator 6.5.96.5.6
 

PROMPT Creating Package Body 'REPLIKACIJA'
CREATE OR REPLACE PACKAGE BODY REPLIKACIJA IS
TYPE rec_t IS RECORD (
   rec_id_old l_replikacija_log.id_old%TYPE,
   rec_id_new l_replikacija_log.id_new%TYPE,
   rec_mijenjan_blob BOOLEAN,
   rec_replicirati_djecu BOOLEAN);

TYPE plsql_tab_t IS TABLE OF rec_t INDEX BY BINARY_INTEGER;

plsql_tab_m plsql_tab_t;


TYPE fk_level_rec_t IS RECORD (
   tablica VARCHAR2 (30),
   razina  NUMBER (3));

TYPE fk_level_tab_t IS TABLE OF fk_level_rec_t INDEX BY BINARY_INTEGER;

fk_level_tab_m fk_level_tab_t;


broj_sloga_m        BINARY_INTEGER;
aplikacija_m        smet_aplikacije.sifra%TYPE;
tablica_m           VARCHAR2 (30);
udaljena_tablica_m  VARCHAR2 (60);
stupci_m            VARCHAR2 (32000);
id_old_m            l_replikacija_log.id_old%TYPE;
id_new_m            l_replikacija_log.id_new%TYPE;
azur_podcentar_m    BOOLEAN;
metcvor_sifra_m     smet_cvorovi.sifra%TYPE;

PROCEDURE REPLICIRAJ_RETKE
 (APLIKACIJA_P IN VARCHAR2
 ,TABLICA_P IN VARCHAR2
 ,AZURIRATI_BLOB_P IN BOOLEAN := TRUE
 ,RADNJA_P IN VARCHAR2
 ,POKRENUTO_IZ_PROCEDURE_P IN BOOLEAN := FALSE
 );
PROCEDURE UNESI_UDALJENI_REDAK;
PROCEDURE MIJENJAJ_UDALJENI_REDAK;
PROCEDURE BRISI_UDALJENI_REDAK;
PROCEDURE UNESI_POSEBNE_TAB_POCETAK
 (METCVOR_SIFRA_P IN SMET_CVOROVI.SIFRA%TYPE
 );
PROCEDURE MIJENJAJ_POSEBNE_TAB_POCETAK
 (METCVOR_SIFRA_P IN SMET_CVOROVI.SIFRA%TYPE
 ,ID_LOG_P IN L_REPLIKACIJA_LOG.ID%TYPE
 );
PROCEDURE UNESI_STANDARDNE_TAB
 (METCVOR_SIFRA_P IN SMET_CVOROVI.SIFRA%TYPE
 );
PROCEDURE UNESI_POSEBNE_TAB_KRAJ
 (METCVOR_SIFRA_P IN SMET_CVOROVI.SIFRA%TYPE
 );
PROCEDURE MIJENJAJ_STANDARDNE_TAB
 (METCVOR_SIFRA_P IN SMET_CVOROVI.SIFRA%TYPE
 ,ID_LOG_P IN L_REPLIKACIJA_LOG.ID%TYPE
 );
PROCEDURE MIJENJAJ_POSEBNE_TAB_KRAJ
 (METCVOR_SIFRA_P IN SMET_CVOROVI.SIFRA%TYPE
 ,ID_LOG_P IN L_REPLIKACIJA_LOG.ID%TYPE
 );
PROCEDURE KREIRAJ_IMENA_STUPACA
 (UPDATE_P IN BOOLEAN
 ,UKLJUCITI_BLOB_P IN BOOLEAN := TRUE
 );
FUNCTION STUPCI_BEZ_INSERT
 RETURN VARCHAR2;
FUNCTION STUPCI_BEZ_UPDATE
 RETURN VARCHAR2;
PROCEDURE AZUR_IZVJ_NA_OBJEKTU
 (METCVOR_SIFRA_P IN SMET_CVOROVI.SIFRA%TYPE
 );
FUNCTION PONUDA_REPLICIRA_NA_CVOR
 (METCVOR_SIFRA_P IN SMET_CVOROVI.SIFRA%TYPE
 )
 RETURN BOOLEAN;
PROCEDURE REPL_DJECU_ZA_PONUDU
 (PON_ID_P IN T_PONUDE.ID%TYPE
 ,RADNJA_P IN VARCHAR2
 );


PROCEDURE BRISI_TAB
 IS
BEGIN
   broj_sloga_m := 0;
END;
PROCEDURE NAPUNI_TAB
 (ID_OLD_P IN L_REPLIKACIJA_LOG.ID_OLD%TYPE
 ,ID_NEW_P IN L_REPLIKACIJA_LOG.ID_NEW%TYPE
 ,MIJENJAN_BLOB_P IN BOOLEAN := TRUE
 ,REPLICIRATI_DJECU_P IN BOOLEAN := FALSE
 )
 IS
BEGIN
   /*
   Radi se i na objektu (a ne samo na centru),
   kako bi i na objektu (napunjenu) PL/SQL tablicu mogao koristiti ASL okida (za upis u log).
   Replikacija se nee pokretati na objektu, jer AZURIRAJ_RETKE provjerava da li je centar.
   */
   broj_sloga_m := broj_sloga_m + 1;
   plsql_tab_m (broj_sloga_m).rec_id_old := id_old_p;
   plsql_tab_m (broj_sloga_m).rec_id_new := id_new_p;
   plsql_tab_m (broj_sloga_m).rec_mijenjan_blob := mijenjan_blob_p;
   plsql_tab_m (broj_sloga_m).rec_replicirati_djecu := replicirati_djecu_p;
END;
PROCEDURE AZURIRAJ_RETKE
 (APLIKACIJA_P IN VARCHAR2
 ,TABLICA_P IN VARCHAR2
 ,AZURIRATI_BLOB_P IN BOOLEAN := TRUE
 )
 IS
--
   radnja_l VARCHAR2 (20);
BEGIN
   /* Samo centar aurira po mrei */
   IF pra_zmp_zaj.centar = 0 THEN
      RETURN;
   END IF;

   IF INSERTING THEN
      radnja_l := 'INSERTING';
   ELSIF UPDATING THEN
      radnja_l := 'UPDATING';
   ELSIF DELETING THEN
      radnja_l := 'DELETING';
   END IF;

   /*
   Procedura AZURIRAJ_RETKE se uvijek poziva iz okidaa.
   Procedura REPLICIRAJ_RETKE se moe pozvati iz AZURIRAJ_RETKE, ali i izvan nje.
   REPLICIRAJ_RETKE moe raditi i samo za odreeni vor - prije se napuni metcvor_sifra_m.
   */
   metcvor_sifra_m := NULL;

   repliciraj_retke (
      aplikacija_p     => aplikacija_p,
      tablica_p        => tablica_p,
      azurirati_blob_p => azurirati_blob_p,
      radnja_p         => radnja_l);

   upisi_u_log (
      aplikacija_p  => aplikacija_m,
      tablica_p     => tablica_m,
      replikacija_p => 'D');
END;
PROCEDURE REPLICIRAJ_RETKE
 (APLIKACIJA_P IN VARCHAR2
 ,TABLICA_P IN VARCHAR2
 ,AZURIRATI_BLOB_P IN BOOLEAN := TRUE
 ,RADNJA_P IN VARCHAR2
 ,POKRENUTO_IZ_PROCEDURE_P IN BOOLEAN := FALSE
 )
 IS
BEGIN
   /*
   Izbjegavaju se nepotrebne radnje (npr. poziv procedure kreiraj_imena_stupaca)
   ako ROW okidai nisu u PL/SQL tablicu upisali retke za replikaciju
   (npr. ako je u toku obraun, ili aplikacija NABAVA alje sirovine).
   */
   IF broj_sloga_m = 0 THEN
      RETURN;
   END IF;

   aplikacija_m := UPPER (aplikacija_p);
   tablica_m    := UPPER (tablica_p);

   IF je_tablica_ponuda (tablica_m) = 'N' -- za tablice ponuda provjera se ve napravila u AR okidaima (samo za one vorove koji imaju ponude)
   THEN
      IF radnja_p = 'DELETING' THEN
         /* Ne smije se brisati ako nisu u mrei svi vorovi na kojima je aplikacija */
         IF potrebni_cvorovi_u_mrezi (aplikacija_m, tablica_m) = 0 THEN
            pra_zmp_zaj.vrati_poruku (-20044);
         END IF;
      ELSIF radnja_p = 'UPDATING' THEN
         /* Ne smije se mijenjati ID ako nisu u mrei svi vorovi na kojima je aplikacija */
         IF potrebni_cvorovi_u_mrezi (aplikacija_m, tablica_m) = 0 THEN
            FOR brojac IN 1..broj_sloga_m LOOP
               id_old_m  := plsql_tab_m (brojac).rec_id_old;
               id_new_m  := plsql_tab_m (brojac).rec_id_new;

               IF id_old_m <> id_new_m THEN
                  pra_zmp_zaj.vrati_poruku (-20043);
               END IF;
            END LOOP;
         END IF;
      END IF;
   END IF;

   FOR metins IN (
      SELECT ins.metcvor_sifra
        FROM smet_instalacije ins,
             smet_cvorovi     cvor
       WHERE ins.metapl_sifra  =  aplikacija_m
         AND LOWER (ins.metcvor_sifra) <> LOWER (pra_zmp_zaj.tekuci_cvor)
         AND ins.metcvor_sifra =  cvor.sifra
         AND cvor.ozn_u_mrezi  =  -1
       ORDER BY ins.metcvor_sifra)
   LOOP
      IF tab_replicira_na_cvor (metins.metcvor_sifra, tablica_m) = 0 THEN
         GOTO kraj_petlje_za_cvorove;
      END IF;

      /*
      Procedura REPLICIRAJ_RETKE se moe pozvati iz AZURIRAJ_RETKE, ali i izvan nje.
      REPLICIRAJ_RETKE moe raditi i samo za odreeni vor - prije se napuni metcvor_sifra_m.
      */
      IF metcvor_sifra_m IS NOT NULL
         AND
         LOWER (metcvor_sifra_m) <> LOWER (metins.metcvor_sifra)
      THEN
         GOTO kraj_petlje_za_cvorove;
      END IF;

      /*
      Ako se radi INSERT ili UPDATE, postavlja se informacija (kroz "azur_podcentar_m")
      za funkcije "stupci_bez_update" i "stupci_bez_insert", koje se pozivaju iz "kreiraj_imena_stupaca"
      */
      IF radnja_p IN ('INSERTING', 'UPDATING') THEN
         IF cvor_je_podcentar (metins.metcvor_sifra) = -1 THEN
            azur_podcentar_m := TRUE;
         ELSE
            azur_podcentar_m := FALSE;
         END IF;

         /* Kroz AS replikacijski trigger moe se rei da se ne aurira BLOB sa azurirati_blob_p = FALSE (default je TRUE) */
         IF radnja_p = 'INSERTING' THEN
            kreiraj_imena_stupaca (update_p => FALSE, ukljuciti_blob_p => azurirati_blob_p);
         ELSIF radnja_p = 'UPDATING' THEN
            kreiraj_imena_stupaca (update_p => TRUE,  ukljuciti_blob_p => azurirati_blob_p);
         END IF;
      END IF;

      udaljena_tablica_m := tablica_m || '@' || metins.metcvor_sifra;

      FOR brojac IN 1..broj_sloga_m LOOP
         id_old_m  := plsql_tab_m (brojac).rec_id_old;
         id_new_m  := plsql_tab_m (brojac).rec_id_new;

         IF tablica_m = 'M_SIROVINE'
            AND NOT azur_podcentar_m -- nije podcentar
            AND radnja_p IN ('INSERTING', 'UPDATING')
         THEN
            /*
            Replikacija sirovina na objekte se ne radi (na podcentre se radi)
            ako je INSERT/UPDATE i ako redak ima oznaku valjanosti = 'N' i dodatni naziv = '?'
            (to znai da tehnolog jo nije aurirao sirovinu).
            */
            DECLARE
               ozn_valjanosti_l m_sirovine.ozn_valjanosti%TYPE;
               naz_dodatni_l    m_sirovine.naz_dodatni%TYPE;
            BEGIN
               IF radnja_p = 'INSERTING' THEN
                 SELECT ozn_valjanosti, naz_dodatni
                   INTO ozn_valjanosti_l, naz_dodatni_l
                   FROM m_sirovine
                  WHERE id = id_new_m;
               ELSE
                 SELECT ozn_valjanosti, naz_dodatni
                   INTO ozn_valjanosti_l, naz_dodatni_l
                   FROM m_sirovine
                  WHERE id = id_old_m;
               END IF;

               IF ozn_valjanosti_l = 'N' AND NVL (naz_dodatni_l, 0) = '?' THEN
                  GOTO kraj_petlje_za_retke;
               END IF;
            END;
        ELSIF tablica_m = 'TPKA_TECAJNICE' AND radnja_p = 'INSERTING' THEN
            /* Teajnice se mogu unositi i na objektu, pa ih prije INSERT treba brisati. */
            DECLARE
               ban_id_l    tpka_tecajnice.ban_id%TYPE;
               vtec_id_l   tpka_tecajnice.vtec_id%TYPE;
               datum_l     tpka_tecajnice.datum%TYPE;
               godina_l    tpka_tecajnice.godina%TYPE;
               broj_l      tpka_tecajnice.broj%TYPE;
               pkatec_id_l tpka_tec_val.pkatec_id%TYPE;
               naredba_l   VARCHAR2 (32000);
            BEGIN
               /* Treba nai UK, jer je ID vjerojatno razliit. */
               SELECT ban_id, vtec_id, datum
                 INTO ban_id_l, vtec_id_l, datum_l
                 FROM tpka_tecajnice
                WHERE id = id_new_m;

               BEGIN
                  /* Traenje zaglavlja na objektu - ako ne postoji, ii e na EXCEPTION (NULL). */
                  naredba_l :=
                  'SELECT id' ||
                  '  FROM tpka_tecajnice@' || metins.metcvor_sifra ||
                  ' WHERE ban_id = :ban_id_l AND vtec_id = :vtec_id_l AND datum = :datum_l' ||
                  '    OR ban_id = :ban_id_l AND godina = :godina_l AND broj = :broj_l AND vtec_id = :vtec_id_l';

                  EXECUTE IMMEDIATE naredba_l INTO pkatec_id_l
                     USING ban_id_l, vtec_id_l, datum_l, ban_id_l, godina_l, broj_l, vtec_id_l;

                  /* Brisanje stavaka na objektu. */
                  naredba_l :=
                  'DELETE tpka_tec_val@' || metins.metcvor_sifra ||
                  ' WHERE pkatec_id = :pkatec_id_l';

                  EXECUTE IMMEDIATE naredba_l USING pkatec_id_l;

                  /* Brisanje zaglavlja na objektu. */
                  naredba_l :=
                  'DELETE tpka_tecajnice@' || metins.metcvor_sifra ||
                  ' WHERE id = :pkatec_id_l';

                  EXECUTE IMMEDIATE naredba_l USING pkatec_id_l;
               EXCEPTION
                  WHEN NO_DATA_FOUND THEN NULL;
               END;
            END;
         ELSIF je_tablica_ponuda (tablica_m) = 'D' THEN
            /*
            Ponude se ne alju na potcentar, ali to se ne upisuje u tablice SMET_BEZ_REPLIKACIJE, ve se testira ovdje.
            Ovo je vano samo za DELETE, koji se alje svugdje, jer INSERT/UPDATE radi na temelju funkcije ponuda_replicira_na_cvor.
            */
            IF DELETING AND cvor_je_podcentar (metins.metcvor_sifra) = -1 THEN
               GOTO kraj_petlje_za_retke;
            END IF;

            /*
            INSERT i UPDATE se rade samo na vorove koji imaju ponude.
            DELETE se radi na sve vorove (koji imaju aplikaciju), jer u AS okidau vie nema informacije za :OLD.
            */
            IF (radnja_p = 'INSERTING' OR radnja_p = 'UPDATING')
               AND
               NOT ponuda_replicira_na_cvor (metins.metcvor_sifra)
            THEN
               GOTO kraj_petlje_za_retke;
            END IF;

            IF tablica_m = 'T_PON_OJR' THEN
               DECLARE
                  metcvor_sifra_l mzmp_ojr.metcvor_sifra%TYPE;
                  pon_id_l        t_pon_ojr.pon_id%TYPE;
                  zmpojr_id_l     t_pon_ojr.zmpojr_id%TYPE;
               BEGIN
                  /*
                  Brisanje je mogue samo ako je ponuda u izradi.
                  U tom sluaju nije replicirana i nije potrebno brisati udaljeni redak.
                  */
                  IF radnja_p = 'DELETING' THEN
                     GOTO kraj_petlje_za_retke;
                  END IF;

                  SELECT pon_id,   zmpojr_id
                    INTO pon_id_l, zmpojr_id_l
                    FROM t_pon_ojr
                   WHERE id = plsql_tab_m (brojac).rec_id_new;

                  /*
                  Funkcija PONUDA_PROVJERENA mora se pozvati ovdje, a ne u ROW triggeru (kao u ostalim triggerima za ponude).
                  U ROW triggeru desilo bi se mutiranje, jer funkcija ita tablicu T_PON_OJR.
                  */
                  IF NOT ponuda_provjerena (pon_id_l) THEN
                     GOTO kraj_petlje_za_retke;
                  END IF;

                  /*
                  Ako je nad tablicom T_PON_OJR pokrenut INSERT iz triggera (tj. NOT pokrenuto_iz_procedure_p)
                  onda se NE alje na vor sa kojim je T_PON_OJR vezana (preko MZMP_OJR)
                  jer moda jo nije repliciran odgovarajui redak T_PONUDE, pa bi javilo FK greku
                  (redak T_PONUDE moda i postoji, ako je repliciran kroz drugi T_PON_OJR za istu ponudu i isti vor).
                  */
                  IF radnja_p = 'INSERTING' AND NOT pokrenuto_iz_procedure_p THEN
                     SELECT NVL (metcvor_sifra, metcvor_sifra_gas)
                       INTO metcvor_sifra_l
                       FROM mzmp_ojr
                      WHERE id = zmpojr_id_l;

                     IF LOWER (metcvor_sifra_l) = LOWER (metins.metcvor_sifra) THEN
                        GOTO kraj_petlje_za_retke;
                     END IF;
                  END IF;
               END;
            END IF;
         END IF;

         IF radnja_p = 'INSERTING' THEN
            unesi_udaljeni_redak;
         ELSIF radnja_p = 'UPDATING' THEN
            IF azurirati_blob_p AND NOT plsql_tab_m (brojac).rec_mijenjan_blob THEN
               /* Kroz AR replikacijski trigger moe se rei da nije mijenjan BLOB (default je TRUE - da je mijenjan) */
               kreiraj_imena_stupaca (update_p => TRUE, ukljuciti_blob_p => FALSE);
            END IF;

            mijenjaj_udaljeni_redak;
         ELSE -- DELETING
            brisi_udaljeni_redak;
         END IF;

         <<kraj_petlje_za_retke>> NULL;
      END LOOP; -- za sve retke

      <<kraj_petlje_za_cvorove>> NULL;
   END LOOP; -- za sve vorove
END;
PROCEDURE UPISI_U_LOG
 (APLIKACIJA_P IN VARCHAR2
 ,TABLICA_P IN VARCHAR2
 ,REPLIKACIJA_P IN VARCHAR2 := 'N'
 )
 IS
--
   naredba_l   VARCHAR2 (32000);
   redak_l     VARCHAR2 (32000);
   redak_old_l VARCHAR2 (32000);
   radnja_l    VARCHAR2 (1);

   FUNCTION redak_old RETURN VARCHAR2 IS
      PRAGMA AUTONOMOUS_TRANSACTION;
      naredba_l   VARCHAR2 (32000);
      redak_old_l VARCHAR2 (4000);
   BEGIN
      naredba_l :=
      ' SELECT ' || stupci_m  ||
      '   FROM ' || tablica_m ||
      '  WHERE id = :id_old_m';

      BEGIN
         EXECUTE IMMEDIATE naredba_l INTO redak_old_l USING id_old_m;
      EXCEPTION
         WHEN NO_DATA_FOUND THEN
            redak_old_l := '***** NEMA STAROG RETKA *****';
      END;

      RETURN redak_old_l;
   END;
BEGIN
   aplikacija_m := UPPER (aplikacija_p);
   tablica_m    := UPPER (tablica_p);
   stupci_m     := NULL;

   FOR tabcol IN (
      SELECT CASE WHEN data_type = 'DATE' THEN
                'TO_CHAR (' || column_name || ', ''DD.MM.YYYY HH:MM:SS'')'
             WHEN data_type = 'VARCHAR2' THEN
                'SUBSTR (' || column_name || ', 1, 240)'
             ELSE
                column_name
             END column_name
        FROM user_tab_columns
       WHERE table_name = tablica_m
         AND data_type <> 'BLOB' -- BLOB se ne moe upisati u l_replikacija_log
       ORDER BY column_id)
   LOOP
      IF stupci_m IS NULL THEN
         stupci_m := tabcol.column_name;
      ELSE
         stupci_m := stupci_m || ' || '' >> '' || ' || tabcol.column_name;
      END IF;
   END LOOP;

   FOR brojac IN 1..broj_sloga_m LOOP
      id_old_m := plsql_tab_m (brojac).rec_id_old;
      id_new_m := plsql_tab_m (brojac).rec_id_new;

      naredba_l :=
      ' SELECT ' || stupci_m  ||
      '   FROM ' || tablica_m ||
      '  WHERE id = :id_new_m';

      IF INSERTING THEN
         radnja_l := 'I';
         EXECUTE IMMEDIATE naredba_l INTO redak_l USING id_new_m;
         redak_old_l := NULL;
      ELSIF UPDATING THEN
         radnja_l := 'U';
         EXECUTE IMMEDIATE naredba_l INTO redak_l USING id_new_m;
         redak_old_l := redak_old;
      ELSE -- DELETING
         radnja_l := 'D';
         redak_l := NULL;
         redak_old_l := redak_old;
      END IF;

      INSERT INTO l_replikacija_log (
            id, replikacija,
            metapl_sifra, tablica, id_old, id_new,
            datum, radnja, korisnik, redak, redak_old)
         VALUES (
            sekvenca_replog (NULL), replikacija_p,
            aplikacija_m, tablica_m, id_old_m, id_new_m,
            SYSDATE, radnja_l, USER, SUBSTR (redak_l, 1, 4000), SUBSTR (redak_old_l, 1, 4000)); -- u bazi polje moe imati do 4000 B
   END LOOP;
END;
PROCEDURE AZUR_RETKE_NA_CVORU
 (METCVOR_SIFRA_P IN SMET_CVOROVI.SIFRA%TYPE
 ,ID_LOG_P IN L_REPLIKACIJA_LOG.ID%TYPE
 )
 IS
BEGIN
   /*
   Postavlja se informacija da li se radi na podcentru
   za funkcije "stupci_bez_azuriranja" i "stupci_bez_update".
   */
   IF cvor_je_podcentar (metcvor_sifra_p) = -1 THEN
      azur_podcentar_m := TRUE;
   ELSE
      azur_podcentar_m := FALSE;
   END IF;

   unesi_posebne_tab_pocetak (metcvor_sifra_p);

   mijenjaj_posebne_tab_pocetak (metcvor_sifra_p, id_log_p); -- mora biti na ovom mjestu!

   unesi_standardne_tab (metcvor_sifra_p);

   unesi_posebne_tab_kraj (metcvor_sifra_p);

   mijenjaj_standardne_tab (metcvor_sifra_p, id_log_p);

   mijenjaj_posebne_tab_kraj (metcvor_sifra_p, id_log_p);

   IF cvor_je_podcentar (metcvor_sifra_p) = 0 THEN
      azur_izvj_na_objektu (metcvor_sifra_p);
   END IF;
END;
FUNCTION POTREBNI_CVOROVI_U_MREZI
 (METAPL_SIFRA_P IN SMET_APLIKACIJE.SIFRA%TYPE
 ,TABLICA_P IN SMET_BEZ_REPLIKACIJE.TABLICA%TYPE
 )
 RETURN NUMBER
 IS
--
   cvorovi_ins_u_mrezi_l NUMBER := -1;
   brojac_l NUMBER;
BEGIN
   /* vorovi koji imaju instaliranu (definiranu) aplikaciju i koji nisu u mrei. */
   FOR cvor IN (
      SELECT cvor.sifra
        FROM smet_instalacije ins,
             smet_cvorovi     cvor
       WHERE ins.metapl_sifra  = metapl_sifra_p
         AND ins.metcvor_sifra = cvor.sifra
         AND cvor.ozn_u_mrezi  = 0)
   LOOP
      /*
      Ako za vor (koji nije u mrei) i (definiranu) tablicu
      nema zapisa u smet_bez_replikacije, replikacija se ne radi.
      */
      SELECT COUNT (1) INTO brojac_l
        FROM smet_bez_replikacije
       WHERE LOWER (metcvor_sifra) = LOWER (cvor.sifra)
         AND LOWER (tablica)       = LOWER (tablica_p);

      IF brojac_l = 0 THEN
         cvorovi_ins_u_mrezi_l := 0;
         EXIT;
      END IF;
   END LOOP;

   RETURN cvorovi_ins_u_mrezi_l;
END;
FUNCTION CVOROVI_INS_U_MREZI
 (METAPL_SIFRA_P IN SMET_APLIKACIJE.SIFRA%TYPE
 )
 RETURN NUMBER
 IS
--
   cvorovi_ins_u_mrezi_l NUMBER;
   brojac_l NUMBER;
BEGIN
   -- da li postoje instalacije (te aplikacije) na vorovima koji nisu u mrei
   SELECT COUNT (1) INTO brojac_l
     FROM smet_instalacije ins,
          smet_cvorovi cvor
    WHERE ins.metapl_sifra = metapl_sifra_p
      AND ins.metcvor_sifra = cvor.sifra
      AND cvor.ozn_u_mrezi = 0;

   IF brojac_l = 0 THEN
      cvorovi_ins_u_mrezi_l := -1;
   ELSE
      cvorovi_ins_u_mrezi_l := 0;
   END IF;

   RETURN cvorovi_ins_u_mrezi_l;
END;
FUNCTION CVOR_JE_PODCENTAR
 (METCVOR_SIFRA_P IN SMET_CVOROVI.SIFRA%TYPE
 )
 RETURN NUMBER
 IS
--
   vrijednost_l szmp_parametri.vrijednost%TYPE;
   cvor_je_podcentar_l NUMBER := 0;
BEGIN
   /*
   Ako je parametar funkcije jednak tekuem voru, parametar 0032 ("da li je vor podcentar")
   se ita lokalno, a ne preko db link-a, zato to ne postoji "db link na samoga sebe".
   */
   IF LOWER (metcvor_sifra_p) = LOWER (pra_zmp_zaj.tekuci_cvor) THEN
      vrijednost_l := pra_zmp_zaj.zmppar_vrijednost ('ZMP', '0032');
   ELSE
      EXECUTE IMMEDIATE
         'SELECT pra_zmp_zaj.zmppar_vrijednost@' || metcvor_sifra_p || ' (''ZMP'', ''0032'') FROM DUAL'
         INTO vrijednost_l;
   END IF;

   IF vrijednost_l = 'D' THEN
      cvor_je_podcentar_l := -1; -- TRUE
   END IF;

   RETURN cvor_je_podcentar_l;
END;
FUNCTION TAB_REPLICIRA_NA_CVOR
 (METCVOR_SIFRA_P IN SMET_CVOROVI.SIFRA%TYPE
 ,TABLICA_P IN VARCHAR2
 )
 RETURN INTEGER
 IS
--
   br_redaka_l NUMBER;
BEGIN
   SELECT COUNT (1) INTO br_redaka_l
     FROM smet_bez_replikacije
    WHERE LOWER (metcvor_sifra) = LOWER (metcvor_sifra_p)
      AND LOWER (tablica)       = LOWER (tablica_p);

   /* Ako u meta tablici postoji zapis, tablica se ne replicira na vor */
   IF br_redaka_l <> 0 THEN
      RETURN 0;
   ELSE
      RETURN -1;
   END IF;
END;
FUNCTION FK_LEVEL
 (TABLE_NAME_P IN VARCHAR2
 )
 RETURN NUMBER
 IS
--
   nasao_l      BOOLEAN;
   razina_l     NUMBER;
   razina_pom_l NUMBER;
   i            NUMBER;
BEGIN
   /* Da li je tekua tablica ve zapisana u PL/SQL tablicu */
   nasao_l := FALSE;
   FOR i IN 1 .. fk_level_tab_m.COUNT LOOP
      IF fk_level_tab_m(i).tablica = table_name_p THEN
         nasao_l  := TRUE;
         razina_l := fk_level_tab_m(i).razina;
         EXIT;
      END IF;
   END LOOP;

   /* Ako tekua tablica nije zapisana, trai najveu razinu njenih roditelja i dodaje 1 */
   IF NOT nasao_l THEN
      razina_l := 0;

      /* Za sve roditelje tekue tablice */
      FOR cur IN (
         SELECT parent.table_name
           FROM user_constraints child,
                user_constraints parent
          WHERE child.table_name = table_name_p
            AND child.constraint_type = 'R'          -- NIJE NUNO, ALI UBRZAVA
            AND parent.constraint_type IN ('P', 'U') -- NIJE NUNO, ALI UBRZAVA
            AND child.r_constraint_name = parent.constraint_name
            AND child.table_name <> parent.table_name)
      LOOP
         razina_pom_l := fk_level (cur.table_name) + 1; -- rekurzivni poziv

         IF razina_pom_l > razina_l THEN
            razina_l := razina_pom_l;
         END IF;
      END LOOP;

      /* Zapisuje tekuu tablicu u PL/SQL tablicu */
      i := fk_level_tab_m.COUNT;
      fk_level_tab_m(i + 1).tablica := table_name_p;
      fk_level_tab_m(i + 1).razina  := razina_l;
   END IF;

   RETURN razina_l;
END;
FUNCTION SEKVENCA_REPLOG
 (ID_P IN INTEGER
 )
 RETURN INTEGER
 IS
BEGIN
   RETURN pra_zmp_zaj.i3_sekvenca (id_p);
END;
PROCEDURE UNESI_UDALJENI_REDAK
 IS
--
   naredba_l VARCHAR2 (32000);
   stupci_odrediste_l VARCHAR2(4000);
   stupci_izvor_l VARCHAR2(4000);
   def_stupci_podcentar_l VARCHAR2(4000) := NULL;
   def_vrijednosti_podcentar_l VARCHAR2(4000) := NULL;
BEGIN
   stupci_odrediste_l := stupci_m;
   stupci_izvor_l     := stupci_m;

   /* Na podcentar se mogu slati neke default vrijednosti */
   BEGIN
      IF azur_podcentar_m THEN
         SELECT default_stupci_podcentar, default_vrijednosti_podcentar
           INTO def_stupci_podcentar_l, def_vrijednosti_podcentar_l
           FROM smet_stupci_bez_repl
          WHERE UPPER (tablica) = tablica_m;

         IF def_stupci_podcentar_l IS NOT NULL AND def_vrijednosti_podcentar_l IS NOT NULL THEN
            stupci_odrediste_l := stupci_odrediste_l || ',' || def_stupci_podcentar_l;
            stupci_izvor_l     := stupci_izvor_l     || ',' || def_vrijednosti_podcentar_l;
         END IF;
      END IF;
   EXCEPTION
      WHEN NO_DATA_FOUND THEN
         NULL;
   END;

   naredba_l :=
   '  INSERT INTO ' || udaljena_tablica_m ||
   '    (' || stupci_odrediste_l || ')'   ||
   '    SELECT ' || stupci_izvor_l        ||
   '      FROM ' || tablica_m             ||
   '     WHERE id = :id_new_m';

   EXECUTE IMMEDIATE naredba_l USING id_new_m;
END;
PROCEDURE MIJENJAJ_UDALJENI_REDAK
 IS
--
   naredba_l     VARCHAR2 (32000);
   nasao_redak_l VARCHAR2 (1);
BEGIN
   naredba_l :=
   '  BEGIN'                             ||
   '     UPDATE ' || udaljena_tablica_m  ||
   '        SET (' || stupci_m || ') ='  ||
   '            (SELECT ' || stupci_m    ||
   '               FROM ' || tablica_m   ||
   '              WHERE id = :id_new_m)' ||
   '      WHERE id = :id_old_m;'         ||
   ' '                                   ||
   '     IF SQL%FOUND THEN'              ||
   '        :nasao_redak_l := ''D'';'    ||
   '     ELSE'                           ||
   '        :nasao_redak_l := ''N'';'    ||
   '     END IF;'                        ||
   '  END;';

   EXECUTE IMMEDIATE naredba_l USING id_new_m, id_old_m, OUT nasao_redak_l;

   IF nasao_redak_l = 'N' THEN
      /*
      Ako je potreban INSERT, stupce treba kreirati za INSERT
      (za UPDATE se moda ne alju svi stupci).

      INSERT na ovom mjestu (kod UPDATE) u veini sluajeva ne bi niti trebao,
      jer procedura vraanja vora u mreu radi INSERT svega ega nema (i to prije UPDATE).

      No, mogue je da korisnik unosi redak ba dok se vor vraa u mreu,
      i to u trenucima nakon to je procedura vraanja prola tu tablicu
      (i nije nala redak koji korisnik upravo unosi),
      ali prije nego je vor oznaen da je u mrei (pa ga je on-line replikacija preskoila).
      Nakon toga e vor biti u mrei, a nee imati te (u meuvremenu unesene) retke.
      Zato treba ovaj dio programskog koda, da bi se kroz UPDATE na centru mogao ipak
      napraviti INSERT takvih redaka na objekt, bez ponovnog stavljanja/vraanja objekta u mreu.
      */
      kreiraj_imena_stupaca (update_p => FALSE);

      unesi_udaljeni_redak;
   END IF;
END;
PROCEDURE BRISI_UDALJENI_REDAK
 IS
--
   naredba_l VARCHAR2 (32000);
BEGIN
   naredba_l :=
   '  DELETE ' || udaljena_tablica_m ||
   '   WHERE id = :id_old_m';

   EXECUTE IMMEDIATE naredba_l USING id_old_m;
END;
PROCEDURE UNESI_POSEBNE_TAB_POCETAK
 (METCVOR_SIFRA_P IN SMET_CVOROVI.SIFRA%TYPE
 )
 IS
--
   naredba_l VARCHAR2 (32000);
   brojac_l  INTEGER;
BEGIN
   /* IMENA TABLICA MORAJU BITI PISANA VELIKIM SLOVIMA */

   /* Poseban postupak za ZMP tablice. */
   SELECT COUNT (1) INTO brojac_l
     FROM smet_instalacije
    WHERE metcvor_sifra = metcvor_sifra_p
      AND metapl_sifra = 'ZMP';

   IF brojac_l <> 0 THEN
      /*
      Aplikacije nemaju ID, pa im sinhrona replikacija ide preko ne-generikih okidaa,
      a asinhrona replikacija (samo INSERT - UPDATE nije dozvoljen) je posebna.
      Mora biti na poetku, jer se druge tablice pozivaju na nju, preko FK.
      */
      tablica_m := 'SMET_APLIKACIJE';
      IF tab_replicira_na_cvor (metcvor_sifra_p, tablica_m) = -1 THEN
         udaljena_tablica_m := tablica_m || '@' || metcvor_sifra_p;

         naredba_l :=
         'INSERT INTO ' || udaljena_tablica_m ||
         '       (sifra,
                  naziv,
                  unos_korisnik, unos_dat,
                  izmjena_korisnik, izmjena_dat)
           SELECT c.sifra,
                  c.naziv,
                  c.unos_korisnik, c.unos_dat,
                  c.izmjena_korisnik, c.izmjena_dat
             FROM ' || tablica_m          || ' c, ' ||
                       udaljena_tablica_m || ' u  ' ||
         '  WHERE u.sifra (+) = c.sifra
              AND u.sifra IS NULL';

         EXECUTE IMMEDIATE naredba_l;
      END IF;

      /*
      vorovi nemaju ID, pa im sinhrona replikacija ide preko ne-generikih okidaa,
      a asinhrona replikacija je posebna.
      Mora biti na poetku, jer se druge tablice pozivaju na nju, preko FK.
      */
      tablica_m := 'SMET_CVOROVI';
      IF tab_replicira_na_cvor (metcvor_sifra_p, tablica_m) = -1 THEN
         udaljena_tablica_m := tablica_m || '@' || metcvor_sifra_p;

         naredba_l :=
         'INSERT INTO ' || udaljena_tablica_m ||
         '       (sifra,
                  rbr,
                  naziv,
                  ozn_u_mrezi,
                  unos_korisnik, unos_dat,
                  izmjena_korisnik, izmjena_dat)
           SELECT c.sifra,
                  c.rbr,
                  c.naziv,
                  c.ozn_u_mrezi,
                  c.unos_korisnik, c.unos_dat,
                  c.izmjena_korisnik, c.izmjena_dat
             FROM ' || tablica_m          || ' c, ' ||
                       udaljena_tablica_m || ' u  ' ||
         '  WHERE u.sifra (+) = c.sifra
              AND u.sifra IS NULL';

         EXECUTE IMMEDIATE naredba_l;
      END IF;

      /*
      Tablica SMET_STUPCI_BEZ_REPL nema ID, pa sinhrona replikacija ide preko ne-generikih okidaa,
      a asinhrona replikacija je posebna.
      Mora biti na poetku, jer replikacija drugih tablica moe ovisiti o njoj.
      */
      tablica_m := 'SMET_STUPCI_BEZ_REPL';
      IF tab_replicira_na_cvor (metcvor_sifra_p, tablica_m) = -1 THEN
         udaljena_tablica_m := tablica_m || '@' || metcvor_sifra_p;

         naredba_l :=
         'INSERT INTO ' || udaljena_tablica_m ||
         '       (tablica,
                  stupci_bez_update_podcentar,
                  stupci_bez_update_objekt,
                  stupci_bez_insert_podcentar,
                  stupci_bez_insert_objekt,
                  forms_stupci_update_podcentar,
                  forms_stupci_update_objekt,
                  default_stupci_podcentar,
                  default_vrijednosti_podcentar,
                  unos_korisnik, unos_dat,
                  izmjena_korisnik, izmjena_dat)
           SELECT c.tablica,
                  c.stupci_bez_update_podcentar,
                  c.stupci_bez_update_objekt,
                  c.stupci_bez_insert_podcentar,
                  c.stupci_bez_insert_objekt,
                  c.forms_stupci_update_podcentar,
                  c.forms_stupci_update_objekt,
                  c.default_stupci_podcentar,
                  c.default_vrijednosti_podcentar,
                  c.unos_korisnik, c.unos_dat,
                  c.izmjena_korisnik, c.izmjena_dat
             FROM ' || tablica_m          || ' c, ' ||
                       udaljena_tablica_m || ' u  ' ||
         '  WHERE u.tablica (+) = c.tablica
              AND u.tablica IS NULL';

         EXECUTE IMMEDIATE naredba_l;
      END IF;

      /*
      Instalacije nemaju ID, pa im sinhrona replikacija ide preko ne-generikih okidaa,
      a asinhrona replikacija je posebna.
      Ne mora biti na poetku, ali je stavljena ovdje uz aplikacije i vorove.
      */
      tablica_m := 'SMET_INSTALACIJE';
      IF tab_replicira_na_cvor (metcvor_sifra_p, tablica_m) = -1 THEN
         udaljena_tablica_m := tablica_m || '@' || metcvor_sifra_p;

         naredba_l :=
         'INSERT INTO ' || udaljena_tablica_m ||
         '       (metapl_sifra,
                  metcvor_sifra,
                  unos_korisnik, unos_dat,
                  izmjena_korisnik, izmjena_dat)
           SELECT c.metapl_sifra,
                  c.metcvor_sifra,
                  c.unos_korisnik, c.unos_dat,
                  c.izmjena_korisnik, c.izmjena_dat
            FROM ' || tablica_m          || ' c, ' ||
                      udaljena_tablica_m || ' u  ' ||
         ' WHERE u.metapl_sifra (+) = c.metapl_sifra
             AND u.metapl_sifra IS NULL
             AND u.metcvor_sifra (+) = c.metcvor_sifra
             AND u.metcvor_sifra IS NULL';

         EXECUTE IMMEDIATE naredba_l;
      END IF;

      /* Mora se replicirati prije drugih tablica */
      tablica_m := 'S_STUPCI';
      IF tab_replicira_na_cvor (metcvor_sifra_p, tablica_m) = -1 THEN
         udaljena_tablica_m := tablica_m || '@' || metcvor_sifra_p;

         naredba_l :=
         'INSERT INTO ' || udaljena_tablica_m ||
         '       (id,
                  naz_tablice,
                  naziv,
                  duljina,
                  ozn_broj,
                  ozn_zerofill,
                  ozn_slovo,
                  ozn_upper,
                  ozn_lower,
                  min_duljina,
                  ozn_duljine,
                  unos_korisnik, unos_dat,
                  izmjena_korisnik, izmjena_dat)
           SELECT c.id,
                  c.naz_tablice,
                  c.naziv,
                  c.duljina,
                  c.ozn_broj,
                  c.ozn_zerofill,
                  c.ozn_slovo,
                  c.ozn_upper,
                  c.ozn_lower,
                  c.min_duljina,
                  c.ozn_duljine,
                  c.unos_korisnik, c.unos_dat,
                  c.izmjena_korisnik, c.izmjena_dat
             FROM ' || tablica_m          || ' c, ' ||
                       udaljena_tablica_m || ' u  ' ||
           'WHERE u.id (+) = c.id
              AND u.id IS NULL';

         EXECUTE IMMEDIATE naredba_l;
      END IF;

      /*
      Neki parametri moraju se unijeti sa drugaijim vrijednostima od onih na (pot)centru.
      Zato se tablica SZMP_PARAMETRI replicira kao posebna tablica.
      Prije nje treba replicirati retke tablice SZMP_SUSTAVI, koja joj je "roditelj".
      */
      tablica_m := 'SZMP_SUSTAVI';
      IF tab_replicira_na_cvor (metcvor_sifra_p, tablica_m) = -1 THEN
         udaljena_tablica_m := tablica_m || '@' || metcvor_sifra_p;
         kreiraj_imena_stupaca (update_p => FALSE);

         naredba_l :=
         '  INSERT INTO ' || udaljena_tablica_m ||
         '    (' || stupci_m || ')' ||
         '    SELECT ' || 'centar.'  || REPLACE (stupci_m, ',', ', centar.') ||
         '      FROM ' || tablica_m          || ' centar, ' ||
                          udaljena_tablica_m || ' objekt' ||
         '     WHERE objekt.id (+) = centar.id' ||
         '       AND objekt.id IS NULL';

         EXECUTE IMMEDIATE naredba_l;
      END IF;

      /*
      Parametri ija se vrijednost ne replicira:
      ZMP 0003 vor je centar mree, tj. vor koji aurira replikacijske tablice. (D/N)
      ZMP 0031 Aurirati podatke u aplikaciji POSSUS. (D/N)
      ZMP 0032 vor je podcentar mree. (D/N)
      PKA 1035 Naziv tablice aplikacije Kadrovi i plae iz koje se u dnevni izvjetaj preuzimaju pokazatelji ili nebitno.
      */
      tablica_m := 'SZMP_PARAMETRI';
      IF tab_replicira_na_cvor (metcvor_sifra_p, tablica_m) = -1 THEN
         udaljena_tablica_m := tablica_m || '@' || metcvor_sifra_p;

         naredba_l :=
         'INSERT INTO ' || udaljena_tablica_m ||
         '       (id,
                  zmpsus_id,
                  sifra,
                  opis,
                  vrijednost,
                  unos_korisnik, unos_dat,
                  izmjena_korisnik, izmjena_dat)
           SELECT c.id,
                  c.zmpsus_id,
                  c.sifra,
                  c.opis,
                  CASE (SELECT sifra FROM szmp_sustavi WHERE id = c.zmpsus_id)
                  WHEN ''ZMP'' THEN
                     CASE c.sifra
                     WHEN ''0003'' THEN ''N''
                     WHEN ''0031'' THEN ''N''
                     WHEN ''0032'' THEN ''N''
                     ELSE c.vrijednost
                     END
                  WHEN ''PKA'' THEN
                     CASE c.sifra
                     WHEN ''1035'' THEN ''nebitno''
                     ELSE c.vrijednost
                     END
                  ELSE c.vrijednost
                  END,
                  c.unos_korisnik, c.unos_dat,
                  c.izmjena_korisnik, c.izmjena_dat
             FROM ' || tablica_m          || ' c, ' ||
                       udaljena_tablica_m || ' u  ' ||
           'WHERE u.id (+) = c.id
              AND u.id IS NULL';

         EXECUTE IMMEDIATE naredba_l;
      END IF;
   END IF;


   /* Poseban postupak za PKA tablice. */
   SELECT COUNT (1) INTO brojac_l
     FROM smet_instalacije
    WHERE metcvor_sifra = metcvor_sifra_p
      AND metapl_sifra = 'PKA';

   IF brojac_l <> 0 THEN
      /* Mora se replicirati prije drugih tablica */
      tablica_m := 'SPKA_STUPCI';
      IF tab_replicira_na_cvor (metcvor_sifra_p, tablica_m) = -1 THEN
         udaljena_tablica_m := tablica_m || '@' || metcvor_sifra_p;

         naredba_l :=
         'INSERT INTO ' || udaljena_tablica_m ||
         '       (id,
                  naz_tablice,
                  naziv,
                  duljina,
                  ozn_broj,
                  ozn_zerofill,
                  ozn_slovo,
                  ozn_upper,
                  ozn_lower,
                  min_duljina,
                  ozn_duljine,
                  unos_korisnik, unos_dat,
                  izmjena_korisnik, izmjena_dat)
           SELECT c.id,
                  c.naz_tablice,
                  c.naziv,
                  c.duljina,
                  c.ozn_broj,
                  c.ozn_zerofill,
                  c.ozn_slovo,
                  c.ozn_upper,
                  c.ozn_lower,
                  c.min_duljina,
                  c.ozn_duljine,
                  c.unos_korisnik, c.unos_dat,
                  c.izmjena_korisnik, c.izmjena_dat
             FROM ' || tablica_m          || ' c, ' ||
                       udaljena_tablica_m || ' u  ' ||
           'WHERE u.id (+) = c.id
              AND u.id IS NULL';

         EXECUTE IMMEDIATE naredba_l;
      END IF;
   END IF;


   /*
   IRN 3593
   Tablica srec_stupci treba se replicirati prije drugih tablica
   bez obzira na to postoji li instalacija aplikacije REC jer neke
   REC tablice npr. m_agencije pripadaju ZMP replikaciji
   */
   tablica_m := 'SREC_STUPCI';
   IF tab_replicira_na_cvor (metcvor_sifra_p, tablica_m) = -1 THEN
      udaljena_tablica_m := tablica_m || '@' || metcvor_sifra_p;

      naredba_l :=
      'INSERT INTO ' || udaljena_tablica_m ||
      '       (id,
               naz_tablice,
               naziv,
               duljina,
               ozn_broj,
               ozn_zerofill,
               ozn_slovo,
               ozn_upper,
               ozn_lower,
               min_duljina,
               ozn_duljine,
               unos_korisnik, unos_dat,
               izmjena_korisnik, izmjena_dat)
        SELECT c.id,
               c.naz_tablice,
               c.naziv,
               c.duljina,
               c.ozn_broj,
               c.ozn_zerofill,
               c.ozn_slovo,
               c.ozn_upper,
               c.ozn_lower,
               c.min_duljina,
               c.ozn_duljine,
               c.unos_korisnik, c.unos_dat,
               c.izmjena_korisnik, c.izmjena_dat
          FROM ' || tablica_m          || ' c, ' ||
                    udaljena_tablica_m || ' u  ' ||
        'WHERE u.id (+) = c.id
           AND u.id IS NULL';

     EXECUTE IMMEDIATE naredba_l;
  END IF;
END;
PROCEDURE MIJENJAJ_POSEBNE_TAB_POCETAK
 (METCVOR_SIFRA_P IN SMET_CVOROVI.SIFRA%TYPE
 ,ID_LOG_P IN L_REPLIKACIJA_LOG.ID%TYPE
 )
 IS
--
   naredba_l VARCHAR2 (32000);
   brojac_l INTEGER;
BEGIN
   /* IMENA TABLICA MORAJU BITI PISANA VELIKIM SLOVIMA */

   /* Poseban postupak za ZMP tablice. */
   SELECT COUNT (1) INTO brojac_l
     FROM smet_instalacije
    WHERE metcvor_sifra = metcvor_sifra_p
      AND metapl_sifra = 'ZMP';

   IF brojac_l <> 0 THEN
      /* Mora se replicirati prije drugih tablica */
      tablica_m := 'S_STUPCI';
      IF tab_replicira_na_cvor (metcvor_sifra_p, tablica_m) = -1 THEN
         udaljena_tablica_m := tablica_m || '@' || metcvor_sifra_p;
         kreiraj_imena_stupaca (update_p => TRUE);

         FOR tab IN (
            SELECT tablica, id_old, id_new
              FROM l_replikacija_log
             WHERE id > id_log_p
               AND replikacija = 'D'
               AND radnja = 'U'
               AND tablica = tablica_m
             ORDER BY id)
         LOOP
            id_old_m := tab.id_old;
            id_new_m := tab.id_new;
            mijenjaj_udaljeni_redak;
         END LOOP;
      END IF;
   END IF;


   /* Poseban postupak za PKA tablice. */
   SELECT COUNT (1) INTO brojac_l
     FROM smet_instalacije
    WHERE metcvor_sifra = metcvor_sifra_p
      AND metapl_sifra = 'PKA';

   IF brojac_l <> 0 THEN
      /* Mora se replicirati prije drugih tablica */
      tablica_m := 'SPKA_STUPCI';
      IF tab_replicira_na_cvor (metcvor_sifra_p, tablica_m) = -1 THEN
         udaljena_tablica_m := tablica_m || '@' || metcvor_sifra_p;
         kreiraj_imena_stupaca (update_p => TRUE);

         FOR tab IN (
            SELECT tablica, id_old, id_new
              FROM l_replikacija_log
             WHERE id > id_log_p
               AND replikacija = 'D'
               AND radnja = 'U'
               AND tablica = tablica_m
             ORDER BY id)
         LOOP
            id_old_m := tab.id_old;
            id_new_m := tab.id_new;
            mijenjaj_udaljeni_redak;
         END LOOP;
      END IF;
   END IF;


   /*
   IRN 3593
   Tablica srec_stupci treba se replicirati prije drugih tablica
   bez obzira na to postoji li instalacija aplikacije REC jer neke
   REC tablice npr. m_agencije pripadaju ZMP replikaciji
   */
   tablica_m := 'SREC_STUPCI';
   IF tab_replicira_na_cvor (metcvor_sifra_p, tablica_m) = -1 THEN
      udaljena_tablica_m := tablica_m || '@' || metcvor_sifra_p;
      kreiraj_imena_stupaca (update_p => TRUE);

      FOR tab IN (
         SELECT tablica, id_old, id_new
           FROM l_replikacija_log
          WHERE id > id_log_p
            AND replikacija = 'D'
            AND radnja = 'U'
            AND tablica = tablica_m
          ORDER BY id)
      LOOP
         id_old_m := tab.id_old;
         id_new_m := tab.id_new;
         mijenjaj_udaljeni_redak;
      END LOOP;
   END IF;
END;
PROCEDURE UNESI_STANDARDNE_TAB
 (METCVOR_SIFRA_P IN SMET_CVOROVI.SIFRA%TYPE
 )
 IS
--
   naredba_l VARCHAR2 (32000);
   brojac_l INTEGER;
   pomoc_l   VARCHAR2 (32767);
   stupci_odrediste_l VARCHAR2(4000);
   stupci_izvor_l VARCHAR2(4000);
   def_stupci_podcentar_l VARCHAR2(4000) := NULL;
   def_vrijednosti_podcentar_l VARCHAR2(4000) := NULL;
BEGIN
   /*
   OVO NE RADIMO, JER L_REPLIKACIJA_LOG NEMA PODATKE OD POETKA RADA !!!

   Insert na objekt, za sve replikacijske tablice (replikacija = 'D'),
   kod kojih je nakon stavljanja vora van mree (id > id_log_p)
   napravljen Insert (radnja = I), i to po redoslijedu FK ovisnosti - prvo na one tablice
   koje ne ovise o drugim tablicama, pa one koje ovise samo o prethodnima itd.

   FOR tab IN (
      SELECT DISTINCT tablica
        FROM l_replikacija_log
       WHERE id > id_log_p
         AND replikacija = 'D'
         AND radnja = 'I'
         AND metapl_sifra IN (SELECT DISTINCT metapl_sifra
                                FROM smet_instalacije
                               WHERE metcvor_sifra = metcvor_sifra_p)
         AND tablica NOT IN (...)
       ORDER BY fk_level (tablica))
   LOOP
   */

   /*
   Insert na objekt, za sve replikacijske tablice (zakljuujemo po okidau AS_)
   koje pripadaju aplikacijama koje su instalirane na objektu, po redoslijedu FK ovisnosti:
   prvo na one tablice koje ne ovise o drugim tablicama, pa one koje ovise samo o prethodnima itd.
   */
   FOR tab IN (
      SELECT table_name tablica,
             trigger_body
        FROM user_triggers
       WHERE SUBSTR (trigger_name, 1, 3) = 'AS_'
         AND table_name NOT IN
             ('S_STUPCI', 'SPKA_STUPCI', 'SREC_STUPCI', 'SZMP_SUSTAVI', 'SZMP_PARAMETRI',
              'M_SIROVINE', 'M_RASTAV', 'M_ART_AMB', 'M_SASTAV', 'MGAS_KKT_ART'
             )
         AND je_tablica_ponuda (table_name) = 'N' -- nije tablica ponuda
       ORDER BY fk_level (table_name))
   LOOP
      pomoc_l := tab.trigger_body; -- ne radi INSTR (trigger_body), jer je LONG

      /*
      Ako programski kod okidaa sadri 'REC', a vor nema instalaciju 'REC',
      ili programski kod okidaa sadri 'PKA', a vor nema instalaciju 'PKA',
      ili programski kod okidaa sadri 'GAS', a vor nema instalaciju 'GAS',
      replikacija se ne radi.
      */
      IF INSTR (pomoc_l, '''REC''') <> 0 THEN
         SELECT COUNT (1) INTO brojac_l
           FROM smet_instalacije
          WHERE metcvor_sifra = metcvor_sifra_p
            AND metapl_sifra  = 'REC';

         IF brojac_l = 0 THEN
            GOTO kraj_petlje;
         END IF;
      END IF;

      IF INSTR (pomoc_l, '''PKA''') <> 0 THEN
         SELECT COUNT (1) INTO brojac_l
           FROM smet_instalacije
          WHERE metcvor_sifra = metcvor_sifra_p
            AND metapl_sifra  = 'PKA';

         IF brojac_l = 0 THEN
            GOTO kraj_petlje;
         END IF;
      END IF;

      IF INSTR (pomoc_l, '''GAS''') <> 0 THEN
         SELECT COUNT (1) INTO brojac_l
           FROM smet_instalacije
          WHERE metcvor_sifra = metcvor_sifra_p
            AND metapl_sifra  = 'GAS';

         IF brojac_l = 0 THEN
            GOTO kraj_petlje;
         END IF;
      END IF;

      tablica_m := tab.tablica;
      IF tab_replicira_na_cvor (metcvor_sifra_p, tablica_m) = 0 THEN
         GOTO kraj_petlje;
      END IF;


      IF tablica_m = 'TPKA_TECAJNICE' THEN
         /* Teajnice se mogu unositi i na objektu, pa ih prije INSERT treba brisati. */
         naredba_l :=
         '  DELETE tpka_tec_val@' || metcvor_sifra_p ||
         '   WHERE pkatec_id IN
                   (SELECT o.id
                      FROM tpka_tecajnice@' || metcvor_sifra_p || ' o,
                           tpka_tecajnice c
                     WHERE (o.ban_id = c.ban_id AND o.vtec_id = c.vtec_id AND o.datum = c.datum
                            OR
                            o.ban_id = c.ban_id AND o.godina = c.godina AND o.broj = c.broj AND o.vtec_id = c.vtec_id
                           )
                       AND o.id <> c.id
                   )';

         EXECUTE IMMEDIATE naredba_l;

         naredba_l :=
         '  DELETE tpka_tecajnice@' || metcvor_sifra_p ||
         '   WHERE id IN
                   (SELECT o.id
                      FROM tpka_tecajnice@' || metcvor_sifra_p || ' o,
                           tpka_tecajnice c
                     WHERE (o.ban_id = c.ban_id AND o.vtec_id = c.vtec_id AND o.datum = c.datum
                            OR
                            o.ban_id = c.ban_id AND o.godina = c.godina AND o.broj = c.broj AND o.vtec_id = c.vtec_id
                           )
                       AND o.id <> c.id
                   )';

         EXECUTE IMMEDIATE naredba_l;
      END IF;


      udaljena_tablica_m := tablica_m || '@' || metcvor_sifra_p;
      kreiraj_imena_stupaca (update_p => FALSE);

      stupci_odrediste_l := stupci_m;
      stupci_izvor_l     := 'centar.'  || REPLACE (stupci_m, ',', ', centar.');

      /* Na podcentar se mogu slati neke default vrijednosti */
      BEGIN
         IF azur_podcentar_m THEN
            SELECT default_stupci_podcentar, default_vrijednosti_podcentar
              INTO def_stupci_podcentar_l, def_vrijednosti_podcentar_l
              FROM smet_stupci_bez_repl
             WHERE UPPER (tablica) = tablica_m;

            IF def_stupci_podcentar_l IS NOT NULL AND def_vrijednosti_podcentar_l IS NOT NULL THEN
               stupci_odrediste_l := stupci_odrediste_l || ',' || def_stupci_podcentar_l;
               stupci_izvor_l     := stupci_izvor_l     || ',' || def_vrijednosti_podcentar_l;
            END IF;
         END IF;
      EXCEPTION
         WHEN NO_DATA_FOUND THEN
            NULL;
      END;

      naredba_l :=
      '  INSERT INTO ' || udaljena_tablica_m ||
      '    (' || stupci_odrediste_l || ')'   ||
      '    SELECT ' || stupci_izvor_l        ||
      '      FROM ' || tablica_m          || ' centar, ' ||
                       udaljena_tablica_m || ' objekt' ||
      '     WHERE objekt.id (+) = centar.id' ||
      '       AND objekt.id IS NULL';

      EXECUTE IMMEDIATE naredba_l;

      <<kraj_petlje>> NULL;
   END LOOP;
END;
PROCEDURE UNESI_POSEBNE_TAB_KRAJ
 (METCVOR_SIFRA_P IN SMET_CVOROVI.SIFRA%TYPE
 )
 IS
--
   naredba_l VARCHAR2 (32000);
   brojac_l  INTEGER;
BEGIN
   /* IMENA TABLICA MORAJU BITI PISANA VELIKIM SLOVIMA */


   /* IRN 3575; Poseban postupak za ZMP tablice. */
   SELECT COUNT (1) INTO brojac_l
     FROM smet_instalacije
    WHERE metcvor_sifra = metcvor_sifra_p
      AND metapl_sifra = 'ZMP';

   IF brojac_l <> 0 THEN
      /*
      Tablica s_vlasnik nije replikacijska, ali ima obaveznu vezu
      na tablicu s_valute koja je replikacijska, pa se s_vlasnik
      moe napuniti nakon punjenja tablice s_valute.
      Stupci od domval0_id do ozn_tecaja0 nisu obvezni, ali se zbog
      dvojnog iskazivanja trebaju puniti do 31.12.2023.
      */
      tablica_m := 'S_VLASNIK';
      udaljena_tablica_m := tablica_m || '@' || metcvor_sifra_p;
      /*
      IRN 3593
      Vrijednost u s_vlasnik.sifra na shemi podcentar ne mora biti jednaka
      vrijednosti s_vlasnik.sifra na shemi centar, pa se ne moe koristiti
      WHERE u.sifra (+) = c.sifra AND u.sifra IS NULL
      */ 
      naredba_l := 'SELECT COUNT (1) FROM ' || udaljena_tablica_m;
      EXECUTE IMMEDIATE naredba_l INTO brojac_l;
      IF brojac_l = 0 THEN
         naredba_l :=
            'INSERT INTO ' || udaljena_tablica_m ||
            '       (sifra,
                     naziv,
                     naz_licence,
                     br_licence,
                     verzija,
                     sifra_tekuceg_cvora,
                     domval_id,
                     dat_primjene_domval,
                     ozn_tecaja,
                     domval0_id,
                     izn_tecaja,
                     dat_ispis_2val_poc,
                     dat_ispis_2val_zav,
                     dat_optjecaj_2val_zav,
                     ozn_tecaja0)
              SELECT c.sifra,
                     c.naziv,
                     ''*Licenca (instal_o)'',
                     ''*ZMP2'',
                     c.verzija,
                     :metcvor_sifra_p,
                     c.domval_id,
                     c.dat_primjene_domval,
                     c.ozn_tecaja,
                     c.domval0_id,
                     c.izn_tecaja,
                     c.dat_ispis_2val_poc,
                     c.dat_ispis_2val_zav,
                     c.dat_optjecaj_2val_zav,
                     c.ozn_tecaja0
                FROM ' || tablica_m || ' c ';
         EXECUTE IMMEDIATE naredba_l USING metcvor_sifra_p;
      END IF;
      -- KRAJ IRN 3593
   END IF;


   /* Poseban postupak za GAS tablice zbog poslovnog pravila. */
   SELECT COUNT (1) INTO brojac_l
     FROM smet_instalacije
    WHERE metcvor_sifra = metcvor_sifra_p
      AND metapl_sifra = 'GAS';

   IF brojac_l <> 0 THEN
      /*
      Repliciraju se sirovine koje imaju oznaku valjanosti "V",
      ali se prvo alje oznaka valjanosti "N", jer se rastav replicira poslije.
      */
      tablica_m := 'M_SIROVINE';
      IF tab_replicira_na_cvor (metcvor_sifra_p, tablica_m) = -1 THEN
         udaljena_tablica_m := tablica_m || '@' || metcvor_sifra_p;

            naredba_l :=
            '  INSERT INTO ' || udaljena_tablica_m ||
            '         (id,
                       sifra,
                       naziv,
                       naz_dodatni,
                       gtehsir_id,
                       jm_dobavljaca,
                       jm,
                       odnos_jm_b,
                       odnos_jm_n,
                       kalo_odmrzavanja,
                       kalo_obrade,
                       ozn_smjestaja,
                       zad_nab_cijena,
                       dat_azur_nc,
                       ozn_valjanosti,
                       unos_korisnik, unos_dat,
                       izmjena_korisnik, izmjena_dat,
                       ean_kod,
                       naz_kod,
                       ozn_kod)
                SELECT c.id,
                       c.sifra,
                       c.naziv,
                       c.naz_dodatni,
                       c.gtehsir_id,
                       c.jm_dobavljaca,
                       c.jm,
                       c.odnos_jm_b,
                       c.odnos_jm_n,
                       c.kalo_odmrzavanja,
                       c.kalo_obrade,
                       c.ozn_smjestaja,
                       0,    -- c.zad_nab_cijena,
                       NULL, -- c.dat_azur_nc,
                       ''N'',
                       c.unos_korisnik, c.unos_dat,
                       c.izmjena_korisnik, c.izmjena_dat,
                       c.ean_kod,
                       c.naz_kod,
                       c.ozn_kod
                  FROM ' || tablica_m          || ' c, ' ||
                            udaljena_tablica_m || ' u  ' ||
                'WHERE u.id (+) = c.id
                   AND u.id IS NULL
                   AND c.ozn_valjanosti = ''V'' ';
         EXECUTE IMMEDIATE naredba_l;
      END IF;

      tablica_m := 'M_RASTAV';
      IF tab_replicira_na_cvor (metcvor_sifra_p, tablica_m) = -1 THEN
         udaljena_tablica_m := tablica_m || '@' || metcvor_sifra_p;

         naredba_l :=
         '  INSERT INTO ' || udaljena_tablica_m ||
         '         (id,
                    sir_id,
                    nam_id,
                    udio_namirnice,
                    unos_korisnik, unos_dat,
                    izmjena_korisnik, izmjena_dat)
             SELECT c.id,
                    c.sir_id,
                    c.nam_id,
                    c.udio_namirnice,
                    c.unos_korisnik, c.unos_dat,
                    c.izmjena_korisnik, c.izmjena_dat
               FROM ' || tablica_m          || ' c, ' ||
                         udaljena_tablica_m || ' u  ' ||
             'WHERE u.id (+) = c.id
                AND u.id IS NULL';

         EXECUTE IMMEDIATE naredba_l;
      END IF;

      tablica_m := 'M_ART_AMB';
      IF tab_replicira_na_cvor (metcvor_sifra_p, tablica_m) = -1 THEN
         udaljena_tablica_m := tablica_m || '@' || metcvor_sifra_p;

         naredba_l :=
         '  INSERT INTO ' || udaljena_tablica_m ||
         '         (id,
                    amb_id,
                    sir_id,
                    nam_id,
                    odnos_art_amb,
                    unos_korisnik, unos_dat,
                    izmjena_korisnik, izmjena_dat)
             SELECT c.id,
                    c.amb_id,
                    c.sir_id,
                    c.nam_id,
                    c.odnos_art_amb,
                    c.unos_korisnik, c.unos_dat,
                    c.izmjena_korisnik, c.izmjena_dat
               FROM ' || tablica_m          || ' c, ' ||
                         udaljena_tablica_m || ' u  ' ||
             'WHERE u.id (+) = c.id
                AND u.id IS NULL
                AND (c.sir_id IS NULL
                     OR
                    (SELECT ozn_valjanosti FROM m_sirovine WHERE id = c.sir_id) = ''V''
                    )';

         EXECUTE IMMEDIATE naredba_l;
      END IF;

      tablica_m := 'MGAS_KKT_ART';
      IF tab_replicira_na_cvor (metcvor_sifra_p, tablica_m) = -1 THEN
         udaljena_tablica_m := tablica_m || '@' || metcvor_sifra_p;

         naredba_l :=
         '  INSERT INTO ' || udaljena_tablica_m ||
         '         (id,
                    kkt_id,
                    sir_id,
                    nam_id,
                    pro_id,
                    unos_korisnik, unos_dat,
                    izmjena_korisnik, izmjena_dat)
             SELECT c.id,
                    c.kkt_id,
                    c.sir_id,
                    c.nam_id,
                    c.pro_id,
                    c.unos_korisnik, c.unos_dat,
                    c.izmjena_korisnik, c.izmjena_dat
               FROM ' || tablica_m          || ' c, ' ||
                         udaljena_tablica_m || ' u  ' ||
             'WHERE u.id (+) = c.id
                AND u.id IS NULL
                AND (c.sir_id IS NULL
                     OR
                    (SELECT ozn_valjanosti FROM m_sirovine WHERE id = c.sir_id) = ''V''
                    )';

         EXECUTE IMMEDIATE naredba_l;
      END IF;
   END IF;
END;
PROCEDURE MIJENJAJ_STANDARDNE_TAB
 (METCVOR_SIFRA_P IN SMET_CVOROVI.SIFRA%TYPE
 ,ID_LOG_P IN L_REPLIKACIJA_LOG.ID%TYPE
 )
 IS
--
   naredba_l VARCHAR2 (32000);
BEGIN
   /*
   Update na objekt, na temelju svih radnji Update (radnja = U) na replikacijskim tablicama (replikacija = 'D'),
   nakon stavljanja vora van mree (id > id_log_p).

   U pomonu (GTT) tablicu pamte se imena tablica i svih ID-ova redaka koji su mijenjani.
   Napomena: ID nije mogao biti mijenjan, jer je zabranjeno mijenjati ID ako nisu svi vorovi u mrei.
   */

   DELETE p_zaj; -- brie se za svaki sluaj, iako se ovdje brie i na kraju

   INSERT INTO p_zaj (naziv, id)
      SELECT tablica, id_old
        FROM l_replikacija_log
       WHERE id > id_log_p
         AND replikacija = 'D'
         AND radnja = 'U'
         AND metapl_sifra IN (
             SELECT DISTINCT metapl_sifra
               FROM smet_instalacije
              WHERE metcvor_sifra = metcvor_sifra_p
             )
         AND tablica NOT IN ('S_STUPCI', 'SPKA_STUPCI', 'SREC_STUPCI', 'M_SIROVINE', 'M_SASTAV')
         AND je_tablica_ponuda (tablica) = 'N' -- nije tablica ponuda
       GROUP BY tablica, id_old;

   /*
   Ide se po mijenjanim tablicama evidentiranim u pomonoj tablici (redoslijed po fk_level),
   i radi se UPDATE svih mijenjanih redaka jedne tablice, kroz jednu UPDATE naredbu.
   */
   FOR tab IN (
      SELECT DISTINCT naziv
        FROM p_zaj
       ORDER BY fk_level (naziv))
   LOOP
      tablica_m := tab.naziv;
      IF tab_replicira_na_cvor (metcvor_sifra_p, tablica_m) = 0 THEN
         GOTO kraj_petlje;
      END IF;

      udaljena_tablica_m := tablica_m || '@' || metcvor_sifra_p;

      kreiraj_imena_stupaca (update_p => TRUE);

      naredba_l :=
      '  BEGIN'                                    ||
      '     UPDATE ' || udaljena_tablica_m || ' x' ||
      '        SET (' || stupci_m || ') ='         ||
      '            (SELECT ' || stupci_m           ||
      '               FROM ' || tablica_m          ||
      '              WHERE id = x.id'              ||
      '            )'                              ||
      '      WHERE id IN (SELECT id FROM p_zaj WHERE naziv = :tablica_m);' ||
      '  END;';

      EXECUTE IMMEDIATE naredba_l USING tablica_m;

      <<kraj_petlje>> NULL;
   END LOOP;

   DELETE p_zaj;
END;
PROCEDURE MIJENJAJ_POSEBNE_TAB_KRAJ
 (METCVOR_SIFRA_P IN SMET_CVOROVI.SIFRA%TYPE
 ,ID_LOG_P IN L_REPLIKACIJA_LOG.ID%TYPE
 )
 IS
--
   naredba_l VARCHAR2 (32000);
   brojac_l INTEGER;
BEGIN
   /* IMENA TABLICA MORAJU BITI PISANA VELIKIM SLOVIMA */

   /* Poseban postupak za GAS tablice. */
   SELECT COUNT (1) INTO brojac_l
     FROM smet_instalacije
    WHERE metcvor_sifra = metcvor_sifra_p
      AND metapl_sifra = 'GAS';

   IF brojac_l <> 0 THEN
      /*
      M_SASTAV ne moe se unijeti (pa onda ni mijenjati) dok ne proe UPDATE na M_PROIZVODI,
      zbog pravila vezanog za stupac RAZINA u M_PROIZVODI.
      */
      tablica_m := 'M_SASTAV';
      IF tab_replicira_na_cvor (metcvor_sifra_p, tablica_m) = -1 THEN
         udaljena_tablica_m := tablica_m || '@' || metcvor_sifra_p;

         /*
         Update se radi prije INSERT zato to se moe desiti da korisnik napravi UPDATE sa novim artiklom,
         a onda prethodni artikal unese u novu stavku,
         pa bi se onda desio ORA-00001: unique constraint (GASSAS_UK) violated.
         */

         DELETE p_zaj; -- brie se za svaki sluaj, iako se ovdje brie i na kraju

         INSERT INTO p_zaj (naziv, id)
            SELECT 'M_SASTAV', id_old
              FROM l_replikacija_log
             WHERE id > id_log_p
               AND replikacija = 'D'
               AND radnja = 'U'
               AND UPPER (tablica) = 'M_SASTAV'
             GROUP BY id_old;

         kreiraj_imena_stupaca (update_p => TRUE);

         naredba_l :=
         '  BEGIN'                                    ||
         '     UPDATE ' || udaljena_tablica_m || ' x' ||
         '        SET (' || stupci_m || ') ='         ||
         '            (SELECT ' || stupci_m           ||
         '               FROM ' || tablica_m          ||
         '              WHERE id = x.id'              ||
         '            )'                              ||
         '      WHERE id IN (SELECT id FROM p_zaj);'  ||
         '  END;';

         EXECUTE IMMEDIATE naredba_l;

         DELETE p_zaj;


         naredba_l :=
         '  INSERT INTO ' || udaljena_tablica_m ||
         '         (id,
                    pro_id,
                    nam_id,
                    pro_id_poluproizvod,
                    normativ,
                    unos_korisnik, unos_dat,
                    izmjena_korisnik, izmjena_dat)
             SELECT c.id,
                    c.pro_id,
                    c.nam_id,
                    c.pro_id_poluproizvod,
                    c.normativ,
                    c.unos_korisnik, c.unos_dat,
                    c.izmjena_korisnik, c.izmjena_dat
               FROM ' || tablica_m          || ' c, ' ||
                         udaljena_tablica_m || ' u  ' ||
             'WHERE u.id (+) = c.id
                AND u.id IS NULL';

         EXECUTE IMMEDIATE naredba_l;
      END IF;


      tablica_m := 'M_SIROVINE';
      IF tab_replicira_na_cvor (metcvor_sifra_p, tablica_m) = -1 THEN
         udaljena_tablica_m := tablica_m || '@' || metcvor_sifra_p;
         kreiraj_imena_stupaca (update_p => TRUE);

         FOR tab IN (
            SELECT tablica, id_old, id_new
              FROM l_replikacija_log
             WHERE id > id_log_p
               AND replikacija = 'D'
               AND radnja = 'U'
               AND tablica = tablica_m
             ORDER BY id)
         LOOP
            id_old_m := tab.id_old;
            id_new_m := tab.id_new;
            mijenjaj_udaljeni_redak;
         END LOOP;

         /* Postavljenje oznake valjanosti na "V", jer nije moglo biti "V" dok se ne replicira rastav */
         naredba_l :=
         '  UPDATE ' || udaljena_tablica_m ||
         '     SET ozn_valjanosti = ''V''' ||
         '   WHERE ozn_valjanosti = ''P''' ||
         '      OR ozn_valjanosti = ''N''';

         EXECUTE IMMEDIATE naredba_l;
      END IF;
   END IF;
END;
PROCEDURE KREIRAJ_IMENA_STUPACA
 (UPDATE_P IN BOOLEAN
 ,UKLJUCITI_BLOB_P IN BOOLEAN := TRUE
 )
 IS
--
   slati_audit_polja_c CONSTANT VARCHAR2 (1) := 'D';
   stupci_bez_azuriranja_l VARCHAR2 (4000);
   stupci_bez_insert_l VARCHAR2 (4000);
   ukljuciti_blob_l NUMBER;
BEGIN
   IF update_p THEN
      stupci_bez_insert_l := stupci_bez_insert;

      IF stupci_bez_insert_l IS NULL THEN
         stupci_bez_azuriranja_l := stupci_bez_update;
      ELSE
         /* Ako se stupcu ne radi INSERT, automatski se ne radi niti UPDATE */
         stupci_bez_azuriranja_l := stupci_bez_update || ',' || stupci_bez_insert_l;
      END IF;
   ELSE
      stupci_bez_azuriranja_l := stupci_bez_insert;
   END IF;

   /*
   Pretvaranje u velika slova, eliminiranje blanka (da ne bi bio blank izmeu imena stupca i zareza),
   te dodavanje zareza ispred prvog i iza zadnjeg stupca.
   Zarez ispred i iza imena stupca potreban je zato jer bi bez zareza INSTR mogao nai
   da se npr. 'SIFRA' nalazi u 'SIFRA_MT', a sa zarezom e traiti tono ',SIFRA,'.
   */
   stupci_bez_azuriranja_l :=
      ',' || UPPER (REPLACE (stupci_bez_azuriranja_l, ' ')) || ',';

   IF slati_audit_polja_c = 'N' THEN
      /* Mora pisati zarez iza IZMJENA_DAT */
      stupci_bez_azuriranja_l := stupci_bez_azuriranja_l ||
         'UNOS_KORISNIK,UNOS_DAT,IZMJENA_KORISNIK,IZMJENA_DAT,';
   END IF;

   stupci_m := NULL;

   IF ukljuciti_blob_p THEN
      ukljuciti_blob_l := 1;
   ELSE
      ukljuciti_blob_l := 0;
   END IF;

   FOR tabcol IN (
      SELECT column_name
        FROM user_tab_columns
       WHERE table_name = tablica_m
         AND (ukljuciti_blob_l = 1 OR data_type <> 'BLOB')
       ORDER BY column_id)
   LOOP
      /*
      Da li se u popisu stupaca koji se ne auriraju nalazi zarez + ime stupca + zarez ?
      Ako se nalazi u popisu, onda se taj stupac preskae.
      */
      IF stupci_bez_azuriranja_l IS NULL
         OR INSTR (stupci_bez_azuriranja_l, ',' || tabcol.column_name || ',') = 0
      THEN
         stupci_m := stupci_m || ',' || tabcol.column_name;
      END IF;
   END LOOP;

   stupci_m := SUBSTR (stupci_m, 2); -- skida se poetni zarez
END;
FUNCTION STUPCI_BEZ_INSERT
 RETURN VARCHAR2
 IS
--
   stupci_bez_insert_l VARCHAR2 (4000) := NULL;
BEGIN
   BEGIN
      IF azur_podcentar_m THEN
         SELECT stupci_bez_insert_podcentar
           INTO stupci_bez_insert_l
           FROM smet_stupci_bez_repl
          WHERE UPPER (tablica) = tablica_m;
      ELSE
         SELECT stupci_bez_insert_objekt
           INTO stupci_bez_insert_l
           FROM smet_stupci_bez_repl
          WHERE UPPER (tablica) = tablica_m;
      END IF;
   EXCEPTION
      WHEN NO_DATA_FOUND THEN
         NULL;
   END;

   RETURN stupci_bez_insert_l;
END;
FUNCTION STUPCI_BEZ_UPDATE
 RETURN VARCHAR2
 IS
--
   stupci_bez_update_l VARCHAR2 (4000) := NULL;
BEGIN
   BEGIN
      IF azur_podcentar_m THEN
         SELECT stupci_bez_update_podcentar
           INTO stupci_bez_update_l
           FROM smet_stupci_bez_repl
          WHERE UPPER (tablica) = tablica_m;
      ELSE
         SELECT stupci_bez_update_objekt
           INTO stupci_bez_update_l
           FROM smet_stupci_bez_repl
          WHERE UPPER (tablica) = tablica_m;
      END IF;
   EXCEPTION
      WHEN NO_DATA_FOUND THEN
         NULL;
   END;

   RETURN stupci_bez_update_l;
END;
PROCEDURE AZUR_IZVJ_NA_OBJEKTU
 (METCVOR_SIFRA_P IN SMET_CVOROVI.SIFRA%TYPE
 )
 IS
-- prilikom ukljuivanja vora u mreu se ide preko oznaka u lpka_izv_cvor:
-- K treba kopirati i aurirati log sa O(bavljeno)
-- B brisati i brisati log
-- N nulirati ostvareno i aurirati log sa O i 0 = ozn_ostvareno
   naredba_l VARCHAR2(4000);
BEGIN
  -- brisanje
   naredba_l :=
      'DELETE FROM ipka_izv_vsizv@' || metcvor_sifra_p || ' pkaizvvsizv
        WHERE pkaizvvsizv.pkaizvvizv_id IN (
              SELECT pkaizvcvor.pkaizvvizv_id
                FROM lpka_izv_cvor pkaizvcvor
               WHERE ozn_izvcvor = ''B''
                 AND metcvor_sifra = :1)';

   EXECUTE IMMEDIATE naredba_l USING metcvor_sifra_p;

   naredba_l :=
      'DELETE FROM ipka_izv_vizv@' || metcvor_sifra_p || ' pkaizvvizv
        WHERE pkaizvvizv.id IN (
              SELECT pkaizvcvor.pkaizvvizv_id
                FROM lpka_izv_cvor pkaizvcvor
               WHERE ozn_izvcvor = ''B''
                 AND metcvor_sifra = :1)';

   EXECUTE IMMEDIATE naredba_l USING metcvor_sifra_p;

   -- kod ponitavanja se ide preko pkaizvhij_id jer se tada zna, tu se ne zna pa se briu sve pkaizvhij koje nemaju djece i
   -- pripadaju zaglavlju ije se hijerarhije briu
   naredba_l :=
      'DELETE FROM ipka_izv_hij@' || metcvor_sifra_p || ' pkaizvhij
        WHERE NOT EXISTS (
              SELECT 1 FROM ipka_izv_vizv@' || metcvor_sifra_p || ' pkaizvvizv
               WHERE pkaizvvizv.pkaizvhij_id = pkaizvhij.id)
                 AND pkaizvhij.pkaizv_id IN (
                     SELECT pkaizv_id
                       FROM lpka_izv_cvor
                      WHERE ozn_izvcvor = ''B''
                        AND metcvor_sifra = :1)';

   EXECUTE IMMEDIATE naredba_l USING metcvor_sifra_p;

   naredba_l :=
      'DELETE FROM ipka_izvjestaji@' || metcvor_sifra_p || ' pkaizvjestaji
        WHERE pkaizvjestaji.id IN (
              SELECT pkaizv_id
                FROM lpka_izv_cvor
               WHERE ozn_izvcvor = ''B''
                 AND metcvor_sifra = :1
              MINUS
              SELECT pkaizv_id
               FROM lpka_izv_cvor
              WHERE ozn_izvcvor <> ''B''
                AND metcvor_sifra = :2)';

   EXECUTE IMMEDIATE naredba_l USING metcvor_sifra_p, metcvor_sifra_p;

   DELETE FROM lpka_izv_cvor
    WHERE ozn_izvcvor = 'B'
      AND metcvor_sifra = metcvor_sifra_p;

   -- nuliranje ostvarenog po objektima prema oznakama u logu
   naredba_l :=
      'UPDATE ipka_izv_vsizv@' || metcvor_sifra_p || ' pkaizvvsizv
          SET ostvareno = 0, ost_mjesec = 0, ost_godina = 0
        WHERE pkaizvvsizv.pkaizvvizv_id IN (
              SELECT pkaizvcvor.pkaizvvizv_id
                FROM lpka_izv_cvor pkaizvcvor
               WHERE ozn_izvcvor = ''N''
                 AND metcvor_sifra = :1)';

   EXECUTE IMMEDIATE naredba_l USING metcvor_sifra_p;

   -- ipka_izv_vizv - NE MIJENJA SE

   -- treba aurirati pkaizvhij, ita se iz pkaizvvizv koji se nuliraju
   naredba_l :=
      'UPDATE ipka_izv_hij@' || metcvor_sifra_p || ' pkaizvhij
          SET ozn_ostvareno = 0
        WHERE pkaizvhij.id IN (
              SELECT pkaizvhij_id
                FROM ipka_izv_vizv
               WHERE id IN (
                     SELECT pkaizvcvor.pkaizvvizv_id
                       FROM lpka_izv_cvor pkaizvcvor
                      WHERE ozn_izvcvor = ''N''
                        AND metcvor_sifra = :1)
              )';

   EXECUTE IMMEDIATE naredba_l USING metcvor_sifra_p;

   -- oznaiti zaglavlje na objektu prema zaglavlju na centru
   naredba_l :=
      'UPDATE ipka_izvjestaji@' || metcvor_sifra_p || ' pkaizvjestaji
          SET ozn_ostvareno = 0
        WHERE pkaizvjestaji.id IN (
              SELECT pkaizvcvor.pkaizv_id
                FROM lpka_izv_cvor pkaizvcvor, ipka_izvjestaji pkaizv
               WHERE pkaizvcvor.pkaizv_id =  pkaizv.id
                 AND pkaizvcvor.ozn_izvcvor = ''N''
                 AND pkaizv.ozn_ostvareno = 0
                 AND pkaizvcvor.metcvor_sifra = :1)';
   EXECUTE IMMEDIATE naredba_l USING metcvor_sifra_p;

   UPDATE lpka_izv_cvor
      SET ozn_izvcvor = 'O', ozn_ostvareno = 0  -- N ponitava samo ostvareno, za plan mora ostati zapis da je kopiran
    WHERE ozn_izvcvor = 'N'
      AND metcvor_sifra = metcvor_sifra_p;

   -- Kopiranje. Ista procedura se koristi u BM_PKA3010 kod kopiranja DI na objekte
   kopiraj_di_na_cvor (metcvor_sifra_p);

END;
FUNCTION PONUDA_PROVJERENA
 (PON_ID_P IN T_PONUDE.ID%TYPE
 )
 RETURN BOOLEAN
 IS
--
   ozn_book_l t_ponude.ozn_book%TYPE;
   brojac_l INTEGER;
BEGIN
   /*
   Replikacija se radi ako je zadovoljen jedan od uvjeta u T_PONUDE:
   - oznaka = 'V'
   - oznaka = 'P' AND ozn_book IS NOT NULL
   U svim tim sluajevima (i samo u tim sluajevima) zajedniko je - ozn_book IS NOT NULL.
   */

   SELECT ozn_book
     INTO ozn_book_l
     FROM t_ponude
    WHERE id = pon_id_p;

   IF ozn_book_l IS NULL THEN
      RETURN FALSE;
   END IF;

   /* Ako neki vor, na koji je poslana ponuda nije u mrei, javlja greku */
   SELECT COUNT (1) INTO brojac_l
     FROM smet_cvorovi cvor,
          mzmp_ojr     ojr,
          t_pon_ojr    ponojr
    WHERE ponojr.pon_id = pon_id_p
      AND ponojr.zmpojr_id = ojr.id
      AND NVL (ojr.metcvor_sifra, ojr.metcvor_sifra_gas) = cvor.sifra
      AND cvor.ozn_u_mrezi = 0;

   IF brojac_l <> 0 THEN
      -- vor, na koji se alje dokument, nije u mrei.
      pra_rec_zaj.vrati_poruku (-20230);
   END IF;

   RETURN TRUE; -- samo ako prethodna provjera proe
END;
PROCEDURE REPLICIRAJ_DJECU_ZA_PONUDE
 IS
--
   plsql_tab_l  plsql_tab_t; -- lokalna PL/SQL tablica
   broj_sloga_l BINARY_INTEGER;
   pon_id_l     t_ponude.id%TYPE;
BEGIN
   /* Samo centar aurira po mrei */
   IF pra_zmp_zaj.centar = 0 THEN
      RETURN;
   END IF;

   /*
   Puni lokalnu PL/SQL tablicu iz globalne PL/SQL tablice,
   zato jer e se globalna PL/SQL tablica koristiti za djecu, u proceduri REPLICIRAJ_RETKE.
   */
   plsql_tab_l  := plsql_tab_m;
   broj_sloga_l := broj_sloga_m;

   FOR brojac IN 1..broj_sloga_l LOOP
      IF plsql_tab_l (brojac).rec_replicirati_djecu THEN
         pon_id_l := plsql_tab_l (brojac).rec_id_new;
         repl_djecu_za_ponudu (pon_id_l, 'INSERTING');
      END IF;
   END LOOP;
END;
PROCEDURE REPLICIRAJ_PONUDU_I_DJECU
 IS
--
   plsql_tab_l     plsql_tab_t; -- lokalna PL/SQL tablica
   broj_sloga_l    BINARY_INTEGER;
   pon_id_l        t_pon_ojr.pon_id%TYPE;
   zmpojr_id_l     t_pon_ojr.zmpojr_id%TYPE;
   pon_ozn_book_l  t_ponude.ozn_book%TYPE;
   metcvor_sifra_l mzmp_ojr.metcvor_sifra%TYPE;
BEGIN
   /* Samo centar aurira po mrei */
   IF pra_zmp_zaj.centar = 0 THEN
      RETURN;
   END IF;

   /*
   Puni lokalnu PL/SQL tablicu iz globalne PL/SQL tablice,
   zato jer e se globalna PL/SQL tablica koristiti za djecu, u proceduri REPLICIRAJ_RETKE.
   */
   plsql_tab_l  := plsql_tab_m;
   broj_sloga_l := broj_sloga_m;

   FOR brojac IN 1..broj_sloga_l LOOP
      SELECT pon_id,   zmpojr_id
        INTO pon_id_l, zmpojr_id_l
        FROM t_pon_ojr
       WHERE id = plsql_tab_l (brojac).rec_id_new;

      /*
      Replikacija se radi ako je zadovoljen jedan od uvjeta u T_PONUDE:
      - oznaka = 'V'
      - oznaka = 'P' AND ozn_book IS NOT NULL
      U svim tim sluajevima (i samo u tim sluajevima) zajedniko je - ozn_book IS NOT NULL.
      */

      SELECT ozn_book
        INTO pon_ozn_book_l
        FROM t_ponude
       WHERE id = pon_id_l;

      IF pon_ozn_book_l IS NULL THEN
         GOTO kraj_petlje_za_retke;
      END IF;

      SELECT NVL (metcvor_sifra, metcvor_sifra_gas)
        INTO metcvor_sifra_l
        FROM mzmp_ojr
       WHERE id = zmpojr_id_l;

      IF metcvor_sifra_l IS NULL THEN
         GOTO kraj_petlje_za_retke;
      END IF;

      /*
      Procedura REPLICIRAJ_RETKE se moe pozvati iz AZURIRAJ_RETKE, ali i izvan nje.
      REPLICIRAJ_RETKE moe raditi i samo za odreeni vor - prije se napuni metcvor_sifra_m.
      */
      metcvor_sifra_m := metcvor_sifra_l;

      brisi_tab;
      napuni_tab (pon_id_l, pon_id_l);
      repliciraj_retke (
         aplikacija_p => 'REC',
         tablica_p    => 'T_PONUDE',
         radnja_p     => 'UPDATING',
         pokrenuto_iz_procedure_p => TRUE);

      repl_djecu_za_ponudu (pon_id_l, 'UPDATING');

      <<kraj_petlje_za_retke>>
      metcvor_sifra_m := NULL;
   END LOOP;
END;
FUNCTION PONUDA_REPLICIRA_NA_CVOR
 (METCVOR_SIFRA_P IN SMET_CVOROVI.SIFRA%TYPE
 )
 RETURN BOOLEAN
 IS
--
   id_l     t_ponude.id%TYPE;
   pon_id_l t_ponude.id%TYPE;
   brojac_l INTEGER;
   ponuda_replicira_na_cvor BOOLEAN;
BEGIN
   id_l := id_new_m;

   IF    tablica_m = 'T_PONUDE' THEN
      pon_id_l := id_l;
   ELSIF tablica_m = 'T_PON_DOG' THEN
      SELECT pon_id INTO pon_id_l
        FROM t_pon_dog
       WHERE id = id_l;
   ELSIF tablica_m = 'T_PON_DOGSLU' THEN
      SELECT pon_id INTO pon_id_l
        FROM t_pon_dog
       WHERE id = (SELECT pondog_id
                     FROM t_pon_dogslu
                    WHERE id = id_l
                  );
   ELSIF tablica_m = 'T_PON_NAP' THEN
      SELECT pon_id INTO pon_id_l
        FROM t_pon_nap
       WHERE id = id_l;
   ELSIF tablica_m = 'T_PON_OJR' THEN
      SELECT pon_id INTO pon_id_l
        FROM t_pon_ojr
       WHERE id = id_l;
   ELSIF tablica_m = 'T_PON_PROS' THEN
      SELECT pon_id INTO pon_id_l
        FROM t_pon_ojr
       WHERE id = (SELECT ponojr_id
                     FROM t_pon_pros
                    WHERE id = id_l
                  );
   ELSIF tablica_m = 'T_PON_OPR' THEN
      SELECT pon_id INTO pon_id_l
        FROM t_pon_ojr
       WHERE id = (SELECT ponojr_id
                     FROM t_pon_opr
                    WHERE id = id_l
                  );
   ELSIF tablica_m = 'T_PON_SO' THEN
      SELECT pon_id INTO pon_id_l
        FROM t_pon_ojr
       WHERE id = (SELECT ponojr_id
                     FROM t_pon_so
                    WHERE id = id_l
                  );
   ELSIF tablica_m = 'T_PON_SOUSL' THEN
      SELECT pon_id INTO pon_id_l
        FROM t_pon_ojr
       WHERE id = (SELECT ponojr_id
                     FROM t_pon_so
                    WHERE id = (SELECT ponso_id
                                  FROM t_pon_sousl
                                 WHERE id = id_l
                               )
                  );
   ELSIF tablica_m = 'T_PONSO_PRED' THEN
      SELECT pon_id INTO pon_id_l
        FROM t_pon_ojr
       WHERE id = (SELECT ponojr_id
                     FROM t_pon_so
                    WHERE id = (SELECT ponso_id
                                  FROM t_ponso_pred
                                 WHERE id = id_l
                               )
                  );
   ELSIF tablica_m = 'T_PONSO_SO' THEN
      SELECT pon_id INTO pon_id_l
        FROM t_pon_ojr
       WHERE id = (SELECT ponojr_id
                     FROM t_pon_so
                    WHERE id = (SELECT ponso_id
                                  FROM t_ponso_so
                                 WHERE id = id_l
                               )
                  );
   ELSIF tablica_m = 'TREC_PON_CJEUSL' THEN
      SELECT pon_id INTO pon_id_l
        FROM t_pon_ojr
       WHERE id = (SELECT ponojr_id
                     FROM t_pon_so
                    WHERE id = (SELECT ponso_id
                                  FROM trec_pon_cjeusl
                                 WHERE id = id_l
                               )
                  );
   ELSIF tablica_m = 'T_PON_VSJ' THEN
      SELECT pon_id INTO pon_id_l
        FROM t_pon_ojr
       WHERE id = (SELECT ponojr_id
                     FROM t_pon_so
                    WHERE id = (SELECT ponso_id
                                  FROM t_pon_vsj
                                 WHERE id = id_l
                               )
                  );
   ELSIF tablica_m = 'T_PON_VSJUSL' THEN
      SELECT pon_id INTO pon_id_l
        FROM t_pon_ojr
       WHERE id = (SELECT ponojr_id
                     FROM t_pon_so
                    WHERE id = (SELECT ponso_id
                                  FROM t_pon_vsj
                                 WHERE id = (SELECT ponvsj_id
                                               FROM t_pon_vsjusl
                                              WHERE id = id_l
                                            )
                               )
                  );
   ELSIF tablica_m = 'TREC_PON_BOR' THEN
      SELECT pon.id INTO pon_id_l
        FROM trec_pon_bor recponbor,
             t_pon_so ponso,
             t_pon_ojr ponojr,
             t_ponude pon
       WHERE recponbor.id = id_l
         AND ponso.id = recponbor.ponso_id
         AND ponojr.id = ponso.ponojr_id
         AND pon.id = ponojr.pon_id;
   ELSIF tablica_m = 'TREC_PON_ROK' THEN
      SELECT pon.id INTO pon_id_l
        FROM trec_pon_rok recponrok,
             t_pon_so ponso,
             t_pon_ojr ponojr,
             t_ponude pon
       WHERE recponrok.id = id_l
         AND ponso.id = recponrok.ponso_id
         AND ponojr.id = ponso.ponojr_id
         AND pon.id = ponojr.pon_id;
   ELSIF tablica_m = 'TREC_PON_VPRO' THEN
      SELECT pon.id INTO pon_id_l
        FROM trec_pon_vpro recponvpro,
             t_pon_so ponso,
             t_pon_ojr ponojr,
             t_ponude pon
       WHERE recponvpro.id = id_l
         AND ponso.id = recponvpro.ponso_id
         AND ponojr.id = ponso.ponojr_id
         AND pon.id = ponojr.pon_id;
   ELSIF tablica_m = 'TREC_PONVPRO_RAZDOBLJA' THEN
      SELECT pon_id INTO pon_id_l
        FROM trec_pon_vpro recponvpro,
             t_pon_so ponso,
             t_pon_ojr ponojr,
             t_ponude pon
       WHERE recponvpro.id = (
                   SELECT recponvpro_id
                     FROM trec_ponvpro_razdoblja
                    WHERE id = id_l)
         AND ponso.id = recponvpro.ponso_id
         AND ponojr.id = ponso.ponojr_id
         AND pon.id = ponojr.pon_id;
   ELSIF tablica_m = 'TREC_PON_VSJA' THEN
      SELECT pon_id INTO pon_id_l
        FROM t_pon_ojr
       WHERE id = (SELECT ponojr_id
                     FROM t_pon_so
                    WHERE id = (SELECT ponso_id
                                  FROM t_pon_vsj
                                 WHERE id = (SELECT ponvsj_id
                                               FROM trec_pon_vsja
                                              WHERE id = id_l
                                            )
                               )
                  );
   END IF;

   SELECT COUNT (1) INTO brojac_l
     FROM mzmp_ojr  ojr,
          t_pon_ojr ponojr
    WHERE ponojr.pon_id = pon_id_l
      AND ponojr.zmpojr_id = ojr.id
      AND NVL (ojr.metcvor_sifra, ojr.metcvor_sifra_gas) = metcvor_sifra_p;

   IF brojac_l = 0 THEN
      ponuda_replicira_na_cvor := FALSE;
   ELSE
      ponuda_replicira_na_cvor := TRUE;
   END IF;

   RETURN ponuda_replicira_na_cvor;
END;
PROCEDURE REPL_DJECU_ZA_PONUDU
 (PON_ID_P IN T_PONUDE.ID%TYPE
 ,RADNJA_P IN VARCHAR2
 )
 IS
BEGIN
   /*
   Tablice - djeca od T_PONUDE.
   Redoslijed je vaan zbog meusobne FK zavisnosti djece.
   */

   brisi_tab;

   FOR c IN (
      SELECT id
        FROM t_pon_ojr
       WHERE pon_id = pon_id_p)
   LOOP
      napuni_tab (c.id, c.id);
   END LOOP;

   repliciraj_retke (
      aplikacija_p => 'REC',
      tablica_p    => 'T_PON_OJR',
      radnja_p     => radnja_p,
      pokrenuto_iz_procedure_p => TRUE);


   brisi_tab;

   FOR c IN (
      SELECT id
        FROM t_pon_dog
       WHERE pon_id = pon_id_p)
   LOOP
      napuni_tab (c.id, c.id);
   END LOOP;

   repliciraj_retke (
      aplikacija_p => 'REC',
      tablica_p    => 'T_PON_DOG',
      radnja_p     => radnja_p,
      pokrenuto_iz_procedure_p => TRUE);


   brisi_tab;

   FOR c IN (
      SELECT id
        FROM t_pon_dogslu
       WHERE pondog_id IN (SELECT id
                             FROM t_pon_dog
                            WHERE pon_id = pon_id_p
                          ))
   LOOP
      napuni_tab (c.id, c.id);
   END LOOP;

   repliciraj_retke (
      aplikacija_p => 'REC',
      tablica_p    => 'T_PON_DOGSLU',
      radnja_p     => radnja_p,
      pokrenuto_iz_procedure_p => TRUE);


   brisi_tab;

   FOR c IN (
      SELECT id
        FROM t_pon_nap
       WHERE pon_id = pon_id_p)
   LOOP
      napuni_tab (c.id, c.id);
   END LOOP;

   repliciraj_retke (
      aplikacija_p => 'REC',
      tablica_p    => 'T_PON_NAP',
      radnja_p     => radnja_p,
      pokrenuto_iz_procedure_p => TRUE);


   /*
   Tablice - djeca od T_PON_OJR.
   Redoslijed je vaan zbog meusobne FK zavisnosti djece.
   */

   brisi_tab;

   FOR c IN (
      SELECT id
        FROM t_pon_pros
       WHERE ponojr_id IN (SELECT id
                             FROM t_pon_ojr
                            WHERE pon_id = pon_id_p
                          ))
   LOOP
      napuni_tab (c.id, c.id);
   END LOOP;

   repliciraj_retke (
      aplikacija_p => 'REC',
      tablica_p    => 'T_PON_PROS',
      radnja_p     => radnja_p,
      pokrenuto_iz_procedure_p => TRUE);


   brisi_tab;

   FOR c IN (
      SELECT id
        FROM t_pon_opr
       WHERE ponojr_id IN (SELECT id
                             FROM t_pon_ojr
                            WHERE pon_id = pon_id_p
                          ))
   LOOP
      napuni_tab (c.id, c.id);
   END LOOP;

   repliciraj_retke (
      aplikacija_p => 'REC',
      tablica_p    => 'T_PON_OPR',
      radnja_p     => radnja_p,
      pokrenuto_iz_procedure_p => TRUE);


   brisi_tab;

   FOR c IN (
      SELECT id
        FROM t_pon_so
       WHERE ponojr_id IN (SELECT id
                             FROM t_pon_ojr
                            WHERE pon_id = pon_id_p
                          ))
   LOOP
      napuni_tab (c.id, c.id);
   END LOOP;

   repliciraj_retke (
      aplikacija_p => 'REC',
      tablica_p    => 'T_PON_SO',
      radnja_p     => radnja_p,
      pokrenuto_iz_procedure_p => TRUE);


   brisi_tab;

   FOR c IN (
      SELECT id
        FROM t_pon_sousl
       WHERE ponso_id IN (SELECT id
                            FROM t_pon_so
                           WHERE ponojr_id IN (SELECT id
                                                 FROM t_pon_ojr
                                                WHERE pon_id = pon_id_p
                                              )
                         ))
   LOOP
      napuni_tab (c.id, c.id);
   END LOOP;

   repliciraj_retke (
      aplikacija_p => 'REC',
      tablica_p    => 'T_PON_SOUSL',
      radnja_p     => radnja_p,
      pokrenuto_iz_procedure_p => TRUE);


   brisi_tab;

   FOR c IN (
      SELECT id
        FROM trec_pon_cjeusl
       WHERE ponso_id IN (SELECT id
                            FROM t_pon_so
                           WHERE ponojr_id IN (SELECT id
                                                 FROM t_pon_ojr
                                                WHERE pon_id = pon_id_p
                                              )
                         ))
   LOOP
      napuni_tab (c.id, c.id);
   END LOOP;

   repliciraj_retke (
      aplikacija_p => 'REC',
      tablica_p    => 'TREC_PON_CJEUSL',
      radnja_p     => radnja_p,
      pokrenuto_iz_procedure_p => TRUE);


   brisi_tab;

   FOR c IN (
      SELECT id
        FROM t_ponso_pred
       WHERE ponso_id IN (SELECT id
                            FROM t_pon_so
                           WHERE ponojr_id IN (SELECT id
                                                 FROM t_pon_ojr
                                                WHERE pon_id = pon_id_p
                                              )
                         ))
   LOOP
      napuni_tab (c.id, c.id);
   END LOOP;

   repliciraj_retke (
      aplikacija_p => 'REC',
      tablica_p    => 'T_PONSO_PRED',
      radnja_p     => radnja_p,
      pokrenuto_iz_procedure_p => TRUE);

   brisi_tab;

   FOR c IN (
      SELECT id
        FROM t_ponso_so
       WHERE ponso_id IN (SELECT id
                            FROM t_pon_so
                           WHERE ponojr_id IN (SELECT id
                                                 FROM t_pon_ojr
                                                WHERE pon_id = pon_id_p
                                              )
                         ))
   LOOP
      napuni_tab (c.id, c.id);
   END LOOP;

   repliciraj_retke (
      aplikacija_p => 'REC',
      tablica_p    => 'T_PONSO_SO',
      radnja_p     => radnja_p,
      pokrenuto_iz_procedure_p => TRUE);

   brisi_tab;

   FOR c IN (
      SELECT id
        FROM t_pon_vsj
       WHERE ponso_id IN (SELECT id
                            FROM t_pon_so
                           WHERE ponojr_id IN (SELECT id
                                                 FROM t_pon_ojr
                                                WHERE pon_id = pon_id_p
                                              )
                         ))
   LOOP
      napuni_tab (c.id, c.id);
   END LOOP;

   repliciraj_retke (
      aplikacija_p => 'REC',
      tablica_p    => 'T_PON_VSJ',
      radnja_p     => radnja_p,
      pokrenuto_iz_procedure_p => TRUE);


   brisi_tab;

   FOR c IN (
      SELECT id
        FROM t_pon_vsjusl
       WHERE ponvsj_id IN (SELECT id
                             FROM t_pon_vsj
                            WHERE ponso_id IN (SELECT id
                                                 FROM t_pon_so
                                                WHERE ponojr_id IN (SELECT id
                                                                      FROM t_pon_ojr
                                                                     WHERE pon_id = pon_id_p
                                                                   )
                                              )
                          ))
   LOOP
      napuni_tab (c.id, c.id);
   END LOOP;

   repliciraj_retke (
      aplikacija_p => 'REC',
      tablica_p    => 'T_PON_VSJUSL',
      radnja_p     => radnja_p,
      pokrenuto_iz_procedure_p => TRUE);

   brisi_tab;

   FOR c IN (
      SELECT id
        FROM trec_pon_bor
       WHERE ponso_id IN (SELECT id
                            FROM t_pon_so
                           WHERE ponojr_id IN (SELECT id
                                                 FROM t_pon_ojr
                                                WHERE pon_id = pon_id_p
                                              )
                         ))
   LOOP
      napuni_tab (c.id, c.id);
   END LOOP;

   repliciraj_retke (
      aplikacija_p => 'REC',
      tablica_p    => 'TREC_PON_BOR',
      radnja_p     => radnja_p,
      pokrenuto_iz_procedure_p => TRUE);

   brisi_tab;

   FOR c IN (
      SELECT id
        FROM trec_pon_rok
       WHERE ponso_id IN (SELECT id
                            FROM t_pon_so
                           WHERE ponojr_id IN (SELECT id
                                                 FROM t_pon_ojr
                                                WHERE pon_id = pon_id_p
                                              )
                         ))
   LOOP
      napuni_tab (c.id, c.id);
   END LOOP;

   repliciraj_retke (
      aplikacija_p => 'REC',
      tablica_p    => 'TREC_PON_ROK',
      radnja_p     => radnja_p,
      pokrenuto_iz_procedure_p => TRUE);


   brisi_tab;

   FOR c IN (
      SELECT id
        FROM trec_pon_vpro
       WHERE ponso_id IN (SELECT id
                            FROM t_pon_so
                           WHERE ponojr_id IN (SELECT id
                                                 FROM t_pon_ojr
                                                WHERE pon_id = pon_id_p
                                              )
                         ))
   LOOP
      napuni_tab (c.id, c.id);
   END LOOP;

   repliciraj_retke (
      aplikacija_p => 'REC',
      tablica_p    => 'TREC_PON_VPRO',
      radnja_p     => radnja_p,
      pokrenuto_iz_procedure_p => TRUE);


   brisi_tab;

   FOR c IN (
      SELECT id
        FROM trec_ponvpro_razdoblja
       WHERE recponvpro_id IN (SELECT id
                                 FROM trec_pon_vpro
                                WHERE ponso_id IN (SELECT id
                                                     FROM t_pon_so
                                                    WHERE ponojr_id IN (SELECT id
                                                                          FROM t_pon_ojr
                                                                         WHERE pon_id = pon_id_p)
                                                   )
                               ))
   LOOP
      napuni_tab (c.id, c.id);
   END LOOP;

   repliciraj_retke (
      aplikacija_p => 'REC',
      tablica_p    => 'TREC_PONVPRO_RAZDOBLJA',
      radnja_p     => radnja_p,
      pokrenuto_iz_procedure_p => TRUE);

   brisi_tab;

   FOR c IN (
      SELECT id
        FROM trec_pon_vsja
       WHERE ponvsj_id IN (SELECT id
                             FROM t_pon_vsj
                            WHERE ponso_id IN (SELECT id
                                                 FROM t_pon_so
                                                WHERE ponojr_id IN (SELECT id
                                                                      FROM t_pon_ojr
                                                                     WHERE pon_id = pon_id_p
                                                                   )
                                              )
                          )
       ORDER BY ponvsj_id, kol_sj DESC, br_postelja DESC)
   LOOP
      napuni_tab (c.id, c.id);
   END LOOP;

   repliciraj_retke (
      aplikacija_p => 'REC',
      tablica_p    => 'TREC_PON_VSJA',
      radnja_p     => radnja_p,
      pokrenuto_iz_procedure_p => TRUE);
END;
PROCEDURE KOPIRAJ_PONUDE_NA_NOVI_CVOR
 (ZMPOJR_ID_P IN MZMP_OJR.ID%TYPE
 ,METCVOR_SIFRA_NEW_P IN SMET_CVOROVI.SIFRA%TYPE
 )
 IS
--
   brojac_l INTEGER;
BEGIN
   /*
   Kopiraju se sve tablice ponuda na novi vor.
   Procedura se poziva iz okidaa AS_MZMP_OJR (u petlji) i to nakon standardne replikacije MZMP_OJR,
   a prije UPDATE m_so (u petlji), koji (preko BUR_M_SO) pokree replikaciju ponuda i drugih tablica.
   Provjera da je novi vor razliit od starog, napravljena je u okidau BUR_MZMP_OJR.

   Napomena: kada bi se ova procedura pozivala iz ROW okidaa (npr. BUR ili AR),
   morala bi na poetku sauvati vrijednost globalne PL/SQL tablice (i brojaa) u lokalnu PL/SQL tablicu,
   i na kraju vratiti lokalnu PL/SQL tablicu u globalnu.
   */

   /* samo vor-centar moe objektu mijenjati ifru vora */
   IF pra_zmp_zaj.centar = 0 THEN
      -- Samo vor-centar moe kopirati ponudu/ugovor na druge vorove.
      pra_rec_zaj.vrati_poruku (-20232);
   END IF;

   /* ako je novi vor centar, ne treba kopirati */
   IF LOWER (metcvor_sifra_new_p) = LOWER (pra_zmp_zaj.tekuci_cvor) THEN
      RETURN;
   END IF;

   /* ako replikacija na novi vor nije doputena ne kopiraj */
   IF tab_replicira_na_cvor (metcvor_sifra_new_p, 't_ponude') = 0 THEN
      RETURN;
   END IF;

   /* da li ima ponuda za kopiranje */
   SELECT COUNT (1) INTO brojac_l
     FROM t_pon_ojr
    WHERE zmpojr_id = zmpojr_id_p;
   IF brojac_l = 0 THEN
      RETURN;
   END IF;

   /* da li je novi vor u mrei */
   SELECT COUNT (1) INTO brojac_l
     FROM smet_cvorovi
    WHERE sifra = metcvor_sifra_new_p
      AND ozn_u_mrezi = -1;
   IF brojac_l = 0 THEN
      -- vor, na koji se alje dokument, nije u mrei.
      pra_rec_zaj.vrati_poruku (-20230);
   END IF;

   /* da li novi vor ima instalaciju aplikacije REC */
   SELECT COUNT (1) INTO brojac_l
     FROM smet_instalacije
    WHERE metapl_sifra  = 'REC'
      AND metcvor_sifra = metcvor_sifra_new_p;
   IF brojac_l = 0 THEN
      -- vor, na koji se alje dokument, nema instalaciju aplikacije REC.
      pra_rec_zaj.vrati_poruku (-20231);
   END IF;

   /*
   Procedura REPLICIRAJ_RETKE se moe pozvati iz AZURIRAJ_RETKE, ali i izvan nje.
   REPLICIRAJ_RETKE moe raditi i samo za odreeni vor - prije se napuni metcvor_sifra_m.
   */
   metcvor_sifra_m := metcvor_sifra_new_p;

   /*
   Repliciraju se ponude (i njihova djeca) koje su vezane za MZMP_OJR kojemu se mijenja ifra vora.

   Replikacija se radi ako je zadovoljen jedan od uvjeta u T_PONUDE:
   - oznaka = 'V'
   - oznaka = 'P' AND ozn_book IS NOT NULL
   U svim tim sluajevima (i samo u tim sluajevima) zajedniko je - ozn_book IS NOT NULL.
   */
   FOR cpon IN (
      SELECT pon.id
        FROM t_pon_ojr ponojr,
             t_ponude pon
       WHERE ponojr.zmpojr_id = zmpojr_id_p
         AND pon.id = ponojr.pon_id
         AND pon.ozn_book IS NOT NULL)
   LOOP
      brisi_tab;
      napuni_tab (cpon.id, cpon.id);
      repliciraj_retke (
         aplikacija_p => 'REC',
         tablica_p    => 'T_PONUDE',
         radnja_p     => 'UPDATING',
         pokrenuto_iz_procedure_p => TRUE);

      repl_djecu_za_ponudu (cpon.id, 'UPDATING');
   END LOOP;

   metcvor_sifra_m := NULL;
END;
FUNCTION JE_TABLICA_PONUDA
 (TABLICA_P VARCHAR2
 )
 RETURN VARCHAR2
 IS
BEGIN
   IF UPPER (tablica_p) IN (
      'T_PONUDE', 'T_PON_DOG', 'T_PON_DOGSLU', 'T_PON_NAP', 'T_PON_OJR', 'T_PON_PROS',
      'T_PON_OPR', 'T_PON_SO', 'T_PON_SOUSL', 'TREC_PON_CJEUSL', 'T_PON_VSJ', 'T_PON_VSJUSL',
      'TREC_PON_BOR', 'TREC_PON_ROK', 'TREC_PON_VPRO', 'TREC_PONVPRO_RAZDOBLJA', 'TREC_PON_VSJA',
      'T_PONSO_PRED', 'T_PONSO_SO')
   THEN
      RETURN 'D';
   ELSE
      RETURN 'N';
   END IF;
END;
PROCEDURE KOPIRAJ_DI_NA_CVOR
 (METCVOR_SIFRA_P IN SMET_CVOROVI.SIFRA%TYPE
 )
 IS
-- procedura se poziva iz replikacije kod ukljuivanja vora u mreu i kopiranja u pka3010
   naredba_l VARCHAR2 (32000);
   nebitno_l NUMBER;
BEGIN
   -- Ako je plan ve bio poslan potreban je update a moda poneki insert.
   -- za zaglavlja izv, izvhij mora ii insert/update zbog prethodnih kopiranja, za izvvizv je OK jer ih je malo,
   -- za sizv bi moda bilo bolje brii/pii
   -- pretpostavka: u tablicama na centru i objektu je isti raspored stupaca.

   -- upis PKA izvjestaja (zaglavlje ve postoji ako je bilo kopirano sa izvjetajima neke druge hijerarhije ili ako je bio kopiran plan)
   FOR pkaizv IN (
      SELECT pkaizv.*
        FROM ipka_izvjestaji pkaizv
       WHERE pkaizv.id IN (
             SELECT DISTINCT pkaizv_id
               FROM lpka_izv_cvor
              WHERE ozn_izvcvor = 'K'
                AND metcvor_sifra = metcvor_sifra_p)
      )
   LOOP
      naredba_l :=
        'SELECT COUNT (1) FROM ipka_izvjestaji@' || metcvor_sifra_p || '
          WHERE id = :pkaizv_id';
      EXECUTE IMMEDIATE naredba_l INTO nebitno_l USING pkaizv.id;
      IF nebitno_l = 0 THEN
         naredba_l :=
            'INSERT INTO ipka_izvjestaji@' || metcvor_sifra_p || '
             SELECT * FROM ipka_izvjestaji WHERE id = :pkaizv_id';
         EXECUTE IMMEDIATE naredba_l USING pkaizv.id;
      ELSE
         naredba_l :=
            'UPDATE ipka_izvjestaji@' || metcvor_sifra_p || '
                SET ozn_ostvareno = :ozn_ostvareno WHERE id = :pkaizv_id';
         EXECUTE IMMEDIATE naredba_l USING pkaizv.ozn_ostvareno, pkaizv.id;
      END IF;
   END LOOP;

   -- izvhij
   FOR pkaizvhij IN (
      SELECT * FROM ipka_izv_hij
       WHERE id IN (
             SELECT pkaizvvizv.pkaizvhij_id
               FROM lpka_izv_cvor pkaizvcvor, ipka_izv_vizv pkaizvvizv
              WHERE pkaizvcvor.pkaizvvizv_id = pkaizvvizv.id
                AND pkaizvcvor.ozn_izvcvor = 'K'
                AND pkaizvcvor.metcvor_sifra = metcvor_sifra_p)
      )
   LOOP
      naredba_l :=
         'SELECT COUNT (1) FROM ipka_izv_hij@' || metcvor_sifra_p || '
           WHERE id = :pkaizvhij_id';
      EXECUTE IMMEDIATE naredba_l INTO nebitno_l USING pkaizvhij.id;
      IF nebitno_l = 0 THEN
         naredba_l :=
            'INSERT INTO ipka_izv_hij@' || metcvor_sifra_p || '
             SELECT * FROM ipka_izv_hij WHERE id = :pkaizvhij_id';
         EXECUTE IMMEDIATE naredba_l USING pkaizvhij.id;
      ELSE
         naredba_l :=
            'UPDATE ipka_izv_hij@' || metcvor_sifra_p || '
                SET ozn_ostvareno = :ozn_ostvareno WHERE id = :pkaizvhij_id';
         EXECUTE IMMEDIATE naredba_l USING pkaizvhij.ozn_ostvareno, pkaizvhij.id;
      END IF;
   END LOOP;

   -- izvvizv
   FOR pkaizvvizv IN (
      SELECT * FROM ipka_izv_vizv
       WHERE id IN (
             SELECT pkaizvvizv_id
               FROM lpka_izv_cvor
              WHERE ozn_izvcvor = 'K'
                AND metcvor_sifra = metcvor_sifra_p)
      )
   LOOP
      naredba_l :=
         'SELECT COUNT (1) FROM ipka_izv_vizv@' || metcvor_sifra_p || '
           WHERE id = :pkaizvvizv_id';
      EXECUTE IMMEDIATE naredba_l INTO nebitno_l USING pkaizvvizv.id;
      IF nebitno_l = 0 THEN
         naredba_l :=
            'INSERT INTO ipka_izv_vizv@' || metcvor_sifra_p || '
             SELECT * FROM ipka_izv_vizv WHERE id = :pkaizvvizv_id';
         EXECUTE IMMEDIATE naredba_l USING pkaizvvizv.id;

         naredba_l :=
            'INSERT INTO ipka_izv_vsizv@' || metcvor_sifra_p || '
             SELECT * FROM ipka_izv_vsizv WHERE pkaizvvizv_id = :pkaizvvizv_id';
         EXECUTE IMMEDIATE naredba_l USING pkaizvvizv.id;

      ELSE
         -- izvvizv - update ne treba
         -- izvsizv - brii - pii
         naredba_l :=
            'DELETE FROM ipka_izv_vsizv@' || metcvor_sifra_p || '
              WHERE pkaizvvizv_id = :pkaizvvizv_id';
         EXECUTE IMMEDIATE naredba_l USING pkaizvvizv.id;
         naredba_l :=
            'INSERT INTO ipka_izv_vsizv@' || metcvor_sifra_p || '
             SELECT * FROM ipka_izv_vsizv WHERE pkaizvvizv_id = :pkaizvvizv_id';
         EXECUTE IMMEDIATE naredba_l USING pkaizvvizv.id;
      END IF;
   END LOOP;

   UPDATE lpka_izv_cvor
      SET ozn_izvcvor = 'O'
    WHERE ozn_izvcvor = 'K'
      AND metcvor_sifra = metcvor_sifra_p;

END;

END REPLIKACIJA;
/
SHOW ERROR

