PROMPT Creating Package Body 'PRA_SELF_CHECK_IN'
CREATE OR REPLACE PACKAGE BODY PRA_SELF_CHECK_IN IS

LANG_M S_JEZICI.SIFRA_2A%TYPE;
SIFRA_JEZ_M S_JEZICI.SIFRA_3A%TYPE;
ACCESS_CODE_M LREC_KODOVI.KOD%TYPE;
RECKOD_ROW_M LREC_KODOVI%ROWTYPE;
CVOR_M VARCHAR2(41);
OPIS_M LREC_PROMJENE.OPIS%TYPE;
GUEST_ID_M T_GOSTI.ID%TYPE;
LOYALTY_CARD_M TLOY_KARTICE.BROJ%TYPE;
PLATE_M T_KGOSTIJU.REG_VOZILA%TYPE;
IME_M T_REZ_GOST.IME%TYPE;
PREZIME_M T_REZ_GOST.PREZIME%TYPE;
RESIDENCE_COUNTRY_M S_ZEMLJE.SIFRA_2A%TYPE;
SERVICES_TAB_M SERVICES_TAB_T;
DEPARTURE_TIME_M T_REZERVACIJE.SAT_ODLASKA%TYPE;
ARRIVAL_TIME_M T_REZERVACIJE.SAT_DOLASKA%TYPE;


FUNCTION KOD_LISTA
 (ACCESS_CODE_P IN lrec_kodovi.kod%TYPE
 ,LANG_P IN s_jezici.sifra_2a%TYPE := NULL
 )
 RETURN SYS_REFCURSOR
 IS
-- funkciju poziva Apex modul Self-Check-in
-- IRN 2956; API SELF-CHECK-IN / Access Code Data / Retrieve Access Code Data
  rc_l sys_refcursor;
BEGIN
  lang_m := lang_p;
  pra_self_check_in.zaj_set_sifra_jez_m;

  access_code_m := access_code_p;
  pra_self_check_in.zaj_set_reckod_row_m;

  IF reckod_row_m.id IS NULL
    OR (reckod_row_m.zak_id IS NULL AND reckod_row_m.rez_id IS NULL)
  THEN
    cvor_m := NULL;
  ELSE
    pra_self_check_in.zaj_set_cvor_m;
  END IF;

  IF reckod_row_m.zak_id IS NOT NULL THEN
    OPEN rc_l FOR REPLACE (pra_self_check_in.pom_zak_upit, '<CVOR>', cvor_m) USING access_code_m, access_code_m;
  ELSE
    OPEN rc_l FOR REPLACE (pra_self_check_in.pom_rez_upit, '<CVOR>', cvor_m) USING access_code_m, access_code_m;
  END IF;

  RETURN rc_l;
END;
FUNCTION USL_LISTA
 (SO_SIFRA_P IN m_so.sifra%TYPE
 ,LANG_P IN s_jezici.sifra_2a%TYPE := NULL
 )
 RETURN SYS_REFCURSOR
 IS
-- IRN 2956; API SELF-CHECK-IN / Services / Retrieve Services
  rc_l sys_refcursor;
  dat_max_l DATE := TO_DATE ('31.12.9999', 'DD.MM.RRRR');
BEGIN

  OPEN rc_l FOR
    SELECT
      usl.sifra AS code,
      NVL (usljez2.naziv, usl.naziv) AS name
    FROM
      s_usluge usl,
      (
      SELECT usljez.usl_id, usljez.naziv
        FROM s_usl_jez usljez,
             s_jezici jez
       WHERE jez.sifra_2a = lang_p
         AND usljez.jez_id = jez.id
      ) usljez2,
      mrec_so_usl recsousl,
      m_so so
    WHERE
      TRUNC (SYSDATE) BETWEEN usl.dat_valjan AND (NVL (usl.dat_ponisten, dat_max_l) - 1)
      AND usl.ozn_autocheckin = -1
      AND usl.id NOT IN (SELECT usl_id FROM s_usl_sas)
      AND usl.id = usljez2.usl_id(+)
      AND usl.id = recsousl.usl_id
      AND recsousl.so_id = so.id
      AND so.sifra = so_sifra_p
    ORDER BY name;

  RETURN rc_l;
END;
PROCEDURE CHECK_IN
 (ACCESS_CODE_P IN lrec_kodovi.kod%TYPE
 ,LANG_P IN s_jezici.sifra_2a%TYPE := NULL
 ,GUEST_ID_P IN t_rez_gost.id%TYPE
 ,FIRST_NAME_P IN t_rez_gost.ime%TYPE := NULL
 ,LAST_NAME_P IN t_rez_gost.prezime%TYPE := NULL
 ,ARRIVAL_DATE_P IN t_rezervacije.dat_dolaska%TYPE
 ,DEPARTURE_DATE_P IN t_rezervacije.dat_odlaska%TYPE
 ,PLATE_P IN t_rez_gost.reg_vozila%TYPE := NULL
 ,CITIZENSHIP_P IN s_zemlje.sifra_2a%TYPE
 ,SEX_P IN VARCHAR2
 ,BIRTH_DATE_P IN t_rez_gost.dat_rodjenja%TYPE
 ,BIRTH_COUNTRY_P IN s_zemlje.sifra_2a%TYPE
 ,TRAVEL_DOCUMENT_TYPE_P IN s_vpisprava.sifra%TYPE
 ,TRAVEL_DOCUMENT_NUMBER_P IN t_rez_gost.br_pisprave%TYPE
 ,LOYALTY_CARD_P IN tloy_kartice.broj%TYPE := NULL
 ,RESIDENCE_COUNTRY_P IN s_zemlje.sifra_2a%TYPE
 ,RESIDENCE_CITY_P IN t_rez_gost.naz_mjesta%TYPE := NULL
 ,RESIDENCE_STREET_P IN t_rez_gost.naz_ulice%TYPE := NULL
 ,PHONE_P IN t_rez_gost.br_telefona%TYPE := NULL
 ,ARRIVAL_TIME_P IN t_rezervacije.sat_dolaska%TYPE := NULL
 ,DEPARTURE_TIME_P IN t_rezervacije.sat_odlaska%TYPE := NULL
 ,SERVICES_TAB_P IN SERVICES_TAB_T
 ,RESPONSE_P OUT VARCHAR2
 )
 IS
-- proceduru poziva Apex modul Self-Check-in
-- API SELF-CHECK-IN / Check-in / Check In
  naredba_l VARCHAR2(32000);
  sc_param_1003_l szmp_parametri.vrijednost%TYPE; -- IRN 3200
BEGIN

  -- IRN 3200, dodani parametri first_name_p i last_name_p
  -- IRN 3275, dodan parametar phone_p
  -- IRN 4031, dodani parametri arrival_time_p i departure_time_p
  opis_m := SUBSTR (
    'access_code ' || access_code_p ||
      ', lang ' || lang_p ||
      ', guest_id ' || guest_id_p ||
      ', first_name_p ' || first_name_p ||
      ', last_name_p ' || last_name_p ||
      ', arrival_date ' || TO_CHAR (arrival_date_p, 'DD.MM.RRRR') ||
      ', departure_date ' || TO_CHAR (departure_date_p, 'DD.MM.RRRR') ||
      ', plate ' || plate_p ||
      ', citizenship ' || citizenship_p ||
      ', sex ' || sex_p ||
      ', birth_date ' || TO_CHAR (birth_date_p, 'DD.MM.RRRR') ||
      ', birth_country ' || birth_country_p ||
      ', travel_document_type ' || travel_document_type_p ||
      ', travel_document_number ' || travel_document_number_p ||
      ', loyalty_card ' || loyalty_card_p ||
      ', residence_country ' || residence_country_p ||
      ', residence_city ' || residence_city_p ||
      ', residence_street ' || residence_street_p ||
      ', phone ' || phone_p ||
      ', arrival_time ' || TO_CHAR (arrival_time_p, 'DD.MM.RRRR HH24:MI') ||
      ', departure_time ' || TO_CHAR (departure_time_p, 'DD.MM.RRRR HH24:MI'),
    1, 2000);

  lang_m := lang_p;
  pra_self_check_in.zaj_set_sifra_jez_m;

  -- Nedostaje obvezan ulazni parametar (#0).
  IF access_code_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku_zaj ('REC', -20422, 'access_code');
  -- lang_p
  ELSIF guest_id_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku_zaj ('REC', -20422, 'guest_id');
  -- first_name_p
  -- last_name_p
  ELSIF arrival_date_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku_zaj ('REC', -20422, 'arrival_date');
  ELSIF departure_date_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku_zaj ('REC', -20422, 'departure_date');
  -- plate_p
  ELSIF citizenship_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku_zaj ('REC', -20422, 'citizenship');
  ELSIF sex_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku_zaj ('REC', -20422, 'sex');
  ELSIF birth_date_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku_zaj ('REC', -20422, 'birth_date');
  ELSIF birth_country_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku_zaj ('REC', -20422, 'birth_country');
  ELSIF travel_document_type_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku_zaj ('REC', -20422, 'travel_document_type');
  ELSIF travel_document_number_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku_zaj ('REC', -20422, 'travel_document_number');
  -- loyalty_card_p
  ELSIF residence_country_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku_zaj ('REC', -20422, 'residence_country');
  ELSIF residence_country_p = 'HR' AND residence_city_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku_zaj ('REC', -20422, 'residence_city');
  -- residence_street_p
  -- phone_p
  -- services_tab_p
  END IF;

  -- Provjeri arrival_date_p, departure_date_p i birth_date_p
  IF TRUNC (arrival_date_p) < TRUNC (SYSDATE) -- IRN 3200
    OR TRUNC (arrival_date_p) >= TRUNC (departure_date_p)
  THEN
    -- Pogrena vrijednost parametra #0.
    pra_zmp_zaj.vrati_poruku_zaj ('REC', -20474, 'arrival_date');
  ELSIF TRUNC (birth_date_p) >= TRUNC (SYSDATE) THEN
    -- Pogrena vrijednost parametra #0.
    pra_zmp_zaj.vrati_poruku_zaj ('REC', -20474, 'birth_date');
  END IF;

  -- IRN 3713
  gost_row_g := NULL;
  kgost_row_g := NULL;
  rezgost_row_g := NULL;

  -- poetak punjenja gost_row_g (T_GOSTI) i kgost_row_g (T_KGOSTIJU)
  ime_m := UPPER (first_name_p);    -- IRN 3200
  prezime_m := UPPER (last_name_p); -- IRN 3200
  gost_row_g.dat_dolaska := arrival_date_p;
  gost_row_g.dat_odlaska := departure_date_p;
  kgost_row_g.dat_rodjenja := birth_date_p;

  IF sex_p = 'M' THEN
    kgost_row_g.ozn_spola := sex_p;
  ELSIF sex_p = 'F' THEN
    kgost_row_g.ozn_spola := '';
  ELSE
    -- Pogrena vrijednost parametra #0.
    pra_zmp_zaj.vrati_poruku_zaj ('REC', -20474, 'sex');
  END IF;

  SELECT MIN(id) INTO gost_row_g.zem_id FROM s_zemlje WHERE sifra_2a = citizenship_p;
  IF gost_row_g.zem_id IS NULL THEN
    -- Pogrena vrijednost parametra #0.
    pra_zmp_zaj.vrati_poruku_zaj ('REC', -20474, 'citizenship');
  END IF;

  SELECT MIN(id) INTO kgost_row_g.zemr_id FROM s_zemlje WHERE sifra_2a = birth_country_p;
  IF kgost_row_g.zemr_id IS NULL THEN
    -- Pogrena vrijednost parametra #0.
    pra_zmp_zaj.vrati_poruku_zaj ('REC', -20474, 'birth_country');
  END IF;

  SELECT MIN(id) INTO kgost_row_g.zem_id FROM s_zemlje WHERE sifra_2a = residence_country_p;
  IF kgost_row_g.zem_id IS NULL THEN
    -- Pogrena vrijednost parametra #0.
    pra_zmp_zaj.vrati_poruku_zaj ('REC', -20474, 'residence_country');
  END IF;

  SELECT MIN(id) INTO kgost_row_g.vpisp_id FROM s_vpisprava WHERE sifra = travel_document_type_p;
  IF kgost_row_g.vpisp_id IS NULL THEN
    -- Pogrena vrijednost parametra #0.
    pra_zmp_zaj.vrati_poruku_zaj ('REC', -20474, 'travel_document_type');
  END IF;
  kgost_row_g.br_pisprave := travel_document_number_p;

  IF residence_country_p = 'HR' THEN
    SELECT MIN (puni_naziv) INTO kgost_row_g.naz_pboravista
      FROM mzmp_evmjesta
     WHERE UPPER (puni_naziv) = UPPER (residence_city_p); -- IRN 4031
    IF kgost_row_g.naz_pboravista IS NULL THEN
      -- Pogrena vrijednost parametra #0.
      pra_zmp_zaj.vrati_poruku_zaj ('REC', -20474, 'residence_city');
    END IF;
    residence_country_m := residence_country_p; -- IRN 3729
  ELSE
    kgost_row_g.naz_mjesta := residence_city_p;
  END IF;
  kgost_row_g.naz_ulice := residence_street_p;
  kgost_row_g.br_telefona := phone_p; -- IRN 3275

  arrival_time_m := arrival_time_p; -- IRN 4031
  departure_time_m := departure_time_p; -- IRN 4031

  access_code_m := access_code_p;
  pra_self_check_in.zaj_set_reckod_row_m;

  IF reckod_row_m.id IS NULL
    OR (reckod_row_m.zak_id IS NULL AND reckod_row_m.rez_id IS NULL)
  THEN
    -- Pogrena vrijednost parametra #0.
    pra_zmp_zaj.vrati_poruku_zaj ('REC', -20474, 'access_code');
  END IF;

  pra_self_check_in.zaj_set_cvor_m;

  guest_id_m := guest_id_p;
  loyalty_card_m := loyalty_card_p;
  plate_m := plate_p;

  gost_row_g.unos_korisnik := NVL (apex_application.g_user, zmp_zaj.korisnik (-1));  -- IRN 3242, 3275
  gost_row_g.unos_dat := SYSDATE;

  kgost_row_g.unos_korisnik := NVL (apex_application.g_user, zmp_zaj.korisnik (-1)); -- IRN 3242, 3275
  kgost_row_g.unos_dat := SYSDATE;

  -- IRN 2992
  EXECUTE IMMEDIATE REPLACE (
    'BEGIN pra_rec_iud.set_audit_g<CVOR> (:unos_korisnik, SYSDATE); END;',
    '<CVOR>', cvor_m)
    USING gost_row_g.unos_korisnik; -- IRN 3242, 3275

  IF reckod_row_m.zak_id IS NOT NULL THEN
    services_tab_m := services_tab_p;
    pra_self_check_in.pom_zak_check_in;
  ELSIF reckod_row_m.rez_id IS NOT NULL THEN
    -- SC parametar 1003 Poetni sat prijave u obliku HH24 (npr. 14) ili nebitno.
    naredba_l := 'SELECT pra_zmp_zaj.zmppar_vrijednost<CVOR> (''SC'', ''1003'') FROM dual'; -- IRN 3275
    EXECUTE IMMEDIATE REPLACE (naredba_l, '<CVOR>', cvor_m) INTO sc_param_1003_l;
    IF sc_param_1003_l = 'nebitno' THEN
      sc_param_1003_l := '00';
    END IF;
    -- IRN 3200, dodan poziv procedure pom_pre_check_in
    IF TO_DATE (TO_CHAR (arrival_date_p, 'DD.MM.RRRR') || ' ' || sc_param_1003_l, 'DD.MM.RRRR HH24') > SYSDATE
      OR pra_self_check_in.pom_rez_sj_id IS NULL -- IRN 3906
    THEN
      pra_self_check_in.pom_pre_check_in;
    ELSE
      services_tab_m := services_tab_p; -- IRN 3275
      pra_self_check_in.pom_rez_check_in;
    END IF;
  END IF;

  COMMIT;

  response_p := 'OK';
  IF gost_row_g.id IS NOT NULL THEN
    response_p := response_p || ' ' || gost_row_g.id;
  ELSE
    response_p := response_p || ' ' || 'Pre-Check-in';
  END IF;

EXCEPTION
  WHEN OTHERS THEN
    ROLLBACK;
    response_p := SUBSTR ('ERROR ' || SQLERRM, 1, 2000);
    pra_rec.puni_promjene ('9321', SUBSTR (response_p || ' | ' || opis_m, 1, 2000), 0);
    RAISE;
END;
PROCEDURE DEPARTURE_CHANGE
 (ACCESS_CODE_P IN lrec_kodovi.kod%TYPE
 ,LANG_P IN s_jezici.sifra_2a%TYPE := NULL
 ,GUEST_ID_P IN t_zak_korisnici.id%TYPE
 ,NEW_DEPARTURE_DATE_P IN DATE
 ,RESPONSE_P OUT VARCHAR2
 )
 IS
-- proceduru poziva Apex modul Self-Check-in
-- API SELF-CHECK-IN / Change Departure Date / Change Departure Date

  -- za zakljuavanje tablice T_TROSKOVI
  COULD_NOT_LOCK EXCEPTION;
  PRAGMA EXCEPTION_INIT (COULD_NOT_LOCK, -54);
  nebitno_l NUMBER;

  naredba_l VARCHAR2(32000);

  rc_l SYS_REFCURSOR;
  dat_dolaska_l t_gosti.dat_dolaska%TYPE;
  dat_odlaska_l t_gosti.dat_odlaska%TYPE;
  sat_odlaska_l t_gosti.sat_odlaska%TYPE;
  ozn_prisutnosti_l t_gosti.ozn_prisutnosti%TYPE;
BEGIN

  opis_m := SUBSTR (
    'access_code ' || access_code_p ||
      ', lang ' || lang_p ||
      ', guest_id ' || guest_id_p ||
      ', new_departure_date ' || new_departure_date_p,
    1, 2000);

  lang_m := lang_p;
  pra_self_check_in.zaj_set_sifra_jez_m;

  -- Nedostaje obvezan ulazni parametar (#0).
  IF access_code_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku_zaj ('REC', -20422, 'access_code');
  -- lang_p
  ELSIF guest_id_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku_zaj ('REC', -20422, 'guest_id');
  ELSIF new_departure_date_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku_zaj ('REC', -20422, 'new_departure_date');
  END IF;

  access_code_m := access_code_p;
  pra_self_check_in.zaj_set_reckod_row_m;

  IF reckod_row_m.id IS NULL OR reckod_row_m.zak_id IS NULL THEN
    -- Pogrena vrijednost parametra #0.
    pra_zmp_zaj.vrati_poruku_zaj ('REC', -20474, 'access_code');
  END IF;

  pra_self_check_in.zaj_set_cvor_m;

  naredba_l := 'SELECT dat_dolaska, dat_odlaska, sat_odlaska, ozn_prisutnosti FROM t_gosti<CVOR> WHERE id = :guest_id_p';
  OPEN rc_l FOR REPLACE (naredba_l, '<CVOR>', cvor_m) USING guest_id_p;
  FETCH rc_l INTO dat_dolaska_l, dat_odlaska_l, sat_odlaska_l, ozn_prisutnosti_l;
  IF rc_l%NOTFOUND THEN
    CLOSE rc_l;
    -- Pogrena vrijednost parametra #0.
    pra_zmp_zaj.vrati_poruku_zaj ('REC', -20474, 'access_code');
  END IF;
  CLOSE rc_l;

  IF ozn_prisutnosti_l = 'O' THEN
    -- Pogrena vrijednost parametra #0.
    pra_zmp_zaj.vrati_poruku_zaj ('REC', -20474, 'guest_id');
  END IF;

  IF new_departure_date_p <= dat_dolaska_l
    OR new_departure_date_p = dat_odlaska_l
    OR new_departure_date_p < TRUNC (SYSDATE)
  THEN
    -- Pogrena vrijednost parametra #0.
    pra_zmp_zaj.vrati_poruku_zaj ('REC', -20474, 'new_departure_date');
  END IF;

  -- pokuaj zakljuati tablicu T_TROSKOVI
  BEGIN
    naredba_l := 'SELECT 1 FROM t_troskovi<CVOR> WHERE gost_id = :guest_id_p OR gostp_id = :guest_id_p FOR UPDATE NOWAIT';
    OPEN rc_l FOR REPLACE (naredba_l, '<CVOR>', cvor_m) USING guest_id_p, guest_id_p;
    FETCH rc_l INTO nebitno_l;
    CLOSE rc_l;
  EXCEPTION
    WHEN COULD_NOT_LOCK THEN
      -- Promjene nisu doputene dok je raun za gosta u izradi!
      pra_zmp_zaj.vrati_poruku_zaj ('REC', -20642);
  END;

  IF sat_odlaska_l IS NOT NULL
    AND TRUNC (sat_odlaska_l) = dat_odlaska_l
  THEN
    sat_odlaska_l := TO_DATE (TO_CHAR (new_departure_date_p, 'DD.MM.RRRR') || ' ' || TO_CHAR (sat_odlaska_l, 'HH24:MI'), 'DD.MM.RRRR HH24:MI');
  END IF;

  -- IRN 2992
  EXECUTE IMMEDIATE REPLACE (
    'BEGIN pra_rec_iud.set_audit_g<CVOR> (:unos_korisnik, SYSDATE); END;',
    '<CVOR>', cvor_m)
    USING NVL (apex_application.g_user, zmp_zaj.korisnik (-1)); -- IRN 3242, 3275

  naredba_l := 'BEGIN fm_rec2210.promijeni_dat_odlaska<CVOR> (:gost_id_p, :dat_odlaska_p, :sat_odlaska_l); END;';
  EXECUTE IMMEDIATE REPLACE (naredba_l, '<CVOR>', cvor_m) USING guest_id_p, new_departure_date_p, sat_odlaska_l;

  COMMIT;

  response_p := 'OK';
EXCEPTION
  WHEN OTHERS THEN
    ROLLBACK;
    response_p := SUBSTR ('ERROR ' || SQLERRM, 1, 2000);
    pra_rec.puni_promjene ('9321', SUBSTR (response_p || ' | ' || opis_m, 1, 2000), 0);
    RAISE;
END;
PROCEDURE CHECK_OUT
 (ACCESS_CODE_P IN lrec_kodovi.kod%TYPE
 ,LANG_P IN s_jezici.sifra_2a%TYPE := NULL
 ,GUEST_ID_P IN t_zak_korisnici.id%TYPE
 ,RESPONSE_P OUT VARCHAR2
 )
 IS
-- proceduru poziva Apex modul Self-Check-in
-- API SELF-CHECK-IN / Check-out / Check Out

  -- za zakljuavanje tablice T_TROSKOVI
  COULD_NOT_LOCK EXCEPTION;
  PRAGMA EXCEPTION_INIT (COULD_NOT_LOCK, -54);
  nebitno_l NUMBER;

  naredba_l VARCHAR2(32000);

  rc_l SYS_REFCURSOR;
  dat_odlaska_l t_gosti.dat_odlaska%TYPE;
  sat_odlaska_l t_gosti.sat_odlaska%TYPE;
  ozn_prisutnosti_l t_gosti.ozn_prisutnosti%TYPE;

  sc_param_1011_l szmp_parametri.vrijednost%TYPE; -- IRN 3275
  sc_param_1014_l szmp_parametri.vrijednost%TYPE; -- IRN 3275
  sc_param_p_l szmp_parametri.vrijednost%TYPE;
  sc_param_k_l szmp_parametri.vrijednost%TYPE;
  val_sifra3a_l s_valute.sifra_3a%TYPE;
  ban_id_l NUMBER;
  vtec_id_l NUMBER;
  tro_iznos_l NUMBER := 0;
  pkarnk_iznos_l NUMBER := 0;
  uk_iznos_l NUMBER;
BEGIN

  opis_m := SUBSTR (
    'access_code ' || access_code_p ||
      ', lang ' || lang_p ||
      ', guest_id ' || guest_id_p,
    1, 2000);

  pra_rec.puni_promjene ('9321', SUBSTR (opis_m, 1, 2000), -1);

  lang_m := lang_p;
  pra_self_check_in.zaj_set_sifra_jez_m;

  -- Nedostaje obvezan ulazni parametar (#0).
  IF access_code_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku_zaj ('REC', -20422, 'access_code');
  -- jez_sifra_2a_p
  ELSIF guest_id_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku_zaj ('REC', -20422, 'guest_id');
  END IF;

  access_code_m := access_code_p;
  pra_self_check_in.zaj_set_reckod_row_m;

  IF reckod_row_m.id IS NULL
    OR (reckod_row_m.zak_id IS NULL AND reckod_row_m.rez_id IS NULL)
  THEN
    -- Pogrena vrijednost parametra #0.
    pra_zmp_zaj.vrati_poruku_zaj ('REC', -20474, 'access_code');
  END IF;

  pra_self_check_in.zaj_set_cvor_m;

  -- IRN 3275
  -- SC parametar 1011 Dopustiti odjavu korisniku ugovora o zakupu: da ili ne.
  -- SC parametar 1014 Dopustiti odjavu gostu s rezervacijom: da ili ne.
  -- ZMP parametar 0001 ifra domae valute.
  naredba_l :=
    'SELECT
       pra_zmp_zaj.zmppar_vrijednost<CVOR> (''SC'', ''1011''),
       pra_zmp_zaj.zmppar_vrijednost<CVOR> (''SC'', ''1014''),
       pra_zmp_zaj.vrijednost_parametra<CVOR> (''0001'')
     FROM dual';
  EXECUTE IMMEDIATE REPLACE (naredba_l, '<CVOR>', cvor_m) INTO sc_param_1011_l, sc_param_1014_l, val_sifra3a_l;
  IF (reckod_row_m.zak_id IS NOT NULL AND sc_param_1011_l = 'ne')
    OR (reckod_row_m.rez_id IS NOT NULL AND sc_param_1014_l = 'ne')
  THEN
    -- Pogrena vrijednost parametra #0.
    pra_zmp_zaj.vrati_poruku_zaj ('REC', -20474, 'access_code');
  END IF;

  naredba_l := 'SELECT dat_odlaska, sat_odlaska, ozn_prisutnosti FROM t_gosti<CVOR> WHERE id = :guest_id_p';
  OPEN rc_l FOR REPLACE (naredba_l, '<CVOR>', cvor_m) USING guest_id_p;
  FETCH rc_l INTO dat_odlaska_l, sat_odlaska_l, ozn_prisutnosti_l;
  IF rc_l%NOTFOUND THEN
    CLOSE rc_l;
    -- Pogrena vrijednost parametra #0.
    pra_zmp_zaj.vrati_poruku_zaj ('REC', -20474, 'access_code');
  END IF;
  CLOSE rc_l;

  IF ozn_prisutnosti_l = 'O' THEN
    -- Pogrena vrijednost parametra #0.
    pra_zmp_zaj.vrati_poruku_zaj ('REC', -20474, 'guest_id');
  END IF;

  IF reckod_row_m.zak_id IS NOT NULL
    AND dat_odlaska_l < TRUNC (SYSDATE)
  THEN
    -- Datum odlaska treba biti jednak ili vei od tekueg datuma!
    pra_zmp_zaj.vrati_poruku_zaj ('REC', -20644);
  ELSIF reckod_row_m.rez_id IS NOT NULL
    AND dat_odlaska_l <> TRUNC (SYSDATE)
  THEN
    -- Datum odlaska treba biti jednak tekuem datumu!
    pra_zmp_zaj.vrati_poruku_zaj ('REC', -20652);
  END IF;


  -- Promijeni usluge ako je datum odlaska razliit od tekueg
  IF reckod_row_m.zak_id IS NOT NULL AND dat_odlaska_l > TRUNC (SYSDATE) THEN

    -- Pokuaj zakljuati tablicu T_TROSKOVI
    BEGIN
      naredba_l := 'SELECT 1 FROM t_troskovi<CVOR> WHERE gost_id = :guest_id_p FOR UPDATE NOWAIT';
      OPEN rc_l FOR REPLACE (naredba_l, '<CVOR>', cvor_m) USING guest_id_p;
      FETCH rc_l INTO nebitno_l;
      CLOSE rc_l;
    EXCEPTION
      WHEN COULD_NOT_LOCK THEN
        -- Promjene nisu doputene dok je raun za gosta u izradi!
        pra_zmp_zaj.vrati_poruku_zaj ('REC', -20642);
    END;

    IF sat_odlaska_l IS NOT NULL
      AND TRUNC (sat_odlaska_l) = dat_odlaska_l
    THEN
      sat_odlaska_l := TO_DATE (TO_CHAR (SYSDATE, 'DD.MM.RRRR') || ' ' || TO_CHAR (sat_odlaska_l, 'HH24:MI'), 'DD.MM.RRRR HH24:MI');
    END IF;

    naredba_l := 'BEGIN fm_rec2210.promijeni_dat_odlaska<CVOR> (:gost_id_p, TRUNC (SYSDATE), :sat_odlaska_l); END;';
    EXECUTE IMMEDIATE REPLACE (naredba_l, '<CVOR>', cvor_m) USING guest_id_p, sat_odlaska_l;

  END IF;


  -- Provjeri ima li neplaenih usluga
  IF reckod_row_m.zak_id IS NOT NULL THEN
    -- SC parametar 1012 Dopustiti odjavu korisniku ugovora o zakupu - platitelju neplaenih usluga: da ili ne.
    -- SC parametar 1013 Dopustiti odjavu korisniku ugovora o zakupu - korisniku neplaenih usluga: da ili ne.
    naredba_l :=
      'SELECT
         pra_zmp_zaj.zmppar_vrijednost<CVOR> (''SC'', ''1012''),
         pra_zmp_zaj.zmppar_vrijednost<CVOR> (''SC'', ''1013'')
       FROM dual';
    EXECUTE IMMEDIATE REPLACE (naredba_l, '<CVOR>', cvor_m) INTO sc_param_p_l, sc_param_k_l;
  ELSE -- IRN 3275
    -- SC parametar 1015 Dopustiti odjavu gostu s rezervacijom - platitelju neplaenih usluga: da ili ne.
    -- SC parametar 1016 Dopustiti odjavu gostu s rezervacijom - korisniku neplaenih usluga: da ili ne.
    naredba_l :=
      'SELECT
         pra_zmp_zaj.zmppar_vrijednost<CVOR> (''SC'', ''1015''),
         pra_zmp_zaj.zmppar_vrijednost<CVOR> (''SC'', ''1016'')
       FROM dual';
    EXECUTE IMMEDIATE REPLACE (naredba_l, '<CVOR>', cvor_m) INTO sc_param_p_l, sc_param_k_l;
  END IF;

  IF sc_param_p_l = 'ne' OR sc_param_k_l = 'ne' THEN
    naredba_l := 'SELECT vtec_id, ban_id FROM s_vapldok<CVOR> WHERE oznaka = ''GI'' AND metapl_sifra = ''REC''';
    EXECUTE IMMEDIATE REPLACE (naredba_l, '<CVOR>', cvor_m) INTO vtec_id_l, ban_id_l;
  END IF;

  -- Provjeri je li gost platitelj neplaenih usluga
  IF sc_param_p_l = 'ne' THEN
    naredba_l :=
     'SELECT SUM (
               tro.kol_usluge
               * (tro.dat_zav - tro.dat_poc - usl.obr_zdana)
               * tro.cijena_usluge * tro.stopa_placanja / 100 * (tro.ozn_smjesta + 1)
               * pra_pka.izn_tecaja<CVOR> (tro.val_id, :ban_id_l, :vtec_id_l, TRUNC (SYSDATE)))
        FROM s_usluge<CVOR> usl,
             t_troskovi<CVOR> tro
       WHERE tro.usl_id = usl.id
         AND (tro.rac_id IS NULL OR pra_rec_s.rac_pripada_rp<CVOR> (tro.rac_id) = -1)
         AND tro.gostp_id = :guest_id_p
         AND tro.usl_id1 IS NULL';
    EXECUTE IMMEDIATE REPLACE (naredba_l, '<CVOR>', cvor_m) INTO tro_iznos_l
      USING ban_id_l, vtec_id_l, guest_id_p;

    -- IRN 03545 : polje izn_tecaja je izbrisano, prelazak na EUR
    naredba_l :=
     'SELECT SUM (izn_placanja)
        FROM tpka_rnkasa<CVOR>
       WHERE gostp_id = :guest_id_p
         AND pra_rec_s.obracunato<CVOR> (id) = 0
         AND (rac_id IS NULL OR pra_rec_s.rac_pripada_rp<CVOR> (rac_id) = -1)
         AND pkarac_id IS NULL
         AND oznaka = ''V''
         AND pra_zmp.vpla_pripada_irn<CVOR> (vpla_id) = -1';
    EXECUTE IMMEDIATE REPLACE (naredba_l, '<CVOR>', cvor_m) INTO pkarnk_iznos_l
      USING guest_id_p;

    uk_iznos_l := NVL (tro_iznos_l, 0) + NVL (pkarnk_iznos_l, 0);
    IF uk_iznos_l <> 0 THEN
      -- Odjava nije doputena dok postoje neplaene usluge (#0 #1)!
      pra_zmp_zaj.vrati_poruku_zaj ('REC', -20643, LTRIM (TO_CHAR (uk_iznos_l, '9G999G999G990D00')), val_sifra3a_l);
    END IF;
  END IF;

  -- Provjeri je li gost korisnik neplaenih usluga
  IF sc_param_k_l = 'ne' THEN -- IRN 3329
    naredba_l :=
     'SELECT SUM (
               tro.kol_usluge
               * (tro.dat_zav - tro.dat_poc - usl.obr_zdana)
               * tro.cijena_usluge * tro.stopa_placanja / 100 * (tro.ozn_smjesta + 1)
               * pra_pka.izn_tecaja<CVOR> (tro.val_id, :ban_id_l, :vtec_id_l, TRUNC (SYSDATE)))
        FROM s_usluge<CVOR> usl,
             t_troskovi<CVOR> tro
       WHERE tro.usl_id = usl.id
         AND (tro.rac_id IS NULL OR pra_rec_s.rac_pripada_rp<CVOR> (tro.rac_id) = -1)
         AND tro.gost_id = :guest_id_p
         AND tro.usl_id1 IS NULL';
    EXECUTE IMMEDIATE REPLACE (naredba_l, '<CVOR>', cvor_m) INTO tro_iznos_l
      USING ban_id_l, vtec_id_l, guest_id_p;

    -- IRN 03545 : polje izn_tecaja je izbrisano, prelazak na EUR
    naredba_l :=
     'SELECT SUM (izn_placanja)
        FROM tpka_rnkasa<CVOR>
       WHERE gost_id = :guest_id_p
         AND pra_rec_s.obracunato<CVOR> (id) = 0
         AND (rac_id IS NULL OR pra_rec_s.rac_pripada_rp<CVOR> (rac_id) = -1)
         AND pkarac_id IS NULL
         AND oznaka = ''V''
         AND pra_zmp.vpla_pripada_irn<CVOR> (vpla_id) = -1';
    EXECUTE IMMEDIATE REPLACE (naredba_l, '<CVOR>', cvor_m) INTO pkarnk_iznos_l
      USING guest_id_p;

    uk_iznos_l := NVL (tro_iznos_l, 0) + NVL (pkarnk_iznos_l, 0);
    IF uk_iznos_l <> 0 THEN
      -- Odjava nije doputena dok postoje neplaene usluge!
      pra_zmp_zaj.vrati_poruku_zaj ('REC', -20656); -- NE prikazuje se iznos neplaenih usluga
    END IF;
  END IF;

  -- Odjavi gosta
  naredba_l := 'UPDATE t_gosti<CVOR> SET ozn_prisutnosti = ''O'' WHERE id = :guest_id_p';
  EXECUTE IMMEDIATE REPLACE (naredba_l, '<CVOR>', cvor_m) USING guest_id_p;

  COMMIT;

  response_p := 'OK';
EXCEPTION
  WHEN OTHERS THEN
    ROLLBACK;
    response_p := SUBSTR ('ERROR ' || SQLERRM, 1, 2000);
    pra_rec.puni_promjene ('9321', SUBSTR (response_p || ' | ' || opis_m, 1, 2000), 0);
    RAISE;
END;
PROCEDURE ZAJ_SET_SIFRA_JEZ_M
 IS
-- procedura se poziva iz funkcije kod_lista, procedura departure_change i check_out
  CURSOR jez_c IS
    SELECT id, sifra_3a
      FROM s_jezici
     WHERE sifra_2a = lang_m;
BEGIN
  IF lang_m IS NOT NULL THEN
    OPEN jez_c;
    FETCH jez_c INTO gost_row_g.jez_id, sifra_jez_m;
    CLOSE jez_c;
  END IF;
  IF sifra_jez_m IS NULL THEN
    sifra_jez_m := 'eng'; -- IRN 3329
  END IF;
  pra_zmp_zaj.sifra_jez_g := sifra_jez_m;
  pra_zmp_zaj.dodaj_por_vrsta_g := 0;
END;
PROCEDURE ZAJ_SET_RECKOD_ROW_M
 IS
-- proceduru pozivaju funcija kod_lista, procedure check_in, departure_change i check_out
  CURSOR reckod_c IS
    SELECT * FROM lrec_kodovi WHERE kod = access_code_m;
BEGIN
  OPEN reckod_c;
  FETCH reckod_c INTO reckod_row_m;
  CLOSE reckod_c;
END;
PROCEDURE ZAJ_SET_CVOR_M
 IS
-- procedura se poziva iz funkcije kod_lista, procedura check_in, departure_change i check_out
BEGIN
  IF reckod_row_m.metcvor_sifra = pra_zmp_zaj.tekuci_cvor THEN
    cvor_m := NULL;
  ELSE
    cvor_m := '@' || reckod_row_m.metcvor_sifra;
  END IF;
END;
FUNCTION POM_ZAK_UPIT
 RETURN VARCHAR2
 IS
-- funkciju poziva funkcija kod_lista
BEGIN
  -- IRN 3016, dodano --> AND pra_zmp_s.oznaka<CVOR> (''P0027'', so.sifra) = -1
  -- IRN 3177, dodano itanje tablice m_agencije
  -- IRN 3275, REC parametar 1213 --> SC parametar 1005, dodano itanje t_kgostiju ...
  -- IRN 4031, dodani stupci: age, arrival_time, departure_time
  RETURN (
    'SELECT
      zak.pristupni_kod AS access_code,
      ''contract'' AS mish_source_type,
      ''false'' AS checked_in,
      so.sifra AS property_code,
      INITCAP (so.naziv) AS property_name,
      sj.broj AS unit_code,
      zakkor.id AS guest_id,
      TO_CHAR (NULL) AS guest_no,
      INITCAP (zakkor.ime) AS first_name,
      INITCAP (zakkor.prezime) AS last_name,
      TO_CHAR (zak.dat_poc, ''DD.MM.RRRR'') AS start_date,
      TO_CHAR (zak.dat_zav, ''DD.MM.RRRR'') AS end_date,
      TO_CHAR (NULL) AS arrival,
      TO_CHAR (NULL) AS departure,
      TO_CHAR (NULL) AS arrival_time,
      TO_CHAR (NULL) AS departure_time,
      zakkor.reg_vozila AS plate,
      DECODE (pra_zmp_zaj.zmppar_vrijednost<CVOR> (''SC'', ''1005''), ''da'', ''true'', ''false'') AS plate_insert_allowed,
      NVL (zemd.sifra_2a, zema.sifra_2a) AS nationality,
      DECODE (recagost.ozn_spola, '''', ''F'', recagost.ozn_spola) AS sex,
      pra_rec_s3.dob (recagost.dat_rodjenja, TRUNC (SYSDATE)) AS age,
      TO_CHAR (recagost.dat_rodjenja, ''DD.MM.RRRR'') AS birth_date,
      NVL (zemr.sifra_2a, zema.sifra_2a) AS birth_country,
      TO_CHAR (NULL) AS birth_country_name,
      vpisp.sifra AS travel_document_type,
      TO_CHAR (NULL) AS travel_document_type_name,
      recagost.br_pisprave AS travel_document_number,
      (
      SELECT MIN (broj)
        FROM tloy_kartice<CVOR>
       WHERE recagost_id = recagost.id
         AND TRUNC (SYSDATE) BETWEEN dat_valjan AND (NVL (dat_ponisten, TO_DATE (''31.12.9999'', ''DD.MM.RRRR'')) - 1)
        ) AS loyalty_card,
      NVL (zem.sifra_2a, zema.sifra_2a) AS residence_country,
      INITCAP (NVL (pos.naziv, recagost.naz_mjesta)) AS residence_city,
      recagost.naz_ulice AS residence_street,
      TO_CHAR (NULL) AS phone
    FROM
      t_zak_korisnici<CVOR> zakkor,
      t_zak_sj<CVOR> zaksj,
      t_zakup<CVOR> zak,
      m_sj<CVOR> sj,
      m_so<CVOR> so,
      trec_agostiju<CVOR> recagost,
      s_zemlje<CVOR> zemd,
      s_zemlje<CVOR> zemr,
      s_zemlje<CVOR> zem,
      s_vpisprava<CVOR> vpisp,
      m_poste<CVOR> pos,
      mpka_adrese<CVOR> pkaadr,
      m_agencije<CVOR> age,
      s_zemlje<CVOR> zema
    WHERE
      zakkor.zaksj_id = zaksj.id
      AND zaksj.zak_id = zak.id
      AND zak.pristupni_kod = :access_code_m
      AND zak.oznaka = ''V''
      AND TRUNC (SYSDATE) BETWEEN zak.dat_poc AND zak.dat_zav
      AND zaksj.sj_id = sj.id
      AND sj.so_id = so.id
      AND zakkor.id NOT IN (
          SELECT zakkor_id
            FROM t_gosti<CVOR>
           WHERE zakkor_id IS NOT NULL
             AND ozn_prisutnosti = ''P'')
      AND zakkor.recagost_id = recagost.id(+)
      AND recagost.zemd_id = zemd.id(+)
      AND recagost.zemr_id = zemr.id(+)
      AND recagost.zem_id = zem.id(+)
      AND recagost.vpisp_id = vpisp.id(+)
      AND recagost.pos_id = pos.id(+)
      AND zak.pkaadr_id = pkaadr.id(+)
      AND zak.age_id = age.id(+)
      AND NVL (pkaadr.zem_id, age.zem_id) = zema.id
      AND pra_zmp_s.oznaka<CVOR> (''P0027'', so.sifra) = -1
    UNION ALL
    SELECT
      zak.pristupni_kod AS access_code,
      ''contract'' AS mish_source_type,
      ''true'' AS checked_in,
      so.sifra AS property_code,
      INITCAP (so.naziv) AS property_name,
      sj.broj AS unit_code,
      gost.id AS guest_id,
      gost.rbr AS guest_no,
      INITCAP (gost.ime) AS first_name,
      INITCAP (gost.prezime) AS last_name,
      TO_CHAR (zak.dat_poc, ''DD.MM.RRRR'') AS start_date,
      TO_CHAR (zak.dat_zav, ''DD.MM.RRRR'') AS end_date,
      TO_CHAR (gost.dat_dolaska, ''DD.MM.RRRR'') AS arrival,
      TO_CHAR (gost.dat_odlaska, ''DD.MM.RRRR'') AS departure,
      TO_CHAR (NULL) AS arrival_time,
      TO_CHAR (NULL) AS departure_time,
      TO_CHAR (NULL) AS plate,
      TO_CHAR (NULL) AS plate_insert_allowed,
      TO_CHAR (NULL) AS nationality,
      TO_CHAR (NULL) AS sex,
      TO_NUMBER (NULL) AS age,
      TO_CHAR (kgost.dat_rodjenja, ''DD.MM.RRRR'') AS birth_date,
      zemr.sifra_2a AS birth_country,
      zemr.naziv AS birth_country_name,
      vpisp.sifra AS travel_document_type,
      vpisp.naziv AS travel_document_type_name,
      kgost.br_pisprave AS travel_document_number,
      TO_CHAR (NULL) AS loyalty_card,
      TO_CHAR (NULL) AS residence_country,
      TO_CHAR (NULL) AS residence_city,
      TO_CHAR (NULL) AS residence_street,
      TO_CHAR (NULL) AS phone
    FROM
      t_gosti<CVOR> gost,
      t_zak_korisnici<CVOR> zakkor,
      t_zak_sj<CVOR> zaksj,
      t_zakup<CVOR> zak,
      m_sj<CVOR> sj,
      m_so<CVOR> so,
      t_kgostiju<CVOR> kgost,
      s_zemlje<CVOR> zemr,
      s_vpisprava<CVOR> vpisp
    WHERE
      gost.ozn_prisutnosti = ''P''
      AND NVL (gost.ozn_brisano, 0) = 0
      AND gost.zakkor_id = zakkor.id
      AND zakkor.zaksj_id = zaksj.id
      AND zaksj.zak_id = zak.id
      AND zak.pristupni_kod = :access_code_m
      AND gost.sj_id = sj.id
      AND sj.so_id = so.id
      AND kgost.gost_id = gost.id
      AND kgost.oznaka = ''V''
      AND kgost.ozn_brisano = 0
      AND kgost.zemr_id = zemr.id(+)
      AND kgost.vpisp_id = vpisp.id(+)
      AND pra_zmp_s.oznaka<CVOR> (''P0027'', so.sifra) = -1
    ORDER BY unit_code, guest_no, last_name, first_name');
END;
FUNCTION POM_REZ_UPIT
 RETURN VARCHAR2
 IS
-- funkciju poziva funkcija kod_lista
BEGIN
  -- IRN 3016, dodano --> AND pra_zmp_s.oznaka<CVOR> (''P0027'', so.sifra) = -1
  -- IRN 3200, dodano itanje t_rez_gost.pristupni_kod i dr. podataka iz t_rez_gost, REC parametra 1222, ANSI JOIN
  -- IRN 3275, REC parametar 1213, 1222 --> SC parametar 1005, 1002, dodano itanje t_kgostiju
  -- IRN 3713, TRIM (REPLACE (rezgost.ime, ''.'', ''''))
  -- IRN 4031, dodani stupci: age, arrival_time, departure_time
  RETURN (
    'SELECT
      rez.pristupni_kod AS access_code,
      ''reservation'' AS mish_source_type,
      ''false'' AS checked_in,
      so.sifra AS property_code,
      INITCAP (so.naziv) AS property_name,
      sj.broj AS unit_code,
      rezgost.id AS guest_id,
      TO_CHAR (rezgost.rbr) AS guest_no,
      INITCAP (TRIM (REPLACE (rezgost.ime, ''.'', ''''))) AS first_name,
      INITCAP (rezgost.prezime) AS last_name,
      TO_CHAR (rez.dat_dolaska, ''DD.MM.RRRR'') AS start_date,
      TO_CHAR (rez.dat_odlaska, ''DD.MM.RRRR'') AS end_date,
      TO_CHAR (rez.dat_dolaska, ''DD.MM.RRRR'') AS arrival,
      TO_CHAR (rez.dat_odlaska, ''DD.MM.RRRR'') AS departure,
      TO_CHAR (rez.sat_dolaska, ''HH24:MI'') AS arrival_time,
      TO_CHAR (rez.sat_odlaska, ''HH24:MI'') AS departure_time,
      rezgost.reg_vozila AS plate,
      param.plate_insert_allowed AS plate_insert_allowed,
      NVL (zemd.sifra_2a, rezzem.sifra_2a) AS nationality,
      DECODE (rezgost.ozn_spola, '''', ''F'', rezgost.ozn_spola) AS sex,
      DECODE (rezgost.dob, NULL, pra_rec_s3.dob (rezgost.dat_rodjenja, rez.dat_dolaska), rezgost.dob) AS age,
      TO_CHAR (rezgost.dat_rodjenja, ''DD.MM.RRRR'') AS birth_date,
      NVL (zemr.sifra_2a, rezzem.sifra_2a) AS birth_country,
      TO_CHAR (NULL) AS birth_country_name,
      vpisp.sifra AS travel_document_type,
      TO_CHAR (NULL) AS travel_document_type_name,
      rezgost.br_pisprave AS travel_document_number,
      (
      SELECT MIN (broj)
        FROM tloy_kartice<CVOR>
       WHERE recagost_id = recagost.id
         AND rez.dat_dolaska BETWEEN dat_valjan AND (NVL (dat_ponisten, TO_DATE (''31.12.9999'', ''DD.MM.RRRR'')) - 1)
        ) AS loyalty_card,
      NVL (zem.sifra_2a, rezzem.sifra_2a) AS residence_country,
      INITCAP (NVL (rezgost.naz_mjesta, rez.naz_mjesta)) AS residence_city,
      NVL (rezgost.naz_ulice, rez.naz_ulice) AS residence_street,
      rezgost.br_telefona AS phone
    FROM
      t_rez_gost<CVOR> rezgost
      JOIN t_rez_vsj<CVOR> rezvsj ON rezgost.rezvsj_id = rezvsj.id
      JOIN t_rezervacije<CVOR> rez ON rezvsj.rez_id = rez.id
      JOIN m_so<CVOR> so ON rez.so_id = so.id
      JOIN (
           SELECT
             DECODE (pra_zmp_zaj.zmppar_vrijednost<CVOR> (''SC'', ''1005''), ''da'', ''true'', ''false'') AS plate_insert_allowed,
             pra_zmp_zaj.zmppar_vrijednost<CVOR> (''SC'', ''1002'') AS br_dana
           FROM dual
           ) param ON 1 = 1
      LEFT OUTER JOIN m_sj<CVOR> sj ON NVL (rezgost.sj_id, rezvsj.sj_id) = sj.id
      LEFT OUTER JOIN trec_agostiju<CVOR> recagost ON rezgost.recagost_id = recagost.id
      LEFT OUTER JOIN s_zemlje<CVOR> zemd ON rezgost.zemd_id = zemd.id
      LEFT OUTER JOIN s_zemlje<CVOR> zemr ON rezgost.zemr_id = zemr.id
      LEFT OUTER JOIN s_zemlje<CVOR> zem ON rezgost.zem_id = zem.id
      LEFT OUTER JOIN s_vpisprava<CVOR> vpisp ON rezgost.vpisp_id = vpisp.id
      LEFT OUTER JOIN s_zemlje<CVOR> rezzem ON NVL (rez.zemd_id, rez.zem_id) = rezzem.id
    WHERE
      rezgost.ozn_fiktivni = 0
      AND NVL (rezgost.pristupni_kod, rez.pristupni_kod) = :access_code_m
      AND rez.oznaka = ''V''
      AND rez.ozn_vstorna IS NULL
      AND rez.dat_dolaska BETWEEN TRUNC (SYSDATE) AND (TRUNC (SYSDATE) + param.br_dana)
      AND rezgost.id NOT IN (
          SELECT gost.rezgost_id
            FROM t_gosti<CVOR> gost
           WHERE gost.rezgost_id IS NOT NULL
             AND gost.rezvsj_id = rezvsj.id)
      AND pra_zmp_s.oznaka<CVOR> (''P0027'', so.sifra) = -1
    UNION ALL
    SELECT
      rez.pristupni_kod AS access_code,
      ''reservation'' AS mish_source_type,
      ''true'' AS checked_in,
      so.sifra AS property_code,
      INITCAP (so.naziv) AS property_name,
      sj.broj AS unit_code,
      gost.id AS guest_id,
      gost.rbr AS guest_no,
      INITCAP (gost.ime) AS first_name,
      INITCAP (gost.prezime) AS last_name,
      TO_CHAR (rez.dat_dolaska, ''DD.MM.RRRR'') AS start_date,
      TO_CHAR (rez.dat_odlaska, ''DD.MM.RRRR'') AS end_date,
      TO_CHAR (gost.dat_dolaska, ''DD.MM.RRRR'') AS arrival,
      TO_CHAR (gost.dat_odlaska, ''DD.MM.RRRR'') AS departure,
      TO_CHAR (NULL) AS arrival_time,
      TO_CHAR (NULL) AS departure_time,
      TO_CHAR (NULL) AS plate,
      TO_CHAR (NULL) AS plate_insert_allowed,
      TO_CHAR (NULL) AS nationality,
      TO_CHAR (NULL) AS sex,
      TO_NUMBER (NULL) AS age,
      TO_CHAR (kgost.dat_rodjenja, ''DD.MM.RRRR'') AS birth_date,
      zemr.sifra_2a AS birth_country,
      zemr.naziv AS birth_country_name,
      vpisp.sifra AS travel_document_type,
      vpisp.naziv AS travel_document_type_name,
      kgost.br_pisprave AS travel_document_number,
      TO_CHAR (NULL) AS loyalty_card,
      TO_CHAR (NULL) AS residence_country,
      TO_CHAR (NULL) AS residence_city,
      TO_CHAR (NULL) AS residence_street,
      TO_CHAR (NULL) AS phone
    FROM
      t_gosti<CVOR> gost
      JOIN t_rez_gost<CVOR> rezgost ON gost.rezgost_id = rezgost.id
      JOIN t_rez_vsj<CVOR> rezvsj ON rezgost.rezvsj_id = rezvsj.id
      JOIN t_rezervacije<CVOR> rez ON rezvsj.rez_id = rez.id
      JOIN m_sj<CVOR> sj ON gost.sj_id = sj.id
      JOIN m_so<CVOR> so ON sj.so_id = so.id
      JOIN t_kgostiju<CVOR> kgost ON kgost.gost_id = gost.id AND kgost.oznaka = ''V'' AND kgost.ozn_brisano = 0
      LEFT OUTER JOIN s_zemlje<CVOR> zemr ON kgost.zemr_id = zemr.id
      LEFT OUTER JOIN s_vpisprava<CVOR> vpisp ON kgost.vpisp_id = vpisp.id
    WHERE
      NVL (rezgost.pristupni_kod, rez.pristupni_kod) = :access_code_m
      AND gost.ozn_prisutnosti = ''P''
      AND NVL (gost.ozn_brisano, 0) = 0
      AND pra_zmp_s.oznaka<CVOR> (''P0027'', so.sifra) = -1
    ORDER BY unit_code, guest_no');
END;
PROCEDURE POM_ZAK_CHECK_IN
 IS
-- proceduru poziva procedura check_in
  naredba_l VARCHAR2(32000);
  rc_l SYS_REFCURSOR;

  CURSOR loykar_c IS
    SELECT loykar.recagost_id, UPPER (recagost.ime), UPPER (recagost.prezime)
      FROM tloy_kartice loykar, trec_agostiju recagost
     WHERE loykar.broj = loyalty_card_m
       AND loykar.recagost_id = recagost.id
       AND recagost.oznaka = 'V';
  recagost_ime_l trec_agostiju.ime%TYPE;
  recagost_prezime_l trec_agostiju.prezime%TYPE;

  so_id_l m_sj.so_id%TYPE;
  so_naz_grada_l m_so.naz_grada%TYPE;   -- IRN 3729
  so_naz_mjesta_l m_so.naz_mjesta%TYPE; -- IRN 3729

  cje_sifra_l t_cjenici.sifra%TYPE;
  rec_param_1170_l szmp_parametri.vrijednost%TYPE;
  rec_param_1185_l szmp_parametri.vrijednost%TYPE;
  sc_param_1005_l szmp_parametri.vrijednost%TYPE;
  sc_param_1007_l szmp_parametri.vrijednost%TYPE;
  sc_param_1008_l szmp_parametri.vrijednost%TYPE;

  gostp_id_l   t_troskovi.gostp_id%TYPE;
  pkaadrp_id_l t_troskovi.pkaadrp_id%TYPE;
  agep_id_l    t_troskovi.agep_id%TYPE; -- IRN 3177
  ozn_postoji_cijena_l NUMBER;

  dob_l NUMBER;
  vplabp_sifra_l s_vplabp_tz.sifra%TYPE;
BEGIN

  gost_row_g.zakkor_id := guest_id_m; -- IRN 3275

  -- IRN 3177, dodano itanje zak.age_id
  -- IRN 3200, dodano itanje zakkor.recagost_id
  -- IRN 3275, REC param 1213, 1210 --> SC param 1005, 1008, +1007
  naredba_l :=
   'SELECT
      zak.ms_id,
      zaksj.sj_id,
      UPPER (zakkor.ime),
      UPPER (zakkor.prezime),
      zakkor.reg_vozila,
      zak.pkaadr_id,
      zak.age_id,
      zakkor.recagost_id
    FROM
      t_zak_korisnici<CVOR> zakkor,
      t_zak_sj<CVOR> zaksj,
      t_zakup<CVOR> zak
    WHERE
      zakkor.id = :guest_id_m
      AND zakkor.zaksj_id = zaksj.id
      AND zaksj.zak_id = zak.id
      AND zak.pristupni_kod = :access_code_m
      AND zak.oznaka = ''V''
      AND :dat_dolaska <= zak.dat_zav
      AND :dat_odlaska >= zak.dat_poc
      AND zakkor.id NOT IN (
          SELECT zakkor_id
            FROM t_gosti<CVOR>
           WHERE zakkor_id IS NOT NULL
             AND ozn_prisutnosti = ''P'')';

  OPEN rc_l FOR REPLACE (naredba_l, '<CVOR>', cvor_m) USING guest_id_m, access_code_m, gost_row_g.dat_dolaska, gost_row_g.dat_odlaska;
  FETCH rc_l INTO
    gost_row_g.ms_id,
    gost_row_g.sj_id,
    gost_row_g.ime,
    gost_row_g.prezime,
    kgost_row_g.reg_vozila,
    pkaadrp_id_l,
    agep_id_l,
    gost_row_g.recagost_id;
  IF rc_l%NOTFOUND THEN
    CLOSE rc_l;
    -- Pogrena vrijednost parametra #0.
    pra_zmp_zaj.vrati_poruku_zaj ('REC', -20474, 'access_code');
  END IF;
  CLOSE rc_l;

  IF loyalty_card_m IS NOT NULL THEN
    OPEN loykar_c;
    FETCH loykar_c INTO gost_row_g.recagost_id, recagost_ime_l, recagost_prezime_l;
    CLOSE loykar_c;
    IF gost_row_g.recagost_id IS NOT NULL
      AND recagost_ime_l = gost_row_g.ime
      AND recagost_prezime_l = gost_row_g.prezime
    THEN
      NULL;
    ELSE
      gost_row_g.recagost_id := NULL;
      gost_row_g.napomena := pra_zmp_zaj.poruka ('REC', 'REC_LOYKAR') || ' ' || loyalty_card_m;
    END IF;
  END IF;

  -- IRN 3729; dodala punjenje u so_naz_grada_l i so_naz_mjesta_l
  SELECT sj.vsj_id, so.knjm_id, sj.so_id, UPPER (so.naz_grada), UPPER (so.naz_mjesta)
    INTO gost_row_g.vsj_id, kgost_row_g.knjm_id, so_id_l, so_naz_grada_l, so_naz_mjesta_l
    FROM m_sj sj, m_so so
   WHERE sj.id = gost_row_g.sj_id
     AND sj.so_id = so.id;

  -- REC parametar 1019 ifra cjenika za neugovorene usluge koja se predlae u modulu REC2240 - Check In.
  -- REC parametar 1170 Knjiga gostiju za domae i strane goste vodi se: 1 = zajedno ili 2 = odvojeno.
  -- REC parametar 1185 Uobiajeni sat odlaska od 0 do 24 ili nebitno.
  -- SC parametar 1005 Dopustiti unos registarske oznake vozila: da ili ne.
  -- SC parametar 1007 Dopustiti dodavanje usluga korisniku ugovora o zakupu: da ili ne.
  -- SC parametar 1008 Platitelj usluga korisnika ugovora o zakupu je: 1 = prvi gost u SJ, 2 = gost ili 3 = zakupac.
  naredba_l :=
    'SELECT
       pra_rec_zaj.vrijednost_parametra<CVOR> (''1019''),
       pra_rec_zaj.vrijednost_parametra<CVOR> (''1170''),
       pra_rec_zaj.vrijednost_parametra<CVOR> (''1185''),
       pra_zmp_zaj.zmppar_vrijednost<CVOR> (''SC'', ''1005''),
       pra_zmp_zaj.zmppar_vrijednost<CVOR> (''SC'', ''1007''),
       pra_zmp_zaj.zmppar_vrijednost<CVOR> (''SC'', ''1008'')
     FROM dual';
  EXECUTE IMMEDIATE REPLACE (naredba_l, '<CVOR>', cvor_m)
     INTO cje_sifra_l, rec_param_1170_l, rec_param_1185_l, sc_param_1005_l, sc_param_1007_l, sc_param_1008_l;

  SELECT id INTO gost_row_g.cje_id
    FROM t_cjenici
   WHERE sifra = cje_sifra_l;
  IF gost_row_g.cje_id IS NULL THEN
    -- Provjerite vrijednost #0 parametra #1!
    pra_zmp_zaj.vrati_poruku_zaj ('ZMP', -20100, 'REC', '1019');
  END IF;

  gost_row_g.ozn_valjanosti := 'V';
  gost_row_g.ozn_prisutnosti := 'P';
  gost_row_g.ozn_gratis := 0;
  gost_row_g.ozn_fiktivni := 0;

  naredba_l :=
   'SELECT MIN (id)
      FROM t_gosti<CVOR>
     WHERE sj_id = :sj_id
       AND ozn_prisutnosti = ''P''
       AND dat_dolaska = :dat_dolaska';
  EXECUTE IMMEDIATE REPLACE (naredba_l, '<CVOR>', cvor_m)
     INTO gostp_id_l
    USING gost_row_g.sj_id, gost_row_g.dat_dolaska;
  IF gostp_id_l IS NULL THEN
    gost_row_g.ozn_platitelj := -1;
  ELSE
    gost_row_g.ozn_platitelj := 0;
  END IF;

  naredba_l := 'SELECT pra_zmp_zaj.i3_sekvenca<CVOR> (NULL) FROM dual';
  EXECUTE IMMEDIATE REPLACE (naredba_l, '<CVOR>', cvor_m) INTO gost_row_g.id;

  -- puni T_GOSTI
  naredba_l := 'BEGIN INSERT INTO t_gosti<CVOR> VALUES pra_self_check_in.gost_row_g; END;';
  EXECUTE IMMEDIATE REPLACE (naredba_l, '<CVOR>', cvor_m);

  -- puni T_TROSKOVI
  /*
  TYPE service_obj_t AS OBJECT (service_code VARCHAR2(4), quantity NUMBER(3), start_date DATE, end_date DATE)
  */

  -- SC parametar 1008 Platitelj usluga korisnika ugovora o zakupu je: 1 = prvi gost u SJ, 2 = gost ili 3 = zakupac (agencija ili adresa).
  IF sc_param_1008_l = '1' THEN
    gostp_id_l := NVL (gostp_id_l, gost_row_g.id);
    pkaadrp_id_l := NULL;
    agep_id_l := NULL;
  ELSIF sc_param_1008_l = '2' THEN
    gostp_id_l := gost_row_g.id;
    pkaadrp_id_l := NULL;
    agep_id_l := NULL;
  ELSE
    gostp_id_l := NULL;
  END IF;

  FOR tro_c IN (
    SELECT usl.id AS usl_id,
           tro.start_date AS dat_poc,
           tro.end_date AS dat_zav,
           tro.quantity AS kol_usluge,
           usl.sifra AS usl_sifra
      FROM TABLE (services_tab_m) tro,
           s_usluge usl
     WHERE tro.service_code = usl.sifra
       AND tro.start_date IS NOT NULL
       AND tro.end_date IS NOT NULL
       AND tro.start_date <= tro.end_date
       AND tro.start_date >= gost_row_g.dat_dolaska
       AND tro.end_date <= gost_row_g.dat_odlaska
       AND tro.quantity IS NOT NULL
       AND tro.quantity > 0
       AND sc_param_1007_l = 'da' -- IRN 3275
    UNION ALL
    SELECT usl.id,
           gost_row_g.dat_dolaska,
           DECODE (usl.ozn_1dan, 0, gost_row_g.dat_odlaska, gost_row_g.dat_dolaska),
           1,
           usl.sifra AS usl_sifra
      FROM m_ms_usl msusl,
           s_usluge usl
     WHERE msusl.ms_id = gost_row_g.ms_id
       AND msusl.usl_id = usl.id
    )
  LOOP
    naredba_l :=
     'BEGIN
        pra_rec_iud4.puni_troskove<CVOR> (
          gostk_id_p => :gost_row_g_id,
          agek_id_p => NULL,
          pkaadrk_id_p => NULL,
          gostp_id_p => :gostp_id_l,
          agep_id_p => :agep_id_l,
          pkaadrp_id_p => :pkaadrp_id_l,
          so_id_p => :so_id_l,
          cje_id_p => :gost_row_g_cje_id,
          ms_id_p => :gost_row_g_ms_id,
          age_id_p => NULL,
          usl_id_p => :tro_c_usl_id,
          sas_id_p => NULL,
          kol_usluge_p => :tro_c_kol_usluge,
          vsj_id_p => :gost_row_g_vsj_id,
          dat_poc_p => :tro_c_dat_poc,
          dat_zav_p => :tro_c_dat_zav,
          br_uputnice_p => NULL,
          stopa_placanja_p => 100,
          ozn_gratis_p => 0,
          ozn_platitelj_p => NULL,
          cijena_usluge_p => NULL,
          val_id_p => NULL,
          recara_id_p => NULL,
          ponso_id_p => NULL,
          recvpro_id_p => NULL,
          usl_id1_p => NULL,
          recrez2pros_id_p => NULL,
          recrez2opr_id_p => NULL,
          ozn_postoji_cijena_p => :ozn_postoji_cijena_l);
      END;';
    EXECUTE IMMEDIATE REPLACE (naredba_l, '<CVOR>', cvor_m) USING
      gost_row_g.id,
      gostp_id_l,
      agep_id_l,
      pkaadrp_id_l,
      so_id_l,
      gost_row_g.cje_id,
      gost_row_g.ms_id,
      tro_c.usl_id,
      tro_c.kol_usluge,
      gost_row_g.vsj_id,
      tro_c.dat_poc,
      tro_c.dat_zav,
      IN OUT ozn_postoji_cijena_l;
  END LOOP;

  -- puni T_KGOSTIJU
  kgost_row_g.gost_id := gost_row_g.id;

  -- IRN 3628
  vplabp_sifra_l := NULL;
  IF gost_row_g.recagost_id IS NOT NULL THEN
    SELECT MIN (vplabp.sifra) INTO vplabp_sifra_l
      FROM trec_agostiju recagost,
           s_vplabp_tz vplabp
     WHERE recagost.id = gost_row_g.recagost_id
       AND recagost.vplabp_id = vplabp.id;
  END IF;
  IF vplabp_sifra_l IS NULL OR vplabp_sifra_l IN ('A', 'J', 'L') THEN -- IRN 3729; dodala 'L'
    dob_l := pra_rec_s3.dob (kgost_row_g.dat_rodjenja, gost_row_g.dat_dolaska);
    IF dob_l BETWEEN 0 AND 11 THEN
      vplabp_sifra_l := 'A';
    ELSIF dob_l BETWEEN 12 AND 17 THEN
      vplabp_sifra_l := 'J';
    ELSE
      vplabp_sifra_l := 'N';
    END IF;
  END IF;
  -- IRN 3729
  IF residence_country_m = 'HR'
    AND UPPER (kgost_row_g.naz_pboravista) IN (so_naz_grada_l, so_naz_mjesta_l)
    AND vplabp_sifra_l IN ('J', 'N')
  THEN
    vplabp_sifra_l := 'L';
  END IF;
  -- KRAJ IRN 3729
  SELECT MIN (id) INTO kgost_row_g.vplabp_id FROM s_vplabp_tz WHERE sifra = vplabp_sifra_l;

  -- REC param 1170 Knjiga gostiju za domae i strane goste vodi se: 1 = zajedno ili 2 = odvojeno
  IF rec_param_1170_l = '1' THEN
    kgost_row_g.ozn_vknjiga := '2'; -- zajednika knjiga
  ELSE
    -- Provjerite vrijednost #0 parametra #1!
    pra_zmp_zaj.vrati_poruku_zaj ('ZMP', -20100, 'REC', '1170');
  END IF;
  kgost_row_g.oznaka := 'V';
  kgost_row_g.ozn_datrodj := 'P'; -- poznat
  -- kgost_row_g.ozn_recagost := 0; -- IRN 3223 ozn_recagost iz ms
  naredba_l := 'SELECT ozn_recagost FROM m_msegmenti<CVOR> WHERE id = :gost_row_g_ms_id';
  EXECUTE IMMEDIATE REPLACE (naredba_l, '<CVOR>', cvor_m) INTO kgost_row_g.ozn_recagost USING gost_row_g.ms_id;
  kgost_row_g.ozn_brisano := 0;
  kgost_row_g.sat_dolaska := SYSDATE;

  -- SC param 1005 Dopustiti unos registarske oznake vozila: da ili ne.
  IF sc_param_1005_l = 'da' THEN
    kgost_row_g.reg_vozila := plate_m;
  END IF;

  -- REC param 1185 Uobiajeni sat odlaska od 0 do 24 ili nebitno.
  IF rec_param_1185_l = 'nebitno' THEN
    kgost_row_g.sat_odlaska :=
      TO_DATE (TO_CHAR (gost_row_g.dat_odlaska, 'DD.MM.RRRR') || ' ' || '10:00', 'DD.MM.RRRR HH24:MI');
  ELSE
    kgost_row_g.sat_odlaska :=
      TO_DATE (TO_CHAR (gost_row_g.dat_odlaska, 'DD.MM.RRRR') || ' ' || rec_param_1185_l || ':00', 'DD.MM.RRRR HH24:MI');
  END IF;

  naredba_l := 'BEGIN INSERT INTO t_kgostiju<CVOR> VALUES pra_self_check_in.kgost_row_g; END;';
  EXECUTE IMMEDIATE REPLACE (naredba_l, '<CVOR>', cvor_m);

END;
PROCEDURE POM_REZ_CHECK_IN
 IS
-- proceduru poziva procedura check_in
  naredba_l VARCHAR2(32000);
  rc_l SYS_REFCURSOR;

  CURSOR loykar_c IS
    SELECT loykar.recagost_id, UPPER (recagost.ime), UPPER (recagost.prezime)
      FROM tloy_kartice loykar, trec_agostiju recagost
     WHERE loykar.broj = loyalty_card_m
       AND loykar.recagost_id = recagost.id
       AND recagost.oznaka = 'V';
  recagost_ime_l trec_agostiju.ime%TYPE;
  recagost_prezime_l trec_agostiju.prezime%TYPE;
  br_redaka_l NUMBER; -- IRN 3679

  so_id_l m_sj.so_id%TYPE;
  so_naz_grada_l m_so.naz_grada%TYPE;   -- IRN 3729
  so_naz_mjesta_l m_so.naz_mjesta%TYPE; -- IRN 3729

  rec_param_1170_l szmp_parametri.vrijednost%TYPE;
  rec_param_1185_l szmp_parametri.vrijednost%TYPE;
  sc_param_1005_l szmp_parametri.vrijednost%TYPE;
  sc_param_1009_l szmp_parametri.vrijednost%TYPE;
  sc_param_1010_l szmp_parametri.vrijednost%TYPE;

  rezgusl_row_l t_rez_gusl%ROWTYPE;
  gostp_id_l  t_troskovi.gostp_id%TYPE;
  gostx_id_l  t_troskovi.gostp_id%TYPE;
  gostx2_id_l t_troskovi.gostp_id%TYPE; -- IRN 3275
  agex_id_l   t_troskovi.agep_id%TYPE;
  ponsox_id_l t_troskovi.ponso_id%TYPE;
  ozn_postoji_cijena_l NUMBER;

  dob_l NUMBER;
  vplabp_sifra_l s_vplabp_tz.sifra%TYPE;
BEGIN

  -- IRN 3200, dodano itanje rezgost.recagost_id
  naredba_l :=
   'SELECT
      rez.ms_id,
      NVL (rezgost.sj_id, rezvsj.sj_id),
      UPPER (rezgost.ime),
      UPPER (rezgost.prezime),
      rezgost.reg_vozila,
      rezvsj.vsjc_id,
      rez.cje_id,
      rez.age_id,
      rez.br_uputnice,
      rez.ponso_id,
      rez.recvpro_id,
      rezgost.id,
      rezvsj.id,
      rezgost.recagost_id,
      NVL (rezgost.email, rez.email)
    FROM
      t_rez_gost<CVOR> rezgost,
      t_rez_vsj<CVOR> rezvsj,
      t_rezervacije<CVOR> rez
    WHERE
      rezgost.id = :guest_id_m
      AND rezgost.rezvsj_id = rezvsj.id
      AND rezvsj.rez_id = rez.id
      AND NVL (rezgost.pristupni_kod, rez.pristupni_kod) = :access_code_m
      AND rez.oznaka = ''V''
      AND rez.ozn_vstorna IS NULL
      AND :dat_dolaska = rez.dat_dolaska
      AND :dat_odlaska = rez.dat_odlaska
      AND rezgost.id NOT IN (
          SELECT rezgost_id FROM t_gosti<CVOR> WHERE rezgost_id IS NOT NULL)';

  OPEN rc_l FOR REPLACE (naredba_l, '<CVOR>', cvor_m) USING guest_id_m, access_code_m, gost_row_g.dat_dolaska, gost_row_g.dat_odlaska;
  FETCH rc_l INTO
    gost_row_g.ms_id,
    gost_row_g.sj_id,
    gost_row_g.ime,
    gost_row_g.prezime,
    kgost_row_g.reg_vozila,
    gost_row_g.vsj_id,
    gost_row_g.cje_id,
    gost_row_g.age_id,
    gost_row_g.br_uputnice,
    gost_row_g.ponso_id,
    gost_row_g.recvpro_id,
    gost_row_g.rezgost_id,
    gost_row_g.rezvsj_id,
    gost_row_g.recagost_id,
    kgost_row_g.email; -- IRN 3679
  IF rc_l%NOTFOUND THEN
    CLOSE rc_l;
    -- Pogrena vrijednost parametra #0.
    pra_zmp_zaj.vrati_poruku_zaj ('REC', -20474, 'access_code');
  END IF;
  CLOSE rc_l;

  gost_row_g.ime := NVL (ime_m, gost_row_g.ime);             -- IRN 3200
  gost_row_g.prezime := NVL (prezime_m, gost_row_g.prezime); -- IRN 3200

  IF loyalty_card_m IS NOT NULL THEN
    OPEN loykar_c;
    FETCH loykar_c INTO gost_row_g.recagost_id, recagost_ime_l, recagost_prezime_l;
    CLOSE loykar_c;
    IF gost_row_g.recagost_id IS NOT NULL
      AND recagost_ime_l = gost_row_g.ime
      AND recagost_prezime_l = gost_row_g.prezime
    THEN
      NULL;
    ELSE
      -- isprazni recagost_id jer kartica ne pripada gostu
      gost_row_g.recagost_id := NULL;
    END IF;
  END IF;

  -- IRN 3679
  IF gost_row_g.recagost_id IS NOT NULL THEN
    SELECT COUNT(1) INTO br_redaka_l
      FROM trec_agostiju
     WHERE id = gost_row_g.recagost_id
       AND oznaka = 'P';
    IF br_redaka_l > 0 THEN
      -- isprazni recagost_id da se ne javlja poruka
      -- -20404 Valjani podaci ne mogu se vezati s ponitenim podacima o gostu iz arhive.
      gost_row_g.recagost_id := NULL;
    END IF;
  END IF;

  IF gost_row_g.recagost_id IS NOT NULL THEN
    naredba_l :=
      'SELECT COUNT (1)
         FROM t_gosti<CVOR>
        WHERE recagost_id = :recagost_id
          AND dat_dolaska <= :dat_odlaska
          AND dat_odlaska >= :dat_dolaska';
    EXECUTE IMMEDIATE REPLACE (naredba_l, '<CVOR>', cvor_m)
       INTO br_redaka_l
      USING gost_row_g.recagost_id, gost_row_g.dat_odlaska, gost_row_g.dat_dolaska;
    IF br_redaka_l > 0 THEN
      -- isprazni recagost_id da se ne javlja poruka
      -- -20442 Razdoblja boravka gosta iz arhive gostiju ne mogu se preklapati (#0)!
      gost_row_g.recagost_id := NULL;
    END IF;
  END IF;

  IF gost_row_g.recagost_id IS NULL AND loyalty_card_m IS NOT NULL THEN
    gost_row_g.napomena := pra_zmp_zaj.poruka ('REC', 'REC_LOYKAR') || ' ' || loyalty_card_m;
  END IF;

  IF kgost_row_g.email IS NOT NULL THEN
    naredba_l :=
      'SELECT COUNT (1)
         FROM t_gosti<CVOR> gost,
              t_kgostiju<CVOR> kgost
        WHERE kgost.gost_id = gost.id
          AND kgost.oznaka = ''V''
          AND gost.ozn_prisutnosti = ''P''
          AND LOWER (kgost.email) = LOWER (:email)';
    EXECUTE IMMEDIATE REPLACE (naredba_l, '<CVOR>', cvor_m)
       INTO br_redaka_l
      USING kgost_row_g.email;
    IF br_redaka_l > 0 THEN
      -- isprazni email jer postoji prisutan gost s jednakom e-adresom
      kgost_row_g.email := NULL;
    END IF;
  END IF;
  -- KRAJ IRN 3679

  IF gost_row_g.sj_id IS NULL THEN -- IRN 3200
    -- Pogrena vrijednost parametra #0.
    pra_zmp_zaj.vrati_poruku_zaj ('REC', -20474, 'unit_code');
  END IF;

  -- IRN 3729; dodala punjenje u so_naz_grada_l i so_naz_mjesta_l
  SELECT so.knjm_id, sj.so_id, UPPER (so.naz_grada), UPPER (so.naz_mjesta)
    INTO kgost_row_g.knjm_id, so_id_l, so_naz_grada_l, so_naz_mjesta_l
    FROM m_sj sj, m_so so
   WHERE sj.id = gost_row_g.sj_id
     AND sj.so_id = so.id;

  -- REC parametar 1170 Knjiga gostiju za domae i strane goste vodi se: 1 = zajedno ili 2 = odvojeno.
  -- REC parametar 1185 Uobiajeni sat odlaska od 0 do 24 ili nebitno.
  -- SC parametar 1005 Dopustiti unos registarske oznake vozila: da ili ne.
  -- SC parametar 1009 Dopustiti dodavanje usluga gostu s rezervacijom: da ili ne.
  -- SC parametar 1010 Platitelj usluga gosta s rezervacijom je: 1 = prvi gost u SJ ili 2 = gost.
  naredba_l :=
    'SELECT
       pra_rec_zaj.vrijednost_parametra<CVOR> (''1170''),
       pra_rec_zaj.vrijednost_parametra<CVOR> (''1185''),
       pra_zmp_zaj.zmppar_vrijednost<CVOR> (''SC'', ''1005''),
       pra_zmp_zaj.zmppar_vrijednost<CVOR> (''SC'', ''1009''),
       pra_zmp_zaj.zmppar_vrijednost<CVOR> (''SC'', ''1010'')
     FROM dual';
  EXECUTE IMMEDIATE REPLACE (naredba_l, '<CVOR>', cvor_m)
     INTO rec_param_1170_l, rec_param_1185_l, sc_param_1005_l, sc_param_1009_l, sc_param_1010_l;

  gost_row_g.ozn_valjanosti := 'V';
  gost_row_g.ozn_prisutnosti := 'P';
  gost_row_g.ozn_gratis := 0;
  gost_row_g.ozn_fiktivni := 0;

  naredba_l := 'SELECT pra_zmp_zaj.i3_sekvenca<CVOR> (NULL) FROM dual';
  EXECUTE IMMEDIATE REPLACE (naredba_l, '<CVOR>', cvor_m) INTO gost_row_g.id;

  naredba_l :=
   'SELECT MIN(id)
      FROM t_gosti<CVOR>
     WHERE sj_id = :sj_id
       AND ozn_prisutnosti = ''P''
       AND dat_dolaska = :dat_dolaska
       AND ozn_platitelj = -1';
  EXECUTE IMMEDIATE REPLACE (naredba_l, '<CVOR>', cvor_m)
     INTO gostp_id_l
    USING gost_row_g.sj_id, gost_row_g.dat_dolaska;
  IF gostp_id_l IS NULL THEN
    gostp_id_l := gost_row_g.id;
    gost_row_g.ozn_platitelj := -1;
  ELSE
    gost_row_g.ozn_platitelj := 0;
  END IF;

  gost_row_g.sat_odlaska := departure_time_m; -- IRN 4031

  -- puni T_GOSTI
  naredba_l := 'BEGIN INSERT INTO t_gosti<CVOR> VALUES pra_self_check_in.gost_row_g; END;';
  EXECUTE IMMEDIATE REPLACE (naredba_l, '<CVOR>', cvor_m);

  -- puni T_TROSKOVI
  -- IRN 3200, dodano itanje gost_row_g.ozn_platitelj i uvjet AND (usl.obr_osoba = -1 OR gost.ozn_platitelj = -1)
  naredba_l :=
    'SELECT
       rezusl.usl_id,
       rezusl.sas_id,
       NVL (rezusl.dat_poc, :dat_dolaska),
       NVL (rezusl.dat_zav, DECODE (usl.ozn_1dan, 0, :dat_odlaska, :dat_dolaska)),
       100 AS stopa_placanja,
       rezusl.recara_id,
       rezusl.ozn_platitelja,
       rezusl.ozn_ugo,
       rezusl.usl_id1
     FROM
       t_rez_gost<CVOR> rezgost,
       t_rez_vsj<CVOR> rezvsj,
       t_rez_usl<CVOR> rezusl,
       s_usluge<CVOR> usl,
       (SELECT :gost_ozn_platitelj AS ozn_platitelj FROM dual) gost
     WHERE
       rezgost.id = :guest_id_m
       AND rezgost.rezvsj_id = rezvsj.id
       AND rezvsj.rez_id = rezusl.rez_id
       AND rezusl.usl_id = usl.id
       AND (usl.obr_osoba = -1 OR gost.ozn_platitelj = -1)
     UNION ALL
     SELECT
       rezgusl.usl_id,
       rezgusl.sas_id,
       NVL (rezgusl.dat_poc, :dat_dolaska),
       NVL (rezgusl.dat_zav, DECODE (usl.ozn_1dan, 0, :dat_odlaska, :dat_dolaska)),
       NVL (rezgusl.stopa_placanja, 100),
       rezgusl.recara_id,
       rezgusl.ozn_platitelja,
       rezgusl.ozn_ugo,
       rezgusl.usl_id1
     FROM
       t_rez_gusl<CVOR> rezgusl,
       s_usluge<CVOR> usl
     WHERE
       rezgusl.rezgost_id = :guest_id_m
       AND rezgusl.usl_id = usl.id';
  OPEN rc_l FOR REPLACE (naredba_l, '<CVOR>', cvor_m)
    USING
      gost_row_g.dat_dolaska, gost_row_g.dat_odlaska, gost_row_g.dat_dolaska, gost_row_g.ozn_platitelj, guest_id_m,
      gost_row_g.dat_dolaska, gost_row_g.dat_odlaska, gost_row_g.dat_dolaska, guest_id_m;
  LOOP
    FETCH rc_l INTO
      rezgusl_row_l.usl_id,
      rezgusl_row_l.sas_id,
      rezgusl_row_l.dat_poc,
      rezgusl_row_l.dat_zav,
      rezgusl_row_l.stopa_placanja,
      rezgusl_row_l.recara_id,
      rezgusl_row_l.ozn_platitelja,
      rezgusl_row_l.ozn_ugo,
      rezgusl_row_l.usl_id1;
    EXIT WHEN rc_l%NOTFOUND;

    IF rezgusl_row_l.ozn_platitelja = -1 THEN -- Plaa gost
      gostx_id_l := gostp_id_l;
      agex_id_l := NULL;
    ELSE
      gostx_id_l := NULL;
      agex_id_l := gost_row_g.age_id;
    END IF;
    IF rezgusl_row_l.ozn_ugo = 0 THEN -- Usluga nije ugovorena
      ponsox_id_l := NULL;
    ELSE
      ponsox_id_l := gost_row_g.ponso_id;
    END IF;

    naredba_l :=
     'BEGIN
        pra_rec_iud4.puni_troskove<CVOR> (
          gostk_id_p => :gost_row_g_id,
          agek_id_p => NULL,
          pkaadrk_id_p => NULL,
          gostp_id_p => :gostx_id_l,
          agep_id_p => :agex_id_l,
          pkaadrp_id_p => NULL,
          so_id_p => :so_id_l,
          cje_id_p => :gost_row_g_cje_id,
          ms_id_p => :gost_row_g_ms_id,
          age_id_p => NULL,
          usl_id_p => :rezgusl_row_l_usl_id,
          sas_id_p => :rezgusl_row_l_sas_id,
          kol_usluge_p => 1,
          vsj_id_p => :gost_row_g_vsj_id,
          dat_poc_p => :rezgusl_row_l_dat_poc,
          dat_zav_p => :rezgusl_row_l_dat_zav,
          br_uputnice_p => :gost_row_g_br_uputnice,
          stopa_placanja_p => :rezgusl_row_l_stopa_placanja,
          ozn_gratis_p => 0,
          ozn_platitelj_p => NULL,
          cijena_usluge_p => NULL,
          val_id_p => NULL,
          recara_id_p => :rezgusl_row_l_recara_id,
          ponso_id_p => :ponsox_id_l,
          recvpro_id_p => :gost_row_g_recvpro_id,
          usl_id1_p => :rezgusl_row_l_usl_id1,
          recrez2pros_id_p => NULL,
          recrez2opr_id_p => NULL,
          ozn_postoji_cijena_p => :ozn_postoji_cijena_l);
      END;';
    EXECUTE IMMEDIATE REPLACE (naredba_l, '<CVOR>', cvor_m) USING
      gost_row_g.id,
      gostx_id_l,
      agex_id_l,
      so_id_l,
      gost_row_g.cje_id,
      gost_row_g.ms_id,
      rezgusl_row_l.usl_id,
      rezgusl_row_l.sas_id,
      gost_row_g.vsj_id,
      rezgusl_row_l.dat_poc,
      rezgusl_row_l.dat_zav,
      gost_row_g.br_uputnice,
      rezgusl_row_l.stopa_placanja,
      rezgusl_row_l.recara_id,
      ponsox_id_l,
      gost_row_g.recvpro_id,
      rezgusl_row_l.usl_id1,
      IN OUT ozn_postoji_cijena_l;
  END LOOP;
  CLOSE rc_l;

  -- IRN 3275, puni T_TROSKOVI iz services_tab_m
  -- SC parametar 1010 Platitelj usluga gosta s rezervacijom je: 1 = prvi gost u SJ ili 2 = gost.
  IF sc_param_1010_l = '1' THEN
    gostx2_id_l := NVL (gostp_id_l, gost_row_g.id);
  ELSE
    gostx2_id_l := gost_row_g.id;
  END IF;

  FOR tro_c IN (
    SELECT usl.id AS usl_id,
           tro.start_date AS dat_poc,
           tro.end_date AS dat_zav,
           tro.quantity AS kol_usluge,
           usl.sifra AS usl_sifra
      FROM TABLE (services_tab_m) tro,
           s_usluge usl
     WHERE tro.service_code = usl.sifra
       AND tro.start_date IS NOT NULL
       AND tro.end_date IS NOT NULL
       AND tro.start_date <= tro.end_date
       AND tro.start_date >= gost_row_g.dat_dolaska
       AND tro.end_date <= gost_row_g.dat_odlaska
       AND tro.quantity IS NOT NULL
       AND tro.quantity > 0
       AND sc_param_1009_l = 'da'
    )
  LOOP
    naredba_l :=
     'BEGIN
        pra_rec_iud4.puni_troskove<CVOR> (
          gostk_id_p => :gost_row_g_id,
          agek_id_p => NULL,
          pkaadrk_id_p => NULL,
          gostp_id_p => :gostx2_id_l,
          agep_id_p => NULL,
          pkaadrp_id_p => NULL,
          so_id_p => :so_id_l,
          cje_id_p => :gost_row_g_cje_id,
          ms_id_p => :gost_row_g_ms_id,
          age_id_p => NULL,
          usl_id_p => :tro_c_usl_id,
          sas_id_p => NULL,
          kol_usluge_p => :tro_c_kol_usluge,
          vsj_id_p => :gost_row_g_vsj_id,
          dat_poc_p => :tro_c_dat_poc,
          dat_zav_p => :tro_c_dat_zav,
          br_uputnice_p => NULL,
          stopa_placanja_p => 100,
          ozn_gratis_p => 0,
          ozn_platitelj_p => NULL,
          cijena_usluge_p => NULL,
          val_id_p => NULL,
          recara_id_p => NULL,
          ponso_id_p => NULL,
          recvpro_id_p => NULL,
          usl_id1_p => NULL,
          recrez2pros_id_p => NULL,
          recrez2opr_id_p => NULL,
          ozn_postoji_cijena_p => :ozn_postoji_cijena_l);
      END;';
    EXECUTE IMMEDIATE REPLACE (naredba_l, '<CVOR>', cvor_m) USING
      gost_row_g.id,
      gostx2_id_l,
      so_id_l,
      gost_row_g.cje_id,
      gost_row_g.ms_id,
      tro_c.usl_id,
      tro_c.kol_usluge,
      gost_row_g.vsj_id,
      tro_c.dat_poc,
      tro_c.dat_zav,
      IN OUT ozn_postoji_cijena_l;
  END LOOP;
  -- KRAJ IRN 3275, puni T_TROSKOVI iz services_tab_m

  -- puni T_KGOSTIJU
  kgost_row_g.gost_id := gost_row_g.id;

  dob_l := pra_rec_s3.dob (kgost_row_g.dat_rodjenja, gost_row_g.dat_dolaska);
  IF dob_l BETWEEN 0 AND 11 THEN
    vplabp_sifra_l := 'A';
  ELSIF dob_l BETWEEN 12 AND 17 THEN
    vplabp_sifra_l := 'J';
  ELSE
    vplabp_sifra_l := 'N';
  END IF;
  -- IRN 3729
  IF residence_country_m = 'HR'
    AND UPPER (kgost_row_g.naz_pboravista) IN (so_naz_grada_l, so_naz_mjesta_l)
    AND vplabp_sifra_l IN ('J', 'N')
  THEN
    vplabp_sifra_l := 'L';
  END IF;
  -- KRAJ IRN 3729
  SELECT MIN (id) INTO kgost_row_g.vplabp_id FROM s_vplabp_tz WHERE sifra = vplabp_sifra_l;

  -- REC param 1170 Knjiga gostiju za domae i strane goste vodi se: 1 = zajedno ili 2 = odvojeno
  IF rec_param_1170_l = '1' THEN
    kgost_row_g.ozn_vknjiga := '2'; -- zajednika knjiga
  ELSE
    -- Provjerite vrijednost #0 parametra #1!
    pra_zmp_zaj.vrati_poruku_zaj ('ZMP', -20100, 'REC', '1170');
  END IF;
  kgost_row_g.oznaka := 'V';
  kgost_row_g.ozn_datrodj := 'P'; -- poznat
  -- kgost_row_g.ozn_recagost := 0;  -- IRN 3223 ozn_recagost iz ms
  naredba_l := 'SELECT ozn_recagost FROM m_msegmenti<CVOR> WHERE id = :gost_row_g_ms_id';
  EXECUTE IMMEDIATE REPLACE (naredba_l, '<CVOR>', cvor_m) INTO kgost_row_g.ozn_recagost USING gost_row_g.ms_id;
  kgost_row_g.ozn_brisano := 0;
  kgost_row_g.sat_dolaska := SYSDATE;

  -- SC param 1005 Dopustiti unos registarske oznake vozila: da ili ne.
  IF sc_param_1005_l = 'da' THEN
    kgost_row_g.reg_vozila := plate_m;
  END IF;

  -- REC param 1185 Uobiajeni sat odlaska od 0 do 24 ili nebitno.
  IF rec_param_1185_l = 'nebitno' THEN
    kgost_row_g.sat_odlaska :=
      TO_DATE (TO_CHAR (gost_row_g.dat_odlaska, 'DD.MM.RRRR') || ' ' || '10:00', 'DD.MM.RRRR HH24:MI');
  ELSE
    kgost_row_g.sat_odlaska :=
      TO_DATE (TO_CHAR (gost_row_g.dat_odlaska, 'DD.MM.RRRR') || ' ' || rec_param_1185_l || ':00', 'DD.MM.RRRR HH24:MI');
  END IF;

  naredba_l := 'BEGIN INSERT INTO t_kgostiju<CVOR> VALUES pra_self_check_in.kgost_row_g; END;';
  EXECUTE IMMEDIATE REPLACE (naredba_l, '<CVOR>', cvor_m);

END;
PROCEDURE POM_PRE_CHECK_IN
 IS
-- IRN 3200; poziva se iz procedure check_in
  naredba_l VARCHAR2(32000);
  rc_l SYS_REFCURSOR;

  CURSOR loykar_c IS
    SELECT loykar.recagost_id, UPPER (recagost.ime), UPPER (recagost.prezime)
      FROM tloy_kartice loykar, trec_agostiju recagost
     WHERE loykar.broj = loyalty_card_m
       AND loykar.recagost_id = recagost.id
       AND recagost.oznaka = 'V';
  recagost_ime_l trec_agostiju.ime%TYPE;
  recagost_prezime_l trec_agostiju.prezime%TYPE;
  br_redaka_l NUMBER; -- IRN 3679

  sc_param_1005_l szmp_parametri.vrijednost%TYPE;

  -- IRN 4031
  rez_id_l          t_rezervacije.id%TYPE;
  sat_dolaska_old_l t_rezervacije.sat_dolaska%TYPE;
  sat_odlaska_old_l t_rezervacije.sat_odlaska%TYPE;
  sat_dolaska_new_l t_rezervacije.sat_dolaska%TYPE;
  sat_odlaska_new_l t_rezervacije.sat_odlaska%TYPE;
BEGIN

  naredba_l := 'SELECT * FROM t_rez_gost<CVOR> WHERE id = :guest_id_m';
  OPEN rc_l FOR REPLACE (naredba_l, '<CVOR>', cvor_m) USING guest_id_m;
  FETCH rc_l INTO rezgost_row_g;
  IF rc_l%NOTFOUND THEN
    CLOSE rc_l;
    -- Pogrena vrijednost parametra #0.
    pra_zmp_zaj.vrati_poruku_zaj ('REC', -20474, 'access_code');
  END IF;
  CLOSE rc_l;

  rezgost_row_g.ime     := UPPER (NVL (ime_m, rezgost_row_g.ime));
  rezgost_row_g.prezime := UPPER (NVL (prezime_m, rezgost_row_g.prezime));

  IF loyalty_card_m IS NOT NULL THEN
    OPEN loykar_c;
    FETCH loykar_c INTO rezgost_row_g.recagost_id, recagost_ime_l, recagost_prezime_l;
    CLOSE loykar_c;
    IF rezgost_row_g.recagost_id IS NOT NULL
      AND recagost_ime_l = rezgost_row_g.ime
      AND recagost_prezime_l = rezgost_row_g.prezime
    THEN
      NULL;
    ELSE
      -- isprazni recagost_id jer kartica ne pripada gostu
      rezgost_row_g.recagost_id := NULL;
    END IF;
  END IF;

  -- IRN 3679
  IF rezgost_row_g.recagost_id IS NOT NULL THEN
    SELECT COUNT (1) INTO br_redaka_l
      FROM trec_agostiju
     WHERE id = gost_row_g.recagost_id
       AND oznaka = 'P';
    IF br_redaka_l > 0 THEN
      -- isprazni recagost_id da se ne javlja poruka
      -- -20404 Valjani podaci ne mogu se vezati s ponitenim podacima o gostu iz arhive.
      rezgost_row_g.recagost_id := NULL;
    END IF;
  END IF;

  -- IRN 3713; :rez_id --> NULL
  IF rezgost_row_g.recagost_id IS NOT NULL THEN
    naredba_l :=
      'BEGIN
         pra_t_rez_gost.provjeri_rez_recagost<CVOR> (
           recagost_id_p => :recagost_id,
           rez_id_p      => NULL,
           rezgost_id_p  => :rezgost_id,
           dat_dolaska_p => :dat_dolaska,
           dat_odlaska_p => :dat_odlaska);
       END;';
    BEGIN
      EXECUTE IMMEDIATE REPLACE (naredba_l, '<CVOR>', cvor_m) USING
        rezgost_row_g.recagost_id,
        guest_id_m,
        gost_row_g.dat_dolaska,
        gost_row_g.dat_odlaska;
    EXCEPTION
      WHEN OTHERS THEN
        -- isprazni recagost_id da se ne javlja greka
        -- -20478 Veza gosta iz arhive i rezervacije ili gosta u boravku ve postoji.
        rezgost_row_g.recagost_id := NULL;
    END;
  END IF;

  IF rezgost_row_g.recagost_id IS NULL AND loyalty_card_m IS NOT NULL THEN
    rezgost_row_g.napomena := pra_zmp_zaj.poruka ('REC', 'REC_LOYKAR') || ' ' || loyalty_card_m;
  END IF;
  -- KRAJ IRN 3679

  rezgost_row_g.dat_rodjenja := kgost_row_g.dat_rodjenja;
  IF rezgost_row_g.dob IS NOT NULL THEN -- IRN 3335
    rezgost_row_g.dob := pra_rec_s3.dob (rezgost_row_g.dat_rodjenja, gost_row_g.dat_dolaska);
  END IF;
  rezgost_row_g.ozn_spola   := kgost_row_g.ozn_spola;
  rezgost_row_g.zemd_id     := gost_row_g.zem_id;
  rezgost_row_g.zemr_id     := kgost_row_g.zemr_id;
  rezgost_row_g.zem_id      := kgost_row_g.zem_id;
  rezgost_row_g.vpisp_id    := kgost_row_g.vpisp_id;
  rezgost_row_g.br_pisprave := kgost_row_g.br_pisprave;
  rezgost_row_g.naz_mjesta  := NVL (kgost_row_g.naz_pboravista, kgost_row_g.naz_mjesta);
  rezgost_row_g.naz_ulice   := kgost_row_g.naz_ulice;
  -- IRN 3275
  rezgost_row_g.sc_korisnik := NVL (apex_application.g_user, zmp_zaj.korisnik (-1));
  rezgost_row_g.sc_dat      := SYSDATE;
  rezgost_row_g.br_telefona := kgost_row_g.br_telefona;

  -- SC parametar 1005 Dopustiti unos registarske oznake vozila: da ili ne.
  naredba_l := 'SELECT pra_zmp_zaj.zmppar_vrijednost<CVOR> (''SC'', ''1005'') FROM dual'; -- IRN 3275
  EXECUTE IMMEDIATE REPLACE (naredba_l, '<CVOR>', cvor_m) INTO sc_param_1005_l;
  IF sc_param_1005_l = 'da' THEN
    rezgost_row_g.reg_vozila := plate_m;
  END IF;

  naredba_l := 'BEGIN UPDATE t_rez_gost<CVOR> SET ROW = pra_self_check_in.rezgost_row_g WHERE id = :guest_id_m; END;';
  EXECUTE IMMEDIATE REPLACE (naredba_l, '<CVOR>', cvor_m) USING guest_id_m;

  -- IRN 4031; auriraj sat dolaska i sat odlaska u t_rezervacije
  IF arrival_time_m IS NOT NULL OR departure_time_m IS NOT NULL THEN

    naredba_l :=
      'SELECT id, sat_dolaska, sat_odlaska
         FROM t_rezervacije<CVOR>
        WHERE id = (SELECT rez_id FROM t_rez_vsj<CVOR> WHERE id = :rezvsj_id)';
    EXECUTE IMMEDIATE REPLACE (naredba_l, '<CVOR>', cvor_m)
       INTO rez_id_l, sat_dolaska_old_l, sat_odlaska_old_l
      USING rezgost_row_g.rezvsj_id;

    IF arrival_time_m IS NOT NULL
      AND (sat_dolaska_old_l IS NULL OR sat_dolaska_old_l > arrival_time_m)
    THEN
      sat_dolaska_new_l := arrival_time_m;
    END IF;
    IF departure_time_m IS NOT NULL
      AND (sat_odlaska_old_l IS NULL OR sat_odlaska_old_l < departure_time_m)
    THEN
      sat_odlaska_new_l := departure_time_m;
    END IF;

    naredba_l :=
      'BEGIN
         UPDATE t_rezervacije<CVOR>
            SET sat_dolaska = NVL (:sat_dolaska_new_l, sat_dolaska),
                sat_odlaska = NVL (:sat_odlaska_new_l, sat_odlaska)
          WHERE id = :rez_id_l
            AND (:sat_dolaska_new_l IS NOT NULL OR :sat_odlaska_new_l IS NOT NULL);
       END;';
    EXECUTE IMMEDIATE REPLACE (naredba_l, '<CVOR>', cvor_m)
      USING sat_dolaska_new_l, sat_odlaska_new_l, rez_id_l;

  END IF;

END;
FUNCTION VALJAN_PRISTUPNI_KOD
 (P_USERNAME IN VARCHAR2
 ,P_PASSWORD IN VARCHAR2
 )
 RETURN BOOLEAN
 IS
/*
  Funkcija autentikacije Self-Check-in apex aplikacije.
  Vraa TRUE ako je unesen valjani pristupni kod. U suprotnom
  vraa FALSE.
*/

  l_rez_id NUMBER;
  l_zak_id NUMBER;
  l_broj   NUMBER;
BEGIN
  -- napuni kolekciju
  pra_self_check_in.puni_coll_sci_gost(
    p_password
  );

  SELECT COUNT(1)
  INTO l_broj
  FROM apex_collections
  WHERE collection_name = 'SCI_GOSTI';

  -- kod nije valjan ako je kolekcija prazna
  IF l_broj = 0 THEN
    RETURN FALSE;
  END IF;

  -- dohvati rez_id, zak_id
  SELECT
    rez_id,
    zak_id
  INTO
    l_rez_id,
    l_zak_id
  FROM lrec_kodovi
  WHERE kod = p_password;

  -- postavi aplikacijske varijable
  apex_util.set_session_state( 'APP_KOD', p_password );
  apex_util.set_session_state( 'APP_CVOR', cvor_m );

  IF l_rez_id IS NOT NULL THEN
    apex_util.set_session_state( 'APP_OZN_REZ_ZAK', 'REZ' );
  ELSIF l_zak_id IS NOT NULL THEN
    apex_util.set_session_state( 'APP_OZN_REZ_ZAK', 'ZAK' );
  END IF;

  RETURN TRUE;

END;
PROCEDURE PUNI_COLL_EVMJESTA
 IS
/*
  Stvaranje/ienje Apex kolekcije i punjenje iste
  s nazivima naselja po notaciji sustava eVisitor
*/

  naziv_coll_l VARCHAR2(30) := 'EVMJESTA';
BEGIN
  -- kreira/oisti kolekciju
  apex_collection.create_or_truncate_collection(
    p_collection_name => naziv_coll_l
  );

  -- dohvati naselja
  FOR evm_c IN (
    SELECT
      evm.id AS id,
      evm.puni_naziv AS naziv
    FROM mzmp_evmjesta evm
    WHERE
      evm.dat_valjan <= TRUNC(sysdate) AND
      NVL(evm.dat_ponisten, sysdate+1) > TRUNC(sysdate)
    ORDER BY 2
  )
  LOOP
    -- dodaj stavku u kolekciju
    apex_collection.add_member( p_collection_name => naziv_coll_l,
      p_c001 => evm_c.id,
      p_c002 => evm_c.naziv
    );

  END LOOP;

END;
PROCEDURE PUNI_COLL_VPISPRAVA
 IS
/*
  Stvaranje Apex kolekcije za popunjavanje select liste
  za vrste putnih isprava na odabranom jeziku
*/

  naziv_coll_l VARCHAR2(30) := 'VPISPRAVA';
BEGIN
  -- kreira/oisti kolekciju
  apex_collection.create_or_truncate_collection(
    p_collection_name => naziv_coll_l
  );

  -- dohvati vrste putnih isprava na odabranom jeziku
  -- ako nema prijevoda, prikai neprevedeni naziv
  FOR vpisp_c IN(
    SELECT
      vpisp.id AS vpisp_id,
      vpisp.sifra AS sifra,
      NVL (vpispjez.naziv, vpisp.naziv) AS naziv,
      vpisp.ozn_strani AS ozn_strani
    FROM s_vpisprava vpisp
    LEFT OUTER JOIN s_jezici jez ON
      jez.sifra_2a = apex_util.get_session_state('FSP_LANGUAGE_PREFERENCE')
    LEFT OUTER JOIN s_vpisp_jez vpispjez ON
      vpisp.id = vpispjez.vpisp_id AND
      vpispjez.jez_id = jez.id
    WHERE
      vpisp.dat_valjan <= TRUNC (SYSDATE) AND
      NVL (vpisp.dat_ponisten, SYSDATE + 1) > SYSDATE AND
      vpisp.ozn_sc = -1 -- IRN 3275
    ORDER BY 3
  )
  LOOP
    -- dodaj stavku u kolekciju
    apex_collection.add_member( p_collection_name => naziv_coll_l,
      p_c001 => vpisp_c.vpisp_id,
      p_c002 => vpisp_c.sifra,
      p_c003 => vpisp_c.naziv,
      p_c004 => vpisp_c.ozn_strani
    );
  END LOOP;

END;
PROCEDURE PUNI_COLL_USLUGE
 (SO_SIFRA_P IN M_SO.SIFRA%TYPE
 )
 IS
/*
  Stvaranje Apex kolekcije za popunjavanje select liste
  usluga za self check-in na odabranom jeziku.
  Popis ne ukljuuje usluge sa sastojkom.
*/

  TYPE usl_rec_type IS RECORD(
    sifra s_usluge.sifra%TYPE,
    naziv s_usluge.naziv%TYPE
  );
  usl_rec_l    usl_rec_type;
  rc_l         sys_refcursor;
  naziv_coll_l VARCHAR2(30) := 'USLUGE';
BEGIN
  -- dohvati usluge sa oznakom za self check-in na odabranom jeziku
  -- ako nema prijevoda, prikai naziv na hrvatskom
  -- dohvati samo usluge dodijeljene proslijeenom SO
  rc_l := pra_self_check_in.usl_lista(
            so_sifra_p,
            NVL( apex_util.get_session_state('FSP_LANGUAGE_PREFERENCE'), 'hr')
          );

  -- kreira/oisti kolekciju
  apex_collection.create_or_truncate_collection(
    p_collection_name => naziv_coll_l
  );

  LOOP
    FETCH rc_l INTO usl_rec_l;
    EXIT WHEN rc_l%NOTFOUND;
    -- dodaj stavku u kolekciju
    apex_collection.add_member( p_collection_name => naziv_coll_l,
      p_c001 => usl_rec_l.sifra,
      p_c002 => usl_rec_l.naziv
    );

  END LOOP;

END;
PROCEDURE PUNI_COLL_ZEMLJE
 IS
/*
  Stvaranje Apex kolekcije za popunjavanje select liste
  za drave na odabranom jeziku
*/

  naziv_coll_l VARCHAR2(30) := 'ZEMLJE';
BEGIN
  -- kreira/oisti kolekciju
  apex_collection.create_or_truncate_collection(
    p_collection_name => naziv_coll_l
  );

  -- dohvati zemlje na odabranom jeziku
  -- ako nema prijevoda, prikai naziv na hrvatskom
  FOR zem_c IN(
    SELECT
      zem.id AS zem_id,
      zem.sifra_2a AS sifra_2a,
      zem.sifra_3a AS sifra_3a,
      INITCAP( NVL( zemjez.naziv, zem.naziv ) ) AS naziv
    FROM s_zemlje zem
    LEFT OUTER JOIN s_jezici jez ON
      jez.sifra_2a = apex_util.get_session_state('FSP_LANGUAGE_PREFERENCE')
    LEFT OUTER JOIN s_zem_jez zemjez ON
      zem.id = zemjez.zem_id AND
      jez.id = zemjez.jez_id
    WHERE
      zem.dat_valjan <= TRUNC(sysdate) AND
      NVL(zem.dat_ponisten, sysdate+1) > TRUNC(sysdate)
    ORDER BY 4
  )
  LOOP
    -- dodaj stavku u kolekciju
    apex_collection.add_member( p_collection_name => naziv_coll_l,
      p_c001 => zem_c.zem_id,
      p_c002 => zem_c.sifra_2a,
      p_c003 => zem_c.sifra_3a,
      p_c004 => zem_c.naziv
    );

  END LOOP;

END;
PROCEDURE PUNI_COLL_SCI_GOST
 (KOD_P IN LREC_KODOVI.KOD%TYPE
 )
 IS
/*
  Stvara/oisti apex kolekciju i napuni je s podacima o gostima
  korisnicima ugovora o zakupu ili osobama u rezervaciji,
  gdje su ugovor ili rezervacija vezani za proslijeeni pristupni kod
*/

  rc_l         sys_refcursor;
  pci_status_l NUMBER;
  naziv_coll_l VARCHAR2(30) := 'SCI_GOSTI';

  TYPE sci_gost_rec_type IS RECORD(
    pristupni_kod t_zakup.pristupni_kod%TYPE,
    mish_source_type VARCHAR2(20), -- contract ili reservation
    prijavljen VARCHAR2(5),
    so_sifra m_so.sifra%TYPE,
    so_naziv m_so.naziv%TYPE,
    sj_broj m_sj.broj%TYPE,
    gost_id t_zak_korisnici.id%TYPE,
    gost_rbr t_gosti.rbr%TYPE,
    ime t_zak_korisnici.ime%TYPE,
    prezime t_zak_korisnici.prezime%TYPE,
    dat_poc DATE,
    dat_zav DATE,
    dat_dolaska DATE,
    dat_odlaska DATE,
    sat_dolaska VARCHAR2(5),
    sat_odlaska VARCHAR2(5),
    reg_vozila t_zak_korisnici.reg_vozila%TYPE,
    reg_allowed VARCHAR2(5),
    drzavljanstvo s_zemlje.sifra_2a%TYPE,
    spol trec_agostiju.ozn_spola%TYPE,
    dob t_rez_gost.dob%TYPE,
    dat_rodenja DATE,
    zem_rod_sifra s_zemlje.sifra_2a%TYPE,
    zem_rod_naziv s_zemlje.naziv%TYPE,  -- IRN 3275
    vpisp_sifra s_vpisprava.sifra%TYPE,
    vpisp_naziv s_vpisprava.naziv%TYPE, -- IRN 3275
    br_pisprave trec_agostiju.br_pisprave%TYPE,
    loy_kar_broj tloy_kartice.broj%TYPE,
    zem_preb_sifra s_zemlje.sifra_2a%TYPE,
    mjesto_preb_naziv trec_agostiju.naz_mjesta%TYPE,
    ulica_preb trec_agostiju.naz_ulice%TYPE,
    br_telefona t_rez_gost.br_telefona%TYPE
  );
  sci_gost_rec_l sci_gost_rec_type;
BEGIN
  -- dohvati podatke o gostima na temelju koda
  rc_l := pra_self_check_in.kod_lista(
            kod_p,
            NVL( apex_util.get_session_state('FSP_LANGUAGE_PREFERENCE'), 'hr')
          );

  -- kreiraj/oisti apex kolekciju
  apex_collection.create_or_truncate_collection(
    p_collection_name => naziv_coll_l
  );

  -- napuni kolekciju
  LOOP
    FETCH rc_l INTO sci_gost_rec_l;
    EXIT WHEN rc_l%NOTFOUND;

    pci_status_l := -1; -- podaci pretprijave spremljeni

    IF sci_gost_rec_l.spol IS NULL OR
       sci_gost_rec_l.dat_rodenja IS NULL OR
       sci_gost_rec_l.zem_rod_sifra IS NULL OR
       sci_gost_rec_l.drzavljanstvo IS NULL OR
       sci_gost_rec_l.vpisp_sifra IS NULL OR
       sci_gost_rec_l.br_pisprave IS NULL OR
       sci_gost_rec_l.zem_preb_sifra IS NULL THEN
      pci_status_l := 0; -- nedostaju podaci pretprijave
    END IF;

    apex_collection.add_member( p_collection_name => naziv_coll_l,
      p_c001 => sci_gost_rec_l.gost_id,
      p_c002 => sci_gost_rec_l.prezime,
      p_c003 => sci_gost_rec_l.ime,
      p_c004 => sci_gost_rec_l.spol,
      p_c005 => sci_gost_rec_l.zem_rod_sifra,
      p_c006 => sci_gost_rec_l.drzavljanstvo,
      p_c007 => sci_gost_rec_l.zem_preb_sifra,
      p_c008 => sci_gost_rec_l.mjesto_preb_naziv,
      p_c009 => sci_gost_rec_l.ulica_preb,
      p_c010 => sci_gost_rec_l.vpisp_sifra,
      p_c011 => sci_gost_rec_l.br_pisprave,
      p_c012 => sci_gost_rec_l.so_sifra,
      p_c013 => sci_gost_rec_l.so_naziv,
      p_c014 => sci_gost_rec_l.sj_broj,
      p_c015 => sci_gost_rec_l.loy_kar_broj,
      p_c016 => sci_gost_rec_l.prijavljen,
      p_c017 => sci_gost_rec_l.reg_vozila,
      p_c018 => sci_gost_rec_l.reg_allowed,
      p_c019 => pci_status_l,
      p_c020 => sci_gost_rec_l.zem_rod_naziv,
      p_c021 => sci_gost_rec_l.vpisp_naziv,
      p_c022 => sci_gost_rec_l.br_telefona,
      p_c023 => sci_gost_rec_l.sat_dolaska,
      p_c024 => sci_gost_rec_l.sat_odlaska,
      p_n001 => sci_gost_rec_l.dob,
      p_d001 => sci_gost_rec_l.dat_rodenja,
      p_d002 => sci_gost_rec_l.dat_dolaska,
      p_d003 => sci_gost_rec_l.dat_odlaska,
      p_d004 => sci_gost_rec_l.dat_poc,
      p_d005 => sci_gost_rec_l.dat_zav
    );

  END LOOP;

END;
PROCEDURE GET_ACCESS_CODE
 (VOUCHER_P IN t_rezervacije.br_uputnice%TYPE
 ,ARRIVAL_DATE_P IN t_rezervacije.dat_dolaska%TYPE := NULL
 ,DEPARTURE_DATE_P IN t_rezervacije.dat_odlaska%TYPE := NULL
 ,EMAIL_P IN t_rezervacije.email%TYPE
 ,LANG_P IN s_jezici.sifra_2a%TYPE := NULL
 ,RESPONSE_P OUT VARCHAR2
 )
 IS
-- IRN 3329
  CURSOR rez_c IS
    SELECT DISTINCT cvor, rez_id, ime, prezime, dat_dolaska, dat_odlaska, ms_sifra, so_sifra
      FROM v_trec_rezvsj
     WHERE oznaka = 'V'
       AND ozn_vstorna IS NULL
       AND dat_dolaska >= TRUNC (SYSDATE)
       AND UPPER (br_uputnice) = UPPER (voucher_p)
       AND (arrival_date_p IS NULL OR dat_dolaska = arrival_date_p)
       AND (departure_date_p IS NULL OR dat_odlaska = departure_date_p)
       AND pristupni_kod IS NULL;
  rez_c_l  rez_c%ROWTYPE;
  rez2_c_l rez_c%ROWTYPE;
  cvor_l VARCHAR2(41) := NULL;
  naredba_l VARCHAR2(32000);
  sc_param_1018_l szmp_parametri.vrijednost%TYPE;
  sc_param_1019_l szmp_parametri.vrijednost%TYPE;
  oznaka_l NUMBER := 0;
  pristupni_kod_l t_rezervacije.pristupni_kod%TYPE;
  ozn_poslano_l NUMBER := 0;
BEGIN

  opis_m := SUBSTR (
    'voucher_p ' || voucher_p ||
      ', arrival_date ' || TO_CHAR (arrival_date_p, 'DD.MM.RRRR') ||
      ', departure_date ' || TO_CHAR (departure_date_p, 'DD.MM.RRRR') ||
      ', email ' || email_p ||
      ', lang ' || lang_p,
    1, 2000);

  lang_m := lang_p;
  pra_self_check_in.zaj_set_sifra_jez_m;

  -- Nedostaje obvezan ulazni parametar (#0).
  IF voucher_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku_zaj ('REC', -20422, 'voucher');
  ELSIF (arrival_date_p IS NULL AND departure_date_p IS NULL) THEN
    pra_zmp_zaj.vrati_poruku_zaj ('REC', -20422, 'arrival_date/departure_date');
  ELSIF email_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku_zaj ('REC', -20422, 'email');
  -- lang_p
  END IF;

  OPEN rez_c;
  FETCH rez_c INTO rez_c_l;
  IF rez_c%NOTFOUND THEN
    CLOSE rez_c;
    RAISE NO_DATA_FOUND;   -- ne postoji valjana rezervacija s traenim brojem uputnice i datumom dolaska/odlaska
  ELSE
    FETCH rez_c INTO rez2_c_l;
    IF rez_c%FOUND THEN
      CLOSE rez_c;
      RAISE NO_DATA_FOUND; -- postoji vie valjanih rezervacija s traenim brojem uputnice i datumom dolaska/odlaska
    END IF;
  END IF;

  IF rez_c_l.cvor <> pra_zmp_zaj.tekuci_cvor THEN
    cvor_l := '@' || rez_c_l.cvor;
  END IF;

  -- SC parametar 1018 Omogueno je zaprimanje upita za dostavu pristupnog koda: da ili ne.
  -- SC parametar 1019 ifre MS (odvojene zarezom) kojima pripadaju rezervacije za koje se trai pristupni kod ili nebitno.
  naredba_l :=
    'SELECT
       pra_zmp_zaj.zmppar_vrijednost<CVOR> (''SC'', ''1018''),
       pra_zmp_zaj.zmppar_vrijednost<CVOR> (''SC'', ''1019''),
       pra_zmp_s.oznaka<CVOR> (''P0027'', :so_sifra)
     FROM dual';
  EXECUTE IMMEDIATE REPLACE (naredba_l, '<CVOR>', cvor_l) INTO sc_param_1018_l, sc_param_1019_l, oznaka_l USING rez_c_l.so_sifra;

  IF sc_param_1018_l <> 'da' THEN
    -- Provjerite vrijednost #0 parametra #1!
    pra_zmp_zaj.vrati_poruku_zaj ('ZMP', -20100, 'SC', '1018'); -- na shemi nije omogueno zaprimanje upita za dostavu pristupnog koda
  END IF;

  IF zmp_zaj.string_in_list (rez_c_l.ms_sifra, sc_param_1019_l) = 0 THEN
    -- Provjerite vrijednost #0 parametra #1!
    pra_zmp_zaj.vrati_poruku_zaj ('ZMP', -20100, 'SC', '1019'); -- MS rezervacije nije naveden u SC parametru 1019
  END IF;

  IF oznaka_l = 0 THEN
    -- Nedoputen pristup!
    pra_zmp_zaj.vrati_poruku_zaj ('ZMP', -20138); -- modul SC nije aktivan za rezervirani SO
  END IF;

  naredba_l := 'SELECT pra_rec3.pristupni_kod<CVOR> (NULL, :rez_id) FROM dual';
  EXECUTE IMMEDIATE REPLACE (naredba_l, '<CVOR>', cvor_l) INTO pristupni_kod_l USING rez_c_l.rez_id;

  IF pristupni_kod_l IS NULL THEN
    RAISE NO_DATA_FOUND; -- greka kod kreiranja pristupnog koda
  END IF;

  naredba_l :=
    'BEGIN
       UPDATE t_rezervacije<CVOR>
          SET pristupni_kod = :pristupni_kod,
              email = :email,
              jez_id = NVL (:jez_id, jez_id)
        WHERE id = :rez_id;
       pra_mpka_veporuka.salji_pristupni_kod<CVOR> (
         ozn_veporuka_p  => ''60'',
         ime_p           => :ime,
         prezime_p       => :prezime,
         email_p         => :email,
         jez_id_p        => :jez_id,
         jez_sifra_3a_p  => :jez_sifra_3a,
         pristupni_kod_p => :pristupni_kod,
         dat_dolaska_p   => :dat_dolaska,
         dat_odlaska_p   => :dat_odlaska,
         rez_id_p        => :rez_id,
         ozn_poslano_p   => :ozn_poslano_l);
       IF :ozn_poslano_l = -1 THEN
         COMMIT;
       ELSE
         ROLLBACK;
       END IF;
     END;';
  EXECUTE IMMEDIATE REPLACE (naredba_l, '<CVOR>', cvor_l)
    USING pristupni_kod_l,
          email_p,
          gost_row_g.jez_id,    -- puni procedura zaj_set_sifra_jez_m
          rez_c_l.rez_id,
          rez_c_l.ime,
          rez_c_l.prezime,
          -- email,             -- ve navedeno
          -- jez_id,            -- ve navedeno
          sifra_jez_m,          -- puni procedura zaj_set_sifra_jez_m
          -- pristupni_kod,     -- ve navedeno
          rez_c_l.dat_dolaska,
          rez_c_l.dat_odlaska,
          -- rez_id,            -- ve navedeno
          IN OUT ozn_poslano_l;

  IF ozn_poslano_l = -1 THEN
    response_p := 'OK';
  ELSE
    RAISE NO_DATA_FOUND; -- poruka s pristupnim kodom nije poslana
  END IF;

EXCEPTION
  WHEN OTHERS THEN
    ROLLBACK;
    response_p := SUBSTR ('ERROR ' || SQLERRM, 1, 2000);
    pra_rec.puni_promjene ('9321', SUBSTR (response_p || ' | ' || opis_m, 1, 2000), 0);
    RAISE;
END;
FUNCTION POM_REZ_SJ_ID
 RETURN t_rez_vsj.sj_id%TYPE
 IS
-- IRN 3906; poziva se iz procedure check_in
  naredba_l VARCHAR2(1000);
  sj_id_l t_rez_vsj.sj_id%TYPE;
BEGIN
  naredba_l :=
   'SELECT
      NVL (rezgost.sj_id, rezvsj.sj_id)
    FROM
      t_rez_gost<CVOR> rezgost,
      t_rez_vsj<CVOR> rezvsj
    WHERE
      rezgost.id = :guest_id_m
      AND rezgost.rezvsj_id = rezvsj.id';

  EXECUTE IMMEDIATE REPLACE (naredba_l, '<CVOR>', cvor_m) INTO sj_id_l USING guest_id_m;
  RETURN sj_id_l;
END;

END PRA_SELF_CHECK_IN;
/
SHOW ERROR

