-- C:\Radni\pra_rec_s5.pkb
--
-- Generated for Oracle 10g on Mon Nov 03  10:13:39 2025 by Server Generator 6.5.96.5.6
 

PROMPT Creating Package Body 'PRA_REC_S5'
CREATE OR REPLACE PACKAGE BODY PRA_REC_S5 IS

FUNCTION RACUPUT_REZ_IMEP
 (RAC_ID_P IN t_racuni.id%TYPE
 ,BR_UPUTNICE_P IN t_troskovi.br_uputnice%TYPE
 )
 RETURN VARCHAR2
 IS
-- popis imena i prezimena iz rezervacija za koje su vezani gosti
-- koji imaju trokove s uputnicom br_uputnice_p zaraunate na raunu rac_id_p
-- koristi se u v_pspp_rac_uput
  racuput_rez_imep_l VARCHAR2(4000);
  ime_prezime_l VARCHAR2(4000);
BEGIN

  FOR rez_c IN (
    SELECT DISTINCT rez.ime, rez.prezime
      FROM (
           SELECT DISTINCT gost_id
             FROM t_troskovi tro
            WHERE tro.br_uputnice = br_uputnice_p
              AND tro.rac_id = rac_id_p
           ) tro,
           t_gosti gost, t_rez_vsj rezvsj, t_rezervacije rez
     WHERE tro.gost_id = gost.id
       AND gost.rezvsj_id = rezvsj.id (+)
       AND NVL (rezvsj.rez_id, 0) = NVL (rez.id, 0)
    )
  LOOP
    IF rez_c.prezime IS NOT NULL THEN
      IF rez_c.ime IS NOT NULL THEN
        ime_prezime_l := rez_c.ime ||  ' ' || rez_c.prezime || '; ';
      ELSE
        ime_prezime_l := rez_c.prezime || '; ';
      END IF;
      IF LENGTH (racuput_rez_imep_l || ime_prezime_l) <= 4000 THEN
        racuput_rez_imep_l := racuput_rez_imep_l || ime_prezime_l;
      END IF;
    END IF;
  END LOOP;

  RETURN (racuput_rez_imep_l);
END;
FUNCTION VISE_SEZONA
 (CJE_ID_P IN t_cjenici.id%TYPE
 ,SO_ID_P IN m_so.id%TYPE
 ,VSJ_ID_P IN s_vsj.id%TYPE
 ,USL_ID_P IN s_usluge.id%TYPE
 ,DAT_POC_P IN DATE
 ,DAT_ZAV_P IN DATE
 ,RECARA_ID_P IN mrec_aranzmani.id%TYPE := NULL
 )
 RETURN NUMBER
 IS
/*
Procedura vrati -1 ako za zadani cjenik, so, vsj, usl, razdoblje, recara ima vie sezona, 0 inae
*/

  dat_zav_l DATE;
  dat_cje_prethodni_l DATE;
  dat_cje_sljedeci_l DATE;
  obr_zdana_l s_usluge.obr_zdana%TYPE;
  obr_po_danu_l s_usluge.obr_po_danu%TYPE;
  ozn_cje_vsj_l s_usluge.ozn_cje_vsj%TYPE;
  ozn_cje_ara_l mrec_ara_usl.ozn_cje_ara%TYPE := 0;
  ozn_ima_vise_sezona_l NUMBER;

  CURSOR recarausl_c IS
    SELECT ozn_cje_ara FROM mrec_ara_usl WHERE usl_id = usl_id_p AND recara_id = recara_id_p;
BEGIN
  IF so_id_p IS NULL OR cje_id_p IS NULL OR usl_id_p IS NULL
    OR dat_poc_p IS NULL OR dat_zav_p IS NULL
    OR dat_zav_p < dat_poc_p
  THEN
    RETURN NULL;
  END IF;
  /* zapamtiti obraun zadnjeg dana */
  SELECT obr_zdana,
         obr_po_danu,
         ozn_cje_vsj
    INTO obr_zdana_l, obr_po_danu_l, ozn_cje_vsj_l
    FROM s_usluge
   WHERE id = usl_id_p;

  dat_zav_l := dat_zav_p - obr_zdana_l;

  IF obr_po_danu_l = 0 OR dat_zav_l - dat_poc_p <= 1 THEN
    ozn_ima_vise_sezona_l := 0;
  ELSE
    SELECT MAX (datum) INTO dat_cje_prethodni_l
      FROM t_cje_usl
     WHERE cje_id = cje_id_p
       AND so_id = so_id_p
       AND NVL (vsj_id, 0) = DECODE (ozn_cje_vsj_l, -1, vsj_id_p, 0, 0)
       AND usl_id = usl_id_p
       AND NVL (recara_id, 0) = DECODE (ozn_cje_ara_l, -1, recara_id_p, 0, 0)
       AND datum <= dat_poc_p;
    SELECT MIN (datum) INTO dat_cje_sljedeci_l
      FROM t_cje_usl
     WHERE cje_id = cje_id_p
       AND so_id = so_id_p
       AND NVL (vsj_id, 0) = DECODE (ozn_cje_vsj_l, -1, vsj_id_p, 0, 0)
       AND usl_id = usl_id_p
       AND NVL (recara_id, 0) = DECODE (ozn_cje_ara_l, -1, recara_id_p, 0, 0)
       AND datum > NVL (dat_cje_prethodni_l, dat_poc_p);
    IF NVL (dat_cje_prethodni_l, dat_poc_p) < NVL (dat_cje_sljedeci_l, dat_zav_l) AND NVL (dat_cje_sljedeci_l, dat_zav_l) < dat_zav_l THEN
      ozn_ima_vise_sezona_l := -1;
    ELSE
      ozn_ima_vise_sezona_l := 0;
    END IF;
  END IF;
  RETURN ozn_ima_vise_sezona_l;
END;
FUNCTION IZN_USL_IZ_CJENIKA
 (CJE_ID_P IN t_cjenici.id%TYPE
 ,SO_ID_P IN m_so.id%TYPE
 ,VSJ_ID_P IN s_vsj.id%TYPE
 ,USL_ID_P IN s_usluge.id%TYPE
 ,OZN_USL1_P IN NUMBER
 ,DAT_POC_P IN DATE
 ,DAT_ZAV_P IN DATE
 ,KOL_SJ_P IN NUMBER
 ,BR_OSOBA_P IN NUMBER
 ,RECARA_ID_P IN mrec_aranzmani.id%TYPE
 )
 RETURN NUMBER
 IS
/*
Procedura izrauna iznos usluge za zadani cjenik, so, vsj, usl,
razdoblje i kol_sj odnosno br_osoba.
*/
  /*
  pra_rec_s5.izn_usl_iz_cjenika
     (cje_id_p =>
     ,so_id_p =>
     ,vsj_id_p =>
     ,usl_id_p =>
     ,ozn_usl1_p =>
     ,dat_poc_p =>
     ,dat_zav_p =>
     ,kol_sj_p =>
     ,br_osoba_p =>
     ,recara_id_p =>
     )
  */

  dat_poc_l DATE;
  dat_zav_l DATE;
  datum_l DATE;
  dat_cje_prethodni_l DATE;
  obr_zdana_l s_usluge.obr_zdana%TYPE;
  obr_po_danu_l s_usluge.obr_po_danu%TYPE;
  ozn_cje_vsj_l s_usluge.ozn_cje_vsj%TYPE;
  kolicina_l NUMBER;
  cijena_usluge_l t_cje_usl.cijena_usluge%TYPE;
  iznos_l NUMBER := 0;
  iznos_pom_l NUMBER;
  ozn_cje_ara_l mrec_ara_usl.ozn_cje_ara%TYPE := 0;

  CURSOR recarausl_c IS
    SELECT ozn_cje_ara FROM mrec_ara_usl WHERE usl_id = usl_id_p AND recara_id = recara_id_p;
BEGIN
  IF so_id_p IS NULL OR cje_id_p IS NULL OR usl_id_p IS NULL
    OR dat_poc_p IS NULL OR dat_zav_p IS NULL
    OR dat_zav_p < dat_poc_p
  THEN
    RETURN NULL;
  END IF;
  /* zapamtiti obraun zadnjeg dana, koliina */
  SELECT obr_zdana,
         obr_po_danu,
         ozn_cje_vsj,
         -- ako je obr_osoba=-1 i ozn_cijenasj=0 => br_osoba inae kol_sj
         DECODE (obr_osoba * (ozn_cijenasj + 1), -1, br_osoba_p, kol_sj_p)
    INTO obr_zdana_l, obr_po_danu_l, ozn_cje_vsj_l, kolicina_l
    FROM s_usluge
   WHERE id = usl_id_p;

  IF obr_po_danu_l = 0 THEN
    dat_zav_l := dat_poc_p;
    dat_cje_prethodni_l := dat_poc_p + 1;
  ELSIF obr_zdana_l = -1 THEN
    dat_zav_l := dat_zav_p;
    dat_cje_prethodni_l := dat_zav_p + 1;
  ELSE
    dat_zav_l := dat_zav_p;
    dat_cje_prethodni_l := dat_zav_p;
  END IF;

  LOOP
    SELECT MAX (datum) INTO datum_l
      FROM t_cje_usl
     WHERE cje_id = cje_id_p
       AND so_id = so_id_p
       AND NVL (vsj_id, 0) = DECODE (ozn_cje_vsj_l, -1, vsj_id_p, 0, 0)
       AND usl_id = usl_id_p
       AND NVL (recara_id, 0) = DECODE (ozn_cje_ara_l, -1, recara_id_p, 0, 0)
       AND datum < dat_cje_prethodni_l;
    IF datum_l IS NOT NULL THEN
      SELECT DECODE (ozn_usl1_p, 0, cijena_usluge, NVL (cje_usl_obr, cijena_usluge))
        INTO cijena_usluge_l
        FROM t_cje_usl
       WHERE cje_id = cje_id_p
         AND so_id = so_id_p
         AND NVL (vsj_id, 0) = DECODE (ozn_cje_vsj_l, -1, vsj_id_p, 0, 0)
         AND usl_id = usl_id_p
         AND NVL (recara_id, 0) = DECODE (ozn_cje_ara_l, -1, recara_id_p, 0, 0)
         AND datum = datum_l;
      SELECT GREATEST (dat_poc_p, datum_l) INTO dat_poc_l FROM dual;
      -- obr_zdana mora utjecati samo na zadnju sezonu i ako iznos ovisi o broju dana u razdoblju
      IF obr_po_danu_l = 0 THEN
        iznos_pom_l :=   cijena_usluge_l * kolicina_l;
      ELSIF dat_cje_prethodni_l > dat_zav_p THEN
        iznos_pom_l := cijena_usluge_l *  (dat_zav_l - dat_poc_l - obr_zdana_l) * kolicina_l;
      ELSE
        iznos_pom_l := cijena_usluge_l * (dat_zav_l - dat_poc_l) * kolicina_l;
      END IF;
      iznos_l := iznos_l + iznos_pom_l;
      dat_zav_l := dat_poc_l;
      dat_cje_prethodni_l := datum_l;
    ELSE
      EXIT;
    END IF;
    EXIT WHEN dat_zav_l <= dat_poc_p;
  END LOOP;
  RETURN iznos_l;
END;
FUNCTION IZN_REZ_PRED
 (REZ_ID_P IN t_rezervacije.id%TYPE
 ,VAL_ID_P IN t_rezervacije.val_id%TYPE
 )
 RETURN NUMBER
 IS
--
   brojac_l NUMBER(2);

   CURSOR pkarac_c IS
      SELECT pkarac.id, NVL (val_id_p, pkarac.val_id)
        FROM tpka_racuni pkarac,
             t_rez_pred rezpred
       WHERE rezpred.rez_id = rez_id_p
         AND pkarac.id = rezpred.pkaracp_id
         AND pkarac.oznaka = 'V'
       ORDER BY rezpred.unos_dat DESC;
   pkarac_id_l tpka_racuni.id%TYPE;
   val_id_l t_rezervacije.val_id%TYPE;

   CURSOR ban_id_c IS
      SELECT id FROM m_banke WHERE sifra = pra_rec_zaj.vrijednost_parametra ('1002');
   ban_id_l m_banke.id%TYPE;

   uk_iznos_pred_l NUMBER;
BEGIN
   SELECT COUNT (1) INTO brojac_l
     FROM tpka_racuni pkarac, t_rez_pred rezpred
    WHERE rezpred.rez_id = rez_id_p
      AND pkarac.id = rezpred.pkaracp_id
      AND pkarac.oznaka = 'V';
   IF brojac_l > 0 THEN
      OPEN pkarac_c;
      FETCH pkarac_c INTO pkarac_id_l, val_id_l;
      CLOSE pkarac_c;
      OPEN ban_id_c;
      FETCH ban_id_c INTO ban_id_l;
      CLOSE ban_id_c;
      SELECT SUM (rezpred.izn_predujma
                  * DECODE (pkarac.val_id, val_id_p, 1,
                       NVL (pkarac.izn_tecaja, 0) / pra_pka.izn_tecaja (val_id_p, ban_id_l, pkarac.vtec_id, pkarac.datum)))
        INTO uk_iznos_pred_l
        FROM tpka_racuni pkarac,
             t_rez_pred rezpred
       WHERE rezpred.rez_id = rez_id_p
         AND pkarac.id = rezpred.pkaracp_id
         AND pkarac.oznaka = 'V';
   ELSE
      uk_iznos_pred_l := 0;
   END IF;
   RETURN (uk_iznos_pred_l);
END;
PROCEDURE PROVJERI_SO_KOL_RESTORANA
 (SO_ID_P IN mrec_pres_so.so_id%TYPE
 ,BR_RESTORANA_P IN mrec_pres_so.br_restorana%TYPE
 )
 IS
--
   koliko_l NUMBER;
BEGIN
   SELECT kol_restorana INTO koliko_l FROM m_so WHERE id = so_id_p;
   IF br_restorana_p > koliko_l THEN
      -- Broj restorana mora biti manji ili jednak ukupnom broju restorana smjetajnog objekta.
      pra_rec_zaj.vrati_poruku (-20067);
   END IF;
END;
FUNCTION SLOBODNA_SJ
 (SO_ID_P IN m_sj.so_id%TYPE
 ,VSJ_ID_P IN m_sj.vsj_id%TYPE
 ,DAT_POC_P IN DATE
 ,DAT_ZAV_P IN DATE
 )
 RETURN NUMBER
 IS
--
  dat_poc_l DATE := TRUNC (dat_poc_p);
  dat_zav_l DATE := TRUNC (dat_zav_p);
  CURSOR sj_c IS
    SELECT id
      FROM m_sj
     WHERE so_id = so_id_p
       AND vsj_id = vsj_id_p
       AND dat_valjan <= dat_poc_l
       AND NVL (dat_ponisten, dat_zav_l) >= dat_zav_l
       AND id NOT IN (
           SELECT DISTINCT sj_id
             FROM i_statusisj
            WHERE datum >= dat_poc_l
              AND datum < dat_zav_l
              AND (   ozn_i = 3   -- izvan upotrebe
                   OR ozn_u = -1  -- vezana ugovorom o zakupu
                   OR ozn_z > 0   -- zauzeta
                   OR ozn_r > 0)  -- rezervirana
           )
     ORDER BY broj;
  sj_id_l m_sj.id%TYPE;
BEGIN
  OPEN sj_c;
  FETCH sj_c INTO sj_id_l;
  CLOSE sj_c;
  RETURN sj_id_l;
END;
FUNCTION IZN_PNAKNADE_PO
 (RAC_ID_P IN t_racuni.id%TYPE
 )
 RETURN tpka_rnkasa.izn_ppot%TYPE
 IS
-- Iznos povratne naknade na POS raunima (prethodno obraunato) zaraunatim na REC raunu

  iznos_l tpka_rnkasa.izn_pnaknade%TYPE;
BEGIN
  SELECT NVL (SUM (izn_pnaknade), 0)
    INTO iznos_l
    FROM tpka_rnkasa
   WHERE rac_id = rac_id_p;

  RETURN iznos_l;
END;
FUNCTION OZN_NAPOJNICE_PKARACFIS
 (RAC_ID_P IN t_racuni.id%TYPE
 )
 RETURN NUMBER
 IS
--
  ozn_napojnice_l NUMBER;
BEGIN
  SELECT MAX (NVl (ozn_napojnice, 0))
    INTO ozn_napojnice_l
    FROM lpka_rac_fis
   WHERE rac_id = rac_id_p
     AND sifra_greske IS NULL
     AND opis_greske IS NULL;

  RETURN ozn_napojnice_l;

END;
FUNCTION IZN_NAPOJNICE
 (RAC_ID_P IN t_racuni.id%TYPE
 ,OZN_NAPOJNICE_P IN NUMBER
 )
 RETURN NUMBER
 IS
-- vraa iznos u domaoj valuti POS ili REC napojnice za REC raun.
-- ozn_napojnice_p = 1 - POS, = 2 - REC napojnica
-- teoretski na raun moemo staviti negativan POS raun sa negativnom napojnicom i pozitivnu REC napojnicu
-- tako da je ukupni iznos napojnice = 0 ali taj raun bi ipak trebali smatrati s napojnicom
-- (ako imamo vie POS napojnica sa zbrojem = 0 onda smatramo da su to ponitavanja da je POS nap = 0)
-- znai raun ima napojnicu ako je izn_napojnice (rac_id_p, 1) <> 0 OR izn_napojnice (rac_id_p, 2) <> 0

  izn_napojnice_l NUMBER;
BEGIN
  IF rac_id_p IS NULL THEN
    RETURN NULL;
  END IF;

  IF ozn_napojnice_p = 1 THEN
    -- POS napojnica
    SELECT SUM (NVL (izn_napojnice, 0)) INTO izn_napojnice_l FROM tpka_rnkasa WHERE rac_id = rac_id_p;
  ELSIF ozn_napojnice_p = 2 THEN
    -- REC napojnica
    SELECT SUM (ROUND (NVL (izn_napojnice, 0) * izn_tecaja, 2)) INTO izn_napojnice_l FROM t_rac_nap WHERE rac_id = rac_id_p;
  END IF;

  RETURN NVL (izn_napojnice_l, 0);
END;
FUNCTION DAT_FISKALIZACIJE
 (RAC_ID_P IN t_racuni.id%TYPE
 ,OZN_NAPOJNICE_P IN NUMBER
 )
 RETURN DATE
 IS
-- vraa datum (uspjene) fiskalizacije za REC raun ili napojnicu:
-- ozn_napojnice = NULL - za raun, = 1 za POS napojnicu, = 2 za REC napojnicu
-- POS napojnica je fiskalizirana ako postoji zapis u lpka_rac_fis sa ozn_napojnice 1 ili 2 bez greke
-- REC napojnica je fiskalizirana ako postoji zapis u lpka_rac_fis sa ozn_napojnice 2 bez greke

  dat_fiskalizacije_l DATE;
BEGIN

  IF rac_id_p IS NULL THEN
    RETURN NULL;
  END IF;

  IF ozn_napojnice_p IS NULL THEN
    -- Raun
    SELECT MAX (dat_obrade) INTO dat_fiskalizacije_l
      FROM lpka_rac_fis
     WHERE rac_id = rac_id_p
       AND ozn_napojnice IS NULL
       AND sifra_greske IS NULL
       AND opis_greske IS NULL;
  ELSIF ozn_napojnice_p = 1 AND pra_rec_s5.izn_napojnice (rac_id_p, 1) <> 0 THEN
    -- POS napojnica
    SELECT MAX (dat_obrade) INTO dat_fiskalizacije_l
      FROM lpka_rac_fis
     WHERE rac_id = rac_id_p
       AND ozn_napojnice IN (1, 2)
       AND sifra_greske IS NULL
       AND opis_greske IS NULL;
  ELSIF ozn_napojnice_p = 2 AND pra_rec_s5.izn_napojnice (rac_id_p, 2) <> 0 THEN
    -- REC napojnica
    SELECT MAX (dat_obrade) INTO dat_fiskalizacije_l
      FROM lpka_rac_fis
     WHERE rac_id = rac_id_p
       AND ozn_napojnice IN (2)
       AND sifra_greske IS NULL
       AND opis_greske IS NULL;
  END IF;

  RETURN dat_fiskalizacije_l;
END;
FUNCTION KD_OPIS
 (RAC_ID_P IN t_racuni.id%TYPE
 ,OZNAKA_P IN VARCHAR2
 )
 RETURN VARCHAR2
 IS
--
  opis_l VARCHAR2(4000);
  gost_id_l   NUMBER;
  pkaadr_id_l NUMBER;
  age_id_l    NUMBER;
  gmpkom_id_l NUMBER;
BEGIN
  -- oznaka iz v_pspp_racuni: RAC t_racuni, PKARAC tpka_racuni, OB nije obraeno
  IF oznaka_p = 'RAC' THEN
    SELECT gost_id, pkaadr_id, age_id
      INTO gost_id_l, pkaadr_id_l, age_id_l
      FROM t_racuni
     WHERE id = rac_id_p;
  ELSIF oznaka_p = 'PKARAC' THEN
    SELECT pkaadr_id, gmpkom_id
      INTO pkaadr_id_l, gmpkom_id_l
      FROM tpka_racuni
     WHERE id = rac_id_p;
  END IF;

  IF gost_id_l IS NOT NULL THEN
    SELECT gost.ime || ' ' || gost.prezime || '; ' ||
             kgost.naz_ulice || '; ' ||
             DECODE (kgost.pos_id, NULL, kgost.naz_mjesta, pos.broj || ' ' || pos.naziv) || '; ' ||
             zem.sifra_2a AS kd_opis
      INTO opis_l
      FROM t_gosti gost,
           t_kgostiju kgost,
           m_poste pos,
           s_zemlje zem
     WHERE gost.id = gost_id_l
       AND kgost.gost_id(+) = gost.id
       AND kgost.oznaka(+) = 'V'
       AND kgost.ozn_brisano(+) = 0
       AND pos.id(+) = kgost.pos_id
       AND zem.id(+) = kgost.zem_id;
  END IF;

  IF pkaadr_id_l IS NOT NULL THEN
    SELECT DECODE (pkaadr.naz_poduzeca, NULL, NULL, pkaadr.naz_poduzeca || DECODE (pkaadr.ime || pkaadr.prezime, NULL, NULL,  ' | ' )) ||
             DECODE (pkaadr.ime, NULL, NULL, pkaadr.ime || ' ') || pkaadr.prezime || '; ' ||
             pkaadr.naz_ulice || '; ' ||
             DECODE (pos.broj, NULL, pkaadr.naz_mjesta, pos.broj || ' ' || pos.naziv) || '; ' ||
             zem.sifra_2a
      INTO opis_l
      FROM mpka_adrese pkaadr,
           m_poste pos,
           s_zemlje zem
     WHERE pkaadr.id = pkaadr_id_l
       AND pos.id(+) = pkaadr.pos_id
       AND zem.id = pkaadr.zem_id;
  END IF;

  IF age_id_l IS NOT NULL THEN
    SELECT age.naziv || '; ' || age.naz_ulice || '; ' || pos.broj || ' ' || pos.naziv || '; ' || zem.sifra_2a
      INTO opis_l
      FROM m_agencije age,
           s_zemlje zem,
           m_poste pos
      WHERE age.id = age_id_l
        AND age.zem_id = zem.id
        AND age.pos_id = pos.id (+);
  END IF;

  IF gmpkom_id_l IS NOT NULL THEN
    SELECT gmpkom.naziv || '; ' || gmpkom.naz_ulice || '; ' || pos.broj || ' ' || pos.naziv || '; ' || zem.sifra_2a
      INTO opis_l
      FROM mgmp_komitenti gmpkom,
           s_zemlje zem,
           m_poste pos
      WHERE gmpkom.id = gmpkom_id_l -- IRN 4060
        AND gmpkom.zem_id = zem.id
        AND gmpkom.pos_id = pos.id (+);
  END IF;

  RETURN opis_l;
END;
FUNCTION IZN_NAPOJNICE_UK
 (RAC_ID_P IN t_racuni.id%TYPE
 ,OZN_VALUTE_P IN NUMBER
 )
 RETURN NUMBER
 IS
-- vraa ukupan iznos napojnice na REC raunu (POS i REC napojnicu) u domaoj ili valuti rauna
-- neovisno je li napojnica fiskalizirana ili ne
-- ozn_valute_p: 1 vraa iznos napojnice u domaoj valuti, 2 u valuti rauna
-- zbog POS napojnice treba provjeriti da se radi o GI raunu
-- ako se trai napojnica u valuti rauna treba je preraunati prema teaju iz rauna

  izn_napojnice_l t_rac_nap.izn_napojnice%TYPE;
  izn_napojnice_pos_l NUMBER;
  izn_napojnice_rec_l NUMBER;
  izn_tecaja_l t_racuni.izn_tecaja%TYPE;
  vapldok_oznaka_l s_vapldok.oznaka%TYPE;
BEGIN
  IF rac_id_p IS NULL THEN
    RETURN NULL;
  END IF;

  -- POS napojnica u domaoj valuti
  SELECT NVL (SUM (NVL (izn_napojnice, 0)), 0) INTO izn_napojnice_pos_l FROM tpka_rnkasa WHERE rac_id = rac_id_p;
  -- REC napojnica u domaoj valuti
  SELECT SUM (NVL (izn_napojnice, 0) * izn_tecaja) INTO izn_napojnice_rec_l FROM t_rac_nap WHERE rac_id = rac_id_p;

  IF izn_napojnice_pos_l <> 0 OR ozn_valute_p = 2 THEN
    SELECT rac.izn_tecaja, vapldok.oznaka
      INTO izn_tecaja_l, vapldok_oznaka_l
      FROM t_racuni rac, s_vapldok vapldok
     WHERE rac.id = rac_id_p
       AND rac.vapldok_id = vapldok.id;
    IF vapldok_oznaka_l = 'GI' THEN
      IF ozn_valute_p = 1 THEN
        izn_napojnice_l := ROUND (izn_napojnice_pos_l + izn_napojnice_rec_l, 8);
      ELSIF ozn_valute_p = 2 THEN -- u valuti rauna
        izn_napojnice_l := ROUND (izn_napojnice_pos_l / izn_tecaja_l + izn_napojnice_rec_l / izn_tecaja_l, 8);
      END IF;
    ELSE
      izn_napojnice_l := 0;
    END IF;
  ELSE    -- izn_napojnice_pos_l i ozn_valute_p = 1
    izn_napojnice_l := ROUND (izn_napojnice_rec_l, 8);
  END IF;

  RETURN izn_napojnice_l;
EXCEPTION
  WHEN NO_DATA_FOUND THEN
    RETURN NULL;
END;
FUNCTION BR_PRETPRIJAVLJENIH
 (REZVSJ_ID_P IN t_rez_gost.rezvsj_id%TYPE
 )
 RETURN NUMBER
 IS
-- IRN 3972
-- Broj pretprijavljenih osoba (rezervirano - ostvareno)
-- Poziva se iz modula rec8320 - Rezervirane vrste SJ

  br_pretprijavljenih_l NUMBER;
BEGIN
  SELECT COUNT (1) INTO br_pretprijavljenih_l
    FROM t_rez_gost
   WHERE rezvsj_id = rezvsj_id_p
     AND sc_korisnik IS NOT NULL
     AND id NOT IN (
         SELECT rezgost_id
           FROM t_gosti
          WHERE rezgost_id IS NOT NULL
            AND rezvsj_id = rezvsj_id_p);
  RETURN (br_pretprijavljenih_l);
END;
PROCEDURE PROVJERI_RECSOUSL
 (SO_ID_P IN mrec_so_usl.so_id%TYPE
 ,USL_ID_P IN mrec_so_usl.usl_id%TYPE
 )
 IS
-- IRN 4118
  br_redaka_l NUMBER;
  so_sifra_l  m_so.sifra%TYPE;
  usl_sifra_l s_usluge.sifra%TYPE;
BEGIN
  IF so_id_p IS NULL
    OR usl_id_p IS NULL
  THEN
    RETURN;
  END IF;

  SELECT COUNT (1) INTO br_redaka_l
    FROM mrec_so_usl
   WHERE so_id = so_id_p
     AND usl_id = usl_id_p;
  IF br_redaka_l = 0 THEN
    SELECT NVL (MIN (sifra), '(id ' || so_id_p || ')') INTO so_sifra_l FROM m_so WHERE id = so_id_p;
    SELECT NVL (MIN (sifra), '(id ' || usl_id_p || ')') INTO usl_sifra_l FROM s_usluge WHERE id = usl_id_p;
    -- Uslugu #0 nije doputeno koristiti u smjetajnom objektu #1.
    pra_rec_zaj.vrati_poruku (-20137, usl_sifra_l, so_sifra_l);
  END IF;
END;
/* KPD_SIFRA */
FUNCTION KPD_SIFRA
 (SO_ID_P M_SO.ID%TYPE
 ,USL_ID_P S_USLUGE.ID%TYPE
 )
 RETURN VARCHAR2
 IS
-- IRN 4122
  CURSOR kpd_c IS SELECT kpd.sifra 
                    FROM s_kpd kpd, 
                         mrec_so_usl recsousl, 
                         s_usluge usl
                   WHERE usl.id (+) = usl_id_p 
                     AND recsousl.usl_id (+) = usl_id_p
                     AND recsousl.so_id (+) = so_id_p
                     AND kpd.id =  NVL (recsousl.kpd_id, usl.kpd_id);
                      
  sifra_kpd_l S_KPD.sifra%TYPE;
BEGIN

  IF so_id_p IS NULL OR usl_id_p IS NULL THEN
    RETURN(NULL);
  END IF;
  
  OPEN kpd_c;
  FETCH kpd_c INTO sifra_kpd_l;
  CLOSE kpd_c;
  
  RETURN(sifra_kpd_l);
END;

END PRA_REC_S5;
/
SHOW ERROR

