-- C:\Radni\pra_rec_s4.pkb
--
-- Generated for Oracle 10g on Thu Oct 02  13:33:21 2025 by Server Generator 6.5.96.5.6
 

PROMPT Creating Package Body 'PRA_REC_S4'
CREATE OR REPLACE PACKAGE BODY PRA_REC_S4 IS

FUNCTION DAT_SJ_SLOBODNA_OD
 (SJ_ID_P IN I_STATUSISJ.SJ_ID%TYPE
 ,DATUM_P IN I_STATUSISJ.DATUM%TYPE
 ,OZN_SASTAVLJENA_P IN NUMBER := 0
 )
 RETURN DATE
 IS
/*
Datum do kojeg je SJ slobodna od datum_p unatrag.
Ako SJ za (datum_p - 1) nije slobodna vraa datum_p (i ako SJ na datum_p nije slobodna)
*/
  dat_slobodna_od_l DATE;
  dat_pomocna_l     DATE := TO_DATE ('01.01.1800', 'DD.MM.RRRR');
BEGIN
  IF ozn_sastavljena_p = 0 THEN
    SELECT MAX (datum) INTO dat_slobodna_od_l
      FROM i_statusisj
     WHERE (ozn_i = 3 OR ozn_r <> 0 OR ozn_z <> 0 OR ozn_u = -1)
       AND sj_id = sj_id_p
       AND datum < datum_p;

  ELSE
    FOR sj_c IN (
      SELECT sj_id_p id
        FROM dual
      UNION
      SELECT id
        FROM m_sj
       WHERE sjp_id = sj_id_p)
    LOOP

      SELECT MAX (datum)
        INTO dat_pomocna_l
        FROM i_statusisj
       WHERE (ozn_i = 3 OR ozn_r <> 0 OR ozn_z <> 0 OR ozn_u = -1)
         AND sj_id = sj_c.id
         AND datum < datum_p;

      IF dat_slobodna_od_l IS NULL
        OR dat_slobodna_od_l < dat_pomocna_l
      THEN
        dat_slobodna_od_l := dat_pomocna_l;
      END IF;

    END LOOP;

  END IF;

  IF dat_slobodna_od_l IS NOT NULL THEN
    dat_slobodna_od_l := dat_slobodna_od_l + 1;
  END IF;

  RETURN dat_slobodna_od_l;
END;
FUNCTION DAT_SJ_SLOBODNA_DO
 (SJ_ID_P IN I_STATUSISJ.SJ_ID%TYPE
 ,DATUM_P IN I_STATUSISJ.DATUM%TYPE
 ,OZN_SASTAVLJENA_P IN NUMBER := 0
 )
 RETURN DATE
 IS
/*
Datum do kojeg je SJ slobodna od datum_p unaprijed.
Ako SJ za datum_p nije slobodna trai se manji datum za koji je bila slobodna
*/
  dat_slobodna_do_l DATE;
  datum_l DATE;
BEGIN
  IF ozn_sastavljena_p = 0 THEN
    SELECT MIN (datum) INTO dat_slobodna_do_l
      FROM i_statusisj
     WHERE (ozn_i = 3 OR ozn_r <> 0 OR ozn_z <> 0 OR ozn_u = -1)
       AND sj_id = sj_id_p
       AND datum >= datum_p;

    IF dat_slobodna_do_l = datum_p THEN
      -- za datum_p je SJ zauzeta, provjerava se prethodni datum
      SELECT MIN (datum) INTO datum_l FROM i_statusisj
       WHERE (ozn_i = 3 OR ozn_r <> 0 OR ozn_z <> 0 OR ozn_u = -1)
         AND sj_id = sj_id_p
         AND datum = datum_p-1;
      IF datum_l IS NOT NULL THEN
        /*
        Za prethodni datum je SJ zauzeta, trai se zadnji datum kada je slobodna.
        LV iz rezervacija daje samo slobodne SJ do datuma_p pa datum_l hoe biti NULL
        i nastavak se nee izvoditi (i eventualno usporavati prikaz)
        */
        SELECT zmp_zaj.set_dates (datum_p - 365, datum_p) INTO datum_l FROM dual;
        SELECT MAX (kal.datum) INTO dat_slobodna_do_l
          FROM v_zmp_kalendar kal,
               (
               SELECT *
                 FROM i_statusisj
                WHERE sj_id = sj_id_p
                  AND datum BETWEEN datum_p - 365 AND datum_p
               ) stsj
         WHERE kal.datum = stsj.datum (+)
           AND NVL (ozn_i, 1) <> 3
           AND NVL (ozn_r, 0) = 0
           AND NVL (ozn_z, 0) = 0
           AND NVL (ozn_u, 0) = 0;
        dat_slobodna_do_l := dat_slobodna_do_l + 1;
      END IF;
    END IF;
  ELSE
    SELECT MIN(pra_rec_s4.dat_sj_slobodna_do(sj.id, datum_p))
      INTO dat_slobodna_do_l
      FROM (SELECT sj_id_p id
              FROM dual
            UNION
            SELECT id
              FROM m_sj
             WHERE sjp_id = sj_id_p) sj;
  END IF;
  RETURN dat_slobodna_do_l;
END;
FUNCTION SJ_BROJ
 (SJ_ID_P IN m_sj.id%TYPE
 )
 RETURN m_sj.broj%TYPE
 IS
CURSOR sj_c IS
    SELECT broj
      FROM m_sj
     WHERE id = sj_id_p;
  sj_broj_l m_sj.broj%TYPE;
BEGIN
  IF sj_id_p IS NULL THEN
    RETURN (NULL);
  END IF;
  OPEN sj_c;
  FETCH sj_c INTO sj_broj_l;
  CLOSE sj_c;
  RETURN (sj_broj_l);
END;
FUNCTION PROVIZIJA
 (RAC_ID_P IN T_RACUNI.ID%TYPE
 ,STOPA_PROVIZIJE_P IN t_ponude.stopa_provizije%TYPE
 ,OZN_U_VAL_RAC_P IN NUMBER
 ,OZN_BRUTO_P IN NUMBER
 ,VPISPZ_STOPA_P IN s_vpisporukaz.stopa%TYPE
 )
 RETURN NUMBER
 IS
/*
funkcija rauna iznos provizije za sve trokove na raunu koji imaju obr_provizije = -1
neovisno da li su trokovi vezani na ugovor/ponudu ili je ugovor/ponuda null
*/
  tro_izn_provizije_l NUMBER;
  rac_izn_provizije_l NUMBER := 0;
BEGIN

  IF stopa_provizije_p IS NULL THEN
    RETURN (0);
  END IF;
  -- IRN 2439 MK
  -- Provizija se rauna na usluge koje nisu ukljuene u drugu uslugu i ne umanjuje se za proviziju na ukljuenu uslugu
  -- Koristi se oznaka obr_provizije iz tro
  FOR tro_c IN (
    SELECT
      tro.iznos tro_iznos,
      tro.izn_odbitka tro_izn_odbitka,
      tro.izn_tecaja tro_izn_tecaja,
      rac.izn_tecaja rac_izn_tecaja,
      tro.obr_provizije tro_obr_provizije
    FROM
      t_troskovi tro,
      t_racuni rac
    WHERE
      rac.id = rac_id_p
      AND tro.rac_id = rac.id
      AND tro.usl_id1 IS NULL
      )
  LOOP
    IF ozn_u_val_rac_p = -1 THEN
      tro_izn_provizije_l := tro_c.tro_obr_provizije * (-1)
                          * (tro_c.tro_iznos * tro_c.tro_izn_tecaja / tro_c.rac_izn_tecaja - tro_c.tro_izn_odbitka)
                          * (stopa_provizije_p / 100);
    ELSE
      tro_izn_provizije_l := tro_c.tro_obr_provizije * (-1)
                          * (tro_c.tro_iznos * tro_c.tro_izn_tecaja - tro_c.tro_izn_odbitka * tro_c.rac_izn_tecaja)
                          * (stopa_provizije_p / 100);
    END IF;

    IF ozn_bruto_p = 0 THEN
      tro_izn_provizije_l := tro_izn_provizije_l * 100 / (100 + NVL (vpispz_stopa_p, 0));
    END IF;

    rac_izn_provizije_l := rac_izn_provizije_l + tro_izn_provizije_l;
  END LOOP;

  RETURN (ROUND (rac_izn_provizije_l, 2));
END;
FUNCTION STSJ_OZN_DOMACICE1
 (SJ_ID_P IN i_statusisj.sj_id%TYPE
 ,DATUM_P IN i_statusisj.datum%TYPE
 )
 RETURN i_statusisj.ozn_domacice1%TYPE
 IS
--
  CURSOR stsj_c IS
    SELECT ozn_domacice1
      FROM i_statusisj
     WHERE datum = TRUNC (datum_p)
       AND sj_id = sj_id_p;
  ozn_domacice1_l i_statusisj.ozn_domacice1%TYPE;
BEGIN
  OPEN stsj_c;
  FETCH stsj_c INTO ozn_domacice1_l;
  IF stsj_c%NOTFOUND THEN
    ozn_domacice1_l := 2; -- ista
  END IF;
  CLOSE stsj_c;

  RETURN (ozn_domacice1_l);
END;
FUNCTION REZ_USL_SIFRA
 (REZ_ID_P IN T_REZERVACIJE.ID%TYPE
 ,REZGOST_ID_P IN T_REZ_GOST.ID%TYPE := NULL
 )
 RETURN s_usluge.sifra%TYPE
 IS
-- Rezervirana usluga
  CURSOR rezusl_c IS
    SELECT usl.sifra
      FROM (
           SELECT rezusl.usl_id, NVL (rezusl.dat_poc, rez.dat_dolaska) dat_poc
             FROM t_rez_usl rezusl,
                  t_rezervacije rez
            WHERE rez.id = rez_id_p
              AND rezusl.rez_id = rez.id
           UNION ALL
           SELECT rezgusl.usl_id, NVL (rezgusl.dat_poc, rez.dat_dolaska) dat_poc
             FROM t_rez_gusl rezgusl,
                  t_rez_gost rezgost,
                  t_rez_vsj rezvsj,
                  t_rezervacije rez
            WHERE rez.id = rez_id_p
              AND rezvsj.rez_id = rez.id
              AND rezgost.rezvsj_id = rezvsj.id
              AND rezgusl.rezgost_id = rezgost.id
              AND (
                  (rezgost_id_p IS NULL)
                  OR
                  (rezgost_id_p IS NOT NULL AND rezgusl.rezgost_id = rezgost_id_p)
                  )
           ) rezusl,
           s_usluge usl
     WHERE rezusl.usl_id = usl.id
     ORDER BY rezusl.dat_poc, usl.ozn_osnovna, usl.ozn_abc, usl.sifra;
  usl_sifra_l s_usluge.sifra%TYPE;
BEGIN
  IF rez_id_p IS NULL THEN
    RETURN (NULL);
  END IF;
  OPEN rezusl_c;
  FETCH rezusl_c INTO usl_sifra_l;
  CLOSE rezusl_c;
  RETURN (usl_sifra_l);
END;
FUNCTION DOKUMENT
 (OZNAKA_P IN VARCHAR2
 ,PONSO_ID_P IN t_pon_so.id%TYPE
 ,REZ_ID_P IN t_rezervacije.id%TYPE
 )
 RETURN VARCHAR2
 IS
--
  dokument_l VARCHAR2(5); -- rbr je VARCHAR2(5)
BEGIN
  IF oznaka_p IS NULL THEN
    RETURN (NULL);
  END IF;
  IF ponso_id_p IS NULL
    AND rez_id_p IS NULL
  THEN
    RETURN (NULL);
  END IF;
  IF ponso_id_p IS NOT NULL THEN
    SELECT DECODE (oznaka_p,
             '1', pon.rbr,
             '2', pon.god_poslovna,
             '3', pon.oznaka)
      INTO dokument_l
      FROM t_pon_so ponso, t_pon_ojr ponojr, t_ponude pon
     WHERE ponso.id = ponso_id_p
       AND ponso.ponojr_id = ponojr.id
       AND ponojr.pon_id = pon.id;
    RETURN (dokument_l);
  END IF;
  IF rez_id_p IS NOT NULL THEN
    SELECT DECODE (oznaka_p,
             '1', rbr,
             '2', god_poslovna,
             '3', oznaka)
      INTO dokument_l
      FROM t_rezervacije
     WHERE id = rez_id_p;
    RETURN (dokument_l);
  END IF;
END;
FUNCTION USL_JE_PONUDENA
 (PONSO_ID_P IN T_PON_SOUSL.PONSO_ID%TYPE
 ,USL_ID_P IN T_PON_SOUSL.USL_ID%TYPE
 )
 RETURN NUMBER
 IS
--
  br_redaka_l NUMBER;
BEGIN
  IF ponso_id_p IS NULL OR usl_id_p IS NULL THEN
    RETURN (-1);
  END IF;

  -- provjeri u t_pon_sousl
  SELECT COUNT (1) INTO br_redaka_l
    FROM t_pon_sousl
   WHERE ponso_id = ponso_id_p
     AND usl_id = usl_id_p;

  IF br_redaka_l > 0 THEN
    RETURN (-1);
  END IF;

  -- provjeri u t_pon_vsjusl
  SELECT COUNT (1) INTO br_redaka_l
    FROM t_pon_vsjusl ponvsjusl,
         t_pon_vsj ponvsj
   WHERE ponvsjusl.ponvsj_id = ponvsj.id
     AND ponvsj.ponso_id = ponso_id_p
     AND ponvsjusl.usl_id = usl_id_p;

  IF br_redaka_l > 0 THEN
    RETURN (-1);
  ELSE
    RETURN (0);
  END IF;
END;
FUNCTION BR_DANA
 (OBR_PO_DANU_P IN t_troskovi.obr_po_danu%TYPE
 ,OBR_ZDANA_P IN t_troskovi.obr_zdana%TYPE
 ,DAT_POC_P IN t_troskovi.dat_poc%TYPE
 ,DAT_ZAV_P IN t_troskovi.dat_zav%TYPE
 )
 RETURN NUMBER
 IS
BEGIN
  IF obr_po_danu_p = -1 THEN
    RETURN (dat_zav_p - dat_poc_p - obr_zdana_p);
  ELSE
    RETURN (1);
  END IF;
END;
FUNCTION VSJC_JE_PONUDENA
 (PONSO_ID_P IN T_PON_VSJ.PONSO_ID%TYPE
 ,VSJC_ID_P IN T_PON_VSJ.VSJC_ID%TYPE
 )
 RETURN NUMBER
 IS
--
  br_redaka_l NUMBER;
BEGIN
  IF ponso_id_p IS NULL OR vsjc_id_p IS NULL THEN
    RETURN (-1);
  END IF;

  SELECT COUNT (1) INTO br_redaka_l
    FROM t_pon_vsj
   WHERE ponso_id = ponso_id_p
     AND vsjc_id = vsjc_id_p;

  IF br_redaka_l > 0 THEN
    RETURN (-1);
  ELSE
    RETURN (0);
  END IF;
END;
FUNCTION RECARA_SIFRA
 (RECARA_ID_P IN mrec_aranzmani.id%TYPE
 )
 RETURN mrec_aranzmani.sifra%TYPE
 IS
--
  recara_sifra_l mrec_aranzmani.sifra%TYPE;
BEGIN
  IF recara_id_p IS NULL THEN
    RETURN (NULL);
  END IF;

  SELECT sifra INTO recara_sifra_l
    FROM mrec_aranzmani
   WHERE id = recara_id_p;

  RETURN (recara_sifra_l);
END;
FUNCTION USL_OZN_ABC
 (USL_ID_P IN s_usluge.id%TYPE
 )
 RETURN s_usluge.ozn_abc%TYPE
 IS
--
  usl_ozn_abc_l s_usluge.ozn_abc%TYPE;
BEGIN
  IF usl_id_p IS NULL THEN
    RETURN (NULL);
  END IF;

  SELECT ozn_abc INTO usl_ozn_abc_l
    FROM s_usluge
   WHERE id = usl_id_p;

  RETURN (usl_ozn_abc_l);
END;
FUNCTION USL_SIFRA
 (USL_ID_P IN s_usluge.id%TYPE
 )
 RETURN s_usluge.sifra%TYPE
 IS
--
  usl_sifra_l s_usluge.sifra%TYPE;
BEGIN
  IF usl_id_p IS NULL THEN
    RETURN (NULL);
  END IF;

  SELECT sifra INTO usl_sifra_l
    FROM s_usluge
   WHERE id = usl_id_p;

  RETURN (usl_sifra_l);
END;
FUNCTION IZN_PRED_PO_REZ
 (PKARACP_ID_P IN tpka_racuni.id%TYPE
 ,POPIS_REZ_PRED_P IN VARCHAR2
 )
 RETURN NUMBER
 IS
--
  naredba_l  VARCHAR2(3000);
  izn_l      NUMBER;
BEGIN

  IF popis_rez_pred_p IS NULL THEN
    izn_l := 0;

  ELSE
    naredba_l := '  SELECT NVL (SUM (rezpred.izn_predujma), 0)       ' ||
                 '    FROM t_rez_pred rezpred                        ' ||
                 '   WHERE rezpred.id IN (' || popis_rez_pred_p || ')' ||
                 '     AND rezpred.pkaracp_id = :1                   ';

    EXECUTE IMMEDIATE naredba_l INTO izn_l USING pkaracp_id_p;
  END IF;

  RETURN izn_l;

END;
FUNCTION REZ_SAS_SIFRA
 (REZ_ID_P IN T_REZERVACIJE.ID%TYPE
 )
 RETURN s_sastojci.sifra%TYPE
 IS
-- Sastojak rezervirane usluge

  CURSOR rezusl_c IS
    SELECT rezusl.sas_id
      FROM (
           SELECT rezusl.sas_id, rezusl.usl_id, NVL (rezusl.dat_poc, rez.dat_dolaska) dat_poc
             FROM t_rez_usl rezusl,
                  t_rezervacije rez
            WHERE rez.id = rez_id_p
              AND rezusl.rez_id = rez.id
          UNION ALL
          SELECT rezgusl.sas_id, rezgusl.usl_id, NVL (rezgusl.dat_poc, rez.dat_dolaska) dat_poc
            FROM t_rez_gusl rezgusl, t_rez_gost rezgost, t_rez_vsj rezvsj,
                 t_rezervacije rez
           WHERE rez.id = rez_id_p
             AND rezvsj.rez_id = rez.id
             AND rezgost.rezvsj_id = rezvsj.id
             AND rezgusl.rezgost_id = rezgost.id
           ) rezusl,
           s_usluge usl
     WHERE rezusl.usl_id = usl.id
     ORDER BY rezusl.dat_poc, usl.ozn_osnovna, usl.ozn_abc, usl.sifra;
  sas_id_l s_sastojci.id%TYPE;

  CURSOR sas_c (sas_id_k s_sastojci.id%TYPE) IS
    SELECT sifra
      FROM s_sastojci
     WHERE id = sas_id_k;
  sas_sifra_l s_sastojci.sifra%TYPE;
BEGIN
  IF rez_id_p IS NULL THEN
    RETURN (NULL);
  END IF;
  -- Id sastojka rezervirane usluge
  OPEN rezusl_c;
  FETCH rezusl_c INTO sas_id_l;
  CLOSE rezusl_c;
  -- ifra sastojka
  OPEN sas_c (sas_id_l);
  FETCH sas_c INTO sas_sifra_l;
  CLOSE sas_c;
  RETURN (sas_sifra_l);
END;
FUNCTION REZ_PRED_KOL
 (REZ_ID_P IN T_REZERVACIJE.ID%TYPE
 )
 RETURN NUMBER
 IS
-- Koliina rezerviranih predujmova
  br_redaka_l NUMBER;
BEGIN
  IF rez_id_p IS NULL THEN
    RETURN (0);
  END IF;
  SELECT COUNT (1) INTO br_redaka_l
    FROM t_rez_pred rezpred,
         tpka_racuni pkaracp
   WHERE rezpred.rez_id = rez_id_p
     AND rezpred.pkaracp_id = pkaracp.id
     AND pkaracp.oznaka = 'V';
  RETURN (br_redaka_l);
END;
FUNCTION REZ_ISKORISTENA
 (REZ_ID_P IN T_REZERVACIJE.ID%TYPE
 )
 RETURN NUMBER
 IS
-- Rezervacija je iskoritena
  br_redaka_l NUMBER;
BEGIN
  IF rez_id_p IS NULL THEN
    RETURN (0);
  END IF;
  SELECT COUNT (1) INTO br_redaka_l
    FROM t_rez_vsj
   WHERE rez_id = rez_id_p
     AND (
         (kol_sj - NVL (kol_sjz, 0)) > 0
         OR
         (br_osoba - NVL (br_osobaz, 0)) > 0);
  IF br_redaka_l = 0 THEN
    -- Rezervacija je iskoritena
    RETURN (-1);
  ELSE
    -- Rezervacija nije iskoritena
    RETURN (0);
  END IF;
END;
FUNCTION REZ_ARA_SIFRA
 (REZ_ID_P IN T_REZERVACIJE.ID%TYPE
 )
 RETURN mrec_aranzmani.sifra%TYPE
 IS
-- ifra rezerviranog aranmana

  CURSOR rezusl_c IS
    SELECT rezusl.recara_sifra
      FROM (
           SELECT recara.sifra AS recara_sifra, rezusl.usl_id, NVL (rezusl.dat_poc, rez.dat_dolaska) dat_poc
             FROM t_rez_usl rezusl,
                  t_rezervacije rez,
                  mrec_aranzmani recara
            WHERE rez.id = rez_id_p
              AND rezusl.rez_id = rez.id
              AND rezusl.recara_id = recara.id (+)
           UNION ALL
           SELECT recara.sifra, rezgusl.usl_id, NVL (rezgusl.dat_poc, rez.dat_dolaska) dat_poc
             FROM t_rez_gusl rezgusl,
                  t_rez_gost rezgost,
                  t_rez_vsj rezvsj,
                  t_rezervacije rez,
                  mrec_aranzmani recara
            WHERE rez.id = rez_id_p
              AND rezvsj.rez_id = rez.id
              AND rezgost.rezvsj_id = rezvsj.id
              AND rezgusl.rezgost_id = rezgost.id
              AND rezgusl.recara_id = recara.id (+)
           ) rezusl,
           s_usluge usl
     WHERE rezusl.usl_id = usl.id
     ORDER BY rezusl.dat_poc, usl.ozn_osnovna, usl.ozn_abc, usl.sifra;
  recara_sifra_l mrec_aranzmani.sifra%TYPE;
BEGIN
  IF rez_id_p IS NULL THEN
    RETURN (NULL);
  END IF;
  OPEN rezusl_c;
  FETCH rezusl_c INTO recara_sifra_l;
  CLOSE rezusl_c;
  RETURN (recara_sifra_l);
END;
FUNCTION REZ_RBR_CVOR
 (CVOR_P IN SMET_CVOROVI.SIFRA%TYPE
 ,REZ_ID_P IN T_REZERVACIJE.ID%TYPE
 )
 RETURN VARCHAR2
 IS
--
  naredba_l VARCHAR2(300);
  centar_l VARCHAR2(50) := pra_zmp_zaj.zmppar_vrijednost ('ZMP', '0018');
  rbr_l VARCHAR2(20);
BEGIN
  IF pra_zmp_zaj.centar = -1 OR cvor_p IS NULL THEN
    naredba_l :=
      'SELECT rbr || '' '' || god_poslovna' ||
      '  FROM t_rezervacije' || cvor_p ||
      ' WHERE id = ' || rez_id_p;
  ELSE
    naredba_l := 'SELECT pra_rec_s4.rez_rbr_cvor@' || centar_l || '('''|| cvor_p ||''', ' || rez_id_p || ') FROM DUAL';
  END IF;

  EXECUTE IMMEDIATE naredba_l INTO rbr_l;
  RETURN rbr_l;
END;
FUNCTION POSTOJI_PON_SO
 (PONSO_ID_P IN T_PON_SO.ID%TYPE
 ,SO_ID_P IN M_SO.ID%TYPE
 )
 RETURN NUMBER
 IS
--
  naredba_l VARCHAR2(2000);
  at_centar_l VARCHAR2(21) := pra_zmp_s.at_centar;
  ima_l NUMBER;
BEGIN
  naredba_l :=
    'SELECT COUNT (1) FROM (' ||
    '  SELECT ponso.so_id ' ||
    '    FROM t_pon_so<CVOR> ponso ' ||
    '   WHERE ponso.ponojr_id IN ( ' ||
    '         SELECT ponojr.id ' ||
    '           FROM t_pon_ojr<CVOR> ponojr ' ||
    '          WHERE ponojr.pon_id IN (' ||
    '                SELECT pon.id ' ||
    '                  FROM t_ponude<CVOR> pon, ' ||
    '                       t_pon_ojr<CVOR> ponojr, ' ||
    '                       t_pon_so<CVOR> ponso ' ||
    '                 WHERE ponso.id = ' || ponso_id_p ||
    '                   AND ponojr.id = ponso.ponojr_id ' ||
    '                   AND pon.id = ponojr.pon_id)) ' ||
    '     AND ponso.so_id = ' || so_id_p ||
    '  UNION ' ||
    '  SELECT ponsoso.so_id ' ||
    '    FROM t_ponso_so<CVOR> ponsoso ' ||
    '   WHERE ponsoso.ponso_id IN (' ||
    '         SELECT ponso.so_id ' ||
    '           FROM t_pon_so<CVOR> ponso ' ||
    '          WHERE ponso.ponojr_id IN (' ||
    '                SELECT ponojr.id ' ||
    '                  FROM t_pon_ojr<CVOR> ponojr ' ||
    '                 WHERE ponojr.pon_id IN (' ||
    '                       SELECT pon.id ' ||
    '                         FROM t_ponude<CVOR> pon, ' ||
    '                              t_pon_ojr<CVOR> ponojr, ' ||
    '                              t_pon_so<CVOR> ponso ' ||
    '                        WHERE ponso.id = ' || ponso_id_p ||
    '                          AND ponojr.id = ponso.ponojr_id ' ||
    '                          AND pon.id = ponojr.pon_id)))' ||
    '    AND ponsoso.so_id = ' || so_id_p || ')';
  EXECUTE IMMEDIATE REPLACE (naredba_l, '<CVOR>', at_centar_l) INTO ima_l;

  IF ima_l = 0 THEN
    RETURN 0;
  ELSE
    RETURN -1;
  END IF;

END;
FUNCTION CJE_ID_PONUDENI
 (PONSO_ID_P IN T_PONSO_SO.ID%TYPE
 ,RECVPRO_ID_P IN MREC_VPROGRAMA.ID%TYPE
 )
 RETURN t_cjenici.id%TYPE
 IS
-- id ponuenog cjenika ovisno o vrsti programa

  CURSOR pon_c IS
    SELECT pon.cje_id
      FROM t_ponude pon,
           t_pon_ojr ponojr,
           t_pon_so ponso
     WHERE ponso.id = ponso_id_p
       AND ponojr.id = ponso.ponojr_id
       AND pon.id = ponojr.pon_id;

  CURSOR recponvpro_c IS
    SELECT cje_id
      FROM trec_pon_vpro
     WHERE ponso_id = ponso_id_p
       AND recvpro_id = recvpro_id_p;

  cje_id_l t_cjenici.id%TYPE;
  cje_id_pom_l t_cjenici.id%TYPE;
BEGIN
  OPEN pon_c;
  FETCH pon_c INTO cje_id_l;
  CLOSE pon_c;

  IF recvpro_id_p IS NOT NULL THEN
    OPEN recponvpro_c;
    FETCH recponvpro_c INTO cje_id_pom_l;
    CLOSE recponvpro_c;
    IF cje_id_pom_l IS NOT NULL THEN
      cje_id_l := cje_id_pom_l;
    END IF;
  END IF;

  RETURN (cje_id_l);
END;
FUNCTION METCVOR_SIFRA_SO
 (SJ_ID_P IN m_sj.id%TYPE
 )
 RETURN m_so.metcvor_sifra%TYPE
 IS
--
  metcvor_sifra_l m_so.metcvor_sifra%TYPE;
BEGIN
  IF sj_id_p IS NULL THEN
    RETURN (NULL);
  END IF;

  SELECT MIN (metcvor_sifra) INTO metcvor_sifra_l
    FROM m_sj sj, m_so so
   WHERE sj.id = sj_id_p
     AND sj.so_id = so.id;

 RETURN (metcvor_sifra_l);

END;
PROCEDURE PROVJERI_RECPOPRAZ_DAT_POC_ZAV
 (ZMPPOP_ID_P IN trec_pop_razd.zmppop_id%TYPE
 ,SO_ID_P IN trec_pop_razd.so_id%type
 ,VSJ_ID_P IN trec_pop_razd.vsj_id%TYPE
 ,USL_ID_P IN trec_pop_razd.usl_id%TYPE
 ,DAT_POC_P IN trec_pop_razd.dat_poc%TYPE
 ,DAT_ZAV_P IN trec_pop_razd.dat_zav%TYPE
 )
 IS
-- Razdoblja popusta ne mogu se preklapati, za provjeru u trigeru
  CURSOR recpoprazd_c IS
    SELECT dat_poc, dat_zav
      FROM trec_pop_razd
     WHERE zmppop_id = zmppop_id_p
       AND so_id = so_id_p
       AND NVL (vsj_id, -1) = NVL (vsj_id_p, -1)
       AND usl_id = usl_id_p;
  dat_poc_l trec_pop_razd.dat_poc%TYPE;
  dat_zav_l trec_pop_razd.dat_zav%TYPE;
BEGIN
  IF zmppop_id_p IS NULL
    OR so_id_p IS NULL
    OR usl_id_p IS NULL
    OR dat_poc_p IS NULL
    OR dat_zav_p IS NULL
  THEN
    RETURN;
  END IF;

  OPEN recpoprazd_c;
  LOOP
    FETCH recpoprazd_c INTO dat_poc_l, dat_zav_l;
    EXIT WHEN recpoprazd_c%NOTFOUND;
    IF dat_poc_p <> dat_poc_l
      AND dat_poc_p <= dat_zav_l
      AND dat_zav_p >= dat_poc_l
    THEN
      CLOSE recpoprazd_c;
      -- Razdoblja popusta ne mogu se preklapati.
      pra_rec_zaj.vrati_poruku (-20574);
    END IF;
  END LOOP;
  CLOSE recpoprazd_c;
END;
PROCEDURE PROVJERI_ZMPPOPUSL
 (ZMPPOP_ID_P IN trec_pop_razd.zmppop_id%TYPE
 )
 IS
-- Procedura koja se poziva prilikom unosa u TREC_POP_RAZD kako bi provjerila da nema redaka u MZMP_POP_USL
  br_redaka_l NUMBER;
BEGIN
  SELECT COUNT (1) INTO br_redaka_l
    FROM mzmp_pop_usl
   WHERE zmppop_id = zmppop_id_p;

  IF br_redaka_l > 1 THEN
    -- Ne mogu se definirati popusti po razdobljima ako su ve upisani po uslugama.
    pra_rec_zaj.vrati_poruku (-20575);
  END IF;
END;
FUNCTION STOPA_ZMPPOP
 (ZMPPOP_ID_P IN mzmp_popusti.id%TYPE
 ,SO_ID_P IN m_so.id%TYPE
 ,VSJ_ID_P IN s_vsj.id%TYPE
 ,USL_ID_P IN s_vsj.id%TYPE
 ,DAT_POC_P IN trec_pop_razd.dat_poc%TYPE
 ,DAT_ZAV_P IN trec_pop_razd.dat_zav%TYPE
 ,BR_DANA_BORAVKA_P IN NUMBER
 )
 RETURN NUMBER
 IS
-- funkcija vraa stopu popusta iz mzmp_pop_usl (mzmp_popusti) ili iz trec_pop_razd

  stopa_zmppop_l NUMBER;

  CURSOR zmppopusl_c IS
    SELECT NVL (zmppopusl.stopa, zmppop.stopa)
      FROM mzmp_popusti zmppop, mzmp_pop_usl zmppopusl
     WHERE zmppop.id = zmppop_id_p
       AND zmppop.id = zmppopusl.zmppop_id AND zmppopusl.usl_id = usl_id_p
       AND NVL (zmppop.min_boravak, 0) <= br_dana_boravka_p;

  CURSOR recpoprazd_c IS
    SELECT recpoprazd.stopa
      FROM trec_pop_razd recpoprazd, mzmp_popusti zmppop, s_usluge usl
     WHERE recpoprazd.zmppop_id = zmppop_id_p
       AND recpoprazd.zmppop_id = zmppop.id
       AND recpoprazd.usl_id = usl_id_p
       AND recpoprazd.usl_id = usl.id
       AND recpoprazd.so_id = so_id_p
       AND NVL (recpoprazd.vsj_id, 0) = DECODE (usl.ozn_cje_vsj, -1, vsj_id_p, 0, 0)
       AND recpoprazd.dat_poc <= dat_poc_p
       AND recpoprazd.dat_zav >= dat_zav_p - DECODE (usl.obr_zdana, 0, 1, 0)
       AND NVL (zmppop.min_boravak, 0) <= br_dana_boravka_p;
BEGIN

  OPEN zmppopusl_c;
  FETCH zmppopusl_c INTO stopa_zmppop_l;
  IF zmppopusl_c%NOTFOUND THEN
    OPEN recpoprazd_c;
    FETCH recpoprazd_c INTO stopa_zmppop_l;
    CLOSE recpoprazd_c;
  END IF;
  CLOSE zmppopusl_c;

  RETURN stopa_zmppop_l;
END;
FUNCTION RACNAP_ID_MAX
 (RAC_ID_P IN T_RACUNI.ID%TYPE
 )
 RETURN NUMBER
 IS
--
  max_iznos_l NUMBER;
  CURSOR racnap_c (izn_k IN NUMBER) IS
    SELECT id
      FROM t_rac_nap
     WHERE ABS (izn_placanja * izn_tecaja) = izn_k
       AND rac_id = rac_id_p;
  retval_l t_rac_nap.id%TYPE;
BEGIN
  SELECT MAX (ABS (izn_placanja * izn_tecaja))
    INTO max_iznos_l
    FROM t_rac_nap
   WHERE rac_id = rac_id_p;

  IF max_iznos_l IS NOT NULL THEN
    OPEN racnap_c (max_iznos_l);
    FETCH racnap_c INTO retval_l;
    CLOSE racnap_c;
  END IF;
  RETURN retval_l;
END;
FUNCTION RAC_UPUTNICE
 (RAC_ID_P IN T_RACUNI.ID%TYPE
 )
 RETURN VARCHAR2
 IS
--
  br_uputnice_l VARCHAR2(4000);
BEGIN
   FOR uputnice_c IN (
     SELECT DISTINCT br_uputnice
       FROM t_troskovi
      WHERE br_uputnice IS NOT NULL
        AND rac_id = rac_id_p)
  LOOP
    br_uputnice_l := br_uputnice_l || uputnice_c.br_uputnice || '; ';
  END LOOP;
  RETURN (br_uputnice_l);
END;
FUNCTION RECREZNS_IZNOS
 (DAT_POC_P IN trec_rez_noshow.dat_poc%type
 ,DAT_ZAV_P IN trec_rez_noshow.dat_zav%type
 ,KOL_SJ_P IN trec_rez_noshow.kol_sjP%type
 ,BR_OSOBA_P IN trec_rez_noshow.br_osobaP%type
 ,CIJENA_USLUGE_P IN trec_rez_noshow.cijena_usluge%type
 ,STOPA_PLACANJA_P IN trec_rez_noshow.stopa_placanja%type
 ,OBR_ZDANA_P IN trec_rez_noshow.obr_zdana%type
 ,OZN_CIJENASJ_P IN trec_rez_noshow.ozn_cijenaSJ%type
 ,OBR_PO_DANU_P IN trec_rez_noshow.obr_po_danu%type
 )
 RETURN NUMBER
 IS
-- iznos usluge za noshow izraunat prema zadanim parametrima

  iznos_l NUMBER := 0;
  kolicina_l NUMBER;
  br_dana_l NUMBER;
BEGIN
  IF obr_po_danu_p = 0 THEN
    br_dana_l := 1;
  ELSE
    br_dana_l := dat_zav_p - dat_poc_p - obr_zdana_p;
  END IF;
  IF ozn_cijenaSJ_p = 0 THEN
    kolicina_l := br_osoba_p;
  ELSE
    kolicina_l := kol_sj_p;
  END IF;

  iznos_l := ROUND (cijena_usluge_p * kolicina_l * br_dana_l * stopa_placanja_p / 100, 2);

  RETURN iznos_l;
END;
PROCEDURE PROVJERI_RECREZNS_OBAVEZNO
 (USL_ID_P IN trec_rez_noshow.usl_id%type
 ,DAT_POC_P IN trec_rez_noshow.dat_poc%type
 ,DAT_ZAV_P IN trec_rez_noshow.dat_zav%type
 ,KOL_SJP_P IN trec_rez_noshow.kol_sjP%type
 ,BR_OSOBAP_P IN trec_rez_noshow.br_osobaP%type
 ,CIJENA_USLUGE_P IN trec_rez_noshow.cijena_usluge%type
 ,STOPA_PLACANJA_P IN trec_rez_noshow.stopa_placanja%type
 ,OBR_ZDANA_P IN trec_rez_noshow.obr_zdana%type
 ,OZN_CIJENASJ_P IN trec_rez_noshow.ozn_cijenaSJ%type
 ,OBR_PO_DANU_P IN trec_rez_noshow.obr_po_danu%type
 )
 IS
/*
Podaci koliina i broj osoba za naplatu, usluga, razdoblje, cijena, stopa plaanja
(i oznake potrebne za izraun iznosa) moraju biti svi upisani ili svi prazni.
*/
  nebitno_l NUMBER;
BEGIN
  SELECT
    DECODE (usl_id_p, NULL, 0, 1) +
    DECODE (kol_sjp_p, NULL, 0, 1) +
    DECODE (br_osobap_p, NULL, 0, 1) +
    DECODE (dat_poc_p, NULL, 0, 1) +
    DECODE (dat_zav_p, NULL, 0, 1) +
    DECODE (cijena_usluge_p, NULL, 0, 1) +
    DECODE (stopa_placanja_p, NULL, 0, 1) +
    DECODE (obr_zdana_p, NULL, 0, 1) +
    DECODE (ozn_cijenaSJ_p, NULL, 0, 1) +
    DECODE (obr_po_danu_p, NULL, 0, 1)
  INTO nebitno_l
  FROM dual;

  IF nebitno_l NOT IN (0, 10) THEN
    -- Koliina i broj osoba za naplatu, usluga, razdoblje, cijena, stopa plaanja
    -- (i oznake potrebne za izraun iznosa) moraju biti svi upisani ili svi prazni.
    pra_rec_zaj.vrati_poruku (-20584);
  END IF;
END;
FUNCTION RECARAUSL_OZN_SUM
 (RECARA_ID_P IN mrec_ara_usl.recara_id%TYPE
 ,USL_ID_P IN mrec_ara_usl.usl_id%TYPE
 )
 RETURN mrec_ara_usl.ozn_sum%TYPE
 IS
/*
IRN 2071
funkcija ne provjerava postoji li aranman
za usluge koje ne pripadaju aranmanu vraa -1
*/
  ozn_sum_l mrec_ara_usl.ozn_sum%TYPE;
BEGIN
  IF recara_id_p IS NULL OR usl_id_p IS NULL THEN
    RETURN 0;
  END IF;

  SELECT NVL (MIN (ozn_sum), -1)
    INTO ozn_sum_l
    FROM mrec_ara_usl
   WHERE recara_id = recara_id_p
     AND usl_id = usl_id_p;

  RETURN ozn_sum_l;

END;
FUNCTION RECARA_OZN_RNK
 (RECARA_ID_P IN mrec_aranzmani.id%TYPE
 )
 RETURN mrec_aranzmani.ozn_rnk%TYPE
 IS
-- IRN 2071
  ozn_rnk_l mrec_aranzmani.ozn_rnk%TYPE;
BEGIN
  IF recara_id_p IS NULL THEN
    RETURN 0;
  END IF;

  SELECT NVL (MIN (ozn_rnk), 0)
    INTO ozn_rnk_l
    FROM mrec_aranzmani
   WHERE id = recara_id_p;

  RETURN ozn_rnk_l;

END;
FUNCTION IZN_ISK_REZ_PREDUJMA
 (PKARACP_ID_P IN TPKA_RACUNI.ID%TYPE
 )
 RETURN NUMBER
 IS
-- iznos iskoritenog rezerviranog predujma
-- iznos iskoritenog predujma koji se javlja u raunima
-- na kojima su naplaeni trokovi gostiju koji su doli po rezervacijama vezanim na taj predujam

  iznos_l t_rac_pred.iznos%TYPE;
BEGIN
  IF pkaracp_id_p IS NULL THEN
    RETURN (NULL);
  END IF;
  SELECT NVL (SUM (racpred.iznos), 0) INTO iznos_l
    FROM t_racuni rac,
         t_rac_pred racpred
   WHERE rac.id = racpred.rac_id
     AND rac.oznaka = 'V'
     AND racpred.pkaracp_id = pkaracp_id_p
     AND rac.id IN (
         SELECT tro.rac_id
           FROM t_troskovi tro,
                t_gosti gost,
                t_rez_vsj rezvsj,
                t_rezervacije rez,
                t_rez_pred rezpred
          WHERE tro.gost_id = gost.id
            AND gost.rezvsj_id = rezvsj.id
            AND rezvsj.rez_id = rez.id
            AND rez.oznaka = 'V'
            AND rez.id = rezpred.rez_id
            AND rezpred.pkaracp_id = pkaracp_id_p);

  RETURN (iznos_l);

END;
FUNCTION STOPA_POP_DATUM
 (ZMPPOP_ID_P IN TREC_POP_RAZD.ZMPPOP_ID%TYPE
 ,SO_ID_P IN TREC_POP_RAZD.SO_ID%TYPE
 ,VSJ_ID_P IN TREC_POP_RAZD.VSJ_ID%TYPE
 ,USL_ID_P IN TREC_POP_RAZD.USL_ID%TYPE
 ,DATUM_P IN TREC_POP_RAZD.DAT_POC%TYPE
 )
 RETURN NUMBER
 IS
--
  CURSOR stopa_c IS
    SELECT stopa
      FROM trec_pop_razd
     WHERE zmppop_id = zmppop_id_p
       AND so_id = so_id_p
       AND usl_id = usl_id_p
       AND NVL (vsj_id, 0) = NVL (vsj_id_p, 0)
       AND dat_poc <= datum_p
       AND datum_p <= dat_zav;
  stopa_l trec_pop_razd.stopa%TYPE;
BEGIN
  OPEN stopa_c;
  FETCH stopa_c INTO stopa_l;
  CLOSE stopa_c;
  RETURN stopa_l;
END;
FUNCTION ZAK_USL_PRVA
 (ZAK_ID_P IN NUMBER
 )
 RETURN VARCHAR2
 IS
--
  CURSOR usl_c (zak_id_p NUMBER) IS
    SELECT s_usluge.sifra
      FROM t_zakup,
           trec_zak_usl,
           s_usluge
     WHERE t_zakup.id = trec_zak_usl.zak_id (+)
       AND trec_zak_usl.usl_id = s_usluge.id (+)
       AND t_zakup.id = zak_id_p
     ORDER BY s_usluge.ozn_osnovna, s_usluge.ozn_abc, trec_zak_usl.unos_dat;
   usl_id_l s_usluge.id%TYPE;
   usl_sifra_l s_usluge.sifra%TYPE;
   usl_sifra2_l s_usluge.sifra%TYPE;
   ima_l NUMBER;
BEGIN

  SELECT s_usluge.id, s_usluge.sifra
    INTO usl_id_l, usl_sifra_l
    FROM t_zakup,
         s_vzakupa,
         s_usluge
   WHERE t_zakup.vzak_id = s_vzakupa.id
     AND s_vzakupa.usl_id = s_usluge.id
     AND t_zakup.id = zak_id_p;

  SELECT COUNT (1) INTO ima_l
    FROM t_zakup,
         trec_zak_usl,
         s_usluge
   WHERE t_zakup.id = trec_zak_usl.zak_id (+)
     AND trec_zak_usl.usl_id = s_usluge.id (+)
     AND t_zakup.id = zak_id_p
     AND s_usluge.id = usl_id_l;

  IF ima_l = 1 THEN
    RETURN (usl_sifra_l);
  ELSE
    OPEN usl_c (zak_id_p);
    FETCH usl_c INTO usl_sifra2_l;
    CLOSE usl_c;
    IF usl_sifra2_l IS NOT NULL THEN
      RETURN (usl_sifra2_l);
    ELSE
      RETURN (usl_sifra_l);
    END IF;
  END IF;
END;
FUNCTION BR_RACUNA_FSUS
 (OJ_SIFRA_P IN m_oj.sifra%TYPE
 ,VDOK_SIFRA2N_P IN t_racuni.vdok_sifra2n%TYPE
 ,RBR_P IN t_racuni.rbr%TYPE
 ,DATUM_P IN t_racuni.datum%TYPE
 )
 RETURN VARCHAR2
 IS
-- broj rauna po notaciji fiskalnog sustava
  br_racuna_l VARCHAR2(30);
BEGIN
  br_racuna_l := pra_pka_s.br_racuna_fsus (oj_sifra_p, vdok_sifra2n_p, rbr_p, datum_p);
  RETURN br_racuna_l;
END;
FUNCTION OZN_ZA_PRIJAVU_EV
 (DAT_DOLASKA_P IN date
 ,VPLABP_ID_P IN s_vplabp_tz.id%TYPE
 )
 RETURN NUMBER
 IS
-- vraa -1 ako je dat_dolaska_p >= poetnom datumu za slanje u eVisitor i vplaBP.sifra <> 9

  vplabp_id9_l s_vplabp_tz.id%TYPE;
  vrijednost_parametra_l szmp_parametri.vrijednost%TYPE;
  ozn_za_eVisitor_l NUMBER := 0;
BEGIN

  SELECT MIN (id) INTO vplabp_id9_l FROM s_vplabp_tz WHERE sifra = '9';

  BEGIN
    IF vplabp_id_p <> NVL (vplabp_id9_l, 0)
      AND dat_dolaska_p >= TO_DATE (pra_rec_zaj.vrijednost_parametra ('1179'), 'DD.MM.RRRR')
    THEN
      ozn_za_eVisitor_l := -1;
    END IF;
  EXCEPTION
    WHEN OTHERS THEN
      -- ako nije upisan datum nije za prijavu u eVisitor
      NULL;
  END;

  RETURN (ozn_za_eVisitor_l);
END;
FUNCTION RN_JE_FIS_NAKNADNO
 (RAC_ID_P IN T_RACUNI.ID%TYPE
 ,PKARAC_ID_P IN TPKA_RACUNI.ID%TYPE
 ,JIR_P IN T_RACUNI.JIR%TYPE
 )
 RETURN NUMBER
 IS
/*
Raun je naknadno fiskaliziran ako ima jir i postoji vie od jedan redak
u logu od fiskalizacije za taj raun
Funkcija vraa -1 ako je raun naknadno fiskaliziran inae 0
*/
  br_redaka_l NUMBER;
BEGIN
  IF (rac_id_p IS NULL AND pkarac_id_p IS NULL)
    OR (rac_id_p IS NOT NULL AND pkarac_id_p IS NOT NULL)
    OR jir_p IS NULL
  THEN
    RETURN (0);
  END IF;

  SELECT COUNT (1) INTO br_redaka_l
    FROM lpka_rac_fis
   WHERE (rac_id = rac_id_p AND ozn_napojnice IS NULL)
      OR pkarac_id = pkarac_id_p;
  IF br_redaka_l > 1 THEN
    RETURN (-1);
  ELSE
    RETURN (0);
  END IF;
END;

END PRA_REC_S4;
/
SHOW ERROR

