PROMPT Creating Package Body 'PRA_REC_KC_IUD'
CREATE OR REPLACE PACKAGE BODY PRA_REC_KC_IUD IS

PROCEDURE KOPIRAJ_KCJED
 (SO_ID_P IN M_SO.ID%TYPE
 ,PREDBROJ_P IN VARCHAR2
 ,KCSUS_ID_P IN MKC_SUSTAVI.ID%TYPE
 ,OZN_PREPISI_BROJ_SJ_P IN NUMBER
 )
 IS
-- Kopiraj SJ odabranog SO u jedinice odabranog Key Card sustava
  br_redaka_l NUMBER;
  recstu_naziv_l srec_stupci.naziv%TYPE;
  kcjed_sifra_l mkc_jedinice.sifra%TYPE;
BEGIN
  IF so_id_p IS NULL
    OR kcsus_id_p IS NULL
  THEN
    RETURN;
  END IF;

  recstu_naziv_l := pra_rec_kc.recstu_naziv (NULL, kcsus_id_p, 'SIFRA', 'MKC_JEDINICE'); -- 891

  -- IRN 2762; uskladi ifre postojeih jedinica s brojevima SJ
  IF ozn_prepisi_broj_sj_p = -1 THEN
    FOR sj_c IN (SELECT id, broj FROM m_sj WHERE so_id = so_id_p)
    LOOP
      UPDATE mkc_jedinice
         SET sifra = sj_c.broj
       WHERE kcsus_id = kcsus_id_p
         AND sj_id = sj_c.id
         AND sifra <> sj_c.broj;
    END LOOP;
  END IF;

  FOR sj_c IN (
    SELECT id,
           broj, -- IRN 2762
           -- predbroj_p || TO_NUMBER (broj) AS kcjed_sifra -- 891
           DECODE (predbroj_p, NULL, LTRIM (broj, '0'), predbroj_p || broj) AS kcjed_sifra -- 891
      FROM m_sj
     WHERE so_id = so_id_p
       AND TRUNC (SYSDATE) BETWEEN dat_valjan AND NVL (dat_ponisten, TO_DATE ('31.12.9999', 'DD.MM.RRRR')) -- 752
     ORDER BY broj)
  LOOP
    IF ozn_prepisi_broj_sj_p = -1 THEN -- IRN 2762
      kcjed_sifra_l := sj_c.broj;
    ELSE
      -- 891
      kcjed_sifra_l := sj_c.kcjed_sifra;
      IF recstu_naziv_l IS NOT NULL THEN
        pra_rec_zaj.oblikuj_podatak (recstu_naziv_l, 'MKC_JEDINICE', kcjed_sifra_l);
      END IF;
      -- kraj 891
    END IF;
    SELECT COUNT (ROWID) INTO br_redaka_l
      FROM mkc_jedinice
     WHERE kcsus_id = kcsus_id_p
       AND (sj_id = sj_c.id OR sifra = kcjed_sifra_l); -- IRN 1700
    IF br_redaka_l = 0 THEN
      INSERT INTO mkc_jedinice (
          kcsus_id,
          sj_id,
          sifra)
        VALUES (
          kcsus_id_p,
          sj_c.id,
          kcjed_sifra_l);
    END IF;
  END LOOP;

  COMMIT;

END;
PROCEDURE OBRADI_KCODG
 (REC_KCODG_P IN TKC_ODGOVORI%ROWTYPE
 )
 IS
--
  ozn_tc_l skc_vs_servisi.ozn_tc%TYPE;
  tcozah_rec_l ttco_zahtjevi%ROWTYPE;

  CURSOR kcvsser_c (
    ozn_statusa_k IN tkc_odgovori.ozn_statusa%TYPE,
    kcjed_id_k IN tkc_odgovori.kcjed_id%TYPE) -- IRN 1414
  IS
    SELECT ozn_domacice1, ozn_domacice2
      FROM skc_vs_servisi
     WHERE sifra = ozn_statusa_k
       AND kcvs_id = pra_rec_kc.kcvs_id (kcjed_id_k);

  recidom_rec_l trec_idomacice%ROWTYPE;
BEGIN

  -- 28.07.2004. G.J. brisala 63 Pripremljena kopija kartice
  IF pra_rec_kc.kcvpor_sifra (rec_kcodg_p.kcvpor_id) IN (61, 62, 64) THEN
    -- Pripremljena kartica (nova, jednokratna)

    -- IRN 1978; Poniti valjane kartice s brojem rec_kcodg_p.kckar_broj 
    UPDATE tkc_kartice
       SET oznaka           = 'P',
           izmjena_korisnik = rec_kcodg_p.izmjena_korisnik
     WHERE oznaka = 'V'
       AND broj = rec_kcodg_p.kckar_broj;

    -- Upii novu karticu
    INSERT INTO tkc_kartice (
        id,
        kcjed_id,
        gost_id, -- 06.06.2008. G.J. IRN 609
        broj,
        oznaka,
        dat_poc,
        dat_zav,
        ime,
        prezime,
        ozn_prisutnosti, -- 06.06.2008. G.J. IRN 609
        pin,
        unos_korisnik, unos_dat, izmjena_korisnik, izmjena_dat)
      VALUES (
        rec_kcodg_p.kckar_id,
        rec_kcodg_p.kcjed_id,
        rec_kcodg_p.gost_id, -- 06.06.2008. G.J. IRN 609
        rec_kcodg_p.kckar_broj,
        'V',
        rec_kcodg_p.dat_poc,
        rec_kcodg_p.dat_zav,
        rec_kcodg_p.ime,
        rec_kcodg_p.prezime,
        'P', -- 06.06.2008. G.J. IRN 609
        rec_kcodg_p.pin,
        rec_kcodg_p.unos_korisnik, rec_kcodg_p.unos_dat, rec_kcodg_p.izmjena_korisnik, NULL);
  END IF;

  IF pra_rec_kc.kcvpor_sifra (rec_kcodg_p.kcvpor_id) IN (69) THEN
    -- Ponitena kartica
    UPDATE tkc_kartice
       SET oznaka           = 'P',
           izmjena_korisnik = rec_kcodg_p.izmjena_korisnik
     WHERE id = rec_kcodg_p.kckar_id;
  END IF;

  IF pra_rec_kc.kcvpor_sifra (rec_kcodg_p.kcvpor_id) IN (71, 72, 77) THEN
    -- Prijavljen korisnik kartice, Promijenjeni podaci o korisniku kartice
    -- 05.06.2007. G.J. Promijenjeno razdoblje valjanosti kartice
    UPDATE tkc_kartice
       SET kcjed_id         = rec_kcodg_p.kcjed_id,         -- kod seljenja gostiju
           gost_id          = rec_kcodg_p.gost_id,
           age_id           = rec_kcodg_p.age_id,
           pkaadr_id        = rec_kcodg_p.pkaadr_id,
           dat_poc          = rec_kcodg_p.dat_poc,
           dat_zav          = rec_kcodg_p.dat_zav,
           ime              = rec_kcodg_p.ime,
           prezime          = rec_kcodg_p.prezime,
           ozn_prisutnosti  = 'P',
           pin              = rec_kcodg_p.pin,
           izmjena_korisnik = rec_kcodg_p.izmjena_korisnik
     WHERE id = rec_kcodg_p.kckar_id;
  END IF;


  -- 01.06.2007. G.J.
  IF pra_rec_kc.kcvpor_sifra (rec_kcodg_p.kcvpor_id) IN (76) THEN
    -- Prijavljen korisnik kartice (interno)
    UPDATE tkc_kartice
       SET gost_id          = rec_kcodg_p.gost_id,
           age_id           = rec_kcodg_p.age_id,
           pkaadr_id        = rec_kcodg_p.pkaadr_id,
           ime              = rec_kcodg_p.ime,
           prezime          = rec_kcodg_p.prezime,
           ozn_prisutnosti  = 'P',
           izmjena_korisnik = rec_kcodg_p.izmjena_korisnik
     WHERE id = rec_kcodg_p.kckar_id;
  END IF;


  IF pra_rec_kc.kcvpor_sifra (rec_kcodg_p.kcvpor_id) IN (73) THEN
    -- Odjavljen korisnik kartice
    UPDATE tkc_kartice
       SET ozn_prisutnosti  = 'O',
           izmjena_korisnik = rec_kcodg_p.izmjena_korisnik
     WHERE id = rec_kcodg_p.kckar_id;
  END IF;


  IF pra_rec_kc.kcvpor_sifra (rec_kcodg_p.kcvpor_id) IN (75) THEN -- Poruke vrste 75 "Promijenjen status SJ"


    IF pra_rec_kc.kcsus_oznaka2 (rec_kcodg_p.kcjed_id) IN (-1) THEN
      -- Poruke vrste 75 "Promijenjen status SJ" mijenjaju klasu telefona

      SELECT MAX (ozn_tc) INTO ozn_tc_l
        FROM skc_vs_servisi
       WHERE sifra = rec_kcodg_p.ozn_statusa
         AND kcvs_id = pra_rec_kc.kcvs_id (rec_kcodg_p.kcjed_id);

      IF ozn_tc_l = 1 THEN -- dopusti vanjsku liniju
        tcozah_rec_l.tcokla_id := pra_rec_tco.tcokla_id (1); -- Telefon ima vanjsku liniju i ima produeno biranje
        tcozah_rec_l.datum := TRUNC (rec_kcodg_p.unos_dat);
        FOR tcotel_c IN (
          SELECT tcotel.id AS id
            FROM mtco_telefoni tcotel,
                 mkc_jedinice kcjed
           WHERE kcjed.sj_id = tcotel.sj_id
             AND kcjed.sj_id IS NOT NULL
             AND kcjed.id = rec_kcodg_p.kcjed_id)
        LOOP
          tcozah_rec_l.tcotel_id := tcotel_c.id;
          tcozah_rec_l.tcovpor_id := pra_rec_tco.tcovpor_id (63); -- Promijeni klasu telefona
          pra_rec_tco_iud.insert_tcozah (tcozah_rec_l);
          tcozah_rec_l.tcovpor_id := pra_rec_tco.tcovpor_id (66); -- Dopusti vanjsku liniju
          pra_rec_tco_iud.insert_tcozah (tcozah_rec_l);
        END LOOP;
      ELSIF ozn_tc_l = 2 THEN -- zabrani vanjsku liniju
        tcozah_rec_l.tcokla_id := pra_rec_tco.tcokla_id (4); -- Telefon nema vanjsku liniju i nema produeno biranje
        tcozah_rec_l.datum := TRUNC (rec_kcodg_p.unos_dat);
        FOR tcotel_c IN (
          SELECT tcotel.id AS id
            FROM mtco_telefoni tcotel,
                 mkc_jedinice kcjed
           WHERE kcjed.sj_id = tcotel.sj_id
             AND kcjed.sj_id IS NOT NULL
             AND kcjed.id = rec_kcodg_p.kcjed_id)
        LOOP
          tcozah_rec_l.tcotel_id := tcotel_c.id;
          tcozah_rec_l.tcovpor_id := pra_rec_tco.tcovpor_id (63); -- Promijeni klasu telefona
          pra_rec_tco_iud.insert_tcozah (tcozah_rec_l);
          tcozah_rec_l.tcovpor_id := pra_rec_tco.tcovpor_id (67); -- Zabrani vanjsku liniju
          pra_rec_tco_iud.insert_tcozah (tcozah_rec_l);
        END LOOP;
      END IF;
    END IF; -- KRAJ Poruke vrste 75 "Promijenjen status SJ" mijenjaju klasu telefona

    IF pra_rec_kc.kcsus_oznaka3 (rec_kcodg_p.kcjed_id) IN (-1) -- Poruke vrste 75 "Promijenjen status SJ" mijenjaju status SJ
      AND pra_rec_kc.sj_id (rec_kcodg_p.kcjed_id) IS NOT NULL
    THEN
      recidom_rec_l.sj_id := pra_rec_kc.sj_id (rec_kcodg_p.kcjed_id);
      recidom_rec_l.datum := TRUNC (rec_kcodg_p.unos_dat);
      OPEN kcvsser_c (rec_kcodg_p.ozn_statusa, rec_kcodg_p.kcjed_id);
      FETCH kcvsser_c INTO recidom_rec_l.ozn_domacice1, recidom_rec_l.ozn_domacice2;
      CLOSE kcvsser_c;
      IF recidom_rec_l.ozn_domacice1 IS NOT NULL THEN
        recidom_rec_l.napomena := 'KC';
        recidom_rec_l.ozn_unosa := 'A';
        pra_rec3.insert_recidom (recidom_rec_l);
      END IF;
    END IF; -- KRAJ Poruke vrste 75 "Promijenjen status SJ" mijenjaju status SJ

  END IF; -- KRAJ Poruke vrste 75 "Promijenjen status SJ"
END;
PROCEDURE AZURIRAJ_KCKARDOP
 (REC_KCODGDOP_P IN TKC_ODG_DOP%ROWTYPE
 )
 IS
CURSOR kcodg_c IS
    SELECT kcvpor_id, kckar_id
      FROM tkc_odgovori
     WHERE id = rec_kcodgdop_p.kcodg_id;
  kcodg_c_l kcodg_c%ROWTYPE;

  CURSOR kckardop_c IS
    SELECT id
      FROM tkc_kar_dop
     WHERE kckar_id = kcodg_c_l.kckar_id
       AND kcdop_id = rec_kcodgdop_p.kcdop_id
       FOR UPDATE;
  nebitno_l NUMBER;
BEGIN
  OPEN kcodg_c;
  FETCH kcodg_c INTO kcodg_c_l;
  IF kcodg_c%NOTFOUND THEN
    CLOSE kcodg_c;
    RETURN;
  END IF;
  CLOSE kcodg_c;

  -- 28.07.2004. G.J. brisala 63 Pripremljena kopija kartice
  IF pra_rec_kc.kcvpor_sifra (kcodg_c_l.kcvpor_id) IN (61, 62, 64, 71, 72) THEN
    -- Pripremljena kartica (61 nova, 62 jednokratna, 64 nova bez ponitavanja postojeih)
    -- Prijavljen korisnik kartice (71), Promijenjeni podaci o korisniku kartice (72)
    OPEN kckardop_c;
    FETCH kckardop_c INTO nebitno_l;
    IF kckardop_c%FOUND THEN
      UPDATE tkc_kar_dop
         SET oznaka = rec_kcodgdop_p.oznaka
       WHERE CURRENT OF kckardop_c;
    ELSE
      INSERT INTO tkc_kar_dop (
          id,
          kckar_id,
          kcdop_id,
          oznaka,
          unos_korisnik, unos_dat, izmjena_korisnik, izmjena_dat)
        VALUES (
          NULL,
          kcodg_c_l.kckar_id,
          rec_kcodgdop_p.kcdop_id,
          rec_kcodgdop_p.oznaka,
          rec_kcodgdop_p.unos_korisnik, rec_kcodgdop_p.unos_dat, rec_kcodgdop_p.izmjena_korisnik, NULL);
    END IF;
    CLOSE kckardop_c;
  END IF;
EXCEPTION
  WHEN OTHERS THEN
    IF kckardop_c%ISOPEN THEN
      CLOSE kckardop_c;
    END IF;
    RAISE;
END;
PROCEDURE CISTI_REC_KCZAH_L
 (REC_KCZAH_P IN OUT TKC_ZAHTJEVI%ROWTYPE
 )
 IS
-- isti sva polja varijable rec_kczah_p koja je tkc_zahtjevi%ROWTYPE
BEGIN
  rec_kczah_p.id := NULL;
  rec_kczah_p.kcvpor_id := NULL;
  rec_kczah_p.kcjed_id := NULL;
  rec_kczah_p.kcjed2_id := NULL;
  rec_kczah_p.kckar_id := NULL;
  rec_kczah_p.gost_id := NULL;
  rec_kczah_p.age_id := NULL;
  rec_kczah_p.pkaadr_id := NULL;
  rec_kczah_p.ozn_pisaca := NULL;
  rec_kczah_p.dat_poc := NULL;
  rec_kczah_p.dat_zav := NULL;
  rec_kczah_p.ime := NULL;
  rec_kczah_p.prezime := NULL;
  rec_kczah_p.pin := NULL;
  rec_kczah_p.oznaka := NULL; -- IRN 1836
  rec_kczah_p.unos_korisnik := NULL;
  rec_kczah_p.unos_dat := NULL;
  rec_kczah_p.izmjena_korisnik := NULL;
  rec_kczah_p.izmjena_dat := NULL;
END;
PROCEDURE INSERT_KCZAH
 (REC_KCZAH_P IN TKC_ZAHTJEVI%ROWTYPE
 )
 IS
BEGIN
  INSERT INTO tkc_zahtjevi (
      id,
      kcvpor_id,
      kcjed_id,
      kcjed2_id,
      kckar_id,
      gost_id,
      age_id,
      pkaadr_id,
      ozn_pisaca,
      dat_poc,
      dat_zav,
      ime,
      prezime,
      pin,
      oznaka, -- IRN 1836
      unos_korisnik,
      unos_dat,
      izmjena_korisnik,
      izmjena_dat)
    VALUES (
      rec_kczah_p.id,
      rec_kczah_p.kcvpor_id,
      rec_kczah_p.kcjed_id,
      rec_kczah_p.kcjed2_id,
      rec_kczah_p.kckar_id,
      rec_kczah_p.gost_id,
      rec_kczah_p.age_id,
      rec_kczah_p.pkaadr_id,
      rec_kczah_p.ozn_pisaca,
      rec_kczah_p.dat_poc,
      rec_kczah_p.dat_zav,
      rec_kczah_p.ime,
      rec_kczah_p.prezime,
      rec_kczah_p.pin,
      NVL (rec_kczah_p.oznaka, -1), -- IRN 1836
      rec_kczah_p.unos_korisnik,
      rec_kczah_p.unos_dat,
      rec_kczah_p.izmjena_korisnik,
      rec_kczah_p.izmjena_dat);
END;
PROCEDURE PUNI_KCZAH_REZVSJ
 (REZ_OZNAKA_P IN T_REZERVACIJE.OZNAKA%TYPE
 ,REZ_OZN_VSTORNA_P IN t_rezervacije.ozn_vstorna%type
 ,SJ_ID_P IN T_REZ_VSJ.SJ_ID%TYPE
 ,KCVPOR_SIFRA_P IN SKC_VPORUKA.SIFRA%TYPE
 ,DAT_DOLASKA_P IN T_REZERVACIJE.DAT_DOLASKA%TYPE
 )
 IS
/*
Punjenje zahtjeva iz rezerviranih vrsta SJ za poruke vrste
31 - Najavi dolazak i/ili 32 - Otkai najavu.
*/
  rec_kczah_l tkc_zahtjevi%ROWTYPE;
BEGIN
  IF NVL (rez_oznaka_p, 'P') IN ('P')
    OR rez_ozn_vstorna_p IS NOT NULL
    OR sj_id_p IS NULL
    OR kcvpor_sifra_p IS NULL
    OR dat_dolaska_p IS NULL
  THEN
    RETURN;
  END IF;

  IF dat_dolaska_p <= TRUNC (SYSDATE) THEN
    -- nije potrebno izraditi zahtjev za danas ili ranije razdoblje
    RETURN;
  END IF;

  FOR kcjed_c IN (SELECT id FROM mkc_jedinice WHERE sj_id IS NOT NULL AND sj_id = sj_id_p) -- IRN 1700
  LOOP
    IF pra_rec_kc.kcsus_oznaka6 (kcjed_c.id) = -1
      AND pra_rec_kc.kcvs_podrzava_kcvpor (kcjed_c.id, kcvpor_sifra_p) = -1
    THEN
      -- postoji komunikacijski modul s Key Card sustavom
      -- vrsta Key Card sustava kojoj pripada odabrana jedinica podrava odabranu vrstu poruke
      rec_kczah_l.kcjed_id := kcjed_c.id;
      rec_kczah_l.kcvpor_id := pra_rec_kc.kcvpor_id (kcvpor_sifra_p);
      rec_kczah_l.dat_poc := dat_dolaska_p;
      pra_rec_kc_iud.insert_kczah (rec_kczah_l);
    END IF;
  END LOOP;
END;
PROCEDURE PUNI_KCZAH_REZ
 (REZ_ID_P IN T_REZERVACIJE.ID%TYPE
 ,REZ_OZNAKA_P IN T_REZERVACIJE.OZNAKA%TYPE
 ,REZ_OZN_VSTORNA_P IN t_rezervacije.ozn_vstorna%type
 ,KCVPOR_SIFRA_P IN SKC_VPORUKA.SIFRA%TYPE
 ,REZ_DAT_DOLASKA_P IN T_REZERVACIJE.DAT_DOLASKA%TYPE
 )
 IS
/*
Punjenje zahtjeva iz rezervacija za poruke vrste
31 - Najavi dolazak ili 32 - Otkai najavu.
*/
BEGIN
  IF rez_id_p IS NULL
    OR rez_oznaka_p IS NULL
    OR kcvpor_sifra_p IS NULL
    OR rez_dat_dolaska_p IS NULL
  THEN
    RETURN;
  END IF;
  FOR rezvsj_c IN (
    SELECT sj_id,
           kol_sj,
           kol_sjz
      FROM t_rez_vsj
     WHERE sj_id IS NOT NULL
       AND rez_id = rez_id_p)
  LOOP
    IF (kcvpor_sifra_p IN (31) AND (rezvsj_c.kol_sj - NVL (rezvsj_c.kol_sjz, 0)) > 0)
      OR kcvpor_sifra_p IN (32)
    THEN
      pra_rec_kc_iud.puni_kczah_rezvsj (
        rez_oznaka_p, rez_ozn_vstorna_p, rezvsj_c.sj_id, kcvpor_sifra_p, rez_dat_dolaska_p);
    END IF;
  END LOOP;
END;
PROCEDURE PUNI_KCZAH_GOST21
 (GOST_ID_P IN T_GOSTI.ID%TYPE
 ,SJ_ID_P IN T_GOSTI.SJ_ID%TYPE
 ,DAT_DOLASKA_P IN T_GOSTI.DAT_DOLASKA%TYPE
 ,DAT_ODLASKA_P IN T_GOSTI.DAT_ODLASKA%TYPE
 ,SAT_ODLASKA_P IN t_gosti.sat_odlaska%TYPE
 ,IME_P IN T_GOSTI.IME%TYPE
 ,PREZIME_P IN T_GOSTI.PREZIME%TYPE
 ,BR_KARTICE_P IN T_GOSTI.BR_KARTICE%TYPE
 )
 IS
/*
Kod unosa gosta puniti zahtjev za poruke vrste "21 Prijavi korisnika kartice"
05.06.2007. G.J.
Kod unosa gosta puniti zahtjev za poruke vrste "26 Prijavi korisnika kartice (interno)" i,
ako je potrebno, "27 Promijeni razdoblje valjanosti kartice".
*/
  CURSOR kckar_c (kcjed_id_k IN mkc_jedinice.id%TYPE, br_kartice_k IN t_gosti.br_kartice%TYPE) IS
    SELECT *
      FROM tkc_kartice
     WHERE id IN (
           SELECT id
             FROM tkc_kartice
            WHERE oznaka = 'V'
              AND gost_id IS NULL
              AND age_id IS NULL
              AND pkaadr_id IS NULL
              AND kcjed_id = kcjed_id_k
              AND TRUNC (NVL (dat_zav, SYSDATE)) >= TRUNC (SYSDATE) -- 12.07.2004. G.J.
           MINUS
           -- neobraeni zahtjevi
           SELECT kckar_id
             FROM tkc_zahtjevi
            WHERE kcvpor_id IN (pra_rec_kc.kcvpor_id (21), pra_rec_kc.kcvpor_id (26)) -- 04.07.2007. G.J.
              AND kcjed_id = kcjed_id_k
              AND oznaka = -1) -- IRN 1836
     ORDER BY DECODE (broj, br_kartice_k, 0, 1), id;
  kckar_c_l kckar_c%ROWTYPE;
  rec_kczah_l tkc_zahtjevi%ROWTYPE;
BEGIN
  IF sj_id_p IS NULL
    OR gost_id_p IS NULL
    OR dat_dolaska_p IS NULL
    OR dat_odlaska_p IS NULL
    OR ime_p IS NULL
    OR prezime_p IS NULL
  THEN
    RETURN;
  END IF;
  
  FOR kcjed_c IN (SELECT id, kcsus_id FROM mkc_jedinice WHERE sj_id IS NOT NULL AND sj_id = sj_id_p) -- IRN 1700
  LOOP

    rec_kczah_l.kcjed_id := kcjed_c.id;

    IF pra_rec_kc.kcsus_oznaka6 (rec_kczah_l.kcjed_id) = 0 THEN
      -- ne postoji komunikacijski modul s Key Card sustavom kojem pripada odabrana jedinica
      GOTO kraj_petlje;
    END IF;

    IF pra_rec_kc.kcsus_oznaka4 (rec_kczah_l.kcjed_id) = 0 THEN
      /*
      za Key Card sustav kojem pripada odabrana jedinica
      unos podataka o gostu ne mijenja korisnika nevezane kartice
      */
      GOTO kraj_petlje;
    END IF;

    IF pra_rec_kc.kcvs_podrzava_kcvpor (rec_kczah_l.kcjed_id, 21) = 0
      AND pra_rec_kc.kcvs_podrzava_kcvpor (rec_kczah_l.kcjed_id, 26) = 0
    THEN
      -- vrsta Key Card sustava kojoj pripada odabrana jedinica ne podrava odabranu vrstu poruke
      GOTO kraj_petlje;
    END IF;

    OPEN kckar_c (rec_kczah_l.kcjed_id, br_kartice_p);
    FETCH kckar_c INTO kckar_c_l;
    IF kckar_c%NOTFOUND THEN
      -- u odabranoj jedinici nema valjanih nepovezanih kartica
      CLOSE kckar_c;
      GOTO kraj_petlje;
    END IF;
    CLOSE kckar_c;

    IF pra_rec_kc.kcvs_podrzava_kcvpor (rec_kczah_l.kcjed_id, 21) = -1 THEN
      -- 21 Prijavi korisnika kartice
      rec_kczah_l.kcvpor_id   := pra_rec_kc.kcvpor_id (21);
    ELSIF pra_rec_kc.kcvs_podrzava_kcvpor (rec_kczah_l.kcjed_id, 26) = -1 THEN
      -- 26 Prijavi korisnika kartice (interno)
      rec_kczah_l.kcvpor_id   := pra_rec_kc.kcvpor_id (26);
    END IF;
    rec_kczah_l.kckar_id    := kckar_c_l.id;
    rec_kczah_l.gost_id     := gost_id_p;
    rec_kczah_l.dat_poc     :=
      TO_DATE (TO_CHAR (dat_dolaska_p, 'DD.MM.RRRR') || ' ' || TO_CHAR (kckar_c_l.dat_poc, 'HH24:MI'), 'DD.MM.RRRR HH24:MI');
    IF sat_odlaska_p IS NULL THEN -- IRN 1700
      rec_kczah_l.dat_zav     :=
        TO_DATE (TO_CHAR (dat_odlaska_p, 'DD.MM.RRRR') || ' ' || TO_CHAR (kckar_c_l.dat_zav, 'HH24:MI'), 'DD.MM.RRRR HH24:MI');
    ELSE
      rec_kczah_l.dat_zav     := sat_odlaska_p;
    END IF;
    IF rec_kczah_l.dat_zav < rec_kczah_l.dat_poc THEN
      rec_kczah_l.dat_zav   :=
        TO_DATE (TO_CHAR (dat_odlaska_p, 'DD.MM.RRRR') || ' ' || TO_CHAR (kckar_c_l.dat_poc, 'HH24:MI'), 'DD.MM.RRRR HH24:MI');
    END IF;
    rec_kczah_l.ime         := ime_p;
    rec_kczah_l.prezime     := prezime_p;
    rec_kczah_l.pin         := kckar_c_l.pin;
    pra_rec_kc_iud.insert_kczah (rec_kczah_l);

    IF pra_rec_kc.kcvs_podrzava_kcvpor (rec_kczah_l.kcjed_id, 27) = -1
      AND
        (
        NVL (TRUNC (kckar_c_l.dat_poc), dat_dolaska_p) <> dat_dolaska_p
        OR
        NVL (TRUNC (kckar_c_l.dat_zav), dat_odlaska_p) <> dat_odlaska_p
        OR
        (kckar_c_l.dat_zav <> sat_odlaska_p AND kckar_c_l.dat_zav IS NOT NULL AND sat_odlaska_p IS NOT NULL) -- IRN 1700
        )
    THEN
      -- 27 Promijeni razdoblje valjanosti kartice
      rec_kczah_l.kcvpor_id   := pra_rec_kc.kcvpor_id (27);
      -- rec_kczah_l.kckar_id
      -- rec_kczah_l.gost_id
      rec_kczah_l.ozn_pisaca  := pra_rec_kc.ozn_pisaca (kcjed_c.kcsus_id);
      -- rec_kczah_l.dat_poc
      -- rec_kczah_l.dat_zav
      -- rec_kczah_l.ime
      -- rec_kczah_l.prezime
      -- rec_kczah_l.pin
      pra_rec_kc_iud.insert_kczah (rec_kczah_l);
    END IF;

    <<kraj_petlje>> NULL;

  END LOOP;

END;
PROCEDURE PUNI_KCZAH_GOST_AUS
 (GOST_ID_P IN T_GOSTI.ID%TYPE
 ,SJ_ID_OLD_P IN T_GOSTI.SJ_ID%TYPE
 ,DAT_DOLASKA_OLD_P IN T_GOSTI.DAT_DOLASKA%TYPE
 ,DAT_ODLASKA_OLD_P IN T_GOSTI.DAT_ODLASKA%TYPE
 ,SAT_ODLASKA_OLD_P IN t_gosti.sat_odlaska%TYPE
 ,IME_OLD_P IN T_GOSTI.IME%TYPE
 ,PREZIME_OLD_P IN T_GOSTI.PREZIME%TYPE
 ,OZN_PRISUTNOSTI_OLD_P IN T_GOSTI.OZN_PRISUTNOSTI%TYPE
 ,SJ_ID_NEW_P IN T_GOSTI.SJ_ID%TYPE
 ,DAT_DOLASKA_NEW_P IN T_GOSTI.DAT_DOLASKA%TYPE
 ,DAT_ODLASKA_NEW_P IN T_GOSTI.DAT_ODLASKA%TYPE
 ,SAT_ODLASKA_NEW_P IN t_gosti.sat_odlaska%TYPE
 ,IME_NEW_P IN T_GOSTI.IME%TYPE
 ,PREZIME_NEW_P IN T_GOSTI.PREZIME%TYPE
 ,OZN_PRISUTNOSTI_NEW_P IN T_GOSTI.OZN_PRISUTNOSTI%TYPE
 )
 IS
/*
Kod promjene podataka o gostu puniti zahtjeve za poruke vrste:
22 Promijeni podatke o korisniku kartice
23 Odjavi korisnika kartice
19 Poniti karticu
05.06.2007. G.J.
Kod promjene podataka o gostu puniti zahtjeve za poruke vrste:
27 Promijeni razdoblje valjanosti kartice
*/
  rec_kczah_l tkc_zahtjevi%ROWTYPE;
  br_redaka_l NUMBER;
  kcvpor22_upisana_l BOOLEAN := FALSE;
  sat_odlaska_null_l DATE := TO_DATE ('01.01.1800', 'DD.MM.RRRR'); -- IRN 1700
BEGIN
  IF gost_id_p IS NULL
    OR sj_id_old_p IS NULL
    OR dat_dolaska_old_p IS NULL
    OR dat_odlaska_old_p IS NULL
    OR ime_old_p IS NULL
    OR prezime_old_p IS NULL
    OR ozn_prisutnosti_old_p IS NULL
    OR sj_id_new_p IS NULL
    OR dat_dolaska_new_p IS NULL
    OR dat_odlaska_new_p IS NULL
    OR ime_new_p IS NULL
    OR prezime_new_p IS NULL
    OR ozn_prisutnosti_new_p IS NULL
  THEN
    RETURN;
  END IF;

  IF sj_id_old_p = sj_id_new_p
    AND dat_dolaska_old_p = dat_dolaska_new_p
    AND dat_odlaska_old_p = dat_odlaska_new_p
    AND NVL (sat_odlaska_old_p, sat_odlaska_null_l) = NVL (sat_odlaska_new_p, sat_odlaska_null_l) -- IRN 1700
    AND ime_old_p = ime_new_p
    AND prezime_old_p = prezime_new_p
    AND ozn_prisutnosti_old_p = ozn_prisutnosti_new_p
  THEN
    -- Nema promjena znaajnih za Key Card sustav
    RETURN;
  END IF;

  -- Promjena podataka o gostu korisniku valjane kartice
  IF dat_dolaska_old_p <> dat_dolaska_new_p
    OR dat_odlaska_old_p <> dat_odlaska_new_p
    OR NVL (sat_odlaska_old_p, sat_odlaska_null_l) <> NVL (sat_odlaska_new_p, sat_odlaska_null_l) -- IRN 1700
    OR ime_old_p <> ime_new_p
    OR prezime_old_p <> prezime_new_p
  THEN
    FOR kckar_c IN (
      SELECT kckar.id AS id,
             kckar.kcjed_id AS kcjed_id,
             kckar.gost_id AS gost_id,
             kckar.dat_poc AS dat_poc,
             kckar.dat_zav AS dat_zav,
             kckar.pin AS pin,
             kcjed.kcsus_id AS kcsus_id
        FROM tkc_kartice kckar,
             mkc_jedinice kcjed -- IRN 1700
       WHERE kckar.oznaka = 'V'
         AND kckar.gost_id = gost_id_p
         AND kckar.kcjed_id = kcjed.id)
    LOOP
      IF pra_rec_kc.kcsus_oznaka6 (kckar_c.kcjed_id) = -1 THEN
        -- Postoji komunikacijski modul s Key Card sustavom: Da/Ne.
        pra_rec_kc_iud.cisti_rec_kczah_l (rec_kczah_l);
        rec_kczah_l.kcjed_id    := kckar_c.kcjed_id;
        rec_kczah_l.kckar_id    := kckar_c.id;
        rec_kczah_l.gost_id     := kckar_c.gost_id;
        rec_kczah_l.dat_poc     :=
          TO_DATE (TO_CHAR (dat_dolaska_new_p, 'DD.MM.RRRR') || ' ' || TO_CHAR (kckar_c.dat_poc, 'HH24:MI'), 'DD.MM.RRRR HH24:MI');
        IF sat_odlaska_new_p IS NULL THEN -- IRN 1700
          rec_kczah_l.dat_zav     :=
            TO_DATE (TO_CHAR (dat_odlaska_new_p, 'DD.MM.RRRR') || ' ' || TO_CHAR (kckar_c.dat_zav, 'HH24:MI'), 'DD.MM.RRRR HH24:MI');
        ELSE
          rec_kczah_l.dat_zav     := sat_odlaska_new_p;
        END IF;
        IF rec_kczah_l.dat_zav < rec_kczah_l.dat_poc THEN
          rec_kczah_l.dat_zav   :=
            TO_DATE (TO_CHAR (dat_odlaska_new_p, 'DD.MM.RRRR') || ' ' || TO_CHAR (kckar_c.dat_poc, 'HH24:MI'), 'DD.MM.RRRR HH24:MI');
        END IF;
        rec_kczah_l.ime         := ime_new_p;
        rec_kczah_l.prezime     := prezime_new_p;
        rec_kczah_l.pin         := kckar_c.pin;
        IF pra_rec_kc.kcvs_podrzava_kcvpor (kckar_c.kcjed_id, 22) = -1 THEN
          rec_kczah_l.kcvpor_id   := pra_rec_kc.kcvpor_id (22); -- Promijeni podatke o korisniku kartice
          pra_rec_kc_iud.insert_kczah (rec_kczah_l);
        END IF;
        -- 05.06.2007. G.J.
        IF pra_rec_kc.kcvs_podrzava_kcvpor (kckar_c.kcjed_id, 27) = -1
          AND (
               dat_dolaska_old_p <> dat_dolaska_new_p
            OR dat_odlaska_old_p <> dat_odlaska_new_p
            OR NVL (sat_odlaska_old_p, sat_odlaska_null_l) <> NVL (sat_odlaska_new_p, sat_odlaska_null_l) -- IRN 1700
            )
        THEN
          rec_kczah_l.kcvpor_id  := pra_rec_kc.kcvpor_id (27); -- Promijeni razdoblje valjanosti kartice
          rec_kczah_l.ozn_pisaca := pra_rec_kc.ozn_pisaca (kckar_c.kcsus_id);
          pra_rec_kc_iud.insert_kczah (rec_kczah_l);
        END IF;
      END IF;
    END LOOP;
  END IF;

  -- Seljenje gosta korisnika valjane kartice
  IF sj_id_old_p <> sj_id_new_p THEN
    FOR kckar_c IN (
      SELECT kckar.id AS id,
             kckar.kcjed_id AS kcjed_id,
             kckar.gost_id AS gost_id,
             kckar.dat_poc AS dat_poc,
             kckar.dat_zav AS dat_zav,
             kckar.pin AS pin
        FROM tkc_kartice kckar,
             mkc_jedinice kcjed -- IRN 1700
       WHERE kckar.oznaka = 'V'
         AND kckar.gost_id = gost_id_p
         AND kckar.kcjed_id = kcjed.id
         AND kcjed.sj_id = sj_id_old_p)
    LOOP
      FOR kcjed_new_c IN (
        SELECT id FROM mkc_jedinice WHERE sj_id = sj_id_new_p)
      LOOP
        IF pra_rec_kc.kcsus_oznaka6 (kckar_c.kcjed_id) = -1
          AND pra_rec_kc.kcsus_oznaka6 (kcjed_new_c.id) = -1
          AND pra_rec_kc.kcvs_podrzava_kcvpor (kckar_c.kcjed_id, 22) = -1
          AND pra_rec_kc.kcvs_podrzava_kcvpor (kcjed_new_c.id, 22) = -1
        THEN
          pra_rec_kc_iud.cisti_rec_kczah_l (rec_kczah_l);
          rec_kczah_l.kcjed_id    := kckar_c.kcjed_id;
          rec_kczah_l.kcjed2_id   := kcjed_new_c.id;
          rec_kczah_l.kcvpor_id   := pra_rec_kc.kcvpor_id (22);
          rec_kczah_l.kckar_id    := kckar_c.id;
          rec_kczah_l.gost_id     := kckar_c.gost_id;
          rec_kczah_l.dat_poc     :=
            TO_DATE (TO_CHAR (dat_dolaska_new_p, 'DD.MM.RRRR') || ' ' || TO_CHAR (kckar_c.dat_poc, 'HH24:MI'), 'DD.MM.RRRR HH24:MI');
          IF sat_odlaska_new_p IS NULL THEN -- IRN 1700
            rec_kczah_l.dat_zav     :=
              TO_DATE (TO_CHAR (dat_odlaska_new_p, 'DD.MM.RRRR') || ' ' || TO_CHAR (kckar_c.dat_zav, 'HH24:MI'), 'DD.MM.RRRR HH24:MI');
          ELSE
            rec_kczah_l.dat_zav     := sat_odlaska_new_p;
          END IF;
          IF rec_kczah_l.dat_zav < rec_kczah_l.dat_poc THEN
            rec_kczah_l.dat_zav   :=
              TO_DATE (TO_CHAR (dat_odlaska_new_p, 'DD.MM.RRRR') || ' ' || TO_CHAR (kckar_c.dat_poc, 'HH24:MI'), 'DD.MM.RRRR HH24:MI');
          END IF;
          rec_kczah_l.ime         := ime_new_p;
          rec_kczah_l.prezime     := prezime_new_p;
          rec_kczah_l.pin         := kckar_c.pin;
          pra_rec_kc_iud.insert_kczah (rec_kczah_l);
          kcvpor22_upisana_l := TRUE;
        END IF;
      END LOOP; -- kraj nove jedinice
    END LOOP; -- kraj stare jedinice
    IF NOT kcvpor22_upisana_l THEN
      /*
      nova SJ ne pripada istom sustavu kao i stara SJ; ili
      sustav ne podrava poruku 22 Promijeni podatke o korisniku kartice,
      pa kartice odabranog gosta vezane za staru SJ treba ponititi
      i prijaviti gosta kao korisnika kartice vezane za novu SJ
      */
      FOR kckar_c IN (
        SELECT kckar.id AS id,
               kckar.kcjed_id AS kcjed_id,
               kckar.gost_id AS gost_id,
               kcjed.kcsus_id AS kcsus_id
          FROM tkc_kartice kckar,
               mkc_jedinice kcjed -- IRN 1700
         WHERE kckar.oznaka = 'V'
           AND kckar.gost_id = gost_id_p
           AND kckar.kcjed_id = kcjed.id
           AND kcjed.sj_id = sj_id_old_p)
      LOOP
        IF pra_rec_kc.kcsus_oznaka6 (kckar_c.kcjed_id) = -1
          AND pra_rec_kc.kcvs_podrzava_kcvpor (kckar_c.kcjed_id, 19) = -1
        THEN
          pra_rec_kc_iud.cisti_rec_kczah_l (rec_kczah_l);
          rec_kczah_l.kcjed_id   := kckar_c.kcjed_id;
          rec_kczah_l.kcvpor_id  := pra_rec_kc.kcvpor_id (19); -- Poniti karticu
          rec_kczah_l.kckar_id   := kckar_c.id;
          rec_kczah_l.gost_id    := kckar_c.gost_id;
          rec_kczah_l.ozn_pisaca := pra_rec_kc.ozn_pisaca (kckar_c.kcsus_id);
          pra_rec_kc_iud.insert_kczah (rec_kczah_l);
        END IF;
      END LOOP;

      pra_rec_kc_iud.puni_kczah_gost21 (
        gost_id_p,
        sj_id_new_p,
        dat_dolaska_new_p,
        dat_odlaska_new_p,
        sat_odlaska_new_p, -- IRN 1700
        ime_new_p,
        prezime_new_p,
        NULL); -- br_kartice
    END IF;
  END IF;

  -- Odjava gosta
  IF ozn_prisutnosti_old_p IN ('P') AND ozn_prisutnosti_new_p IN ('O') THEN
    FOR kckar_c IN (
      SELECT kckar.id AS id,
             kckar.kcjed_id AS kcjed_id,
             kckar.gost_id AS gost_id,
             kcjed.kcsus_id AS kcsus_id
        FROM tkc_kartice kckar,
             mkc_jedinice kcjed -- IRN 1700
       WHERE kckar.oznaka = 'V'
         AND kckar.gost_id = gost_id_p
         AND kckar.kcjed_id = kcjed.id)
    LOOP
      IF pra_rec_kc.kcsus_oznaka6 (kckar_c.kcjed_id) = -1
        AND pra_rec_kc.kcvs_podrzava_kcvpor (kckar_c.kcjed_id, 23) = -1
      THEN
        pra_rec_kc_iud.cisti_rec_kczah_l (rec_kczah_l);
        rec_kczah_l.kcjed_id   := kckar_c.kcjed_id;
        rec_kczah_l.kcvpor_id  := pra_rec_kc.kcvpor_id (23); -- Odjavi korisnika kartice
        rec_kczah_l.kckar_id   := kckar_c.id;
        rec_kczah_l.gost_id    := kckar_c.gost_id;
        rec_kczah_l.ozn_pisaca := pra_rec_kc.ozn_pisaca (kckar_c.kcsus_id);
        pra_rec_kc_iud.insert_kczah (rec_kczah_l);
      END IF;
    END LOOP;
  END IF;

  /*
  Ponititi sve kartice ako nema prisutnih gostiju u staroj SJ
  bez obzira na to tko je korisnik kartice
  */
  IF (
     (sj_id_old_p <> sj_id_new_p)
     OR
     (ozn_prisutnosti_old_p IN ('P') AND ozn_prisutnosti_new_p IN ('O'))
     )
  THEN
    SELECT COUNT (ROWID) INTO br_redaka_l
      FROM t_gosti
     WHERE sj_id = sj_id_old_p
       AND ozn_prisutnosti = 'P'
       AND id <> gost_id_p;
    IF br_redaka_l = 0 THEN
      FOR kckar_c IN (
        SELECT kckar.id AS id,
               kckar.kcjed_id AS kcjed_id,
               kcjed.kcsus_id AS kcsus_id
          FROM tkc_kartice kckar,
               mkc_jedinice kcjed -- IRN 1700
         WHERE kckar.kcjed_id = kcjed.id
           AND kcjed.sj_id = sj_id_old_p
           AND kckar.oznaka = 'V'
           AND kckar.id NOT IN (
               SELECT kczah.kckar_id
                 FROM tkc_zahtjevi kczah,
                      mkc_jedinice kcjed,
                      mkc_jedinice kcjed2
                WHERE kcjed.sj_id = sj_id_old_p
                  AND kczah.kcjed_id = kcjed.id
                  AND kcjed2.sj_id = sj_id_new_p
                  AND kczah.kcjed2_id = kcjed2.id
                  AND kczah.kcvpor_id = pra_rec_kc.kcvpor_id (22)
                  AND kczah.oznaka = -1 -- IRN 1836
               -- 05.06.2007. G.J.
               UNION ALL
               SELECT kckar_id
                 FROM tkc_zahtjevi
                WHERE kcvpor_id = pra_rec_kc.kcvpor_id (19)
                  AND oznaka = -1 -- IRN 1836
               )
           -- 06.06.2008. G.J. IRN 609
           AND TRUNC (NVL (kckar.dat_zav, SYSDATE)) <= TRUNC (SYSDATE)
        )
      LOOP
        IF pra_rec_kc.kcsus_oznaka6 (kckar_c.kcjed_id) = -1
          AND pra_rec_kc.kcvs_podrzava_kcvpor (kckar_c.kcjed_id, 19) = -1
        THEN
          pra_rec_kc_iud.cisti_rec_kczah_l (rec_kczah_l);
          rec_kczah_l.kcjed_id   := kckar_c.kcjed_id;
          rec_kczah_l.kcvpor_id  := pra_rec_kc.kcvpor_id (19);
          rec_kczah_l.kckar_id   := kckar_c.id;
          rec_kczah_l.ozn_pisaca := pra_rec_kc.ozn_pisaca (kckar_c.kcsus_id);
          pra_rec_kc_iud.insert_kczah (rec_kczah_l);
        END IF;
      END LOOP;
    END IF;
  END IF;

END;
PROCEDURE AZURIRAJ_KCKAR_GOST
 (GOST_ID_P IN t_gosti.id%TYPE
 ,SJ_ID_P IN t_gosti.sj_id%TYPE
 ,DAT_DOLASKA_P IN t_gosti.dat_dolaska%TYPE
 ,DAT_ODLASKA_P IN t_gosti.dat_odlaska%TYPE
 ,SAT_ODLASKA_P IN t_gosti.sat_odlaska%TYPE
 ,IME_P IN t_gosti.ime%TYPE
 ,PREZIME_P IN t_gosti.prezime%TYPE
 ,OZN_PRISUTNOSTI_P IN t_gosti.ozn_prisutnosti%TYPE
 ,BR_KARTICE_P IN t_gosti.br_kartice%TYPE
 ,REZGOST_ID_P IN t_gosti.rezgost_id%TYPE
 )
 IS
/*
Kod unosa gosta aurirati valjane nevezane neistekle kartice koje
pripadaju Key Card sustavu gdje je oznaka6 postavljena na 0
to znai da NE postoji komunikacijski modul s Key Card sustavom
pa se kartice auriraju izravno, a ne preko zahtjeva i odgovora.
*/

  CURSOR kckar_c (kcjed_id_k IN mkc_jedinice.id%TYPE, br_kartice_k IN t_gosti.br_kartice%TYPE) IS
    SELECT *
      FROM tkc_kartice
     WHERE oznaka = 'V'
       AND gost_id IS NULL
       AND age_id IS NULL
       AND pkaadr_id IS NULL
       AND rezgost_id IS NULL -- IRN 2960; rezervirane kartice izuzeti
       AND kcjed_id = kcjed_id_k
       -- 12.07.2004. G.J.
       AND TRUNC (NVL (dat_zav, SYSDATE)) >= TRUNC (SYSDATE)
     ORDER BY DECODE (broj, br_kartice_k, 0, 1), id;
  kckar_c_l kckar_c%ROWTYPE;

  -- IRN 2931
  CURSOR kckar2_c (kcsus_id_k IN mkc_jedinice.kcsus_id%TYPE, br_kartice_k IN t_gosti.br_kartice%TYPE) IS
    SELECT kckar.*
      FROM tkc_kartice kckar,
           mkc_jedinice kcjed
     WHERE kckar.kcjed_id = kcjed.id
       /*
       Kartica se kod rezervacije moe vezati na npr. jedinicu Recepcija,
       a kod prijave se treba prevezati na jedinicu u koju je smjeten gost
       */
       AND kcjed.kcsus_id = kcsus_id_k
       AND kckar.oznaka = 'V'
       AND kckar.gost_id IS NULL
       AND kckar.age_id IS NULL
       AND kckar.pkaadr_id IS NULL
       AND kckar.rezgost_id = rezgost_id_p
       AND TRUNC (NVL (kckar.dat_zav, SYSDATE)) >= TRUNC (SYSDATE)
     ORDER BY DECODE (kckar.broj, br_kartice_k, 0, 1), kckar.id;

  -- 19.04.2006. G.J.
  CURSOR kcsus_c (kcsus_id_k IN mkc_sustavi.id%TYPE) IS
    SELECT TO_CHAR (sat_zav, 'HH24:MI') AS sat_zav
      FROM mkc_sustavi
     WHERE id = kcsus_id_k; -- IRN 1700
  kcsus_c_l kcsus_c%ROWTYPE;

  dat_poc_l tkc_kartice.dat_poc%TYPE;
  dat_zav_l tkc_kartice.dat_zav%TYPE;
  br_minuta_l NUMBER;
BEGIN
  IF gost_id_p IS NULL
    OR sj_id_p IS NULL
    OR dat_dolaska_p IS NULL
    OR dat_odlaska_p IS NULL
    OR ime_p IS NULL
    OR prezime_p IS NULL
    OR ozn_prisutnosti_p IS NULL
  THEN
    RETURN;
  END IF;
  
  FOR kcjed_c IN (SELECT id, kcsus_id FROM mkc_jedinice WHERE sj_id = sj_id_p) -- IRN 1700
  LOOP

    IF pra_rec_kc.kcsus_oznaka6 (kcjed_c.id) = -1 THEN
      /*
      postoji komunikacijski modul s Key Card sustavom kojem pripada
      odabrana jedinica, pa se kartice auriraju putem zahtjeva i odgovora,
      a NE izravno
      */
      GOTO kraj_petlje;
    END IF;

    IF pra_rec_kc.kcsus_oznaka4 (kcjed_c.id) = 0 THEN
      /*
      za Key Card sustav kojem pripada odabrana jedinica
      unos podataka o gostu ne mijenja korisnika nevezane kartice
      */
      GOTO kraj_petlje;
    END IF;

    -- IRN 2931
    IF rezgost_id_p IS NOT NULL THEN
      OPEN kckar2_c (kcjed_c.kcsus_id, br_kartice_p);
      FETCH kckar2_c INTO kckar_c_l;
      CLOSE kckar2_c;
    END IF;

    IF kckar_c_l.id IS NULL THEN -- IRN 2931
      OPEN kckar_c (kcjed_c.id, br_kartice_p);
      FETCH kckar_c INTO kckar_c_l;
      IF kckar_c%NOTFOUND THEN
        -- u odabranoj jedinici nema valjanih nepovezanih neisteklih kartica
        CLOSE kckar_c;
        GOTO kraj_petlje;
      END IF;
      CLOSE kckar_c;
    END IF;

    -- 12.06.2006. G.J.
    -- 1088 => Broj minuta koji se dodaje kod predlaganja zavretka razdoblja valjanosti kartice: od 0 do 240.
    br_minuta_l := TO_NUMBER (pra_rec_zaj.vrijednost_parametra ('1088'));
    IF br_minuta_l BETWEEN 0 AND 240
      AND kckar_c_l.dat_zav IS NOT NULL
      AND kckar_c_l.dat_poc IS NOT NULL
      AND kckar_c_l.dat_zav = kckar_c_l.dat_poc + 1 / 24 / 60 * br_minuta_l
    THEN
      -- Ako je zavrno vrijeme jednako predloenom onda predloi zavrno vrijeme iz sustava
      OPEN kcsus_c (kcjed_c.kcsus_id); -- IRN 1700
      FETCH kcsus_c INTO kcsus_c_l;
      CLOSE kcsus_c;
    END IF;

    dat_poc_l :=
      TO_DATE (TO_CHAR (dat_dolaska_p, 'DD.MM.RRRR') || ' ' || TO_CHAR (kckar_c_l.dat_poc, 'HH24:MI'), 'DD.MM.RRRR HH24:MI');
    -- 19.04.2006. G.J.
    IF sat_odlaska_p IS NULL THEN -- IRN 1700
      dat_zav_l :=
        TO_DATE (TO_CHAR (dat_odlaska_p, 'DD.MM.RRRR') || ' ' || NVL (kcsus_c_l.sat_zav, TO_CHAR (kckar_c_l.dat_zav, 'HH24:MI')), 'DD.MM.RRRR HH24:MI');
    ELSE
      dat_zav_l := sat_odlaska_p;
    END IF;
    IF dat_zav_l < dat_poc_l THEN
      dat_zav_l :=
        TO_DATE (TO_CHAR (dat_odlaska_p, 'DD.MM.RRRR') || ' ' || TO_CHAR (kckar_c_l.dat_poc, 'HH24:MI'), 'DD.MM.RRRR HH24:MI');
    END IF;

    UPDATE tkc_kartice
       SET gost_id = gost_id_p,
           dat_poc = dat_poc_l,
           dat_zav = dat_zav_l,
           ime     = ime_p,
           prezime = prezime_p,
           ozn_prisutnosti = ozn_prisutnosti_p,
           kcjed_id = kcjed_c.id -- IRN 2931
     WHERE id = kckar_c_l.id;

     <<kraj_petlje>> NULL;

  END LOOP;
END;
PROCEDURE AZURIRAJ_KCKAR_GOST_AUS
 (GOST_ID_P IN T_GOSTI.ID%TYPE
 ,SJ_ID_OLD_P IN T_GOSTI.SJ_ID%TYPE
 ,DAT_DOLASKA_OLD_P IN T_GOSTI.DAT_DOLASKA%TYPE
 ,DAT_ODLASKA_OLD_P IN T_GOSTI.DAT_ODLASKA%TYPE
 ,SAT_ODLASKA_OLD_P IN t_gosti.sat_odlaska%TYPE
 ,IME_OLD_P IN T_GOSTI.IME%TYPE
 ,PREZIME_OLD_P IN T_GOSTI.PREZIME%TYPE
 ,OZN_PRISUTNOSTI_OLD_P IN T_GOSTI.OZN_PRISUTNOSTI%TYPE
 ,SJ_ID_NEW_P IN T_GOSTI.SJ_ID%TYPE
 ,DAT_DOLASKA_NEW_P IN T_GOSTI.DAT_DOLASKA%TYPE
 ,DAT_ODLASKA_NEW_P IN T_GOSTI.DAT_ODLASKA%TYPE
 ,SAT_ODLASKA_NEW_P IN t_gosti.sat_odlaska%TYPE
 ,IME_NEW_P IN T_GOSTI.IME%TYPE
 ,PREZIME_NEW_P IN T_GOSTI.PREZIME%TYPE
 ,OZN_PRISUTNOSTI_NEW_P IN T_GOSTI.OZN_PRISUTNOSTI%TYPE
 )
 IS
/*
Kod promjene podataka o gostu aurirati njegove kartice.
Kartice moraju pripadati Key Card sustavu gdje je oznaka6
postavljena na 0, to znai da NE postoji komunikacijski
modul s Key Card sustavom, pa se kartice auriraju izravno,
a ne preko zahtjeva i odgovora.
*/
  dat_poc_l tkc_kartice.dat_poc%TYPE;
  dat_zav_l tkc_kartice.dat_zav%TYPE;
  br_redaka_l NUMBER;
  CURSOR kcsuspar_c (
    kcvsvpar_sifra_k skc_vs_vpar.sifra%TYPE,
    kcsus_id_k mkc_sustavi.id%TYPE)
  IS
    SELECT mkc_sus_par.vrijednost AS vrijednost
      FROM mkc_sus_par,
           skc_vs_vpar
     WHERE mkc_sus_par.kcsus_id = kcsus_id_k
       AND mkc_sus_par.kcvsvpar_id = skc_vs_vpar.id
       AND UPPER (skc_vs_vpar.sifra) = kcvsvpar_sifra_k;
  kcsuspar_c_l kcsuspar_c%ROWTYPE;
  seljenje_upisano_l BOOLEAN := FALSE;
  sat_odlaska_null_l DATE := TO_DATE ('01.01.1800', 'DD.MM.RRRR'); -- IRN 1700
BEGIN
  IF gost_id_p IS NULL
    OR sj_id_old_p IS NULL
    OR dat_dolaska_old_p IS NULL
    OR dat_odlaska_old_p IS NULL
    OR ime_old_p IS NULL
    OR prezime_old_p IS NULL
    OR ozn_prisutnosti_old_p IS NULL
    OR sj_id_new_p IS NULL
    OR dat_dolaska_new_p IS NULL
    OR dat_odlaska_new_p IS NULL
    OR ime_new_p IS NULL
    OR prezime_new_p IS NULL
    OR ozn_prisutnosti_new_p IS NULL
  THEN
    RETURN;
  END IF;

  IF sj_id_old_p = sj_id_new_p
    AND dat_dolaska_old_p = dat_dolaska_new_p
    AND dat_odlaska_old_p = dat_odlaska_new_p
    AND NVL (sat_odlaska_old_p, sat_odlaska_null_l) = NVL (sat_odlaska_new_p, sat_odlaska_null_l) -- IRN 1700
    AND ime_old_p = ime_new_p
    AND prezime_old_p = prezime_new_p
    AND ozn_prisutnosti_old_p = ozn_prisutnosti_new_p
  THEN
    -- Nema promjena znaajnih za Key Card sustav
    RETURN;
  END IF;


  -- Promjena podataka o gostu korisniku valjane kartice
  IF dat_dolaska_old_p <> dat_dolaska_new_p
    OR dat_odlaska_old_p <> dat_odlaska_new_p
    OR NVL (sat_odlaska_old_p, sat_odlaska_null_l) <> NVL (sat_odlaska_new_p, sat_odlaska_null_l) -- IRN 1700
    OR ime_old_p <> ime_new_p
    OR prezime_old_p <> prezime_new_p
  THEN
    FOR kckar_c IN (
      SELECT id,
             kcjed_id,
             dat_poc,
             dat_zav
        FROM tkc_kartice
       WHERE oznaka = 'V'
         AND gost_id = gost_id_p)
    LOOP
      IF pra_rec_kc.kcsus_oznaka6 (kckar_c.kcjed_id) = 0 -- ne postoji komunikacijski modul s Key Card sustavom
        AND pra_rec_kc.kcsus_oznaka4 (kckar_c.kcjed_id) = -1 -- unos podataka o gostu mijenja korisnika nevezane kartice
      THEN
        dat_poc_l :=
          TO_DATE (TO_CHAR (dat_dolaska_new_p, 'DD.MM.RRRR') || ' ' || TO_CHAR (kckar_c.dat_poc, 'HH24:MI'), 'DD.MM.RRRR HH24:MI');
        IF sat_odlaska_new_p IS NULL THEN -- IRN 1700
          dat_zav_l :=
            TO_DATE (TO_CHAR (dat_odlaska_new_p, 'DD.MM.RRRR') || ' ' || TO_CHAR (kckar_c.dat_zav, 'HH24:MI'), 'DD.MM.RRRR HH24:MI');
        ELSE
          dat_zav_l := sat_odlaska_new_p;
        END IF;
        IF dat_zav_l < dat_poc_l THEN
          dat_zav_l :=
            TO_DATE (TO_CHAR (dat_odlaska_new_p, 'DD.MM.RRRR') || ' ' || TO_CHAR (kckar_c.dat_poc, 'HH24:MI'), 'DD.MM.RRRR HH24:MI');
        END IF;
        UPDATE tkc_kartice
           SET dat_poc = dat_poc_l,
               dat_zav = dat_zav_l,
               ime     = ime_new_p,
               prezime = prezime_new_p
         WHERE id = kckar_c.id;
      END IF;
    END LOOP;
  END IF;


  -- Seljenje gosta korisnika valjane kartice
  IF sj_id_old_p <> sj_id_new_p THEN
    FOR kckar_c IN (
      SELECT kckar.id AS id,
             kckar.kcjed_id AS kcjed_id
        FROM tkc_kartice kckar,
             mkc_jedinice kcjed -- IRN 1700
       WHERE kckar.oznaka = 'V'
         AND kckar.gost_id = gost_id_p
         AND kckar.kcjed_id = kcjed.id
         AND kcjed.sj_id = sj_id_old_p)
    LOOP
      FOR kcjed_new_c IN (SELECT id FROM mkc_jedinice WHERE sj_id = sj_id_new_p) -- IRN 1700
      LOOP
        IF pra_rec_kc.kcsus_oznaka6 (kckar_c.kcjed_id) = 0 -- ne postoji komunikacijski modul s Key Card sustavom
          AND pra_rec_kc.kcsus_oznaka6 (kcjed_new_c.id) = 0
          AND pra_rec_kc.kcsus_oznaka4 (kckar_c.kcjed_id) = -1 -- unos podataka o gostu mijenja korisnika nevezane kartice
          AND pra_rec_kc.kcsus_oznaka4 (kcjed_new_c.id) = -1
        THEN

          UPDATE tkc_kartice
             SET kcjed_id = kcjed_new_c.id
           WHERE id = kckar_c.id;

          seljenje_upisano_l := TRUE;

        END IF;
      END LOOP; -- nova SJ
    END LOOP; -- stara SJ

    IF NOT seljenje_upisano_l THEN -- IRN 1700
      /*
      nova SJ ne pripada istom sustavu kao i stara SJ; ili
      sustav ne podrava da unos podataka o gostu mijenja korisnika nevezane kartice,
      pa kartice odabranog gosta vezane za staru SJ treba ponititi
      i prijaviti gosta kao korisnika kartice vezane za novu SJ
      */
      FOR kckar_c IN (
        SELECT kckar.id AS id,
               kckar.kcjed_id AS kcjed_id
          FROM tkc_kartice kckar,
               mkc_jedinice kcjed -- IRN 1700
         WHERE kckar.oznaka = 'V'
           AND kckar.gost_id = gost_id_p
           AND kckar.kcjed_id = kcjed.id
           AND kcjed.sj_id = sj_id_old_p)
      LOOP
        IF pra_rec_kc.kcsus_oznaka6 (kckar_c.kcjed_id) = 0 THEN -- ne postoji komunikacijski modul s Key Card sustavom
          UPDATE tkc_kartice
             SET oznaka = 'P'
           WHERE id = kckar_c.id;
        END IF;
      END LOOP;

      pra_rec_kc_iud.azuriraj_kckar_gost (
        gost_id_p,
        sj_id_new_p,
        dat_dolaska_new_p,
        dat_odlaska_new_p,
        sat_odlaska_new_p,
        ime_new_p,
        prezime_new_p,
        ozn_prisutnosti_new_p,
        NULL,  -- br_kartice_p
        NULL); -- IRN 2931 rezgost_id_p
    END IF;
  END IF;


  -- Odjava gosta
  IF ozn_prisutnosti_old_p IN ('P') AND ozn_prisutnosti_new_p IN ('O') THEN
    FOR kckar_c IN (
      SELECT id,
             kcjed_id
        FROM tkc_kartice
       WHERE oznaka = 'V'
         AND gost_id = gost_id_p)
    LOOP
      IF pra_rec_kc.kcsus_oznaka6 (kckar_c.kcjed_id) = 0 -- ne postoji komunikacijski modul s Key Card sustavom
        AND pra_rec_kc.kcsus_oznaka4 (kckar_c.kcjed_id) = -1 -- unos podataka o gostu mijenja korisnika nevezane kartice
      THEN
        UPDATE tkc_kartice
           SET ozn_prisutnosti = ozn_prisutnosti_new_p
         WHERE id = kckar_c.id;
      END IF;
    END LOOP;
  END IF;


  /*
  Ponititi sve kartice, osim rezerviranih, ako nema prisutnih gostiju u staroj SJ
  bez obzira na to tko je korisnik kartice
  */
  IF (
     (sj_id_old_p <> sj_id_new_p)
     OR
     (ozn_prisutnosti_old_p IN ('P') AND ozn_prisutnosti_new_p IN ('O'))
     )
  THEN
    SELECT COUNT (1) INTO br_redaka_l
      FROM t_gosti
     WHERE sj_id = sj_id_old_p
       AND ozn_prisutnosti = 'P'
       AND id <> gost_id_p;
    IF br_redaka_l = 0 THEN
      FOR kckar_c IN (
        SELECT kckar.id AS id,
               kckar.kcjed_id AS kcjed_id,
               kcjed.kcsus_id AS kcsus_id
          FROM tkc_kartice kckar,
               mkc_jedinice kcjed, -- IRN 1700
               mkc_sustavi kcsus,
               (
               SELECT mkc_sus_par.kcsus_id, mkc_sus_par.vrijednost
                 FROM mkc_sus_par,
                      skc_vs_vpar
                WHERE mkc_sus_par.kcvsvpar_id = skc_vs_vpar.id
                  AND UPPER (skc_vs_vpar.sifra) = 'ODJAVA'
               ) kcsuspar
         WHERE kckar.oznaka = 'V'
           AND kckar.kcjed_id = kcjed.id
           AND kcjed.sj_id = sj_id_old_p
           AND kcjed.kcsus_id = kcsus.id
           AND kcsus.oznaka6 = 0
           AND kcsus.id = kcsuspar.kcsus_id(+)
           AND NVL (kcsuspar.vrijednost, 'ne') = 'da'
           -- IRN 2960, rezervirane kartice ostaju valjane
           AND (kckar.rezgost_id IS NULL OR kckar.gost_id IS NOT NULL)
        )
      LOOP
        UPDATE tkc_kartice
           SET oznaka = 'P'
         WHERE id = kckar_c.id;
      END LOOP;
    END IF;
  END IF;

END;
PROCEDURE INSERT_KCVSVPAR
 (KCVS_ID_P IN SKC_VS_VPAR.KCVS_ID%TYPE
 ,SIFRA_P IN SKC_VS_VPAR.SIFRA%TYPE
 ,OPIS_P IN SKC_VS_VPAR.OPIS%TYPE
 ,ID_P IN OUT SKC_VS_VPAR.ID%TYPE
 )
 IS
/*
Upii vrste parametara po vrstama Key Card sustava (skc_vs_vpar) na server 'centar'.
Tablica skc_vs_vpar je replikacijska, a puni je komunikacijski modul koji ne mora biti
instaliran na serveru 'centar'.
*/
  metcvor_sifra_centra_l smet_cvorovi.sifra%TYPE;
  naredba_l VARCHAR2(2000);
BEGIN
  IF kcvs_id_p IS NULL
    OR sifra_p IS NULL
    OR opis_p IS NULL
  THEN
    id_p := NULL;
    RETURN;
  END IF;

  metcvor_sifra_centra_l := pra_zmp_zaj.vrijednost_parametra ('0019'); -- IRN 1700
  IF metcvor_sifra_centra_l IS NULL THEN
    id_p := NULL;
    RETURN;
  END IF;

  IF UPPER (metcvor_sifra_centra_l) <> 'NEBITNO'
    AND metcvor_sifra_centra_l <> pra_zmp_zaj.tekuci_cvor
    AND pra_rec_s.centar_connected (metcvor_sifra_centra_l)
  THEN
    naredba_l :=
      'SELECT pra_zmp_zaj.i3_sekvenca@' || metcvor_sifra_centra_l || ' (:id_p) FROM DUAL';
    EXECUTE IMMEDIATE naredba_l INTO id_p USING id_p;

    naredba_l :=
      'INSERT INTO skc_vs_vpar@' || metcvor_sifra_centra_l || ' ( ' ||
      '    id, ' ||
      '    kcvs_id, ' ||
      '    sifra, ' ||
      '    opis) ' ||
      '  VALUES ( ' ||
      '    :id_p, ' ||
      '    :kcvs_id_p, ' ||
      '    :sifra_p, ' ||
      '    :opis_p) ';
    EXECUTE IMMEDIATE naredba_l USING id_p, kcvs_id_p, sifra_p, opis_p;
  END IF;

  IF pra_zmp_zaj.centar = -1
    OR UPPER (metcvor_sifra_centra_l) = 'NEBITNO'
    OR metcvor_sifra_centra_l = pra_zmp_zaj.tekuci_cvor
  THEN
    id_p := pra_zmp_zaj.i3_sekvenca (id_p);
    INSERT INTO skc_vs_vpar (
        id,
        kcvs_id,
        sifra,
        opis)
      VALUES (
        id_p,
        kcvs_id_p,
        sifra_p,
        opis_p);
  END IF;

EXCEPTION
  WHEN OTHERS THEN
    id_p := NULL;
    RAISE;
END;
PROCEDURE INSERT_PKAKAR
 (KCJED_ID_P IN mkc_jedinice.id%TYPE
 ,GOST_ID_P IN TKC_KARTICE.GOST_ID%TYPE
 ,KCKAR_BROJ_P IN TKC_KARTICE.BROJ%TYPE
 )
 IS
--
  kcsus_id_l mkc_sustavi.id%TYPE;
  kcsus_sifra_l mkc_sustavi.sifra%TYPE;
  kcsus_oznaka7_l mkc_sustavi.oznaka7%TYPE;
  CURSOR gost_c IS
    SELECT zmpojr.id AS zmpojr_id,
           gost.ozn_prisutnosti AS ozn_prisutnosti,
           gost.dat_dolaska AS dat_dolaska,
           gost.dat_odlaska AS dat_odlaska,
           gost.god_poslovna AS god_poslovna,
           gost.rbr AS rbr,
           gost.ime AS ime,
           gost.prezime AS prezime,
           so.sifra AS so_sifra,
           sj.broj AS sj_broj,
           pon.nac_id AS nac_id, -- IRN 1264
           pon.stopa_popusta_pos AS stopa_popusta_pos1, -- IRN 1264
           -- IRN 3105
           recagost.stopa_popusta_pos AS recagost_stopa_popusta_pos,
           TO_NUMBER (pra_pka_zaj.vrijednost_parametra ('1048'), '99D99', 'NLS_NUMERIC_CHARACTERS = '',.''') AS param_stopa_popusta_pos,
           ms.ozn_loyalty AS ms_ozn_loyalty,
           gost.sj_id AS sj_id
      FROM t_gosti gost,
           m_sj sj,
           m_so so,
           mzmp_ojr zmpojr,
           t_pon_so ponso, -- IRN 1264
           t_pon_ojr ponojr,
           t_ponude pon,
           trec_agostiju recagost,
           m_msegmenti ms
     WHERE gost.id = gost_id_p
       AND gost.sj_id = sj.id
       AND sj.so_id = so.id  -- 06.06.2007. G.J.
       AND so.ojr_id = zmpojr.id  -- 05.11.2007 MK
       AND gost.ponso_id = ponso.id(+) -- IRN 1264
       AND ponso.ponojr_id = ponojr.id(+)
       AND ponojr.pon_id = pon.id(+)
       AND gost.recagost_id = recagost.id(+)
       AND gost.ms_id = ms.id;
  gost_c_l gost_c%ROWTYPE;
  pkakar_ozn_izvan_oj_l tpka_kartice.ozn_izvan_oj%TYPE;
  stopa_popusta_pos2_l tpka_kartice.stopa_popusta_pos2%TYPE; -- IRN 3105
BEGIN
  IF kcjed_id_p IS NULL
    OR gost_id_p IS NULL
    OR kckar_broj_p IS NULL
  THEN
    RETURN;
  END IF;

  -- IRN 1836; Za svaku Key Card koju koristi gost automatski izraditi Pay Card: Da/Ne.
  SELECT kcsus.id, kcsus.sifra, kcsus.oznaka7 INTO kcsus_id_l, kcsus_sifra_l, kcsus_oznaka7_l
    FROM mkc_sustavi kcsus,
         mkc_jedinice kcjed
   WHERE kcjed.id = kcjed_id_p
     AND kcjed.kcsus_id = kcsus.id;
  IF kcsus_oznaka7_l = -1 THEN
    NULL;
  ELSE
    RETURN;
  END IF;

  OPEN gost_c;
  FETCH gost_c INTO gost_c_l;
  IF gost_c%NOTFOUND THEN
    CLOSE gost_c;
    RETURN;
  END IF;
  CLOSE gost_c;

  IF gost_c_l.ozn_prisutnosti = 'P'
    AND TRUNC (SYSDATE) BETWEEN gost_c_l.dat_dolaska AND gost_c_l.dat_odlaska
  THEN
    NULL;
  ELSE
    -- gost je odjavljen ili je tekui datum izvan boravka gosta
    RETURN;
  END IF;

  -- PKA 1038 => Duljina podatka PIN: 0 ili 4.
  IF pra_pka_zaj.vrijednost_parametra ('1038') IN ('4') THEN
    -- Pay Card treba PIN
    RETURN;
  END IF;

  -- PKA 1037 => Izdajem kartice koje se mogu koristiti u drugim OJ: da ili ne.
  IF UPPER (pra_pka_zaj.vrijednost_parametra ('1037')) IN ('DA') THEN
    pkakar_ozn_izvan_oj_l := -1;
  ELSE
    pkakar_ozn_izvan_oj_l := 0;
  END IF;

  /*
  IRN 3105
  LoyaltyInSky (LIS); svim gostima u SJ (koji pripadaju loyalty MS) kod izrade Pay Card upisati
  stopu popusta za POS koju ima lan programa vjernosti smjeten u toj istoj SJ
  LOY 1017 => Oznaka vrste programa vjernosti
  IRN 4108
  Dodana vrsta programa vjernosti BECRM = Be-terna CRM
  */
  IF pra_zmp_zaj.zmppar_vrijednost ('LOY', '1017') IN ('LIS', 'BECRM') THEN
    IF gost_c_l.ms_ozn_loyalty = -1 THEN
      IF gost_c_l.recagost_stopa_popusta_pos IS NOT NULL THEN
        stopa_popusta_pos2_l := gost_c_l.recagost_stopa_popusta_pos;
        -- auriraj stopu popusta na karticima gostiju prijavljenih prije lana
        FOR c IN (
          SELECT gost.id
            FROM t_gosti gost,
                 m_msegmenti ms
           WHERE gost.ms_id = ms.id
             AND ms.ozn_loyalty = -1
             AND gost.sj_id = gost_c_l.sj_id
             AND gost.dat_dolaska < gost_c_l.dat_odlaska
             AND gost.dat_odlaska > gost_c_l.dat_dolaska
          )
        LOOP
          UPDATE tpka_kartice
             SET stopa_popusta_pos2 = stopa_popusta_pos2_l
           WHERE oznaka = 'V'
             AND gost_id = c.id
             AND NVL (stopa_popusta_pos2, 0) = 0;
        END LOOP;
      ELSE
        SELECT MAX (recagost.stopa_popusta_pos) INTO stopa_popusta_pos2_l
          FROM t_gosti gost,
               trec_agostiju recagost,
               m_msegmenti ms
         WHERE gost.recagost_id = recagost.id
           AND gost.ms_id = ms.id
           AND ms.ozn_loyalty = -1
           AND gost.sj_id = gost_c_l.sj_id
           AND gost.dat_dolaska < gost_c_l.dat_odlaska
           AND gost.dat_odlaska > gost_c_l.dat_dolaska;
      END IF;
      stopa_popusta_pos2_l := NVL (stopa_popusta_pos2_l, gost_c_l.param_stopa_popusta_pos);
    ELSE
      -- nije loy MS
      stopa_popusta_pos2_l := gost_c_l.param_stopa_popusta_pos;
    END IF;
  ELSE
    -- Oznaka vrste programa vjernosti nije LIS
    stopa_popusta_pos2_l := NVL (gost_c_l.recagost_stopa_popusta_pos, gost_c_l.param_stopa_popusta_pos);
  END IF;

  INSERT INTO tpka_kartice (
      zmpojr_id,
      gost_id,
      broj,
      oznaka,
      ozn_izvan_oj,
      nac_id,  -- 17.12.2007. G.J.
      stopa_popusta_pos1,
      stopa_popusta_pos2,
      kcsus_id, -- IRN 1836
      ozn_prepaid, -- IRN 2527
      ozn_nfc) -- IRN 2735
    VALUES (
      gost_c_l.zmpojr_id,
      gost_id_p,
      kckar_broj_p,
      'V',
      pkakar_ozn_izvan_oj_l,
      gost_c_l.nac_id,
      gost_c_l.stopa_popusta_pos1,
      stopa_popusta_pos2_l, -- IRN 3105
      kcsus_id_l, -- IRN 1836
      0,  -- IRN 2527; 0 = Postpaid
      0); -- IRN 2735; 0 = nije NFC

EXCEPTION
  WHEN OTHERS THEN
    /*
    Neuspjela izrada Pay Card iz Key Card (
    ifra KC sustava; broj kartice; poslovna godina; redni broj gosta; ime gosta; prezime gosta; ifra SO; broj SJ; datum dolaska, datum odlaska, opis greke)
    */
    pra_rec.puni_promjene (
      '0008',
      SUBSTR (
        kcsus_sifra_l || '; ' || -- IRN 1836
          kckar_broj_p || '; ' ||
          gost_c_l.god_poslovna || '; ' ||
          gost_c_l.rbr || '; ' ||
          gost_c_l.ime || '; ' ||
          gost_c_l.prezime || '; ' ||
          gost_c_l.so_sifra || '; ' ||
          gost_c_l.sj_broj || '; ' ||
          TO_CHAR (gost_c_l.dat_dolaska, 'DD.MM.RRRR') || '; ' ||
          TO_CHAR (gost_c_l.dat_odlaska, 'DD.MM.RRRR') || '; ' ||
          SQLERRM,
        1,
        2000),
      0);
END;
PROCEDURE PONISTI_PKAKAR
 (KCJED_ID_P IN mkc_jedinice.id%TYPE
 ,GOST_ID_P IN t_gosti.id%TYPE
 ,KCKAR_BROJ_P IN tkc_kartice.broj%TYPE
 )
 IS
--
  kcsus_oznaka7_l mkc_sustavi.oznaka7%TYPE;
BEGIN
  IF kcjed_id_p IS NULL
    OR gost_id_p IS NULL
    OR kckar_broj_p IS NULL
  THEN
    RETURN;
  END IF;

  -- IRN 1836; Za svaku Key Card koju koristi gost automatski izraditi Pay Card: Da/Ne.
  SELECT kcsus.oznaka7 INTO kcsus_oznaka7_l
    FROM mkc_sustavi kcsus,
         mkc_jedinice kcjed
   WHERE kcjed.id = kcjed_id_p
     AND kcjed.kcsus_id = kcsus.id;
  IF kcsus_oznaka7_l = -1 THEN
    NULL;
  ELSE
    RETURN;
  END IF;

  UPDATE tpka_kartice
     SET oznaka = 'P'
   WHERE gost_id = gost_id_p
     AND UPPER (broj) = UPPER (kckar_broj_p) -- IRN 2999 dodan UPPER
     AND oznaka = 'V';

END;
PROCEDURE POST_KCZAH
 (VLASNIKPODATKA_P IN NUMBER
 ,KCZAH_ID_P IN tkc_zahtjevi.id%TYPE
 )
 IS
-- IRN 2834
  timeout_l  szmp_parametri.vrijednost%TYPE;
  url_l      s_parametri_prijepisa.staza%TYPE;
  username_l szmp_parametri.vrijednost%TYPE;
  password_l szmp_parametri.vrijednost%TYPE;
  --
  req_l UTL_HTTP.req;
  res_l UTL_HTTP.resp;
BEGIN

  IF vlasnikpodatka_p IS NULL OR kczah_id_p IS NULL THEN
    RETURN;
  END IF;

  -- Timeout za KcApi servis ili nebitno.
  timeout_l := pra_zmp_zaj.vrijednost_parametra ('0080');
  IF timeout_l = 'nebitno' THEN
    RETURN;
  END IF;

  -- URL KcApi servisa (npr. http://dperkovic-w10:9000/kc/zahtjev/)
  SELECT MIN (staza) INTO url_l FROM s_parametri_prijepisa WHERE sifra = 'KCAPI';
  IF url_l IS NULL THEN
    RETURN;
  END IF;

  -- Korisniko ime za KcApi servis ili nebitno.
  username_l := pra_zmp_zaj.vrijednost_parametra ('0903');
  IF username_l = 'nebitno' THEN
    RETURN;
  END IF;

  -- Lozinka za KcApi servis ili nebitno.
  password_l := pra_zmp_zaj.vrijednost_parametra ('0904');
  IF password_l = 'nebitno' THEN
    RETURN;
  END IF;

  UTL_HTTP.set_transfer_timeout (timeout => timeout_l);
  UTL_HTTP.set_body_charset (charset => 'UTF-8');
  url_l := url_l || vlasnikpodatka_p || '/' || kczah_id_p;
  req_l := UTL_HTTP.begin_request (url => url_l, method => 'POST', http_version => 'HTTP/1.1');
  UTL_HTTP.set_header (r => req_l, name => 'Content-Type', value => 'application/json; charset=utf-8');
  UTL_HTTP.set_header (req_l, 'Authorization', 'Basic ' || UTL_RAW.cast_to_varchar2 (UTL_ENCODE.base64_encode (UTL_RAW.cast_to_raw (username_l || ':' || password_l))));

  res_l := UTL_HTTP.get_response (req_l);
  IF res_l.status_code = UTL_HTTP.HTTP_OK THEN
    NULL;
  ELSE
    pra_rec.puni_promjene ('0040', 'url: ' || url_l || ' | ' || res_l.status_code, 0);
  END IF;
  UTL_HTTP.end_response (res_l);

EXCEPTION
  WHEN OTHERS THEN
    pra_rec.puni_promjene ('0040', SQLCODE || ': ' || SQLERRM, 0);
    UTL_HTTP.end_response (res_l);
END;
PROCEDURE AZURIRAJ_MKC_SUS_PAR
 (KCSUS_ID_P IN MKC_SUSTAVI.ID%TYPE
 ,KCVS_ID_P IN MKC_SUSTAVI.KCVS_ID%TYPE
 )
 IS
-- IRN 3901; procedura se poziva iz AUS_MKC_SUSTAVI
  CURSOR mkc_sus_par_c IS
    SELECT mkc_sus_par.kcvsvpar_id, skc_vs_vpar.sifra, skc_vs_vpar.opis
      FROM mkc_sus_par, skc_vs_vpar
     WHERE mkc_sus_par.kcsus_id = kcsus_id_p
       AND mkc_sus_par.kcvsvpar_id = skc_vs_vpar.id
       FOR UPDATE OF mkc_sus_par.kcvsvpar_id;

  CURSOR skc_vs_vpar_c (
    kcvs_id_l IN mkc_sustavi.kcvs_id%TYPE,
    sifra_l skc_vs_vpar.sifra%TYPE)
  IS
    SELECT id, sifra , opis
      FROM skc_vs_vpar
     WHERE kcvs_id = kcvs_id_l
       AND sifra = sifra_l;
  skc_vs_vpar_c_l  skc_vs_vpar_c%ROWTYPE;

  new_par_id_l     NUMBER;
BEGIN

  FOR par_c IN mkc_sus_par_c LOOP
    new_par_id_l := NULL;
    OPEN skc_vs_vpar_c (kcvs_id_p, par_c.sifra);
    FETCH skc_vs_vpar_c INTO skc_vs_vpar_c_l;
    IF skc_vs_vpar_c%NOTFOUND THEN
      pra_rec_kc_iud.insert_kcvsvpar (kcvs_id_p, par_c.sifra, par_c.opis, new_par_id_l);
      DBMS_LOCK.sleep (3/10);
    ELSE
      new_par_id_l := skc_vs_vpar_c_l.id;
    END IF;

    UPDATE mkc_sus_par
       SET kcvsvpar_id = new_par_id_l
     WHERE CURRENT OF mkc_sus_par_c;

    CLOSE skc_vs_vpar_c;
  END LOOP;

END;

END PRA_REC_KC_IUD;
/
SHOW ERROR

