-- C:\mish_cvs\misH_skripte\pra_pso_api.pkb
--
-- Generated for Oracle 10g on Thu Jun 26  13:53:16 2025 by Server Generator 6.5.96.5.6
 

PROMPT Creating Package Body 'PRA_PSO_API'
CREATE OR REPLACE PACKAGE BODY PRA_PSO_API IS

FUNCTION R_PSO_ASO_KASE
 (KASA_P VARCHAR2
 ,NACPOT_P VARCHAR2
 ,JEZ_3A_P VARCHAR2
 )
 RETURN SYS_REFCURSOR
 IS
  CURSOR nac_id_c(nacpot_p VARCHAR2) IS
  SELECT nac.id
    FROM m_nacpot nac
   WHERE nac.sifra = nacpot_p;
  
  CURSOR kasa_id_c(kasa_p VARCHAR2) IS
  SELECT k.id
    FROM mgmp_kase k
   WHERE k.sifra = kasa_p;
  
  nac_id_l  M_NACPOT.ID%type;
  kasa_id_l MGMP_KASE.ID%TYPE;
  jez_3a_l  S_JEZICI.SIFRA_3A%TYPE;
  l_rc SYS_REFCURSOR;
BEGIN
  IF JEZ_3A_P IS NULL THEN
    jez_3a_l := pra_zmp_zaj.zmppar_vrijednost ('ZMP', '0014');
  ELSE
    jez_3a_l := JEZ_3A_P; 
  END IF;
    
  -- nacin placanja
  OPEN nac_id_c(nacpot_p);
  FETCH nac_id_c
	INTO nac_id_l;
  CLOSE nac_id_c;

  IF nac_id_l IS NULL THEN
    -- Ne postoji nain potronje: #0
    gas_zaj.vrati_poruku (-20508, nacpot_p);
  END IF;

   -- kasa
  OPEN kasa_id_c(kasa_p);
  FETCH kasa_id_c
	INTO kasa_id_l;
  CLOSE kasa_id_c;

  IF kasa_id_l IS NULL THEN
    -- Ne postoji kasa: #0
    gas_zaj.vrati_poruku (-20508, kasa_p);
  END IF;
  
  BEGIN
    pra_zmp_context.set_parameter('context_parametar','jez_sif_l',jez_3a_l);
    pra_zmp_context.set_parameter('context_parametar','kase_id_l',kasa_id_l);
    pra_zmp_context.set_parameter('context_parametar','nac_id_l',nac_id_l);
    pra_zmp_context.set_parameter('context_parametar','gpro_id_l',null);
  END;

  OPEN l_rc FOR
   'select pro_sifra code,
           pro_naziv name ,
           pc price
      from v_pso_aso_kase_jez
      order by 1';

  RETURN l_rc;
END;
FUNCTION R_PSO_ASO_LOK
 (LOK_ID_P IN VARCHAR2
 ,JEZ_3A_P IN VARCHAR2
 )
 RETURN SYS_REFCURSOR
 IS
 CURSOR lok_id_c(lok_id_p VARCHAR2) IS
  SELECT lok.kase_sifra, lok.nac_sifra
    FROM v_pso_lokacije lok
   WHERE lok.id = lok_id_p;

  kase_sifra_l  mgmp_kase.sifra%type;
  nac_sifra_l m_nacpot.sifra%type;
  l_rc SYS_REFCURSOR;
BEGIN
  -- lokacija
  OPEN lok_id_c(lok_id_p);
  FETCH lok_id_c
	INTO kase_sifra_l, nac_sifra_l;
  CLOSE lok_id_c;

  IF kase_sifra_l IS NULL THEN
    -- Ne postoji lokacija: #0
    gas_zaj.vrati_poruku (-20508, lok_id_p);
  END IF;
 
  l_rc := PRA_PSO_API.R_PSO_ASO_KASE(kase_sifra_l,nac_sifra_l,JEZ_3A_P);
  RETURN l_rc;
END;
FUNCTION R_PSO_LOKACIJE
 (OJ_P IN VARCHAR2
 )
 RETURN SYS_REFCURSOR
 IS
 CURSOR oj_id_c(oj_p VARCHAR2) IS
  SELECT oj.id ojr_id
    FROM mzmp_ojr ojr, m_oj oj
   WHERE oj.id = ojr.id
     AND oj.sifra = oj_p;

  oj_id_l  m_oj.ID%type;
  l_rc SYS_REFCURSOR;
BEGIN
  -- objekt/knjiga rauna
  OPEN oj_id_c(oj_p);
  FETCH oj_id_c
     INTO oj_id_l;
  CLOSE oj_id_c;

  IF oj_id_l IS NULL THEN
    -- Ne postoji OJ/kniga rauna: #0
    gas_zaj.vrati_poruku (-20524, oj_p);
  END IF;

  OPEN l_rc FOR
    SELECT lok.id  location_id,
           lok.sifra      location_code,
           lok.naziv      location_name,
           lok.kase_sifra pos_code,
           lok.kase_naziv pos_name
      FROM v_pso_lokacije lok
     WHERE lok.zmpojr_id = oj_id_l
       AND nvl(lok.ozn_pso_sustava, nvl(lok.ozn_pso_sustava_gr,'M')) = 'V';

  RETURN l_rc;
END;
PROCEDURE ISRT_TPSO_NARUDZBE
 (BR_NAR_P IN tpso_narudzbe.br_nar%TYPE
 ,DATUM_P IN tpso_narudzbe.datum%TYPE
 ,VRIJEME_P IN tpso_narudzbe.vrijeme_isporuke%TYPE
 ,LOK_ID_P IN mpso_lokacije.id%TYPE
 ,VPLA_P IN s_vplacanja.sifra%TYPE
 ,OZN_PLACANJA_P IN VARCHAR2
 ,NAPOMENA_P IN tpso_narudzbe.napomena%TYPE
 ,IZN_NAPOJNICE_P IN tpso_narudzbe.izn_napojnice%TYPE
 ,KASA_SIFRA_P OUT mgmp_kase.sifra%TYPE
 ,ID_P OUT tpso_narudzbe.id%TYPE
 )
 IS
 CURSOR lok_id_c(lokacija_p VARCHAR2) IS
    SELECT lok.id, lok.kase_id, lok.oj_sifra, lok.kase_sifra
      FROM v_pso_lokacije lok
     WHERE lok.id = lok_id_p;

   CURSOR vpla_id_c(vpla_p VARCHAR2) IS
    SELECT t.id  FROM s_vplacanja t WHERE t.sifra = vpla_p;

   id_l          NUMBER;
   lok_id_l      mpso_lokacije.id%TYPE;
   kase_id_l     mpso_lokacije.kase_id%TYPE;
   kasa_sifra_l mgmp_kase.sifra%TYPE;
   godina_l      tpso_narudzbe.godina%TYPE;
   vpla_id_l     s_vplacanja.id%TYPE;
   oj_sifra_l    m_oj.sifra%TYPE;
   ozn_placanja_l tpso_narudzbe.ozn_placanja%TYPE;
BEGIN

  IF pra_zmp_zaj.centar = 0
  THEN
     -- Samo centar aurira po mrei
    pra_zmp_zaj.vrati_poruku (-20142);
  END IF;

   -- Pogresna vrijednost ulaznog parametra (#0)!
  IF lok_id_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'lokacija');
  ELSIF datum_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'datum');
  ELSIF br_nar_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'broj narudbe');
  END IF;
  
  IF upper(ozn_placanja_p) = 'TRUE' THEN
    ozn_placanja_l := -1;
  ELSE
    ozn_placanja_l := 0;
  END IF;    

   OPEN lok_id_c(lok_id_p);
  FETCH lok_id_c
   INTO lok_id_l, kase_id_l, oj_sifra_l, kasa_sifra_l;
  CLOSE lok_id_c;

  IF lok_id_l IS NULL THEN
     gas_zaj.vrati_poruku (-20508, lok_id_l);
  END IF;

  IF pra_zmp_s.oznaka1 ('P0052',oj_sifra_l) = 0 THEN
    -- Nedoputen pristup!
    pra_zmp_zaj.vrati_poruku (-20138);
  END IF;

  OPEN vpla_id_c(vpla_p);
  FETCH vpla_id_c
   INTO vpla_id_l;
  CLOSE vpla_id_c;

  godina_l := to_char(datum_p,'YYYY');

  id_l := gas_zaj.sekvenca(NULL);

  INSERT INTO tpso_narudzbe
     (id, psolok_id, godina, datum, vrijeme_isporuke, vpla_id, napomena, ozn_valjanosti, ozn_placanja, br_nar, izn_napojnice)
  VALUES
     (id_l, lok_id_l, godina_l, datum_p, vrijeme_p, vpla_id_l, napomena_p, 'V', ozn_placanja_l, br_nar_p, izn_napojnice_p);

  id_p := id_l;   
  kasa_sifra_p := kasa_sifra_l;
END;
PROCEDURE ISRT_TPSO_NAR_PRO
 (PSONAR_ID_P IN tpso_nar_pro.psonar_id%TYPE
 ,ART_P IN m_proizvodi.sifra%TYPE
 ,KOLICINA_P IN tpso_nar_pro.kolicina%TYPE
 ,CIJENA_P IN tpso_nar_pro.cijena%TYPE
 ,NAPOMENA_P IN tpso_nar_pro.napomena%TYPE
 )
 IS
  CURSOR pro_id_c(art_p VARCHAR2) IS
    SELECT p.id FROM m_proizvodi p WHERE p.sifra = art_p;

  pro_id_l m_proizvodi.id%TYPE;
  stavka_l tpso_nar_pro.stavka%TYPE;
BEGIN
  IF pra_zmp_zaj.centar = 0 THEN
  -- Samo centar aurira po mrei
    pra_zmp_zaj.vrati_poruku(-20142);
  END IF;

  -- Pogrena vrijednost ulaznog parametra (#0)!
  IF psonar_id_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku(-20099, 'narudba');
  ELSIF art_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku(-20099, 'proizvod');
  ELSIF kolicina_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku(-20099, 'koliina');
  ELSIF cijena_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku(-20099, 'cijena');
  END IF;

  -- ID proizvoda
  OPEN pro_id_c(art_p);
  FETCH pro_id_c
   INTO pro_id_l;
  CLOSE pro_id_c;

  -- ako ne postoji arikal
  IF pro_id_l IS NULL THEN
     gas_zaj.vrati_poruku (-20509, art_p);
  END IF;

  -- insert stavke

  SELECT NVL(MAX(TO_NUMBER(stavka)), 0)
    INTO stavka_l
    FROM tpso_nar_pro st
   WHERE st.psonar_id = psonar_id_p;

  INSERT INTO tpso_nar_pro
    (psonar_id, stavka, pro_id, kolicina, cijena, napomena)
  VALUES
    (psonar_id_p, stavka_l + 1, pro_id_l, kolicina_p, cijena_p, napomena_p);

END;
PROCEDURE POSALJI_OBAVIJEST
 (NAR_ID_P IN tpso_narudzbe.id%TYPE
 ,KASA_SIFRA_P IN mgmp_kase.sifra%TYPE
 )
 IS

  kasa_sifra_l VARCHAR2(50);
  poruka_l   VARCHAR2(50);
  id_l NUMBER := 7642533;
  tema_l  apex_t_varchar2;
BEGIN
  poruka_l := 'Imate novu narudbu';
  kasa_sifra_l := 'narudzba'|| kasa_sifra_p;
  tema_l := apex_t_varchar2(kasa_sifra_l);
  
  pra_pso_apex.posalji_obavijest(id_l, tema_l, poruka_l, NULL, nar_id_p);
  
END;

END PRA_PSO_API;
/
SHOW ERROR

