-- C:\mish_cvs\misH_skripte\pra_pso_apex.pkb
--
-- Generated for Oracle 10g on Mon May 26  20:29:44 2025 by Server Generator 6.5.96.5.6
 

PROMPT Creating Package Body 'PRA_PSO_APEX'
CREATE OR REPLACE PACKAGE BODY PRA_PSO_APEX IS

FUNCTION VRATI_URL
 (LOK_ID_P IN MPSO_LOKACIJE.ID%TYPE
 )
 RETURN VARCHAR2
 IS
  url_l mpso_lokacije.url_adresa%TYPE;
BEGIN
   -- uzima URL adresu iz lokacije ako je definirana
   BEGIN
     SELECT t.url_adresa
       INTO url_l
       FROM mpso_lokacije t
      WHERE t.id = lok_id_p;
   EXCEPTION
     WHEN OTHERS THEN
       url_l:= NULL;
   END;
   -- ako URL adresa nije definirana u lokaciji, uzima iz parametra
   IF url_l IS NULL
   THEN
     url_l := pra_zmp_zaj.ZMPPAR_VRIJEDNOST('PSO','0002');
   END IF;
   RETURN url_l;
END vrati_url;
PROCEDURE POSALJI_OBAVIJEST
 (ID_P IN NUMBER
 ,TEMA_P IN apex_t_varchar2
 ,PORUKA_P IN VARCHAR2
 ,BROJ_SOBE_P IN VARCHAR2 := null
 ,NAR_ID_P IN tpso_narudzbe.id%TYPE := null
 )
 IS
  TYPE cursor_t IS REF CURSOR;
  stavka_c cursor_t;

  response_l      CLOB;
  naredba_l       VARCHAR2(550);
  web_service_exc EXCEPTION;
  PRAGMA exception_init( web_service_exc, -20001 );
  
  cvor_l       smet_cvorovi.sifra%TYPE;
  nar_datum_l  tpso_narudzbe.datum%TYPE;
  sj_broj_l    m_sj.broj%TYPE := broj_sobe_p;
  nar_rbr_l    tpso_narudzbe.rbr%TYPE;
  kasa_sifra_l mgmp_kase.sifra%TYPE;
  napomena_l   tpso_narudzbe.napomena%TYPE;
  total_l      NUMBER;
  
  pro_naziv_l       m_proizvodi.naziv%TYPE;
  kolicina_l        NUMBER;
  jed_cijena_l      NUMBER;
  cijena_l          NUMBER;
  napomena_stavka_l tpso_nar_pro.napomena%TYPE;
BEGIN
  apex_web_service.g_request_headers(1).name := 'Content-Type';
  apex_web_service.g_request_headers(1).value := 'application/json';

  apex_json.initialize_clob_output;

  apex_json.open_object;
  apex_json.write('id', id_p);
  
  apex_json.open_array('topic');
  FOR i IN 1..tema_p.COUNT
  LOOP
    apex_json.write(tema_p(i));
  END LOOP;
  apex_json.close_array;
  
  apex_json.write('message', poruka_p);

  IF nar_id_p IS NOT null THEN
    SELECT
      nar.unos_dat,
      NVL(ojr.metcvor_sifra_gas, ojr.metcvor_sifra),
      NVL(sj.broj, nar.br_sobe),
      nar.rbr,
      kasa.sifra,
      nar.napomena,
      SUM(narp.cijena*narp.kolicina) AS total
    INTO
      nar_datum_l,
      cvor_l,
      sj_broj_l,
      nar_rbr_l,
      kasa_sifra_l,
      napomena_l,
      total_l
    FROM tpso_narudzbe nar
    JOIN mpso_lokacije lok ON
      lok.id = nar.psolok_id
    JOIN mgmp_kase kasa ON
      kasa.id = lok.kase_id
    JOIN mzmp_ojr ojr ON
      ojr.id = lok.zmpojr_id
    LEFT OUTER JOIN m_sj sj ON
      sj.id = lok.sj_id
    JOIN tpso_nar_pro narp ON
      narp.psonar_id = nar.id
    WHERE
      nar.id = nar_id_p
    GROUP BY
      nar.unos_dat,
      NVL(ojr.metcvor_sifra_gas, ojr.metcvor_sifra),
      NVL(sj.broj, nar.br_sobe),
      nar.rbr,
      kasa.sifra,
      nar.napomena;

    naredba_l := REPLACE('
      SELECT
        aso.pro_naziv AS proizvod,
        narp.kolicina,
        aso.pc AS jed_cijena,
        aso.pc*narp.kolicina AS cijena,
        narp.napomena
      FROM tpso_nar_pro narp
      JOIN tpso_narudzbe nar ON
        nar.id = narp.psonar_id
      JOIN mpso_lokacije lok ON
        lok.id = nar.psolok_id
      JOIN v_pso_aso_kase_cvor<CVOR> aso ON
        aso.pro_id = narp.pro_id
        AND aso.kase_id = lok.kase_id
        AND aso.nac_id = lok.nac_id
      WHERE
        narp.psonar_id = :nar_id', '<CVOR>', '@'||cvor_l);

    apex_json.write('kasa',         kasa_sifra_l);
    apex_json.write('brojNarudzbe', nar_rbr_l);
    apex_json.write('kreirano',     nar_datum_l);
    apex_json.write('brojSobe',     sj_broj_l);
    apex_json.write('total',        total_l);
    apex_json.write('napomena',     napomena_l);
    apex_json.open_array('stavke');

    OPEN stavka_c FOR naredba_l USING nar_id_p;
    LOOP
      FETCH stavka_c INTO pro_naziv_l, kolicina_l, jed_cijena_l, cijena_l, napomena_stavka_l;
      EXIT WHEN stavka_c%NOTFOUND;

      apex_json.open_object;
      apex_json.write('naziv',     pro_naziv_l);
      apex_json.write('kolicina',  kolicina_l);
      apex_json.write('cijena',    jed_cijena_l);
      apex_json.write('iznos',     cijena_l);
      apex_json.write('napomena',  napomena_stavka_l);
      apex_json.close_object;
    END LOOP;

    apex_json.close_array;
  END IF;

  apex_json.close_object;

  response_l := apex_web_service.make_rest_request(
    p_url         => pra_zmp_zaj.zmppar_vrijednost( 'PSO', '0001' ),
    p_http_method => 'POST',
    p_body        => apex_json.get_clob_output
  );

  apex_json.free_output;

  IF apex_web_service.g_status_code <> 200 THEN
    apex_json.parse( response_l );
    response_l := apex_json.get_varchar2( p_path => 'message' );
    raise_application_error( -20001, response_l);
  END IF;
END;
/* PUNI_COLL_GPRO */
PROCEDURE PUNI_COLL_GPRO
 (KASA_ID_P IN NUMBER
 ,NAC_ID_P IN NUMBER
 ,JEZIK_3A_P IN VARCHAR2
 )
 IS
 TYPE gpro_type IS RECORD(
        ord     NUMBER,
        id      m_gproizvoda.id%TYPE,
        gpro_id m_gproizvoda.grpro_id%TYPE,
        sifra   m_gproizvoda.sifra%TYPE,
        naziv   m_grpro_jez.naziv%TYPE,
        rbr     m_gproizvoda.rbr%TYPE,
        ind_aso NUMBER);
   gpro_l       gpro_type;
   curs_l       SYS_REFCURSOR;
   coll_naziv_l VARCHAR2(5) := 'GRUPE';
BEGIN
  apex_collection.create_or_truncate_collection(coll_naziv_l);
  curs_l := pra_pso_apex.r_pso_aso_kase(kasa_id_p, nac_id_p, jezik_3a_p);

  LOOP
   FETCH curs_l
    INTO gpro_l;
    EXIT WHEN curs_l%NOTFOUND;

   apex_collection.add_member(p_collection_name => coll_naziv_l,
                              p_c001            => gpro_l.id,
                              p_c002            => gpro_l.gpro_id,
                              p_c003            => gpro_l.sifra,
                              p_c004            => gpro_l.naziv,
                              p_n001            => gpro_l.ord,
                              p_n002            => gpro_l.rbr,
                              p_n003            => gpro_l.ind_aso);
  END LOOP;
END;
FUNCTION R_PSO_ASO_KASE
 (KASA_ID_P IN NUMBER
 ,NAC_ID_P IN NUMBER
 ,JEZIK_3A_P IN VARCHAR2
 )
 RETURN SYS_REFCURSOR
 IS
  l_rc SYS_REFCURSOR;
  cvor_l smet_cvorovi.sifra%TYPE;
BEGIN
  
  SELECT LOWER (NVL (ojr.metcvor_sifra_gas, ojr.metcvor_sifra))
    INTO cvor_l
    FROM mgmp_kase k, mzmp_ojr ojr
   WHERE ojr.id = k.zmpojr_id
     AND k.id = kasa_id_p;
   
  BEGIN
    pra_zmp_context.set_parameter('context_parametar','jez_sif_l',jezik_3a_p);
    pra_zmp_context.set_parameter('context_parametar','kase_id_l',kasa_id_p);
    pra_zmp_context.set_parameter('context_parametar','nac_id_l',nac_id_p);
    pra_zmp_context.set_parameter('context_parametar','gpro_id_l',null);
  END; 
  
  OPEN l_rc FOR
   'SELECT tt.ord, tt.id, tt.gpro_id, tt.sifra, tt.naziv, tt.rbr, tt.ind_aso
     FROM
     (SELECT t.ord, t.id, t.gpro_id, t.sifra, t.naziv, t.rbr, t.ind_aso
        FROM (SELECT rownum ord,
                 gpro.id,
                 gpro.grpro_id AS gpro_id,
                 gpro.sifra,
                 COALESCE ( -- 1. naziv na jeziku iz context-a, 2. naziv na eng ako jezik iz context-a <> domaeg jezika, 3. naziv na domaem jeziku, 4. naziv
                  (SELECT gprojez.naziv FROM m_grpro_jez gprojez WHERE gprojez.grpro_id = gpro.id AND gprojez.jez_id = jez.ctx_jez_id),
                  (SELECT gprojez.naziv FROM m_grpro_jez gprojez WHERE gprojez.grpro_id = gpro.id AND gprojez.jez_id = jez.eng_jez_id AND jez.ctx_jez_id IS NOT NULL AND jez.ctx_jez_id <> jez.dom_jez_id),
                  (SELECT gprojez.naziv FROM m_grpro_jez gprojez WHERE gprojez.grpro_id = gpro.id AND gprojez.jez_id = jez.dom_jez_id),gpro.naziv) AS naziv,
                 gpro.rbr,
                 -- da li ima proizvoda za kasu i nain potronje ako su definirani context-om za grupe hijerahijski ispod
                 CASE WHEN (SELECT COUNT(1)
                             FROM m_gproizvoda gr
                            WHERE TRUNC (SYSDATE) BETWEEN gr.datum_valjan AND
                                   nvl(gr.datum_ponisten, TRUNC (SYSDATE))
                              AND EXISTS (SELECT NULL
                                            FROM v_pso_aso_kase@' ||cvor_l|| ' t
                                           WHERE t.kase_id = NVL (pra_zmp_context.get_parameter(''kase_id_l''),t.kase_id)
                                            AND t.nac_id  = NVL (pra_zmp_context.get_parameter(''nac_id_l''),t.nac_id)
                                            AND t.gpro_id = gr.id)
                            START WITH nvl(grpro_id, 0) = gpro.id
                          CONNECT BY PRIOR gr.id = gr.grpro_id) > 0 OR asok.br > 0
                THEN  1 ELSE  0 END  ind_aso
           FROM m_gproizvoda gpro,
                ( -- vraa vrijednosti ifre jezika iz context-a ako je definiran, engleskog i ifre domaeg jezika
                SELECT
                  (SELECT id FROM s_jezici WHERE sifra_3a = pra_zmp_context.get_parameter (''jez_sif_l'')) AS ctx_jez_id,
                  (SELECT id FROM s_jezici WHERE sifra_3a = ''eng'') AS eng_jez_id,
                  (SELECT id FROM s_jezici WHERE sifra_3a = pra_zmp_zaj.zmppar_vrijednost (''ZMP'', ''0014'')) AS dom_jez_id
                FROM dual
                ) jez,
                ( -- broj proizvoda po grupi iz asortimana za kasu i nain potronje ako su definirani context-om ili sve
                SELECT t.gpro_id, COUNT(t.gpro_id) br
                  FROM v_pso_aso_kase@' ||cvor_l|| ' t
                 WHERE t.kase_id = NVL (pra_zmp_context.get_parameter(''kase_id_l''), t.kase_id)
                   AND t.nac_id = NVL (pra_zmp_context.get_parameter(''nac_id_l''), t.nac_id)
                 GROUP BY t.gpro_id
                 ) asok
          WHERE trunc(SYSDATE) BETWEEN gpro.datum_valjan AND nvl(gpro.datum_ponisten, trunc(SYSDATE))
            AND asok.gpro_id(+) = gpro.id
          START WITH nvl(grpro_id, 0) = nvl(pra_zmp_context.get_parameter(''gpro_id_l''), 0)
        CONNECT BY PRIOR gpro.id = gpro.grpro_id
          ORDER SIBLINGS BY gpro.grpro_id, gpro.rbr) t  -- sortirano po rednom broju unutar grupe
     UNION ALL
      /* dodaje grupu za one proizvode iz asortimana koji nisu grupirani (gpro_id = -1),
          ako parametrom nije definirano da prikazuje samo grupirane proizvode (vrijednost PSO,0003 = da)
          za kasu i nain potronje ako su definirani context-om ili sve */
         SELECT 999, -1, NULL, ''-1'', ''...'', -1, 1
           FROM dual
          WHERE (SELECT COUNT(1) FROM v_pso_aso_kase@' ||cvor_l|| ' t WHERE t.gpro_id = -1
            AND t.KASE_ID = nvl(pra_zmp_context.get_parameter(''kase_id_l''), t.KASE_ID)
            AND t.NAC_ID = nvl(pra_zmp_context.get_parameter(''nac_id_l''), t.NAC_ID) ) > 0
            AND lower(pra_zmp_zaj.zmppar_vrijednost(''PSO'',''0003'')) <> ''da'') tt
   WHERE tt.ind_aso = 1';

  RETURN l_rc;
END;
FUNCTION MIN_VRIJEME_ISPORUKE
 (LOK_ID_P IN NUMBER
 ,MIN_VRIJEME_ISPORUKE_P IN NUMBER
 ,VRIJEME_ISPORUKE_P IN VARCHAR2
 ,DATUM_VRIJEME_UNOSA_NARUDZBE_P IN DATE := SYSDATE
 )
 RETURN BOOLEAN
 IS
 
  broj_l NUMBER;
  datum_vrijeme_isporuke_l DATE;
BEGIN
  datum_vrijeme_isporuke_l := TO_DATE( TO_CHAR( SYSDATE, 'DD.MM.RRRR ') || vrijeme_isporuke_p);

  SELECT COUNT(broj)
  INTO broj_l
  FROM (
    SELECT -1 AS broj -- radno vrijeme lokacije
    FROM mpso_lok_vrijeme lokv
    WHERE
      lokv.psolok_id = lok_id_p AND
      lokv.gpro_id IS NULL AND
      TO_CHAR(lokv.dat_poc, 'HH24:MI') > TO_CHAR(lokv.dat_zav, 'HH24:MI') AND
      vrijeme_isporuke_p < TO_CHAR(lokv.dat_zav, 'HH24:MI')
    UNION
    SELECT -1 AS broj -- radno vrijeme grupe
    FROM v_pso_lokacije lok
    JOIN mpso_lok_vrijeme glokv ON
      lok.psolok_id = glokv.psolok_id
    WHERE
      lok.id = lok_id_p AND
      glokv.gpro_id IS NULL AND
      TO_CHAR(glokv.dat_poc, 'HH24:MI') > TO_CHAR(glokv.dat_zav, 'HH24:MI') AND
      vrijeme_isporuke_p < TO_CHAR(glokv.dat_zav, 'HH24:MI') AND
      NOT EXISTS (SELECT COUNT(id) FROM mpso_lok_vrijeme WHERE psolok_id = lok_id_p AND gpro_id IS NULL));

  IF broj_l > 0 THEN
    datum_vrijeme_isporuke_l := datum_vrijeme_isporuke_l + 1;
  END IF;

  RETURN datum_vrijeme_isporuke_l >= TRUNC(datum_vrijeme_unosa_narudzbe_p, 'MI') + NUMTODSINTERVAL( min_vrijeme_isporuke_p, 'MINUTE' );

END MIN_VRIJEME_ISPORUKE;
FUNCTION RADNO_VRIJEME_LOKACIJE
 (LOK_ID_P IN NUMBER
 ,VRIJEME_P IN VARCHAR2 := NULL
 )
 RETURN BOOLEAN
 IS
BEGIN
  FOR c IN (
    SELECT 1 -- radno vrijeme lokacije
    FROM mpso_lok_vrijeme lokv
    WHERE
      lokv.psolok_id = lok_id_p AND
      lokv.gpro_id IS NULL AND (
        ( -- uobiajeno radno vrijeme
          NVL( vrijeme_p, TO_CHAR( sysdate, 'HH24:MI' )) >= TO_CHAR( lokv.dat_poc, 'HH24:MI' ) AND
          NVL( vrijeme_p, TO_CHAR( sysdate, 'HH24:MI' )) < TO_CHAR( lokv.dat_zav, 'HH24:MI' ) AND
          TO_CHAR( lokv.dat_poc, 'HH24:MI' ) < TO_CHAR( lokv.dat_zav, 'HH24:MI' )
        ) OR
        ( -- radno vrijeme koje prelazi pono
         (NVL( vrijeme_p, TO_CHAR( sysdate, 'HH24:MI' )) >= TO_CHAR( lokv.dat_poc, 'HH24:MI' ) OR
          NVL( vrijeme_p, TO_CHAR( sysdate, 'HH24:MI' )) < TO_CHAR( lokv.dat_zav, 'HH24:MI' )) AND
          TO_CHAR( lokv.dat_poc, 'HH24:MI' ) > TO_CHAR( lokv.dat_zav, 'HH24:MI' )
        )
      )
    UNION
    SELECT 1 -- radno vrijeme grupe
    FROM v_pso_lokacije lok
    JOIN mpso_lok_vrijeme glokv ON
      lok.psolok_id = glokv.psolok_id
    WHERE
      lok.id = lok_id_p AND
      glokv.gpro_id IS NULL AND (
        ( -- uobiajeno radno vrijeme
          NVL( vrijeme_p, TO_CHAR( sysdate, 'HH24:MI' )) >= TO_CHAR( glokv.dat_poc, 'HH24:MI' ) AND
          NVL( vrijeme_p, TO_CHAR( sysdate, 'HH24:MI' )) < TO_CHAR( glokv.dat_zav, 'HH24:MI' ) AND
          TO_CHAR( glokv.dat_poc, 'HH24:MI' ) < TO_CHAR( glokv.dat_zav, 'HH24:MI' )
        ) OR
        ( -- radno vrijeme koje prelazi pono
         (NVL( vrijeme_p, TO_CHAR( sysdate, 'HH24:MI' )) >= TO_CHAR( glokv.dat_poc, 'HH24:MI' ) OR
          NVL( vrijeme_p, TO_CHAR( sysdate, 'HH24:MI' )) < TO_CHAR( glokv.dat_zav, 'HH24:MI' )) AND
          TO_CHAR( glokv.dat_poc, 'HH24:MI' ) > TO_CHAR( glokv.dat_zav, 'HH24:MI' )
        )
      ) AND
      NOT EXISTS (SELECT 1 FROM mpso_lok_vrijeme WHERE psolok_id = lok_id_p AND gpro_id IS NULL)
  )
  LOOP
    RETURN true;
  END LOOP;

  RETURN false;
END RADNO_VRIJEME_LOKACIJE;
PROCEDURE AZURIRAJ_NARUDZBU
 (PRO_ID_P IN NUMBER
 ,KOLICINA_P IN NUMBER
 )
 IS
  cijena_l NUMBER;
  coll_name_l VARCHAR2(8) := 'NARUDZBA';
  item_count_l  NUMBER;
  seq_id_l  NUMBER;
  total_price_l  VARCHAR2(10);
  naredba_l VARCHAR2(400);
BEGIN
  BEGIN
    SELECT seq_id
      INTO seq_id_l
      FROM apex_collections
     WHERE collection_name = coll_name_l AND
           c001 = pro_id_p;

    IF kolicina_p IS null THEN
      apex_collection.delete_member( coll_name_l, seq_id_l );
    ELSE
      apex_collection.update_member_attribute(
        p_collection_name => coll_name_l,
        p_seq             => seq_id_l,
        p_attr_number     => 1,
        p_number_value    => kolicina_p);
    END IF;

  EXCEPTION
    WHEN NO_DATA_FOUND THEN
      naredba_l := '
        SELECT DISTINCT pc
          FROM v_pso_aso_kase_cvor<CVOR>
         WHERE kase_id = :APP_KASA_ID AND
               nac_id  = :APP_NAC_ID AND
               pro_id  = :pro_id_p';
               
      EXECUTE IMMEDIATE REPLACE(naredba_l, '<CVOR>', v('APP_CVOR'))
      INTO cijena_l
      USING v('APP_KASA_ID'), v('APP_NAC_ID'), pro_id_p;

    apex_collection.add_member(
      p_collection_name => coll_name_l,
      p_c001 => pro_id_p,
      p_n001 => kolicina_p,
      p_n002 => cijena_l);
  END;

  SELECT NVL( SUM(n001), 0), TO_CHAR( NVL(SUM(n001*n002), 0), 'FM999G999G999G999G990D00' )
    INTO item_count_l, total_price_l
    FROM apex_collections
   WHERE collection_name = coll_name_l
     AND n001 > 0
     AND c050 IS null;

  apex_json.open_object(); 
  apex_json.write('status', 200);
  apex_json.write('itemCount', item_count_l);
  apex_json.write('totalPrice',apex_string.format('%s%s%s', '&', 'euro;', total_price_l));
  apex_json.close_object();

END AZURIRAJ_NARUDZBU;
PROCEDURE PROVJERI_DATUM_PSO
 (LOK_ID_P IN MPSO_LOKACIJE.ID%TYPE
 )
 IS
 CURSOR c_lok  IS
   SELECT psolok.dat_pso
      FROM mpso_lokacije psolok
   WHERE psolok.id = LOK_ID_P;

 datum_l DATE;
BEGIN
     OPEN c_lok;
   FETCH c_lok INTO datum_l;
   CLOSE c_lok;
   
   IF nvl(datum_l,SYSDATE) > SYSDATE THEN
     -- Nije dozvoljeno naruivanje do #0.
     gas_zaj.vrati_poruku (-20517, to_char(datum_l, 'dd.mm.yyyy hh24:mm')); 
   END IF;

END PROVJERI_DATUM_PSO;
PROCEDURE PSO_NOTIFIKACIJA
 (PSONAR_ID_P IN tpso_narudzbe.id%TYPE
 ,PSOLOK_ID_P IN tpso_narudzbe.psolok_id%TYPE
 ,DAT_PREUZIMANJA_P IN tpso_narudzbe.datum_preuzimanja%TYPE
 ,POS_BROJ_P IN tpso_narudzbe.pos_broj%TYPE
 ,BROJ_SOBE_P IN tpso_narudzbe.br_sobe%TYPE
 ,GOST_ID_P IN tpso_narudzbe.gost_id%TYPE
 ,JEZ_ID_P IN tpso_narudzbe.jez_id%TYPE
 )
 IS
 broj_sobe_l  VARCHAR2(30);
  jez_sifra_l  VARCHAR2(5);
 ozn_dostave_l NUMBER;
  ozn_gotovo_l NUMBER := 0;
  path_l       VARCHAR2(30) := '/pso/push/notify';
  response_l   VARCHAR2(400);
  text_l       VARCHAR2(100);
  title_l      VARCHAR2(50) := 'POS self-ordering';
  url_l        VARCHAR2(100);
  vrsta_lok_l  VARCHAR2(10);
BEGIN
  apex_web_service.g_request_headers(1).name := 'Content-Type';
  apex_web_service.g_request_headers(1).value := 'application/json';
  
  /* Dohvati podatke lokacije */
  SELECT
    lok.ozn_dostave AS ozn_dostave,
    glok.vrsta_lok AS vrsta_lokacije,
    NVL(sj.broj, broj_sobe_p) AS broj_sobe,
    NVL(lok.url_notifikacije, glok.url_notifikacije) AS url
  INTO
    ozn_dostave_l,
    vrsta_lok_l,
    broj_sobe_l,
    url_l
  FROM mpso_lokacije lok
  LEFT OUTER JOIN mpso_lokacije glok ON
    glok.id = lok.psolok_id
  LEFT OUTER JOIN m_sj sj ON
    sj.id = lok.sj_id
  WHERE lok.id = psolok_id_p;
  
  /* Dohvati ifru jezika (default engleski) */
  IF jez_id_p IS NOT NULL THEN
	SELECT sifra_3a
	INTO jez_sifra_l
	FROM s_jezici
	WHERE id = jez_id_p;
  ELSE
  	jez_sifra_l := 'eng';
  END IF;
  
  /* Ne mora se slati obavijest ako nema URL-a */
  IF url_l IS NULL THEN
    RETURN;
  END IF;
  
  /* Brie narudbu iz servisa za notifikacije ako je zavrena */
  IF pos_broj_p IS NOT NULL THEN
    ozn_gotovo_l := 1;
  END IF;
  
  /* narudba je gotova kad je naplaena na kasi */
  IF pos_broj_p IS NOT NULL THEN
    /* narudba se dostavlja na stol ako je vrsta lokacije stol */
    IF vrsta_lok_l = 'ST' THEN
      /* Vaa narudba se dostavlja na va stol*/
      text_l := pra_zmp_zaj.porjez('PSO', 'PSO_NAR_STOL', jez_sifra_l);
    /* narudba se dostavllja u sobu ako je upisan broj sobe */
    ELSIF broj_sobe_l IS NOT NULL AND ozn_dostave_l = 1 THEN
      /* Vaa narudba se dostavlja u sobu #0*/
      text_l := pra_zmp_zaj.porjez('PSO', 'PSO_NAR_SOBA', jez_sifra_l, broj_sobe_l);
    /* inae se preuzima */
    ELSE
      /* Vaa narudba je spremna za preuzimanje */
      text_l := pra_zmp_zaj.porjez('PSO', 'PSO_NAR_PREUZIMANJE', jez_sifra_l);
    END IF;
  /* ako jo nije naplaena, a preuzeta je na kasi */
  ELSIF dat_preuzimanja_p IS NOT null THEN
    /* Vaa narudba je preuzeta u obradu*/
    text_l := pra_zmp_zaj.porjez('PSO', 'PSO_NAR_PREUZETA', jez_sifra_l);
  /* ako nije ni preuzeta, ne mora se ni slati obavijest */
  ELSE
    RETURN;
  END IF;

  apex_json.initialize_clob_output;
  
  apex_json.open_object();
  apex_json.write('orderId', TO_CHAR(psonar_id_p));
  apex_json.write('finished', ozn_gotovo_l);
  apex_json.open_object('payload');
  apex_json.write('title', title_l);
  apex_json.write('text', text_l);
  apex_json.close_object();
    
  IF gost_id_p IS NOT NULL THEN
    apex_json.write('gostId', gost_id_p);
		
	path_l := null; -- jer URL MDP-a ne zavrava sa '/notify'
  END IF;
  
  apex_json.close_object();
  
  /* Poalji notifikaciju */
  response_l := apex_web_service.make_rest_request(
    p_url         => url_l || path_l,
    p_http_method => 'POST',
    p_body        => apex_json.get_clob_output
  );

  apex_json.free_output;

  IF apex_web_service.g_status_code >= 400 THEN
    apex_json.parse( response_l );
    response_l := apex_json.get_varchar2( p_path => 'message' );
    --raise_application_error( -20001, response_l );
  END IF;

EXCEPTION
  WHEN OTHERS THEN
    -- bad request: logirati negdje
    null;
    
END PSO_NOTIFIKACIJA;

END PRA_PSO_APEX;
/
SHOW ERROR

