-- D:\mish_CVS\misH_skripte\pra_pos_gas.pkb
--
-- Generated for Oracle 10g on Tue Dec 30  13:20:56 2025 by Server Generator 6.5.96.5.6
 

PROMPT Creating Package Body 'PRA_POS_GAS'
CREATE OR REPLACE PACKAGE BODY PRA_POS_GAS IS

CENTAR_M VARCHAR2(41);


FUNCTION POSTOJI_DO
 (DATUM_P IN DATE
 )
 RETURN NUMBER
 IS
--
  brojac_l NUMBER;
  naredba_l VARCHAR2(3200);
BEGIN
  centar_M := vrati_gas_cvor;
  naredba_l :=
    ' SELECT COUNT(*)' ||
    '   FROM l_obracun' || centar_M ||
    '  WHERE oznaka = ''00'' ' ||
    '    AND datum = :datum_p';

  EXECUTE IMMEDIATE naredba_l INTO brojac_l USING datum_p;

  IF brojac_l = 1 THEN
    RETURN -1;
  ELSE
    RETURN 0;
  END IF;
END;
FUNCTION POSTOJI_PROMET
 (KASE_ID_P IN t_rnkase.kase_id%TYPE
 ,DATUM_P IN DATE
 )
 RETURN NUMBER
 IS
--
  brojac_l NUMBER:=0;
  naredba_l VARCHAR2(3200);
  ozn_online_prijepisa_l mgmp_kase.ozn_online_prijepisa%TYPE;
BEGIN                    
  SELECT ozn_online_prijepisa
    INTO ozn_online_prijepisa_l 
    FROM mgmp_kase 
   WHERE id = kase_id_p;
  /* Ako je za kasu ukljuen on line prijepis ne provjerava se postojanje prometa,
     kasa kontrolira je li promet prepisan
  */
  IF ozn_online_prijepisa_l = 0 THEN   
     centar_M := vrati_gas_cvor;
     naredba_l :=
       ' SELECT COUNT(*)' ||
       '   FROM t_rnkase' || centar_M ||
       '  WHERE kase_id = :kase_id_p' ||
       '    AND datum = :datum_p';

     EXECUTE IMMEDIATE naredba_l INTO brojac_l USING kase_id_p, datum_p;   
  END IF;

  IF brojac_l > 0 THEN
    RETURN -1;
  ELSE
    RETURN 0;
  END IF;
END;
FUNCTION BROJ_RACUNA
 (DATUM_P IN T_RNKASE.DATUM%TYPE
 ,KASE_ID_P IN t_rnkase.kase_id%TYPE
 )
 RETURN NUMBER
 IS
--
  br_redaka_l NUMBER;
  naredba_l VARCHAR2(3200);
BEGIN   
  centar_M := vrati_gas_cvor;
  naredba_l :=
    ' SELECT COUNT(*) ' ||
    '   FROM t_rnkase' || centar_M ||
    '  WHERE datum = :datum_p ' ||
    '    AND kase_id = :kase_id_p';
  EXECUTE IMMEDIATE naredba_l INTO br_redaka_l USING datum_p, kase_id_p;
  RETURN br_redaka_l;
END;
FUNCTION SUMA_RACUNA
 (DATUM_P IN T_RNKASE.DATUM%TYPE
 ,KASE_ID_P IN t_rnkase.kase_id%TYPE
 )
 RETURN NUMBER
 IS
--
  naredba_l VARCHAR2(3200);
  suma_l NUMBER;
BEGIN
  centar_M := vrati_gas_cvor;
  naredba_l :=
    ' SELECT SUM (s.iznos)'||
    '   FROM t_rnkase_pro' || centar_M  || ' s' ||
    '       ,t_rnkase' || centar_M  || ' r' ||
    '  WHERE r.datum = :datum_p' ||
    '    AND r.kase_id = :kase_id_p' ||
    '    AND r.id = s.rn_id';
  EXECUTE IMMEDIATE naredba_l INTO suma_l USING datum_p, kase_id_p;
  RETURN suma_l;
END;
PROCEDURE BRISI_PROMET
 (KASE_ID_P IN mgmp_kase.id%TYPE
 ,DATUM_P IN DATE
 )
 IS
--
  naredba_l VARCHAR2(3200);
  metapl_sifra_l smet_aplikacije.sifra%TYPE; 
  ozn_online_prijepisa_l mgmp_kase.ozn_online_prijepisa%TYPE;   
  
  CURSOR c_primjena  IS    
  SELECT vla.dat_primjene_domval
    FROM s_vlasnik vla
   WHERE pra_zmp_zaj.zmppar_vrijednost('ZMP', '0002') = 'HR';

 dat_primjena_l t_ulazdok.datum%TYPE;
BEGIN
  centar_M := vrati_gas_cvor;
  /*
     Ako je promet prepisan u LIBUSOFT tada nema brisanja prometa.
     Da bi se moglo brisati potrebno  je u LIBUSOFTU stornirati raune i temeljnice,
     te aurirati tablicu LPKA_RAC_FIN da bi se moglo ponovo slati
  */   
  naredba_l := 
     'BEGIN        
         IF pra_zmp_zaj.zmppar_vrijednost(''PKA'', ''1049'') = ''LIBUSOFT'' THEN
            pra_pka_fin.zabrani_izmjenu_gasrnk' || centar_M ||'(:kase_id_p, :datum_p);
         END IF;
      END;';
  EXECUTE IMMEDIATE naredba_l USING kase_id_p, datum_p;   
  
  SELECT metapl_sifra, ozn_online_prijepisa
    INTO metapl_sifra_l, ozn_online_prijepisa_l 
    FROM mgmp_kase 
   WHERE id = kase_id_p;
  
    OPEN c_primjena;
   FETCH c_primjena INTO dat_primjena_l;
   CLOSE c_primjena;    
                  
    IF dat_primjena_l IS NOT  NULL AND TRUNC(SYSDATE) >= dat_primjena_l THEN
      IF (datum_p >= dat_primjena_l AND  pra_pka_domval.hrk_arhiva = -1 )
         OR  (datum_p < dat_primjena_l AND  pra_pka_domval.hrk_arhiva = 0 )
      THEN
         IF  pra_pka_domval.hrk_arhiva = -1 THEN
             RAISE_APPLICATION_ERROR (-20000, '  Nije dozvoljen prijepis prometa za datum > 31.12.2022 na HRK emi');
         ELSE
             RAISE_APPLICATION_ERROR (-20000, '  Nije dozvoljen prijepis prometa za datum < 01.01.2023 na EUR emi');
         END IF;
      END IF;
    END IF;
  
   
  IF metapl_sifra_l = 'GAS' OR ozn_online_prijepisa_l = -1 THEN
    gas_zaj.vrati_poruku (-20220); -- Nije dozvoljeno brisanje prometa kase.
  END IF;

  naredba_l :=
    'DELETE t_rnkase_pro' || centar_M ||
    ' WHERE rn_id IN (SELECT id '||
    '                   FROM t_rnkase' || centar_M ||
    '                  WHERE kase_id = :kase_id_p' ||
    '                    AND datum   = :datum_p)';
  EXECUTE IMMEDIATE naredba_l USING kase_id_p, datum_p;

  naredba_l :=
    'DELETE t_rnkase' || centar_M ||
    ' WHERE kase_id = :kase_id_p' ||
    '   AND datum   = :datum_p';
  EXECUTE IMMEDIATE naredba_l USING kase_id_p, datum_p;

  COMMIT;

END;
FUNCTION ASORTIMAN
 (KASE_ID_P IN m_aso_kase.kase_id%TYPE
 )
 RETURN SYS_REFCURSOR
 IS
rc SYS_REFCURSOR;
  vrijednost_l szmp_parametri.vrijednost%TYPE;
  ozn_l        VARCHAR2(1);   
  tecaj_l      VARCHAR2(20);
  konverzija_l NUMBER;
  primjena_l   NUMBER;
  
  CURSOR c_konverzija IS 
  SELECT COUNT (*)
    FROM lpka_promjene_domval
   WHERE oznaka = 'M_ASO_KASE';

  CURSOR c_primjena  IS    
  SELECT COUNT (*) 
    FROM s_vlasnik vla
   WHERE TRUNC(SYSDATE) >= vla.dat_primjene_domval
     AND pra_zmp_zaj.zmppar_vrijednost('ZMP', '0002') = 'HR';
BEGIN
   /* provjera konverzije */
 OPEN c_konverzija;
   FETCH c_konverzija INTO konverzija_l;
 CLOSE c_konverzija;

 /* provjera primjene */
 OPEN c_primjena;
   FETCH c_primjena INTO primjena_l;
 CLOSE c_primjena;

 /* Samo ako su cijene NISU konvertirane, a primjenjuje se nova valuta uzima se tecaj */
 IF konverzija_l = 0 AND primjena_l = 1 THEN
    tecaj_l := pra_pka_s3.izn_ftecaja;
 ELSE
    tecaj_l := 1;
 END IF;

 tecaj_l :=  TRANSLATE (tecaj_l, ',', '.');
 ozn_l := NULL;

 EXECUTE IMMEDIATE ('ALTER SESSION SET NLS_NUMERIC_CHARACTERS = '',.'' ');

 /*  Omogueno je vie stopa PPOT u jednoj emi na nain da kase pripadaju razliitim knjigama rauna.
     Parametar: GAS 1060: Doputene kombinacije knjige rauna za PPOT: nebitno ili prvi znak je prvi znak ifre poreza
     i ifra knjige rauna(kombinacije odvojene zarezom).
     U poreznim grupama je potrebno otvoriti 'duple' grupe.
     01 i P01 a u parametru upisati P100, to znai sa se za sve kase koje pripadaju knjizi rauna 100 ppot iz porezne grupe 01
     zamjenjuje sa PPOT iz porezne grupe P01.
*/
  IF NVL(pra_zmp_zaj.zmppar_vrijednost('GAS', '1060'),'nebitno') <> 'nebitno' THEN
    BEGIN
      SELECT (WITH data AS
           (SELECT pra_zmp_zaj.zmppar_vrijednost('GAS', '1060') str FROM dual)
               SELECT substr(TRIM(regexp_substr(str, '[^,]+', 1, LEVEL)),1,1)  str
                 FROM DATA
                WHERE substr(TRIM(regexp_substr(str, '[^,]+', 1, LEVEL)),2) = t.sifra_ojr
               CONNECT BY instr(str, ',', 1, LEVEL - 1) > 0) ozn
        INTO ozn_l
        FROM m_kase t
       WHERE t.id = kase_id_p
            AND EXISTS
               (WITH data AS
               (SELECT pra_zmp_zaj.zmppar_vrijednost('GAS', '1060') str FROM dual)
                     SELECT TRIM(regexp_substr(str, '[^,]+', 1, LEVEL))  str
                       FROM DATA
                      WHERE substr(TRIM(regexp_substr(str, '[^,]+', 1, LEVEL)),2) = t.sifra_ojr
             CONNECT BY instr(str, ',', 1, LEVEL - 1) > 0);
   EXCEPTION
       WHEN no_data_found THEN
         ozn_l := NULL;
     END;
  END IF;

    centar_M := vrati_gas_cvor;
    vrijednost_l := pra_zmp_zaj.zmppar_vrijednost ('GAS', '1004');

    /* radi voenja trokova po RC u parametru je zapisana vrijednost 1 ali se ne radi sa SUBTOTALIMA
       tako da de vrijednost prebacije na '3'
    */
    IF pra_zmp_zaj.tekuci_cvor = 'kimonumenti' AND vrijednost_l = '1' THEN
       vrijednost_l := '3';
    END IF;

    IF ozn_l IS NULL THEN
     /*PPOT se uzima iz porezne grupe */
     OPEN rc FOR
      'SELECT pro.id AS gas_pro_id,                                            '||
      '       pro.sif_proizvoda_kasa AS pro_sifra,                             '||
      '       DECODE(pra_zmp_zaj.zmppar_vrijednost (''GAS'', ''1035''), ''da'', NVL(pro.naz_dodatni, pro.naziv), pro.naziv) AS pro_naziv,   '||
      '       gpor.id AS gas_gpor_id,                                          '||
      '       asokase.nac_id AS gas_nac_id,                                    '||
      '       asokase.mt_id AS gas_mt_id,                                      '||
      '       DECODE(asokase.pc,0,0,DECODE (ozn_proizvoda, ''5'',DECODE(ROUND(asokase.pc * -1 / ' || tecaj_l || ', 2),0,0.01,ROUND(asokase.pc * -1 / '|| tecaj_l || ', 2)), DECODE(ROUND(asokase.pc / ' || tecaj_l || ', 2),0,0.01,ROUND(asokase.pc / ' || tecaj_l || ', 2)))) AS pc,  '||
      '       DECODE (ozn_proizvoda, ''1'', ''N'', ''2'', ''N'', ''3'', ''Y'', ''4'', ''Y'', ''5'', ''N'', ''6'', ''N'') AS izmjenjiva_cijena,  '||
      '       DECODE (ozn_proizvoda, ''1'', pro.popust_max / 100, ''2'', pro.popust_max / 100, ''3'', 0, ''4'', 0, ''5'', 0, ''6'', 0) AS doz_popust,  '||
      '       asokase.popust_obavezni / 100 AS popust,                           '||
      '       DECODE (pro.sif_proizvoda_kasa, ''9999'', ''Y'', ''N'') AS room_service, '||
      '       pro.kolicina                 AS gas_id_kalkulacije,              '||
      '       pro.naz_kod AS naziv_kratki,                                     '||
      '       pro.ean_kod AS ean_kod,                                          '||
      '       TO_NUMBER(DECODE (mt.vrsta, ''U'', ROUND(pra_nst_zaj.povratna_naknada(pro.id, NULL, NULL)/ '|| tecaj_l ||',2), 0)) AS iznos_pn,  '||
      '       UPPER (SUBSTR (gknji.naziv, 1, 2)) AS knjigo_grupa,              '||
      '       gtehpro.naziv AS gtehpro_naziv,                                  '||
      '       pro.ozn_proizvoda AS oznaka_proizvoda,                           '||
      '       DECODE('''||vrijednost_l||''', ''1'', pra_pos_gas.br_subtotal (UPPER (SUBSTR (gknji.naziv, 1, 2)) || '' ''|| vpispz.stopa || ''+'' || gpor.ppot), -1) AS subtotal,    '||
      '       pri.prilozi  AS prilozi,                                         '||
      '       kpd.sifra AS kpd_sifra                                           '||
      '  FROM m_aso_kase'||centar_M ||' asokase,                               '||
      '       m_proizvodi'||centar_M ||' pro,                                  '||
      '       m_gporez'||centar_M ||' gpor,                                    '||
      '       m_oj'||centar_M ||' oj,                                          '||
      '       m_mt'||centar_M ||' mt,                                          '||
      '       m_gknjigo'||centar_M ||' gknji,                                  '||
      '       m_mt_kase'||centar_M ||' mtkase,                                 '||
      '       m_gtehpro'||centar_M ||' gtehpro,                                '||
      '       mgas_gpor_raz'||centar_M ||' gporraz,                            '||
      '       s_vpisporukap '||centar_M ||'  vpispp,                           '||
      '       s_vpisporukaz '||centar_M ||'  vpispz,                           '||
      '       s_kpd '||centar_M ||'  kpd,                                      '||
      '       (SELECT pro_id, LISTAGG(pro1.sif_proizvoda_kasa, '', '')         '||
      '               WITHIN GROUP (order by pro2_id) "PRILOZI"                '||
      '          FROM m_pro_prilozi,                                           '||
      '               m_proizvodi pro1                                         '||
      '         WHERE pro1.id = pro2_id                                        '||
      '         GROUP BY pro_id                                                '||
      '         ORDER BY pro_id) pri                                           '||
      ' WHERE pro.id = asokase.pro_id                                          '||
      '   AND pro.gpor_id = gpor.id                                            '||
      '   AND pro.gknji_id = gknji.id                                          '||
      '   AND pro.kpd_id = kpd.id (+)                                             '||
      '   AND asokase.mt_id = oj.id                                            '||
      '   AND asokase.mt_id = mt.id                                            '||
      '   AND asokase.mt_id = mtkase.mt_id                                     '||
      '   AND asokase.kase_id = mtkase.kase_id                                 '||
      '   AND pro.gtehpro_id =  gtehpro.id                                     '||
      '   AND pro.gpor_id       = gporraz.gpor_id                              '||
      '   AND TRUNC(SYSDATE) BETWEEN gporraz.dat_valjan                        '||
      '   AND NVL(gporraz.dat_ponisten, SYSDATE)                               '||
      '   AND gporraz.vpispp_id    = vpispp.id                                 '||
      '   AND vpispp.vpispz_id  = vpispz.id                                    '||
      '   AND TRUNC(SYSDATE) BETWEEN oj.dat_valjan AND NVL (oj.dat_ponisten, SYSDATE)  '||
      '   AND pro.id = pri.pro_id (+)                                          '||
      '   AND asokase.kase_id = ' || kase_id_p                                  ||
      'UNION                                                                   '||
      'SELECT sifgr.id AS gas_pro_id,                                          '||
      '       sifgr.sif_proizvoda_kasa AS pro_sifra,                           '||
      '       DECODE(pra_zmp_zaj.zmppar_vrijednost (''GAS'', ''1035''), ''da'', NVL(sifgr.naz_dodatni, sifgr.naziv), sifgr.naziv) AS pro_naziv,     '||
      '       gpor.id AS gas_gpor_id,                                          '||
      '       asokasegrupa.nac_id AS gas_nac_id,                               '||
      '       asokasegrupa.mt_id AS gas_mt_id,                                 '||
      '       DECODE(ROUND(asokasegrupa.pc/' || tecaj_l || ',2),0,0.01,ROUND(asokasegrupa.pc/' || tecaj_l || ',2)) AS  pc,        '||
      '       ''Y'' AS izmjenjiva_cijena,                                      '||
      '       DECODE(pra_zmp_zaj.zmppar_vrijednost (''GAS'', ''1062''), sif_proizvoda_kasa, 0, 1 ) AS  doz_popust,      '||
      '       0 AS popust,                                                     '||
      '       ''N'' AS room_service,                                           '||
      '       0 AS gas_id_kalkulacije,                                         '||
      '       NULL AS naziv_kratki,                                            '||
      '       NULL AS ean_kod,                                                 '||
      '       0 AS iznos_pn,                                                   '||
      '       UPPER (SUBSTR (gknji.naziv, 1, 2)) AS knjigo_grupa,              '||
      '       gtehpro.naziv AS gtehpro_naziv,                                  '||
      '       ''1'' AS oznaka_proizvoda,                                       '||
      '       DECODE('''|| vrijednost_l||''', ''1'', pra_pos_gas.br_subtotal (UPPER (SUBSTR (gknji.naziv, 1, 2)) || '' ''|| vpispz.stopa || ''+'' || gpor.ppot), -1) AS subtotal,  '||
      '       NULL AS prilozi,                                                 '||
      '       kpd.sifra AS kpd_sifra                                           '||
      '  FROM m_aso_kase_grupe'||centar_M ||' asokasegrupa,                    '||
      '       m_sif_grupa'||centar_M ||' sifgr,                                '||
      '       m_gporez'||centar_M ||' gpor,                                    '||
      '       m_oj'||centar_M ||' oj,                                          '||
      '       m_gknjigo'||centar_M ||' gknji,                                  '||
      '       m_mt_kase'||centar_M ||' mtkase,                                 '||
      '       m_gtehpro'||centar_M ||' gtehpro,                                '||
      '       mgas_gpor_raz'||centar_M ||' gporraz,                            '||
      '       s_vpisporukap '||centar_M ||'  vpispp,                           '||
      '       s_vpisporukaz '||centar_M ||'  vpispz,                           '||
      '       s_kpd '||centar_M ||'  kpd                                       '||
      ' WHERE sifgr.id = asokasegrupa.sifgr_id                                 '||
      '   AND sifgr.gpor_id = gpor.id                                          '||
      '   AND sifgr.gknji_id = gknji.id                                        '||
      '   AND sifgr.kpd_id = kpd.id (+)                                           '||
      '   AND asokasegrupa.mt_id = oj.id                                       '||
      '   AND asokasegrupa.mt_id = mtkase.mt_id                                '||
      '   AND asokasegrupa.kase_id = mtkase.kase_id                            '||
      '   AND sifgr.gtehpro_id = gtehpro.id                                    '||
      '   AND TRUNC(SYSDATE) BETWEEN gporraz.dat_valjan AND NVL(gporraz.dat_ponisten, SYSDATE)  '||
      '   AND sifgr.gpor_id       = gporraz.gpor_id                            '||
      '   AND gporraz.vpispp_id    = vpispp.id                                 '||
      '   AND vpispp.vpispz_id  = vpispz.id                                    '||
      '   AND TRUNC(SYSDATE) BETWEEN oj.dat_valjan AND NVL (oj.dat_ponisten, SYSDATE)  '||
      '   AND asokasegrupa.kase_id = ' || kase_id_p;
  ELSE
     OPEN rc FOR
       /*PPOT se uzima iz parametra */
      'SELECT pro.id AS gas_pro_id,                                            '||
      '       pro.sif_proizvoda_kasa AS pro_sifra,                             '||
      '       DECODE(pra_zmp_zaj.zmppar_vrijednost (''GAS'', ''1035''), ''da'', NVL(pro.naz_dodatni, pro.naziv), pro.naziv) AS pro_naziv,   '||
      '       gpor.id AS gas_gpor_id,                                          '||
      '       asokase.nac_id AS gas_nac_id,                                    '||
      '       asokase.mt_id AS gas_mt_id,                                      '||
      '       DECODE(asokase.pc,0,0,DECODE (ozn_proizvoda, ''5'',DECODE(ROUND(asokase.pc * -1 / ' || tecaj_l || ', 2),0,0.01,ROUND(asokase.pc * -1 / '|| tecaj_l || ', 2)), DECODE(ROUND(asokase.pc / ' || tecaj_l || ', 2),0,0.01,ROUND(asokase.pc / ' || tecaj_l || ', 2)))) AS pc,  '||
      '       DECODE (ozn_proizvoda, ''1'', ''N'', ''2'', ''N'', ''3'', ''Y'', ''4'', ''Y'', ''5'', ''N'', ''6'', ''N'') AS izmjenjiva_cijena,  '||
      '       DECODE (ozn_proizvoda, ''1'', pro.popust_max / 100, ''2'', pro.popust_max / 100, ''3'', 0, ''4'', 0, ''5'', 0, ''6'', 0) AS doz_popust,  '||
      '       asokase.popust_obavezni / 100 AS popust,                         '||
      '       DECODE (pro.sif_proizvoda_kasa, ''9999'', ''Y'', ''N'') AS room_service, '||
      '       pro.kolicina                AS gas_id_kalkulacije,               '||
      '       pro.naz_kod AS naziv_kratki,                                     '||
      '       pro.ean_kod AS ean_kod,                                          '||
      '       TO_NUMBER(DECODE (mt.vrsta, ''U'', ROUND(pra_nst_zaj.povratna_naknada(pro.id, NULL, NULL)/ '|| tecaj_l ||',2), 0))  AS iznos_pn,  '||
      '       UPPER (SUBSTR (gknji.naziv, 1, 2)) AS knjigo_grupa,              '||
      '       gtehpro.naziv AS gtehpro_naziv,                                  '||
      '       pro.ozn_proizvoda AS oznaka_proizvoda,                           '||
      '       DECODE('''||vrijednost_l||''', ''1'', pra_pos_gas.br_subtotal (UPPER (SUBSTR (gknji.naziv, 1, 2)) || '' ''|| vpispz.stopa || ''+'' || gpor.ppot), -1) AS subtotal,   '||
      '       pri.prilozi  AS prilozi,                                         '||
      '       kpd.sifra AS kpd_sifra                                           '||
      '  FROM m_aso_kase'||centar_M ||' asokase,                               '||
      '       (SELECT nvl((SELECT gp.id                                        '||
      '                      FROM m_gporez '||centar_M ||' gp,                 '||
      '                           m_gporez  '||centar_M ||' gpp                '||
      '                     WHERE gpp.id = p.gpor_id                           '||
      '                       AND gp.sifra = '''||ozn_l ||'''|| gpp.sifra ),   '||
      '                  p.gpor_id) pgpor_id,p.*                               '||
      '           FROM m_proizvodi '||centar_M ||' p) pro,                     '||
      '       m_gporez'||centar_M ||' gpor,                                    '||
      '       m_oj'||centar_M ||' oj,                                          '||
      '       m_mt'||centar_M ||' mt,                                          '||
      '       m_gknjigo'||centar_M ||' gknji,                                  '||
      '       m_mt_kase'||centar_M ||' mtkase,                                 '||
      '       m_gtehpro'||centar_M ||' gtehpro,                                '||
      '       mgas_gpor_raz'||centar_M ||' gporraz,                            '||
      '       s_vpisporukap '||centar_M ||'  vpispp,                           '||
      '       s_vpisporukaz '||centar_M ||'  vpispz,                           '||
      '       s_kpd '||centar_M ||'  kpd,                                      '||
      '       (SELECT pro_id, LISTAGG(pro1.sif_proizvoda_kasa, '', '')         '||
      '               WITHIN GROUP (order by pro2_id) "PRILOZI"                '||
      '          FROM m_pro_prilozi,                                           '||
      '               m_proizvodi pro1                                         '||
      '         WHERE pro1.id = pro2_id                                        '||
      '         GROUP BY pro_id                                                '||
      '         ORDER BY pro_id) pri                                           '||
      ' WHERE pro.id = asokase.pro_id                                          '||
      '   AND pro.pgpor_id = gpor.id                                           '||
      '   AND pro.gknji_id = gknji.id                                          '||
      '   AND pro.kpd_id = kpd.id (+)                                             '||
      '   AND asokase.mt_id = oj.id                                            '||
      '   AND asokase.mt_id = mt.id                                            '||
      '   AND asokase.mt_id = mtkase.mt_id                                     '||
      '   AND asokase.kase_id = mtkase.kase_id                                 '||
      '   AND pro.gtehpro_id =  gtehpro.id                                     '||
      '   AND pro.gpor_id       = gporraz.gpor_id                              '||
      '   AND TRUNC(SYSDATE) BETWEEN gporraz.dat_valjan AND NVL(gporraz.dat_ponisten, SYSDATE)  '||
      '   AND gporraz.vpispp_id    = vpispp.id                                '||
      '   AND vpispp.vpispz_id  = vpispz.id                                   '||
      '   AND TRUNC(SYSDATE) BETWEEN oj.dat_valjan AND NVL (oj.dat_ponisten, SYSDATE)  '||
      '   AND pro.id = pri.pro_id (+)                                          '||
      '   AND asokase.kase_id = ' || kase_id_p                                  ||
      'UNION                                                                   '||
      'SELECT sifgr.id AS gas_pro_id,                                          '||
      '       sifgr.sif_proizvoda_kasa AS pro_sifra,                           '||
      '       DECODE(pra_zmp_zaj.zmppar_vrijednost (''GAS'', ''1035''), ''da'', NVL(sifgr.naz_dodatni, sifgr.naziv), sifgr.naziv) AS pro_naziv,     '||
      '       gpor.id AS gas_gpor_id,                                          '||
      '       asokasegrupa.nac_id AS gas_nac_id,                               '||
      '       asokasegrupa.mt_id AS gas_mt_id,                                 '||
      '       DECODE(ROUND(asokasegrupa.pc/' || tecaj_l || ',2),0,0.01,ROUND(asokasegrupa.pc/' || tecaj_l || ',2)) AS pc,    '||
      '       ''Y'' AS izmjenjiva_cijena,                                      '||
      '       DECODE(pra_zmp_zaj.zmppar_vrijednost (''GAS'', ''1062''), sif_proizvoda_kasa, 0,1 ) AS  doz_popust,      '||
      '       0 AS popust,                                                     '||
      '       ''N'' AS room_service,                                           '||
      '       0 AS gas_id_kalkulacije,                                         '||
      '       NULL AS naziv_kratki,                                            '||
      '       NULL AS ean_kod,                                                 '||
      '       0 AS iznos_pn,                                                   '||
      '       UPPER (SUBSTR (gknji.naziv, 1, 2)) AS knjigo_grupa,              '||
      '       gtehpro.naziv AS gtehpro_naziv,                                  '||
      '       ''1'' AS oznaka_proizvoda,                                       '||
      '       DECODE('''|| vrijednost_l||''', ''1'', pra_pos_gas.br_subtotal (UPPER (SUBSTR (gknji.naziv, 1, 2)) || '' ''|| vpispz.stopa || ''+'' || gpor.ppot), -1) AS subtotal,  '||
      '       NULL  AS prilozi,                                                '||
      '       kpd.sifra AS kpd_sifra                                           '||
      '  FROM m_aso_kase_grupe'||centar_M ||' asokasegrupa,                    '||
      '       (SELECT nvl((SELECT gp.id                                        '||
      '                      FROM m_gporez'||centar_M ||' gp,                  '||
      '                           m_gporez'||centar_M ||' gpp                  '||
      '                     WHERE gpp.id = p.gpor_id                           '||
      '                       AND gp.sifra = '''||ozn_l ||'''|| gpp.sifra),    '||
      '                  p.gpor_id) pgpor_id, p.*                              '||
      '           FROM m_sif_grupa'||centar_M ||' p) sifgr,                    '||
      '       m_gporez'||centar_M ||' gpor,                                    '||
      '       m_oj'||centar_M ||' oj,                                          '||
      '       m_gknjigo'||centar_M ||' gknji,                                  '||
      '       m_mt_kase'||centar_M ||' mtkase,                                 '||
      '       m_gtehpro'||centar_M ||' gtehpro,                                '||
      '       mgas_gpor_raz'||centar_M ||' gporraz,                            '||
      '       s_vpisporukap '||centar_M ||'  vpispp,                           '||
      '       s_vpisporukaz '||centar_M ||'  vpispz,                           '||
      '       s_kpd '||centar_M ||' kpd                                        '||
      ' WHERE sifgr.id = asokasegrupa.sifgr_id                                 '||
      '   AND sifgr.pgpor_id = gpor.id                                         '||
      '   AND sifgr.gknji_id = gknji.id                                        '||
      '   AND sifgr.kpd_id = kpd.id (+)                                           '||
      '   AND asokasegrupa.mt_id = oj.id                                       '||
      '   AND asokasegrupa.mt_id = mtkase.mt_id                                '||
      '   AND asokasegrupa.kase_id = mtkase.kase_id                            '||
      '   AND sifgr.gtehpro_id = gtehpro.id                                    '||
      '   AND TRUNC(SYSDATE) BETWEEN gporraz.dat_valjan AND NVL(gporraz.dat_ponisten, SYSDATE)  '||
      '   AND sifgr.gpor_id       = gporraz.gpor_id                            '||
      '   AND gporraz.vpispp_id    = vpispp.id                                 '||
      '   AND vpispp.vpispz_id  = vpispz.id                                    '||
      '   AND TRUNC(SYSDATE) BETWEEN oj.dat_valjan AND NVL (oj.dat_ponisten, SYSDATE)  '||
      '   AND asokasegrupa.kase_id = ' || kase_id_p;
  END IF;
  RETURN rc;
END;
FUNCTION CJENICI
 (KASE_ID_P IN m_kasa_np.kase_id%TYPE
 )
 RETURN SYS_REFCURSOR
 IS
rc SYS_REFCURSOR;
BEGIN 
  centar_M := vrati_gas_cvor;
  OPEN rc FOR
    ' SELECT nac_id AS gas_nac_id, nac.sifra AS nac_sifra, nac.naziv AS nac_naziv, oj.sifra AS oj_sifra, DECODE (nac.ozn_napojnice, 0, -1, 0) AS ozn_napojnice  '||
    '   FROM m_kasa_np'||centar_M ||' kasanp, '||
    '        m_nacpot' ||centar_M ||' nac,    '||
    '        m_oj'     ||centar_M ||' oj      '||
    '  WHERE kasanp.kase_id = '|| kase_id_p    ||
    '    AND kasanp.nac_id = nac.id           '||
    '    AND kasanp.kase_id IN (SELECT DISTINCT(kase_id) FROM m_aso_kase'||centar_M ||' UNION SELECT DISTINCT(kase_id) FROM m_aso_kase_grupe'||centar_M ||' )'||
    '    AND kasanp.oj_id = oj.id(+)';
  RETURN rc;
END;
PROCEDURE UCITAJ_RNKASE
 (GODINA_P IN VARCHAR2
 ,KASE_ID_P IN T_RNKASE.KASE_ID%TYPE
 ,RBR_P IN T_RNKASE.RBR%TYPE
 ,DATUM_P IN T_RNKASE.DATUM%TYPE
 ,KON_ID_P IN T_RNKASE.KON_ID%TYPE
 ,NAC_ID_P IN T_RNKASE.NAC_ID%TYPE
 ,VPLA_ID_P IN T_RNKASE.VPLA_ID%TYPE
 ,POPUST_P IN T_RNKASE.POPUST%TYPE
 ,OPIS_P IN T_RNKASE.OPIS%TYPE
 ,VRIJEME_P IN T_RNKASE.VRIJEME%TYPE
 ,OJ_ID_P IN T_RNKASE.OJ_ID%TYPE
 ,SJ_ID_P IN T_RNKASE.SJ_ID%TYPE
 ,AGE_ID_P IN T_RNKASE.AGE_ID%TYPE
 ,BR_GOSTIJU_P IN T_RNKASE.BR_GOSTIJU%TYPE
 ,PKAADR_ID_P IN T_RNKASE.OJ_ID%TYPE
 ,VPDOG_ID_P IN T_RNKASE.VPDOG_ID%TYPE
 ,GODINA_STO_P IN T_RNKASE.GODINA%TYPE
 ,RBR_STO_P IN T_RNKASE.RBR%TYPE
 ,JIR_P IN T_RNKASE.JIR%TYPE
 ,ZASTITNI_KOD_P IN T_RNKASE.ZASTITNI_KOD%TYPE
 ,PARAGON_P IN T_RNKASE.PARAGON%TYPE
 ,PARAGON_SET_P IN T_RNKASE.PARAGON_SET%TYPE
 ,PARAGON_SERIJA_P IN T_RNKASE.PARAGON_SERIJA%TYPE
 ,BR_LOY_KARTICE_P IN T_RNKASE.BR_LOY_KARTICE%TYPE
 ,BR_KARTICE_P IN T_RNKASE.BR_KARTICE%TYPE
 ,BR_STOLA_P IN T_RNKASE.BR_STOLA%TYPE
 ,VPLA2_ID_P IN T_RNKASE.VPLA_ID%TYPE
 ,IZN_PLACANJA_P IN T_RNKASE.IZN_PLACANJA%TYPE
 ,IZN_PLACANJA2_P IN T_RNKASE.IZN_PLACANJA%TYPE
 ,VPLA_NAPOJNICE_ID_P IN T_RNKASE.VPLA_NAPOJNICE_ID%TYPE
 ,IZN_NAPOJNICE_P IN T_RNKASE.IZN_NAPOJNICE%TYPE
 ,DATUM_NAPOJNICE_P IN T_RNKASE.DATUM_NAPOJNICE%TYPE
 ,OZN_STORNA_P IN T_RNKASE.OZN_STORNA%TYPE
 ,RBR_FISK_P IN T_RNKASE.RBR_FISK%TYPE
 )
 IS
--
/* Trai se priznanje za bilo koje mjesto troka koje je vezano za tu kasu i taj nain potronje
*/

CURSOR priznanje_c (kase_id VARCHAR2, nac_id VARCHAR2, datum_p DATE) IS
SELECT gasnacraz.priznanje, gasnacraz.priznanje_trosak
  FROM m_kasa_np kasenp,
       m_mt_np mtnp,
       mgas_nac_raz  gasnacraz
 WHERE kasenp.kase_id = kase_id_p
   AND kasenp.nac_id = nac_id_p
   AND kasenp.nac_id = mtnp.nac_id
   AND gasnacraz.nac_id = nac_id_p
   AND gasnacraz.mt_id = mtnp.mt_id
   AND datum_p BETWEEN gasnacraz.dat_valjan AND NVL(gasnacraz.dat_ponisten, to_date('31.12.2999', 'DD.MM.RRRR'));


   naredba_l VARCHAR2(3200);
   pkaadr_ozn_l t_rnkase.pkaadr_ozn%TYPE;
   rn_id_l t_rnkase.id%TYPE;
   brojac_l NUMBER;
   oj_id_l m_oj.id%TYPE; -- za Operu, a ne elimo staviti da je oj_id_p IN OUT
   priznanje_l t_izlaz.priznanje%TYPE := 0;
   priznanje_trosak_l t_izlaz.priznanje%TYPE := 0;
   gpor_id_l m_nacpot.gpor_id%TYPE;
   ozn_online_prijepisa_l  mgmp_kase.ozn_online_prijepisa%TYPE;
BEGIN

   centar_M := vrati_gas_cvor;
   /*
   mpka_adrese nisu replikacijski podatak, a GAS moe biti centralni, zato se u T_RNKASE
   stavlja samo oznaka je li naplata na adresu
   */
   IF pkaadr_id_p IS NULL THEN
      pkaadr_ozn_l := 'N';
   ELSIF pkaadr_id_p IS NOT NULL THEN
      pkaadr_ozn_l := 'D';
   END IF;

   /* trai se id originalnog rauna */
   IF godina_sto_p IS NOT NULL AND rbr_sto_p IS NOT NULL THEN

      naredba_l :=
        ' SELECT COUNT(*)                     '||
        '   FROM t_rnkase'||centar_M ||
        '  WHERE godina   = :godina_sto_p     '||
        '    AND kase_id  = :kase_id_p        '||
        '    AND rbr      = :rbr_sto_p';

      EXECUTE IMMEDIATE naredba_l INTO brojac_l USING godina_sto_p, kase_id_p, rbr_sto_p;

      IF brojac_l = 1 THEN
         naredba_l :=
           ' SELECT id                           '||
           '   FROM t_rnkase'||centar_M ||
           '  WHERE godina   = :godina_sto_p     '||
           '    AND kase_id  = :kase_id_p        '||
           '    AND rbr      = :rbr_sto_p';
         EXECUTE IMMEDIATE naredba_l INTO rn_id_l USING godina_sto_p, kase_id_p, rbr_sto_p;
      ELSE
         gas_zaj.vrati_poruku (-20225, rbr_sto_p, godina_sto_p);
      END IF;
   END IF;

    /*
   POS ne vraa oj_id (knjigu rauna) za sve vrste naplate, pa se puni oj
   */
   BEGIN
     SELECT zmpojr_id, ozn_online_prijepisa INTO oj_id_l, ozn_online_prijepisa_l
       FROM mgmp_kase
      WHERE id = kase_id_p;
   EXCEPTION
       WHEN NO_DATA_FOUND THEN NULL;
   END;

   /* Ako POS alje oj_id_p tada se zadravata oj (naplata na druge oj).
   */
   IF oj_id_p IS NOT NULL THEN
      oj_id_l := oj_id_p;
   END IF;

   /* Ako je u parametru GAS '1004' upisano 1, tada se radi sa Opera sustavom */
   IF pra_zmp_zaj.zmppar_vrijednost ('GAS', '1004') = '1' THEN
      /*
      Kod rauna na sobu, polje PARAGON sadri podatke: BROJ SJ, IFRA SO, HOTELID (Opera), NAZIV SO, Paycard oznaka
      sa graninikom toka-zarez, npr.: "Opera: 1234;56;78;Valamar Club Diamant;PAYCARD"
      */
      IF paragon_p LIKE ('Opera: %')
         AND oj_id_p IS NULL -- za svaki sluaj; kada se radi s Operom, trebalo bi biti NULL
      THEN
         DECLARE
            -- pozicije znaka toka-zarez u polju PARAGON
            pozicija_1_l INTEGER := INSTR (paragon_p, ';', 1, 1);
            pozicija_2_l INTEGER := INSTR (paragon_p, ';', 1, 2);
            oj_sifra_l m_oj.sifra%TYPE;
         BEGIN
            oj_sifra_l := SUBSTR (paragon_p, pozicija_1_l + 1, pozicija_2_l - 1 - pozicija_1_l);

            SELECT id INTO oj_id_l
              FROM m_oj
             WHERE sifra = oj_sifra_l;
         EXCEPTION
            WHEN NO_DATA_FOUND THEN NULL; -- nee se desiti greka ako ne nae OJ
         END;
      END IF;
   END IF;

   /*
   POS ne vraa oj_id (knjigu rauna) za sve vrste naplate, pa se puni oj
   */
   BEGIN
     SELECT zmpojr_id, ozn_online_prijepisa INTO oj_id_l, ozn_online_prijepisa_l
       FROM mgmp_kase
      WHERE id = kase_id_p;
   EXCEPTION
       WHEN NO_DATA_FOUND THEN NULL;
   END;

   /* Porezna grupa i priznanje se puni za naine portronje gdje se obraunava samo PPOT.
      Samo za te naine potronje i mjesta troka je upisano u tablici mgas_nac_raz.
    */
   SELECT gpor_id INTO gpor_id_l
     FROM m_nacpot
    WHERE id  = nac_id_p;

   OPEN priznanje_c (kase_id_p, nac_id_p, datum_p);
   FETCH priznanje_c INTO priznanje_l, priznanje_trosak_l ;
   IF priznanje_c%NOTFOUND THEN
      priznanje_l := 0;
   END IF;
   CLOSE priznanje_c;

   naredba_l :=
      'BEGIN
         INSERT INTO t_rnkase'||centar_M ||' (
           id, godina, kase_id, rbr, datum, kon_id,
           nac_id, vpla_id, popust, opis, vrijeme,
           oj_id, sj_id, age_id, br_gostiju, pkaadr_ozn, vpdog_id, ozn_valjanosti,
           rn_id, jir, zastitni_kod, paragon, paragon_set, paragon_serija, br_loy_kartice, br_kartice,
           br_stola, vpla2_id, izn_placanja, izn_placanja2, priznanje, priznanje_trosak, gpor_id, 
           vpla_napojnice_id, izn_napojnice, datum_napojnice, ozn_storna, rbr_fisk)
         VALUES (
           NULL, :godina_p, :kase_id_p, :rbr_p, :datum_p, :kon_id_p,
           :nac_id_p, :vpla_id_p, :popust_p, :opis_p, :vrijeme_p,
           :oj_id_l, :sj_id_p, :age_id_p, :br_gostiju_p, :pkaadr_ozn_l, :vpdog_id_p, ''V'',
           :rn_id_l, :jir_p, :zastitni_kod_p, :paragon_p, :paragon_set_p, :paragon_serija_p, :br_loy_kartice_p,
           :br_kartice_p, :br_stola_p, :vpla2_id_p, :izn_placanja_p, :izn_placanja2_p, :priznanje_l, :priznanje_trosak_l, :gpor_id_l,
           :vpla_napojnice_id_p, :izn_napojnice_p, :datum_napojnice_p, :ozn_storna_p, :rbr_fisk_p);
        EXCEPTION
          WHEN DUP_VAL_ON_INDEX THEN
           IF :ozn_online_prijepisa_l = -1 THEN
              NULL;
           ELSE
              gas_zaj.vrati_poruku (-20436,:rbr_p);
           END IF;
        END;';

   EXECUTE IMMEDIATE naredba_l
   USING godina_p, kase_id_p, rbr_p, datum_p, kon_id_p,
         nac_id_p, vpla_id_p, popust_p, opis_p, vrijeme_p,
         oj_id_l, sj_id_p, age_id_p, br_gostiju_p, pkaadr_ozn_l,
         vpdog_id_p, rn_id_l, jir_p, zastitni_kod_p, paragon_p, paragon_set_p, paragon_serija_p,
         br_loy_kartice_p, br_kartice_p, br_stola_p, vpla2_id_p, izn_placanja_p, izn_placanja2_p,
         priznanje_l, priznanje_trosak_l, gpor_id_l, vpla_napojnice_id_p, izn_napojnice_p, datum_napojnice_p, ozn_storna_p, rbr_fisk_p, rbr_p;
END;
PROCEDURE UCITAJ_RNKASE_PRO
 (GODINA_P IN VARCHAR2
 ,KASE_ID_P IN T_RNKASE.KASE_ID%TYPE
 ,RBR_P IN T_RNKASE.RBR%TYPE
 ,RBR_STAVKE_P IN T_RNKASE_PRO.RBR_STAVKE%TYPE
 ,PRO_SIFRA_P IN M_PROIZVODI.SIF_PROIZVODA_KASA%TYPE
 ,SIFGR_ID_P IN M_SIF_GRUPA.ID%TYPE
 ,GPOR_ID_P IN M_GPOREZ.ID%TYPE
 ,MT_ID_P IN M_MT.ID%TYPE
 ,KOLICINA_P IN T_RNKASE_PRO.KOLICINA%TYPE
 ,CIJENA_P IN T_RNKASE_PRO.CIJENA%TYPE
 ,PDV_P IN T_RNKASE_PRO.PDV%TYPE
 ,PPOT_P IN T_RNKASE_PRO.PPOT%TYPE
 ,VPISPZ_ID_P IN T_RNKASE.VPDOG_ID%TYPE
 ,POPUST_P IN T_RNKASE.POPUST%TYPE
 ,MATKALK_ID_P IN T_RNKASE_PRO.MATKALK_ID%TYPE
 ,PRO_ID_P IN T_RNKASE_PRO.PRO_ID%TYPE
 ,IZNOS_P IN T_RNKASE_PRO.IZNOS%TYPE
 ,IZNOS_POPUST_P IN T_RNKASE_PRO.IZNOS_POPUST%TYPE
 ,IZNOS_PDV_P IN T_RNKASE_PRO.IZNOS_PDV%TYPE
 ,IZNOS_PPOT_P IN T_RNKASE_PRO.IZNOS_PPOT%TYPE
 ,IZNOS_PNAKNADE_P IN T_RNKASE_PRO.IZNOS_PNAKNADE%TYPE
 ,ZMPDJE_ID_P IN T_RNKASE_PRO.ZMPDJE_ID%TYPE
 ,IZNOS_POPUST2_P IN T_RNKASE_PRO.IZNOS_POPUST2%TYPE
 )
 IS
--
   gknji_id_l   m_gknjigo.id%TYPE;
   gtehpro_id_l m_gtehpro.id%TYPE;
   brojac_l     NUMBER;
   pro_id_l     m_proizvodi.id%TYPE;
   sifgr_id_l   m_sif_grupa.id%TYPE;
   rn_id_l      t_rnkase.id%TYPE;
   naredba_l    VARCHAR2(3200);
   matkalk_id_l t_rnkase.id%TYPE; 
   ozn_online_prijepisa_l  mgmp_kase.ozn_online_prijepisa%TYPE;
BEGIN
   centar_M := vrati_gas_cvor;

   IF matkalk_id_p <> 0 THEN
      matkalk_id_l := matkalk_id_p;
   ELSE
      matkalk_id_l := NULL;
   END IF;
           
   SELECT ozn_online_prijepisa INTO ozn_online_prijepisa_l
     FROM mgmp_kase
    WHERE id = kase_id_p;         
   
   SELECT COUNT(*) INTO brojac_l                         
     FROM m_proizvodi
    WHERE sif_proizvoda_kasa = pro_sifra_p;
    
   BEGIN
     IF brojac_l = 1 THEN
        SELECT id, gknji_id, gtehpro_id 
          INTO pro_id_l, gknji_id_l, gtehpro_id_l          
          FROM m_proizvodi 
         WHERE sif_proizvoda_kasa = pro_sifra_p;    
     ELSE
        SELECT id, gknji_id, gtehpro_id 
          INTO sifgr_id_l, gknji_id_l, gtehpro_id_l          
          FROM m_sif_grupa           
         WHERE sif_proizvoda_kasa = pro_sifra_p;
     END IF;
   EXCEPTION
      WHEN NO_DATA_FOUND THEN   
       /* Greka - izbrisan proizvod */
        gas_zaj.vrati_poruku (-20513, pro_sifra_p);
   END;

   naredba_l :=
      ' SELECT id                      '||
      '   FROM t_rnkase'|| centar_M     ||
      '  WHERE godina = :godina_p      '||
      '    AND kase_id = :kase_id_p    '||
      '    AND rbr = :rbr_p';

   EXECUTE IMMEDIATE naredba_l INTO rn_id_l USING godina_p, kase_id_p, rbr_p;

   naredba_l :=
      'BEGIN 
          INSERT INTO t_rnkase_pro'|| centar_M || ' (  
            rn_id, rbr_stavke, pro_id, sifgr_id, gpor_id, matkalk_id,       
            gknji_id, gtehpro_id, mt_id, kolicina, cijena,                  
            pdv, ppot, vpispz_id, popust, zad_nab_cijena, pros_nab_cijena,  
            iznos, iznos_popust, iznos_pdv, iznos_ppot, iznos_pnaknade, zmpdje_id, iznos_popust2)   
          VALUES (                                                           
            :rn_id_l, :rbr_stavke_p, :pro_id_l, :sifgr_id_l,:gpor_id_p, :matkalk_id_l,                                      
            :gknji_id_l, :gtehpro_id_l, :mt_id_p, :kolicina_p, :cijena_p,   
            :pdv_p, :ppot_p, :vpispz_id_p, :popust_p, 0, 0,                
            :iznos_p, :iznos_popust_p, :iznos_pdv_p, :iznos_ppot_p, :iznos_pnaknade_p, :zmpdje_id_p, :iznos_popust2_p);
         EXCEPTION
           WHEN DUP_VAL_ON_INDEX THEN
           IF :ozn_online_prijepisa_l = -1 THEN
              NULL;
           ELSE
              gas_zaj.vrati_poruku (-20436, :rbr_p);
           END IF;
       END;';    

   EXECUTE IMMEDIATE naredba_l
   USING rn_id_l, rbr_stavke_p, pro_id_l, sifgr_id_l, gpor_id_p, matkalk_id_l,
         gknji_id_l, gtehpro_id_l, mt_id_p, kolicina_p, cijena_p, pdv_p, ppot_p,
         vpispz_id_p, popust_p, iznos_p, iznos_popust_p, iznos_pdv_p, iznos_ppot_p,
         iznos_pnaknade_p, zmpdje_id_p, iznos_popust2_p, ozn_online_prijepisa_l, rbr_p;

   /* dodano za kontrolu poslanog id_a proizvoda sa kase u stavci prometa   */   
   
   IF pro_id_l IS NOT NULL THEN
      IF pro_id_l <> pro_id_p THEN
         naredba_l :=
            ' INSERT INTO lgas_promet_log'|| centar_M ||          ' ('||
            '    rn_id, rbr_stavke, pro_id, pro_id_kasa, pro_sifra)  '||
            ' VALUES (                                               '||
            '    :rn_id_l, :rbr_stavke_p, :pro_id_l, :pro_id_p, :pro_sifra_p )';
         EXECUTE IMMEDIATE naredba_l
            USING rn_id_l, rbr_stavke_p, pro_id_l, pro_id_p, pro_sifra_p;
      END IF;
   ELSIF sifgr_id_l IS NOT NULL THEN
      IF sifgr_id_l <> pro_id_p THEN
         naredba_l :=
            ' INSERT INTO lgas_promet_log'|| centar_M ||            ' ('||
            '    rn_id, rbr_stavke, sifgr_id, pro_id_kasa, pro_sifra)  '||
            ' VALUES (                                                 '||
            '    :rn_id_l, :rbr_stavke_p, :sifgr_id_l, :pro_id_p, :pro_sifra_p )';
         EXECUTE IMMEDIATE naredba_l
            USING rn_id_l, rbr_stavke_p, sifgr_id_l, pro_id_p, pro_sifra_p;
      END IF;
   END IF;
END;
FUNCTION POSTOJI_ARTIKAL
 (ID_P IN NUMBER
 ,SIFRA_P IN M_PROIZVODI.SIFRA%TYPE
 )
 RETURN NUMBER
 IS
--
  id_l m_proizvodi.id%TYPE;
  brojac_l NUMBER;
BEGIN
  IF id_p IS NULL AND sifra_p IS NULL THEN
    RETURN NULL;
  END IF;

  IF id_p IS NOT NULL THEN
    id_l := id_p;

    SELECT COUNT (1) INTO brojac_l
      FROM m_proizvodi
     WHERE id = id_p;

    IF brojac_l = 0 THEN
      SELECT COUNT (1) INTO brojac_l
        FROM m_sif_grupa
       WHERE id = id_p;

      IF brojac_l = 0 THEN
        id_l := NULL;
      END IF;
    END IF;
  END IF;

  IF id_l IS NULL THEN
    SELECT COUNT (1) INTO brojac_l
      FROM m_proizvodi
     WHERE sif_proizvoda_kasa = sifra_p;

    IF brojac_l = 1 THEN
      SELECT id INTO id_l
        FROM m_proizvodi
       WHERE sif_proizvoda_kasa = sifra_p;
    ELSE
      SELECT COUNT (1) INTO brojac_l
        FROM m_sif_grupa
       WHERE sif_proizvoda_kasa = sifra_p;

      IF brojac_l = 1 THEN
        SELECT id INTO id_l
          FROM m_sif_grupa
         WHERE sif_proizvoda_kasa = sifra_p;
      END IF;
    END IF;
  END IF;

  RETURN id_l;
END;
FUNCTION POSTOJI_NACPOT
 (ID_P IN NUMBER
 ,SIFRA_P IN M_NACPOT.SIFRA%TYPE
 )
 RETURN NUMBER
 IS
--
  id_l m_nacpot.id%TYPE;
  brojac_l NUMBER := 0;
BEGIN
  IF id_p IS NULL AND sifra_p IS NULL THEN
    RETURN NULL;
  END IF;

  IF id_p IS NOT NULL THEN
    SELECT COUNT (1) INTO brojac_l
      FROM m_nacpot
     WHERE id = id_p;
  END IF;

  IF brojac_l = 1 THEN
    id_l := id_p;
  ELSE
    SELECT COUNT (1) INTO brojac_l
      FROM m_nacpot
     WHERE sifra = sifra_p;

    IF brojac_l = 1 THEN
      SELECT id INTO id_l
        FROM m_nacpot
       WHERE sifra = sifra_p;
    ELSE
      id_l := NULL;
    END IF;
  END IF;

  RETURN id_l;
END;
FUNCTION POSTOJI_MT
 (ID_P IN NUMBER
 ,SIFRA_P IN M_MT.SIFRA%TYPE
 )
 RETURN NUMBER
 IS
--
  id_l m_mt.id%TYPE;
  brojac_l NUMBER := 0;
BEGIN
  IF id_p IS NULL AND sifra_p IS NULL THEN
    RETURN NULL;
  END IF;

  IF id_p IS NOT NULL THEN
    SELECT COUNT (1) INTO brojac_l
      FROM m_mt
     WHERE id = id_p;
  END IF;

  IF brojac_l = 1 THEN
    id_l := id_p;
  ELSE
    SELECT COUNT (1) INTO brojac_l
      FROM m_mt
     WHERE sifra = sifra_p;

    IF brojac_l = 1 THEN
      SELECT id INTO id_l
        FROM m_mt
       WHERE sifra = sifra_p;
    ELSE
      id_l := NULL;
    END IF;
  END IF;

  RETURN id_l;
END;
FUNCTION POSTOJI_GPOREZ
 (ID_P IN NUMBER
 ,SIFRA_P IN M_GPOREZ.SIFRA%TYPE
 )
 RETURN NUMBER
 IS
--
  id_l m_gporez.id%TYPE;
  brojac_l NUMBER := 0;
BEGIN
  IF id_p IS NULL AND sifra_p IS NULL THEN
    RETURN NULL;
  END IF;

  IF id_p IS NOT NULL THEN
    SELECT COUNT (1) INTO brojac_l
      FROM m_gporez
     WHERE id = id_p;
  END IF;

  IF brojac_l = 1 THEN
    id_l := id_p;
  ELSE
    SELECT COUNT (1) INTO brojac_l
      FROM m_gporez
     WHERE sifra = sifra_p;

    IF brojac_l = 1 THEN
      SELECT id INTO id_l
        FROM m_gporez
       WHERE sifra = sifra_p;
    ELSE
      id_l := NULL;
    END IF;
  END IF;

  RETURN id_l;
END;
FUNCTION POSTOJI_VPLACANJA
 (ID_P IN NUMBER
 ,SIFRA_P IN s_vplacanja.sifra%TYPE
 )
 RETURN NUMBER
 IS
--
  id_l s_vplacanja.id%TYPE;
  brojac_l NUMBER := 0;
BEGIN
  IF id_p IS NULL AND sifra_p IS NULL THEN
    RETURN NULL;
  END IF;

  IF id_p IS NOT NULL THEN
    SELECT COUNT (1) INTO brojac_l
      FROM s_vplacanja
     WHERE id = id_p;
  END IF;

  IF brojac_l = 1 THEN
    id_l := id_p;
  ELSE
    SELECT COUNT (1) INTO brojac_l
      FROM s_vplacanja
     WHERE sifra = sifra_p;

    IF brojac_l = 1 THEN
      SELECT id INTO id_l
        FROM s_vplacanja
       WHERE sifra = sifra_p;
    ELSE
      id_l := NULL;
    END IF;
  END IF;

  RETURN id_l;
END;
FUNCTION POSTOJI_KONOBAR
 (ID_P IN NUMBER
 ,SIFRA_P IN M_KONOBARI.SIFRA%TYPE
 )
 RETURN NUMBER
 IS
--
  id_l m_konobari.id%TYPE;
  brojac_l NUMBER := 0;
BEGIN
  IF id_p IS NULL AND sifra_p IS NULL THEN
    RETURN NULL;
  END IF;

  IF id_p IS NOT NULL THEN
    SELECT COUNT (1) INTO brojac_l
      FROM m_konobari
     WHERE id = id_p;
  END IF;

  IF brojac_l = 1 THEN
    id_l := id_p;
  ELSE
    SELECT COUNT (1) INTO brojac_l
      FROM m_konobari
     WHERE sifra = sifra_p;

    IF brojac_l = 1 THEN
      SELECT id INTO id_l
        FROM m_konobari
       WHERE sifra = sifra_p;
    ELSE
      id_l := NULL;
    END IF;
  END IF;

  RETURN id_l;
END;
FUNCTION POSTOJI_PISPORUKA
 (ID_P IN NUMBER
 ,SIFRA_P IN szmp_spisporuka.sifra%TYPE
 )
 RETURN NUMBER
 IS
--
  id_l szmp_spisporuka.id%TYPE;
  brojac_l NUMBER := 0;
BEGIN
  IF id_p IS NULL AND sifra_p IS NULL THEN
    RETURN NULL;
  END IF;

  IF id_p IS NOT NULL THEN
    SELECT COUNT (1) INTO brojac_l
      FROM szmp_spisporuka
     WHERE id = id_p;
  END IF;

  IF brojac_l = 1 THEN
     id_l := id_p;
  ELSE
    SELECT COUNT (1) INTO brojac_l
      FROM szmp_spisporuka
     WHERE sifra = sifra_p;

    IF brojac_l = 1 THEN
      SELECT id INTO id_l
        FROM szmp_spisporuka
       WHERE sifra = sifra_p;
    ELSE
      id_l := NULL;
    END IF;
  END IF;

  RETURN id_l;
END;
FUNCTION VPISPORUKAP_VPDOGADJAJA
 RETURN SYS_REFCURSOR
 IS
--
  rc SYS_REFCURSOR;
BEGIN
  OPEN rc FOR          
   SELECT vpispdog.vpispp_id, vpispdog.vpdog_id, vpispdog.vpispz_id 
      FROM s_vpisp_dog vpispdog,
                  s_vpisporukap vpispp,
                  s_vpisporukaz vpispz,
                  s_vpdogadjaja vpdog
     WHERE vpispdog.vpispp_id = vpispp.id
           AND vpispdog.vpispz_id = vpispz.id
           AND vpispdog.vpdog_id = vpdog.id
           AND (vpispp.dat_ponisten IS NULL OR vpispp.dat_ponisten > SYSDATE)
           AND (vpispz.dat_ponisten IS NULL OR vpispz.dat_ponisten > SYSDATE) 
           AND (vpdog.dat_ponisten IS NULL OR vpdog.dat_ponisten > SYSDATE);
  RETURN rc;
END;
FUNCTION KASE
 RETURN SYS_REFCURSOR
 IS
--
  rc SYS_REFCURSOR;
BEGIN
  /** Istarske toplice imaju dva oib-a: kasa 20000  Poliklinika, nije u sustavu pdv-a */
  /** GAS 1016 Prava konobara se definiraju u MISH: da ili ne. */
    
  OPEN rc FOR
   SELECT DISTINCT (kase.id) AS gas_kase_id,
           kase.sifra AS kase_sifra,
           kase.naziv AS kase_naziv,
           DECODE (pra_zmp_zaj.tekuci_cvor, 'itoplice', DECODE (kase.sifra, '20000', '14355845773', vlasnik.oib), vlasnik.oib) AS OIB,
           vlasnik.ozn_fsustava, NVL (ojpp.sifra, oj.sifra) AS poslovni_prostor,
           vlasnik.dat_primjene                             AS dat_primjene,
           pra_pka_i3fiskal.vlas_u_sust_pdv                 AS ozn_u_sus_pdv,
           NVL (kase.ozn_kase, '1')                         AS ozn_kase,
           kase.ozn_loyalty                                 AS ozn_loyalty,
           pra_zmp_zaj.zmppar_vrijednost ('GAS', '1016')    AS ozn_mish_prava,
           pra_zmp_zaj.zmppar_vrijednost ('GAS', '1041')    AS vise_placanja,
           ozn_online_prijepisa                             AS ozn_online_prijepisa,
           val1.sifra_3a                                    AS domaca_val,
           val.sifra_3a                                     AS prikaz_val,
           tec.tecaj                                        AS tecaj,
           tec1.tecaj                                       AS tecaj_prikaz     
      FROM mgmp_kase kase,
           m_mt_kase mtkase,
           s_vlasnik vlasnik,
           m_oj oj,
           m_oj ojpp,
           s_valute val,
           s_valute  val1,
           (SELECT (CASE WHEN  TRUNC(SYSDATE)  >= dat_primjene_domval THEN  domval_id ELSE domval0_id END) id FROM s_vlasnik) dom, 
           (SELECT (CASE WHEN  TRUNC(SYSDATE)  < dat_primjene_domval THEN  domval_id ELSE domval0_id END) id FROM s_vlasnik) dom1,
           (SELECT (CASE WHEN  TRUNC(SYSDATE)  >= dat_primjene_domval THEN  ROUND(1/izn_tecaja,14) ELSE izn_tecaja END) tecaj FROM s_vlasnik) tec, 
           (SELECT (CASE WHEN  TRUNC(SYSDATE)  < dat_primjene_domval THEN izn_tecaja  ELSE izn_tecaja END) tecaj FROM s_vlasnik) tec1
     WHERE kase.id = mtkase.kase_id
       AND gas_zaj.podreden (mtkase.mt_id, (SELECT oj_id FROM sgas_vlasnik)) = -1
       AND kase.metapl_sifra = 'POS'
       AND kase.dat_ponisten IS NULL
       AND kase.zmpojr_id = oj.id
       AND kase.zmpojrp_id = ojpp.id (+)
       AND dom1.id = val.id
       AND dom.id =  val1.id;

  RETURN rc;
END;
FUNCTION KONOBARI
 (KASE_ID_P IN m_kon_kase.kase_id%TYPE
 )
 RETURN SYS_REFCURSOR
 IS
--
  rc SYS_REFCURSOR;
  brojac_l NUMBER;
  ozn_fsustava_l s_vlasnik.ozn_fsustava%TYPE;
BEGIN
  SELECT ozn_fsustava INTO ozn_fsustava_l
    FROM s_vlasnik;

  IF ozn_fsustava_l = 'HR' THEN -- samo za HR fiskalizaciju je bitan OIB
    SELECT COUNT (1) INTO brojac_l
      FROM m_konobari kon,
           m_kon_kase konkase
     WHERE kon.id = konkase.kon_id
       AND konkase.kase_id = kase_id_p
       AND kon.oib IS NULL
       AND kon.aktivan = 'D';

    IF brojac_l > 0 THEN
      /* Provjerite OIB konobara */
      gas_zaj.vrati_poruku (-20423);
    END IF;
  END IF;

  OPEN rc FOR
    SELECT kon.id AS gas_kon_id,
           sifra AS kon_sifra,
           ime_prezime, 
           kon.lozinka, 
           kon.oib,
           nvl(kon.ime_prezime1,ime_prezime) naziv_za_ispis
      FROM m_konobari kon,
           m_kon_kase konkase
     WHERE konkase.kase_id = kase_id_p
       AND konkase.kon_id = kon.id AND aktivan = 'D';

  RETURN rc;
END;
FUNCTION VPLACANJA
 (KASE_ID_P IN mgmp_kase.id%TYPE
 ,NAC_ID_P IN m_kasa_np.nac_id%TYPE
 )
 RETURN SYS_REFCURSOR
 IS
--
  rc SYS_REFCURSOR;  
  gotovina_l t_rnkase.izn_placanja%TYPE := -1;   
  gas_param_1004_l szmp_parametri.vrijednost%TYPE;
BEGIN
           
  /* Ogranienje u poslovanju s gotovinom npr. 75.000,00 ili nebitno. */  
  IF pra_pka_zaj.vrijednost_parametra ('1093') <> 'nebitno' THEN
     SELECT TO_NUMBER (pra_pka_zaj.vrijednost_parametra ('1093'), '999G999D99', 'NLS_NUMERIC_CHARACTERS = '',.'' ')
       INTO gotovina_l
       FROM dual;                     
  END IF;         
 
  /*Monumenti trokove radi kao Opera susustav ali na POS kasi ima raziti plugin
   Parametar GAS 1004 Vanjski sustavi: 1 = Opera, 2 = Gartner, 3 = Protel  ili nebitno.
  */
  gas_param_1004_l := pra_zmp_zaj.zmppar_vrijednost ('GAS','1004');       
 
  IF pra_zmp_zaj.tekuci_cvor = 'kimonumenti' AND  gas_param_1004_l = '1' THEN   
     gas_param_1004_l := '3';
  END IF;
  
  OPEN rc FOR
    SELECT vpla.id AS gas_vpla_id,
           vpla.sifra AS vpla_sifra,
           vpla.naziv AS vpla_naziv,
           DECODE (vpla.ozn_irn, NULL, vpla.ozn_irn,
                   DECODE (gas_param_1004_l,'1', '7', '3', '8', vpla.ozn_irn)) AS ozn_irn,
           DECODE (vpla.ozn_obr, -1, 'D', 'N') AS ozn_obr,
           NULL                                   AS ozn_opod,
           vpla.br_kopija                         AS br_kopija,
           vppla.sifra                            AS ozn_fiskalizacije,
           (SELECT LISTAGG(zmpvplasus.sifra, ', ') WITHIN GROUP (ORDER BY zmpvplasus.sifra) 
              FROM mzmp_vpla_sus zmpvplasus, szmp_sustavi zmpsus
             WHERE zmpvplasus.zmpsus_id = zmpsus.id
               AND zmpsus.sifra = 'PKA'
               AND vpla.id = zmpvplasus.vpla_id)  AS card_issuer,
           DECODE(vppla.sifra,'G',gotovina_l, -1) AS maksimalni_iznos,
           vpla.ozn_napojnice                     AS ozn_napojnice
      FROM mgmp_kase kase,
           m_kasa_np kasanp,
           m_nac_vpla nacvpla,
           s_vplacanja vpla,
           s_vpplacanja vppla
     WHERE kase.id = kase_id_p
       AND kasanp.kase_id = kase_id_p
       AND kasanp.nac_id = nac_id_p
       AND nacvpla.nac_id = nac_id_p
       AND vpla.id = nacvpla.vpla_id
       AND vpla.ozn_kag = -1
       AND vpla.id IN (SELECT vpla_id
                         FROM m_vpla_val
                        WHERE oj_id = kase.zmpojr_id)
       AND vppla.id = vpla.vppla_id;

  RETURN rc;
END;
FUNCTION VPISPORUKAZ
 RETURN SYS_REFCURSOR
 IS
--
  rc SYS_REFCURSOR;
BEGIN
  OPEN rc FOR
    SELECT vpispz.id AS gas_vpispz_id,
           vpispz.sifra AS vpispz_sifra,
           vpispz.naziv AS vpispz_naziv,
           vpispz.stopa / 100 AS pdv,
           zmpspisp.sifra AS zmpspisp_sifra,
           oznaka.rbr AS oznaka
      FROM s_vpisporukaz vpispz,
           szmp_spisporuka zmpspisp,
           (SELECT stopa,
                   CHR(64 + ROW_NUMBER() OVER (ORDER BY stopa)) AS rbr
              FROM
                 ( SELECT DISTINCT(stopa) stopa
                     FROM s_vpisporukaz
                    WHERE dat_ponisten IS NULL)
             ORDER BY stopa ) oznaka 
     WHERE vpispz.zmpspisp_id = zmpspisp.id
       AND vpispz.stopa = oznaka.stopa;
     

  RETURN rc;
END;
FUNCTION MJESTA_TROSKA
 (KASE_ID_P IN m_mt_kase.kase_id%TYPE
 )
 RETURN SYS_REFCURSOR
 IS
--
  rc SYS_REFCURSOR;
BEGIN
  OPEN rc FOR
    SELECT mt_id AS gas_mt_id,
           mt.sifra,
           mt.naziv
      FROM m_mt mt,
           m_oj oj,
           m_mt_kase mtkase
     WHERE mtkase.mt_id = mt.id
       AND mt.id = oj.id
       AND TRUNC (sysdate) BETWEEN oj.dat_valjan AND NVL (oj.dat_ponisten, sysdate)
       AND mtkase.kase_id = kase_id_p;

   RETURN rc;
END;
FUNCTION GPOREZI
 RETURN SYS_REFCURSOR
 IS
--
  rc SYS_REFCURSOR;
BEGIN  
  OPEN rc FOR
    SELECT gpor.id AS gas_gpor_id,
           gpor.sifra AS sifra,
           gpor.naziv AS naziv,
           vpispz.stopa / 100 AS pdv,
           gpor.ppot / 100 AS ppot,
           vpispp.id AS gas_vpispp_id,
           vpispz.id AS gas_vpispz_id,
           zmpspisp.sifra AS sifra_spisp
      FROM m_gporez gpor,
           mgas_gpor_raz gporraz,
           s_vpisporukap vpispp,
           s_vpisporukaz vpispz,
           szmp_spisporuka zmpspisp
     WHERE gpor.ID = gporraz.gpor_id
       AND TRUNC (SYSDATE) BETWEEN gporraz.dat_valjan AND NVL (gporraz.dat_ponisten, SYSDATE)
       AND gporraz.vpispp_id = vpispp.id
       AND vpispp.vpispz_id = vpispz.id
       AND vpispz.zmpspisp_id = zmpspisp.id;
  RETURN rc;
END;
FUNCTION VPDOGADJAJA
 RETURN SYS_REFCURSOR
 IS
--
  rc SYS_REFCURSOR;
BEGIN
  OPEN rc FOR
    SELECT vpdog.id AS gas_vpdog_id,
           vpdog.sifra,
           vpdog.naziv,
           vpdog.dat_ponisten,
           vnap.naziv AS opis
      FROM s_vpdogadjaja vpdog,
           m_vnapomena vnap
     WHERE vpdog.vnap_id = vnap.id(+)
       AND (vpdog.dat_ponisten IS NULL OR vpdog.dat_ponisten > SYSDATE);

  RETURN rc;
END;
FUNCTION DOZVOLE
 (KASE_ID_P IN m_kon_kase.kase_id%TYPE
 ,KON_ID_P IN m_kon_kase.kon_id%TYPE
 )
 RETURN SYS_REFCURSOR
 IS
/*
Kasa uitava dozvole ovisno o GAS parametru 1016 Prava konobara se definiraju u MISH: da ili ne.
Parametar se prosljeuje na POS unutar fje KASE
*/
  rc SYS_REFCURSOR;
BEGIN
  OPEN rc FOR
    SELECT dozkon.sifra
      FROM m_kon_kase konkase,
           mgas_gdozvola_kon gdozkon,
           mgas_gdozvola_kon_sta gdozkons,
           sgas_dozvole_kon dozkon
     WHERE konkase.kase_id = kase_id_p
       AND konkase.kon_id = kon_id_p
       AND konkase.gdozkon_id = gdozkon.id
       AND gdozkon.id = gdozkons.gdozkon_id
       AND gdozkons.dozkon_id = dozkon.id;

  RETURN rc;
END;
FUNCTION CJENICI_KONOBARA
 (KON_ID_P IN m_kon_np.kon_id%TYPE
 ,KASE_ID_P IN m_kasa_np.kase_id%TYPE
 )
 RETURN SYS_REFCURSOR
 IS
--
  rc SYS_REFCURSOR;
BEGIN
  IF pra_zmp_zaj.zmppar_vrijednost ('GAS', '1028') = 1 THEN
    /*
    Veza izmeu konobara i naina potronje (NP) definira se:
    1 = za NP ukupno (5.tab u programu Konobari)

    Gleda se presjek izmeu tablica M_KON_NP i M_KASA_NP
    */

    OPEN rc FOR
      SELECT nac.sifra
        FROM m_kon_np konnp,
             m_nacpot nac
       WHERE konnp.kon_id = kon_id_p
         AND konnp.nac_id = nac.id
      INTERSECT
      SELECT nac.sifra
        FROM m_kasa_np kasanp,
             m_nacpot nac
       WHERE kasanp.kase_id = kase_id_p
         AND kasanp.nac_id = nac.id;
  ELSE
    /*
    Veza izmeu konobara i naina potronje (NP) definira se:
    2 = za svaku kasu (6.tab u Konobari)
    */

    OPEN rc FOR
      SELECT nac.sifra
        FROM m_kon_kase_np konkasenp,
             m_nacpot nac
       WHERE konkasenp.kon_id  = kon_id_p
         AND konkasenp.kase_id = kase_id_p
         AND konkasenp.nac_id  = nac.id;
  END IF;

  RETURN rc;
END;
FUNCTION VRATI_GAS_CVOR
 RETURN VARCHAR2
 IS
--
   brojac_l NUMBER;
   tekuci_cvor_l smet_cvorovi.sifra%TYPE;
   cvor_l smet_cvorovi.sifra%TYPE;
BEGIN
   SELECT sifra_tekuceg_cvora INTO tekuci_cvor_l
     FROM s_vlasnik;

   SELECT COUNT (*) INTO brojac_l
     FROM smet_instalacije
    WHERE metapl_sifra = 'GAS'
      AND metcvor_sifra = tekuci_cvor_l;

   IF brojac_l > 0 THEN
      NULL;
   ELSIF brojac_l = 0 THEN
      cvor_l := '@' || pra_zmp_zaj.zmppar_vrijednost ('ZMP', '0018');
   END IF;
   RETURN cvor_l;
END;
FUNCTION ZMPPAR_VRIJEDNOST
 (ZMPSUS_SIFRA_P IN VARCHAR2
 ,ZMPPAR_SIFRA_P IN VARCHAR2
 ,CVOR_P IN VARCHAR2 := NULL
 )
 RETURN VARCHAR2
 IS
--
  vrijednost_l szmp_parametri.vrijednost%TYPE;
  naredba_l    VARCHAR2(3200);
BEGIN
  IF cvor_p IS NULL OR pra_zmp_zaj.centar = 0 THEN
    SELECT pra_zmp_zaj.zmppar_vrijednost (zmpsus_sifra_p, zmppar_sifra_p)
      INTO vrijednost_l
      FROM dual;
  ELSE
    -- IRN 2819; sa Centra itaj vrijednost parametra na Objektu
    naredba_l :=
      'SELECT pra_zmp_zaj.zmppar_vrijednost<CVOR> (:zmpsus_sifra_p, :zmppar_sifra_p) FROM dual';
    EXECUTE IMMEDIATE REPLACE (naredba_l, '<CVOR>', cvor_p)
       INTO vrijednost_l
      USING zmpsus_sifra_p, zmppar_sifra_p;
  END IF;
  RETURN vrijednost_l;
END;
FUNCTION AUTOMATSKA_SINKRONIZACIJA
 (KASE_ID_P MGMP_KASE.ID%TYPE
 )
 RETURN NUMBER
 IS
--
  dat_sinkronizacije_l mgmp_kase.dat_sinkronizacije%TYPE;
  ozn_sinkronizacije_l mgmp_kase.ozn_sinkronizacije%TYPE;
BEGIN
  /*
  POS kase uitavaju matine podatke automatski, na temelju
  datuma i oznake sinkronizacije u modulu GAS1310 Kase: da ili ne.
  */
  IF pra_zmp_zaj.zmppar_vrijednost ('GAS', '1003') != 'da' THEN
    RETURN 0;
  END IF;

  SELECT dat_sinkronizacije, ozn_sinkronizacije
    INTO dat_sinkronizacije_l, ozn_sinkronizacije_l
    FROM mgmp_kase
   WHERE id = kase_id_p;

  IF ozn_sinkronizacije_l = 'N' OR NVL (dat_sinkronizacije_l, '31.12.3000') > SYSDATE THEN
    RETURN 0;
  END IF;

  RETURN -1;
END;
PROCEDURE AZURIRAJ_OZN_SINKRONIZACIJE
 (KASE_ID_P IN MGMP_KASE.ID%TYPE
 )
 IS
BEGIN
  IF automatska_sinkronizacija (kase_id_p) = -1 THEN
    UPDATE mgmp_kase
       SET ozn_sinkronizacije = 'N'
     WHERE id = kase_id_p;
  END IF;
END;
FUNCTION NP_LISTA
 (GMPKAS_ID_P IN mgmp_kase.id%TYPE
 )
 RETURN SYS_REFCURSOR
 IS
/*
IRN 2819; lista standardnih naina potronje za POS
Opis GAS parametra 1040 = ifre standardnih naina potronje za POS (odvojene zarezom) ili nebitno.
Standardni nain potronje znai NIJE s popustom odnosno NIJE akcijski.
*/
  rc_l sys_refcursor;
  cvor_l VARCHAR2(41);
  naredba_l VARCHAR2(3200);
  np_lista_l szmp_parametri.vrijednost%TYPE;
BEGIN
  IF gmpkas_id_p IS NULL THEN
    OPEN rc_l FOR SELECT NULL FROM dual WHERE 1 = 2; -- IRN 2930
    RETURN rc_l;
  END IF;

  SELECT NVL (zmpojr.metcvor_sifra_gas, zmpojr.metcvor_sifra) INTO cvor_l
    FROM mgmp_kase gmpkas,
         mzmp_ojr zmpojr
   WHERE gmpkas.id = gmpkas_id_p
     AND gmpkas.zmpojr_id = zmpojr.id;

  IF cvor_l = pra_zmp_zaj.tekuci_cvor THEN
    np_lista_l := pra_zmp_zaj.zmppar_vrijednost ('GAS', '1040');
  ELSIF cvor_l = pra_zmp_zaj.zmppar_vrijednost ('ZMP', '0018') THEN -- centar
    naredba_l := 'SELECT pra_zmp_zaj.zmppar_vrijednost<CVOR> (''GAS'', ''1040'') FROM dual';
    cvor_l := '@' || cvor_l;
    EXECUTE IMMEDIATE REPLACE (naredba_l, '<CVOR>', cvor_l) INTO np_lista_l;
  ELSE
    naredba_l := 'SELECT pra_pos_gas.zmppar_vrijednost<CVOR> (''GAS'', ''1040'', :cvor_l) FROM dual';
    centar_m := '@' || pra_zmp_zaj.zmppar_vrijednost ('ZMP', '0018');
    cvor_l := '@' || cvor_l;
    EXECUTE IMMEDIATE REPLACE (naredba_l, '<CVOR>', centar_m) INTO np_lista_l USING cvor_l;
  END IF;

  IF np_lista_l IS NULL OR np_lista_l = 'nebitno' THEN
    OPEN rc_l FOR SELECT NULL FROM dual WHERE 1 = 2; -- IRN 2930
    RETURN rc_l;
  END IF;

  OPEN rc_l FOR
    SELECT
       LTRIM (
         SUBSTR (',' || np_lista_l,
           INSTR (',' || np_lista_l, ',', 1, n) + 1,
           ABS (
             INSTR (',' || np_lista_l, ',', 1, n) + 1
             -
             NVL (LEAD (INSTR (',' || np_lista_l, ',', 1, n)) OVER (ORDER BY n), LENGTH (',' || np_lista_l) + 1)
             )
           )
         ) AS np_sifra
     FROM
       (
       SELECT ROWNUM n
       FROM dual
       CONNECT BY LEVEL <= LENGTH (',' || np_lista_l) - LENGTH (REPLACE (',' || np_lista_l, ','))
       );

  RETURN rc_l;
END;
FUNCTION PROMET_ZA_RAZDOBLJE
 (KASE_ID_P IN T_RNKASE.KASE_ID%TYPE
 ,DATUM1_P IN T_RNKASE.DATUM%TYPE
 ,DATUM2_P IN T_RNKASE.DATUM%TYPE
 )
 RETURN SYS_REFCURSOR
 IS
--
  rc SYS_REFCURSOR;
BEGIN   
  centar_M := vrati_gas_cvor;  
  OPEN rc FOR    
   ' SELECT kal.datum, NVL(promet.suma,0) suma,  NVL(promet.br_racuna, 0) br_racuna,       '||
   '        NVL(min_rbr,0) min_rbr,NVL(max_rbr,0) max_rbr, NVL(br_nefis_rn,0) br_nefis_rn, '||  
   '        NVL(izn_napojnice, 0) izn_napojnice                                            '||
   '   FROM (SELECT TO_DATE ('''||datum1_P||''') + ROWNUM - 1 datum                        '||
   '          FROM user_objects                                                            '||
   '         WHERE rownum <= TO_DATE('''||datum2_P||''') + 1 - TO_DATE('''||datum1_P||''') '||
   '        ) kal,                                                                         '||
   '       (SELECT rn.datum datum, SUM(rnpro.iznos) suma, COUNT(DISTINCT(rbr)) br_racuna,  '||
   '               MIN(abs(ltrim(rbr, 0))) min_rbr,MAX(abs(ltrim(rbr, 0))) max_rbr,        '|| 
   '               SUM(CASE WHEN rn.zastitni_kod IS NOT NULL AND rn.jir IS NULL THEN 1 ELSE 0 END) br_nefis_rn, '||  
   '               SUM(rn.izn_napojnice) izn_napojnice                                        '|| 
   '          FROM t_rnkase'|| centar_M ||' rn,                                            '||
   '              (select rnpro1.rn_id,SUM(rnpro1.iznos) iznos from t_rnkase_pro '|| centar_M ||' rnpro1 group by  rnpro1.rn_id ) rnpro '||
   '         WHERE rn.id = rnpro.rn_id                                                     '||
   '           AND rn.kase_id = ' || kase_id_P                                              ||
   '           AND rn.datum BETWEEN '''|| datum1_P ||''' AND '''||datum2_P  || ''''         ||
   '         GROUP BY rn.datum) promet                                                     '||
   ' WHERE kal.datum = promet.datum(+)                                                     '||
   ' ORDER BY 1';
   RETURN rc;   
  
END;
FUNCTION PROMET_ZA_DATUM
 (DATUM_P IN T_RNKASE.DATUM%TYPE
 )
 RETURN SYS_REFCURSOR
 IS
rc SYS_REFCURSOR;
BEGIN
   centar_M := vrati_gas_cvor;
  OPEN rc FOR
   ' SELECT NVL (promet.datum,'''|| datum_P ||''') datum, k.sifra sifra_kase, NVL(promet.suma,0) suma,  NVL(promet.br_racuna, 0) br_racuna,       '||
   '        NVL(min_rbr,0) min_rbr,NVL(max_rbr,0) max_rbr, NVL(br_nefis_rn,0) br_nefis_rn, NVL(izn_napojnice, 0) izn_napojnice  '||
   '   FROM (SELECT rn.datum datum,rn.kase_id, SUM(rnpro.iznos) suma, COUNT(DISTINCT(rbr)) br_racuna,  '||
   '               MIN(abs(ltrim(rbr, 0))) min_rbr,MAX(abs(ltrim(rbr, 0))) max_rbr,        '||
   '               SUM(CASE WHEN rn.zastitni_kod IS NOT NULL AND rn.jir IS NULL THEN 1 ELSE 0 END) br_nefis_rn, '||  
   '               SUM(rn.izn_napojnice) izn_napojnice                                        '||
   '          FROM t_rnkase'|| centar_M ||' rn,                                            '||
   '               m_kase'|| centar_M ||' kase,                                            '||
   '              (select rnpro1.rn_id,SUM(rnpro1.iznos) iznos from t_rnkase_pro '|| centar_M ||' rnpro1 group by  rnpro1.rn_id ) rnpro '||
   '         WHERE rn.id = rnpro.rn_id                                                     '||
   '           AND rn.datum = '''|| datum_P ||''''||
   '           AND rn.kase_id = kase.id                                                    '||
   '         GROUP BY rn.kase_id, rn.datum) promet,                                                  '||
   '       m_kase '|| centar_M ||' k                                                                        '||
   ' WHERE k.id = promet.kase_id(+)                                                        '||
   '   AND '''|| datum_P ||''' BETWEEN NVL (k.dat_valjan,'''|| datum_P ||''') AND NVL (k.dat_ponisten,'''|| datum_P ||''') '||
   '   AND k.metapl_sifra = ''POS''                                                         '||
   ' ORDER BY 1';
   RETURN rc;

END;
PROCEDURE UCITAJ_JIR
 (GODINA_P IN VARCHAR2
 ,KASE_ID_P IN T_RNKASE.KASE_ID%TYPE
 ,RBR_P IN T_RNKASE.RBR%TYPE
 ,ZASTITNI_KOD_P IN T_RNKASE.ZASTITNI_KOD%TYPE
 ,JIR_P IN T_RNKASE.JIR%TYPE
 )
 IS
--
   naredba_l VARCHAR2(3200);    
   jir_l  t_rnkase.jir%TYPE;
   id_l t_rnkase.id%TYPE;
BEGIN
   centar_M := vrati_gas_cvor; 
   BEGIN  
      IF zastitni_kod_p IS NOT NULL THEN
         naredba_l :=
           ' SELECT id                              '||
           '   FROM t_rnkase'||centar_M ||
           '  WHERE godina       = :godina__p       '||
           '    AND kase_id      = :kase_id_p       '||
           '    AND rbr          = :rbr_p           '||
           '    AND zastitni_kod = :zastitni_kod_p  '|| 
           '    AND jir IS NULL ';

        EXECUTE IMMEDIATE naredba_l INTO id_l USING godina_p, kase_id_p, rbr_p, zastitni_kod_p;
      END IF;
   EXCEPTION
      WHEN NO_DATA_FOUND THEN NULL;
   END;    
    
   IF id_l IS NOT NULL THEN       
      naredba_l :=
         'UPDATE t_rnkase'||centar_M || 
         '   SET jir = :jir_p       '||
         ' WHERE id  = :id_l ';
                                         
      EXECUTE IMMEDIATE naredba_l USING jir_p, id_l;
   END IF; 
END;
FUNCTION BR_SUBTOTAL
 (SUBTOTAL_P VARCHAR
 )
 RETURN NUMBER
 IS
/* datum zadnje promjene poreza '01.01.2020'
       nije bilo promjene kod subtotala
   */
   datum_l DATE := TO_DATE('01.01.2020', 'DD.MM.RRRR');
   br_subtotala_l NUMBER(2);
   sustav_l szmp_parametri.vrijednost%TYPE; 
   domaca_zemlja_l  szmp_parametri.vrijednost%TYPE;
BEGIN      
    sustav_l := pra_zmp_zaj.zmppar_vrijednost ('GAS', '1004');  
    domaca_zemlja_l := pra_zmp_zaj.zmppar_vrijednost ('ZMP', '0002');  
    /* Opera u HR */
    IF domaca_zemlja_l = 'HR' AND sustav_l = '1' THEN   
       CASE
       WHEN subtotal_p = 'HR 13+0' THEN
         br_subtotala_l := 1;
       WHEN subtotal_p = 'PI 13+0' THEN
         br_subtotala_l := 2;
       WHEN subtotal_p = 'HR 25+0' THEN
         br_subtotala_l := 3;
       WHEN subtotal_p = 'PI 13+3' THEN
         br_subtotala_l := 4;
       WHEN subtotal_p = 'PI 25+0' THEN
         br_subtotala_l := 5;
       WHEN (subtotal_p = 'PI 25+3'  OR subtotal_p = 'HR 25+3' ) THEN          /* za subtotal br 6 postoje dva retka */
         br_subtotala_l := 6;   
       WHEN subtotal_p = 'OS 25+0' THEN
         br_subtotala_l := 7;
       WHEN subtotal_p = 'HR 5+0' THEN
         br_subtotala_l := 8;
       WHEN subtotal_p = 'S1 25+0' THEN
         br_subtotala_l := 9;
       WHEN subtotal_p = 'TR 25+0' THEN
         br_subtotala_l:= 10;
       WHEN subtotal_p = 'S2 25+0' THEN
         br_subtotala_l:= 11;
       WHEN subtotal_p = 'S3 25+0' THEN
         br_subtotala_l := 12;
       WHEN subtotal_p = 'IZ 0+0' THEN
         br_subtotala_l := 13;
       WHEN subtotal_p = 'OS 0+0' THEN
         br_subtotala_l := 14;
       WHEN subtotal_p = 'PR 25+0' THEN
         br_subtotala_l := 15;
       ELSE
         br_subtotala_l := -1;   /* Za POS znai da nepostojei subtotal */
       END CASE;  
    ELSIF  domaca_zemlja_l = 'AT' AND sustav_l = '1' THEN
       CASE
       WHEN subtotal_p = 'SP 10+0' THEN
         br_subtotala_l := 1;
       WHEN subtotal_p = 'GE 20+0' THEN
         br_subtotala_l := 2;
       WHEN subtotal_p = 'MA 20+0' THEN
         br_subtotala_l := 3; 
       WHEN subtotal_p = 'AN 20+0' THEN
         br_subtotala_l := 4;  
       WHEN subtotal_p = 'AN 0+0' THEN
         br_subtotala_l := 5; 
       WHEN subtotal_p = 'SP 20+0' THEN
         br_subtotala_l := 6;  
       WHEN subtotal_p = 'EX 0+0' THEN
         br_subtotala_l := 7; 
       WHEN subtotal_p = 'PR 10+0' THEN
         br_subtotala_l := 8;        
       ELSE
         br_subtotala_l := -1;   /* Za POS znai da nepostojei subtotal */   
       END CASE;
    ELSE
       br_subtotala_l := -1;   /* Za POS znai da nepostojei subtotal */
    END IF;
    
    RETURN br_subtotala_l;
  END;
FUNCTION R_POSSO_DOHVATI_ZAGLAVLJA
 (KASE_ID_P MGMP_KASE.ID%TYPE
 ,DATUM_P DATE
 )
 RETURN SYS_REFCURSOR
 IS
l_rc SYS_REFCURSOR;
BEGIN
    -- vreca uvijek centar
    centar_M := vrati_pso_cvor;
    -- vraca narudbe koje nisu preuzete za kasu i datum od
    OPEN l_rc FOR
         'SELECT psonar.id                AS nar_id, 
                 nvl(psonar.br_nar,psonar.rbr) AS rbr,
                 psonar.godina            AS godina,
                 psonar.unos_dat          AS datum_vrijeme,
                 to_char(psonar.vrijeme_isporuke,''hh24:mi'') AS vrijeme_dostave,
                 psolok.sifra             AS sifra_lokacije,
                 psolok.naziv             AS naziv_lokacije,
                 nacpot.sifra             AS sifra_nacpot,
                 nacpot.naziv             AS naziv_nacpot,
                 vpla.sifra               AS sifra_vpla,
                 vpla.naziv               AS naziv_vpla,
                 so.id                    AS so_id,
                 so.sifra                 AS so_sifra,
                 psonar.napomena          AS komentar,
                 psonarpro.iznos          AS total,
                 nvl(sj.broj,psonar.br_sobe) AS broj_sobe,
                 psonar.ozn_placanja      AS ozn_placeno,
                 psonar.izn_napojnice     AS izn_napojnice,
                 psonar.izvor             AS izvor       
            FROM tpso_narudzbe'||centar_M ||' psonar, 
                 mpso_lokacije'||centar_M ||' psolok,
                 m_nacpot'||centar_M ||' nacpot,
                 m_sj'||centar_M ||' sj,
                 m_so'||centar_M ||' so,
                 s_vplacanja'||centar_M ||' vpla,
                 (SELECT st.psonar_id psonar_id,SUM(st.kolicina * st.cijena) iznos
                    FROM tpso_nar_pro'||centar_M ||' st 
                   GROUP BY st.psonar_id) psonarpro 
           WHERE psolok.id = psonar.psolok_id
             AND nacpot.id = psolok.nac_id
             AND sj.id(+)= psolok.sj_id
             AND so.id(+) = sj.so_id
             AND psonarpro.psonar_id = psonar.id
             AND vpla.id(+) = psonar.vpla_id 
             AND psonar.ozn_valjanosti  = ''V''
             AND psonarpro.iznos > 0 
             AND psolok.kase_id = '|| kase_id_p ||'
             AND psonar.datum >= '''|| datum_p ||'''		
             AND psonar.datum_preuzimanja IS NULL';
 
     RETURN l_rc;
END;
FUNCTION R_POSSO_DOHVATI_STAVKE
 (NAR_ID_P TPSO_NARUDZBE.ID%TYPE
 )
 RETURN SYS_REFCURSOR
 IS
l_rc SYS_REFCURSOR;
BEGIN
    -- vreca uvijek centar
    centar_M := vrati_pso_cvor;
    -- vraca stavke narudbe za ID narudbe i kolicinu > 0 (koje nisu stornirane)
    OPEN l_rc FOR
     'SELECT t.sifra_artikla AS sifra_artikla,
             t.naziv_artikla AS naziv_artikla, 
             sum(t.kolicina) AS kolicina,
             sum(t.iznos) AS iznos,
             avg(t.jedinicna_cijena) jedinicna_cijena,
             min(t.komentar) komentar
        FROM (SELECT pro.sif_proizvoda_kasa AS sifra_artikla,pro.naziv as naziv_artikla,
                     psonarpro.kolicina AS kolicina,psonarpro.cijena AS jedinicna_cijena,
                     psonarpro.kolicina * psonarpro.cijena AS iznos,
                     psonarpro.napomena AS komentar,
                     SUM(psonarpro.kolicina) over(PARTITION BY psonarpro.psonar_id, psonarpro.pro_id) sum_kol 
                FROM tpso_nar_pro'||centar_M ||'  psonarpro,'||
                   ' m_proizvodi'||centar_M ||' pro'||
            '  WHERE  psonarpro.PRO_ID = pro.id
                 AND psonarpro.psonar_id = '||nar_id_p ||') t
       WHERE t.sum_kol > 0
       GROUP BY t.sifra_artikla, t.naziv_artikla';
    
    RETURN l_rc;
END;
FUNCTION R_POSSO_DOHVATI_PO_ID
 (NAR_ID_P TPSO_NARUDZBE.ID%TYPE
 )
 RETURN SYS_REFCURSOR
 IS
l_rc SYS_REFCURSOR;
 naredba_l    VARCHAR2(3200);
BEGIN
    -- vreca uvijek centar
    centar_M := vrati_pso_cvor;
    -- vraca narudbu za ID narudbe i update datuma preuzimanja u narudbi  
    OPEN l_rc FOR
       'SELECT psonar.id                AS nar_id, 
               nvl(psonar.br_nar,psonar.rbr) AS rbr,
               psonar.godina            AS godina,
               psonar.unos_dat          AS datum_vrijeme,
               to_char(psonar.vrijeme_isporuke,''hh24:mi'') AS vrijeme_dostave,
               psolok.sifra             AS sifra_lokacije,
               psolok.naziv             AS naziv_lokacije,
               nacpot.sifra             AS sifra_nacpot,
               nacpot.naziv             AS naziv_nacpot,
               vpla.sifra               AS sifra_vpla,
               vpla.naziv               AS naziv_vpla,
               so.id                    AS so_id,
               so.sifra                 AS so_sifra,
               psonar.napomena||CHR(10)|| 
                 DECODE((SELECT COUNT(1)
                           FROM tpso_nar_pro'||centar_M ||' narp, m_proizvodi'||centar_M ||' pro
                          WHERE narp.pro_id = pro.id
                            AND narp.psonar_id = psonar.id
                            AND pro.sifra = pra_zmp_zaj.zmppar_vrijednost'||centar_M ||'(''PSO'', ''0004'')), 1,
                                pra_zmp_zaj.poruka(''GAS'',-20515), 
                                pra_zmp_zaj.poruka(''GAS'',-20516)) AS komentar,
               psonarpro.iznos          AS total,
               nvl(sj.broj,psonar.br_sobe) AS broj_sobe,
               psonar.ozn_placanja       AS ozn_placeno,
               psonar.izn_napojnice      AS izn_napojnice,
               psonar.izvor              AS izvor       
          FROM tpso_narudzbe'||centar_M ||' psonar, 
                mpso_lokacije'||centar_M ||' psolok,
                m_nacpot'||centar_M ||' nacpot,
                m_sj'||centar_M ||' sj,
                m_so'||centar_M ||' so,
                s_vplacanja'||centar_M ||' vpla,
                (SELECT st.psonar_id psonar_id,SUM(st.kolicina * st.cijena) iznos
                  FROM tpso_nar_pro'||centar_M ||' st 
                 GROUP BY st.psonar_id) psonarpro 
          WHERE psolok.id = psonar.psolok_id
            AND nacpot.id = psolok.nac_id
            AND sj.id(+)= psolok.sj_id
            AND so.id(+) = sj.so_id
            AND psonarpro.psonar_id = psonar.id
            AND vpla.id(+) = psonar.vpla_id   
            AND psonar.ozn_valjanosti  = ''V''
            AND psonarpro.iznos > 0 
            AND psonar.id = '|| nar_id_p ||'		
            AND psonar.datum_preuzimanja IS NULL';
     
             
      RETURN l_rc;  
      
END r_posso_dohvati_po_id;
FUNCTION VRATI_PSO_CVOR
 RETURN VARCHAR2
 IS
  tekuci_cvor_l smet_cvorovi.sifra%TYPE;
   cvor_l smet_cvorovi.sifra%TYPE;
BEGIN
   SELECT sifra_tekuceg_cvora INTO tekuci_cvor_l
     FROM s_vlasnik;

   IF lower(tekuci_cvor_l) =  lower(pra_zmp_zaj.zmppar_vrijednost ('ZMP', '0018')) THEN
      NULL;
   ELSE
      cvor_l := '@' || pra_zmp_zaj.zmppar_vrijednost ('ZMP', '0018');
   END IF;
   RETURN cvor_l;
END;
FUNCTION DOZVOLJEN_PRIJEPIS
 (DATUM_P IN DATE
 )
 RETURN NUMBER
 IS

  konverzija_l NUMBER;
  primjena_l NUMBER;

CURSOR c_konverzija IS 
SELECT COUNT (*)
  FROM lpka_promjene_domval
 WHERE oznaka = 'M_ASO_KASE' ;

CURSOR c_primjena (datum_p DATE) IS    
SELECT COUNT (*) 
  FROM s_vlasnik vla
 WHERE TRUNC (SYSDATE) >= vla.dat_primjene_domval
      AND pra_zmp_zaj.zmppar_vrijednost('ZMP', '0002') = 'HR';
BEGIN
  
  RETURN -1;
  
  /* koristilo se za provjeru prije 01.01.2023 pa je stavljeno u komentar*/   
  
 /*\* provjera konverzije *\
 OPEN c_konverzija;
   FETCH c_konverzija INTO konverzija_l;
 CLOSE c_konverzija;

 \* provjera primjene *\
 OPEN c_primjena (datum_p);
   FETCH c_primjena INTO primjena_l;
 CLOSE c_primjena;
 
  \* Samo ako su cijene konvertirane prije datuma primjene, ne moe se prepisati na kasu *\
 IF konverzija_l = 1 AND primjena_l = 0 THEN
   RETURN 0;
 ELSE
   RETURN -1;
 END IF;*/
END;
PROCEDURE POSSO_POTVRDA_NAPLATE
 (NAR_ID_P IN TPSO_NARUDZBE.ID%TYPE
 ,POS_BROJ_P IN TPSO_NARUDZBE.POS_BROJ%TYPE
 )
 IS
naredba_l    VARCHAR2(3200);
BEGIN
    -- vraa uvijek centar
    centar_M := vrati_pso_cvor;
    -- aurira broj rauna iz POS-a
    naredba_l :=
     'BEGIN '||
     '  UPDATE tpso_narudzbe'||centar_M ||' psonar '||
     '     SET psonar.pos_broj = :pos_broj '||
     '   WHERE psonar.id = :nar_id;'||
     ' END;';
    EXECUTE IMMEDIATE naredba_l
      USING pos_broj_p, nar_id_p;

END POSSO_POTVRDA_NAPLATE;
FUNCTION UPISI_DATUM_ZABRANE
 (KASE_ID_P MPSO_LOKACIJE.KASE_ID%TYPE
 ,VRIJEME_P NUMBER
 )
 RETURN TIMESTAMP
 IS
--
  naredba_l    VARCHAR2(3200);
  dat_pso_l    TIMESTAMP;
BEGIN
    -- vraa uvijek centar
    centar_M := vrati_pso_cvor;

    naredba_l :=
     'BEGIN '||
     '  UPDATE mpso_lokacije'||centar_M ||' psolok '||
     '     SET psolok.dat_pso = SYSDATE + INTERVAL ''' ||VRIJEME_P|| ''' MINUTE'||
     '   WHERE psolok.kase_id = :kase_id; '||
     'END;';
    EXECUTE IMMEDIATE naredba_l
      USING kase_id_p;

    naredba_l :=
    'BEGIN ' ||
    '  SELECT MIN(dat_pso) ' ||
    '    INTO :dat_pso ' ||
    '    FROM mpso_lokacije' || centar_M ||
    '   WHERE kase_id = :kase_id;' ||
    'END;';
    
    EXECUTE IMMEDIATE naredba_l 
      USING OUT dat_pso_l, IN kase_id_p;
     
    RETURN dat_pso_l;
END;
PROCEDURE BRISI_DATUM_ZABRANE
 (KASE_ID_P MPSO_LOKACIJE.KASE_ID%TYPE
 )
 IS
--
  naredba_l    VARCHAR2(3200);
BEGIN
    -- vraa uvijek centar
    centar_M := vrati_pso_cvor;

    naredba_l :=
     'BEGIN '||
     '  UPDATE mpso_lokacije'||centar_M ||' psolok '||
     '     SET psolok.dat_pso = null'||
     '   WHERE psolok.kase_id = :kase_id; '||
     'END;';
    EXECUTE IMMEDIATE naredba_l
      USING kase_id_p;
END BRISI_DATUM_ZABRANE;
PROCEDURE UPDATE_NAPOJNICE
 (GODINA_P IN VARCHAR2
 ,KASE_ID_P IN T_RNKASE.KASE_ID%TYPE
 ,RBR_P IN T_RNKASE.RBR%TYPE
 ,VPLA_NAPOJNICE_ID_P IN T_RNKASE.VPLA_NAPOJNICE_ID%TYPE
 ,IZN_NAPOJNICE_P IN T_RNKASE.IZN_NAPOJNICE%TYPE
 ,DATUM_NAPOJNICE_P IN T_RNKASE.DATUM_NAPOJNICE%TYPE
 ,ROWCOUNT_P OUT NUMBER
 )
 IS
--
   naredba_l VARCHAR2(3200);
   id_l t_rnkase.id%TYPE;
BEGIN  
   centar_M := vrati_gas_cvor;
   BEGIN
         naredba_l :=
           ' SELECT id                              '||
           '   FROM t_rnkase'||centar_M ||
           '  WHERE godina       = :godina__p       '||
           '    AND kase_id      = :kase_id_p       '||
           '    AND rbr          = :rbr_p           ';

        EXECUTE IMMEDIATE naredba_l INTO id_l USING godina_p, kase_id_p, rbr_p;
   EXCEPTION
      WHEN NO_DATA_FOUND THEN NULL;
   END;

   IF id_l IS NOT NULL THEN
      naredba_l :=
         'UPDATE t_rnkase'||centar_M ||
         '   SET vpla_napojnice_id = :vpla_napojnice_id_p, '||
		 '       izn_napojnice = :izn_napojnice_p, '||
         '       datum_napojnice = :datum_napojnice_p '||
         ' WHERE id  = :id_l ';

      EXECUTE IMMEDIATE naredba_l USING vpla_napojnice_id_p, izn_napojnice_p, datum_napojnice_p, id_l;
   END IF;
   rowcount_p := SQL%ROWCOUNT;
END;
PROCEDURE UPDATE_VPLACANJA
 (GODINA_P IN VARCHAR2
 ,KASE_ID_P IN T_RNKASE.KASE_ID%TYPE
 ,RBR_P IN T_RNKASE.RBR%TYPE
 ,VPLA_ID_P IN T_RNKASE.VPLA_ID%TYPE
 ,VPLA2_ID_P IN T_RNKASE.VPLA2_ID%TYPE
 ,ROWCOUNT_P OUT NUMBER
 )
 IS
--
   naredba_l VARCHAR2(3200);
   id_l t_rnkase.id%TYPE;
BEGIN
   centar_M := vrati_gas_cvor;
   BEGIN
         naredba_l :=
           ' SELECT id                              '||
           '   FROM t_rnkase'||centar_M ||
           '  WHERE godina       = :godina__p       '||
           '    AND kase_id      = :kase_id_p       '||
           '    AND rbr          = :rbr_p           ';

        EXECUTE IMMEDIATE naredba_l INTO id_l USING godina_p, kase_id_p, rbr_p;
   EXCEPTION
      WHEN NO_DATA_FOUND THEN NULL;
   END;

   IF id_l IS NOT NULL THEN 
      naredba_l :=
         'UPDATE t_rnkase'||centar_M ||
         '   SET vpla_id = :vpla_id_p, '||
		 '       vpla2_id = :vpla2_id_p '||
         ' WHERE id  = :id_l ';

      EXECUTE IMMEDIATE naredba_l USING vpla_id_p, vpla2_id_p, id_l;
   END IF;
   rowcount_p := SQL%ROWCOUNT;
END;
PROCEDURE UPDATE_DATUM_PREUZIMANJA
 (NAR_ID_P IN tpso_narudzbe.id%type
 )
 IS
  naredba_l VARCHAR2(3200);
BEGIN
  centar_M := vrati_pso_cvor;
  naredba_l :=
   'BEGIN '||
   '  UPDATE tpso_narudzbe'||centar_M ||' psonar '||
   '     SET psonar.datum_preuzimanja = SYSDATE '||
   '   WHERE psonar.id = :nar_id '||
   '     AND psonar.datum_preuzimanja IS NULL;
  END;';
  EXECUTE IMMEDIATE naredba_l
    USING nar_id_p;

END;

END PRA_POS_GAS;
/
SHOW ERROR

