-- C:\Radni\pra_pka_s.pkb
--
-- Generated for Oracle 10g on Fri Oct 03  08:44:51 2025 by Server Generator 6.5.96.5.6
 

PROMPT Creating Package Body 'PRA_PKA_S'
CREATE OR REPLACE PACKAGE BODY PRA_PKA_S IS

MINUS_PDV_IZV_M NUMBER(1) := NULL;
MINUS_ODBITAK_IZV_M NUMBER(1) := NULL;


FUNCTION KUP_VPOBV_ID
 (GMPKOM_ID_P IN TPKA_RACUNI.GMPKOM_ID%TYPE
 ,PKAADR_ID_P IN TPKA_RACUNI.PKAADR_ID%TYPE
 )
 RETURN s_vpobveznika.id%TYPE
 IS
-- Vrsta poreznih obveznika kojoj pripada kupac
  CURSOR gmpkom_c IS
    SELECT vpobv_id
      FROM mgmp_komitenti
     WHERE id = gmpkom_id_p;
  CURSOR pkaadr_c IS
    SELECT vpobv_id
      FROM mpka_adrese
     WHERE id = pkaadr_id_p;
  kupac_vpobv_id_l s_vpobveznika.id%TYPE;
BEGIN
  IF gmpkom_id_p IS NULL
    AND pkaadr_id_p IS NULL
  THEN
    kupac_vpobv_id_l := NULL;
  END IF;
  IF gmpkom_id_p IS NOT NULL THEN
    OPEN gmpkom_c;
    FETCH gmpkom_c INTO kupac_vpobv_id_l;
    IF gmpkom_c%NOTFOUND THEN
       kupac_vpobv_id_l := NULL;
    END IF;
    CLOSE gmpkom_c;
  END IF;
  IF pkaadr_id_p IS NOT NULL THEN
    OPEN pkaadr_c;
    FETCH pkaadr_c INTO kupac_vpobv_id_l;
    IF pkaadr_c%NOTFOUND THEN
       kupac_vpobv_id_l := NULL;
    END IF;
    CLOSE pkaadr_c;
  END IF;
  RETURN (kupac_vpobv_id_l);
END;
FUNCTION KUP_BR_POREZNI
 (GMPKOM_ID_P IN TPKA_RACUNI.GMPKOM_ID%TYPE
 ,PKAADR_ID_P IN TPKA_RACUNI.PKAADR_ID%TYPE
 )
 RETURN VARCHAR2
 IS
-- ifra i porezni broj kupca
  CURSOR gmpkom_c IS
    SELECT gmpkom.sifra  || ', ' ||
             NVL (
               DECODE (zem.sifra_2a, pra_zmp_zaj.vrijednost_parametra ('0002'), -- IRN 2032
                 gmpkom.oib,
                 gmpkom.br_porezni),
               '-')
      FROM mgmp_komitenti gmpkom,
           s_zemlje zem
     WHERE gmpkom.id = gmpkom_id_p
       AND gmpkom.zem_id = zem.id;

  CURSOR pkaadr_c IS
    SELECT 'Adresa ' || pkaadr.rbr || ', ' ||
              NVL (
                DECODE (zem.sifra_2a, pra_zmp_zaj.vrijednost_parametra ('0002'), -- IRN 2032
                  pkaadr.oib,
                  pkaadr.br_porezni),
                '-')
      FROM mpka_adrese pkaadr,
           s_zemlje zem
     WHERE pkaadr.id = pkaadr_id_p
       AND pkaadr.zem_id = zem.id;

  kupac_br_porezni_l VARCHAR2(100);
BEGIN
  IF gmpkom_id_p IS NULL
    AND pkaadr_id_p IS NULL
  THEN
    kupac_br_porezni_l := NULL;
  END IF;

  IF gmpkom_id_p IS NOT NULL THEN
    OPEN gmpkom_c;
    FETCH gmpkom_c INTO kupac_br_porezni_l;
    CLOSE gmpkom_c;
  ELSIF pkaadr_id_p IS NOT NULL THEN
    OPEN pkaadr_c;
    FETCH pkaadr_c INTO kupac_br_porezni_l;
    CLOSE pkaadr_c;
  END IF;

  RETURN (kupac_br_porezni_l);
END;
FUNCTION KUP_NAZIV
 (GMPKOM_ID_P IN TPKA_RACUNI.GMPKOM_ID%TYPE
 ,PKAADR_ID_P IN TPKA_RACUNI.PKAADR_ID%TYPE
 )
 RETURN VARCHAR2
 IS
-- Naziv i sjedite kupca
  CURSOR gmpkom_c IS
    SELECT gmpkom.naziv || ', ' ||
           DECODE (gmpkom.zem_id, pra_zmp_zaj.domaca_zemlja,
                   NVL (pos.naziv, zem.sifra_2a),
                   zem.sifra_2a)
      FROM mgmp_komitenti gmpkom,
           s_zemlje zem,
           m_poste pos
     WHERE gmpkom.id = gmpkom_id_p
       AND gmpkom.zem_id = zem.id
       AND gmpkom.pos_id = pos.id (+);
  CURSOR pkaadr_c IS
    SELECT DECODE (pkaadr.prezime, NULL,
                   pkaadr.naz_poduzeca || ', ' ||
                     DECODE (pkaadr.zem_id, pra_zmp_zaj.domaca_zemlja,
                             NVL (pos.naziv, NVL(pkaadr.naz_mjesta,zem.sifra_2a)),
                             zem.sifra_2a),
                   pkaadr.prezime || ', ' || NVL (pkaadr.ime, '-') || ', ' ||
                     DECODE (pkaadr.zem_id, pra_zmp_zaj.domaca_zemlja,
                             NVL (pos.naziv, NVL(pkaadr.naz_mjesta,zem.sifra_2a)),
                             zem.sifra_2a))
      FROM mpka_adrese pkaadr,
           s_zemlje zem,
           m_poste pos
     WHERE pkaadr.id = pkaadr_id_p
       AND pkaadr.zem_id = zem.id
       AND pkaadr.pos_id = pos.id (+);
  kupac_naziv_l VARCHAR2(100);
BEGIN
  IF gmpkom_id_p IS NULL
    AND pkaadr_id_p IS NULL
  THEN
    kupac_naziv_l := NULL;
  END IF;
  IF gmpkom_id_p IS NOT NULL THEN
    OPEN gmpkom_c;
    FETCH gmpkom_c INTO kupac_naziv_l;
    IF gmpkom_c%NOTFOUND THEN
       kupac_naziv_l := NULL;
    END IF;
    CLOSE gmpkom_c;
  END IF;
  IF pkaadr_id_p IS NOT NULL THEN
    OPEN pkaadr_c;
    FETCH pkaadr_c INTO kupac_naziv_l;
    IF pkaadr_c%NOTFOUND THEN
       kupac_naziv_l := NULL;
    END IF;
    CLOSE pkaadr_c;
  END IF;
  RETURN (kupac_naziv_l);
END;
FUNCTION IZN_PKARACPDV
 (PKARAC_ID_P IN IPKA_RAC_PDV.PKARAC_ID%TYPE
 ,VPISPZ_ID_P IN IPKA_RAC_PDV.VPISPZ_ID%TYPE
 ,OSNOVICA_P IN NUMBER
 )
 RETURN ipka_rac_pdv.iznos%TYPE
 IS
/*
Zaraunata osnovica (-1) ili porez (0) po raunu
Iznos poreza = iznos bruto - iznos neto
*/
  iznos_l ipka_rac_pdv.iznos%TYPE;
BEGIN
  SELECT DECODE (osnovica_p,
         -1, NVL (SUM (ROUND (iznos, 2)), 0),
          0, NVL (SUM (ROUND (iznos * (1 + stopa_pdv / 100), 2) - ROUND (iznos, 2)), 0))
    INTO iznos_l
    FROM ipka_rac_pdv
   WHERE pkarac_id = pkarac_id_p
     AND vpispz_id = vpispz_id_p;
  RETURN iznos_l;
END;
FUNCTION IZN_PREDUJMA
 (PKARAC_ID_P IN TPKA_RACUNI.ID%TYPE
 )
 RETURN tpka_rac_pred.iznos%TYPE
 IS
-- Iznos iskoritenog predujma
  iznos_l tpka_rac_pred.iznos%TYPE;
BEGIN
  SELECT NVL (SUM (ROUND (iznos * izn_tecaja, 2)), 0)
    INTO iznos_l
    FROM tpka_rac_pred
   WHERE pkarac_id = pkarac_id_p;
  RETURN iznos_l;
END;
FUNCTION DAT_ZABRANJEN
 (OJ_ID_P IN TPKA_ZABRANE.OJ_ID%TYPE
 ,NAZ_TABLICE_P IN TPKA_ZABRANE.NAZ_TABLICE%TYPE
 )
 RETURN DATE
 IS
-- Funkcija vraa najvei zabranjen (vaei) datum za oj i njoj nadreene OJ
  dat_zabranjen_l tpka_zabrane.datum%TYPE;
BEGIN
  SELECT MAX (datum) INTO dat_zabranjen_l
    FROM tpka_zabrane
   WHERE oj_id IN (
         SELECT id
           FROM m_oj
          START WITH id = oj_id_p
        CONNECT BY PRIOR oj_id = id)
     AND oznaka IN ('V')
     AND UPPER (naz_tablice) = UPPER (naz_tablice_p);
  RETURN NVL (dat_zabranjen_l, TO_DATE ('01.01.2000', 'DD.MM.RRRR'));
END;
PROCEDURE PROVJERI_DAT_ZABRANJEN
 (OJ_ID_P IN TPKA_ZABRANE.OJ_ID%TYPE
 ,NAZ_TABLICE_P IN TPKA_ZABRANE.NAZ_TABLICE%TYPE
 ,DATUM_P IN TPKA_ZABRANE.DATUM%TYPE
 )
 IS
BEGIN
  IF oj_id_p IS NULL
    OR naz_tablice_p IS NULL
    OR datum_p IS NULL
  THEN
    RETURN;
  END IF;
  IF datum_p <= pra_pka_s.dat_zabranjen (oj_id_p, naz_tablice_p) THEN
    -- Zabranjeno je auriranje s datumom manjim od #0.
    pra_pka_zaj.vrati_poruku (
      -20061,
      TO_CHAR (pra_pka_s.dat_zabranjen (oj_id_p, naz_tablice_p), 'DD.MM.RRRR'));
  END IF;
END;
FUNCTION DAT_ZADNJEG_IZVJESTAJA
 (ZMPHIJ_ID_P IN ipka_izv_hij.zmphij_id%TYPE := NULL
 ,OZN_OSTVARENO_P IN ipka_izvjestaji.ozn_ostvareno%TYPE := -1
 )
 RETURN DATE
 IS
-- ako parametar zmphij_id_p = NULL (DEFAULT) funkcija vraa datum zadnjeg izv
-- ako parametar zmphij_id_p <> NULL, vraa datum zadnjeg izv za tu hijerarhiju
-- ako je ozn_ostvareno_p = -1 (DEFAULT) vraa datum zadnjeg izv za ostvareno, ako = 0 vraa datum zadnjeg izv za planirano
  dat_zadnjeg_izvjestaja_l ipka_izvjestaji.datum%TYPE := NULL;
BEGIN
  IF zmphij_id_p IS NOT NULL THEN
    SELECT MAX (datum) INTO dat_zadnjeg_izvjestaja_l
      FROM ipka_izvjestaji pkaizv, ipka_izv_hij pkaizvhij
     WHERE pkaizv.id = pkaizvhij.pkaizv_id
       AND pkaizvhij.zmphij_id = zmphij_id_p
       AND pkaizvhij.ozn_ostvareno <= ozn_ostvareno_p; -- izraunato ostvareno podrazumjeva i planirano
  ELSE
    SELECT MAX (datum) INTO dat_zadnjeg_izvjestaja_l
      FROM ipka_izvjestaji
     WHERE ozn_ostvareno <= ozn_ostvareno_p;
  END IF;
  RETURN dat_zadnjeg_izvjestaja_l;
END;
FUNCTION IZN_PONISTENI_PKARAC
 (PKARAC_ID_P IN TPKA_RACUNI.ID%TYPE
 ,DATUM_P IN DATE := TO_DATE ('31.12.9999', 'DD.MM.RRRR')
 )
 RETURN tpka_racuni.iznos%TYPE
 IS
-- (djelomino) poniteni iznos rauna
  izn_ponisteni_pkarac_l tpka_racuni.iznos%TYPE;
BEGIN
  IF pkarac_id_p IS NULL THEN
    RETURN 0;
  END IF;

  SELECT NVL (SUM (iznos), 0) * -1 INTO izn_ponisteni_pkarac_l
    FROM tpka_racuni
   WHERE pkaracd_id = pkarac_id_p
     AND raci_id IS NULL    -- IRN 1890
     AND pkaraci_id IS NULL -- IRN 1890
     AND datum <= datum_p;  -- IRN 1890

  RETURN izn_ponisteni_pkarac_l;
END;
FUNCTION BROJ_RACUNA
 (PKARACNAP_ID_P IN TPKA_RACUNI.ID%TYPE
 ,RACNAP_ID_P IN T_RACUNI.ID%TYPE
 ,PKARNK_ID_P IN TPKA_RNKASA.ID%TYPE
 ,ID_RAC_P IN TPKA_OBR_RAC.ID_RAC%TYPE
 )
 RETURN VARCHAR2
 IS
-- broj obraunatog rauna (PKA rauna, REC rauna ili POS rauna)
  br_racuna_l VARCHAR2(40);
  CURSOR pkarac_c IS
    SELECT 'PKA ' || vdok_sifra2n || god_poslovna || '-' || oj_sifra || '-' || rbr
      FROM tpka_racuni
     WHERE id = id_rac_p;
  CURSOR rac_c IS
    SELECT 'REC ' || vdok_sifra2n || god_poslovna || '-' || oj_sifra || '-' || rbr
      FROM t_racuni
     WHERE id = id_rac_p;
  CURSOR pkarnk_c IS
    SELECT 'POS ' || pkarnk.god_poslovna || '-' || gmpkas.sifra || '-' || pkarnk.rbr
      FROM tpka_rnkasa pkarnk,
           mgmp_kase gmpkas
     WHERE pkarnk.id = id_rac_p
       AND pkarnk.gmpkas_id = gmpkas.id;
BEGIN
  IF pkaracnap_id_p IS NOT NULL THEN
    -- broj obraunatog PKA rauna
    OPEN pkarac_c;
    FETCH pkarac_c INTO br_racuna_l;
    CLOSE pkarac_c;
  ELSIF racnap_id_p IS NOT NULL THEN
    -- broj obraunatog REC rauna
    OPEN rac_c;
    FETCH rac_c INTO br_racuna_l;
    CLOSE rac_c;
  ELSIF pkarnk_id_p IS NOT NULL THEN
    -- broj obraunatog POS rauna
    OPEN pkarnk_c;
    FETCH pkarnk_c INTO br_racuna_l;
    CLOSE pkarnk_c;
  END IF;
  RETURN br_racuna_l;
END;
FUNCTION DNEVNI_FOND_SATI
 (DATUM_P IN DATE
 )
 RETURN ipka_izv_sizv.ostvareno%TYPE
 IS
--
  CURSOR fond_c IS -- za dnevni fond sati
    SELECT ostvareno
      FROM ipka_izvjestaji pkaizv,
           ipka_izv_sizv pkaizvsizv,
           mzmp_sizvjestaja zmpsizv
     WHERE pkaizv.id = pkaizvsizv.pkaizv_id
       AND pkaizvsizv.zmpsizv_id = zmpsizv.id
       AND pkaizv.datum = datum_p
       AND zmpsizv.sifra = pra_zmp_zaj.vrijednost_parametra ('0035'); -- ifra stavke izvjetaja za fond sati ili nebitno.
  dnevni_fond_sati_l ipka_izv_sizv.ostvareno%TYPE;
BEGIN
  IF datum_p IS NULL THEN
    dnevni_fond_sati_l := NULL;
  ELSE
    OPEN fond_c;
    FETCH fond_c INTO dnevni_fond_sati_l;
    IF fond_c%NOTFOUND THEN
      IF TO_CHAR (datum_p, 'D') IN ('1', '2', '3', '4', '5') THEN
        dnevni_fond_sati_l := 8;
      ELSE
        dnevni_fond_sati_l := 0;
      END IF;
    END IF;
  END IF;
  RETURN dnevni_fond_sati_l;
END;
FUNCTION GASIZLDOK_ZARACUNAT
 (PKARACGAS_ID_P IN TPKA_RAC_GASIZLDOK.ID%TYPE
 ,GASIZLDOK_ID_P IN TPKA_RAC_GASIZLDOK.GASIZLDOK_ID%TYPE
 )
 RETURN NUMBER
 IS
-- Otpremnica je zaraunata: da = -1 ili ne = 0.
  br_redaka_l NUMBER;
BEGIN
  IF gasizldok_id_p IS NULL THEN
    RETURN (0);
  END IF;
  SELECT COUNT (1) INTO br_redaka_l
    FROM tpka_racuni,
         tpka_rac_gasizldok
   WHERE tpka_rac_gasizldok.gasizldok_id = gasizldok_id_p
     AND tpka_rac_gasizldok.pkarac_id = tpka_racuni.id
     AND tpka_rac_gasizldok.id <> NVL (pkaracgas_id_p, -1)
     AND tpka_racuni.oznaka = 'V';
  IF br_redaka_l = 0 THEN
    RETURN 0;
  ELSE
    RETURN (-1);
  END IF;
END;
FUNCTION IZN_PPOT_PO
 (PKARAC_ID_P IN TPKA_RACUNI.ID%TYPE
 )
 RETURN tpka_rnkasa.izn_ppot%TYPE
 IS
-- Iznos zaraunatog i prethodno obraunatog poreza na potronju
  izn_ppot_l tpka_rnkasa.izn_ppot%TYPE;
BEGIN
  SELECT NVL (SUM (izn_ppot), 0)
    INTO izn_ppot_l
    FROM tpka_rnkasa
   WHERE pkarac_id = pkarac_id_p;

  RETURN izn_ppot_l;
END;
FUNCTION IZN_PKARNK
 (PKARAC_ID_P IN TPKA_RACUNI.ID%TYPE
 ,VPISPZ_ID_P IN IPKA_RNK_PDV.VPISPZ_ID%TYPE
 ,OZNAKA_P IN NUMBER
 )
 RETURN ipka_rnk_pdv.iznos%TYPE
 IS
/*
Zaraunata osnovica (oznaka_p = -1) ili porez (oznaka_p = 0) po raunima sa kasa
Iznos poreza = iznos bruto - iznos neto
*/
  iznos_l NUMBER(14, 2);
BEGIN
  SELECT DECODE (oznaka_p,
         -1, NVL (SUM (ipka_rnk_pdv.izn_osnovice), 0),
          0, NVL (SUM (ipka_rnk_pdv.izn_pdv), 0))
    INTO iznos_l
    FROM ipka_rnk_pdv,
         tpka_rnkasa
   WHERE tpka_rnkasa.pkarac_id = pkarac_id_p
     AND ipka_rnk_pdv.pkarnk_id = tpka_rnkasa.id
     AND ipka_rnk_pdv.vpispz_id = vpispz_id_p;

  RETURN iznos_l;
END;
FUNCTION IZN_PREDUJMA_RACVAL
 (PKARAC_ID_P IN TPKA_RACUNI.ID%TYPE
 ,IZN_TECAJA_P IN TPKA_RACUNI.IZN_TECAJA%TYPE
 )
 RETURN tpka_rac_pred.iznos%TYPE
 IS
-- Iznos iskoritenog predujma u valuti rauna
  iznos_l tpka_rac_pred.iznos%TYPE;
BEGIN
  IF pkarac_id_p IS NULL OR izn_tecaja_p IS NULL THEN
    RETURN (NULL);
  END IF;
  SELECT NVL (SUM (ROUND (iznos * izn_tecaja / izn_tecaja_p, 2)), 0)
    INTO iznos_l
    FROM tpka_rac_pred
   WHERE pkarac_id = pkarac_id_p;
  RETURN (iznos_l);
END;
FUNCTION PIN32
 (PIN4_P IN VARCHAR2
 )
 RETURN VARCHAR2
 IS
-- kriptirani PIN4
BEGIN
  IF pin4_p IS NULL THEN
    RETURN (TO_CHAR (NULL));
  ELSE
    RETURN (
      utl_raw.cast_to_raw (
        dbms_obfuscation_toolkit.md5 (
          input_string => pin4_p)));
  END IF;
END;
FUNCTION PKADNE_DATUM_MAX
 (ZMPOJR_ID_P IN IPKA_DNEVNIK.ZMPOJR_ID%TYPE
 )
 RETURN ipka_dnevnik.datum%TYPE
 IS
-- datum zadnjeg dnevnika prometa promatrane OJ ili NULL ako dnevnika nema
  datum_l ipka_dnevnik.datum%TYPE;
BEGIN
  SELECT MAX (datum) INTO datum_l
    FROM ipka_dnevnik
   WHERE zmpojr_id = zmpojr_id_p;

  RETURN datum_l;
END;
PROCEDURE PROVJERI_PKADNE_DATUM
 (ZMPOJR_ID_P IN IPKA_DNEVNIK.ZMPOJR_ID%TYPE
 ,DATUM_P IN IPKA_DNEVNIK.DATUM%TYPE
 )
 IS
-- datum mora biti vei od datuma zadnjeg dnevnika prometa
BEGIN
  IF zmpojr_id_p IS NULL
    OR datum_p IS NULL
  THEN
    RETURN;
  END IF;

  IF datum_p <= NVL (pra_pka_s.pkadne_datum_max (zmpojr_id_p), TO_DATE ('01.01.1999', 'DD.MM.RRRR')) THEN
    -- Datum (rauna, novog dnevnika prometa, ...) mora biti vei od datuma zadnjeg dnevnika prometa.
    pra_pka_zaj.vrati_poruku (-20091);
  END IF;
END;
FUNCTION PKARACISP_IZNOS_RACVAL
 (PKARAC_ID_P IN TPKA_RAC_ISP.PKARAC_ID%TYPE
 )
 RETURN tpka_racuni.iznos%TYPE
 IS
-- Iznos zaraunatih isporuka (u valuti rauna)
  iznos_l tpka_racuni.iznos%TYPE;
BEGIN
  SELECT SUM (kolicina * cijena) iznos
    INTO iznos_l
    FROM tpka_rac_isp
   WHERE pkarac_id = pkarac_id_p;
  RETURN (iznos_l);
END;
FUNCTION MINUS_ODBITAK_IZV
 RETURN NUMBER
 IS
BEGIN
  IF minus_odbitak_izv_m IS NULL THEN
    -- Iznos prihoda umanjiti za odbitke: da ili ne.
    SELECT DECODE (UPPER (pra_pka_zaj.vrijednost_parametra ('1045')), 'DA', 1, 0)
      INTO minus_odbitak_izv_m
      FROM dual;
  END IF;
  RETURN (minus_odbitak_izv_m);
END;
FUNCTION MINUS_PDV_IZV
 RETURN NUMBER
 IS
BEGIN
  IF minus_pdv_izv_m IS NULL THEN
    -- U iznos prihoda uraunati PDV: da ili ne.
    SELECT DECODE (UPPER (pra_pka_zaj.vrijednost_parametra ('1044')), 'DA', 0, 1)
      INTO minus_pdv_izv_m
      FROM dual;
  END IF;
  RETURN (minus_pdv_izv_m);
END;
FUNCTION IZN_PRIHODA_IZV
 (IZN_PRIHODA_P IN IPKA_DNE_ISP.IZN_PRIHODA%TYPE
 ,IZN_PDV_P IN IPKA_DNE_ISP.IZN_PDV%TYPE
 ,IZN_PPOT_P IN IPKA_DNE_ISP.IZN_PPOT%TYPE
 ,IZN_ODBITKA_P IN IPKA_DNE_ISP.IZN_ODBITKA%TYPE
 ,IZN_ODBITKA_PDV_P IN IPKA_DNE_ISP.IZN_ODBITKA_PDV%TYPE
 )
 RETURN NUMBER
 IS
--
  iznos_l ipka_dne_isp.izn_prihoda%TYPE;
BEGIN
  iznos_l :=
    (
      (izn_prihoda_p - (pra_pka_s.minus_pdv_izv * (izn_pdv_p + izn_odbitka_pdv_p + izn_ppot_p)) )
    - (pra_pka_s.minus_odbitak_izv * (izn_odbitka_p - (pra_pka_s.minus_pdv_izv * izn_odbitka_pdv_p)) )
    );
  RETURN (iznos_l);
END;
FUNCTION IZN_ODBITKA_IZV
 (IZN_ODBITKA_P IN IPKA_DNE_ISP.IZN_ODBITKA%TYPE
 ,IZN_ODBITKA_PDV_P IN IPKA_DNE_ISP.IZN_ODBITKA_PDV%TYPE
 )
 RETURN NUMBER
 IS
--
  iznos_l ipka_dne_isp.izn_odbitka%TYPE;
BEGIN
  iznos_l :=
    izn_odbitka_p - (pra_pka_s.minus_pdv_izv * izn_odbitka_pdv_p);
  RETURN (iznos_l);
END;
FUNCTION BR_RACUNA_FSUS
 (OJ_SIFRA_P IN m_oj.sifra%TYPE
 ,VDOK_SIFRA2N_P IN tpka_racuni.vdok_sifra2n%TYPE
 ,RBR_P IN tpka_racuni.rbr%TYPE
 ,DATUM_P IN tpka_racuni.datum%TYPE
 )
 RETURN VARCHAR2
 IS
-- broj rauna prema fiskalnom sustavu
-- SI rauni se od datuma fiskalizacije ispisuju po SI notaciji (oj_sifra - vdok_sifra2n - rbr)
-- svi ostali rauni kao v 13.1 (rbr - oj_sifra - vdok_sifra2n)
  br_racuna_l VARCHAR2(30);
BEGIN
  IF pra_pka_i3fiskal.vlas_u_fsus_si (datum_p) = -1 THEN
    br_racuna_l := oj_sifra_p || '-' || vdok_sifra2n_p || '-' || TO_NUMBER (rbr_p);
  ELSE
    br_racuna_l := TO_NUMBER (rbr_p) || '-' || oj_sifra_p || '-' || vdok_sifra2n_p;
  END IF;
  RETURN br_racuna_l;
END;
FUNCTION IZN_PNAKNADE_PO
 (PKARAC_ID_P IN TPKA_RACUNI.ID%TYPE
 )
 RETURN tpka_rnkasa.izn_pnaknade%TYPE
 IS
-- Iznos povratne naknade na POS raunima (prethodno obraunato) zaraunatim na PKA raunu
  izn_pnaknade_l tpka_rnkasa.izn_pnaknade%TYPE;
BEGIN
  SELECT NVL (SUM (izn_pnaknade), 0)
    INTO izn_pnaknade_l
    FROM tpka_rnkasa
   WHERE pkarac_id = pkarac_id_p;

  RETURN izn_pnaknade_l;
END;

END PRA_PKA_S;
/
SHOW ERROR

