PROMPT Creating Package Body 'PRA_PKA_PAYPER'
CREATE OR REPLACE PACKAGE BODY PRA_PKA_PAYPER IS

LOG_FILE_NAME_M VARCHAR2(100);
DATA_M CLOB;
ODGOVOR_M CLOB;
SECRET_KEY_M S_NEBITNO3.P2%TYPE;
SIGNATURE_M VARCHAR2(128);
VALUES_M APEX_JSON.T_VALUES;
ERROR_CODE_M TPP_ORDERS.ERROR_CODE%TYPE;
ERROR_MESSAGE_M TPP_ORDERS.ERROR_MESSAGE%TYPE;
RESPONSE_ID_M TPP_ORDERS.RESPONSE_ID%TYPE;
UNOS_KORISNIK_M TPP_ORDERS.UNOS_KORISNIK%TYPE;


PROCEDURE AZURIRAJ_PPORD
 (PPORD_ROW_P IN tpp_orders%ROWTYPE
 )
 IS
-- poziva se iz ORDS modula apipayper

  CURSOR cvor_c IS
    SELECT DECODE (so.metcvor_sifra, vlas.sifra_tekuceg_cvora, NULL, '@' || so.metcvor_sifra)
      FROM mrec_so_sus recsosus,
           m_so so,
           s_vlasnik vlas
     WHERE recsosus.sifra = ppord_row_p.organization_code
       AND recsosus.zmpsus_id = (SELECT id FROM szmp_sustavi WHERE sifra = 'PAYPER')
       AND recsosus.so_id = so.id;
  cvor_l VARCHAR2(21);

  ozn_vzahtjeva_l tpp_orders.ozn_vzahtjeva%TYPE; -- IRN 3869 30.10.2024.
  naredba_l VARCHAR2(5000);
  ppord_id_l tpp_orders.id%TYPE;

  rc_l SYS_REFCURSOR;
BEGIN

  -- Dohvati vor za poslani organization_code
  OPEN cvor_c;
  FETCH cvor_c INTO cvor_l;
  CLOSE cvor_c;

  /*
  IRN 3869 30.10.2024.
  Ponitavanje predautorizacije, kompletiranje predautorizacije i povrat mogu se
  obaviti putem PayPer suelja. U tom sluaju treba kreirati novi redak u tpp_orders.
  Odnosno, ako postoji odgovarajui zahtjev u MISH onda taj zahtjev treba aurirati.
  */
  IF ppord_row_p.status IN (3) THEN           -- 3 = Voided
    ozn_vzahtjeva_l := '06';                  -- 06 = Void (ponitavanje predautorizacije)

  ELSIF ppord_row_p.authorization_type IN (1) -- 1 = Preauthorization
    AND ppord_row_p.status IN (2)             -- 2 = Completed
  THEN
    ozn_vzahtjeva_l := '04';                  -- 04 = Capture transaction (kompletiranje predautorizacije)

  ELSIF ppord_row_p.status IN (4, 5) THEN     -- 4 = Refunded, 5 = Partially refunded
    ozn_vzahtjeva_l := '07';                  -- 07 = Credit (povrat)

  END IF;

  -- Dohvati zadnji tpp_orders.id za poslani order_id
  /*
  IRN 3869 30.10.2024.
  - u WHERE dodan dio (ozn_vzahtjeva_l IS NULL OR ...
  IRN 3869 18.03.2025.
  - u WHERE dodano OR ozn_vzahtjeva = ''08'' jer za zahtjev vrste 08 Create Order
    stie povratna info gdje je status = 3 = Voided
  */
  naredba_l :=
    'SELECT MAX (id) ' ||
    '  FROM tpp_orders<CVOR> ' ||
    ' WHERE (:ozn_vzahtjeva_l IS NULL OR ozn_vzahtjeva = :ozn_vzahtjeva_l OR ozn_vzahtjeva = ''08'') ' ||
    '   AND order_id = :order_id';
  EXECUTE IMMEDIATE REPLACE (naredba_l, '<CVOR>', cvor_l) INTO ppord_id_l
    USING ozn_vzahtjeva_l, ozn_vzahtjeva_l, ppord_row_p.order_id;

  IF ppord_id_l IS NOT NULL THEN
    -- Auriraj zapis u tpp_orders
    IF ppord_row_p.ozn_vzahtjevap = '10' THEN -- Order updated callback
      naredba_l :=
        'UPDATE tpp_orders<CVOR>
            SET merchant_reference_id = :merchant_reference_id,
                order_type = :order_type,
                authorization_type = :authorization_type,
                status = :status,
                url = :url,
                amount = :amount,
                initial_amount = :initial_amount,
                payment_reference_id = :payment_reference_id,
                approval_code = :approval_code,
                payment_type = :payment_type,
                masked_pan = :masked_pan,
                partner = :partner,
                payment_plan = :payment_plan,
                on_site = :on_site,
                currency_code = :currency_code,
                expiration_date = :expiration_date,
                payment_accepting_method = :payment_accepting_method,
                first_name = :first_name,
                last_name = :last_name,
                email = :email,
                address = :address,
                zip = :zip,
                city = :city,
                country = :country,
                phone = :phone,
                organization_code = :organization_code,
                transaction_token = NVL (:transaction_token, transaction_token),
                ozn_vzahtjevap = :ozn_vzahtjevap
          WHERE id = :id';
       EXECUTE IMMEDIATE REPLACE (naredba_l, '<CVOR>', cvor_l)
         USING ppord_row_p.merchant_reference_id,
               ppord_row_p.order_type,
               ppord_row_p.authorization_type,
               ppord_row_p.status,
               ppord_row_p.url,
               ppord_row_p.amount,
               ppord_row_p.initial_amount,
               ppord_row_p.payment_reference_id,
               ppord_row_p.approval_code,
               ppord_row_p.payment_type,
               ppord_row_p.masked_pan,
               ppord_row_p.partner,
               ppord_row_p.payment_plan,
               ppord_row_p.on_site,
               ppord_row_p.currency_code,
               ppord_row_p.expiration_date,
               ppord_row_p.payment_accepting_method,
               ppord_row_p.first_name,
               ppord_row_p.last_name,
               ppord_row_p.email,
               ppord_row_p.address,
               ppord_row_p.zip,
               ppord_row_p.city,
               ppord_row_p.country,
               ppord_row_p.phone,
               ppord_row_p.organization_code,
               ppord_row_p.transaction_token, -- IRN 3869 30.10.2024.
               ppord_row_p.ozn_vzahtjevap,
               ppord_id_l;
    ELSIF ppord_row_p.ozn_vzahtjevap = '03' THEN -- Process transaction result
      naredba_l :=
        'UPDATE tpp_orders<CVOR>
            SET merchant_reference_id = :merchant_reference_id,
                terminal_identificator = :terminal_identificator,
                approval_code = :approval_code,
                amount = :amount,
                authorization_type = :authorization_type,
                transaction_token = NVL (:transaction_token, transaction_token),
                number_of_instalments = :number_of_instalments,
                transaction_status = :transaction_status,
                masked_pan = :masked_pan,
                payment_type = :payment_type,
                expiration_date = :expiration_date,
                organization_code = :organization_code,
                ozn_vzahtjevap = :ozn_vzahtjevap,
                error_code = :error_code,
                error_message = :error_message
          WHERE id = :id';
       EXECUTE IMMEDIATE REPLACE (naredba_l, '<CVOR>', cvor_l)
         USING ppord_row_p.merchant_reference_id,
               ppord_row_p.terminal_identificator,
               ppord_row_p.approval_code,
               ppord_row_p.amount,
               ppord_row_p.authorization_type,
               ppord_row_p.transaction_token,
               ppord_row_p.number_of_instalments,
               ppord_row_p.transaction_status,
               ppord_row_p.masked_pan,
               ppord_row_p.payment_type,
               ppord_row_p.expiration_date,
               ppord_row_p.organization_code,
               ppord_row_p.ozn_vzahtjevap,
               ppord_row_p.error_code,
               ppord_row_p.error_message,
               ppord_id_l;
    END IF;
  ELSE
    -- Upii novi zapis u tpp_orders
    /*
    IRN 3869 30.10.2024.
    novi zapisi odnose se i na zahtjeve gdje je
    order_type = 1 - Card on File (COF) ili 0 - Reservation only (RO)
    koje generira Phobs
    */
    ppord_row_g := ppord_row_p;
    ppord_row_g.unos_korisnik := 'PAYPER';
    ppord_row_g.unos_dat := SYSDATE;

    naredba_l :=
      'SELECT id
         FROM t_rezervacije<CVOR>
        WHERE br_uputnice || ''|'' || creator_id = :merchant_reference_id
        ORDER BY DECODE (oznaka, ''V'', 0, 1), DECODE (ozn_vstorna, NULL, 0, 1), id DESC';
    OPEN rc_l FOR REPLACE (naredba_l, '<CVOR>', cvor_l) USING ppord_row_g.merchant_reference_id;
    FETCH rc_l INTO ppord_row_g.rez_id;
    CLOSE rc_l;

    -- ozn_vzahtjevap moe biti 10 Order updated callback ili 03 Process transaction result
    ppord_row_g.ozn_vzahtjeva := ppord_row_g.ozn_vzahtjevap;
    naredba_l := 'BEGIN INSERT INTO tpp_orders<CVOR> VALUES pra_pka_payper.ppord_row_g; END;';
    EXECUTE IMMEDIATE REPLACE (naredba_l, '<CVOR>', cvor_l);
  END IF;
END;
PROCEDURE PUNI_LOG
 (ENDPOINT_NAME_P IN VARCHAR2
 ,CLOB_P IN VARCHAR2
 ,SQLERRM_P IN VARCHAR2
 )
 IS
-- Puni log odnosno tablicu lpka_clob; poziva se iz ORDS modula apipayper
/*
IRN 4035
Datatype parametra clob_p izmijenjen iz CLOB u VARCHAR2 tako da ORDS skripta na
it8centar ne javlja greku ORA-22992: cannot use LOB locators selected from remote tables.
*/
  log_file_name_l VARCHAR2(100);
  error_txt_l     VARCHAR2(10);
  clob_l          CLOB; -- IRN 4035
  email_l         szmp_parametri.vrijednost%TYPE;
  sender_l        szmp_parametri.vrijednost%TYPE;
BEGIN
  log_file_name_l := 'apipayper-' || TO_CHAR (SYSDATE, 'RRRR-MM-DD') || '.log';
  IF sqlerrm_p IS NOT NULL THEN
    error_txt_l := '*** Error ';
  END IF;

  -- IRN 4035; tri poziva pra_pka2.clob_to_table spojena u jedan
  clob_l :=
    error_txt_l || endpoint_name_p || ' ' || TO_CHAR (SYSDATE, 'DD.MM.RRRR HH24:MI:SS') || CHR(10) ||
    clob_p || CHR(10) ||
    sqlerrm_p || CHR(10);

  DBMS_LOCK.sleep (3/10); -- da se tablica lpka_clob eventualno otkljua

  pra_pka2.clob_to_table (clob_l, log_file_name_l, NULL, 'PAYPER');
  -- KRAJ IRN 4035

  IF sqlerrm_p IS NULL THEN
    RETURN;
  END IF;

  -- E-adrese (odvojene zarezom) za slanje obavijesti o grekama ili nebitno.
  email_l := pra_zmp_zaj.zmppar_vrijednost ('PAYPER', '1006');
  IF email_l = 'nebitno' THEN
    RETURN; -- izlaz iz procedure
  END IF;

  sender_l := pra_zmp_zaj.zmppar_vrijednost ('ZMP', '0905'); -- noreply

  BEGIN
    pra_pka2.salji_html_email (
      recipient_p    => email_l,
      recipient_h_p  => NULL,
      sender_p       => sender_l,
      sender_h_p     => 'MISH Baza',
      bcc_p          => NULL,
      subject_p      => '(' || LOWER (SYS_CONTEXT ('USERENV', 'CURRENT_SCHEMA')) || ') Greka u komunikaciji s PayPer sustavom', -- 31.03.2025.
      text_p         => sqlerrm_p,
      attach_name3_p => log_file_name_l,
      attach_clob3_p => clob_p);
  EXCEPTION
    WHEN OTHERS THEN
      NULL;
  END;
END;
FUNCTION SIGNATURE
 (ENDPOINT_NAME_P IN VARCHAR2
 ,ORGANIZATION_CODE_P IN tpp_orders.organization_code%TYPE
 ,ORDER_ID_P IN tpp_orders.order_id%TYPE
 ,AMOUNT_P IN tpp_orders.amount%TYPE
 )
 RETURN VARCHAR2
 IS
-- poziva se iz ORDS modula apipayper
BEGIN
  IF endpoint_name_p IS NULL
    OR order_id_p IS NULL
  THEN
    RETURN (NULL);
  END IF;

  secret_key_m := zaj_secret_key (organization_code_p);

  IF endpoint_name_p = 'order_updated_callback' THEN

    signature_m :=
      string2sha512 (
        secret_key_m ||
        order_id_p ||
        secret_key_m ||
        order_id_p ||
        secret_key_m ||
        secret_key_m);

  ELSIF endpoint_name_p = 'process_transaction_result' THEN

    signature_m :=
      string2sha512 (
        order_id_p ||
        secret_key_m ||
        amount_p * 100 ||
        secret_key_m);

  END IF;

  RETURN (signature_m);
END;
FUNCTION STRING2SHA512
 (INPUT_P IN VARCHAR2
 )
 RETURN VARCHAR2
 IS
--
  retval_l VARCHAR2(128);
BEGIN
  -- funkcija standard_hash ne radi na 11g i XE bazama i zato se koristi EXECUTE IMMEDIATE
  IF pra_zmp_zaj.tekuci_cvor IN ('i3centar', 'i3hotel', 'i3kamp') THEN
    /*
    sheme i3centar, i3hotel i i3kamp su na 11g bazi, pa se za potrebe
    testiranja koristi funkcija sa sheme itrazvoj koja je na 12c bazi
    */
    EXECUTE IMMEDIATE 'SELECT pra_pka_payper.string2sha512@itrazvoj (:input_p) FROM dual' INTO retval_l USING input_p;
  ELSE
    EXECUTE IMMEDIATE 'SELECT standard_hash (:input_p, ''SHA512'') FROM dual' INTO retval_l USING input_p;
  END IF;
  RETURN LOWER (retval_l);
END;
FUNCTION ZAJ_ORGANIZATION_CODE
 (SO_ID_P IN m_so.id%TYPE
 )
 RETURN tpp_orders.organization_code%TYPE
 IS
-- vrati "OrganizationCode" poslanog so_id_p
  organization_code_l tpp_orders.organization_code%TYPE;
BEGIN
  SELECT MIN (sifra) INTO organization_code_l
    FROM mrec_so_sus
   WHERE zmpsus_id = (SELECT id FROM szmp_sustavi WHERE sifra = 'PAYPER')
     AND so_id = so_id_p;
  RETURN (organization_code_l);
END;
FUNCTION ZAJ_SECRET_KEY
 (ORGANIZATION_CODE_P IN tpp_orders.organization_code%TYPE
 )
 RETURN VARCHAR2
 IS
-- vrati "SecretKey" poslanog organization_code_p
  secret_key_l s_nebitno3.naziv%TYPE;
BEGIN
  /*
  IRN 4035
  komentirano jer vie razliitih organization_code
  moe imati jednak secret_key, a stupac p2 je UK

  SELECT MIN (p2) INTO secret_key_l
    FROM s_nebitno3
   WHERE p1 = organization_code_p;
  */

  SELECT MIN (naziv) INTO secret_key_l
    FROM s_nebitno3
   WHERE p2 = 'recpp' || organization_code_p;

  RETURN (secret_key_l);

END;
PROCEDURE ZAJ_SEND
 (ENDPOINT_P IN VARCHAR2
 ,METHOD_P IN VARCHAR2 := 'POST'
 )
 IS
--
  req_l UTL_HTTP.req;
  res_l UTL_HTTP.resp;
  line_l CLOB;

  url_l     szmp_parametri.vrijednost%TYPE;
  timeout_l szmp_parametri.vrijednost%TYPE;
  ozn_log_l szmp_parametri.vrijednost%TYPE;
BEGIN

  odgovor_m := NULL;

  IF endpoint_p IS NULL THEN
    RETURN;
  END IF;

  url_l := pra_zmp_zaj.zmppar_vrijednost ('PAYPER', '1001');
  IF url_l = 'nebitno' THEN
    RETURN;
  END IF;
  url_l := url_l || endpoint_p;

  timeout_l := pra_zmp_zaj.zmppar_vrijednost ('PAYPER', '1002');
  IF timeout_l = 'nebitno' THEN
    RETURN;
  END IF;

  -- Spremati komunikaciju u log: da ili nebitno.
  ozn_log_l := pra_zmp_zaj.zmppar_vrijednost ('PAYPER', '1003');
  log_file_name_m := 'PayPer-' || TO_CHAR (SYSDATE, 'RRRR-MM-DD') || '.log';

  IF ozn_log_l = 'da' THEN
    pra_pka2.clob_to_table (CHR(10) || 'Request [' || TO_CHAR (SYSDATE, 'DD.MM.RRRR HH24:MI:SS') || '] ' || url_l || ' [' || method_p || ']' || CHR(10), log_file_name_m, NULL, 'PAYPER');
    pra_pka2.clob_to_table (data_m || CHR(10), log_file_name_m, NULL, 'PAYPER');
  END IF;

  UTL_HTTP.set_detailed_excp_support (enable => true);
  UTL_HTTP.set_transfer_timeout (timeout => TO_NUMBER (timeout_l));
  UTL_HTTP.set_body_charset (charset => 'UTF-8');

  req_l := UTL_HTTP.begin_request (url => url_l, method => method_p, http_version => 'HTTP/1.1');

  UTL_HTTP.set_header (r => req_l, name => 'Content-Type', value => 'application/json; charset=utf-8');
  UTL_HTTP.set_header (req_l, 'Content-Length', pra_pka2.clob_length (data_m));

  UTL_HTTP.write_text (req_l, data_m);

  res_l := UTL_HTTP.get_response (req_l);

  IF res_l.status_code = UTL_HTTP.HTTP_OK THEN
    odgovor_m := NULL;
  ELSE
    pra_zmp_zaj.vrati_poruku (-20000, res_l.status_code || ': ' || res_l.reason_phrase);
  END IF;

  BEGIN
    LOOP
      UTL_HTTP.read_line (res_l, line_l);
      odgovor_m := odgovor_m || line_l;
    END LOOP;
    UTL_HTTP.end_response (res_l);
  EXCEPTION
    WHEN UTL_HTTP.end_of_body THEN
      UTL_HTTP.end_response (res_l);
  END;

  IF ozn_log_l = 'da' THEN
    pra_pka2.clob_to_table ('Response [' || TO_CHAR (SYSDATE, 'DD.MM.RRRR HH24:MI:SS') || '] ' || CHR(10), log_file_name_m, NULL, 'PAYPER');
    pra_pka2.clob_to_table (odgovor_m || CHR(10), log_file_name_m, NULL, 'PAYPER');
  END IF;

EXCEPTION
  WHEN OTHERS THEN
    UTL_HTTP.end_response (res_l); -- It completes the HTTP request and response.

    -- upii greku u log bez obzira na to je li ukljueno spremanje komunikacije u log ili ne
    pra_pka2.clob_to_table ('Error [' || TO_CHAR (SYSDATE, 'DD.MM.RRRR HH24:MI:SS') || '] ' || url_l || ' [' || method_p || ']' || CHR(10), log_file_name_m, NULL, 'PAYPER');
    IF ozn_log_l NOT IN ('da') THEN
      pra_pka2.clob_to_table (data_m || CHR(10), log_file_name_m, NULL, 'PAYPER');
    END IF;
    pra_pka2.clob_to_table (SQLERRM || CHR(10), log_file_name_m, NULL, 'PAYPER');

    RAISE;
END;
PROCEDURE INIT_TERMINAL_TRANSACTION
 (ORDER_ID_P IN tpp_orders.order_id%TYPE
 ,ORGANIZATION_CODE_P IN tpp_orders.organization_code%TYPE
 ,REZ_ID_P IN t_rezervacije.id%TYPE
 ,GOST_ID_P IN t_gosti.id%TYPE
 ,RACNAP_ID_P IN t_rac_nap.id%TYPE := NULL
 ,PKARACNAP_ID_P IN tpka_rac_nap.id%TYPE := NULL
 ,MERCHANT_REFERENCE_ID_P IN tpp_orders.merchant_reference_id%TYPE
 ,TERMINAL_IDENTIFICATOR_P IN tpp_orders.terminal_identificator%TYPE
 ,LABEL_P IN VARCHAR2
 ,VALID_FOR_P IN NUMBER
 ,AMOUNT_P IN tpp_orders.amount%TYPE
 ,AUTHORIZATION_TYPE_P IN tpp_orders.authorization_type%TYPE
 ,RESPONSE_P OUT VARCHAR2
 ,PPORD_ID_P OUT tpp_orders.id%TYPE
 )
 IS
-- Initialize terminal transaction
  ppord_id_l tpp_orders.id%TYPE;
BEGIN
  IF organization_code_p IS NULL
    OR terminal_identificator_p IS NULL
    OR amount_p IS NULL
    OR authorization_type_p IS NULL
  THEN
    RETURN;
  END IF;

  -- upii zahtjev vrste 01 Initialize terminal transaction
  INSERT INTO tpp_orders (
      rez_id, gost_id, racnap_id, pkaracnap_id, ozn_vzahtjeva, order_id, merchant_reference_id, terminal_identificator, amount, authorization_type, organization_code)
    VALUES (
      rez_id_p, gost_id_p, racnap_id_p, pkaracnap_id_p, '01', order_id_p, merchant_reference_id_p, terminal_identificator_p, amount_p, authorization_type_p, organization_code_p)
    RETURNING id INTO ppord_id_l;
  COMMIT;

  secret_key_m := zaj_secret_key (organization_code_p);

  data_m := NULL;

  apex_json.initialize_clob_output;
  apex_json.open_object;
    apex_json.write ('OrderId', order_id_p);
    apex_json.write ('MerchantReferenceId', merchant_reference_id_p);
    apex_json.write ('TerminalIdentificator', terminal_identificator_p);
    apex_json.open_object ('Initiator');
      apex_json.write ('OrganizationCode', organization_code_p);
    apex_json.close_object;
    apex_json.write ('Label', label_p);
    apex_json.write ('ValidFor', valid_for_p);
    apex_json.write ('Amount', amount_p);
    apex_json.write ('AuthorizationType', authorization_type_p);
    IF organization_code_p IN ('ISTRATECHTEST')
      AND terminal_identificator_p IN ('04040404')
    THEN
      apex_json.write ('IsEmulatingTerminal', true);
    ELSE
      apex_json.write ('IsEmulatingTerminal', false);
    END IF;
    signature_m :=
      string2sha512 (
        order_id_p ||
        secret_key_m ||
        (amount_p * 100) ||
        secret_key_m);
    apex_json.write ('Signature', signature_m);
  apex_json.close_object;
  data_m := apex_json.get_clob_output;
  apex_json.free_output;

  zaj_send ('/api/payment/terminal');

   -- Obradi odgovor
  /*
  {
    "ErrorCode": "123",
    "ErrorMessage": "Error message"
  }
  ili
  {
    "Id": "173C5AB7-5AB1-49E5-A599-E3BA5D38676D"
  }
  */

  apex_json.parse (values_m, odgovor_m);
  error_code_m := apex_json.get_varchar2 (p_path => 'ErrorCode', p_values => values_m);
  error_message_m := apex_json.get_varchar2 (p_path => 'ErrorMessage', p_values => values_m);
  response_id_m := apex_json.get_varchar2 (p_path => 'Id', p_values => values_m);

  -- upii odgovor
  UPDATE tpp_orders
     SET error_code = error_code_m,
         error_message = error_message_m,
         response_id = response_id_m
   WHERE id = ppord_id_l;
  COMMIT;

  response_p := NVL (error_message_m, 'OK');
  ppord_id_p := ppord_id_l;

END;
PROCEDURE CANCELLATION_TRANSACTION
 (ORDER_ID_P IN tpp_orders.order_id%TYPE
 ,REZ_ID_P IN t_rezervacije.id%TYPE
 ,GOST_ID_P IN t_gosti.id%TYPE
 ,RACNAP_ID_P IN t_rac_nap.id%TYPE := NULL
 ,PKARACNAP_ID_P IN tpka_rac_nap.id%TYPE := NULL
 ,TERMINAL_IDENTIFICATOR_P IN tpp_orders.terminal_identificator%TYPE
 ,ORGANIZATION_CODE_P IN tpp_orders.organization_code%TYPE
 ,AMOUNT_P IN tpp_orders.amount%TYPE
 ,RESPONSE_P OUT VARCHAR2
 ,PPORD_ID_P OUT tpp_orders.id%TYPE
 )
 IS
-- Cancellation of announced transaction
-- Otkazivanje najavljene transakcije
-- If requested, queued transaction will be removed from transaction queue on terminal.
  ppord_id_l tpp_orders.id%TYPE;
BEGIN
  IF order_id_p IS NULL
    OR terminal_identificator_p IS NULL
    OR amount_p IS NULL
  THEN
    RETURN;
  END IF;

  -- upii zahtjev vrste 02 Cancellation of announced transaction
  INSERT INTO tpp_orders (
      rez_id, gost_id, racnap_id, pkaracnap_id, ozn_vzahtjeva, order_id, terminal_identificator, amount, organization_code)
    VALUES (
      rez_id_p, gost_id_p, racnap_id_p, pkaracnap_id_p, '02', order_id_p, terminal_identificator_p, amount_p, organization_code_p)
    RETURNING id INTO ppord_id_l;
  COMMIT;

  secret_key_m := zaj_secret_key (organization_code_p);

  data_m := NULL;

  apex_json.initialize_clob_output;
  apex_json.open_object;
    apex_json.write ('OrderId', order_id_p);
    apex_json.write ('TerminalIdentificator', terminal_identificator_p);
    apex_json.open_object ('Initiator');
      apex_json.write ('OrganizationCode', organization_code_p);
    apex_json.close_object;
    apex_json.write ('Amount', amount_p);
    signature_m :=
      string2sha512 (
        order_id_p ||
        secret_key_m ||
        (amount_p * 100) ||
        secret_key_m);
    apex_json.write ('Signature', signature_m);
  apex_json.close_object;
  data_m := apex_json.get_clob_output;
  apex_json.free_output;

  zaj_send ('/api/payment/terminal', 'DELETE');

  -- Obradi odgovor
  /*
  {
    "ErrorCode": "123",
    "ErrorMessage": "Error message"
  }
  ili
  {
    "Id": "173C5AB7-5AB1-49E5-A599-E3BA5D38676D"
  }
  */

  apex_json.parse (values_m, odgovor_m);
  error_code_m := apex_json.get_varchar2 (p_path => 'ErrorCode', p_values => values_m);
  error_message_m := apex_json.get_varchar2 (p_path => 'ErrorMessage', p_values => values_m);
  response_id_m := apex_json.get_varchar2 (p_path => 'Id', p_values => values_m);

  -- upii odgovor
  UPDATE tpp_orders
     SET error_code = error_code_m,
         error_message = error_message_m,
         response_id = response_id_m
   WHERE id = ppord_id_l;
  COMMIT;

  response_p := NVL (error_message_m, 'OK');
  ppord_id_p := ppord_id_l;

END;
PROCEDURE CAPTURE_TRANSACTION
 (ORDER_ID_P IN tpp_orders.order_id%TYPE
 ,REZ_ID_P IN t_rezervacije.id%TYPE
 ,GOST_ID_P IN t_gosti.id%TYPE
 ,RACNAP_ID_P IN t_rac_nap.id%TYPE := NULL
 ,PKARACNAP_ID_P IN tpka_rac_nap.id%TYPE := NULL
 ,TRANSACTION_TOKEN_P IN tpp_orders.transaction_token%TYPE
 ,ORGANIZATION_CODE_P IN tpp_orders.organization_code%TYPE
 ,AMOUNT_P IN tpp_orders.amount%TYPE
 ,IME_P IN t_rezervacije.ime%TYPE
 ,PREZIME_P IN t_rezervacije.prezime%TYPE
 ,RESPONSE_P OUT VARCHAR2
 ,PPORD_ID_P OUT tpp_orders.id%TYPE
 )
 IS
-- Capture transaction
-- Kompletiranje autoriziranog iznosa
  ppord_id_l tpp_orders.id%TYPE;
  amount_l   tpp_orders.amount%TYPE;
BEGIN

  IF order_id_p IS NULL
    AND transaction_token_p IS NULL
  THEN
    RETURN;
  END IF;

  -- upii zahtjev vrste 04 Capture transaction
  INSERT INTO tpp_orders (
      rez_id, gost_id, racnap_id, pkaracnap_id, ozn_vzahtjeva, order_id, transaction_token, amount, first_name, last_name, organization_code)
    VALUES (
      rez_id_p, gost_id_p, racnap_id_p, pkaracnap_id_p, '04', NVL (order_id_p, '[04]'), transaction_token_p, amount_p, ime_p, prezime_p, organization_code_p)
    RETURNING id INTO ppord_id_l;
  COMMIT;

  secret_key_m := zaj_secret_key (organization_code_p);

  data_m := NULL;

  apex_json.initialize_clob_output;
  apex_json.open_object;
    IF order_id_p IS NOT NULL THEN -- autorizacija je obavljena putem Process payment
      apex_json.write ('OrderId', order_id_p);
      signature_m :=
        string2sha512 (
          order_id_p ||
          secret_key_m ||
          (amount_p * 100) ||
          secret_key_m);
    END IF;
    apex_json.open_object ('Initiator');
      apex_json.write ('OrganizationCode', organization_code_p);
    apex_json.close_object;
    apex_json.write ('Amount', amount_p);
    apex_json.write ('FirstName', ime_p);
    apex_json.write ('LastName', prezime_p);
    IF transaction_token_p IS NOT NULL THEN -- autorizacija je obavljena na POS terminalu
      apex_json.open_object ('PaymentMethod');
        apex_json.write ('TransactionToken', transaction_token_p);
      apex_json.close_object;
      signature_m :=
        string2sha512 (
          transaction_token_p ||
          secret_key_m ||
          (amount_p * 100) ||
          secret_key_m);
    END IF;
    apex_json.write ('Signature', signature_m);
  apex_json.close_object;
  data_m := apex_json.get_clob_output;
  apex_json.free_output;

  zaj_send ('/api/payment/capture');

  -- Obradi odgovor
  /*
  {
    "ErrorCode": "123",
    "ErrorMessage": "Error message"
  }
  ili
  {
    "Id": "173C5AB7-5AB1-49E5-A599-E3BA5D38676D",
    "Amount": 10.00
  }
  */

  apex_json.parse (values_m, odgovor_m);
  error_code_m := apex_json.get_varchar2 (p_path => 'ErrorCode', p_values => values_m);
  error_message_m := apex_json.get_varchar2 (p_path => 'ErrorMessage', p_values => values_m);
  response_id_m := apex_json.get_varchar2 (p_path => 'Id', p_values => values_m);
  amount_l := apex_json.get_number (p_path => 'Amount', p_values => values_m);

  -- upii odgovor
  UPDATE tpp_orders
     SET error_code = error_code_m,
         error_message = error_message_m,
         response_id = response_id_m,
         amount = amount_l
   WHERE id = ppord_id_l;
  COMMIT;

  response_p := NVL (error_message_m, 'OK');
  ppord_id_p := ppord_id_l;

END;
PROCEDURE PROCESS_PAYMENT
 (ORDER_ID_P IN tpp_orders.order_id%TYPE
 ,ORGANIZATION_CODE_P IN tpp_orders.organization_code%TYPE
 ,REZ_ID_P IN t_rezervacije.id%TYPE
 ,GOST_ID_P IN t_gosti.id%TYPE
 ,RACNAP_ID_P IN t_rac_nap.id%TYPE := NULL
 ,PKARACNAP_ID_P IN tpka_rac_nap.id%TYPE := NULL
 ,MERCHANT_REFERENCE_ID_P IN tpp_orders.merchant_reference_id%TYPE
 ,AMOUNT_P IN tpp_orders.amount%TYPE
 ,TRANSACTION_TOKEN_P IN tpp_orders.transaction_token%TYPE
 ,AUTHORIZATION_TYPE_P IN tpp_orders.authorization_type%TYPE
 ,RESPONSE_P OUT VARCHAR2
 ,PPORD_ID_P OUT tpp_orders.id%TYPE
 )
 IS
-- Process payment
-- Autorizacija (AuthorizationType = 1) ili kupovina (AuthorizationType = 2) via MerchantReferenceId ili TransactionToken
  ppord_id_l  tpp_orders.id%TYPE;
  ppord_row_l tpp_orders%ROWTYPE;
BEGIN

  -- to do provjera parametara -- javiti greku ili return?

  -- upii zahtjev vrste 05 Process payment
  INSERT INTO tpp_orders (
      rez_id, gost_id, racnap_id, pkaracnap_id, ozn_vzahtjeva, order_id, merchant_reference_id, amount, transaction_token, authorization_type, organization_code)
    VALUES (
      rez_id_p, gost_id_p, racnap_id_p, pkaracnap_id_p, '05', order_id_p, merchant_reference_id_p, amount_p, transaction_token_p, authorization_type_p, organization_code_p)
    RETURNING id INTO ppord_id_l;
  COMMIT;

  secret_key_m := zaj_secret_key (organization_code_p);

  data_m := NULL;

  apex_json.initialize_clob_output;
  apex_json.open_object;
    apex_json.write ('OrderId', order_id_p);
    apex_json.write ('MerchantReferenceId', merchant_reference_id_p);
    apex_json.write ('Amount', amount_p);
    IF transaction_token_p IS NOT NULL THEN
      apex_json.open_object ('PaymentMethod');
        apex_json.write ('TransactionToken', transaction_token_p);
      apex_json.close_object;
    END IF;
    apex_json.write ('AuthorizationType', authorization_type_p);
    apex_json.open_object ('Initiator');
      apex_json.write ('OrganizationCode', organization_code_p);
      apex_json.write ('AgentCode', pra_zmp_zaj.zmppar_vrijednost ('PAYPER', '1005')); -- AgentCode ili nebitno.
    apex_json.close_object;
    signature_m :=
      string2sha512 (
        order_id_p ||
        secret_key_m ||
        (amount_p * 100) ||
        secret_key_m);
    apex_json.write ('Signature', signature_m);
  apex_json.close_object;
  data_m := apex_json.get_clob_output;
  apex_json.free_output;

  zaj_send ('/api/payment/process-payment');

  -- Obradi odgovor
  /*
  {
    "ErrorCode": "123",
    "ErrorMessage": "Error message"
  }
  ili
  {
    "OrderId": "1234-CIT-Request",
    "MerchantReferenceId": "20200546544",
    "OrderType": 2,
    "AuthorizationType": 1,
    "Status": 0,
    "Amount": 1830.88,
    "InitialAmount": 1830.88,
    "Transaction": {
      "PaymentReferenceId": "2b64275c-0a94-4e5e-a6b9-e00cbdc7bf69",
      "ApprovalCode": "876992",
      "PaymentType": "MASTERCARD",
      "MaskedPAN": "377500*****1007",
      "PaymentPlan": "0000",
      "CurrencyCode": "191",
      "ExpirationDate": "10/27"
    },
    "FirstName": "John",
    "LastName": "Doe",
    "Email": "johndoe@gmail.com",
    "Address": "Street 9",
    "Zip": "10000",
    "City": "Zagreb",
    "Country": "Croatia",
    "CountryCode": "hrv",
    "Phone": "0911234556"
  }
  */

  apex_json.parse (values_m, odgovor_m);
  ppord_row_l.order_type := apex_json.get_varchar2 (p_path => 'OrderType', p_values => values_m);
  ppord_row_l.authorization_type := apex_json.get_varchar2 (p_path => 'AuthorizationType', p_values => values_m);
  ppord_row_l.status := apex_json.get_varchar2 (p_path => 'Status', p_values => values_m);
  ppord_row_l.amount := apex_json.get_varchar2 (p_path => 'Amount', p_values => values_m);
  ppord_row_l.initial_amount := apex_json.get_varchar2 (p_path => 'InitialAmount', p_values => values_m);
  ppord_row_l.payment_reference_id := apex_json.get_varchar2 (p_path => 'Transaction.PaymentReferenceId', p_values => values_m);
  ppord_row_l.approval_code := apex_json.get_varchar2 (p_path => 'Transaction.ApprovalCode', p_values => values_m);
  ppord_row_l.payment_type := apex_json.get_varchar2 (p_path => 'Transaction.PaymentType', p_values => values_m);
  ppord_row_l.masked_pan := apex_json.get_varchar2 (p_path => 'Transaction.MaskedPan', p_values => values_m);
  ppord_row_l.payment_plan := apex_json.get_varchar2 (p_path => 'Transaction.PaymentPlan', p_values => values_m);
  ppord_row_l.currency_code := apex_json.get_varchar2 (p_path => 'Transaction.CurrencyCode', p_values => values_m);
  ppord_row_l.expiration_date := apex_json.get_varchar2 (p_path => 'Transaction.ExpirationDate', p_values => values_m);
  ppord_row_l.first_name := apex_json.get_varchar2 (p_path => 'FirstName', p_values => values_m);
  ppord_row_l.last_name := apex_json.get_varchar2 (p_path => 'LastName', p_values => values_m);
  ppord_row_l.email := apex_json.get_varchar2 (p_path => 'Email', p_values => values_m);
  ppord_row_l.address := apex_json.get_varchar2 (p_path => 'Address', p_values => values_m);
  ppord_row_l.zip := apex_json.get_varchar2 (p_path => 'Zip', p_values => values_m);
  ppord_row_l.country := apex_json.get_varchar2 (p_path => 'Country', p_values => values_m);
  ppord_row_l.phone := apex_json.get_varchar2 (p_path => 'Phone', p_values => values_m);
  error_code_m := apex_json.get_varchar2 (p_path => 'ErrorCode', p_values => values_m);
  error_message_m := apex_json.get_varchar2 (p_path => 'ErrorMessage', p_values => values_m);

  -- upii odgovor
  UPDATE tpp_orders
     SET order_type = ppord_row_l.order_type,
         authorization_type = ppord_row_l.authorization_type,
         status = ppord_row_l.status,
         amount = ppord_row_l.amount,
         initial_amount = ppord_row_l.initial_amount,
         payment_reference_id = ppord_row_l.payment_reference_id,
         approval_code = ppord_row_l.approval_code,
         payment_type = ppord_row_l.payment_type,
         masked_pan = ppord_row_l.masked_pan,
         payment_plan = ppord_row_l.payment_plan,
         currency_code = ppord_row_l.currency_code,
         expiration_date = ppord_row_l.expiration_date,
         first_name = ppord_row_l.first_name,
         last_name = ppord_row_l.last_name,
         email = ppord_row_l.email,
         address = ppord_row_l.address,
         zip = ppord_row_l.zip,
         country = ppord_row_l.country,
         phone = ppord_row_l.phone,
         error_code = error_code_m,
         error_message = error_message_m
   WHERE id = ppord_id_l;
  COMMIT;

  response_p := NVL (error_message_m, 'OK [' || ppord_row_l.payment_type || ']');
  ppord_id_p := ppord_id_l;

END;
PROCEDURE VOID
 (ORDER_ID_P IN tpp_orders.order_id%TYPE
 ,REZ_ID_P IN t_rezervacije.id%TYPE
 ,GOST_ID_P IN t_gosti.id%TYPE
 ,RACNAP_ID_P IN t_rac_nap.id%TYPE := NULL
 ,PKARACNAP_ID_P IN tpka_rac_nap.id%TYPE := NULL
 ,TRANSACTION_TOKEN_P IN tpp_orders.transaction_token%TYPE
 ,ORGANIZATION_CODE_P IN tpp_orders.organization_code%TYPE
 ,RESPONSE_P OUT VARCHAR2
 ,PPORD_ID_P OUT tpp_orders.id%TYPE
 )
 IS
-- Void
-- Oslobaanje autoriziranog iznosa
  ppord_id_l tpp_orders.id%TYPE;
BEGIN

  IF order_id_p IS NULL
    AND transaction_token_p IS NULL
  THEN
    RETURN;
  END IF;

  -- upii zahtjev vrste 06 Void
  INSERT INTO tpp_orders (
      rez_id, gost_id, racnap_id, pkaracnap_id, ozn_vzahtjeva, order_id, transaction_token, organization_code)
    VALUES (
      rez_id_p, gost_id_p, racnap_id_p, pkaracnap_id_p, '06', NVL (order_id_p, '[06]'), transaction_token_p, organization_code_p)
    RETURNING id INTO ppord_id_l;
  COMMIT;

  secret_key_m := zaj_secret_key (organization_code_p);

  data_m := NULL;

  apex_json.initialize_clob_output;
  apex_json.open_object;
    IF order_id_p IS NOT NULL THEN -- autorizacija je obavljena putem Process payment
      apex_json.write ('OrderId', order_id_p);
      signature_m :=
        string2sha512 (
          order_id_p ||
          secret_key_m ||
          order_id_p ||
          secret_key_m);
    END IF;
    apex_json.open_object ('Initiator');
      apex_json.write ('OrganizationCode', organization_code_p);
    apex_json.close_object;
    IF transaction_token_p IS NOT NULL THEN -- autorizacija je obavljena na POS terminalu
      apex_json.open_object ('PaymentMethod');
        apex_json.write ('TransactionToken', transaction_token_p);
      apex_json.close_object;
      signature_m :=
        string2sha512 (
          transaction_token_p ||
          secret_key_m ||
          transaction_token_p ||
          secret_key_m);
    END IF;
    apex_json.write ('Signature', signature_m);
  apex_json.close_object;
  data_m := apex_json.get_clob_output;
  apex_json.free_output;

  zaj_send ('/api/payment/terminal/void');

  -- Obradi odgovor
  /*
  {
    "ErrorCode": "123",
    "ErrorMessage": "Error message"
  }
  ili
  {
    "Id": "173C5AB7-5AB1-49E5-A599-E3BA5D38676D"
  }
  */

  apex_json.parse (values_m, odgovor_m);
  error_code_m := apex_json.get_varchar2 (p_path => 'ErrorCode', p_values => values_m);
  error_message_m := apex_json.get_varchar2 (p_path => 'ErrorMessage', p_values => values_m);
  response_id_m := apex_json.get_varchar2 (p_path => 'Id', p_values => values_m);

  -- upii odgovor
  UPDATE tpp_orders
     SET error_code = error_code_m,
         error_message = error_message_m,
         response_id = response_id_m
   WHERE id = ppord_id_l;
  COMMIT;

  response_p := NVL (error_message_m, 'OK');
  ppord_id_p := ppord_id_l;

END;
PROCEDURE CREDIT
 (ORDER_ID_P IN tpp_orders.order_id%TYPE
 ,REZ_ID_P IN t_rezervacije.id%TYPE
 ,GOST_ID_P IN t_gosti.id%TYPE
 ,RACNAP_ID_P IN t_rac_nap.id%TYPE := NULL
 ,PKARACNAP_ID_P IN tpka_rac_nap.id%TYPE := NULL
 ,TRANSACTION_TOKEN_P IN tpp_orders.transaction_token%TYPE
 ,ORGANIZATION_CODE_P IN tpp_orders.organization_code%TYPE
 ,AMOUNT_P IN tpp_orders.amount%TYPE
 ,RESPONSE_P OUT VARCHAR2
 ,PPORD_ID_P OUT tpp_orders.id%TYPE
 )
 IS
-- Credit transaction (Refund or Partially refund)
-- Povrat
  ppord_id_l tpp_orders.id%TYPE;
BEGIN

  IF order_id_p IS NULL
    AND transaction_token_p IS NULL
  THEN
    RETURN;
  END IF;

  -- upii zahtjev vrste 07 Credit
  INSERT INTO tpp_orders (
      rez_id, gost_id, racnap_id, pkaracnap_id, ozn_vzahtjeva, order_id, amount, transaction_token, organization_code)
    VALUES (
      rez_id_p, gost_id_p, racnap_id_p, pkaracnap_id_p, '07', NVL (order_id_p, '[07]'), amount_p, transaction_token_p, organization_code_p)
    RETURNING id INTO ppord_id_l;
  COMMIT;

  secret_key_m := zaj_secret_key (organization_code_p);

  data_m := NULL;

  apex_json.initialize_clob_output;
  apex_json.open_object;
    IF order_id_p IS NOT NULL THEN -- kupovina je obavljena putem Process payment
      apex_json.write ('OrderId', order_id_p);
      signature_m :=
        string2sha512 (
          order_id_p ||
          secret_key_m ||
          (amount_p * 100) ||
          secret_key_m);
    END IF;
    apex_json.open_object ('Initiator');
      apex_json.write ('OrganizationCode', organization_code_p);
    apex_json.close_object;
    apex_json.write ('Amount', amount_p);
    IF transaction_token_p IS NOT NULL THEN -- kupovina je obavljena na POS terminalu
      apex_json.open_object ('PaymentMethod');
        apex_json.write ('TransactionToken', transaction_token_p);
      apex_json.close_object;
      signature_m :=
        string2sha512 (
          transaction_token_p ||
          secret_key_m ||
          (amount_p * 100) ||
          secret_key_m);
    END IF;
    apex_json.write ('Signature', signature_m);
  apex_json.close_object;
  data_m := apex_json.get_clob_output;
  apex_json.free_output;

  zaj_send ('/api/payment/terminal/credit');

  -- Obradi odgovor
  /*
  {
    "ErrorCode": "123",
    "ErrorMessage": "Error message"
  }
  ili
  {
    "Id": "173C5AB7-5AB1-49E5-A599-E3BA5D38676D"
  }
  */

  apex_json.parse (values_m, odgovor_m);
  error_code_m := apex_json.get_varchar2 (p_path => 'ErrorCode', p_values => values_m);
  error_message_m := apex_json.get_varchar2 (p_path => 'ErrorMessage', p_values => values_m);
  response_id_m := apex_json.get_varchar2 (p_path => 'Id', p_values => values_m);

  -- upii odgovor
  UPDATE tpp_orders
     SET error_code = error_code_m,
         error_message = error_message_m,
         response_id = response_id_m
   WHERE id = ppord_id_l;
  COMMIT;

  response_p := NVL (error_message_m, 'OK');
  ppord_id_p := ppord_id_l;

END;
PROCEDURE CREATE_ORDER
 (ORGANIZATION_CODE_P IN tpp_orders.organization_code%TYPE
 ,REZ_ID_P IN t_rezervacije.id%TYPE
 ,MERCHANT_REFERENCE_ID_P IN tpp_orders.merchant_reference_id%TYPE
 ,ORDER_TYPE_P IN tpp_orders.order_type%TYPE := 3
 ,AMOUNT_P IN tpp_orders.amount%TYPE := NULL
 ,DAT_ODLASKA_P IN t_rezervacije.dat_odlaska%TYPE
 ,NOTIFICATION_TYPE_P IN NUMBER
 ,JEZ_ID_P IN s_jezici.id%TYPE
 ,BR_UPUTNICE_P IN t_rezervacije.br_uputnice%TYPE
 ,IME_P IN t_rezervacije.ime%TYPE
 ,PREZIME_P IN t_rezervacije.prezime%TYPE
 ,EMAIL_P IN t_rezervacije.email%TYPE
 ,ZEM_ID_P IN s_zemlje.id%TYPE
 ,RESPONSE_P OUT VARCHAR2
 )
 IS
/*
Create order
PayPer e temeljem ovog zahtjeva poslati gostu
- poziv za tokenizaciju kartice ili
- poziv za plaanje

IRN 3869 3.9.
MISH alje drugi poziv za tokenizaciju ili poruku o otkazu rezervacije.
*/

  order_id_l VARCHAR2(36) := LOWER (pra_zmp_zaj.formatted_guid (NULL));
  ppord_id_l tpp_orders.id%TYPE;

  CURSOR rez_c IS
    SELECT rbr || '/' || god_poslovna AS broj
      FROM t_rezervacije
     WHERE token_status IS NOT NULL
       AND id <> NVL (rez_id_p, id)
       AND br_uputnice || '|' || creator_id = merchant_reference_id_p;
  rez_c_l rez_c%ROWTYPE;

  CURSOR vnap_c (
    zmppar_sifra_k IN szmp_parametri.sifra%TYPE,
    jez_id_k IN mzmp_vnap_jez.jez_id%TYPE)
  IS
    SELECT NVL (zmpvnapjez.napomena, vnap.napomena) AS napomena
      FROM m_vnapomena vnap,
           (
           SELECT vnap_id, napomena
             FROM mzmp_vnap_jez
            WHERE jez_id = jez_id_k
           ) zmpvnapjez
    WHERE vnap.sifra = pra_zmp_zaj.zmppar_vrijednost ('PAYPER', zmppar_sifra_k)
      AND vnap.id = zmpvnapjez.vnap_id (+);
  subject_l m_vnapomena.napomena%TYPE;
  description_l m_vnapomena.napomena%TYPE;

  jez_sifra_3a_l s_jezici.sifra_3a%TYPE;
  zem_sifra_2a_l s_zemlje.sifra_2a%TYPE;

  has_errors_l BOOLEAN;
  token_status_l t_rezervacije.token_status%TYPE;
BEGIN

  -- privremeno komentirano
  IF /* rez_id_p IS NULL
    OR */ merchant_reference_id_p IS NULL
  THEN
    RETURN;
  END IF;

  -- Provjeri rezervacije
  OPEN rez_c;
  FETCH rez_c INTO rez_c_l;
  IF rez_c%FOUND THEN
    CLOSE rez_c;
    -- Postoji nalog za rezervaciju broj #0 s jednakim Merchant Reference Id #1.
    pra_pka_zaj.vrati_poruku (-20120, rez_c_l.broj, merchant_reference_id_p);
  END IF;
  CLOSE rez_c;

  -- upii zahtjev vrste 08 Create order
  INSERT INTO tpp_orders (
      rez_id, ozn_vzahtjeva, order_id, merchant_reference_id,
      order_type, authorization_type, amount,
      first_name, last_name, email, organization_code,
      unos_korisnik, unos_dat) -- IRN 4027
    VALUES (
      rez_id_p, '08', order_id_l, merchant_reference_id_p,
      order_type_p, DECODE (order_type_p, 2, 2, NULL), amount_p, -- 2 = Customer Initiated Transaction (CIT)
      ime_p, prezime_p, email_p, organization_code_p,
      unos_korisnik_m, SYSDATE) -- IRN 4027
    RETURNING id INTO ppord_id_l;
  COMMIT;

  secret_key_m := zaj_secret_key (organization_code_p);

  data_m := NULL;

  apex_json.initialize_clob_output;
  apex_json.open_object;
    apex_json.write ('OrderId', order_id_l);
    apex_json.write ('MerchantReferenceId', merchant_reference_id_p);
    apex_json.write ('OrderType', order_type_p); -- 3 = Tokenization (TKN) ili 2 = Customer Initiated Transaction (CIT)
    IF order_type_p = 2 THEN
      apex_json.write ('AuthorizationType', 2); -- 2 = Purchase
      apex_json.write ('Amount', amount_p);
    END IF;
    apex_json.write ('ValidUntil', TO_CHAR (dat_odlaska_p + 7, 'YYYY-MM-DD') || ' 23:59:59'); -- IRN 4035; produljena valjanost na 7 dana od dana odlaska

    IF order_type_p = 2 THEN -- 2 = Customer Initiated Transaction (CIT)
      -- 1020 ifra vrste napomene "Naziv poziva za plaanje" ili nebitno.
      OPEN vnap_c ('1020', jez_id_p);
    ELSE
      -- 1007 ifra vrste napomene "Naziv poziva za tokenizaciju" ili nebitno.
      OPEN vnap_c ('1007', jez_id_p);
    END IF;
    FETCH vnap_c INTO subject_l;
    CLOSE vnap_c;
    apex_json.write ('Subject', subject_l);

    IF order_type_p = 2 THEN -- 2 = Customer Initiated Transaction (CIT)
      -- 1021 ifra vrste napomene "Opis poziva za plaanje" ili nebitno.
      OPEN vnap_c ('1021', jez_id_p);
    ELSE
      -- 1008 ifra vrste napomene "Opis poziva za tokenizaciju" ili nebitno.
      OPEN vnap_c ('1008', jez_id_p);
    END IF;
    FETCH vnap_c INTO description_l;
    CLOSE vnap_c;
    apex_json.write ('Description', REPLACE (description_l, '$ReservationID$', br_uputnice_p));

    SELECT MIN (sifra_3a) INTO jez_sifra_3a_l FROM s_jezici WHERE id = jez_id_p;
    apex_json.write ('PreferredLanguageCode', jez_sifra_3a_l);

    apex_json.write ('FirstName', ime_p);
    apex_json.write ('LastName', prezime_p);
    apex_json.write ('Email', email_p);

    SELECT MIN (sifra_2a) INTO zem_sifra_2a_l FROM s_zemlje WHERE id = zem_id_p;
    apex_json.write ('Country', zem_sifra_2a_l);

    apex_json.write ('UrlNotification', 1); -- 1 = User

    apex_json.open_object ('Initiator');
      apex_json.write ('OrganizationCode', organization_code_p);
      apex_json.write ('AgentCode', pra_zmp_zaj.zmppar_vrijednost ('PAYPER', '1005')); -- IRN 3869, AgentCode ili nebitno.
    apex_json.close_object;

    signature_m :=
      string2sha512 (
        secret_key_m ||
        order_id_l ||
        order_id_l ||
        secret_key_m ||
        organization_code_p ||
        secret_key_m);
    apex_json.write ('Signature', signature_m);
  apex_json.close_object;
  data_m := apex_json.get_clob_output;
  apex_json.free_output;

  zaj_send ('/api/payment/order');

  -- Obradi odgovor
  /*
  {
    "OrderId": "14908e44-4b0f-624f-e063-0100007fc55f",
    "MerchantReferenceId": "GJ26031338|MISH",
    "URL": "https://pp31.wspay.info//EN/Payment/1c0cff29-e6da-4fb8-8657-05c4b092c31a",
    "OrderType": 3,
    "AuthorizationType": 1,
    "Status": 0,
    "HasErrors": false,
    "Errors": []
  }
  */

  error_code_m := NULL;
  error_message_m := NULL;
  response_id_m := NULL;

  apex_json.parse (values_m, odgovor_m);
  has_errors_l := apex_json.get_boolean (p_path => 'HasErrors', p_values => values_m);
  IF has_errors_l THEN
    error_code_m := apex_json.get_varchar2 (p_path => 'Errors[1].ErrorCode', p_values => values_m);
    error_message_m := apex_json.get_varchar2 (p_path => 'Errors[1].ErrorMessage', p_values => values_m);
  ELSE
    response_id_m := SUBSTR (apex_json.get_varchar2 (p_path => 'OrderId', p_values => values_m), 1, 36);
  END IF;

  -- upii odgovor
  UPDATE tpp_orders
     SET error_code = error_code_m,
         error_message = error_message_m,
         response_id = response_id_m
   WHERE id = ppord_id_l;

  IF NOT has_errors_l THEN
    /*
    Auriraj token_status:
    1 = poslan prvi zahtjev za tokenizaciju kartice
    2 = poslan drugi poziv za tokenizaciju kartice
    3 = kartica je tokenizirana
    4 = poslana poruka o otkazu rezervacije
    5 = poslan zahtjev za plaanje
    */
    IF order_type_p = 2 THEN -- 2 = Customer Initiated Transaction (CIT)
      token_status_l := 5; -- 5 = poslan zahtjev za plaanje
    ELSE
      IF notification_type_p IS NULL THEN
        token_status_l := 1; -- 1 = poslan prvi zahtjev za tokenizaciju kartice

      ELSIF notification_type_p = 1 THEN -- 1 = Reminder message
        token_status_l := 2; -- 2 = poslan drugi poziv za tokenizaciju kartice

      ELSIF notification_type_p = 2 THEN -- 2 = Cancelation message
        token_status_l := 4; -- 4 = poslana poruka o otkazu rezervacije

      END IF;
    END IF;

    UPDATE t_rezervacije
       SET token_status = token_status_l
     WHERE id = rez_id_p
       -- ??? AND oznaka = 'V'
       -- ??? AND ozn_vstorna IS NULL
       AND NVL (token_status, -1) <> 3;
  END IF;

  COMMIT;

  response_p := NVL (error_message_m, 'OK');

END;
PROCEDURE CHECK_ORDER_INFORMATION
 (ORDER_ID_P IN tpp_orders.order_id%TYPE
 ,ORGANIZATION_CODE_P IN tpp_orders.organization_code%TYPE
 ,PPORD_ROW_P OUT tpp_orders%ROWTYPE
 )
 IS
-- Check order information
  ppord_id_l   tpp_orders.id%TYPE;
  ppord_row_l  tpp_orders%ROWTYPE;
  has_errors_l BOOLEAN;
BEGIN
  IF order_id_p IS NULL THEN
    RETURN;
  END IF;

  secret_key_m := zaj_secret_key (organization_code_p);

  data_m := NULL;

  apex_json.initialize_clob_output;
  apex_json.open_object;
    apex_json.write ('OrderId', order_id_p);
    apex_json.open_object ('Initiator');
      apex_json.write ('OrganizationCode', organization_code_p);
    apex_json.close_object;
    signature_m :=
      string2sha512 (
        organization_code_p ||
        secret_key_m ||
        secret_key_m ||
        order_id_p ||
        organization_code_p ||
        secret_key_m);
    apex_json.write ('Signature', signature_m);
  apex_json.close_object;
  data_m := apex_json.get_clob_output;
  apex_json.free_output;

  zaj_send ('/api/services/check-order-information');

  -- obradi odgovor
  apex_json.parse (values_m, odgovor_m);
  ppord_row_l.order_id := apex_json.get_varchar2 (p_path => 'OrderId', p_values => values_m);
  has_errors_l := apex_json.get_boolean (p_path => 'HasErrors', p_values => values_m);
  IF has_errors_l THEN
    ppord_row_l.error_code := apex_json.get_varchar2 (p_path => 'Errors[1].ErrorCode', p_values => values_m);
    ppord_row_l.error_message := apex_json.get_varchar2 (p_path => 'Errors[1].ErrorMessage', p_values => values_m);
  ELSE
    ppord_row_l.merchant_reference_id := apex_json.get_varchar2 (p_path => 'MerchantReferenceId', p_values => values_m);
    ppord_row_l.order_type := apex_json.get_number (p_path => 'OrderType', p_values => values_m);
    ppord_row_l.authorization_type := apex_json.get_number (p_path => 'AuthorizationType', p_values => values_m);
    ppord_row_l.status := apex_json.get_number (p_path => 'Status', p_values => values_m);
    ppord_row_l.url := apex_json.get_varchar2 (p_path => 'URL', p_values => values_m);
    ppord_row_l.amount := apex_json.get_number (p_path => 'Amount', p_values => values_m);
    ppord_row_l.initial_amount := apex_json.get_number (p_path => 'InitialAmount', p_values => values_m);
    ppord_row_l.first_name := apex_json.get_varchar2 (p_path => 'FirstName', p_values => values_m);
    ppord_row_l.last_name := apex_json.get_varchar2 (p_path => 'LastName', p_values => values_m);
    ppord_row_l.email := apex_json.get_varchar2 (p_path => 'Email', p_values => values_m);
    ppord_row_l.address := apex_json.get_varchar2 (p_path => 'Address', p_values => values_m);
    ppord_row_l.zip := apex_json.get_varchar2 (p_path => 'Zip', p_values => values_m);
    ppord_row_l.city := apex_json.get_varchar2 (p_path => 'City', p_values => values_m);
    ppord_row_l.country := apex_json.get_varchar2 (p_path => 'Country', p_values => values_m);
    ppord_row_l.phone := apex_json.get_varchar2 (p_path => 'Phone', p_values => values_m);
    ppord_row_l.payment_reference_id := apex_json.get_varchar2 (p_path => 'Transaction.PaymentReferenceId', p_values => values_m);
    ppord_row_l.approval_code := apex_json.get_varchar2 (p_path => 'Transaction.ApprovalCode', p_values => values_m);
    ppord_row_l.payment_type := apex_json.get_varchar2 (p_path => 'Transaction.PaymentType', p_values => values_m);
    ppord_row_l.masked_pan := apex_json.get_varchar2 (p_path => 'Transaction.MaskedPAN', p_values => values_m);
    ppord_row_l.partner := apex_json.get_varchar2 (p_path => 'Transaction.Partner', p_values => values_m);
    ppord_row_l.payment_plan := apex_json.get_varchar2 (p_path => 'Transaction.PaymentPlan', p_values => values_m);
    ppord_row_l.on_site := apex_json.get_varchar2 (p_path => 'Transaction.OnSite', p_values => values_m);
    ppord_row_l.currency_code := apex_json.get_varchar2 (p_path => 'Transaction.CurrencyCode', p_values => values_m);
    ppord_row_l.expiration_date := apex_json.get_varchar2 (p_path => 'Transaction.ExpirationDate', p_values => values_m);
    ppord_row_l.organization_code := apex_json.get_varchar2 (p_path => 'Initiator.OrganizationCode', p_values => values_m);
  END IF;

  ppord_row_p := ppord_row_l;

END;
PROCEDURE UPDATE_ORDER
 (ORDER_ID_P IN tpp_orders.order_id%TYPE
 ,REZ_ID_P IN t_rezervacije.id%TYPE
 ,MERCHANT_REFERENCE_ID_P IN tpp_orders.merchant_reference_id%TYPE
 ,ORGANIZATION_CODE_P IN tpp_orders.organization_code%TYPE
 ,AMOUNT_P IN tpp_orders.amount%TYPE
 ,DAT_ODLASKA_P IN t_rezervacije.dat_odlaska%TYPE
 ,RESPONSE_P OUT VARCHAR2
 )
 IS
-- Update order
  ppord_id_l tpp_orders.id%TYPE;
BEGIN

  IF order_id_p IS NULL THEN
    RETURN;
  END IF;

  -- upii zahtjev vrste 13 Update order
  INSERT INTO tpp_orders (
      rez_id, ozn_vzahtjeva, order_id, merchant_reference_id, amount, organization_code)
    VALUES (
      rez_id_p, '13', order_id_p, merchant_reference_id_p, amount_p, organization_code_p)
    RETURNING id INTO ppord_id_l;
  COMMIT;

  secret_key_m := zaj_secret_key (organization_code_p);

  data_m := NULL;

  apex_json.initialize_clob_output;
  apex_json.open_object;
    apex_json.write ('OrderId', order_id_p);
    apex_json.write ('MerchantReferenceId', merchant_reference_id_p);
    apex_json.open_object ('Initiator');
      apex_json.write ('OrganizationCode', organization_code_p);
    apex_json.close_object;
    apex_json.write ('Amount', amount_p);
    apex_json.write ('ValidUntil', TO_CHAR (dat_odlaska_p, 'YYYY-MM-DD') || ' 23:59:59');
    signature_m :=
      string2sha512 (
        order_id_p ||
        secret_key_m ||
        organization_code_p ||
        order_id_p ||
        secret_key_m);
    apex_json.write ('Signature', signature_m);
  apex_json.close_object;
  data_m := apex_json.get_clob_output;
  apex_json.free_output;

  zaj_send ('/api/payment/update');

  -- Obradi odgovor
  /*
  {
    "ErrorCode": "123",
    "ErrorMessage": "Error message"
  }
  ili
  {
    "Id": "173C5AB7-5AB1-49E5-A599-E3BA5D38676D"
  }
  */

  apex_json.parse (values_m, odgovor_m);
  error_code_m := apex_json.get_varchar2 (p_path => 'ErrorCode', p_values => values_m);
  error_message_m := apex_json.get_varchar2 (p_path => 'ErrorMessage', p_values => values_m);
  response_id_m := apex_json.get_varchar2 (p_path => 'Id', p_values => values_m);

  -- upii odgovor
  UPDATE tpp_orders
     SET error_code = error_code_m,
         error_message = error_message_m,
         response_id = response_id_m
   WHERE id = ppord_id_l;
  COMMIT;

  response_p := NVL (error_message_m, 'OK');

END;
PROCEDURE CANCEL_ORDER
 (ORDER_ID_P IN tpp_orders.order_id%TYPE
 ,REZ_ID_P IN t_rezervacije.id%TYPE
 ,MERCHANT_REFERENCE_ID_P IN tpp_orders.merchant_reference_id%TYPE
 ,ORGANIZATION_CODE_P IN tpp_orders.organization_code%TYPE
 ,MESSAGE_NOTIFICATION_P IN NUMBER
 ,RESPONSE_P OUT VARCHAR2
 )
 IS
-- Cancel order
  ppord_id_l tpp_orders.id%TYPE;
BEGIN

  IF order_id_p IS NULL THEN
    RETURN;
  END IF;

  -- upii zahtjev vrste 14 Cancel order
  INSERT INTO tpp_orders (
      rez_id, ozn_vzahtjeva, order_id, merchant_reference_id, organization_code)
    VALUES (
      rez_id_p, '14', order_id_p, merchant_reference_id_p, organization_code_p)
    RETURNING id INTO ppord_id_l;
  COMMIT;

  secret_key_m := zaj_secret_key (organization_code_p);

  data_m := NULL;

  apex_json.initialize_clob_output;
  apex_json.open_object;
    apex_json.write ('OrderId', order_id_p);
    apex_json.write ('MerchantReferenceId', merchant_reference_id_p);
    apex_json.open_object ('Initiator');
      apex_json.write ('OrganizationCode', organization_code_p);
    apex_json.close_object;
    apex_json.write ('MessageNotification', message_notification_p);
    signature_m :=
      string2sha512 (
        order_id_p ||
        secret_key_m ||
        order_id_p ||
        secret_key_m);
    apex_json.write ('Signature', signature_m);
  apex_json.close_object;
  data_m := apex_json.get_clob_output;
  apex_json.free_output;

  zaj_send ('/api/payment/cancel');

  -- Obradi odgovor
  /*
  {
    "ErrorCode": "123",
    "ErrorMessage": "Error message"
  }
  ili
  {
    "Id": "173C5AB7-5AB1-49E5-A599-E3BA5D38676D"
  }
  */

  apex_json.parse (values_m, odgovor_m);
  error_code_m := apex_json.get_varchar2 (p_path => 'ErrorCode', p_values => values_m);
  error_message_m := apex_json.get_varchar2 (p_path => 'ErrorMessage', p_values => values_m);
  response_id_m := apex_json.get_varchar2 (p_path => 'Id', p_values => values_m);

  -- upii odgovor
  UPDATE tpp_orders
     SET error_code = error_code_m,
         error_message = error_message_m,
         response_id = response_id_m
   WHERE id = ppord_id_l;

  IF error_message_m IS NULL THEN
    UPDATE t_rezervacije
       SET token_status = NULL
     WHERE id = rez_id_p
       AND token_status IS NOT NULL;
  END IF;

  COMMIT;

  response_p := NVL (error_message_m, 'OK');

END;
PROCEDURE AZURIRAJ_REZ_TOKEN_STATUS
 (REZ_ID_P IN t_rezervacije.id%TYPE
 ,ORDER_TYPE_P IN tpp_orders.order_type%TYPE
 ,STATUS_P IN tpp_orders.status%TYPE
 )
 IS
/*
Postavi t_rezervacije.token_status na 3 - kartica je tokenizirana, ako vrijedi
-- IRN 4027; -- OrderType = 1 - Card on File (COF) i Status = 2 - Completed
-- komentirano jer s tokenom koji stigne s COF se ne moe odraditi SCA (Strong Customer Authenticated) transakcija
-- ili
OrderType = 3 - Tokenization (TKN) i Status = 3 - Voided
ili
OrderType = 2 - Customer Initiated Transaction (CIT) i Status = 2 - Completed, a AuthorizationType = 2 - Purchase
Poziva se iz AIS/AUS_TPP_ORDERS.

IRN 4027
Postavi t_rezervacije.token_status na 1 - poslan prvi zahtjev za tokenizaciju kartice, ako vrijedi
OrderType = 3 - Tokenization (TKN) i Status = 0 - Created
*/
BEGIN
  IF rez_id_p IS NULL
    OR order_type_p NOT IN (2, 3)
    OR status_p NOT IN (0, 2, 3)
  THEN
    RETURN;
  END IF;

  -- IRN 4027; dodano jer odgovor na zahtjev vrlo esto stigne prekasno
  IF (order_type_p = 3 AND status_p = 0)
  THEN
    UPDATE t_rezervacije
       SET token_status = 1
     WHERE id = rez_id_p
       AND token_status IS NULL;
  END IF;
  -- KRAJ IRN 4027

  IF (order_type_p = 3 AND status_p = 3)
    OR
     (order_type_p = 2 AND status_p = 2) -- IRN 3869 1.8.
  THEN
    UPDATE t_rezervacije
       SET token_status = 3
     WHERE id = rez_id_p
       AND NVL (token_status, -1) <> 3;
  END IF;
END;
PROCEDURE IZRADI_TKN_NALOGE
 (VLASNIKPODATKA_P IN NUMBER := NULL
 )
 IS
/*
Izradi zahtjev za tokenizaciju kartice
ili poalji poziv (podsjetnik) za tokenizaciju kartice
ili poalji poruku o otkazu rezervacije.
Proceduru poziva job IZRADI_TKN_NALOGE.
*/
  response_l VARCHAR2 (500);
  br_dana1_l szmp_parametri.vrijednost%TYPE;
  br_dana2_l szmp_parametri.vrijednost%TYPE;
  br_dana3_l szmp_parametri.vrijednost%TYPE; -- IRN 3869 1.8.
  guarantee_codes_l szmp_parametri.vrijednost%TYPE;
  ms_sifre_l szmp_parametri.vrijednost%TYPE;
  cje_sifre_l szmp_parametri.vrijednost%TYPE;
  datum_l DATE; -- IRN 4035
  notification_type_l NUMBER;
  errors_l VARCHAR2 (32000);
  email_l szmp_parametri.vrijednost%TYPE;
  sender_l szmp_parametri.vrijednost%TYPE;

  CURSOR ppord_c (rez_id_k t_rezervacije.id%TYPE) IS -- IRN 3869 3.9.
    SELECT url
      FROM tpp_orders
     WHERE order_type = 3 -- 3 = Tokenization (TKN)
       AND url IS NOT NULL
       AND rez_id = rez_id_k
     ORDER BY izmjena_dat DESC;
  url_l tpp_orders.url%TYPE;
  ozn_poslano_l NUMBER;

  max_rownum_l NUMBER := 0; -- IRN 4035
BEGIN

  pra_zmp_context.set_vlasnikpodatka (vlasnikpodatka_p);

  SELECT
    -- Broj dana prije dolaska za slanje 1. poruke gostu ili nebitno.
    pra_zmp_zaj.zmppar_vrijednost ('PAYPER', '1012'),
    -- Broj dana prije dolaska za slanje 2. poruke gostu ili nebitno.
    pra_zmp_zaj.zmppar_vrijednost ('PAYPER', '1013'),
    -- Broj dana prije dolaska za slanje poruke o otkazu rezervacije ili nebitno.
    pra_zmp_zaj.zmppar_vrijednost ('PAYPER', '1017'),
    -- Guarantee Codes (odvojeni zarezom) za koje je potrebno slati poruku gostu ili nebitno.
    pra_zmp_zaj.zmppar_vrijednost ('PAYPER', '1014'),
    -- ifre MS (odvojene zarezom) za koje je potrebno slati poruku gostu ili nebitno.
    pra_zmp_zaj.zmppar_vrijednost ('PAYPER', '1015'),
    -- ifre cjenika (odvojene zarezom) za koje je potrebno slati poruku gostu ili nebitno.
    pra_zmp_zaj.zmppar_vrijednost ('PAYPER', '1016'),
    -- IRN 4035
    (
    SELECT
      DECODE (vrijednost, 'nebitno', TO_DATE (NULL), TO_DATE (vrijednost, 'DD.MM.RRRR'))
    FROM (
      SELECT
        -- Najmanji datum rezervacije za koji treba slati poziv za tokenizaciju npr. 15.04.2025 ili nebitno.
        pra_zmp_zaj.zmppar_vrijednost ('PAYPER', '1022') AS vrijednost
      FROM dual)
    )
  INTO br_dana1_l, br_dana2_l, br_dana3_l, guarantee_codes_l, ms_sifre_l, cje_sifre_l, datum_l
  FROM dual;

  IF br_dana1_l = 'nebitno'
    OR br_dana2_l = 'nebitno'
    OR br_dana3_l = 'nebitno'
    OR guarantee_codes_l = 'nebitno'
    OR ms_sifre_l = 'nebitno'
    -- 31.03.2025. -- OR cje_sifre_l = 'nebitno'
  THEN
    RETURN;
  END IF;

  unos_korisnik_m := 'MISH-AO'; -- IRN 4027

  FOR rez_c IN (
    SELECT
      rownum AS rnum, -- IRN 4027
      rez.id,
      rez.dat_dolaska,
      rez.dat_odlaska,
      rez.jez_id,
      (SELECT MIN (sifra_3a) FROM s_jezici WHERE id = rez.jez_id) AS jez_sifra_3a, -- IRN 3869 3.9.
      INITCAP (rez.ime) AS ime,
      INITCAP (rez.prezime) AS prezime,
      LOWER (rez.email) AS email,
      NVL (rez.zem_id, rez.zemd_id) AS zem_id,
      rez.br_uputnice,
      rez.creator_id,
      recso.sifra AS recsosus_sifra,
      CASE
        WHEN rez.token_status IS NULL THEN NULL
        WHEN rez.token_status = 1 THEN 1 -- 1 = Reminder message
        ELSE 2                           -- 2 = Cancelation message
      END AS notification_type
    FROM
      t_rezervacije rez,
      (
      SELECT
        recsosus.so_id,
        recsosus.sifra
      FROM
        mrec_so_sus recsosus,
        szmp_sustavi zmpsus
      WHERE
        recsosus.zmpsus_id = zmpsus.id
        AND zmpsus.sifra = 'PAYPER'
      ) recso
    WHERE
      rez.oznaka = 'V'
      AND rez.ozn_vstorna IS NULL
      AND (datum_l IS NULL OR rez.datum >= datum_l) -- IRN 4035
      AND rez.creator_id IS NOT NULL
      AND rez.br_uputnice IS NOT NULL
      AND rez.email IS NOT NULL
      AND recso.so_id = rez.so_id
      AND (rez.token_status IS NULL OR rez.token_status IN (1, 2))
      AND rez.dat_dolaska > TRUNC (SYSDATE)
      AND rez.dat_dolaska <= TRUNC (SYSDATE)
          + CASE
              WHEN rez.token_status IS NULL THEN br_dana1_l
              WHEN rez.token_status = 1 THEN br_dana2_l
              ELSE br_dana3_l
            END
      AND zmp_zaj.string_in_list (rez.guarantee_code, guarantee_codes_l) = -1
      AND rez.ms_id IN (SELECT id FROM m_msegmenti WHERE -1 = zmp_zaj.string_in_list (sifra, ms_sifre_l))
      AND (cje_sifre_l = 'nebitno' OR rez.cje_id IN (SELECT id FROM t_cjenici WHERE -1 = zmp_zaj.string_in_list (sifra, cje_sifre_l))) -- 31.03.2025.
      -- broj poslanih zahtjeva vrste 3 juer i danas za tu rezervaciju
      AND 0 = (SELECT COUNT (1)
                 FROM tpp_orders
                WHERE rez_id = rez.id
                  AND order_type = 3 -- 3 = Tokenization (TKN)
                  AND TRUNC (unos_dat) BETWEEN TRUNC (SYSDATE) - 1 AND TRUNC (SYSDATE) -- 29.12.
               )
      -- IRN 3869 3.9.
      -- broj poslanih e-poruka vrste 21 i 91 juer i danas za tu rezervaciju
      AND 0 = (SELECT COUNT (1)
                 FROM lpka_veporuka lpkavepor,
                      mpka_veporuka pkavepor
                WHERE lpkavepor.pkavepor_id = pkavepor.id
                  AND pkavepor.oznaka IN (21, 91) -- 21 = poziv za tokenizaciju, 91 = poruka o otkazu
                  AND lpkavepor.rez_id = rez.id
                  AND TRUNC (lpkavepor.unos_dat) BETWEEN TRUNC (SYSDATE) - 1 AND TRUNC (SYSDATE) -- 29.12.
               )
      -- KRAJ IRN 3869 3.9.
    ORDER BY -- IRN 4027
      rez.dat_dolaska,
      rez.rbr
    )
  LOOP
    -- IRN 4035
    IF max_rownum_l < rez_c.rnum THEN
      max_rownum_l := rez_c.rnum;
    END IF;
    -- KRAJ IRN 4035
    BEGIN
      -- IRN 3869 3.9.
      IF rez_c.notification_type = 1 THEN -- 1 = Reminder message
        url_l := NULL;
        OPEN ppord_c (rez_c.id);
        FETCH ppord_c INTO url_l;
        CLOSE ppord_c;
        IF url_l IS NOT NULL THEN
          ozn_poslano_l := NULL;
          pra_mpka_veporuka.salji_rez_pp (
            ozn_veporuka_p => 21, -- rezervacije - poziv za tokenizaciju
            ime_p          => rez_c.ime,
            prezime_p      => rez_c.prezime,
            email_p        => rez_c.email,
            jez_id_p       => rez_c.jez_id,
            jez_sifra_3a_p => rez_c.jez_sifra_3a,
            br_uputnice_p  => rez_c.br_uputnice,
            ppord_url_p    => url_l,
            rez_id_p       => rez_c.id,
            ozn_poslano_p  => ozn_poslano_l);
          IF ozn_poslano_l = -1 THEN
            UPDATE t_rezervacije
               SET token_status = 2 -- 2 = poslan drugi zahtjev za tokenizaciju kartice
             WHERE id = rez_c.id
               AND NVL (token_status, -1) <> 3;
            COMMIT;
          ELSE
            -- Poruka vrste #0 za rezervaciju #1 nije poslana.
            UTL_TCP.close_all_connections; -- 31.03.2025. da se ne javlja greka "too many connections"
            pra_pka_zaj.vrati_poruku (-20122, '21 (Reminder)', rez_c.br_uputnice);
          END IF;
        END IF;
      ELSIF rez_c.notification_type = 2 THEN -- 2 = Cancelation message
        ozn_poslano_l := NULL;
        pra_mpka_veporuka.salji_rez_pp (
          ozn_veporuka_p => 91, -- rezervacije - poruka o otkazu
          ime_p          => rez_c.ime,
          prezime_p      => rez_c.prezime,
          email_p        => rez_c.email,
          jez_id_p       => rez_c.jez_id,
          jez_sifra_3a_p => rez_c.jez_sifra_3a,
          br_uputnice_p  => rez_c.br_uputnice,
          ppord_url_p    => NULL,
          rez_id_p       => rez_c.id,
          ozn_poslano_p  => ozn_poslano_l);
        IF ozn_poslano_l = -1 THEN
          UPDATE t_rezervacije
             SET token_status = 4 -- 4 = poslan zahtjev o otkazu rezervacije
           WHERE id = rez_c.id
             AND NVL (token_status, -1) <> 3;
          COMMIT;
        ELSE
          -- Poruka vrste #0 za rezervaciju #1 nije poslana.
          UTL_TCP.close_all_connections; -- 31.03.2025. da se ne javlja greka "too many connections"
          pra_pka_zaj.vrati_poruku (-20122, '91 (Cancelation)', rez_c.br_uputnice);
        END IF;
      END IF;
      -- KRAJ IRN 3869 3.9.
      IF rez_c.notification_type IS NULL
        OR (rez_c.notification_type = 1 AND url_l IS NULL) -- 1 = Reminder message
      THEN
        response_l := NULL; -- IRN 4027
        pra_pka_payper.create_order (
          organization_code_p      => rez_c.recsosus_sifra,
          rez_id_p                 => rez_c.id,
          merchant_reference_id_p  => rez_c.br_uputnice || '|' || rez_c.creator_id,
          order_type_p             => 3, -- 3 = Tokenization (TKN)
          amount_p                 => NULL,
          dat_odlaska_p            => rez_c.dat_odlaska,
          notification_type_p      => rez_c.notification_type,
          jez_id_p                 => rez_c.jez_id,
          br_uputnice_p            => rez_c.br_uputnice,
          ime_p                    => rez_c.ime,
          prezime_p                => rez_c.prezime,
          email_p                  => rez_c.email,
          zem_id_p                 => rez_c.zem_id,
          response_p               => response_l);
        IF response_l IS NULL OR response_l <> 'OK' THEN -- IRN 4027
          errors_l := errors_l || CHR(10) || rez_c.br_uputnice || ' | ' || rez_c.rnum || ' | ' || response_l;
        END IF;
      END IF;
    EXCEPTION
      WHEN OTHERS THEN
        errors_l := errors_l || CHR(10) || rez_c.br_uputnice || ' | ' || rez_c.rnum || ' | ' || SQLERRM; -- IRN 4027; dodan rez_c.rnum
    END;
    DBMS_LOCK.sleep (3); -- 31.03.2025. dodano tako da mail server ne "zapinje" ako ima puno e-poruka
  END LOOP;

  unos_korisnik_m := NULL; -- IRN 4027

  IF errors_l IS NOT NULL THEN
    errors_l := errors_l || CHR(10) || '[' || max_rownum_l || ']'; -- IRN 4035
    pra_pka2.clob_to_table (errors_l || CHR(10), 'PayPer-AO-' || TO_CHAR (SYSDATE, 'RRRR-MM-DD') || '.log', NULL, 'PAYPER');

    -- E-adrese (odvojene zarezom) za slanje obavijesti o grekama ili nebitno.
    email_l := pra_zmp_zaj.zmppar_vrijednost ('PAYPER', '1006');
    IF email_l = 'nebitno' THEN
      RETURN;
    END IF;

    sender_l := pra_zmp_zaj.zmppar_vrijednost ('ZMP', '0905'); -- noreply
    BEGIN
      pra_pka2.salji_html_email (
        recipient_p    => email_l,
        recipient_h_p  => NULL,
        sender_p       => sender_l,
        sender_h_p     => 'MISH Baza',
        bcc_p          => NULL,
        subject_p      => '(' || LOWER (SYS_CONTEXT ('USERENV', 'CURRENT_SCHEMA')) || ') Greka kod slanja zahtjeva za tokenizaciju kartice', -- 31.03.2025.
        text_p         => errors_l);
    EXCEPTION
      WHEN OTHERS THEN
        NULL;
    END;
  END IF;
END;

END PRA_PKA_PAYPER;
/
SHOW ERROR

