-- D:\mish_CVS\misH_skripte\pra_gas_pka.pkb
--
-- Generated for Oracle 10g on Mon Nov 17  15:53:51 2025 by Server Generator 6.5.96.5.6
 

PROMPT Creating Package Body 'PRA_GAS_PKA'
CREATE OR REPLACE PACKAGE BODY PRA_GAS_PKA IS

PROCEDURE UPISI_RACUN
 (DATUM_P IN t_rnkase.datum%TYPE
 ,SJ_ID_P IN m_sj.id%TYPE
 ,PRO_ID_P IN m_proizvodi.id%TYPE
 ,KOLICINA_P IN t_rnkase_pro.kolicina%TYPE
 ,CIJENA_P IN t_rnkase_pro.cijena%TYPE
 ,GOST_ID_P IN t_gosti.id%TYPE
 ,KASE_ID_P IN mgmp_kase.id%TYPE
 ,NAC_ID_P IN m_nacpot.id%TYPE
 ,PKAADR_ID_P IN mpka_adrese.id%TYPE
 ,AGE_ID_P IN m_agencije.id%TYPE
 ,PKAKAR_ID_P IN tpka_kartice.id%TYPE
 ,PORUKA_P IN OUT VARCHAR2
 ,RBR_P OUT t_rnkase.rbr%TYPE
 )
 IS
/*
Procedura nema COMMIT pa njen pozivatelj mora imati vlastiti COMMIT.
Proceduru koristi modul REC2350.fmb - Rauni sa minibara,
te funkcije upis_racuna_well, upis_racuna_ptv i prepaid_uplata.
*/
  poruka_l    VARCHAR2(500);
  br_redaka_l NUMBER;
  gost_id_l   t_gosti.id%TYPE;
  gporez_l   VARCHAR2(60);

  rn_row_l    t_rnkase%ROWTYPE;
  rnpro_row_l t_rnkase_pro%ROWTYPE;

  gmpkas_sifra_l mgmp_kase.sifra%TYPE;
  ozn_irn_l      s_vplacanja.ozn_irn%TYPE;
  pro_sifra_l    m_proizvodi.sifra%TYPE;
  pro_naziv_l    m_proizvodi.naziv%TYPE;
  pro_jm_l       m_proizvodi.jm%TYPE;
  kpd_sifra_l    s_kpd.sifra%TYPE;

  izn_osnovice_l ipka_rnk_pdv.izn_osnovice%TYPE;
  izn_osnovice_ppot_l tpka_rnkasa.izn_osnovice_ppot%TYPE;

  pkarnk_id_l tpka_rnkasa.id%TYPE; -- OUT parametar procedure pra_pos_pka.insert_racun

  CURSOR ojr_kasa_cur IS -- IRN 2548; brisano itanje m_sj i m_so
    SELECT zmpojr_id, sifra
      FROM mgmp_kase
     WHERE id = kase_id_p;

  CURSOR kon_cur is
    SELECT konkase.kon_id
      FROM m_kon_kase konkase,
           m_konobari kon
     WHERE konkase.kase_id = kase_id_p
       AND konkase.kon_id = kon.id
     ORDER BY kon.sifra; -- ako je vie konobara vezano za kasu uzima prvog po ifri

  CURSOR nacvpla_cur IS
    SELECT nacvpla.vpla_id, vpla.ozn_irn
      FROM m_nac_vpla nacvpla,
           s_vplacanja vpla,
           s_vpplacanja vppla
     WHERE nacvpla.nac_id = nac_id_p
       AND nacvpla.vpla_id = vpla.id
       AND vpla.vppla_id = vppla.id
       AND (  (vpla.ozn_irn = '1' AND sj_id_p IS NOT NULL)     -- interni raun na raun gosta
           OR (vpla.ozn_irn = '3' AND pkaadr_id_p IS NOT NULL) -- interni raun na raun osobe (adrese)
           OR (vpla.ozn_irn = '2' AND age_id_p IS NOT NULL) -- IRN 2548; interni raun na raun agencije
           OR (vpla.ozn_irn IS NULL AND sj_id_p IS NULL AND pkaadr_id_p IS NULL AND age_id_p IS NULL)) -- nije interni raun
       AND vppla.sifra = 'X' -- ne fiskalizira se
     ORDER BY vpla.sifra;

  CURSOR pro_cur IS
    SELECT pro.gknji_id, pro.gtehpro_id, gpor.ppot, vpispz.stopa, pro.gpor_id, vpispp.vpispz_id,
           pro.sif_proizvoda_kasa, pro.naziv, pro.jm, kpd.sifra kpd_sifra
      FROM m_proizvodi pro,
           m_gporez gpor,
           mgas_gpor_raz grazgpor,
           s_vpisporukap vpispp,
           s_vpisporukaz vpispz,
           s_kpd kpd
     WHERE pro.ID = pro_id_p
       AND pro.gpor_id = gpor.id
       AND gpor.id = grazgpor.gpor_id
       AND datum_p BETWEEN grazgpor.dat_valjan AND NVL(grazgpor.dat_ponisten, SYSDATE)
       AND grazgpor.vpispp_id= vpispp.ID
       AND vpispp.vpispz_id = vpispz.id
       AND kpd.id(+) = pro.kpd_id;

 CURSOR gpor_cur IS
    SELECT gpor.sifra ||' '|| gpor.naziv
      FROM m_proizvodi pro,
           m_gporez gpor
     WHERE pro.id = pro_id_p
       AND pro.gpor_id = gpor.id;
BEGIN

  poruka_l := poruka_p; -- npr. OK

  -- Nedostaje obvezan ulazni parametar (#0).
  IF datum_p IS NULL THEN
    RAISE_APPLICATION_ERROR (-20202, pra_zmp_zaj.poruka ('PKA', '-20202', 'datum_p'));
  ELSIF pro_id_p IS NULL THEN
    RAISE_APPLICATION_ERROR (-20202, pra_zmp_zaj.poruka ('PKA', '-20202', 'pro_id_p'));
  ELSIF kolicina_p IS NULL THEN
    RAISE_APPLICATION_ERROR (-20202, pra_zmp_zaj.poruka ('PKA', '-20202', 'kolicina_p'));
  ELSIF cijena_p IS NULL THEN
    RAISE_APPLICATION_ERROR (-20202, pra_zmp_zaj.poruka ('PKA', '-20202', 'cijena_p'));
  ELSIF kase_id_p IS NULL THEN
    RAISE_APPLICATION_ERROR (-20202, pra_zmp_zaj.poruka ('PKA', '-20202', 'kase_id_p'));
  ELSIF nac_id_p IS NULL THEN
    RAISE_APPLICATION_ERROR (-20202, pra_zmp_zaj.poruka ('PKA', '-20202', 'nac_id_p'));
  END IF;

  IF   sj_id_p IS NOT NULL AND pkaadr_id_p IS     NULL AND age_id_p IS     NULL
    OR sj_id_p IS     NULL AND pkaadr_id_p IS NOT NULL AND age_id_p IS     NULL
    OR sj_id_p IS     NULL AND pkaadr_id_p IS     NULL AND age_id_p IS NOT NULL
    OR sj_id_p IS     NULL AND pkaadr_id_p IS     NULL AND age_id_p IS     NULL
  THEN
    NULL;
  ELSE
    -- Pogreni ulazni parametri: platitelj je ili gost ili adresa ili agencija
    RAISE_APPLICATION_ERROR (-20422, pra_zmp_zaj.poruka ('GAS', '-20422'));
  END IF;

  IF sj_id_p IS NOT NULL THEN
    SELECT COUNT (rowid) INTO br_redaka_l FROM m_sj WHERE id = sj_id_p;
    IF br_redaka_l = 0 THEN
      -- Ne postoji smjetajna jedinica broj #0!
      RAISE_APPLICATION_ERROR (-20001, pra_zmp_zaj.poruka ('REC', 'REC0202', '[id = ' || sj_id_p || ']'));
    END IF;

    SELECT MIN (id) INTO gost_id_l
      FROM t_gosti
     WHERE sj_id = sj_id_p
       AND TRUNC (datum_p) BETWEEN dat_dolaska AND dat_odlaska
       AND (ozn_prisutnosti = 'P' OR gost_id_p IS NOT NULL)
       AND id = NVL (gost_id_p, id);
    IF gost_id_l IS NULL THEN
      -- Gost ne postoji!
      RAISE_APPLICATION_ERROR (-20001, pra_zmp_zaj.poruka ('PKA', 'PKA0019'));
    END IF;
  END IF;

  SELECT MIN (mt_id) INTO rnpro_row_l.mt_id
    FROM m_aso_kase
   WHERE kase_id = kase_id_p
     AND nac_id = nac_id_p
     AND pro_id = pro_id_p;

  IF rnpro_row_l.mt_id IS NULL THEN
    -- Nije definiran asortiman kase
    RAISE_APPLICATION_ERROR (-20001, pra_zmp_zaj.poruka ('GAS', 'GAS0559'));
  END IF;

  OPEN ojr_kasa_cur;
  FETCH ojr_kasa_cur INTO rn_row_l.oj_id, gmpkas_sifra_l;
  CLOSE ojr_kasa_cur;

  OPEN kon_cur;
  FETCH kon_cur INTO rn_row_l.kon_id;
  CLOSE kon_cur;
  IF rn_row_l.kon_id IS NULL THEN
    -- Ne postoji veza konobar i kasa
    RAISE_APPLICATION_ERROR (-20001, pra_zmp_zaj.poruka ('GAS', 'GAS0633'));
  END IF;

  OPEN nacvpla_cur;
  FETCH nacvpla_cur INTO rn_row_l.vpla_id, ozn_irn_l;
  CLOSE nacvpla_cur;

  -- puni T_RNKASE
  rn_row_l.id := gas_zaj.sekvenca (NULL);
  rn_row_l.godina := TO_CHAR (datum_p, 'RRRR');
  rn_row_l.kase_id := kase_id_p;
  -- rbr     -- puni BIR
  rn_row_l.datum := TRUNC (datum_p);
  -- kon_id  -- vidi kon_cur
  rn_row_l.nac_id := nac_id_p;
  -- vpla_id -- vidi nacvpla_cur
  rn_row_l.popust := 0;
  -- opis
  rn_row_l.vrijeme := TO_CHAR (SYSDATE, 'HH24MI');
  -- oj_id -- vidi ojr_kasa_cur
  rn_row_l.sj_id := sj_id_p;
  rn_row_l.age_id := age_id_p; -- IRN 2548
  rn_row_l.br_gostiju := 1;
  -- vpdog_id
  IF pkaadr_id_p IS NOT NULL THEN -- adresa nije replikacijski podatak, gastro moe biti centralni
    rn_row_l.pkaadr_ozn := 'D';
  ELSE
    rn_row_l.pkaadr_ozn := 'N';
  END IF;
  rn_row_l.ozn_valjanosti := 'V';
  rn_row_l.izn_placanja := ROUND (kolicina_p * cijena_p, 2); -- IRN 2872
  -- unos_korisnik, unos_dat, izmjena_korisnik, izmjena_dat -- puni BIR
  INSERT INTO t_rnkase VALUES rn_row_l;

  OPEN pro_cur;
  FETCH pro_cur
    INTO rnpro_row_l.gknji_id,
         rnpro_row_l.gtehpro_id,
         rnpro_row_l.ppot,
         rnpro_row_l.pdv,
         rnpro_row_l.gpor_id,
         rnpro_row_l.vpispz_id,
         pro_sifra_l, pro_naziv_l, pro_jm_l, kpd_sifra_l;
  CLOSE pro_cur;

  IF rnpro_row_l.gpor_id IS NULL THEN
    OPEN gpor_cur;
    FETCH gpor_cur
       INTO gporez_l;
    CLOSE gpor_cur;

    RAISE_APPLICATION_ERROR (-20001, pra_zmp_zaj.poruka ('GAS', '-20429', gporez_l));
  END IF;


  -- puni T_RNKASE_PRO
  rnpro_row_l.rn_id := rn_row_l.id;
  rnpro_row_l.rbr_stavke := 1;
  rnpro_row_l.pro_id := pro_id_p;
  -- sifgr_id
  -- gpor_id     -- vidi pro_cur
  -- gknji_id    -- vidi pro_cur
  -- gtehpro_id  -- vidi pro_cur
  -- mt_id       -- vidi SELECT FROM m_aso_kase
  rnpro_row_l.kolicina := kolicina_p;
  rnpro_row_l.cijena := cijena_p;
  -- pdv         -- vidi pro_cur
  -- ppot        -- vidi pro_cur
  rnpro_row_l.zad_nab_cijena := 0;
  rnpro_row_l.pros_nab_cijena := 0;
  -- vpispz_id   -- vidi pro_cur
  rnpro_row_l.popust := 0;
  rnpro_row_l.iznos_popust := 0;
  rnpro_row_l.iznos_pnaknade := 0;
  rnpro_row_l.iznos      := ROUND (kolicina_p * cijena_p, 2);
  rnpro_row_l.iznos_pdv  := ROUND (rnpro_row_l.iznos * rnpro_row_l.pdv / (100 + rnpro_row_l.pdv + rnpro_row_l.ppot), 2);
  rnpro_row_l.iznos_ppot := ROUND (rnpro_row_l.iznos * rnpro_row_l.ppot / (100 + rnpro_row_l.pdv + rnpro_row_l.ppot), 2); 
  rnpro_row_l.iznos_popust2 := 0;         -- IRN  4020
  -- unos_korisnik, unos_dat, izmjena_korisnik, izmjena_dat -- puni BIR
  INSERT INTO t_rnkase_pro VALUES rnpro_row_l;

  SELECT rbr INTO rn_row_l.rbr FROM t_rnkase WHERE id = rn_row_l.id;

  IF ozn_irn_l IS NULL THEN
    GOTO kraj; -- radi se o vrstama plaanja koje ne idu u PKA
  END IF;

  izn_osnovice_l := rnpro_row_l.iznos - rnpro_row_l.iznos_pdv - rnpro_row_l.iznos_ppot;
  IF rnpro_row_l.ppot = 0 THEN
    izn_osnovice_ppot_l := 0;
  ELSE
    izn_osnovice_ppot_l := izn_osnovice_l;
  END IF;

  pra_pos_pka.insert_racun (
    zmpojr_id_p => rn_row_l.oj_id,
    gmpkas_id_p => rn_row_l.kase_id,
    vpla_id_p => rn_row_l.vpla_id,
    gostp_id_p => gost_id_l,
    agep_id_p => age_id_p, -- IRN 2548
    pkaadrp_id_p => pkaadr_id_p,
    god_poslovna_p => rn_row_l.godina,
    rbr_p => rn_row_l.rbr,
    datum_p => rn_row_l.datum,
    izn_placanja_p => rnpro_row_l.iznos,
    izn_ppot_p => rnpro_row_l.iznos_ppot,
    opis1_p => NULL,
    opis2_p => NULL,
    recara_id_p => NULL,
    vpdog_id_p => NULL,
    nac_id_p => rn_row_l.nac_id,
    stopa_ppot_p => rnpro_row_l.ppot,
    izn_osnovice_ppot_p => izn_osnovice_ppot_l,
    pkakar_id_p => pkakar_id_p, -- IRN 2527; IRN 2548
    gost_id_p => NULL,
    age_id_p => NULL,
    pkaadr_id_p => NULL,
    izn_popusta_p => rnpro_row_l.iznos_popust, -- IRN 2766
    pkarnk_id_p => pkarnk_id_l);

  pra_pos_pka.insert_porez (
    zmpojr_id_p => rn_row_l.oj_id,
    pkarnk_id_p => pkarnk_id_l,
    izn_osnovice_p => izn_osnovice_l,
    stopa_pdv_p => rnpro_row_l.pdv,
    vpispz_id_p => rnpro_row_l.vpispz_id,
    izn_pdv_p => rnpro_row_l.iznos_pdv);

  pra_pos_pka.insert_pkarnkisp (
    zmpojr_id_p => rn_row_l.oj_id,
    pkarnk_id_p => pkarnk_id_l,
    sifra_p => pro_sifra_l,
    naziv_p => pro_naziv_l,
    jm_p => pro_jm_l,
    kolicina_p => rnpro_row_l.kolicina,
    cijena_p => rnpro_row_l.cijena,
    stopa_popusta_p => 0,
    vpispz_id_p => rnpro_row_l.vpispz_id,
    stopa_pdv_p => rnpro_row_l.pdv,
    izn_ppot_p => rnpro_row_l.iznos_ppot,
    izn_pdv_p => rnpro_row_l.iznos_pdv,
    kpd_sifra_p => kpd_sifra_l);

  <<kraj>> NULL;

  poruka_p := poruka_l;
  rbr_p    := rn_row_l.rbr;

EXCEPTION
  WHEN OTHERS THEN
    ROLLBACK;
    poruka_l := SQLERRM;
    IF INSTR (poruka_l, 'PKARNK_UK') <> 0 THEN
      -- Raun #0 za kasu #1 ve postoji u PKA!
      poruka_l := pra_zmp_zaj.poruka ('PKA', 'PKA0254', rn_row_l.rbr, gmpkas_sifra_l);
    END IF;
    poruka_p := poruka_l;
END;
PROCEDURE PONISTI_RACUN
 (RN_ID_P IN t_rnkase.id%TYPE
 ,OPIS_P IN t_rnkase.opis%TYPE
 )
 IS
/*
Procedura nema COMMIT pa njen pozivatelj mora imati vlastiti COMMIT.
Proceduru koristi modul REC2350.fmb - Rauni sa minibara.
*/

  br_redaka_l  NUMBER;
  rn_row_l     t_rnkase%ROWTYPE;
  godina_izv_l t_rnkase.godina%TYPE; -- IRN 2843
  rbr_izv_l    t_rnkase.rbr%TYPE;    -- IRN 2843
  rnpro_row_l  t_rnkase_pro%ROWTYPE;

  ozn_irn_l   s_vplacanja.ozn_irn%TYPE;

  izn_placanja_l      t_rnkase_pro.iznos%TYPE;
  izn_osnovice_l      t_rnkase_pro.iznos%TYPE;
  izn_ppot_l          t_rnkase_pro.iznos%TYPE;
  stopa_ppot_l        t_rnkase_pro.ppot%TYPE;
  izn_osnovice_ppot_l tpka_rnkasa.izn_osnovice_ppot%TYPE;

  zmpojr_id_l  m_so.ojr_id%TYPE;
  gostp_id_l   tpka_rnkasa.gost_id%TYPE;
  agep_id_l    tpka_rnkasa.age_id%TYPE;
  pkaadrp_id_l tpka_rnkasa.pkaadr_id%TYPE;
  gost_id_l    tpka_rnkasa.gost_id%TYPE;
  age_id_l     tpka_rnkasa.age_id%TYPE;
  pkaadr_id_l  tpka_rnkasa.pkaadr_id%TYPE;

  pkarnk_id_l tpka_rnkasa.id%TYPE;

  CURSOR vpla_cur IS
    SELECT ozn_irn
      FROM s_vplacanja
     WHERE id = rn_row_l.vpla_id;

  CURSOR racun_cur (rn_id_k NUMBER) IS
    SELECT rn.godina,rn.rbr,   -- IRN 3060
           SUM (rnpro.iznos) izn_placanja,
           SUM (rnpro.iznos - rnpro.iznos_pdv - rnpro.iznos_ppot) izn_osnovice,
           SUM (rnpro.iznos_ppot) izn_ppot,
           MAX (rnpro.ppot) AS stopa_ppot
      FROM t_rnkase rn,
           t_rnkase_pro rnpro
     WHERE rn.id = rn_id_k
       AND rn.id = rnpro.rn_id
     GROUP BY rn.godina,rn.rbr;

  CURSOR so_cur IS
    SELECT so.ojr_id
      FROM m_sj sj, m_so so
     WHERE sj.so_id = so.id
       AND sj.id = rn_row_l.sj_id;

  CURSOR pkarnk_cur IS
    SELECT gostp_id, agep_id, pkaadrp_id,
           gost_id, age_id, pkaadr_id
      FROM tpka_rnkasa
     WHERE god_poslovna_izvor = godina_izv_l  -- IRN 2843
       AND gmpkas_id_izvor = rn_row_l.kase_id
       AND rbr_izvor = rbr_izv_l;             -- IRN 2843
BEGIN
  IF rn_id_p IS NULL THEN
    RETURN;
  END IF;

  SELECT COUNT(id) INTO br_redaka_l FROM t_rnkase WHERE rn_id = rn_id_p;
  IF br_redaka_l > 0 THEN
    -- Nije doputeno ponitavanje rauna, raun je ve poniten.
    RAISE_APPLICATION_ERROR (-20421, pra_zmp_zaj.poruka ('GAS', '-20421'));
  END IF;

  SELECT * INTO rn_row_l FROM t_rnkase WHERE id = rn_id_p;
  godina_izv_l := rn_row_l.godina; -- IRN 2843
  rbr_izv_l := rn_row_l.rbr;       -- IRN 2843
  rn_row_l.id := gas_zaj.sekvenca (NULL);  -- IRN 2889
  -- godina
  -- kase_id
  rn_row_l.rbr := NULL;
  rn_row_l.datum := TRUNC (SYSDATE);
  -- kon_id
  -- nac_id
  -- vpla_id
  -- popust
  rn_row_l.opis := opis_p;
  rn_row_l.unos_korisnik :=  zmp_zaj.korisnik (-1);
  rn_row_l.unos_dat := SYSDATE;
  rn_row_l.izmjena_korisnik := NULL;
  rn_row_l.izmjena_dat := NULL;
  rn_row_l.vrijeme := TO_CHAR (SYSDATE, 'HH24MI');
  -- oj_id
  -- sj_id
  -- age_id
  rn_row_l.br_gostiju := rn_row_l.br_gostiju * -1;
  -- vpdog_id
  -- pkaadr_ozn
  rn_row_l.ozn_valjanosti := 'V';
  rn_row_l.rn_id := rn_id_p;
  rn_row_l.izn_placanja := rn_row_l.izn_placanja * -1; -- IRN 2872
  -- vpla2_id, izn_placanja2
  INSERT INTO t_rnkase VALUES rn_row_l;

  FOR rnpro_c IN (SELECT * FROM t_rnkase_pro WHERE rn_id = rn_id_p)
  LOOP
    rnpro_row_l := rnpro_c;
    rnpro_row_l.rn_id := rn_row_l.id;
    rnpro_row_l.id := gas_zaj.sekvenca (NULL);
    -- rbr_stavke
    -- pro_id
    -- sifgr_id
    -- gpor_id
    -- gknji_id,
    -- gtehpro_id
    -- mt_id
    rnpro_row_l.kolicina := rnpro_row_l.kolicina * -1;
    -- cijena
    -- pdv
    -- ppot
    -- zad_nab_cijena
    -- pros_nab_cijena
    rnpro_row_l.unos_korisnik := zmp_zaj.korisnik (-1);
    rnpro_row_l.unos_dat := SYSDATE;
    rnpro_row_l.izmjena_korisnik := NULL;
    rnpro_row_l.izmjena_dat := NULL;
    -- vpispz_id
    -- popust
    rnpro_row_l.iznos_popust := rnpro_row_l.iznos_popust * -1;
    rnpro_row_l.iznos_pdv := rnpro_row_l.iznos_pdv * -1;
    rnpro_row_l.iznos_ppot := rnpro_row_l.iznos_ppot * -1;
    rnpro_row_l.iznos := rnpro_row_l.iznos * -1;
    INSERT INTO t_rnkase_pro VALUES rnpro_row_l;
  END LOOP;

  OPEN vpla_cur;
  FETCH vpla_cur INTO ozn_irn_l;
  CLOSE vpla_cur;

  IF ozn_irn_l IS NULL THEN
    GOTO kraj; -- radi se o vrstama plaanja koje ne idu u PKA
  END IF;

  OPEN racun_cur (rn_row_l.id);  -- IRN 3060
  FETCH racun_cur INTO rn_row_l.godina,rn_row_l.rbr, izn_placanja_l, izn_osnovice_l, izn_ppot_l, stopa_ppot_l;
  CLOSE racun_cur;

  IF stopa_ppot_l = 0 THEN
    izn_osnovice_ppot_l := 0;
  ELSE
    izn_osnovice_ppot_l := izn_osnovice_l;
  END IF;

  OPEN so_cur;
  FETCH so_cur INTO zmpojr_id_l;
  CLOSE so_cur;

  OPEN pkarnk_cur;
  FETCH pkarnk_cur INTO gostp_id_l, agep_id_l, pkaadrp_id_l, gost_id_l, age_id_l, pkaadr_id_l;
  CLOSE pkarnk_cur;

  pra_pos_pka.insert_racun (
    zmpojr_id_p => zmpojr_id_l,
    gmpkas_id_p => rn_row_l.kase_id,
    vpla_id_p => rn_row_l.vpla_id,
    gostp_id_p => gostp_id_l,
    agep_id_p => agep_id_l,
    pkaadrp_id_p => pkaadrp_id_l,
    god_poslovna_p => rn_row_l.godina,
    rbr_p => rn_row_l.rbr,
    datum_p => rn_row_l.datum,
    izn_placanja_p => izn_placanja_l,
    izn_ppot_p => izn_ppot_l,
    opis1_p => NULL,
    opis2_p => NULL,
    recara_id_p => NULL,
    vpdog_id_p => NULL,
    nac_id_p => rn_row_l.nac_id,
    stopa_ppot_p => stopa_ppot_l,
    izn_osnovice_ppot_p => izn_osnovice_ppot_l,
    pkakar_id_p => NULL, -- IRN 2527
    gost_id_p => gost_id_l,
    age_id_p => age_id_l,
    pkaadr_id_p => pkaadr_id_l,
    izn_popusta_p => rnpro_row_l.iznos_popust, -- IRN 2766
    god_poslovna_izv_p => godina_izv_l, -- IRN 2843
    rbr_izv_p => rbr_izv_l,             -- IRN 2843
    pkarnk_id_p => pkarnk_id_l);

  FOR pdv_c IN (
    SELECT pdv AS stopa_pdv,
           vpispz_id,
           SUM (iznos - iznos_pdv - iznos_ppot) AS izn_osnovice,
           SUM (iznos_pdv) AS izn_pdv
      FROM t_rnkase_pro
     WHERE rn_id = rn_row_l.id
     GROUP BY pdv, vpispz_id)
  LOOP
    pra_pos_pka.insert_porez (
      zmpojr_id_p => zmpojr_id_l,
      pkarnk_id_p => pkarnk_id_l,
      izn_osnovice_p => pdv_c.izn_osnovice,
      stopa_pdv_p => pdv_c.stopa_pdv,
      vpispz_id_p => pdv_c.vpispz_id,
      izn_pdv_p => pdv_c.izn_pdv);
  END LOOP;

  FOR isp_c IN (
    SELECT pro.sifra pro_sifra, pro.naziv pro_naziv, pro.jm pro_jm,
           rnpro.kolicina, rnpro.cijena, rnpro.popust, rnpro.vpispz_id,
           rnpro.pdv, rnpro.iznos_ppot, rnpro.iznos_pdv, kpd.sifra kpd_sifra
      FROM t_rnkase_pro rnpro, m_proizvodi pro, s_kpd kpd
     WHERE rnpro.rn_id = rn_row_l.id
       AND rnpro.pro_id = pro.id
       AND kpd.id(+) = pro.kpd_id)
  LOOP
    pra_pos_pka.insert_pkarnkisp (
      zmpojr_id_p => zmpojr_id_l,
      pkarnk_id_p => pkarnk_id_l,
      sifra_p => isp_c.pro_sifra,
      naziv_p => isp_c.pro_naziv,
      jm_p => isp_c.pro_jm,
      kolicina_p => isp_c.kolicina,
      cijena_p => isp_c.cijena,
      stopa_popusta_p => isp_c.popust,
      vpispz_id_p => isp_c.vpispz_id,
      stopa_pdv_p => isp_c.pdv,
      izn_ppot_p => isp_c.iznos_ppot,
      izn_pdv_p => isp_c.iznos_pdv,
      kpd_sifra_p => isp_c.kpd_sifra);
  END LOOP;

  <<kraj>> NULL;
END;
FUNCTION UPIS_RACUNA_WELL
 (REZ_ID_P IN twel_rezervacije.id%TYPE
 )
 RETURN VARCHAR2
 IS
/*
Funkciju koristi MISH Wellness
*/
  poruka_l VARCHAR2(500);
  rbr_l    tpka_rnkasa.rbr%TYPE;

  CURSOR welrez_c IS
    SELECT gost_id, pro_id, kolicina, nac_id,
           cijena, pkaadr_id, stopa_popusta, dat_tretmana
      FROM twel_rezervacije
     WHERE id = rez_id_p;
  welrez_c_l welrez_c%ROWTYPE;

  CURSOR kase_c IS
    SELECT gmpkas.id
      FROM mgmp_kase gmpkas,
           sgas_vlasnik gasvla
     WHERE gmpkas.ozn_kase = 'W'
       AND pra_zmp.oj_pripada_oj (gmpkas.zmpojr_id, gasvla.oj_id) = -1
       AND welrez_c_l.dat_tretmana BETWEEN gmpkas.dat_valjan AND (NVL (gmpkas.dat_ponisten, TO_DATE ('31.12.9999', 'DD.MM.RRRR')) - 1)
     ORDER BY gmpkas.sifra;
  kase_id_l mgmp_kase.id%TYPE;

  CURSOR nac_c IS
    SELECT ozn_obracuna_poreza
      FROM m_nacpot
     WHERE id = welrez_c_l.nac_id;
  ozn_obracuna_poreza_l m_nacpot.ozn_obracuna_poreza%TYPE;

  sj_id_l m_sj.id%TYPE;
BEGIN
  poruka_l := 'OK';

  IF rez_id_p IS NULL THEN
    -- Nedostaje obvezan ulazni parametar (#0).
    poruka_l := pra_zmp_zaj.poruka ('PKA', '-20202', 'rez_id_p');
    RETURN poruka_l;
  END IF;

  OPEN welrez_c;
  FETCH welrez_c INTO welrez_c_l;
  CLOSE welrez_c;

  OPEN kase_c;
  FETCH kase_c INTO kase_id_l;
  CLOSE kase_c;
  IF kase_id_l IS NULL THEN
    -- Nije mogue proknjiiti raun jer kasa vrste Wellness ne postoji!
    poruka_l := pra_zmp_zaj.poruka ('GAS', '-20426');
    RETURN poruka_l;
  END IF;

  OPEN nac_c;
  FETCH nac_c INTO ozn_obracuna_poreza_l;
  CLOSE nac_c;

  IF ozn_obracuna_poreza_l = 'D' AND welrez_c_l.pkaadr_id IS NULL THEN
    IF welrez_c_l.gost_id IS NOT NULL THEN
      SELECT sj_id INTO sj_id_l
        FROM t_gosti
       WHERE id = welrez_c_l.gost_id;
    END IF;
  ELSE
    welrez_c_l.gost_id := NULL;
  END IF;

  upisi_racun (
    welrez_c_l.dat_tretmana,
    sj_id_l,
    welrez_c_l.pro_id,
    welrez_c_l.kolicina,
    ROUND (NVL (welrez_c_l.cijena, 0) * (100 - NVL (welrez_c_l.stopa_popusta, 0)) / 100, 2), -- IRN 2548; dodan ROUND
    welrez_c_l.gost_id,
    kase_id_l,
    welrez_c_l.nac_id,
    welrez_c_l.pkaadr_id,
    NULL, -- IRN 2548; age_id_p
    NULL, -- IRN 2548; pkakar_id_p
    poruka_l,
    rbr_l);

  IF poruka_l = 'OK' AND rbr_l IS NOT NULL THEN
    UPDATE twel_rezervacije
       SET gmpkas_id = kase_id_l,
           gmpkas_rbr = rbr_l,
           gmpkas_godina = TO_CHAR (welrez_c_l.dat_tretmana, 'RRRR')
     WHERE id = rez_id_p;
    COMMIT;
  END IF;

  RETURN (poruka_l);

EXCEPTION
  WHEN OTHERS THEN
    ROLLBACK;
    poruka_l := SQLERRM;
    RETURN (poruka_l);
END;
FUNCTION DATUM_ZADNJEG_DO
 RETURN DATE
 IS
BEGIN
  RETURN (bm_gas3010.dat_zadnjeg_do);
END;
FUNCTION POSTOJI_KASA_WELL
 RETURN NUMBER
 IS
/*
Funkciju koristi MISH Wellness
*/
  ozn_postoji_l NUMBER := -1;
BEGIN

  SELECT DECODE (COUNT (mgmp_kase.id), 0, 0, -1) INTO ozn_postoji_l
    FROM mgmp_kase,
         sgas_vlasnik
   WHERE mgmp_kase.ozn_kase = 'W'
     AND pra_zmp.oj_pripada_oj (mgmp_kase.zmpojr_id, sgas_vlasnik.oj_id) = -1
     AND TRUNC (SYSDATE) BETWEEN mgmp_kase.dat_valjan AND (NVL (mgmp_kase.dat_ponisten, TO_DATE ('31.12.9999', 'DD.MM.RRRR')) - 1);

  RETURN (ozn_postoji_l);

END;
FUNCTION UPIS_RACUNA_PTV
 (PTVSUS_SIFRA_P IN mptv_sustavi.sifra%TYPE
 ,PTVTV_SIFRA_P IN mptv_tv.sifra%TYPE
 ,SIF_ARTIKLA_P IN m_proizvodi.sif_proizvoda_kasa%TYPE
 ,KOLICINA_P IN t_rnkase_pro.kolicina%TYPE
 ,DATUM_P IN t_rnkase.datum%TYPE
 )
 RETURN VARCHAR2
 IS
/*
Funkciju koristi Pay-TV servis.

Minibar posting (PTM) to Room (RN) 2781, guest consumption: article (MA) 1450 2 (M#)
times on 15 September 2000 (DA) at 12:42:54 (TI), sequence number (P#) 0733:
PS|RN2781|PTM|MA1450|M#2|DA000915|TI124254|P#1733|
*/
  poruka_l VARCHAR2(500);
  rbr_l tpka_rnkasa.rbr%TYPE;
  sj_id_l m_sj.id%TYPE;
  pro_id_l m_proizvodi.id%TYPE;
  gmpkas_id_l mgmp_kase.id%TYPE;
  cijena_l m_aso_kase.pc%TYPE;
  nac_id_l m_aso_kase.nac_id%TYPE;

  CURSOR gmpkas_c IS
    SELECT gmpkas.id
      FROM m_sj sj,
           m_so so,
           mgmp_kase gmpkas
     WHERE sj.id = sj_id_l
       AND sj.so_id = so.id
       AND gmpkas.metapl_sifra = 'GAS'
       AND gmpkas.ozn_kase = 'M'
       AND gmpkas.zmpojr_id = so.ojr_id
       AND TRUNC (datum_p) BETWEEN gmpkas.dat_valjan AND (NVL (gmpkas.dat_ponisten, TO_DATE ('31.12.9999', 'DD.MM.RRRR')) - 1)
     ORDER BY gmpkas.sifra;

  CURSOR asokase_c IS
    SELECT asokase.pc, asokase.nac_id
      FROM m_aso_kase asokase,
           m_nac_vpla nacvpla,
           s_vplacanja vpla,
           m_nacpot nac
     WHERE asokase.kase_id = gmpkas_id_l
       AND asokase.pro_id = pro_id_l
       AND asokase.nac_id = nacvpla.nac_id
       AND nacvpla.nac_id = nac.id
       AND nacvpla.vpla_id = vpla.id
       AND vpla.ozn_irn = '1'
     ORDER BY vpla.sifra, nac.sifra;
BEGIN

  -- Nedostaje obvezan ulazni parametar (#0).
  IF ptvsus_sifra_p IS NULL THEN
    RAISE_APPLICATION_ERROR (-20202, pra_zmp_zaj.poruka ('PKA', '-20202', 'ptvsus_sifra_p'));
  ELSIF ptvtv_sifra_p IS NULL THEN
    RAISE_APPLICATION_ERROR (-20202, pra_zmp_zaj.poruka ('PKA', '-20202', 'ptvtv_sifra_p')); -- RN
  ELSIF sif_artikla_p IS NULL THEN
    RAISE_APPLICATION_ERROR (-20202, pra_zmp_zaj.poruka ('PKA', '-20202', 'sif_artikla_p')); -- MA
  ELSIF kolicina_p IS NULL THEN
    RAISE_APPLICATION_ERROR (-20202, pra_zmp_zaj.poruka ('PKA', '-20202', 'kolicina_p'));    -- M#
  ELSIF datum_p IS NULL THEN
    RAISE_APPLICATION_ERROR (-20202, pra_zmp_zaj.poruka ('PKA', '-20202', 'datum_p'));       -- DA
  END IF;

  SELECT MIN (mptv_tv.sj_id) INTO sj_id_l
    FROM mptv_tv, mptv_sustavi
   WHERE mptv_sustavi.sifra = ptvsus_sifra_p
     AND mptv_tv.sifra = ptvtv_sifra_p
     AND mptv_tv.ptvsus_id = mptv_sustavi.id;
  IF sj_id_l IS NULL THEN
    -- Nedostaje podatak (#0)!
    RAISE_APPLICATION_ERROR (-20098, pra_zmp_zaj.poruka ('ZMP', '-20098', pra_zmp_zaj.poruka ('REC', 'REC_SJ')));
  END IF;

  SELECT MIN (id) INTO pro_id_l FROM m_proizvodi WHERE sif_proizvoda_kasa = sif_artikla_p;
  IF pro_id_l IS NULL THEN
    -- Nedostaje podatak (#0)!
    RAISE_APPLICATION_ERROR (-20098, pra_zmp_zaj.poruka ('ZMP', '-20098', pra_zmp_zaj.poruka ('GAS', 'GAS_PRO')));
  END IF;

  OPEN gmpkas_c;
  FETCH gmpkas_c INTO gmpkas_id_l;
  CLOSE gmpkas_c;
  IF gmpkas_id_l IS NULL THEN
    -- Ne postoji kasa vrste Minibar.
    RAISE_APPLICATION_ERROR (-20001, pra_zmp_zaj.poruka ('GAS', 'GAS0632'));
  END IF;

  OPEN asokase_c;
  FETCH asokase_c INTO cijena_l, nac_id_l;
  CLOSE asokase_c;
  IF cijena_l IS NULL OR nac_id_l IS NULL THEN
    -- Nedostaje podatak (#0)!
    RAISE_APPLICATION_ERROR (-20098, pra_zmp_zaj.poruka ('ZMP', '-20098', pra_zmp_zaj.poruka ('GAS', 'GAS_ASOKASE')));
  END IF;

  poruka_l := 'OK';

  upisi_racun (
    datum_p => datum_p,
    sj_id_p => sj_id_l,
    pro_id_p => pro_id_l,
    kolicina_p => kolicina_p,
    cijena_p => cijena_l,
    gost_id_p => NULL,
    kase_id_p => gmpkas_id_l,
    nac_id_p => nac_id_l,
    pkaadr_id_p => NULL,
    age_id_p => NULL,    -- IRN 2548
    pkakar_id_p => NULL, -- IRN 2548
    poruka_p => poruka_l,
    rbr_p => rbr_l);

  IF poruka_l = 'OK' AND rbr_l IS NOT NULL THEN
    COMMIT;
  ELSIF poruka_l = 'OK' AND rbr_l IS NULL THEN
    ROLLBACK;
    poruka_l := 'ERROR';
  ELSIF NVL (poruka_l, '') <> 'OK' THEN
    ROLLBACK;
  END IF;

  RETURN (poruka_l);
EXCEPTION
  WHEN OTHERS THEN
    ROLLBACK;
    poruka_l := SQLERRM;
    -- Neuspjelo spremanje rauna sa minibara
    bm_rec6030.ptv_insert_ptvpog ('0020', poruka_l);
    RETURN (poruka_l);
END;
PROCEDURE UPISI_PREPAID_UPLATU
 (PKAKAR_ID_P IN tpka_kartice.id%TYPE
 ,ZMPOJR_ID_P IN tpka_kartice.zmpojr_id%TYPE
 ,DATUM_P IN t_rnkase.datum%TYPE
 ,IZNOS_P IN t_rnkase_pro.cijena%TYPE
 ,PKAADR_ID_P IN mpka_adrese.id%TYPE
 ,AGE_ID_P IN m_agencije.id%TYPE
 ,PORUKA_P IN OUT VARCHAR2
 ,RBR_P OUT t_rnkase.rbr%TYPE
 )
 IS
/*
IRN 2548; Proceduru koristi modul PKA2130.fmb - Pay Card.
*/
  pro_id_l m_proizvodi.id%TYPE;

  CURSOR asokase_c IS
    SELECT gmpkas.id AS gmpkas_id, asokase.nac_id AS nac_id
      FROM m_aso_kase asokase,
           mgmp_kase gmpkas,
           m_nac_vpla nacvpla,
           s_vplacanja vpla,
           m_nacpot nac
     WHERE asokase.kase_id = gmpkas.id
       AND gmpkas.metapl_sifra = 'GAS'
       AND gmpkas.zmpojr_id = zmpojr_id_p
       AND TRUNC (datum_p) BETWEEN gmpkas.dat_valjan AND (NVL (gmpkas.dat_ponisten, TO_DATE ('31.12.9999', 'DD.MM.RRRR')) - 1)
       AND asokase.pro_id = pro_id_l
       AND asokase.nac_id = nacvpla.nac_id
       AND nacvpla.nac_id = nac.id
       AND nacvpla.vpla_id = vpla.id
       AND (  (vpla.ozn_irn = '3' AND pkaadr_id_p IS NOT NULL)
           OR (vpla.ozn_irn = '2' AND age_id_p IS NOT NULL))
     ORDER BY gmpkas.sifra, vpla.sifra, nac.sifra;

  asokase_c_l asokase_c%ROWTYPE;

  -- OUT upisi_racun
  poruka_l VARCHAR2(500);
  rbr_l tpka_rnkasa.rbr%TYPE;

  -- OUT pra_pos_pkakar.puni_pkakarrnk
  zmpojr_id_l tpka_kartice.zmpojr_id%TYPE;
  so_id_l m_so.id%TYPE;
  pkakarrnk_id_l tpka_kar_rnk.id%TYPE; -- IRN 2781
BEGIN

  -- Nedostaje obvezan ulazni parametar (#0).
  IF pkakar_id_p IS NULL THEN
    RAISE_APPLICATION_ERROR (-20202, pra_zmp_zaj.poruka ('PKA', '-20202', 'pkakar_id_p'));
  ELSIF zmpojr_id_p IS NULL THEN
    RAISE_APPLICATION_ERROR (-20202, pra_zmp_zaj.poruka ('PKA', '-20202', 'zmpojr_id_p'));
  ELSIF datum_p IS NULL THEN
    RAISE_APPLICATION_ERROR (-20202, pra_zmp_zaj.poruka ('PKA', '-20202', 'datum_p'));
  ELSIF iznos_p IS NULL THEN
    RAISE_APPLICATION_ERROR (-20202, pra_zmp_zaj.poruka ('PKA', '-20202', 'iznos_p'));
  ELSIF pkaadr_id_p IS NULL AND age_id_p IS NULL THEN
    RAISE_APPLICATION_ERROR (-20202, pra_zmp_zaj.poruka ('PKA', '-20202', 'pkaadr_id_p, age_id_p'));
  ELSIF pkaadr_id_p IS NOT NULL AND age_id_p IS NOT NULL THEN
    -- Pogrena vrijednost ulaznog parametra (#0)!
    RAISE_APPLICATION_ERROR (-20099, pra_zmp_zaj.poruka ('ZMP', '-20099', 'pkaadr_id_p, age_id_p'));
  END IF;

  SELECT MIN (id) INTO pro_id_l FROM m_proizvodi WHERE ozn_proizvoda = 3; -- Prepaid uplata
  IF pro_id_l IS NULL THEN
    -- Nedostaje podatak (#0)!
    RAISE_APPLICATION_ERROR (-20098, pra_zmp_zaj.poruka ('ZMP', '-20098', pra_zmp_zaj.poruka ('GAS', 'GAS_PRO')));
  END IF;

  OPEN asokase_c;
  FETCH asokase_c INTO asokase_c_l;
  CLOSE asokase_c;
  IF asokase_c_l.gmpkas_id IS NULL OR asokase_c_l.nac_id IS NULL THEN
    -- Nedostaje podatak (#0)!
    RAISE_APPLICATION_ERROR (-20098, pra_zmp_zaj.poruka ('ZMP', '-20098', pra_zmp_zaj.poruka ('GAS', 'GAS_ASOKASE')));
  END IF;

  poruka_l := 'OK';

  upisi_racun (
    datum_p => datum_p,
    sj_id_p => NULL,
    pro_id_p => pro_id_l,
    kolicina_p => 1,
    cijena_p => iznos_p,
    gost_id_p => NULL,
    kase_id_p => asokase_c_l.gmpkas_id,
    nac_id_p => asokase_c_l.nac_id,
    pkaadr_id_p => pkaadr_id_p,
    age_id_p => age_id_p,
    pkakar_id_p => pkakar_id_p,
    poruka_p => poruka_l,
    rbr_p => rbr_l);

  IF poruka_l = 'OK' AND rbr_l IS NOT NULL THEN

    /*
    Auriraj oznaku valjanosti za potrebe prijepisa rauna u Operu (vidi OPERA_POSM.SALJI_RACUNE).
    GAS parametar 1004 -> Vanjski sustavi (nebitno, 1 = Opera, 2 = Gartner, 3 = Protel)
    */
    IF pra_zmp_zaj.zmppar_vrijednost ('GAS', '1004') = '1' THEN
      UPDATE t_rnkase
         SET ozn_valjanosti = 'P'
       WHERE godina = TO_CHAR (datum_p, 'RRRR')
         AND kase_id = asokase_c_l.gmpkas_id
         AND rbr = rbr_l;
    END IF;

    pra_pos_pkakar.puni_pkakarrnk (
      pkakar_id_p => pkakar_id_p,
      metcvor_sifra_p => pra_zmp_zaj.tekuci_cvor,
      pkakar_pin4_p => NULL, -- doputeno je poslati NULL kod uplate
      gmpkas_id_p => asokase_c_l.gmpkas_id,
      god_poslovna_p => TO_CHAR (datum_p, 'RRRR'),
      rbr_p => rbr_l,
      datum_p => datum_p,
      iznos_p => iznos_p,
      oznaka_p => 1, -- uplata
      zmpojr_id_p => zmpojr_id_l,
      so_id_p => so_id_l,
      nac_id_p => asokase_c_l.nac_id,    -- IRN 2766
      izn_rnk_p => 0,                    -- IRN 2766
      izn_popusta_p => 0,                -- IRN 2766
      pkakarrnk_id_p => pkakarrnk_id_l); -- IRN 2781
    COMMIT;
  ELSE
    ROLLBACK;
  END IF;

  poruka_p := poruka_l;
  rbr_p    := rbr_l;

EXCEPTION
  WHEN OTHERS THEN
    ROLLBACK;
    poruka_l := SQLERRM;
    poruka_p := poruka_l;
END;
PROCEDURE UPISI_RACUN_DOM
 (DATUM_P IN t_rnkase.datum%TYPE
 ,SO_SIFRA_P IN M_SO.SIFRA%TYPE
 ,SJ_BROJ_P IN M_SJ.BROJ%TYPE
 ,PRO_ID_P IN m_proizvodi.id%TYPE
 ,KOLICINA_P IN t_rnkase_pro.kolicina%TYPE
 ,PORUKA_P IN OUT VARCHAR2
 )
 IS
--
  CURSOR sj_cur IS
    SELECT sj.id, so.metcvor_sifra
      FROM m_sj sj,
           m_so so
     WHERE so.id = sj.so_id
       AND so.sifra = so_sifra_p
       AND sj.broj = sj_broj_p;

  CURSOR kase_cur IS
    SELECT kase_id,
           nac_id,
           pc
      FROM v_dom_aso_kase
     WHERE so_sifra = so_sifra_p
       AND pro_id = pro_id_p;

  sj_id_l   m_sj.id%TYPE;
  metcvor_sifra_l m_so.metcvor_sifra%TYPE;

  kase_id_l m_kase.id%TYPE;
  nac_id_l  m_nacpot.id%TYPE;
  cijena_l  m_aso_kase.pc%TYPE;

  poruka_l  VARCHAR2(500);
  rbr_l     t_rnkase.rbr%TYPE;
  naredba_l VARCHAR2 (3000);
BEGIN
   OPEN sj_cur;
  FETCH sj_cur INTO sj_id_l, metcvor_sifra_l;
  CLOSE sj_cur;

   OPEN kase_cur;
  FETCH kase_cur INTO kase_id_l, nac_id_l, cijena_l;
  CLOSE kase_cur;

  IF metcvor_sifra_l = pra_zmp_zaj.tekuci_cvor THEN
    BEGIN
      upisi_racun (
        datum_p => datum_p,
        sj_id_p => sj_id_l,
        pro_id_p => pro_id_p,
        kolicina_p => kolicina_p,
        cijena_p => kolicina_p * cijena_l,
        gost_id_p => NULL,
        kase_id_p => kase_id_l,
        nac_id_p => nac_id_l,
        pkaadr_id_p => NULL,
        age_id_p => NULL,
        pkakar_id_p => NULL,
        poruka_p => poruka_l,
        rbr_p => rbr_l);

      poruka_p := poruka_l;
    EXCEPTION
      WHEN OTHERS THEN
        ROLLBACK;
        poruka_l := SQLERRM;
        poruka_p := poruka_l;
     END;
   ELSE
     naredba_l :=
       'BEGIN ' ||
       '  pra_gas_pka.upisi_racun@' || metcvor_sifra_l || ' (' ||
       '    :datum_p, :sj_id_l, :pro_id_p, :kolicina_p, (:kolicina_p * :cijena_l), NULL, :kase_id_l, :nac_id_l, NULL, NULL, NULL, :poruka_l, :rbr_l); ' ||
       'END;';

     EXECUTE IMMEDIATE naredba_l USING datum_p, sj_id_l, pro_id_p, kolicina_p, cijena_l, kase_id_l, nac_id_l, IN OUT poruka_l, OUT rbr_l;
     poruka_p :=  poruka_l;
  END IF;
END;
PROCEDURE PONISTI_RACUN_DOM
 (RN_ID_P IN t_rnkase.id%TYPE
 ,OPIS_P IN t_rnkase.opis%TYPE
 )
 IS
--
  CURSOR cvor_cur IS
    SELECT so.metcvor_sifra
      FROM m_so so,
           v_dom_racuni rn
     WHERE rn.id = rn_id_p
       AND rn.so_sifra = so.sifra;

  metcvor_sifra_l m_so.metcvor_sifra%TYPE;
  naredba_l VARCHAR2 (3000);
BEGIN

   OPEN cvor_cur;
  FETCH cvor_cur INTO metcvor_sifra_l;
  CLOSE cvor_cur;

  IF metcvor_sifra_l = pra_zmp_zaj.tekuci_cvor THEN
    ponisti_racun (
      rn_id_p => rn_id_p,
      opis_p => opis_p);
  ELSE
    naredba_l :=
      'BEGIN ' ||
      '  pra_gas_pka.ponisti_racun@' || metcvor_sifra_l || ' (' ||
      '    :rn_id_p, :opis_p); ' ||
      'END;';
    EXECUTE IMMEDIATE naredba_l USING rn_id_p, opis_p;
  END IF;
END;

END PRA_GAS_PKA;
/
SHOW ERROR

