-- D:\mish_CVS\misH_skripte\pra_gas_api.pkb
--
-- Generated for Oracle 10g on Wed Jun 11  14:22:05 2025 by Server Generator 6.5.96.5.6
 

PROMPT Creating Package Body 'PRA_GAS_API'
CREATE OR REPLACE PACKAGE BODY PRA_GAS_API IS

FUNCTION R_MT
 RETURN SYS_REFCURSOR
 IS

		l_rc SYS_REFCURSOR;
BEGIN  
  OPEN l_rc FOR
	SELECT t.sifra AS code,
  		   t.naziv AS NAME
   	  FROM m_mt t;
  RETURN l_rc;
END;
FUNCTION R_NAC_POT
 RETURN SYS_REFCURSOR
 IS

		l_rc SYS_REFCURSOR;
BEGIN
 OPEN l_rc FOR
   SELECT t.id          AS id,
  		  t.sifra       AS sifra,
  		  t.naziv       AS naziv,
		  t.gpor_id     AS gpor_id,
		  t.gnac_id     AS gnac_id,
		  t.izmjena_dat AS izmjena_dat
     FROM m_nacpot t;
	RETURN l_rc;
END;
FUNCTION R_SIFGR
 RETURN SYS_REFCURSOR
 IS

		l_rc SYS_REFCURSOR;
BEGIN
  OPEN l_rc FOR
	SELECT t.id                 AS id,
		   t.sif_proizvoda_kasa AS sifra,
		   t.naziv              AS naziv,
		   t.gtehpro_id         AS gtehpro_id,
		   t.gpor_id            AS gpor_id,
		   t.gknji_id           AS gknji_id,
		   t.izmjena_dat        AS izmjena_dat
 	 FROM m_sif_grupa t;
    RETURN l_rc;
END;
FUNCTION R_ARTIKLI
 RETURN SYS_REFCURSOR
 IS

		l_rc SYS_REFCURSOR;
BEGIN
    IF pra_zmp_s.oznaka ('P0030') = 0 THEN
      -- Nedopusten pristup!
      pra_zmp_zaj.vrati_poruku (-20138);
    END IF;
    IF lower(pra_zmp_zaj.zmppar_vrijednost('GAS','1027')) = 'nebitno'
    THEN
      raise_application_error(-20101,'Parametar za prepis artikla je postavljen na nebitno');
    ELSE
      OPEN l_rc FOR
       SELECT s.sifra       AS code,
              s.naziv         AS name,
              s.ean_kod       AS ean,
              s.jm            AS measurement_unit,
              s.odnos_jm_b    AS measurement_unit_ratio,
              s.jm_dobavljaca AS supp_measurement_unit,
              s.odnos_jm_n    AS supp_measurement_unit_ratio,
              s.izmjena_dat   AS modified_date
         FROM m_sirovine s
        WHERE upper(pra_zmp_zaj.zmppar_vrijednost('GAS','1027')) IN ('S','SN','SP', 'SNP')
          AND trunc(SYSDATE) BETWEEN s.dat_valjan AND NVL (s.dat_ponisten,trunc(SYSDATE))
       UNION ALL
       SELECT n.sifra AS code,
              n.naziv   AS name,
              NULL      AS ean,
              n.jm      AS measurement_unit,
              1         AS measurement_unit_ratio,
              n.jm      AS supp_measurement_unit,
              1         AS supp_measurement_unit_ratio,
              n.izmjena_dat AS modified_date
         FROM m_namirnice n
        WHERE upper(pra_zmp_zaj.zmppar_vrijednost('GAS','1027')) IN ('N','SN','NP','SNP')
          AND trunc(SYSDATE) BETWEEN n.dat_valjan AND NVL (n.dat_ponisten,trunc(SYSDATE))
       UNION ALL
       SELECT p.sifra   AS code,
              p.naziv   AS name,
              p.ean_kod AS ean,
              p.jm      AS measurement_unit,
              1         AS measurement_unit_ratio,
              p.jm      AS supp_measurement_unit,
              1         AS supp_measurement_unit_ratio,
              p.izmjena_dat AS modified_date
         FROM m_proizvodi p
        WHERE upper(pra_zmp_zaj.zmppar_vrijednost('GAS','1027')) IN ('P','SP','NP', 'SNP')
          AND trunc(SYSDATE) BETWEEN p.dat_valjan AND NVL (p.dat_ponisten,trunc(SYSDATE));
    END IF;
    RETURN l_rc;
END;
FUNCTION R_ARTIKLI_MT
 (MT_P IN m_mt.sifra%TYPE
 )
 RETURN SYS_REFCURSOR
 IS

  l_rc SYS_REFCURSOR;
BEGIN     
    /* Za ankove i trgovau robu ==> Massec */
    
    IF pra_zmp_s.oznaka ('P0053') = 0 THEN
      -- Nedopusten pristup!
      pra_zmp_zaj.vrati_poruku (-20138);
    END IF;
    
    OPEN l_rc FOR
     SELECT s.sifra       AS code,
            s.naziv         AS name,
            s.ean_kod       AS ean,
            s.jm            AS measurement_unit,
            s.odnos_jm_b    AS measurement_unit_ratio,
            s.jm_dobavljaca AS supp_measurement_unit,
            s.odnos_jm_n    AS supp_measurement_unit_ratio,
            s.izmjena_dat   AS modified_date
       FROM m_sirovine s
      WHERE trunc(SYSDATE) BETWEEN s.dat_valjan AND NVL (s.dat_ponisten,trunc(SYSDATE))
        AND EXISTS( SELECT NULL 
                      FROM p_mt_art mta, m_mt mt 
                     WHERE mta.art_id = s.id 
                       AND mt.id = mta.mt_id
                       AND mt.sifra = nvl(MT_P,mt.sifra)
                       AND pra_zmp_s.oznaka1 ('P0053',mt.sifra) = -1)
           
     UNION ALL
     SELECT n.sifra AS code,
            n.naziv   AS name,
            NULL      AS ean,
            n.jm      AS measurement_unit,
            1         AS measurement_unit_ratio,
            n.jm      AS supp_measurement_unit,
            1         AS supp_measurement_unit_ratio,
            n.izmjena_dat AS modified_date
       FROM m_namirnice n
      WHERE trunc(SYSDATE) BETWEEN n.dat_valjan AND NVL (n.dat_ponisten,trunc(SYSDATE))
        AND EXISTS( SELECT NULL 
                      FROM p_mt_art mta, m_mt mt 
                     WHERE mta.art_id = n.id 
                       AND mt.id = mta.mt_id
                       AND mt.sifra = nvl(MT_P,mt.sifra)
                       AND pra_zmp_s.oznaka1 ('P0053',mt.sifra) = -1)
     UNION ALL
     SELECT p.sifra   AS code,
            p.naziv   AS name,
            p.ean_kod AS ean,
            p.jm      AS measurement_unit,
            1         AS measurement_unit_ratio,
            p.jm      AS supp_measurement_unit,
            1         AS supp_measurement_unit_ratio,
            p.izmjena_dat AS modified_date
       FROM m_proizvodi p
      WHERE trunc(SYSDATE) BETWEEN p.dat_valjan AND NVL (p.dat_ponisten,trunc(SYSDATE))
        AND EXISTS( SELECT NULL 
                      FROM p_mt_art mta, m_mt mt 
                     WHERE mta.art_id = p.id 
                       AND mt.id = mta.mt_id
                       AND mt.sifra = nvl(MT_P,mt.sifra)
                       AND pra_zmp_s.oznaka1 ('P0053',mt.sifra) = -1);
    RETURN l_rc;
END;
FUNCTION R_ZALIHA
 RETURN SYS_REFCURSOR
 IS

		l_rc SYS_REFCURSOR;
BEGIN 
   
  OPEN l_rc FOR
	SELECT mt.sifra     AS "organization_unit",
		   n.sifra      AS "item",
		   n.naziv      AS "name",
		   n.jm         AS "measurement_unit", 
		   round(zal.zaliha,2)          AS "quantity",
		   round(zal.zad_nab_cijena,2)  AS "last_price",
		   round(zal.pros_nab_cijena,2) AS "avg_price"
	  FROM i_zaliha    zal,
		   m_mt        mt,
		   m_namirnice n
	 WHERE mt.id = zal.mt_id
	   AND n.id = zal.nam_id
	   AND zaj_obr.vanjsko_mjesto_troska(zal.mt_id) <> -1
	   AND pra_zmp_s.oznaka1 ('P0031',mt.sifra) = -1;
	
	RETURN l_rc;
END;
FUNCTION R_STAVKE_RN
 (RN_ID_P IN t_rnkase.id%TYPE
 )
 RETURN SYS_REFCURSOR
 IS

  l_rc SYS_REFCURSOR;
BEGIN  
 /* Koristi Nybble */   
 OPEN l_RC FOR
 SELECT rnpro.rbr_stavke                          AS "redni_broj",
        NVL(pro.sifra, sifgr.sif_proizvoda_kasa)  AS "proizvod",
        rnpro.cijena                              AS "cijena",
        rnpro.kolicina                            AS "kolicina",
        rnpro.pdv                                 AS "pdv",
        rnpro.ppot                                AS "ppot",
        rnpro.iznos_pdv                           AS "iznos_pdv",
        rnpro.iznos_ppot                          AS "iznos_ppot",
        rnpro.iznos_popust                        AS "iznos_popust",
        rnpro.iznos                               AS "iznos", 
        rnpro.iznos_popust2                       AS "iznos_popust2"
   FROM t_rnkase_pro rnpro,
        m_proizvodi pro,
        m_sif_grupa sifgr
  WHERE rnpro.rn_id = rn_id_p
    AND rnpro.pro_id = pro.id (+)
    AND rnpro.sifgr_id = sifgr.id(+);
 RETURN l_rc;
END;
FUNCTION R_KASA_RBR
 (SIFRA_KASE_P IN MGMP_KASE.SIFRA%TYPE
 )
 RETURN SYS_REFCURSOR
 IS
	l_rc SYS_REFCURSOR;
BEGIN     
  IF sifra_kase_p IS NULL THEN
    -- Pogrena vrijednost ulaznog parametra (#0)!
    pra_zmp_zaj.vrati_poruku (-20099, 'sifra_kase_p');
  END IF;    
  
  OPEN l_rc FOR
    SELECT NVL(MAX(rbr),0)  AS zadnji_rbr,
           TO_CHAR(NVL(MAX(datum), TRUNC(SYSDATE - 1)), 'DDMMYYYY') AS datum_zadnjeg_racuna 
      FROM t_rnkase rn,
           mgmp_kase kase
     WHERE rn.kase_id = kase.id
       AND kase.sifra = sifra_kase_p
       AND godina  = TO_CHAR(SYSDATE, 'YYYY'); 
    
    RETURN l_rc;
END;
FUNCTION R_KASA_ASORTIMAN
 (SIFRA_KASE_P IN MGMP_KASE.SIFRA%TYPE
 )
 RETURN SYS_REFCURSOR
 IS
	l_rc SYS_REFCURSOR;
BEGIN    
  /* za PSM kase nije bilo potrebe za nestandardnim proizvodima, a nema ni kratkog naziva
  */    
  IF sifra_kase_p IS NULL THEN
    -- Pogrena vrijednost ulaznog parametra (#0)!
    pra_zmp_zaj.vrati_poruku (-20099, 'sifra_kase_p');
  END IF;    
  
  OPEN l_rc FOR
    SELECT pro.sifra      AS sifra,
           DECODE(kase.metapl_sifra,'PSM', pro.naz_kod, pro.naziv) AS naziv,    
           asokase.pc     AS cijena,  
           gpor.ppot      AS ppot,
           vpisz.stopa    AS pdv,
           mt.sifra       AS mjesto_troska,
           nac.sifra      AS cjenik, 
           pro.popust_max AS dozvoljeni_popust,    
           gtehpro.sifra  AS grupa_proizvoda      
      FROM m_aso_kase asokase,
           m_kase kase,
           m_proizvodi pro, 
           m_gtehpro gtehpro,
           m_gporez gpor, 
           m_nacpot nac,
           m_mt mt,   
           mgas_gpor_raz gporraz,
           s_vpisporukap vpisp,
           s_vpisporukaz vpisz,
           sgas_vlasnik vlasnik
     WHERE asokase.kase_id = kase.id
       AND kase.sifra = sifra_kase_p
       AND asokase.pro_id = pro.id 
       AND asokase.nac_id = nac.id
       AND asokase.mt_id = mt.id
       AND pro.gpor_id = gpor.id
       AND pro.gtehpro_id = gtehpro.id
       AND pro.gpor_id = gporraz.gpor_id 
       AND pro.ozn_proizvoda NOT IN ('3','4','5')
       AND SYSDATE BETWEEN gporraz.dat_valjan AND NVL(gporraz.dat_ponisten, SYSDATE)
       AND gporraz.vpispp_id = vpisp.id
       AND vpisp.vpispz_id = vpisz.id
       AND (vlasnik.oj_id IS NULL OR gas_zaj.podreden (asokase.mt_id, vlasnik.oj_id) = -1)  
     UNION ALL
    SELECT sifgr.sif_proizvoda_kasa  AS sifra,
           sifgr.naziv               AS naziv,  
           asokasegr.pc              AS cijena, 
           gpor.ppot                 AS ppot,
           vpisz.stopa               AS pdv,
           mt.sifra                  AS mjesto_troska,
           nac.sifra                 AS cjenik,
           0                         AS dozvoljeni_popust,   
           gtehpro.sifra             AS grupa_proizvoda         
      FROM m_aso_kase_grupe asokasegr,
           m_kase kase,
           m_sif_grupa sifgr,
           m_gtehpro gtehpro,
           m_gporez gpor,
           m_nacpot nac, 
           m_mt mt,
           mgas_gpor_raz gporraz,
           s_vpisporukap vpisp,
           s_vpisporukaz vpisz,
           sgas_vlasnik vlasnik
     WHERE asokasegr.kase_id = kase.id 
       AND kase.metapl_sifra <> 'PSM'   
       AND kase.sifra = sifra_kase_p
       AND asokasegr.sifgr_id = sifgr.id 
       AND asokasegr.nac_id = nac.id  
       AND asokasegr.mt_id = mt.id
       AND sifgr.gpor_id = gpor.id 
       AND sifgr.gtehpro_id = gtehpro.id
       AND sifgr.gpor_id = gporraz.gpor_id
       AND SYSDATE BETWEEN gporraz.dat_valjan AND NVL(gporraz.dat_ponisten, SYSDATE)
       AND gporraz.vpispp_id = vpisp.id
       AND vpisp.vpispz_id = vpisz.id
       AND (vlasnik.oj_id IS NULL OR gas_zaj.podreden (asokasegr.mt_id, vlasnik.oj_id) = -1)     
     ORDER BY 2;
   RETURN l_rc;
END;
FUNCTION R_KASA_KONOBARI
 (SIFRA_KASE_P IN MGMP_KASE.SIFRA%TYPE
 )
 RETURN SYS_REFCURSOR
 IS
	l_rc SYS_REFCURSOR;
BEGIN 
  IF sifra_kase_p IS NULL THEN
    -- Pogrena vrijednost ulaznog parametra (#0)!
    pra_zmp_zaj.vrati_poruku (-20099, 'sifra_kase_p');
  END IF;    
  
  OPEN l_rc FOR    
     SELECT kon.sifra                AS kon_sifra,  
            kon.ime_prezime          AS kon_ime_prezime, 
            kon.lozinka              AS kon_lozinka,
            kon.oib                  AS kon_oib,
            NVL(kon.ime_prezime1,kon.ime_prezime) AS gdpr_ime_prezime           
       FROM m_konobari kon,
            m_kon_kase konkase,
            m_kase kase 
      WHERE kon.id = konkase.kon_id
        AND konkase.kase_id = kase.id
        AND kase.sifra = sifra_kase_p
        AND kon.oib IS NOT NULL  
        AND kon.aktivan = 'D' ;
          
  RETURN l_rc;
END;
FUNCTION R_KASA_VLASNIK
 (SIFRA_KASE_P IN MGMP_KASE.SIFRA%TYPE
 )
 RETURN SYS_REFCURSOR
 IS
l_rc SYS_REFCURSOR;
BEGIN   
  IF sifra_kase_p IS NULL THEN
    -- Pogrena vrijednost ulaznog parametra (#0)!
    pra_zmp_zaj.vrati_poruku (-20099, 'sifra_kase_p');
  END IF;    

  OPEN l_rc FOR 
    SELECT  kase.sifra                AS kase_sifra,
            kase.naziv                AS kase_naziv, 
            NVL(ojpp.sifra, oj.sifra) AS oj_sifra,
            SUBSTR (pra_pka_i3fiskal.vlas_u_sust_pdv, 1, 10) AS u_sustavu_pdv,  
            vla.oib                   AS oib,
            kase.zaglavlje            AS kase_zaglavlje,
            kase.podnozje             AS kase_podnozje                                    
       FROM s_vlasnik vla,
            mgmp_kase kase,
            m_oj oj,
            m_oj ojpp
      WHERE kase.sifra = sifra_kase_p
        AND kase.zmpojr_id = oj.id
        AND kase.zmpojrp_id = ojpp.id(+);
     RETURN l_rc;         
END;
FUNCTION R_KASA_VPLACANJA
 (SIFRA_KASE_P IN MGMP_KASE.SIFRA%TYPE
 )
 RETURN SYS_REFCURSOR
 IS
l_rc SYS_REFCURSOR;
gotovina_l t_rnkase.izn_placanja%TYPE := -1;
vpla_sifra_l s_vplacanja.sifra%TYPE;
BEGIN   
    
  IF sifra_kase_p IS NULL THEN
    -- Pogrena vrijednost ulaznog parametra (#0)!
    pra_zmp_zaj.vrati_poruku (-20099, 'sifra_kase_p');
  END IF;       
    
  /* Ogranienje u poslovanju s gotovinom npr. 75.000,00 ili nebitno. */  
  IF pra_pka_zaj.vrijednost_parametra ('1093') <> 'nebitno' THEN
      SELECT TO_NUMBER (pra_pka_zaj.vrijednost_parametra ('1093'), '999G999D99', 'NLS_NUMERIC_CHARACTERS = '',.'' ')
        INTO gotovina_l
        FROM dual;
  END IF;  
  
  OPEN l_rc FOR
    SELECT vpla.sifra  AS vpla_sifra,
           vpla.naziv  AS vpla_naziv,
           vppla.sifra AS vppla_sifra,
           vppla.naziv AS vppla_naziv,
           DECODE (vppla.sifra,'X','N','T','N','D')  AS fisk_oznaka,
           DECODE (vppla.sifra,'G',gotovina_l, -1)   AS max_gotovina,
           pra_pka_s3.izn_ftecaja                    AS izn_tecaja,
           vpla.sifra  AS vpla_sifra,
           (SELECT LISTAGG(zmpvplasus.sifra, ', ') WITHIN GROUP (ORDER BY zmpvplasus.sifra)
              FROM mzmp_vpla_sus zmpvplasus, szmp_sustavi zmpsus
             WHERE zmpvplasus.zmpsus_id = zmpsus.id
               AND zmpsus.sifra = 'PKA'
               AND vpla.id = zmpvplasus.vpla_id)  AS card_issuer
      FROM m_kase kase,
           s_vplacanja vpla,
           m_nac_vpla nacvpla,
           m_kasa_np kasanp,
           s_vpplacanja vppla
     WHERE vpla.id = nacvpla.vpla_id
       AND kasanp.nac_id = nacvpla.nac_id
       AND vpla.vppla_id = vppla.id
       AND vppla.sifra IN ('G', 'K') -- dozvoljne samo gotovina i kartice
       AND ozn_kag = -1
       AND ozn_irn IS NULL
       AND kase.sifra = sifra_kase_p
       AND kasanp.kase_id = kase.id;
       
RETURN l_rc;
END;
FUNCTION R_GTEHPRO
 RETURN SYS_REFCURSOR
 IS

		l_rc SYS_REFCURSOR;
BEGIN
  OPEN l_rc FOR
    SELECT sifra AS sifra,
           naziv AS naziv
      FROM m_gtehpro;
  RETURN l_rc;
END;
FUNCTION R_TEMELJNICA
 (OZNAKA_P IN igas_knjizenje.oznaka%TYPE
 )
 RETURN SYS_REFCURSOR
 IS
 
 l_rc SYS_REFCURSOR;
BEGIN
  OPEN l_rc FOR
     SELECT oj_vlasnik profit_centar,
            to_char(dat_poc, 'dd.mm.yyyy') from_date,
            to_char(dat_zav, 'dd.mm.yyyy') to_date,
            oj_sifra organizational_unit,
            gasoknj_sifra code,
            gasoknj_naziv description,
            konto account,
            duguje debit_balance,
            potrazuje credit_balance,
            oznaka type
       FROM igas_knjizenje
      WHERE oznaka = NVL (oznaka_p,oznaka)
      ORDER BY oznaka, konto, oj_sifra;

  RETURN l_rc;
END;
FUNCTION R_GAS_IRA
 (DAT_POC_P DATE
 ,DAT_ZAV_P DATE
 )
 RETURN SYS_REFCURSOR
 IS

  l_rc SYS_REFCURSOR;
BEGIN
  OPEN l_rc FOR
     SELECT oj_sifra profit_center,
            to_char(datum, 'dd.mm.yyyy') document_date,
            mt_sifra organizational_unit,
            kase_sifra pos_code,
            izn_osnovica  base_amount,
            izn_pdv  vat_amount,
            izn_ppot  tax_amount,
            pdv_stopa  vat_rate
       FROM igas_ira 
      WHERE oznaka_knji = 'D'
        AND datum BETWEEN nvl(dat_poc_p, trunc(SYSDATE)) AND  nvl(dat_zav_p, trunc(SYSDATE))
      ORDER BY oj_sifra, mt_sifra, kase_sifra, datum;

  RETURN l_rc;
END;
FUNCTION R_ULAZDOK
 (DAT_POC_P DATE
 ,DAT_ZAV_P DATE
 )
 RETURN SYS_REFCURSOR
 IS

  l_rc SYS_REFCURSOR;
BEGIN
  OPEN l_rc FOR
      SELECT ulaz.godina year,
        ulaz.datum  document_date,
        ulaz.ozn_vdokumenta document_type, 
        gmpkom.sifra client, 
        ulaz.rbr document, 
        ulaz.broj vendor_document,
        SUM(ROUND(ulazart.kolicina*ROUND(ulazart.nab_cijena*(1-ulazart.rabat/100),2),2))  total_amount
   FROM t_ulazdok ulaz, 
        t_ulazdok_art ulazart,
        mgmp_komitenti gmpkom
  WHERE ulaz.id = ulazart.ulaz_id
    AND ulaz.dob_id = gmpkom.id 
    AND ulaz.ozn_vdokumenta <> 'P'
    AND ulaz.datum BETWEEN nvl(dat_poc_p, trunc(SYSDATE)) AND  nvl(dat_zav_p, trunc(SYSDATE))
  GROUP BY ulaz.id, ulaz.godina, ulaz.datum, ozn_vdokumenta, gmpkom.sifra, ulaz.rbr, ulaz.broj
  ORDER BY gmpkom.sifra, ulaz.rbr, ulaz.datum;

  RETURN l_rc;
END;
PROCEDURE INVENTURA
 (ORGBR_P IN t_inventura.opis%TYPE
 ,DATUM_P IN t_inventura.datum%TYPE
 ,MT_P IN m_mt.sifra%TYPE
 ,OPIS_P IN t_inventura.opis80%TYPE
 ,INV_ID_P OUT t_inventura.id%TYPE
 ,RBR_P OUT VARCHAR2
 ,USER_P IN t_inventura.unos_korisnik%TYPE := null
 )
 IS

	
		CURSOR mt_id_c(mt_p VARCHAR2) IS
			SELECT mt.id FROM m_mt mt WHERE mt.sifra = mt_p;
	
		id_l          NUMBER;
		naredba_l     VARCHAR2(32000);
		sifra_cvora_l smet_cvorovi.sifra%TYPE;
		mt_id_l       t_ulazdok.mt_id%TYPE;
		godina_l      t_ulazdok.godina%TYPE;
		rbr_l         t_ulazdok.rbr%TYPE;
BEGIN   
IF pra_zmp_s.oznaka1 ('P0032',mt_p) = 0 THEN
    -- Nedoputen pristup!
    pra_zmp_zaj.vrati_poruku (-20138);
  END IF;
  -- mjesto troka
  OPEN mt_id_c(mt_p);
  FETCH mt_id_c
  	INTO mt_id_l;
  CLOSE mt_id_c;

  IF mt_id_l IS NULL THEN
   	raise_application_error(-20001,'U GAS ne postoji mjesto troka: ' ||mt_p);
  END IF;

  -- vri kontrolu i vraa vrijednost vora u sifra_cvora_l
  kontrola_cvora(mt_id_l,sifra_cvora_l);

  -- ako je vor ok dodaje @
  IF sifra_cvora_l IS NOT NULL
  THEN
	sifra_cvora_l := '@' || sifra_cvora_l;
  END IF;
  godina_l := to_char(datum_p,'yyyy');

  -- provjerava da li zaglavlje postoji, ako ne postoji dodaje
  naredba_l := 'BEGIN
	 SELECT id,rbr INTO :id,:rbr
		 FROM t_inventura' || sifra_cvora_l || '
		WHERE godina   = :godina
			AND mt_id    = :mt_id
			AND datum    = :datum;
	 EXCEPTION
			WHEN NO_DATA_FOUND THEN
				 :id := gas_zaj.sekvenca' || sifra_cvora_l ||
						 '(NULL);
				
				 INSERT INTO t_inventura' || sifra_cvora_l || '
					 (id,rbr, godina, mt_id, datum, opis, opis80, ozn_valjanosti,unos_korisnik,unos_dat)
				  VALUES
                     (:id,:rbr,:godina, :mt_id, :datum, :opis, :opis80, ''V'',:user,sysdate);
                  SELECT rbr
					INTO :rbr
	                FROM t_inventura' || sifra_cvora_l || '
	               WHERE id  = :id; 
	 END;';
  EXECUTE IMMEDIATE naredba_l
	USING IN OUT id_l, IN OUT rbr_l, IN godina_l, IN mt_id_l, IN datum_p, IN orgbr_p, IN opis_p, IN user_p;
 inv_id_p := id_l;
 rbr_p    := rbr_l;
END;
PROCEDURE INVENTURA_ART
 (INV_ID_P IN t_inventura_art.inv_id%TYPE
 ,MT_P IN m_mt.sifra%TYPE
 ,ART_P IN m_sirovine.sifra%TYPE
 ,KOLICINA_P IN t_inventura_art.kol_inventura%TYPE
 ,USER_P IN t_inventura_art.unos_korisnik%TYPE := null
 )
 IS

		CURSOR sir_id_c(art_p VARCHAR2) IS
			SELECT s.id FROM m_sirovine s WHERE s.sifra = art_p;
		CURSOR nam_id_c(art_p VARCHAR2) IS
			SELECT n.id FROM m_namirnice n WHERE n.sifra = art_p;
		CURSOR pro_id_c(art_p VARCHAR2) IS
			SELECT p.id FROM m_proizvodi p WHERE p.sifra = art_p;
	
		CURSOR mt_id_c(mt_p VARCHAR2) IS
			SELECT mt.id FROM m_mt mt WHERE mt.sifra = mt_p;
	
		naredba_l     VARCHAR2(32000);
		sifra_cvora_l smet_cvorovi.sifra%TYPE;
		sir_id_l      m_sirovine.id%TYPE;
		nam_id_l      m_namirnice.id%TYPE;
		pro_id_l      m_proizvodi.id%TYPE;
		mt_id_l       t_prijelaz.mt_id_daje%TYPE;
		st_id_l       t_inventura_art.id%TYPE;
BEGIN
 -- ID sirovine
  OPEN sir_id_c(art_p);
  FETCH sir_id_c
	INTO sir_id_l;
  CLOSE sir_id_c;
  -- ID namirnice
  OPEN nam_id_c(art_p);
  FETCH nam_id_c
	INTO nam_id_l;
  CLOSE nam_id_c;
  -- ID proizvoda
  OPEN pro_id_c(art_p);
  FETCH pro_id_c
	INTO pro_id_l;
  CLOSE pro_id_c;

  -- ako ne postoji arikal
  IF sir_id_l IS NULL AND
	 nam_id_l IS NULL AND
	 pro_id_l IS NULL
  THEN
	raise_application_error(-20001,'U GAS ne postoji artikal: ' || art_p);
  END IF;

  -- mjesto troka
  OPEN mt_id_c(mt_p);
  FETCH mt_id_c
	INTO mt_id_l;
  CLOSE mt_id_c;

  -- vri kontrolu i vraa vrijednost vora u sifra_cvora_l
  kontrola_cvora(mt_id_l,sifra_cvora_l);
  -- ako je vor ok dodaje zapis u t_
  IF sifra_cvora_l IS NOT NULL
  THEN
	sifra_cvora_l := '@' || sifra_cvora_l;
  END IF;

  -- insert stavke
  naredba_l := 'BEGIN
		 SELECT id INTO :id
			 FROM t_inventura_art' || sifra_cvora_l || '
			WHERE inv_id = :inv_id
				AND nvl(sir_id,0) = nvl(:sir_id,0)
				AND nvl(nam_id,0) = nvl(:nam_id,0)
				and nvl(pro_id,0) = nvl(:pro_id,0);

		 UPDATE t_inventura_art ' || sifra_cvora_l || '
			SET kol_inventura = kol_inventura + :kolicina
		  WHERE id = :id;

	 EXCEPTION
			WHEN NO_DATA_FOUND THEN
        :id := gas_zaj.sekvenca' || sifra_cvora_l ||
                   '(NULL);
				INSERT INTO t_inventura_art' || sifra_cvora_l || '
						(id,inv_id, sir_id, nam_id, pro_id, kol_inventura,unos_korisnik,unos_dat)
				VALUES
						(:id,:inv_id, :sir_id, :nam_id, :pro_id, :kolicina, :user, sysdate);
	 END;';
  EXECUTE IMMEDIATE naredba_l
	USING IN OUT st_id_l ,inv_id_p, sir_id_l, nam_id_l, pro_id_l, kolicina_p, user_p;
END;
PROCEDURE IZLAZ
 (ORGBR_P IN t_izlaz.opis%TYPE
 ,DATUM_P IN t_izlaz.datum%TYPE
 ,MT_P IN m_mt.sifra%TYPE
 ,NACPOT_P IN m_nacpot.sifra%TYPE
 ,OPIS_P IN t_izlaz.opis80%TYPE
 ,IZL_ID_P OUT t_izlaz.id%TYPE
 ,RBR_P OUT VARCHAR2
 )
 IS

	
		CURSOR nac_id_c(nacpot_p VARCHAR2) IS
			SELECT nac.id,
						 nac.gpor_id
				FROM m_nacpot nac
			 WHERE nac.sifra = nacpot_p;
	
		CURSOR mt_id_c(mt_p VARCHAR2) IS
			SELECT mt.id FROM m_mt mt WHERE mt.sifra = mt_p;
	
		id_l          NUMBER;
		naredba_l     VARCHAR2(32000);
		sifra_cvora_l smet_cvorovi.sifra%TYPE;
	
		gpor_id_l          t_izlaz.gpor_id%TYPE;
		nac_id_l           t_izlaz.nac_id%TYPE;
		mt_id_l            t_izlaz.mt_id%TYPE;
		godina_l           t_izlaz.godina%TYPE;
		rbr_l              t_izlaz.rbr%TYPE;
                priznanje_l        t_izlaz.priznanje%TYPE;
                priznanje_trosak_l t_izlaz.priznanje_trosak%TYPE;
BEGIN
  IF pra_zmp_s.oznaka1 ('P0033',mt_p) = 0 THEN
    -- Nedoputen pristup!
    pra_zmp_zaj.vrati_poruku (-20138);
  END IF;
  -- mjesto troka
  OPEN mt_id_c(mt_p);
  FETCH mt_id_c
	INTO mt_id_l;
  CLOSE mt_id_c;

  IF mt_id_l IS NULL THEN
    raise_application_error(-20001,'U GAS ne postoji mjesto troka: ' || mt_p);
  END IF;
  -- vri kontrolu i vraa vrijednost vora u sifra_cvora_l
  kontrola_cvora(mt_id_l,sifra_cvora_l);

  -- ako je vor ok dodaje @
  IF sifra_cvora_l IS NOT NULL
  THEN
   	sifra_cvora_l := '@' || sifra_cvora_l;
  END IF;
  godina_l := to_char(datum_p,'yyyy');
  -- nain plaanja
  OPEN nac_id_c(nacpot_p);
  FETCH nac_id_c
	INTO nac_id_l,
			 gpor_id_l;
  CLOSE nac_id_c;

  IF nac_id_l IS NULL THEN
    raise_application_error(-20001, 'U GAS ne postoji nain potronje: ' || nacpot_p);
  END IF;

  priznanje_l := pra_mgas_nac_raz.prihod (nac_id_l, mt_id_l, datum_p);
  priznanje_trosak_l := pra_mgas_nac_raz.trosak (nac_id_l, mt_id_l, datum_p);
  
	-- provjerava da li zaglavlje postoji, ako ne postoji insert zaglavlja
  naredba_l := 'BEGIN
	  SELECT id,rbr INTO :id,:rbr
		 FROM t_izlaz' || sifra_cvora_l || '
		WHERE datum    = :datum
		  AND mt_id    = :mt_id
		  AND nac_id   = :nac_id;

	 EXCEPTION
		 WHEN NO_DATA_FOUND THEN
			 :id := gas_zaj.sekvenca' || sifra_cvora_l ||
							 '(NULL);
			 pra_rbr.racunaj_novi_rbr (:id, ''T_IZLAZ'', :godina, :mt_id, NULL, NULL, ''V'', :rbr);
			 INSERT INTO t_izlaz' || sifra_cvora_l || '
					(id,rbr,godina,mt_id,datum,nac_id,gpor_id,priznanje,priznanje_trosak,marza,opis,opis80,ozn_valjanosti)
			 VALUES
					(:id,:rbr,:godina,:mt_id,:datum,:nac_id,:gpor_id,:priznanje,:priznanje_trosak,0,:opis,:opis80,''V'');
	 END;';
  EXECUTE IMMEDIATE naredba_l
		USING IN OUT id_l, IN OUT rbr_l, IN datum_p, IN mt_id_l, IN nac_id_l, IN godina_l, IN gpor_id_l, IN priznanje_l, IN priznanje_trosak_l, IN orgbr_p, IN opis_p;

  izl_id_p := id_l;
  rbr_p    := mt_p || '-' || rbr_l;
END;
PROCEDURE IZLAZ_ART
 (IZL_ID_P IN t_izlaz_art.izl_id%TYPE
 ,MT_P IN m_mt.sifra%TYPE
 ,ART_P IN m_sirovine.sifra%TYPE
 ,KOLICINA_P IN t_izlaz_art.kol_izlaz%TYPE
 ,KOL_POVRAT_P IN t_izlaz_art.kol_povrat%TYPE := 0
 )
 IS

		CURSOR sir_id_c(art_p VARCHAR2) IS
			SELECT s.id FROM m_sirovine s WHERE s.sifra = art_p;
		CURSOR nam_id_c(art_p VARCHAR2) IS
			SELECT n.id FROM m_namirnice n WHERE n.sifra = art_p;
		CURSOR pro_id_c(art_p VARCHAR2) IS
			SELECT p.id FROM m_proizvodi p WHERE p.sifra = art_p;
	
		CURSOR mt_id_c(mt_p VARCHAR2) IS
			SELECT mt.id FROM m_mt mt WHERE mt.sifra = mt_p;
	
		naredba_l     VARCHAR2(32000);
		sifra_cvora_l smet_cvorovi.sifra%TYPE;
		sir_id_l      m_sirovine.id%TYPE;
		nam_id_l      m_namirnice.id%TYPE;
		pro_id_l      m_proizvodi.id%TYPE;
		mt_id_l       t_izlaz.mt_id%TYPE;
    		kolicina_l    t_izlaz_art.kol_izlaz%TYPE := 0;
    		kol_povrat_l  t_izlaz_art.kol_povrat%TYPE := 0;
BEGIN
	-- ID sirovine
	OPEN sir_id_c(art_p);
	FETCH sir_id_c
		INTO sir_id_l;
	CLOSE sir_id_c;
	-- ID namirnice
	OPEN nam_id_c(art_p);
	FETCH nam_id_c
		INTO nam_id_l;
	CLOSE nam_id_c;
	-- ID proizvoda
	OPEN pro_id_c(art_p);
	FETCH pro_id_c
		INTO pro_id_l;
	CLOSE pro_id_c;
  
    -- ako ne postoji arikal
	IF sir_id_l IS NULL AND
		 nam_id_l IS NULL AND
		 pro_id_l IS NULL
	THEN
		raise_application_error(-20001,'U GAS ne postoji artikal: ' || art_p);
	END IF;

	-- mjesto troka 
	OPEN mt_id_c(mt_p);
	FETCH mt_id_c
		INTO mt_id_l;
	CLOSE mt_id_c;
	-- vri kontrolu i vraa vrijednost vora u sifra_cvora_l
	kontrola_cvora(mt_id_l,sifra_cvora_l);
	-- ako je vor ok dodaje zapis u t_
	IF sifra_cvora_l IS NOT NULL
	THEN
		sifra_cvora_l := '@' || sifra_cvora_l;
	END IF;
  	 
 	IF kolicina_p IS NOT NULL THEN
    	    kolicina_l := kolicina_p;
 	END IF; 
  
 	IF kol_povrat_p IS NOT NULL THEN
    	    kol_povrat_l := kol_povrat_p;
  	END IF;    
	
	/*napomena - naredba INSERT u dinamikom SQL-u ne radi bez BEGIN -- END; */
	-- insert stavke
    naredba_l := 'BEGIN
	 INSERT INTO t_izlaz_art' || sifra_cvora_l || '
		  (izl_id,nam_id,pro_id,kol_plan,kol_izlaz,pdv,ppot,zad_nab_cijena,pros_nab_cijena,kol_povrat,sir_id)
	 VALUES
		  (:id,:nam_id,:pro_id,0,:kolicina,0,0,0,0,:kol_povrat,:sir_id);
	 END;';
	EXECUTE IMMEDIATE naredba_l
		USING izl_id_p, nam_id_l, pro_id_l, kolicina_l, kol_povrat_l, sir_id_l;
END;
PROCEDURE ULAZDOK
 (ORGBR_P IN t_ulazdok.broj%TYPE
 ,DATUM_P IN t_ulazdok.datum%TYPE
 ,MT_P IN m_mt.sifra%TYPE
 ,DOB_P IN mgmp_komitenti.sifra%TYPE
 ,OPIS_P IN t_ulazdok.opis%TYPE
 ,ULAZ_ID_P OUT t_ulazdok.id%TYPE
 ,OZN_VDOK_P IN VARCHAR := 'U'
 )
 IS

  CURSOR mt_id_c(mt_p VARCHAR2) IS
    SELECT mt.id FROM m_mt mt WHERE mt.sifra = mt_p;

  CURSOR dob_id_c(dob_p VARCHAR2) IS
    SELECT d.id FROM mgmp_komitenti d WHERE d.sifra = dob_p;

  id_l          t_ulazdok.id%TYPE;
  dob_id_l      t_ulazdok.dob_id%TYPE;
  mt_id_l       t_ulazdok.mt_id%TYPE;
  godina_l      t_ulazdok.godina%TYPE;
  ozn_vdok_l    t_ulazdok.ozn_vdokumenta%TYPE := 'U';
  greska        exception;
BEGIN     
   IF pra_zmp_s.oznaka1 ('P0034',mt_p) = 0 THEN
    -- Nedopusten pristup!
    pra_zmp_zaj.vrati_poruku (-20138);
  END IF; 
  -- mjesto troska
  OPEN mt_id_c(mt_p);
  FETCH mt_id_c
	INTO mt_id_l;
  CLOSE mt_id_c;
  IF mt_id_l IS NULL THEN
    raise_application_error(-20001,'U GAS ne postoji mjesto troska: ' || mt_p);
  END IF;
  -- dobavljac
  OPEN dob_id_c(dob_p);
  FETCH dob_id_c
	INTO dob_id_l;
  CLOSE dob_id_c;
  IF dob_id_l IS NULL THEN
    raise_application_error(-20002,'U GAS ne postoji dobavljac: ' || dob_p);
  END IF;
  godina_l := to_char(datum_p,'yyyy');

  IF ozn_vdok_p IS NOT NULL THEN
    ozn_vdok_l := ozn_vdok_p;
  END IF;

  -- provjerava da li zaglavlje postoji, ako ne postoji dodaje inae javi greku
  BEGIN
		 SELECT id 
       INTO id_l
			 FROM t_ulazdok
			WHERE godina    = godina_l
				AND mt_id     = mt_id_l
				AND ozn_vdokumenta = ozn_vdok_l
				AND datum      = datum_p
        AND broj       = orgbr_p;
     raise greska;
	EXCEPTION
		WHEN greska THEN
      raise_application_error(-20001, 'Primka br. ' || ORGBR_P  || ' za MT: ' ||MT_P ||
                                      ' i datum: '|| to_char(DATUM_P,'dd.mm.yyyy') || ' ve postoji.'); 
    WHEN NO_DATA_FOUND THEN
		  BEGIN	
        id_l := gas_zaj.sekvenca(NULL);

         INSERT INTO t_ulazdok
             (id, godina, mt_id, ozn_vdokumenta, datum, dob_id, broj, opis, opis80, ozn_valjanosti, izn_korekcije)
           VALUES
             (id_l, godina_l, mt_id_l, ozn_vdok_l, datum_p, dob_id_l, orgbr_p, opis_p, null, 'N', 0);
      
      EXCEPTION
         WHEN OTHERS THEN
           raise_application_error(-20002,sqlerrm||
                                  ' - Greska kod dodavanja primke: ' || ORGBR_P);     
	    END;
  END;
	ulaz_id_p := id_l;
END;
PROCEDURE ULAZDOK_ART
 (ULAZ_ID_P IN t_ulazdok.ulaz_id%TYPE
 ,ART_P IN m_sirovine.sifra%TYPE
 ,KOLICINA_P IN t_ulazdok_art.kolicina%TYPE
 ,CIJENA_P IN t_ulazdok_art.nab_cijena%TYPE
 ,RABAT_P IN t_ulazdok_art.rabat%TYPE
 )
 IS

  CURSOR sir_id_c(art_p VARCHAR2) IS
    SELECT s.id FROM m_sirovine s WHERE s.sifra = art_p;
  CURSOR nam_id_c(art_p VARCHAR2) IS
    SELECT n.id FROM m_namirnice n WHERE n.sifra = art_p;

  sir_id_l      m_sirovine.id%TYPE;
  nam_id_l      m_namirnice.id%TYPE;
BEGIN
  -- ID sirovine
  OPEN sir_id_c(art_p);
  FETCH sir_id_c
  INTO sir_id_l;
  CLOSE sir_id_c;
  -- ID namirnice
  OPEN nam_id_c(art_p);
  FETCH nam_id_c
  INTO nam_id_l;
  CLOSE nam_id_c;

  -- ako ne postoji arikal
  IF sir_id_l IS NULL AND
    nam_id_l IS NULL
  THEN
     raise_application_error(-20001, 'U GAS ne postoji artikal: ' || art_p);
  END IF;

  -- insert stavke
  BEGIN
    INSERT INTO t_ulazdok_art
      (ulaz_id, sir_id, nam_id, kolicina, rabat, nab_cijena, pnaknada)
    VALUES
      (ulaz_id_p, sir_id_l, nam_id_l, kolicina_p, rabat_p, nvl(cijena_p,0),0);
  EXCEPTION
     WHEN OTHERS THEN
       raise_application_error(-20002,sqlerrm||
                              'Greska kod dodavanja stavki primke: ' || ULAZ_ID_P);
  END;
END;
PROCEDURE UPD_ULAZDOK
 (ULAZ_ID_P IN T_ULAZDOK.ID%TYPE
 ,RBR_P OUT T_ULAZDOK.RBR%TYPE
 )
 IS
 
  rbr_l    t_ulazdok.rbr%TYPE;
BEGIN
   -- radi update ozn_valjanosti za replikaciju na objekt
   UPDATE t_ulazdok 
      SET ozn_valjanosti = 'V'
    WHERE id  = ULAZ_ID_P; 
   
   SELECT mt.sifra || '-' || ul.godina || '-' || ul.rbr
     INTO rbr_l
     FROM t_ulazdok ul, m_mt mt
    WHERE ul.mt_id = mt.id
      AND ul.id  = ULAZ_ID_P; 
 
   rbr_p     := rbr_l; 
EXCEPTION
  WHEN OTHERS THEN
     raise_application_error(-20002,sqlerrm||
                             'Greska kod potvrde primke: ' || ULAZ_ID_P);
END;
PROCEDURE CNCL_ULAZDOK
 (ULAZ_ID_P IN OUT T_ULAZDOK.ID%TYPE
 ,RBR_P OUT T_ULAZDOK.RBR%TYPE
 )
 IS

  CURSOR ulazdok_c(ulaz_id_p VARCHAR2) IS
    SELECT id 
      FROM t_ulazdok t 
     WHERE t.id = ULAZ_ID_P;
   
  id_l          t_ulazdok.id%type;
  ulaz_id_l     t_ulazdok.id%type;
  rbr_l         t_ulazdok.rbr%type;
  v_broj        number;
BEGIN
  -- provjera primke za storno
  OPEN ulazdok_c(ulaz_id_p);
  FETCH ulazdok_c
    INTO ulaz_id_l;
  CLOSE ulazdok_c;
   
  -- ako ne postoji dokument
  IF ulaz_id_l IS NULL 
  THEN
     raise_application_error(-20001, 'U GAS ne postoji primka : ' || ULAZ_ID_P);
  END IF;
  /*
  -- ako  postoji dokument u log-u ne smije stornirati
  SELECT count(*)
    INTO v_broj
    FROM possus_l_dokumenti
   WHERE id = ULAZ_ID_P; 
    
  IF v_broj > 0 THEN  
     raise_application_error(-20002, 'Primka se nije replicirala na objekt,provjeriti log: ' || ULAZ_ID_P);
  END IF;    */
  
  -- insert zaglavlja 
  id_l := gas_zaj.sekvenca(NULL);

  INSERT INTO t_ulazdok
     (id, godina, mt_id, ozn_vdokumenta, datum, dob_id, broj, opis, opis80, ozn_valjanosti, izn_korekcije, ulaz_id)
     SELECT id_l,ul.godina,ul.mt_id,ul.ozn_vdokumenta,ul.datum,ul.dob_id,ul.broj,ul.opis,ul.opis80,'N',ul.izn_korekcije,ul.id
       FROM t_ulazdok ul
      WHERE ul.id = ulaz_id_l;
     
  -- insert stavki
  INSERT INTO t_ulazdok_art
     (ulaz_id, sir_id, nam_id, kolicina, rabat, nab_cijena, pnaknada)
     SELECT id_l,art.sir_id,art.nam_id,art.kolicina * -1,art.rabat,art.nab_cijena,art.pnaknada
       FROM t_ulazdok_art art
      WHERE art.ulaz_id = ulaz_id_l;  
      
   -- replikacija na objekt     
   upd_ulazdok(id_l, rbr_l);
   
   ulaz_id_p := id_l;
   rbr_p := rbr_l;

EXCEPTION
     WHEN OTHERS THEN
       raise_application_error(-20003,sqlerrm||
                              ' - Greka kod storniranja primke: ' || ULAZ_ID_P);   
END;
PROCEDURE DEL_ULAZDOK_ART
 (ULAZ_ID_P IN T_ULAZDOK.ID%TYPE
 ,RBR_P OUT T_ULAZDOK.RBR%TYPE
 )
 IS

  id_l     t_ulazdok.id%type;
  rbr_l    t_ulazdok.rbr%TYPE;
  v_broj   number := 0;
BEGIN

    -- provjera da li primka postoji
    SELECT ul.id, mt.sifra || '-' || ul.godina || '-' || ul.rbr 
      INTO id_l, rbr_l 
      FROM t_ulazdok ul, m_mt mt 
     WHERE mt.id = ul.mt_id
       AND ul.id = ULAZ_ID_P;
    
    SELECT count(*)
       INTO v_broj
       FROM possus_l_dokumenti
      WHERE id = ULAZ_ID_P; 
    
    IF v_broj = 0 THEN   
      -- zapis u log za brisanje za novo dodavanje na objektu ako ne postoji
      INSERT INTO possus_l_dokumenti (id,vrsta,greska)
      VALUES ( ULAZ_ID_P,'U','Brisanje stavaka i ispravak primke ' || rbr_l);
    END IF;  
    -- brisanje 'starih' stavaka
    DELETE  t_ulazdok_art WHERE ulaz_id = ULAZ_ID_P;
    
    rbr_p     := rbr_l; 
 EXCEPTION
    WHEN no_data_found THEN
      raise_application_error(-20001,
                              'Primka ne postoji: ' || ULAZ_ID_P);
    WHEN OTHERS THEN
      raise_application_error(-20002,sqlerrm||
                              ' - Greska kod brisanja stavki primke: ' || ULAZ_ID_P);
 END;
PROCEDURE ULAZDOK_AMB
 (ULAZ_ID_P IN t_ulazdok.ulaz_id%TYPE
 ,MT_P IN m_mt.sifra%TYPE
 ,AMB_P IN m_ambalaza.sifra%TYPE
 ,KOLICINA_P IN t_ulazdok_amb.kolicina%TYPE
 ,CIJENA_P IN t_ulazdok_amb.nab_cijena%TYPE
 )
 IS
	
	CURSOR amb_id_c(amb_p VARCHAR2) IS
		SELECT s.id FROM m_ambalaza s WHERE s.sifra = amb_p;
	
 	CURSOR mt_id_c(mt_p VARCHAR2) IS
		SELECT mt.id FROM m_mt mt WHERE mt.sifra = mt_p;

	naredba_l     VARCHAR2(32000);
	sifra_cvora_l smet_cvorovi.sifra%TYPE;
	amb_id_l      m_ambalaza.id%TYPE;
	mt_id_l       t_prijelaz.mt_id_daje%TYPE;
BEGIN
	-- ID ambalaze
	OPEN amb_id_c(amb_p);
	FETCH amb_id_c
		INTO amb_id_l;
	CLOSE amb_id_c;
	
    -- ako ne postoji arikal
	IF amb_id_l IS NULL 
	THEN
	   raise_application_error(-20001, 'U GAS ne postoji ambalaa: ' || amb_p);
	END IF;
	-- mjesto troka
	OPEN mt_id_c(mt_p);
	FETCH mt_id_c
		INTO mt_id_l;
	CLOSE mt_id_c;
	-- vri kontrolu i vraa vrijednost vora u sifra_cvora_l
	kontrola_cvora(mt_id_l,sifra_cvora_l);
	-- ako je vor ok dodaje zapis u t_ulazdok_art
	IF sifra_cvora_l IS NOT NULL
	THEN
	  sifra_cvora_l := '@' || sifra_cvora_l;
	END IF;

	/*napomena - naredba INSERT u dinamikom SQL-u ne radi bez BEGIN -- END; */
	-- insert stavke
	naredba_l := 'BEGIN
		 INSERT INTO t_ulazdok_amb' || sifra_cvora_l || '
					 (ulaz_id,amb_id,kolicina,nab_cijena)
		 VALUES
					 (:id,:amb_id,:kolicina,nvl(:cijena,0));
		 END;';
	EXECUTE IMMEDIATE naredba_l
		USING ulaz_id_p,amb_id_l, kolicina_p, cijena_p;
END;
PROCEDURE PRIJELAZ
 (ORGBR_P IN t_prijelaz.opis%TYPE
 ,DATUM_P IN t_prijelaz.datum%TYPE
 ,MT_DAJE_P IN m_mt.sifra%TYPE
 ,MT_PRIMA_P IN m_mt.sifra%TYPE
 ,NACPOT_P IN m_nacpot.sifra%TYPE
 ,PRI_ID_P OUT t_prijelaz.id%TYPE
 ,BR_DOK_P OUT VARCHAR2
 )
 IS

		CURSOR nac_id_c(nacpot_p VARCHAR2) IS
			SELECT nac.id FROM m_nacpot nac WHERE nac.sifra = nacpot_p;
	
		CURSOR mt_id_c(mt_p VARCHAR2) IS
			SELECT mt.id FROM m_mt mt WHERE mt.sifra = mt_p;
	
		id_l          NUMBER;
		naredba_l     VARCHAR2(32000);
		sifra_cvora_l smet_cvorovi.sifra%TYPE;
		nac_id_l      t_prijelaz.nac_id%TYPE;
		mt_id_daje_l  t_prijelaz.mt_id_daje%TYPE;
		mt_id_prima_l t_prijelaz.mt_id_prima%TYPE;
		godina_l      t_prijelaz.godina%TYPE;
		rbr_daje_l    t_prijelaz.rbr_daje%TYPE;
		rbr_prima_l   t_prijelaz.rbr_prima%TYPE;
BEGIN  
  IF pra_zmp_s.oznaka1 ('P0035',mt_daje_p) = 0 THEN
    -- Nedoputen pristup!
    pra_zmp_zaj.vrati_poruku (-20138);
  END IF;  
  -- mjesto troka daje
  OPEN mt_id_c(mt_daje_p);
  FETCH mt_id_c
	INTO mt_id_daje_l;
  CLOSE mt_id_c;
  IF mt_id_daje_l IS NULL THEN
     raise_application_error(-20001,'U GAS ne postoji mjesto troka(daje): ' || mt_daje_p);
  END IF; 
  
  -- vri kontrolu i vraa vrijednost vora u sifra_cvora_l
  kontrola_cvora(mt_id_daje_l,sifra_cvora_l); 
  
  -- ako je vor ok dodaje @
  IF sifra_cvora_l IS NOT NULL
  THEN
	sifra_cvora_l := '@' || sifra_cvora_l;
  END IF;

  -- mjesto troka prima
  OPEN mt_id_c(mt_prima_p);
  FETCH mt_id_c
	INTO mt_id_prima_l;
  CLOSE mt_id_c;
  IF mt_id_prima_l IS NULL THEN
    raise_application_error(-20001,'U GAS ne postoji mjesto troka(prima): ' || mt_prima_p);
  END IF;
  godina_l := to_char(datum_p,'yyyy');
  
  -- nain plaanja
  OPEN nac_id_c(nacpot_p);
  FETCH nac_id_c
	INTO nac_id_l;
  CLOSE nac_id_c; 
  
  IF nac_id_l IS NULL AND nacpot_p IS NOT NULL THEN
    raise_application_error(-20001, 'U GAS ne postoji nain potronje: ' || nacpot_p);
  END IF;
 
  -- provjerava da li zaglavlje postoji, ako ne postoji dodaje
  naredba_l := 'BEGIN
	SELECT id,rbr_daje,rbr_prima 
   	  INTO :id,:rbr_daje,:rbr_prima
	  FROM t_prijelaz' || sifra_cvora_l || '
	 WHERE godina      = :godina
       AND mt_id_daje  = :mt_id_daje
       AND mt_id_prima = :mt_id_prima
       AND datum = :datum
       AND ROWNUM = 1;

	 EXCEPTION
		 WHEN NO_DATA_FOUND THEN
			 :id := gas_zaj.sekvenca' || sifra_cvora_l ||
						 '(NULL);
				
			 INSERT INTO t_prijelaz' || sifra_cvora_l || '
					 (id,rbr_daje,rbr_prima,godina,mt_id_daje, mt_id_prima, datum, nac_id, nar_id,opis, opis80,ozn_valjanosti)
			 VALUES
					 (:id,:rbr_daje,:rbr_prima, :godina, :mt_id_daje,:mt_id_prima, :datum, :nac_id,null,:opis, null, ''V'');
									
				 SELECT rbr_daje,rbr_prima 
					 INTO :rbr_daje,:rbr_prima
	      FROM t_prijelaz' || sifra_cvora_l || '
	     WHERE id  = :id;         
      END;';
  EXECUTE IMMEDIATE naredba_l
	USING IN OUT id_l, IN OUT rbr_daje_l, IN OUT rbr_prima_l, IN godina_l, IN mt_id_daje_l, IN mt_id_prima_l, IN datum_p, IN nac_id_l, IN orgbr_p;
  pri_id_p := id_l;
  br_dok_p := mt_daje_p || '-' || rbr_daje_l || '_' || mt_prima_p || '-' ||rbr_prima_l;
END;
PROCEDURE PRIJELAZ_ART
 (PRI_ID_P IN t_prijelaz_art.pri_id%TYPE
 ,MT_P IN m_mt.sifra%TYPE
 ,ART_P IN m_sirovine.sifra%TYPE
 ,KOLICINA_P IN t_prijelaz_art.kolicina%TYPE
 ,CIJENA_P IN t_prijelaz_art.nab_cijena%TYPE
 )
 IS

	
		CURSOR sir_id_c(art_p VARCHAR2) IS
			SELECT s.id FROM m_sirovine s WHERE s.sifra = art_p;
		CURSOR nam_id_c(art_p VARCHAR2) IS
			SELECT n.id FROM m_namirnice n WHERE n.sifra = art_p;
		CURSOR pro_id_c(art_p VARCHAR2) IS
			SELECT p.id,
						 p.pro_nam_id
				FROM m_proizvodi p
			 WHERE p.sifra = art_p;
	
		CURSOR mt_id_c(mt_p VARCHAR2) IS
			SELECT mt.id FROM m_mt mt WHERE mt.sifra = mt_p;
	
		naredba_l     VARCHAR2(32000);
		sifra_cvora_l smet_cvorovi.sifra%TYPE;
    verzija_l     s_vlasnik.verzija%TYPE;
		sir_id_l      m_sirovine.id%TYPE;
		nam_id_l      m_namirnice.id%TYPE;
		pro_id_l      m_proizvodi.id%TYPE;
		nam_pro_id_l  m_proizvodi.pro_nam_id%TYPE;
		mt_id_l       t_prijelaz.mt_id_daje%TYPE;
		st_id_l       t_prijelaz_art.id%TYPE;
BEGIN
  -- ID sirovine
  OPEN sir_id_c(art_p);
  FETCH sir_id_c
	INTO sir_id_l;
  CLOSE sir_id_c;
  -- ID namirnice
  OPEN nam_id_c(art_p);
  FETCH nam_id_c
	INTO nam_id_l;
  CLOSE nam_id_c;
  -- ID proizvoda
  OPEN pro_id_c(art_p);
  FETCH pro_id_c
	INTO pro_id_l,
		 nam_pro_id_l;
  CLOSE pro_id_c;
  
  -- ako ne postoji arikal
  IF sir_id_l IS NULL AND
	 nam_id_l IS NULL AND
	 pro_id_l IS NULL
  THEN
	raise_application_error(-20001,'U GAS ne postoji artikal: ' || art_p);
  END IF;
  
  -- mjesto troka 
  OPEN mt_id_c(mt_p);
  FETCH mt_id_c
	INTO mt_id_l;
  CLOSE mt_id_c;
  
  -- vri kontrolu i vraa vrijednost vora u sifra_cvora_l
  kontrola_cvora(mt_id_l,sifra_cvora_l);
  
  -- ako je vor ok dodaje ili aurira zapis u t_prijelaz_art
  IF sifra_cvora_l IS NOT NULL
  THEN
	sifra_cvora_l := '@' || sifra_cvora_l;
  END IF;
  
  -- insert stavke
  naredba_l := '
    BEGIN
     SELECT id
      INTO :id
      FROM t_prijelaz_art' || sifra_cvora_l || '
     WHERE pri_id        = :pri_id
      AND nvl(sir_id,0)  = nvl(:sir_id,0)
      AND nvl(nam_id,0)  = nvl(:nam_id,0)
      AND nvl(pro_id,0)  = nvl(:pro_id,0)
      AND nvl(nam_pro_id,0)  = nvl(:nam_pro_id,0);
    			
    UPDATE t_prijelaz_art ' || sifra_cvora_l || '
      SET kolicina = kolicina + :kolicina,
          nab_cijena = :cijena
     WHERE id = :id; 
    
    EXCEPTION
    WHEN NO_DATA_FOUND THEN
       :id := gas_zaj.sekvenca' || sifra_cvora_l ||
               '(NULL);
       INSERT INTO t_prijelaz_art' || sifra_cvora_l || '
           (id,pri_id,sir_id,nam_id,pro_id,nam_pro_id,kolicina,nab_cijena,planska_cijena,kolicina_plan)
       VALUES
           (:id,:pri_id,:sir_id,:nam_id,:pro_id,:nam_pro_id,:kolicina,:cijena,0,0);
    END;';
    
  EXECUTE IMMEDIATE naredba_l
	USING IN OUT st_id_l, IN pri_id_p, IN sir_id_l, IN nam_id_l, IN pro_id_l, IN nam_pro_id_l, IN kolicina_p, IN cijena_p;

END;
PROCEDURE KONTROLA_CVORA
 (MT_ID_P IN NUMBER
 ,SIFRA_CVORA_P OUT VARCHAR2
 )
 IS

		sifra_cvora_l smet_cvorovi.sifra%TYPE;
		brojac_l      NUMBER;
		ozn_u_mrezi_l smet_cvorovi.ozn_u_mrezi%TYPE;
		poruka_l      VARCHAR2(2000);
BEGIN
	/* Samo centar aurira po mrei */
	IF pra_zmp_zaj.centar = 0
	THEN
		RETURN;
	END IF;

	sifra_cvora_l := possus_gas.cvor_za_mt(mt_id_p);

	IF sifra_cvora_l IS NULL
	THEN
		poruka_l := pra_zmp_zaj.poruka('GAS','GAS0330', sifra_cvora_l);
		--  RAISE_APPLICATION_ERROR (-20000, 'Greka '||pra_zmp_zaj.poruka ('GAS', 'GAS0330', sifra_cvora_l));
	END IF;

	/* Da li vor ima instalaciju GAS */
	SELECT COUNT(*)
   	  INTO brojac_l
	  FROM smet_instalacije
	 WHERE metapl_sifra = 'GAS'
	    AND metcvor_sifra = sifra_cvora_l;

	IF brojac_l = 0 THEN
		poruka_l := pra_zmp_zaj.poruka('GAS','GAS0332', sifra_cvora_l);
		--RAISE_APPLICATION_ERROR (-20000, 'Greka '||pra_zmp_zaj.poruka ('GAS', 'GAS0332', sifra_cvora_l));
	END IF;

	/* Da li je vor oznaen da je/nije u mrei */
	SELECT ozn_u_mrezi
	  INTO ozn_u_mrezi_l
  	  FROM smet_cvorovi
	 WHERE sifra = sifra_cvora_l;

	IF ozn_u_mrezi_l = 0
	THEN
		poruka_l := pra_zmp_zaj.poruka('GAS','GAS0330', sifra_cvora_l);
		-- RAISE_APPLICATION_ERROR (-20000, 'Greka '||pra_zmp_zaj.poruka ('GAS', 'GAS0333', sifra_cvora_l));
	END IF;
	IF sifra_cvora_l <> pra_zmp_zaj.tekuci_cvor
	THEN
		sifra_cvora_p := sifra_cvora_l;
	END IF;

END;
PROCEDURE INT_NARUDZBA
 (ORGBR_P IN tgas_narudzba.opis%TYPE
 ,DATUM_P IN tgas_narudzba.datum%TYPE
 ,MT_DAJE_P IN m_mt.sifra%TYPE
 ,MT_PRIMA_P IN m_mt.sifra%TYPE
 ,NACPOT_P IN m_nacpot.sifra%TYPE
 ,NAR_ID_P OUT tgas_narudzba.id%TYPE
 ,BR_DOK_P OUT VARCHAR2
 )
 IS

   CURSOR nac_id_c(nacpot_p VARCHAR2) IS
    SELECT nac.id FROM m_nacpot nac WHERE nac.sifra = nacpot_p;

   CURSOR mt_id_c(mt_p VARCHAR2) IS
    SELECT mt.id FROM m_mt mt WHERE mt.sifra = mt_p;

   id_l          NUMBER;
   naredba_l     VARCHAR2(32000);
   sifra_cvora_l smet_cvorovi.sifra%TYPE;
   nac_id_l      tgas_narudzba.nac_id%TYPE;
   mt_id_daje_l  tgas_narudzba.mt_id_daje%TYPE;
   mt_daje_l     m_mt.sifra%TYPE;
   mt_id_prima_l tgas_narudzba.mt_id_prima%TYPE;
   mt_prima_l    m_mt.sifra%TYPE;
   godina_l      tgas_narudzba.godina%TYPE;
   rbr_l         tgas_narudzba.rbr%TYPE;
BEGIN
  IF pra_zmp_s.oznaka1 ('P0045',mt_daje_p) = 0 THEN
    -- Nedoputen pristup!
    pra_zmp_zaj.vrati_poruku (-20138);
  END IF;       
  
  -- mjesto troka daje
  IF mt_daje_p IS NULL THEN
    IF pra_zmp_zaj.zmppar_vrijednost ('GAS', '1058') <> 'nebitno' THEN
      mt_daje_l := pra_zmp_zaj.zmppar_vrijednost ('GAS', '1058');
    ELSE
      raise_application_error(-20001,'Morate upisati mjesto troka(daje)');
    END IF;    
  ELSE
    mt_daje_l := mt_daje_p;
  END IF;    
  
   OPEN mt_id_c(mt_daje_l);
  FETCH mt_id_c
   INTO mt_id_daje_l;
  CLOSE mt_id_c;
  
  IF mt_id_daje_l IS NULL THEN
     raise_application_error(-20001,'U GAS ne postoji mjesto troka(daje): ' || mt_daje_p);
  END IF;

  -- vri kontrolu i vraa vrijednost vora u sifra_cvora_l
  kontrola_cvora(mt_id_daje_l,sifra_cvora_l);

  -- ako je vor ok dodaje @
  IF sifra_cvora_l IS NOT NULL
  THEN
    sifra_cvora_l := '@' || sifra_cvora_l;
  END IF;
  
  IF mt_prima_p IS NULL THEN
    IF pra_zmp_zaj.zmppar_vrijednost ('GAS', '1059') <> 'nebitno' THEN
      mt_prima_l := pra_zmp_zaj.zmppar_vrijednost ('GAS', '1059');
    ELSE
      raise_application_error(-20001,'Morate upisati mjesto troka(prima)');
    END IF; 
    
  ELSE
    mt_prima_l := mt_prima_p;
  END IF;
  
  -- mjesto troka prima
   OPEN mt_id_c(mt_prima_l);
  FETCH mt_id_c
   INTO mt_id_prima_l;
  CLOSE mt_id_c;
  
  IF mt_id_prima_l IS NULL THEN
    raise_application_error(-20001,'U GAS ne postoji mjesto troka(prima): ' || mt_prima_p);
  END IF;
  godina_l := to_char(datum_p,'YYYY');

  -- nain potronje
   OPEN nac_id_c(nacpot_p);
  FETCH nac_id_c
	INTO nac_id_l;
  CLOSE nac_id_c;

  IF nac_id_l IS NULL AND nacpot_p IS NOT NULL THEN
    raise_application_error(-20001, 'U GAS ne postoji nain potronje: ' || nacpot_p);
  END IF;

  -- provjerava da li zaglavlje postoji, ako ne postoji dodaje
  naredba_l := '
  BEGIN
    SELECT id,rbr
   	  INTO :id,:rbr
      FROM tgas_narudzba' || sifra_cvora_l || '
     WHERE godina      = :godina
       AND mt_id_daje  = :mt_id_daje
       AND mt_id_prima = :mt_id_prima 
       AND datum = :datum 
       AND nac_id = :nac_id_l
       AND ozn_obrade = ''N''
       AND ROWNUM = 1;

  EXCEPTION
    WHEN NO_DATA_FOUND THEN
     :id := gas_zaj.sekvenca' || sifra_cvora_l || '(NULL);

    INSERT INTO tgas_narudzba' || sifra_cvora_l || '
      (id, rbr, godina, mt_id_daje, mt_id_prima, datum, nac_id, opis, opis80, ozn_valjanosti)
    VALUES
      (:id, :rbr, :godina, :mt_id_daje, :mt_id_prima, :datum, :nac_id_l, :opis, null, ''V'');

    SELECT rbr
      INTO :rbr
      FROM tgas_narudzba' || sifra_cvora_l || '
     WHERE id  = :id;
      END;';
  EXECUTE IMMEDIATE naredba_l
    USING IN OUT id_l, IN OUT rbr_l, IN godina_l, IN mt_id_daje_l, IN mt_id_prima_l, IN datum_p, IN nac_id_l, IN orgbr_p;
  nar_id_p := id_l;
  br_dok_p := mt_daje_l || '-' || rbr_l || '_' || mt_prima_l || '-' ||rbr_l;
END;
PROCEDURE INT_NARUDZBA_ART
 (NAR_ID_P IN tgas_narudzba_art.nar_id%TYPE
 ,ART_P IN m_sirovine.sifra%TYPE
 ,KOLICINA_P IN tgas_narudzba_art.kolicina_plan%TYPE
 ,MT_P IN m_mt.sifra%TYPE := null
 )
 IS

   CURSOR sir_id_c(art_p VARCHAR2) IS
     SELECT s.id FROM m_sirovine s WHERE s.sifra = art_p;
   CURSOR nam_id_c(art_p VARCHAR2) IS
     SELECT n.id FROM m_namirnice n WHERE n.sifra = art_p;
   CURSOR pro_id_c(art_p VARCHAR2) IS
     SELECT p.id,
            p.pro_nam_id
       FROM m_proizvodi p
      WHERE p.sifra = art_p;

   CURSOR mt_id_c(mt_p VARCHAR2) IS
     SELECT mt.id FROM m_mt mt WHERE mt.sifra = mt_p;

   naredba_l     VARCHAR2(32000);
   sifra_cvora_l smet_cvorovi.sifra%TYPE;
   verzija_l     s_vlasnik.verzija%TYPE;
   sir_id_l      m_sirovine.id%TYPE;
   nam_id_l      m_namirnice.id%TYPE;
   pro_id_l      m_proizvodi.id%TYPE;
   nam_pro_id_l  m_proizvodi.pro_nam_id%TYPE;
   mt_id_l       tgas_narudzba.mt_id_daje%TYPE;
   mt_l          m_mt.sifra%TYPE;
   st_id_l       tgas_narudzba_art.id%TYPE;
BEGIN
  -- ID sirovine
   OPEN sir_id_c(art_p);
  FETCH sir_id_c
   INTO sir_id_l;
  CLOSE sir_id_c;    
  
  IF sir_id_l IS NULL THEN
    -- ID namirnice
    OPEN nam_id_c(art_p);
   FETCH nam_id_c
    INTO nam_id_l;
   CLOSE nam_id_c;
   
   IF nam_id_l IS NULL THEN  
     -- ID proizvoda
      OPEN pro_id_c(art_p);
     FETCH pro_id_c
      INTO pro_id_l, nam_pro_id_l;
     CLOSE pro_id_c;
    
     -- ako ne postoji arikal
     IF  pro_id_l IS NULL
     THEN   
       raise_application_error(-20001,'U GAS ne postoji artikal: ' || art_p);
     END IF;
    
     IF  nam_pro_id_l IS NULL
     THEN
        raise_application_error(-20002,'U GAS ne postoji kvazi namirnica za artikal: ' || art_p);
     END IF;
   
   END IF;
  END IF;    
  
   -- mjesto troka daje
  IF mt_p IS NULL THEN
    IF pra_zmp_zaj.zmppar_vrijednost ('GAS', '1058') <> 'nebitno' THEN
      mt_l := pra_zmp_zaj.zmppar_vrijednost ('GAS', '1058');
    ELSE
      raise_application_error(-20001,'Morate upisati mjesto troka(daje)');
    END IF;
  ELSE
    mt_l := mt_p;
  END IF;  
  
  -- mjesto troka
  OPEN mt_id_c(mt_l);
  FETCH mt_id_c
	INTO mt_id_l;
  CLOSE mt_id_c;

  -- vri kontrolu i vraa vrijednost vora u sifra_cvora_l
  kontrola_cvora(mt_id_l,sifra_cvora_l);

  -- ifra cvora
  IF sifra_cvora_l IS NOT NULL
  THEN
	sifra_cvora_l := '@' || sifra_cvora_l;
  END IF;

  -- insert stavke
  naredba_l := '
    BEGIN
      SELECT id
        INTO :id
        FROM tgas_narudzba_art' || sifra_cvora_l || '
       WHERE nar_id              = :nar_id
         AND NVL(sir_id,0)       = NVL(:sir_id,0)
         AND NVL(nam_id,0)       = NVL(:nam_id,0)
         AND NVL(pro_id,0)       = NVL(:pro_id,0)
         AND NVL(nam_pro_id, 0)  = NVL(:nam_pro_id, 0);

      UPDATE tgas_narudzba_art ' || sifra_cvora_l || '
         SET kolicina_plan = kolicina_plan + :kolicina
       WHERE id = :id;

     EXCEPTION
     WHEN NO_DATA_FOUND THEN
       :id := gas_zaj.sekvenca' || sifra_cvora_l || '(NULL);  
       
       INSERT INTO tgas_narudzba_art' || sifra_cvora_l || '
           (id, nar_id, sir_id, nam_id, pro_id, nam_pro_id, kolicina_plan)
       VALUES
           (:id, :nar_id, :sir_id, :nam_id, :pro_id, :nam_pro_id, :kolicina);
    END;';
  
  EXECUTE IMMEDIATE naredba_l
	USING IN OUT st_id_l, IN nar_id_p, IN sir_id_l, IN nam_id_l, IN pro_id_l, IN nam_pro_id_l, IN kolicina_p;

END;
PROCEDURE RNKASE
 (KASE_SIFRA_P IN mgmp_kase.sifra%TYPE
 ,RBR_P IN t_rnkase.rbr%TYPE
 ,DATUM_P IN t_rnkase.datum%TYPE
 ,VRIJEME_P IN T_RNKASE.VRIJEME%TYPE
 ,KON_SIFRA_P IN m_konobari.sifra%TYPE
 ,NAC_SIFRA_P IN m_nacpot.sifra%TYPE
 ,VPLA_SIFRA_P IN s_vplacanja.sifra%TYPE
 ,POPUST_P IN t_rnkase.popust%TYPE := 0
 ,OPIS_P IN t_rnkase.opis%TYPE
 ,ZKI_P IN t_rnkase.zastitni_kod%TYPE
 ,JIR_P IN t_rnkase.jir%TYPE
 ,PKAADR_RBR_P IN MPKA_ADRESE.RBR%TYPE
 ,RBR_STORNO_P IN t_rnkase.rbr%TYPE
 ,GODINA_STORNO_P IN t_rnkase.godina%TYPE
 ,RN_ID_P OUT t_rnkase.id%TYPE
 ,VPLA_NAPOJNICE_ID_P IN t_rnkase.vpla_napojnice_id%TYPE
 ,IZN_NAPOJNICE_P IN t_rnkase.izn_napojnice%TYPE
 ,DATUM_NAPOJNICE_P IN t_rnkase.datum_napojnice%TYPE
 )
 IS
-- Koristi se za PSM kase  

  /* Kasa */
  CURSOR kase_id_C (kase_sifra_p VARCHAR2) IS
    SELECT id, zmpojr_id,  metapl_sifra 
      FROM mgmp_kase
     WHERE sifra = kase_sifra_p;

  /* Konobar */
  CURSOR kon_id_C (kase_id_l VARCHAR2, kon_sifra_p VARCHAR2) IS
    SELECT kon.id
      FROM m_kon_kase konkase, m_konobari kon
     WHERE kon.sifra = kon_sifra_p
       AND konkase.kase_id = kase_id_l
       AND konkase.kon_id = kon.id;

  /* Nain potronje */
  CURSOR nac_id_C (kase_id_l VARCHAR2, nac_sifra_p VARCHAR2) IS
    SELECT nac.id
      FROM m_kasa_np kasanp, m_nacpot nac
     WHERE nac.sifra = nac_sifra_p
       AND kasanp.kase_id = kase_id_l
       AND kasanp.nac_id = nac.id;

  /* Nain potronje null */
  CURSOR nac_id_nul_C (kase_id_l VARCHAR2) IS
    SELECT kasanp.nac_id
      FROM m_kasa_np kasanp,
           m_kase kase
     WHERE kasanp.kase_id = kase.id
       AND kase.sifra = kase_sifra_p;

  /* Vrsta plaanja */
  CURSOR vpla_id_C (vpla_sifra_p VARCHAR2) IS
    SELECT id
      FROM s_vplacanja
     WHERE sifra = vpla_sifra_p;

  kase_id_l        mgmp_kase.id%TYPE;
  kon_id_l         m_konobari.id%TYPE;
  nac_id_l         m_nacpot.id%TYPE;
  vpla_id_l        s_vplacanja.id%TYPE;
  oj_id_l          m_mt.id%TYPE;
  id_l             t_rnkase.id%TYPE;
  rn_id_l          t_rnkase.id%TYPE;
  rn_id_storno_l   t_rnkase.id%TYPE;      
  metapl_sifra_l   mgmp_kase.metapl_sifra%TYPE;
  ozn_valjanosti_l t_rnkase.ozn_valjanosti%TYPE;
BEGIN

  -- Provjera ulaznih parametara
  IF kase_sifra_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'blagajna');
  ELSIF rbr_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'redni_broj_rauna');
  ELSIF datum_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'datum');
  ELSIF vpla_sifra_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'vrsta_placanja');
  END IF;

  /* ID Kase i ID OJ */
  OPEN kase_id_C (kase_sifra_p);
  FETCH kase_id_C INTO kase_id_l, oj_id_l, metapl_sifra_l;
  CLOSE kase_id_C;

  IF kase_id_l IS NULL THEN
    RAISE_APPLICATION_ERROR (-20000, 'Ne postoji blagajna sa ifrom ' || kase_sifra_p);
  END IF;

  /* ID Konobara */
  IF kon_sifra_p IS NOT NULL THEN
    OPEN kon_id_C (kase_id_l, kon_sifra_p);
    FETCH kon_id_C INTO kon_id_l;
    CLOSE kon_id_C;
  END IF;

  IF kon_id_l IS NULL THEN
    RAISE_APPLICATION_ERROR (-20000, 'Ne postoji konobar ' || kon_sifra_p || ' za blagajnu ' || kase_sifra_p);
  END IF;

  IF nac_sifra_p IS NOT NULL THEN
    /* Ako kasa radi s nainima potronje */
    OPEN nac_id_C (kase_id_l, nac_sifra_p);
    FETCH nac_id_C INTO nac_id_l;
    CLOSE nac_id_C;
  ELSE
    /* Ako kase ne radi s nainima potronje */
    OPEN nac_id_nul_C (kase_sifra_p);
    FETCH nac_id_nul_C INTO nac_id_l;
    CLOSE nac_id_nul_C;
  END IF;

  IF nac_id_l IS NULL THEN
    RAISE_APPLICATION_ERROR (-20000, 'Ne postoji cjenik ' || nac_sifra_p || ' za blagajnu ' || kase_sifra_p);
  END IF;

  /* ID Vrste plaanja */
  OPEN vpla_id_C (vpla_sifra_p);
  FETCH vpla_id_C INTO vpla_id_l;
  CLOSE vpla_id_C;

  IF vpla_id_l IS NULL THEN
    RAISE_APPLICATION_ERROR (-20000, 'Ne postoji vrsta plaanja sa ifrom ' || vpla_sifra_p);
  END IF;

  IF rbr_storno_p IS NOT NULL THEN
    BEGIN
      SELECT id INTO rn_id_storno_l
        FROM t_rnkase
       WHERE godina  = godina_storno_p
         AND kase_id = kase_id_l
         AND rbr = LPAD (rbr_storno_p, 6, '0');
    EXCEPTION
      WHEN NO_DATA_FOUND THEN
        rn_id_storno_l := NULL;
    END;
  END IF; 

  /* Ako je u parametru GAS '1004' upisano 1, tada se preko oznake valjanosti oznaavaju
     rauni za prijepis u Operu sa PSM, VGE i VFR kasa */        
  IF pra_zmp_zaj.zmppar_vrijednost ('GAS', '1004') = '1' THEN     
     IF metapl_sifra_l IN ('PSM', 'VGE', 'VFR') THEN
        ozn_valjanosti_l := 'P';
     END IF;
  ELSE   
     ozn_valjanosti_l := 'V';
  END IF;
          
 
  INSERT INTO t_rnkase (
      godina, kase_id, rbr, datum,
      kon_id, nac_id, vpla_id, popust, opis,
      vrijeme, ozn_valjanosti, datum_izdavanja, izn_placanja,
      oj_id, zastitni_kod, jir, rn_id,
      vpla_napojnice_id, izn_napojnice, datum_napojnice)
    VALUES (
      TO_CHAR (datum_p, 'YYYY'), kase_id_l, LPAD (rbr_p, 6, '0'), datum_p,
      kon_id_l, nac_id_l, vpla_id_l, NVL (popust_p, 0), opis_p,
      vrijeme_p, ozn_valjanosti_l, datum_p, 0,
      oj_id_l, zki_p, jir_p, rn_id_storno_l,
      vpla_napojnice_id_p, izn_napojnice_p, datum_napojnice_p)
      
    RETURN id INTO rn_id_l;

  rn_id_p := rn_id_l;
END;
PROCEDURE RNKASE_PRO
 (RN_ID_P IN t_rnkase_pro.rn_id%type
 ,RBR_STAVKE_P IN t_rnkase_pro.rbr_stavke%TYPE
 ,PRO_SIFRA_P IN m_proizvodi.sifra%TYPE
 ,CIJENA_P IN t_rnkase_pro.cijena%TYPE
 ,KOLICINA_P IN t_rnkase_pro.kolicina%TYPE
 ,STOPA_PDV_P IN t_rnkase_pro.pdv%TYPE
 ,STOPA_PPOT_P IN t_rnkase_pro.ppot%TYPE
 ,IZNOS_PDV_P IN t_rnkase_pro.iznos%TYPE
 ,IZNOS_PPOT_P IN t_rnkase_pro.iznos%TYPE
 ,IZNOS_POPUST_P IN t_rnkase_pro.iznos%type
 ,IZNOS_P IN t_rnkase_pro.iznos%type
 ,IZNOS_MARZE_P IN t_rnkase_pro.iznos_marze%TYPE
 ,IZNOS_PDV_MARZE_P IN t_rnkase_pro.iznos_pdv_marze%TYPE
 ,STOPA_PDV_MARZE_P IN t_rnkase_pro.stopa_pdv_marze%TYPE
 ,IZNOS_POPUST2_P IN t_rnkase_pro.iznos%type
 )
 IS
/* zajednika procedura za PSM I HNB (vanjsko naruivanje) */  
CURSOR pro_id_C (pro_sifra_p VARCHAR2, datum_p DATE, kase_id_l NUMBER, nac_id_l NUMBER) IS
  SELECT pro.id pro_id,
         pro.gpor_id,
         pro.gknji_id,
         pro.gtehpro_id,
         vpispp.vpispz_id,
         pro.zad_nab_cijena,
         pro.pros_nab_cijena,
         (SELECT asokase.mt_id 
            FROM m_aso_kase asokase 
           WHERE asokase.kase_id = kase_id_l
             AND asokase.nac_id  = nac_id_l
             AND asokase.pro_id(+)  = pro.id) mt_id   
    FROM m_proizvodi pro,
         m_gporez gpor,
         mgas_gpor_raz gporraz,
         s_vpisporukap vpispp,
         s_vpisporukaz vpispz
   WHERE pro.sifra = pro_sifra_p
     AND pro.gpor_id   = gpor.ID
     AND gpor.ID = gporraz.gpor_id
     AND datum_p BETWEEN gporraz.dat_valjan AND NVL(gporraz.dat_ponisten, SYSDATE)
     AND gporraz.vpispp_id   = vpispp.id
     AND vpispp.vpispz_id   = vpispz.id;
         
 CURSOR rn_id_c (rn_id_p NUMBER) IS
   SELECT rn.kase_id,  rn.datum, rn.nac_id 
     FROM t_rnkase rn, mgmp_kase kase
    WHERE rn.id = rn_id_p
      AND kase.id = rn.kase_id ;

 CURSOR mt_id_c (kase_id_p NUMBER, nac_id_p NUMBER) IS
 SELECT MIN(mtkase.mt_id) 
   FROM m_mt_kase mtkase,
        m_mt_np mtnp,
        m_mt mt
  WHERE mtkase.kase_id  = kase_id_p
    AND mtnp.nac_id = nac_id_p
    AND mtkase.mt_id = mtnp.mt_id;
 
 CURSOR rnkase_pro_id_c (rn_id_p NUMBER, rbr_stavke_p VARCHAR2) IS
 SELECT rbr_stavke
   FROM t_rnkase_pro
  WHERE rn_id = rn_id_p
    AND rbr_stavke =  rbr_stavke_P;

  pro_id_l          t_rnkase_pro.pro_id%type;
  gpor_id_l         t_rnkase_pro.gpor_id%type;
  gknji_id_l        t_rnkase_pro.gknji_id%TYPE;
  gtehpro_id_l      t_rnkase_pro.gtehpro_id%TYPE;
  mt_id_l           m_mt.id%type;
  vpispz_id_l       t_rnkase_pro.vpispz_id%type;
  pros_nab_cijena_l m_proizvodi.pros_nab_cijena%type;
  zad_nab_cijena_l  m_proizvodi.zad_nab_cijena%type;
  kase_id_l         t_rnkase.kase_id%TYPE;
  kase_l            mgmp_kase.sifra%TYPE;
  nac_id_l          t_rnkase.nac_id%TYPE;
  datum_l           t_rnkase.datum%TYPE;
  id_l              t_rnkase_pro.id%TYPE;
  rn_id_l           t_rnkase_pro.rn_id%TYPE;
BEGIN         
  IF rn_id_p IS NULL THEN
     RAISE_APPLICATION_ERROR (-20202, pra_zmp_zaj.poruka ('PKA', '-20202', 'rn_id_p'));
  END IF; 
  IF pro_sifra_p IS NULL THEN
     RAISE_APPLICATION_ERROR (-20202, pra_zmp_zaj.poruka ('PKA', '-20202', 'pro_sifra_p'));
  END IF;      
  IF cijena_p IS NULL THEN
     RAISE_APPLICATION_ERROR (-20202, pra_zmp_zaj.poruka ('PKA', '-20202', 'cijena_p'));
  END IF;                  
  IF kolicina_p IS NULL THEN
     RAISE_APPLICATION_ERROR (-20202, pra_zmp_zaj.poruka ('PKA', '-20202', 'kolicina_p'));
  END IF;
  
  OPEN rn_id_c (rn_id_p);
    FETCH rn_id_c INTO kase_id_l, datum_l,  nac_id_l; 
  CLOSE rn_id_c;
  
  OPEN pro_id_c (pro_sifra_p,  datum_l, kase_id_l, nac_id_l);
    FETCH pro_id_c INTO  pro_id_l, gpor_id_l, gknji_id_l, gtehpro_id_l, vpispz_id_l, zad_nab_cijena_l, pros_nab_cijena_l, mt_id_l;
  CLOSE pro_id_c;

  IF pro_id_l IS NULL THEN
    RAISE_APPLICATION_ERROR (-20000, 'Ne postoji proizvod sa ifrom ' || pro_sifra_p);
  END IF; 
  
  IF mt_id_l IS NULL THEN
     OPEN mt_id_c (kase_id_l, nac_id_l);
       FETCH mt_id_c INTO mt_id_l;
     CLOSE mt_id_c;
  END IF;
            
  IF mt_id_l IS NULL THEN
     RAISE_APPLICATION_ERROR (-20000, 'Blagajna nije povezana sa mjestom troka');
  END IF;         
  
  /*  Radi nepoznatog problema oko vraanja odgovora i viestrukog slanja narudbi HTTP status 555 - RN 
      insert radimo ako nema stavaka rauna */
  OPEN rnkase_pro_id_c  (rn_id_p, LPAD(rbr_stavke_P, 4, '0'));
    FETCH rnkase_pro_id_c  INTO rn_id_l;
    IF rnkase_pro_id_c%FOUND THEN
       CLOSE rnkase_pro_id_c;
       RETURN; 
    END IF;   
  CLOSE rnkase_pro_id_c;
  
  id_l := gas_zaj.sekvenca (NULL); 
  
  INSERT INTO t_rnkase_pro
    (id,rn_id, rbr_stavke, pro_id, sifgr_id, gpor_id, gknji_id, gtehpro_id, mt_id,
     kolicina, cijena, pdv, ppot, iznos_popust, 
     iznos, iznos_pdv, iznos_ppot, zad_nab_cijena, pros_nab_cijena,
     vpispz_id, iznos_marze, iznos_pdv_marze, stopa_pdv_marze, iznos_popust2)
  VALUES
    (id_l, rn_id_p, LPAD(rbr_stavke_P, 4, '0'), pro_id_l, NULL, gpor_id_l, gknji_id_l, gtehpro_id_l, mt_id_l,
     kolicina_p, cijena_p, stopa_pdv_p, stopa_ppot_p, NVL(iznos_popust_p,0),
     iznos_p, iznos_pdv_p, iznos_ppot_P, zad_nab_cijena_l, pros_nab_cijena_l,
     vpispz_id_l, NVL(iznos_marze_p,0), NVL(iznos_pdv_marze_p,0), NVL(stopa_pdv_marze_p,0),NVL(iznos_popust2_p,0));
  
  /* azurira izn_placanja iz iznosa stavaka u T_RNKASE za isti rn_id_p  */
  UPDATE t_rnkase  
     SET izn_placanja = izn_placanja + iznos_p
   WHERE id = rn_id_p;
 
END;
PROCEDURE UPISI_PTV
 (SIFRA_SUSTAVA_P IN m_proizvodi.sifra%TYPE
 ,SIFRA_KASE_P IN mgmp_kase.sifra%TYPE
 ,DATUM_P IN t_rnkase.datum%TYPE
 ,SIFRA_PROIZVODA_P IN m_proizvodi.sifra%TYPE
 ,KOLICINA_P IN t_rnkase_pro.kolicina%TYPE
 ,IZNOS_P IN t_rnkase_pro.iznos%TYPE
 )
 IS

 CURSOR gmpkas_c (sifra_kase_p  VARCHAR) IS
 SELECT gmpkas.id, metcvor_sifra_gas
   FROM mgmp_kase gmpkas,
        mzmp_ojr  zmpojr
  WHERE gmpkas.metapl_sifra IN ( 'PTV', 'MIC')
    AND gmpkas.sifra = sifra_kase_p
    AND gmpkas.zmpojr_id = zmpojr.id
    AND TRUNC (datum_p) BETWEEN gmpkas.dat_valjan AND (NVL (gmpkas.dat_ponisten, TO_DATE ('31.12.9999', 'DD.MM.RRRR')) - 1)
  ORDER BY gmpkas.sifra;

 CURSOR kon_c (gmpkas_id_l NUMBER) IS 
 SELECT konkase.kon_id  
   FROM m_kon_kase konkase
  WHERE konkase.kase_id = gmpkas_id_l;

 CURSOR nac_c (gmpkas_id_l NUMBER) IS
 SELECT kasanp.nac_id
   FROM m_kasa_np kasanp,
        m_nacpot  nac
  WHERE kasanp.kase_id = gmpkas_id_l
    AND kasanp.nac_id = nac.id
  ORDER BY nac.sifra;

 CURSOR vpla_c (nac_id_l NUMBER) IS
 SELECT nacvpla.vpla_id
   FROM m_nac_vpla  nacvpla,
        s_vplacanja vpla
  WHERE nacvpla.nac_id = nac_id_l
    AND nacvpla.vpla_id = vpla.id
    AND vpla.ozn_irn IS NULL
  ORDER BY vpla.sifra;

CURSOR pro_c (sifra_proizvoda_P VARCHAR) IS 
 SELECT pro.id 
   FROM m_proizvodi   pro
  WHERE sif_proizvoda_kasa = sifra_proizvoda_p; 

 CURSOR sif_grupa_c (sifra_proizvoda_P VARCHAR) IS 
 SELECT sif.id 
   FROM m_sif_grupa   sif
  WHERE sif_proizvoda_kasa = sifra_proizvoda_p; 


 CURSOR pro1_c (sifra_proizvoda_P VARCHAR) IS
 SELECT gknji_id, gtehpro_id, pro.gpor_id, gknji.naz_dodatni,
        zad_nab_cijena, pros_nab_cijena, vpispp.vpispz_id
   FROM m_proizvodi   pro,
        m_gknjigo     gknji,
        m_gporez      gpor,
        mgas_gpor_raz gporraz,
        s_vpisporukap vpispp,
        s_vpisporukaz vpispz
  WHERE sif_proizvoda_kasa = sifra_proizvoda_p
    AND pro.gknji_id = gknji.id
    AND pro.gpor_id  = gpor.id
    AND gpor.id = gporraz.gpor_id
    AND datum_p BETWEEN gporraz.dat_valjan AND NVL(gporraz.dat_ponisten, SYSDATE)
    AND gporraz.vpispp_id = vpispp.id
    AND vpispp.vpispz_id = vpispz.id;

CURSOR sifgr1_c (sifra_proizvoda_P VARCHAR) IS
 SELECT gknji_id, gtehpro_id, sifgr.gpor_id, gknji.naz_dodatni,
       0, 0, vpispp.vpispz_id
   FROM m_sif_grupa  sifgr,
        m_gknjigo     gknji,
        m_gporez      gpor,
        mgas_gpor_raz gporraz,
        s_vpisporukap vpispp,
        s_vpisporukaz vpispz
  WHERE sif_proizvoda_kasa = sifra_proizvoda_p
    AND sifgr.gknji_id = gknji.id
    AND sifgr.gpor_id  = gpor.id
    AND gpor.id = gporraz.gpor_id
    AND datum_p BETWEEN gporraz.dat_valjan AND NVL(gporraz.dat_ponisten, SYSDATE)
    AND gporraz.vpispp_id = vpispp.id
    AND vpispp.vpispz_id = vpispz.id;





 /* za ALH eme povezuje se vrsta mjesta troka i dodatni naziv iz knjigovodstvene grupe
   ako ne uspije na taj nain uzima se prvo mjesto troka koje nije trgovina 
   na trgovinu ne smiju doi proizvodi tipa usluge 
   na ovaj nain se izbjegava unos asortimana u GAS
 */
 CURSOR mt_kase_min_C (gmpkas_id_l NUMBER) IS
 SELECT mtkase2.mt_id
   FROM m_mt_kase mtkase2
  WHERE mtkase2.id = (
        SELECT MIN(mtkase1.id)
          FROM m_mt_kase mtkase1, m_mt mt
         WHERE mtkase1.kase_id = (gmpkas_id_l)
           AND mtkase1.mt_id = mt.id
           AND mt.vrsta <> 'U'); 

 CURSOR mt_kase_C (gmpkas_id_l NUMBER, gknji_naz_dod_l  VARCHAR2) IS
 SELECT mt.id   
   FROM m_mt_kase mtk, 
        m_mt mt
  WHERE mt.id = mtk.mt_id
	AND mtk.kase_id = gmpkas_id_l
    AND mt.vrsta = gknji_naz_dod_l ;

 CURSOR gas_c IS
 SELECT COUNT(*)  
   FROM smet_instalacije
  WHERE metapl_sifra = 'GAS';

 gmpkas_id_l       mgmp_kase.id%TYPE;
 zmpojr_id_l       mgmp_kase.zmpojr_id%TYPE;
 kon_id_l          m_konobari.id%TYPE;
 nac_id_l          m_konobari.id%TYPE;
 pro_id_l          m_proizvodi.id%TYPE;
 sifgr_id_l       m_sif_grupa.id%TYPE;
 vpla_id_l         s_vplacanja.id%TYPE;
 gknji_id_l        m_gknjigo.id%TYPE;
 gtehpro_id_l      m_gtehpro.id%TYPE;
 gpor_id_l         m_gtehpro.id%TYPE;
 sifra_cvora_l     smet_cvorovi.sifra%TYPE;
 rn_id_l           t_rnkase.id%TYPE;
 gknji_naz_dod_l   m_gknjigo.naz_dodatni%TYPE;
 mt_id_l           p_rnkase_pro.mt_id%TYPE;
 mt_id_min_l       p_rnkase_pro.mt_id%TYPE;
 pdv_l             p_rnkase_pro.pdv%TYPE;
 ppot_l            p_rnkase_pro.ppot%TYPE;
 zad_nab_cijena_l  t_rnkase_pro.zad_nab_cijena%TYPE;
 pros_nab_cijena_l t_rnkase_pro.zad_nab_cijena%TYPE;
 naredba_l         VARCHAR2(32000);
 vpispz_id_l       t_rnkase_pro.vpispz_id%type;
 godina_l          VARCHAR(4);
 kolicina_l      t_rnkase_pro.kolicina%TYPE;
 cijena_l          t_rnkase_pro.cijena%TYPE;
 iznos_pdv_l       t_rnkase_pro.iznos_pdv%TYPE;
 iznos_ppot_l      t_rnkase_pro.iznos_ppot%TYPE;
 rbr_stavke_l      t_rnkase_pro.rbr_stavke%TYPE;
 rbr_l             t_rnkase.rbr%TYPE;
 brojac_l          NUMBER;
 request_l         VARCHAR2(40);
BEGIN   
  /* ALH koristi za PAY-TY i Simfony kase 
  */ 
    
  /* Nedostaje obvezan ulazni parametar (#0). 
  */
  
  request_l := 'Request  '  || TO_CHAR (SYSDATE, 'DD.MM.RRRR HH24:MI:SS');
  
  IF sifra_sustava_p  IS NULL THEN
    RAISE_APPLICATION_ERROR (-20202, pra_zmp_zaj.poruka ('PKA', '-20202', 'sifra_sustava_p '));
  ELSIF sifra_kase_p  IS NULL THEN
    RAISE_APPLICATION_ERROR (-20202, pra_zmp_zaj.poruka ('PKA', '-20202', 'sifra_kase_p '));
  ELSIF sifra_proizvoda_p  IS NULL THEN
    RAISE_APPLICATION_ERROR (-20202, pra_zmp_zaj.poruka ('PKA', '-20202', 'sifra_proizvoda_p '));
  ELSIF kolicina_p IS NULL  THEN
    RAISE_APPLICATION_ERROR (-20202, pra_zmp_zaj.poruka ('PKA', '-20202', 'kolicina_p'));
  ELSIF datum_p IS NULL THEN
    RAISE_APPLICATION_ERROR (-20202, pra_zmp_zaj.poruka ('PKA', '-20202', 'datum_p'));
  ELSIF iznos_p IS NULL THEN
    RAISE_APPLICATION_ERROR (-20202, pra_zmp_zaj.poruka ('PKA', '-20202', 'iznos_p'));
  END IF;

  OPEN gmpkas_c (sifra_kase_p);
  FETCH gmpkas_c INTO gmpkas_id_l, sifra_cvora_l ;
  CLOSE gmpkas_c;

  OPEN gas_c;
  FETCH gas_c INTO brojac_l;
  CLOSE gas_c;

  IF brojac_l > 1 AND sifra_cvora_l IS NOT NULL THEN
    sifra_cvora_l := '@' || sifra_cvora_l;
  ELSE 
    sifra_cvora_l := NULL;
  END IF;

  IF gmpkas_id_l IS NULL THEN
    RAISE_APPLICATION_ERROR (-20001, 'Ne postoji kasa '||sifra_kase_p );
  END IF;

  OPEN nac_c (gmpkas_id_l);
  FETCH nac_c INTO nac_id_l;
  CLOSE nac_c;

  IF nac_id_l IS NULL THEN
    RAISE_APPLICATION_ERROR (-20001, 'Ne postoji nain potronje');
  END IF;

  OPEN kon_c (gmpkas_id_l);
  FETCH kon_c INTO kon_id_l;
  CLOSE kon_c;

  IF kon_id_l IS NULL THEN
    RAISE_APPLICATION_ERROR (-20001, 'Ne postoji konobar');
  END IF;

  OPEN vpla_c (nac_id_l);
  FETCH vpla_c INTO vpla_id_l;
  CLOSE vpla_c;

  IF vpla_id_l IS NULL THEN
    RAISE_APPLICATION_ERROR (-20001, 'Ne postoji vrsta plaanja');
  END IF;

  OPEN pro_c (sifra_proizvoda_p);
  FETCH pro_c INTO pro_id_l;
  CLOSE pro_c;
  
  IF pro_id_l IS NULL THEN   
     OPEN sif_grupa_c (sifra_proizvoda_p);
    FETCH sif_grupa_c INTO sifgr_id_l;
    CLOSE sif_grupa_c;    
  END IF;
           
  IF pro_id_l IS NULL AND sifgr_id_l IS NULL THEN                                                         
     RAISE_APPLICATION_ERROR (-20001, 'Ne postoji proizvod:' ||sifra_proizvoda_p);    
  END IF;  
  
  IF pro_id_l IS NOT NULL THEN      
     OPEN pro1_c (sifra_proizvoda_p);
     FETCH pro1_c INTO gknji_id_l, gtehpro_id_l, gpor_id_l, gknji_naz_dod_l, zad_nab_cijena_l, pros_nab_cijena_l, vpispz_id_l;
     CLOSE pro1_c;
  ELSE
     OPEN sifgr1_c (sifra_proizvoda_p);
     FETCH sifgr1_c INTO gknji_id_l, gtehpro_id_l, gpor_id_l, gknji_naz_dod_l, zad_nab_cijena_l, pros_nab_cijena_l, vpispz_id_l;
     CLOSE sifgr1_c;
  END IF;
  

  IF gpor_id_l IS NULL THEN
    RAISE_APPLICATION_ERROR (-20001, 'Proizvod nije vezan za poreznu grupu');
  END IF;

  /* Samo za ALH sheme MT se trai na ovaj nain, ALH ne radi sa asortimanima kase. 
     Za ostale korisnike bi trebalo itati M_ASO_KASE 
  */
  OPEN mt_kase_C (gmpkas_id_l, gknji_naz_dod_l);
  FETCH mt_kase_C INTO mt_id_l;
  CLOSE mt_kase_C;

  /* ako se ne nae mjesto troka preko poveznice: vrste MT i naz_dodatni(M_GKNJGO)
     uzima se bilo koje mjesto troka koje je vezano za kasu a da nije vrste trgovina
   */
  IF mt_id_l IS NULL THEN
     OPEN mt_kase_min_C (gmpkas_id_l);
     FETCH mt_kase_min_C INTO mt_id_l;
     CLOSE mt_kase_min_C;
  END IF;

  IF mt_id_l IS NULL THEN
     RAISE_APPLICATION_ERROR (-20001, 'Kasa nije povezana za mjesto troka');
  END IF;
  
   /* radi se o stornu na isti dan */
  IF kolicina_p = 0 AND iznos_p = 0 THEN
     GOTO kraj;
  END IF;
  
  gas_zaj.porezi (gpor_id_l, datum_p, pdv_l, ppot_l);
  godina_l := TO_CHAR(datum_p, 'YYYY');

   naredba_l :=
    'BEGIN
       SELECT id
         INTO :id
         FROM t_rnkase'|| sifra_cvora_l || '
        WHERE godina  = :godina
          AND kase_id = :kase_id
          AND datum   = TRUNC(:datum);
     EXCEPTION 
     WHEN NO_DATA_FOUND THEN   
        SELECT NVL(MAX(TO_NUMBER(rbr)),0) 
          INTO :rbr
          FROM t_rnkase'|| sifra_cvora_l || '
         WHERE godina  = :godina
         AND kase_id = :kase_id;
       
        :id := gas_zaj.sekvenca'|| sifra_cvora_l || '(NULL);
      
      INSERT INTO t_rnkase'|| sifra_cvora_l || '
        (id, godina, kase_id, rbr, datum, kon_id, nac_id, vpla_id,
         vrijeme, ozn_valjanosti, datum_izdavanja, popust, izn_placanja)
      VALUES
         (:id, :godina, :kase_id, LPAD (TO_CHAR (:rbr + 1), 6, ''0''), :datum, :kon_id, :nac_id, :vpla_id, 
         TO_CHAR(SYSDATE,''HH24MI''), ''V'', :datum, 0, 0);
     WHEN OTHERS THEN
        RAISE;      
     END;';

  EXECUTE IMMEDIATE naredba_l  USING IN OUT rn_id_l,IN godina_l, IN gmpkas_id_l, IN datum_p, IN OUT rbr_l, IN kon_id_l, IN nac_id_l, IN vpla_id_l;

  naredba_l :=
    'BEGIN
       SELECT count(*)
         INTO :rbr_stavke
         FROM t_rnkase_pro'|| sifra_cvora_l || '
        WHERE rn_id = :rn_id;
     END;';
  EXECUTE IMMEDIATE naredba_l  USING IN OUT rbr_stavke_l, rn_id_l;
     
     
  
  iznos_pdv_l  := ROUND (iznos_p * pdv_l / (100 + pdv_l + ppot_l), 2);
  iznos_ppot_l := ROUND (iznos_p * ppot_l / (100 + ppot_l + pdv_l), 2);
  kolicina_l   := kolicina_p;
     
  IF kolicina_p <> 0 THEN   
     cijena_l := ROUND(iznos_p / kolicina_p, 2); 
  ELSE
     cijena_l := ABS(iznos_p);
  END IF;             
  
  IF kolicina_p = 0 THEN
     IF iznos_p <= 0 THEN  
        kolicina_l := 1; 
     ELSE   
        kolicina_l := -1;
     END IF;   
  END IF;
     
  /* Ako postoji storno nad istim proizvodom koliina je 0, pa se razdvaja na dva retka sa
     + i - koliinom
  */    
  IF kolicina_p = 0 AND iznos_p <> 0 THEN   
     naredba_l :=
      'BEGIN
         INSERT INTO t_rnkase_pro' || sifra_cvora_l || '
           (rn_id, rbr_stavke, pro_id, sifgr_id, gpor_id, gknji_id, gtehpro_id,
            mt_id, kolicina, cijena, pdv, ppot, iznos_popust, iznos, iznos_pdv,
            iznos_ppot, zad_nab_cijena, pros_nab_cijena, vpispz_id)
         VALUES
           (:rn_id, NVL(:rbr_stavke_l,0) + 1, :pro_id, :sifgr_id, :gpor_id, :gknji_id, :gtehpro_id,
            :mt_id, :kolicina, 0, :stopa_pdv, :stopa_ppot, 0, 0, 0,
            0, :zad_nab_cijena, :pros_nab_cijena, :vpispz_id);
       EXCEPTION
         WHEN OTHERS THEN RAISE;
       END;';
     EXECUTE IMMEDIATE naredba_l
     USING IN OUT rn_id_l, rbr_stavke_l, pro_id_l, sifgr_id_l, gpor_id_l, gknji_id_l, gtehpro_id_l,
                  mt_id_l, kolicina_l, pdv_l, ppot_l, 
                  zad_nab_cijena_l, pros_nab_cijena_l, vpispz_id_l;  
  
     rbr_stavke_l := rbr_stavke_l + 1;
     kolicina_l := kolicina_l * -1;
  END IF;
  
  naredba_l :=
    'BEGIN
       INSERT INTO t_rnkase_pro' || sifra_cvora_l || '
         (rn_id, rbr_stavke, pro_id, sifgr_id, gpor_id, gknji_id, gtehpro_id, mt_id,
         kolicina, cijena, pdv, ppot, iznos_popust, iznos, iznos_pdv,
         iznos_ppot, zad_nab_cijena, pros_nab_cijena, vpispz_id)
       VALUES
         (:rn_id, NVL(:rbr_stavke_l,0) + 1, :pro_id, :sifgr_id, :gpor_id, :gknji_id, :gtehpro_id, :mt_id,
          DECODE(:kolicina, 0, 1, :kolicina), :cijena, :stopa_pdv, :stopa_ppot, 0, :iznos, :iznos_pdv,
          :iznos_ppot, :zad_nab_cijena, :pros_nab_cijena, :vpispz_id); 
     EXCEPTION
         WHEN OTHERS THEN RAISE;
     END;';     
     
  EXECUTE IMMEDIATE naredba_l
  USING IN OUT rn_id_l, rbr_stavke_l, pro_id_l, sifgr_id_l, gpor_id_l, gknji_id_l, gtehpro_id_l, mt_id_l,
               kolicina_l, cijena_l, pdv_l, ppot_l, iznos_p, iznos_pdv_l,
               iznos_ppot_l, zad_nab_cijena_l, pros_nab_cijena_l, vpispz_id_l;

  /* aurira se izn_placanja u zaglavlju (samo jedna vrsta plaanja) */
  naredba_l :=
    'BEGIN
       UPDATE t_rnkase ' || sifra_cvora_l || '
          SET izn_placanja = izn_placanja + :iznos
        WHERE id = :id;
     END;';
  EXECUTE IMMEDIATE naredba_l USING IN iznos_p, IN OUT rn_id_l;
  
  << kraj >> NULL; 
 EXCEPTION
    WHEN OTHERS THEN 
      pra_pka2.clob_to_table (
        'Procedura - UPISI_PTV ' || CHR(10)|| request_l || CHR(10)|| 'ifra sustava - ' || sifra_sustava_p || CHR(10)|| 'ifra kase - ' || sifra_kase_p 
        || CHR(10)||'ifra proizvoda - ' || sifra_proizvoda_p || CHR(10)|| 'Koliina - ' || kolicina_p || CHR(10) || 'Datum - ' || datum_p 
        || CHR(10) || 'Iznos - ' || iznos_p  || CHR(10)|| 'Greka - '|| SUBSTR (SQLERRM, 1, 200)|| CHR(10) , 'ApiGas - ' || TO_CHAR (SYSDATE, 'RRRR-MM-DD')|| '.log', NULL, 'APIGAS');
    RAISE;
END;
PROCEDURE ISRT_SIROVINE
 (SIFRA_P IN m_sirovine.sifra%TYPE
 ,NAZIV_P IN m_sirovine.naziv%TYPE
 ,JM_P IN m_sirovine.jm_dobavljaca%TYPE
 ,EAN_KOD_P IN m_sirovine.ean_kod%TYPE
 ,DAT_VALJAN_P IN m_sirovine.dat_ponisten%TYPE
 )
 IS

  CURSOR gteh_id_c IS
    SELECT MIN(id) FROM m_gtehsir;
    
  CURSOR sir_id_c (naziv_p VARCHAR2)IS
    SELECT s.sifra FROM m_sirovine s
     WHERE s.naziv = naziv_p;    

  CURSOR jm_c (jm_p VARCHAR2) IS
    SELECT jm.sifra
      FROM m_jm jm
     WHERE upper(jm.sifra) = upper(jm_p);

  gtehsir_id_l   m_sirovine.gtehsir_id%TYPE;
  jm_l           m_jm.sifra%TYPE;
  sifra_l        m_sirovine.sifra%TYPE;
BEGIN 
    -- da se poruke greke vraaju bez vrste greke 
   pra_zmp_zaj.dodaj_por_vrsta_g := 0;
   
   IF pra_zmp_s.oznaka ('P0049') = 0 THEN
    -- Nedopusten pristup!
    pra_zmp_zaj.vrati_poruku (-20138);
  END IF;

  IF pra_zmp_zaj.centar = 0
  THEN
     -- Samo centar aurira po mrei
    pra_zmp_zaj.vrati_poruku (-20142);
  END IF;
  
   -- Pogresna vrijednost ulaznog parametra (#0)!
  IF sifra_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'sifra');
  ELSIF naziv_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'naziv');
  ELSIF jm_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'jm');
  END IF; 

   -- kontrola postojanja sirovine istog naziva
   OPEN sir_id_c (naziv_p);
  FETCH sir_id_c
     INTO sifra_l;
  CLOSE sir_id_c;

  IF sifra_l IS NOT NULL THEN
    -- Ve postoji #0: #1
    pra_zmp_zaj.vrati_poruku (-20144, 'sirovina', sifra_l);
  END IF;
    
  -- JM
   OPEN jm_c (jm_p);
  FETCH jm_c
   INTO jm_l;
  CLOSE jm_c;
  
  IF jm_l IS NULL THEN
    -- Ne postoji #0: #1
    pra_zmp_zaj.vrati_poruku (-20143, 'JM', jm_l);
  END IF;
  
  -- ID tehnoloske grupe
   OPEN gteh_id_c;
  FETCH gteh_id_c
   INTO gtehsir_id_l;
  CLOSE gteh_id_c;
  
  BEGIN
  
    INSERT INTO m_sirovine
      (sifra, naziv,naz_dodatni,gtehsir_id ,jm_dobavljaca,jm ,odnos_jm_b,odnos_jm_n ,ozn_valjanosti,ean_kod, dat_valjan)
    VALUES
      (sifra_p, naziv_p,'?',gtehsir_id_l,jm_l,jm_l,1,1,'N',ean_kod_p, nvl(dat_valjan_p,trunc(SYSDATE)));
  EXCEPTION
    WHEN dup_val_on_index THEN  
      -- Ve postoji #0: #1
      pra_zmp_zaj.vrati_poruku (-20144, 'sirovina', sifra_p);
    WHEN OTHERS THEN   
      -- Greka kod dodavanja #0: #1
      pra_zmp_zaj.vrati_poruku (-20145, 'sirovine', sifra_p);
  END;
END;
PROCEDURE UPD_SIROVINE
 (SIFRA_P IN m_sirovine.sifra%TYPE
 ,NAZIV_P IN m_sirovine.naziv%TYPE
 ,JM_P IN m_sirovine.jm_dobavljaca%TYPE
 ,EAN_KOD_P IN m_sirovine.ean_kod%TYPE
 ,DAT_PONISTEN_P IN m_sirovine.dat_ponisten%TYPE
 )
 IS

  CURSOR jm_c (jm_p VARCHAR2)IS
    SELECT jm.sifra
      FROM m_jm jm 
     WHERE upper(jm.sifra) = upper(jm_p); 

  CURSOR sir_id_c (naziv_p VARCHAR2)IS
    SELECT s.sifra FROM m_sirovine s
     WHERE s.naziv = naziv_p; 

  id_l m_sirovine.id%TYPE;
  jm_l m_jm.sifra%TYPE;
  sifra_l  m_sirovine.sifra%TYPE;
BEGIN     
    -- da se poruke greke vraaju bez vrste greke 
   pra_zmp_zaj.dodaj_por_vrsta_g := 0;
   
   IF pra_zmp_s.oznaka ('P0049') = 0 THEN
    -- Nedopusten pristup!
    pra_zmp_zaj.vrati_poruku (-20138);
  END IF; 

   -- Pogresna vrijednost ulaznog parametra (#0)!
  IF sifra_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'sifra');
  ELSIF naziv_p IS NULL AND jm_p IS NULL AND ean_kod_p IS NULL THEN
     pra_zmp_zaj.vrati_poruku (-20099, 'svi');
  END IF; 
 
  IF pra_zmp_zaj.centar = 0
  THEN
     -- Samo centar aurira po mrei
    pra_zmp_zaj.vrati_poruku (-20142);
  END IF;
  
  IF naziv_p IS NOT NULL THEN
    -- kontrola postojanja sirovine istog naziva
     OPEN sir_id_c (naziv_p);
    FETCH sir_id_c
     INTO sifra_l;
    CLOSE sir_id_c;

    IF sifra_l IS NOT NULL AND sifra_l <> sifra_p THEN
      -- Ve postoji #0: #1
      pra_zmp_zaj.vrati_poruku (-20144, 'sirovina', sifra_l);
    END IF;
  END IF;
  -- kontrola JM
  IF jm_p IS NOT NULL THEN

    OPEN jm_c (jm_p);
    FETCH jm_c
      INTO jm_l;
    CLOSE jm_c;
    
    IF jm_l IS NULL THEN
      -- Ne postoji #0: #1
      pra_zmp_zaj.vrati_poruku (-20143, 'JM', jm_l);
    END IF;
  END IF;  
  
  BEGIN
    SELECT id INTO id_l FROM m_sirovine sir WHERE sir.sifra = sifra_p;

   UPDATE m_sirovine
       SET naziv         = NVL(naziv_p, naziv),
           ean_kod       = NVL(ean_kod_p, ean_kod),
           jm_dobavljaca = NVL(jm_l, jm_dobavljaca),
           jm            = NVL(jm_l, jm),
           dat_ponisten  = dat_ponisten_p 
     WHERE id = id_l;
  EXCEPTION
    WHEN no_data_found THEN 
      -- Ne postoji #0: #1
      pra_zmp_zaj.vrati_poruku (-20143, 'sirovina', sifra_p);
    WHEN OTHERS THEN
      -- Greka kod auriranja #0: #1
      pra_zmp_zaj.vrati_poruku (-20146, 'sirovine', sifra_p);  END;
END;
PROCEDURE PROVJERI_PSM
 (SIFRA_KASE_P IN MGMP_KASE.SIFRA%TYPE
 )
 IS
brojac_l NUMBER := 0;
   greska_l VARCHAR2 (2000);
BEGIN
   /* Na emi provjerava sve kase PSM kase bez obzira koja se uitava
   */           
   IF sifra_kase_p IS NULL THEN  
    RAISE_APPLICATION_ERROR (-20000, '   ifra kase je prazna.');
   END IF;
   
   /* provjera postoji li asortiman kase standardnih proizvoda */ 
   SELECT count(*) INTO brojac_l
     FROM m_kase kase,
          m_aso_kase asokase
    WHERE kase.sifra = sifra_kase_p
      AND kase.id = asokase.kase_id;
   
   IF brojac_l = 0 THEN
      SELECT count(*) INTO brojac_l
        FROM m_kase kase,
             m_aso_kase_grupe asokase
       WHERE kase.sifra = sifra_kase_p
         AND kase.id = asokase.kase_id;
   END IF;  
   
   IF brojac_l = 0 THEN
      RAISE_APPLICATION_ERROR (-20000, '  Za kasu ' || sifra_kase_p ||' ne postoji asortiman.');
   END IF;       
            
            
   /* provjera postoji li vie od 1 naina potronje na mobilnoj kasi */
   FOR c IN (
      SELECT kase.sifra sifra
        FROM m_kasa_np kasanp,
             mgmp_kase kase
       WHERE kase.metapl_sifra = 'PSM'
         AND kase.id = kasanp.kase_id
         AND kase.sifra = sifra_kase_p
       GROUP BY kase.sifra
      HAVING count(*) <>  1)
   LOOP
      greska_l := greska_l ||' '||c.sifra;
   END LOOP;
   IF greska_l IS NOT NULL THEN
      RAISE_APPLICATION_ERROR (-20000, '  Mobilna kasa '||greska_l||' mora imati samo 1 nain potronje.');
   END IF;
   greska_l := NULL;

   /* provjera imaju li proizvodi upisan kratki naziv za orderman */
   FOR c IN (
      SELECT DISTINCT(kase.sifra) sifra
        FROM m_aso_kase asokase,
             m_proizvodi pro,
             mgmp_kase kase 
       WHERE asokase.kase_id = kase.id
         AND kase.metapl_sifra = 'PSM'
         AND asokase.pro_id = pro.id  
         AND kase.sifra = sifra_kase_p
         AND pro.naz_kod IS NULL)
   LOOP
      greska_l := greska_l || ' ' || c.sifra;
   END LOOP;
   IF greska_l IS NOT NULL THEN
      RAISE_APPLICATION_ERROR (-20000, '  Proizvodi u asortimanu kase: ' || greska_l || ' moraju imati popunjen kratki naziv za ispis.');
   END IF;
   greska_l := NULL;

   /* provjera postoje li veza kasa - konobari (sa popunjenim Oib-om i da je aktivan */
   FOR c IN (
       SELECT DISTINCT(kase.sifra) sifra 
         FROM mgmp_kase kase
        WHERE kase.metapl_sifra = 'PSM'
          AND kase.sifra = sifra_kase_p
          AND kase.id NOT IN (
                   SELECT DISTINCT(kase_id) 
                     FROM m_kon_kase konkase,
                          m_konobari kon
                    WHERE konkase.kon_id = kon.id
                      AND kon.oib(+) IS NOT NULL
                      AND kon.aktivan(+) = 'D'))
   LOOP
      greska_l := greska_l || ' ' || c.sifra;
   END LOOP;
   IF greska_l IS NOT NULL THEN
      RAISE_APPLICATION_ERROR (-20000, '  Za kasu ' || sifra_kase_p ||' ne postoje aktivni konobari.');
   END IF;

   /*  provjera postoje li vaee porezne grupe */
   FOR c IN (
       SELECT DISTINCT(gpor.sifra||' '||gpor.naziv) sifra, count(*)
         FROM m_aso_kase asokase,
              m_proizvodi pro,
              mgmp_kase kase,
              m_gporez gpor              
        WHERE asokase.kase_id = kase.id
          AND kase.metapl_sifra = 'PSM' 
          AND kase.sifra = sifra_kase_p
          AND asokase.pro_id =  pro.id
          AND pro.gpor_id = gpor.id
          AND pro.gpor_id NOT IN (SELECT gpor_id
                                    FROM mgas_gpor_raz
                                   WHERE TRUNC(SYSDATE) BETWEEN dat_valjan AND NVL(dat_ponisten,SYSDATE))           
        GROUP BY( gpor.sifra||' '||gpor.naziv)
         )
   LOOP
      greska_l := greska_l ||' '||c.sifra;
   END LOOP;
   IF greska_l IS NOT NULL THEN
      RAISE_APPLICATION_ERROR (-20000, '  Za porezne grupe:'||greska_l||' nije definirano porezno razdoblje.');
   END IF;
END;
PROCEDURE HNB_STORNIRAJ_PREDUJAM
 (ID_P IN t_rnkase.ID%TYPE
 )
 IS
-- poziva se iz ORDS-a
  CURSOR c_iznos_predujma (rn_id_p VARCHAR2) IS
    SELECT rn.datum, rn.rbr, rn.kase_id, suma.rbr_stavke, suma.iznos, suma.iznos_popust, suma.iznos_popust2
      FROM t_rnkase rn,
           (SELECT rn_id, MAX (rbr_stavke) rbr_stavke, SUM (iznos) iznos, SUM (iznos_popust) iznos_popust, SUM (iznos_popust2) iznos_popust2
              FROM t_rnkase_pro
             GROUP BY rn_id) suma
     WHERE rn.id = rn_id_p
       AND rn.id = suma.rn_id
       AND rn.br_kartice IS NOT NULL;

  CURSOR c_pro_predujma IS
    SELECT pro.sifra, vpispz.stopa
      FROM m_proizvodi pro,
           m_gporez gpor,
           mgas_gpor_raz gporraz,
           s_vpisporukap vpispp,
           s_vpisporukaz vpispz
     WHERE pro.ozn_proizvoda = '4' -- Prepaid
       AND pro.gpor_id = gpor.id
       AND gpor.id = gporraz.gpor_id
       AND TRUNC (SYSDATE) BETWEEN gporraz.dat_valjan AND NVL (gporraz.dat_ponisten, (TRUNC (SYSDATE)))
       AND gporraz.vpispp_id = vpispp.id
       AND vpispp.vpispz_id = vpispz.id;

  datum_l             t_rnkase.datum%TYPE;
  kase_id_l           t_rnkase.kase_id%TYPE;
  pro_sifra_l         m_proizvodi.sifra%TYPE;
  rbr_l               t_rnkase.rbr%TYPE;
  rbr_stavke_l        t_rnkase_pro.rbr_stavke%TYPE;
  iznos_predujma_l    t_rnkase.izn_placanja%TYPE;
  iznos_subvencije_l  t_rnkase.izn_placanja%TYPE; 
  iznos_subvencije2_l  t_rnkase.izn_placanja%TYPE;
  pdv_stopa_l         t_rnkase_pro.pdv%TYPE;
  iznos_pdv_l         t_rnkase_pro.iznos_pdv%TYPE;
BEGIN
  IF id_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'id_p');
  END IF;

  OPEN c_pro_predujma;
  FETCH c_pro_predujma INTO pro_sifra_l, pdv_stopa_l;
  CLOSE c_pro_predujma;

  IF pro_sifra_l IS NULL THEN
    RAISE_APPLICATION_ERROR (-20000, 'Ne postoji proizvod vrste PREPAID');
  END IF;

  OPEN c_iznos_predujma (id_p);
  FETCH c_iznos_predujma INTO datum_l, rbr_l, kase_id_l, rbr_stavke_l, iznos_predujma_l, iznos_subvencije_l, iznos_subvencije2_l;
  CLOSE c_iznos_predujma;

  IF NVL (iznos_predujma_l, 0) = 0 THEN
    RAISE_APPLICATION_ERROR (-20000,  'Iznos predujma je 0');
  END IF;

  iznos_pdv_l := iznos_predujma_l * pdv_stopa_l / (100 + pdv_stopa_l) * -1;

  /* 
  Provjera postoji li rezervacija (za RNK UK), te jesu li iznos predujma i iznos subvencije jednaki GAS RNK.
  NYBBLE ne alje iznos predujma i iznos subvencije, pa se provjerava ovdje, poslije upisa u t_rnkase i t_rnkase_pro i pkakar.
  */
  pra_pka_api.hnb_provjeri_pkakarrnk
    (datum_p          => datum_l,
     gmpkas_id_p      => kase_id_l,
     rbr_p            => rbr_l,
     iznos_p          => iznos_predujma_l,
     izn_popusta_p    => iznos_subvencije_l,
     izn_popusta2_p   => iznos_subvencije2_l );

  /*
  Upis negativne stavke (storno predujma)za iznos RNK
  izraun pdv-a po stopi pdv-a za proizvod vrste PREPAID
  */
  pra_gas_api.rnkase_pro
    (rn_id_p            => id_p,
     rbr_stavke_p       => rbr_stavke_l + 1,
     pro_sifra_p        => pro_sifra_l,
     cijena_p           => iznos_predujma_l * -1,
     kolicina_p         => 1,
     stopa_pdv_p        => pdv_stopa_l,
     stopa_ppot_p       => 0,
     iznos_pdv_p        => iznos_pdv_l,
     iznos_ppot_p       => 0,
     iznos_popust_p     => 0,
     iznos_p            => iznos_predujma_l * -1,
     iznos_marze_p      => 0,
     iznos_pdv_marze_p  => 0,
     stopa_pdv_marze_p  => 0,
     iznos_popust2_p    => 0);
END;
PROCEDURE HNB_UPISI_RNKASE
 (KASE_SIFRA_P IN mgmp_kase.sifra%TYPE
 ,RBR_NAR_P IN tpka_kar_rnk.rbr_nar%TYPE
 ,DATUM_P IN t_rnkase.datum%TYPE
 ,VRIJEME_P IN t_rnkase.vrijeme%TYPE
 ,NAC_SIFRA_P IN m_nacpot.sifra%TYPE
 ,VPLA_SIFRA_P IN s_vplacanja.sifra%TYPE
 ,POPUST_P IN t_rnkase.popust%TYPE := 0
 ,PKAADR_RBR_P IN mpka_adrese.rbr%TYPE
 ,KASE_SIFRA_NAR_P IN mgmp_kase.sifra%TYPE
 ,RN_ID_P OUT t_rnkase.id%TYPE
 ,RBR_P OUT t_rnkase.rbr%TYPE
 )
 IS
/*
Koristi se za PKA (HNB) vrste kasa.
Biljei se RAUN iz vanjske aplikacije naruivanje.
Poziva se iz GAS API HNB Uitavanje rauna /hnb/racun [POST]
*/

  -- Kartica
  CURSOR pkakar_c (pkaadr_id_k NUMBER) IS
    SELECT broj
      FROM tpka_kartice
     WHERE pkaadr_id = pkaadr_id_k
       AND ozn_prepaid = -1
       AND (dat_poc IS NULL OR dat_poc <= datum_p)
       AND (dat_zav IS NULL OR dat_zav >= datum_p);

  -- Kasa isporuke po kojoj nastaje RNK u GAS
  CURSOR kase_c IS
    SELECT id, zmpojr_id
      FROM mgmp_kase
     WHERE sifra = kase_sifra_p;    
     
 -- Kasa narudbe po kojoj su rezervirana sredstva 
  CURSOR kase_nar_c IS
    SELECT id
      FROM mgmp_kase
     WHERE sifra = kase_sifra_nar_p; 

  -- Narudba
  CURSOR pkakarrnk_c (kase_id_k NUMBER) IS
    SELECT id, rbr
      FROM tpka_kar_rnk
     WHERE god_poslovna = TO_CHAR (datum_p, 'YYYY')
       AND datum = datum_p
       AND gmpkas_nar_id = kase_id_k
       AND rbr_nar = LPAD (TRIM (rbr_nar_p), 6, '0');

  -- Konobar
  CURSOR kon_c (kase_id_k NUMBER) IS
    SELECT kon_id
      FROM m_kon_kase
     WHERE kase_id = kase_id_k;

  -- Nain potronje
  CURSOR nac_c (kase_id_k NUMBER) IS
    SELECT nac.id
      FROM m_kasa_np kasanp, m_nacpot nac
     WHERE nac.sifra = nac_sifra_p
       AND kasanp.kase_id = kase_id_k
       AND kasanp.nac_id = nac.id;

  -- Vrsta plaanja
  CURSOR vpla_c IS
    SELECT id
      FROM s_vplacanja
     WHERE sifra = vpla_sifra_p;   
     
   -- gastro_raun  
  CURSOR rnkase_c (godina_p VARCHAR2, kase_id_l NUMBER, pkakarrnk_rbr_l VARCHAR2) IS
    SELECT id, rbr
      FROM t_rnkase
     WHERE godina = godina_p 
       AND kase_id = kase_id_l
       AND rbr = pkakarrnk_rbr_l;    

  pkaadr_id_l      mpka_adrese.id%TYPE;
  br_kartice_l     t_rnkase.br_kartice%TYPE;
  kase_id_l        t_rnkase.kase_id%TYPE;   
  kase_nar_id_l    t_rnkase.kase_id%TYPE;
  oj_id_l          t_rnkase.oj_id%TYPE;
  pkakarrnk_id_l   tpka_kar_rnk.id%TYPE;
  pkakarrnk_rbr_l  tpka_kar_rnk.rbr%TYPE;
  kon_id_l         t_rnkase.kon_id%TYPE;
  nac_id_l         t_rnkase.nac_id%TYPE;
  vpla_id_l        t_rnkase.vpla_id%TYPE;

  ozn_valjanosti_l t_rnkase.ozn_valjanosti%TYPE;
  rn_id_l          t_rnkase.id%TYPE;
  rbr_l            t_rnkase.rbr%TYPE;
BEGIN

  -- Provjeri ulazne parametre
  IF kase_sifra_nar_p IS NULL THEN
     pra_zmp_zaj.vrati_poruku (-20099, 'blagajna');
  ELSIF rbr_nar_p IS NULL THEN
     pra_zmp_zaj.vrati_poruku (-20099, 'redni_broj_narudzbe');
  ELSIF datum_p IS NULL THEN
     pra_zmp_zaj.vrati_poruku (-20099, 'datum');
  -- vrijeme_p
  ELSIF vpla_sifra_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'vrsta_placanja');
  -- popust_p
  ELSIF pkaadr_rbr_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'maticni_broj_zaposlenika');
  END IF;

  -- Kartica
  SELECT MIN (id) INTO pkaadr_id_l
    FROM mpka_adrese
   WHERE rbr = LPAD (TRIM (pkaadr_rbr_p), 6, '0');
  IF pkaadr_id_l IS NULL THEN
    -- Pogrena vrijednost ulaznog parametra (#0)!
    pra_zmp_zaj.vrati_poruku (-20099, 'maticni_broj_zaposlenika');
  END IF;
  OPEN pkakar_c (pkaadr_id_l);
  FETCH pkakar_c INTO br_kartice_l;
  CLOSE pkakar_c;

  -- Kasa
  OPEN kase_c;
  FETCH kase_c INTO kase_id_l, oj_id_l;
  CLOSE kase_c;
  IF kase_id_l IS NULL THEN
    RAISE_APPLICATION_ERROR (-20000, 'Ne postoji blagajna sa ifrom ' || kase_sifra_p);
  END IF;      
  
  -- Kasa narudbe
  OPEN kase_nar_c;
  FETCH kase_nar_c INTO kase_nar_id_l; 
  IF kase_nar_c%NOTFOUND THEN
     RAISE_APPLICATION_ERROR (-20000, 'Ne postoji blagajna sa ifrom ' || kase_sifra_p);
     CLOSE kase_nar_c;
  END IF;
  CLOSE kase_nar_c;
  
  -- Narudba
  OPEN pkakarrnk_c (kase_nar_id_l);
  FETCH pkakarrnk_c INTO pkakarrnk_id_l, pkakarrnk_rbr_l;
  IF pkakarrnk_c%NOTFOUND THEN
    CLOSE pkakarrnk_c;
    RAISE_APPLICATION_ERROR (-20000, 'Ne postoji rezervacija sredstava za narudbu broj ' || rbr_nar_p);
  END IF;
  CLOSE pkakarrnk_c; 
  
  -- Konobar       
   OPEN kon_c (kase_id_l);                                                                                           
  FETCH kon_c INTO kon_id_l;  
  IF kon_c%NOTFOUND THEN
    CLOSE kon_c;
    RAISE_APPLICATION_ERROR (-20000, 'Ne postoji konobar za blagajnu ' || kase_sifra_p);
  END IF;
  CLOSE kon_c;
  
  
  -- Nain potronje
  OPEN nac_c (kase_id_l);
  FETCH nac_c INTO nac_id_l;   
  IF nac_c%NOTFOUND THEN 
     RAISE_APPLICATION_ERROR (-20000, 'Ne postoji cjenik ' || nac_sifra_p || ' za blagajnu ' || kase_sifra_p);
     CLOSE nac_c;
  END IF;
  CLOSE nac_c; 
  
  
  -- Vrsta plaanja
  OPEN vpla_c;
  FETCH vpla_c INTO vpla_id_l;   
  IF vpla_c%NOTFOUND THEN 
      RAISE_APPLICATION_ERROR (-20000, 'Ne postoji vrsta plaanja sa ifrom ' || vpla_sifra_p);
     CLOSE vpla_c;
  END IF;                 
  CLOSE vpla_c;
   
   
  /*  Radi nepoznatog problema oko vraanja odgovora i viestrukog slanja narudbi HTTP status 555 - RN 
      insert radimo ako nema rauna, a ako je raun kreiran vraamo rn_id radi stavaka koje ORDS dohvaa 
   */
  IF pkakarrnk_rbr_l IS NULL THEN
     -- unos u T_RNKASE
  
     ozn_valjanosti_l := 'N';
     rn_id_l := pra_zmp_zaj.i3_sekvenca (NULL);

     INSERT INTO t_rnkase (
       id, godina, kase_id, rbr, datum, kon_id,
       nac_id, vpla_id, popust, vrijeme, ozn_valjanosti,
       datum_izdavanja, izn_placanja, oj_id, br_kartice,
       unos_korisnik, unos_dat)
     VALUES (
       rn_id_l, TO_CHAR (datum_p, 'YYYY'), kase_id_l, rn_id_l, datum_p, kon_id_l,
       nac_id_l, vpla_id_l, NVL (popust_p, 0), vrijeme_p, ozn_valjanosti_l,
       datum_p, 0, oj_id_l, br_kartice_l,
       'MISHAPI', SYSDATE);

     -- generiraj rbr
     UPDATE t_rnkase
        SET ozn_valjanosti = 'V'
      WHERE id = rn_id_l
     RETURN rbr INTO rbr_l;

        -- upii rbr u narudbu
     UPDATE tpka_kar_rnk
        SET rbr = rbr_l,
            gmpkas_id = kase_id_l 
      WHERE id = pkakarrnk_id_l; 
  
  ELSE
     OPEN rnkase_c (TO_CHAR (datum_p, 'YYYY'), kase_id_l, pkakarrnk_rbr_l);
    FETCH rnkase_c INTO rn_id_l, rbr_l;
    IF rnkase_c%NOTFOUND THEN    
       RAISE_APPLICATION_ERROR (-20000, 'Ne postoji raun za kasu' ||kase_sifra_p ||' RBR:'||pkakarrnk_rbr_l);        
       CLOSE rnkase_c;
    END IF;
    CLOSE rnkase_c;
  END IF;     
  
  rn_id_p := rn_id_l; -- potrebno za unos i vraanje stavaka
  rbr_p := rbr_l;     -- potrebno za odgovor 
  
END;
PROCEDURE HNB_STORNIRAJ_RACUN
 (GODINA_P IN t_rnkase.godina%TYPE
 ,KASE_SIFRA_P IN mgmp_kase.sifra%TYPE
 ,RBR_P IN t_rnkase.rbr%TYPE
 )
 IS
/* Ne koristi se sada.
   Nybble - teko je izmijeniti koncept da ADMIN useri rade rezervaciju sredstava,
            to bi u sluaju novog ispravnog pozitivnog rauna trebali pa se odustaje od toga
*/


CURSOR kase_C (kase_sifra_p VARCHAR2) IS
    SELECT id
      FROM mgmp_kase
     WHERE sifra = kase_sifra_p
       AND metapl_sifra IN ('GAS', 'PKA');

  CURSOR racun_C (kase_id_l NUMBER, rbr_p VARCHAR2, godina_p  VARCHAR2 ) IS
    SELECT id
      FROM t_rnkase rn
     WHERE rbr = rbr_p
       AND kase_id = kase_id_l
       AND godina = godina_p;

  CURSOR pkakarrnk_c  (kase_id_l NUMBER) IS
    SELECT id, pkakar_id
      FROM tpka_kar_rnk
     WHERE god_poslovna= godina_p
       AND gmpkas_id = kase_id_l
       AND rbr = rbr_p;
         
  pkakarrnk_id_l      tpka_kar_rnk.id%TYPE;
  pkakar_id_l         tpka_kar_rnk.pkakar_id%TYPE;  
  kase_id_l           mgmp_kase.id%TYPE;
  id_l                t_rnkase.id%TYPE;
  rn_id_novi_l        t_rnkase.id%TYPE;
  ozn_valjanosti_l    t_rnkase.ozn_valjanosti%TYPE;
  rbr_l               t_rnkase.rbr%TYPE;
BEGIN  
       
  /* Provjera ulaznih parametara */
  IF kase_sifra_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'blagajna');
  ELSIF rbr_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'redni_broj_rauna');
  ELSIF godina_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'godina');
  END IF;

   OPEN kase_C (kase_sifra_p);
  FETCH kase_C INTO kase_id_l ;
  CLOSE kase_C;

  IF kase_id_l IS NULL THEN
    RAISE_APPLICATION_ERROR (-20000, 'Ne postoji blagajna sa ifrom ' || kase_sifra_p);
  END IF;
   
   OPEN pkakarrnk_c (kase_id_l);
  FETCH pkakarrnk_c  INTO  pkakarrnk_id_l,  pkakar_id_l;
  CLOSE pkakarrnk_c;
  
  IF pkakar_id_l IS NULL THEN
    RAISE_APPLICATION_ERROR (-20000, 'Ne postoji raun (pka) rbr ' || rbr_p||' na blagajni '|| kase_sifra_p );
  END IF;

   OPEN racun_c (kase_id_l, rbr_p, godina_p);
  FETCH racun_c  INTO id_l;
  CLOSE racun_c ;
  
  IF id_l IS NULL THEN
    RAISE_APPLICATION_ERROR (-20000, 'Ne postoji raun (gas) rbr ' || rbr_p||' na blagajni '|| kase_sifra_p );
  END IF;
   
  rn_id_novi_l := pra_zmp_zaj.i3_sekvenca (NULL);
  ozn_valjanosti_l := 'N';

  INSERT INTO t_rnkase (
    id, godina, kase_id, rbr, datum,
    kon_id, nac_id, vpla_id, popust, opis,
    vrijeme, ozn_valjanosti, datum_izdavanja, izn_placanja,
    oj_id, br_kartice,  rn_id)
  SELECT 
    rn_id_novi_l, godina_p, kase_id_l, rn_id_novi_l, SYSDATE,
    kon_id, nac_id, vpla_id, popust, 'Storno RNK '||rbr_p,
    TO_CHAR(SYSDATE, 'HHMM'), ozn_valjanosti_l, sysdate, izn_placanja * -1, oj_id,  br_kartice, NULL
    FROM
    t_rnkase
  WHERE id = id_l;
  
  UPDATE t_rnkase
     SET ozn_valjanosti = 'V'
   WHERE id = rn_id_novi_l;
   
  INSERT INTO t_rnkase_pro 
    (rn_id, rbr_stavke, pro_id, sifgr_id, gpor_id,
     gknji_id, gtehpro_id, mt_id, kolicina, cijena,
     pdv, ppot, zad_nab_cijena, pros_nab_cijena, vpispz_id, 
     popust, iznos_popust, iznos_pdv, iznos_ppot, iznos, iznos_popust2)
  SELECT
     rn_id_novi_l, rbr_stavke, pro_id, sifgr_id, gpor_id,
     gknji_id, gtehpro_id, mt_id, kolicina * -1, cijena,
     pdv, ppot, zad_nab_cijena, pros_nab_cijena, vpispz_id, 
     popust, iznos_popust * -1, iznos_pdv * -1 , iznos_ppot* -1, iznos * -1, iznos_popust2 * -1 
    FROM
     t_rnkase_pro 
   WHERE 
     rn_id = id_l;
     
  UPDATE t_rnkase
     SET rn_id = id_l
   WHERE id = rn_id_novi_l;
   
  DELETE tpka_kar_rnk
   WHERE id = pkakarrnk_id_l; 
END;

END PRA_GAS_API;
/
SHOW ERROR

