-- C:\Radni\pra_eba.pkb
--
-- Generated for Oracle 10g on Mon Dec 29  10:17:09 2025 by Server Generator 6.5.96.5.6
 

PROMPT Creating Package Body 'PRA_EBA'
CREATE OR REPLACE PACKAGE BODY PRA_EBA IS
data_m CLOB;
log_filename_m VARCHAR2(100);
odgovor_m CLOB;
url_m s_parametri_prijepisa.staza%TYPE;
erac_password_m s_vlasnik.erac_password%TYPE;
clob_m CLOB;

racblob_id_m t_racuni_blob.id%TYPE;

-- REC param 1175: Oznaka sustava za slanje e-rauna: 1 = Moj-eRaun, 2 = EBA, 3 = FINA, 5 = Pondi ili nebitno.
tip_m szmp_parametri.vrijednost%TYPE := pra_zmp_zaj.zmppar_vrijednost ('REC', '1175');


/* EBA_IZRADI_ERACUN_BL */
PROCEDURE IZRADI_ERACUN_BLOB
 (RAC_ID_P IN t_racuni.id%TYPE
 ,PKARAC_ID_P IN tpka_racuni.id%TYPE
 ,FILENAME_P IN VARCHAR2
 ,ZAH_PONUDA_P IN VARCHAR2 := NULL
 ,NARUDZBENICA_P IN VARCHAR2 := NULL
 ,UGOVOR_P IN VARCHAR2 := NULL
 ,PROJEKT_P IN VARCHAR2 := NULL
 ,NAPOMENA_P IN VARCHAR2 := NULL
 ,RACBLOB_ID_P OUT t_racuni_blob.id%TYPE
 )
 IS
-- poziva se iz modula pka2070.fmb - Rauni za predujam, rec2250.fmb - Rauni i pka2050.fmb - Rauni
 blobId_l t_racuni_blob.id%TYPE;
BEGIN
  -- REC param 1175: Oznaka sustava za slanje e-rauna: 1 = Moj-eRaun, 2 = EBA, 3 = FINA, 5 = Pondi ili nebitno.
  tip_m := pra_zmp_zaj.zmppar_vrijednost ('REC', '1175');
  IF tip_m <> '2' THEN
    RETURN;
  END IF;
  
  pra_eracun2.izradi_eracun_blob (rac_id_p, pkarac_id_p, filename_p, zah_ponuda_p, narudzbenica_p, ugovor_p, projekt_p, napomena_p, blobId_l);
  racblob_id_p := blobId_l;
END;
/* EBA_IZRADI_ERACUN_CV */
PROCEDURE IZRADI_ERACUN_BLOB_CVOR
 (RAC_ID_P IN t_racuni.id%TYPE
 ,PKARAC_ID_P IN tpka_racuni.id%TYPE
 ,FILENAME_P IN VARCHAR2
 ,ZAH_PONUDA_P IN VARCHAR2 := NULL
 ,NARUDZBENICA_P IN VARCHAR2 := NULL
 ,UGOVOR_P IN VARCHAR2 := NULL
 ,PROJEKT_P IN VARCHAR2 := NULL
 ,NAPOMENA_P IN VARCHAR2
 ,CVOR_NA_P IN VARCHAR2
 ,CVOR_CENTAR_P IN VARCHAR2
 )
 IS
-- IRN 4125
 naredba_l VARCHAR2(32000);         
 racblob_id_l t_racuni_blob.id%TYPE;
 cvor_p VARCHAR2 (100);
 cvor_cen_p VARCHAR2(100):= NULL;
BEGIN
      IF cvor_na_p IS NOT NULL AND cvor_centar_p IS NOT NULL AND cvor_na_p = cvor_centar_p THEN
        cvor_p := cvor_centar_p;
	      naredba_l := 'BEGIN pra_eba.izradi_eracun_blob' || '@'||cvor_p ||
                     '(NULL, :a1, :a2, :a3, :a4, :a5, :a6, :a7, :a8); END;';
                     EXECUTE IMMEDIATE naredba_l USING pkarac_id_p, filename_p, zah_ponuda_p, narudzbenica_p, ugovor_p, projekt_p, napomena_p, OUT racblob_id_l;

        naredba_l := 'BEGIN pra_eba.posalji_eracun' || '@'||cvor_p ||
                     '(NULL, :a1, :a2, :a3); END;';
                     EXECUTE IMMEDIATE naredba_l USING pkarac_id_p, filename_p, racblob_id_l;
      ELSIF cvor_na_p IS NOT NULL AND cvor_centar_p IS NOT NULL AND cvor_na_p <> cvor_centar_p THEN
        cvor_p := cvor_centar_p;
	      naredba_l := 'BEGIN pra_eba.izradi_eracun_blob_cvor' || '@'||cvor_p ||
                     '(NULL, :a1, :a2, :a3, :a4, :a5, :a6, :a7, :a8, :a9); END;';
                     EXECUTE IMMEDIATE naredba_l USING pkarac_id_p, filename_p, zah_ponuda_p, narudzbenica_p, ugovor_p, projekt_p, napomena_p, cvor_na_p, cvor_cen_p;
      END IF;
      IF cvor_na_p IS NOT NULL AND cvor_centar_p IS NULL THEN
        cvor_p := cvor_na_p;
	      naredba_l := 'BEGIN pra_eba.izradi_eracun_blob' || '@'||cvor_p ||
                     '(NULL, :a1, :a2, :a3, :a4, :a5, :a6, :a7, :a8); END;';
                     EXECUTE IMMEDIATE naredba_l USING pkarac_id_p, filename_p, zah_ponuda_p, narudzbenica_p, ugovor_p, projekt_p, napomena_p, OUT racblob_id_l;

        naredba_l := 'BEGIN pra_eba.posalji_eracun' || '@'||cvor_p ||
                     '(NULL, :a1, :a2, :a3); END;';
                     EXECUTE IMMEDIATE naredba_l USING pkarac_id_p, filename_p, racblob_id_l;
      END IF;
END;
/* EBA_OBRADI_ODGOVOR */
PROCEDURE EBA_OBRADI_ODGOVOR
 (METHOD_P IN VARCHAR2
 )
 IS
-- poziva se iz request2eba
  values_l      APEX_JSON.t_values;
  id_vanjsus_l  VARCHAR2(100);
  status_l      VARCHAR2(5);
  status_name_l VARCHAR2(200);
  text_l        VARCHAR2(10000);
BEGIN
  /* response
{
    "docId": "94cc12a9f7008ad79807abbcdc93e3fd",
    "errorCode": 15.000000000000,
    "errorText": "Document not inserted"
}
  */

  IF TRIM (odgovor_m) IS NULL OR odgovor_m = '{}' THEN
    RETURN;
  END IF; 

  APEX_JSON.parse (values_l, odgovor_m);
  id_vanjsus_l := APEX_JSON.get_varchar2 (p_path => 'docId', p_values => values_l);
  status_l := APEX_JSON.get_number (p_path => 'errorCode', p_values => values_l);
  status_name_l :=  APEX_JSON.get_varchar2 (p_path => 'errorText', p_values => values_l);
  
  IF id_vanjsus_l IS NOT NULL AND status_l IS NULL THEN
    status_l := '10';
  END IF;

  IF racblob_id_m IS NOT NULL AND (id_vanjsus_l IS NOT NULL OR status_l IS NOT NULL) THEN
    /*
    domena STATUS_ERAC
    0 = Izraen
    1 = Poslan
    2 = Primljen
    3 = Plaen
    4 = Nije preuzet
    -1 = Poniten -- Odbijen ???
    */

    UPDATE t_racuni_blob
       SET id_vanjsus = NVL (id_vanjsus_l, id_vanjsus),
           status = DECODE (status_l,
                      '00', '0', -- neobraena iznimka sa strane EBA
                      '10', '1', -- 1 = Poslan
                      '15', '0', -- Document not inserted (ostaje u statusu Izraen)
                      '1')
     WHERE id = racblob_id_m;

    COMMIT;

    status_l := NVL (status_l, 1); -- 1 = Poslan
  ELSE
    text_l := 'Error ' ||APEX_JSON.get_number(p_path => 'errorCode', p_values => values_l) ||': ' ||APEX_JSON.get_varchar2(p_path => 'errorText', p_values => values_l);
  END IF;

  IF racblob_id_m IS NULL THEN
    RETURN;
  END IF;

  INSERT INTO t_racblob_log (racblob_id, status)
    VALUES (racblob_id_m, SUBSTR ('(IP 2) ' || INITCAP (method_p) || ' status ' || status_l || ': ' || DECODE (text_l, NULL, status_name_l, 'Error - ' || text_l), 1, 240));

  COMMIT;
END;
/* EBA_POSALJI_ERACUN */
PROCEDURE POSALJI_ERACUN
 (RAC_ID_P IN t_racuni_blob.rac_id%TYPE
 ,PKARAC_ID_P IN t_racuni_blob.pkarac_id%TYPE
 ,FILENAME_P IN VARCHAR2
 ,RACBLOB_ID_P IN t_racuni_blob.id%TYPE
 )
 IS
-- poziva se iz modula pka2070.fmb - Rauni za predujam, rec2250.fmb - Rauni i pka2050.fmb - Rauni

  CURSOR rec_blobs_c IS
    SELECT id, datoteka
      FROM t_racuni_blob
     WHERE rac_id = rac_id_p
       AND NVL (racblob_id_p, id) = id
       AND oznaka = 'xml'
     ORDER BY id DESC;

  CURSOR pka_blobs_c IS
    SELECT id, datoteka
      FROM t_racuni_blob
     WHERE pkarac_id = pkarac_id_p
       AND NVL (racblob_id_p, id) = id
       AND oznaka = 'xml'
     ORDER BY id DESC;

  datoteka_l BLOB;
BEGIN

  -- REC param 1175: Oznaka sustava za slanje e-rauna: 1 = Moj-eRaun, 2 = EBA, 3 = FINA, 5 = Pondi ili nebitno.
  tip_m := pra_zmp_zaj.zmppar_vrijednost ('REC', '1175');
  IF tip_m <> '2' THEN
    RETURN;
  END IF;

  log_filename_m := filename_p;
  racblob_id_m := NULL;

  -- REC raun
  OPEN rec_blobs_c;
  FETCH rec_blobs_c INTO racblob_id_m, datoteka_l;
  IF rec_blobs_c%FOUND THEN
    clob_m := pra_pka2.blob2base64 (datoteka_l);  -- EBA zahtjeva base64
    request2eba ('send');
  END IF;
  CLOSE rec_blobs_c;

  -- PKA raun
  OPEN pka_blobs_c;
  FETCH pka_blobs_c INTO racblob_id_m, datoteka_l;
  IF pka_blobs_c%FOUND THEN
    clob_m := pra_pka2.blob2base64 (datoteka_l);  -- EBA zahtjeva base64
    request2eba ('send');
  END IF;
  CLOSE pka_blobs_c;
END;
/* EBA_REQUEST2EBA */
PROCEDURE REQUEST2EBA
 (METHOD_P IN VARCHAR2
 ,FILENAME_P IN VARCHAR2 := NULL
 ,RACBLOB_ID_P IN t_racuni_blob.id%TYPE := NULL
 ,ID_VANJSUS_P IN NUMBER := NULL
 ,INVOICE_ID_P IN VARCHAR2 := NULL
 ,STATUSID_P IN NUMBER := NULL
 ,STARTDATE_P DATE := NULL
 ,ENDDATE_P IN DATE := NULL
 )
 IS
-- poziva se iz posalji_eracun za informacijskog posrednika 2 = EBA
  CURSOR vla_c IS
    SELECT oib, erac_username, erac_password
      FROM s_vlasnik;
  oib_l      s_vlasnik.oib%TYPE;           -- OIB izdavatelja rauna (vlasnika)
  username_l s_vlasnik.erac_username%TYPE; -- korisnicko ime EBA
  pass_l     s_vlasnik.erac_password%TYPE; -- pass izdavatelja rauna u sustavu EBA
BEGIN

  OPEN vla_c;
  FETCH vla_c INTO oib_l, username_l, pass_l;
  CLOSE vla_c;

  SELECT MIN (staza)
    INTO url_m -- base url
    FROM s_parametri_prijepisa
   WHERE sifra = 'ERACUN_URL';

    url_m := url_m || '/createInvoice';

    APEX_JSON.initialize_clob_output;
    APEX_JSON.open_object; -- {
      APEX_JSON.write ('Username', username_l);
      APEX_JSON.write ('Password', pass_l);
      APEX_JSON.write ('OIB', oib_l);
      APEX_JSON.write ('SoftwareId', 'MISH-001');
      APEX_JSON.write ('File', clob_m);
    APEX_JSON.close_object; -- }
    data_m := APEX_JSON.get_clob_output;

  IF data_m IS NULL THEN
    RETURN;
  END IF;

  zaj_request;
  eba_obradi_odgovor (method_p);
END;
/* EBA_ZAJ_REQUEST */
PROCEDURE ZAJ_REQUEST
 (METHOD_P IN VARCHAR2 := NULL
 )
 IS
req_l  UTL_HTTP.req;
  res_l  UTL_HTTP.resp;
  line_l CLOB;
BEGIN

  odgovor_m := NULL;

  IF log_filename_m IS NOT NULL THEN
    pra_pka2.clob_to_table (CHR(10) || '[' || TO_CHAR (SYSDATE, 'DD.MM.RRRR HH24:MI:SS') || '] ' || url_m || CHR(10), log_filename_m, racblob_id_m, 'ERACUN');
    pra_pka2.clob_to_table (data_m || CHR(10), log_filename_m, racblob_id_m, 'ERACUN');
  END IF;

  UTL_HTTP.set_detailed_excp_support (enable => true);
  UTL_HTTP.set_body_charset (charset => 'UTF-8');
  req_l := UTL_HTTP.begin_request (url => url_m, method => 'POST', http_version => 'HTTP/1.1');
  UTL_HTTP.set_header (req_l, 'Content-Type', 'application/json');
  UTL_HTTP.set_header (req_l, 'Accept', 'application/json'); -- za EBA je Accept parametar u headeru obavezan
  

    DECLARE
      req_length_l BINARY_INTEGER;
      buffer_l     VARCHAR2(32000);
      amount_l     PLS_INTEGER := 2000;
      offset_l     PLS_INTEGER := 1;
    BEGIN
      req_length_l := pra_pka2.clob_length (data_m);
      UTL_HTTP.set_header (req_l, 'Content-Length', req_length_l);

      WHILE (offset_l < req_length_l) LOOP
        buffer_l := DBMS_LOB.substr (data_m, amount_l, offset_l);
        UTL_HTTP.write_text (req_l, buffer_l);
        offset_l := offset_l + amount_l;
      END LOOP;
    END;
    
    
  res_l := UTL_HTTP.get_response (req_l);
  UTL_HTTP.set_body_charset (res_l, charset => 'UTF-8');

  IF log_filename_m IS NOT NULL THEN
    pra_pka2.clob_to_table (res_l.status_code || ' ' || res_l.reason_phrase || CHR(10), log_filename_m, racblob_id_m, 'ERACUN');
  END IF;

  BEGIN
    LOOP
      UTL_HTTP.read_line (res_l, line_l);
      odgovor_m := odgovor_m || line_l;
    END LOOP;
    UTL_HTTP.end_response (res_l);
  EXCEPTION
    WHEN UTL_HTTP.end_of_body THEN
      UTL_HTTP.end_response (res_l);
  END;

  IF log_filename_m IS NOT NULL THEN
    pra_pka2.clob_to_table (odgovor_m || CHR(10), log_filename_m, racblob_id_m, 'ERACUN');
  END IF;
EXCEPTION
  WHEN OTHERS THEN
    UTL_HTTP.end_response (res_l);
    IF log_filename_m IS NOT NULL THEN
      pra_pka2.clob_to_table ('[' || TO_CHAR (SYSDATE, 'DD.MM.RRRR HH24:MI:SS') || '] ' || SQLERRM || CHR(10), log_filename_m, racblob_id_m, 'ERACUN');
    END IF;
    RAISE;
END;

END PRA_EBA;
/
SHOW ERROR

