-- C:\Radni\mpka_eft_par.trg
--
-- Generated for Oracle 10g on Fri Jul 04  07:54:51 2025 by Server Generator 6.5.96.5.6
 

PROMPT Creating Trigger 'BUR_MPKA_EFT_PAR'
CREATE OR REPLACE TRIGGER BUR_MPKA_EFT_PAR
 BEFORE UPDATE
 ON MPKA_EFT_PAR
 FOR EACH ROW
DECLARE

 zapis_l TAB_MPKA_EFT_PAR.PKAEFTPAR_mpka_type;
BEGIN      
  -- IRN 4039
  IF :NEW.naziv = 'IP ADDRESS' THEN
    zapis_l.pkaeftpar_id_new := :NEW.id;
    zapis_l.naziv := :NEW.naziv;
    zapis_l.vrijednost := :NEW.vrijednost;
    tab_mpka_eft_par.puni_tablicu (zapis_l);
  END IF;
  pra_pka_zaj.puni_audit (:NEW.unos_korisnik, :NEW.unos_dat, :NEW.izmjena_korisnik, :NEW.izmjena_dat);
END;
/
SHOW ERROR


PROMPT Creating Trigger 'BIR_MPKA_EFT_PAR'
CREATE OR REPLACE TRIGGER BIR_MPKA_EFT_PAR
 BEFORE INSERT
 ON MPKA_EFT_PAR
 FOR EACH ROW
DECLARE

 zapis_l TAB_MPKA_EFT_PAR.PKAEFTPAR_mpka_type;
BEGIN
  -- IRN 02888
  IF SYS_CONTEXT ('LOGINFO_CTX', 'SSOUSER') = 'ITNEW'
    AND SYS_CONTEXT ('LOGINFO_CTX', 'VLASNIKPODATKA') = pra_zmp_zaj.vrijednost_parametra ('0999')
  THEN
    RETURN;  -- izlaz iz trigera
  END IF;

  :NEW.id := pra_zmp_zaj.i3_sekvenca (:NEW.id);       
  -- IRN 4039
  IF :NEW.naziv = 'IP ADDRESS' THEN
    zapis_l.pkaeftpar_id_new := :NEW.id;
    zapis_l.naziv := :NEW.naziv;
    zapis_l.vrijednost := :NEW.vrijednost;
    tab_mpka_eft_par.puni_tablicu (zapis_l);
  END IF;
  pra_pka_zaj.puni_audit (:NEW.unos_korisnik, :NEW.unos_dat, :NEW.izmjena_korisnik, :NEW.izmjena_dat);
END;
/
SHOW ERROR


PROMPT Creating Trigger 'ALS_MPKA_EFT_PAR'
CREATE OR REPLACE TRIGGER ALS_MPKA_EFT_PAR
 AFTER INSERT OR UPDATE
 ON MPKA_EFT_PAR
DECLARE

  zapis_l tab_mpka_eft_par.pkaeftpar_mpka_type;
  broj_slogova_l INTEGER;
BEGIN
  tab_mpka_eft_par.postavi_iterator;
  WHILE tab_mpka_eft_par.ima_jos LOOP
    zapis_l := tab_mpka_eft_par.slijedeci_red;

    -- Provjera postoji li ve takav zapis u tablici 
    SELECT COUNT (*) INTO broj_slogova_l
      FROM mpka_eft_par pkaeftpar, mpka_eftpos pkaeft
     WHERE pkaeft.id = pkaeftpar.pkaeft_id
       AND pkaeft.ozn_vpruzatelja <> 5 -- iskljucujem PayPar
       AND pkaeftpar.naziv = 'IP ADDRESS'
       AND TRIM (UPPER (pkaeftpar.vrijednost)) = TRIM (UPPER (zapis_l.vrijednost))
       AND pkaeftpar.id <> zapis_l.PKAEFTPAR_id_new;  -- iskljuimo red 

    IF broj_slogova_l > 0 THEN
      tab_mpka_eft_par.brisi_tablicu;   
      pra_zmp_zaj.vrati_poruku_zaj ('PKA', -20260, zapis_l.vrijednost);
    END IF;
  END LOOP;
  tab_mpka_eft_par.brisi_tablicu;

END;
/
SHOW ERROR







