-- D:\z_tekuce\m_sirovine.trg
--
-- Generated for Oracle 10g on Mon Mar 31  12:19:12 2025 by Server Generator 6.5.96.5.6
 





PROMPT Creating Trigger 'AR_M_SIROVINE'
CREATE OR REPLACE TRIGGER AR_M_SIROVINE
 AFTER DELETE OR INSERT OR UPDATE
 ON M_SIROVINE
 FOR EACH ROW
BEGIN
  -- IRN 2888
  IF SYS_CONTEXT ('LOGINFO_CTX', 'SSOUSER') = 'ITNEW'
    AND SYS_CONTEXT ('LOGINFO_CTX', 'VLASNIKPODATKA') = pra_zmp_zaj.vrijednost_parametra ('0999')
  THEN
    RETURN; -- izlaz iz trigera
  END IF;
    
   /* Ako je u toku dnevni obraun/ponitavanje ili auriranje ZNC sirovina, replikacija sirovine se ne radi. */
   IF    bm_gas3010.obrada_u_toku
      OR bm_gas3020.obrada_u_toku
      OR bm_gas3090.obrada_u_toku
   THEN
      RETURN;
   END IF;

   replikacija.napuni_tab (:OLD.id, :NEW.id);
END;
/
SHOW ERROR


PROMPT Creating Trigger 'AS_M_SIROVINE'
CREATE OR REPLACE TRIGGER AS_M_SIROVINE
 AFTER DELETE OR INSERT OR UPDATE
 ON M_SIROVINE
BEGIN
   replikacija.azuriraj_retke (
      aplikacija_p => 'GAS',
      tablica_p    => 'm_sirovine');
END;
/
SHOW ERROR


PROMPT Creating Trigger 'BS_M_SIROVINE'
CREATE OR REPLACE TRIGGER BS_M_SIROVINE
 BEFORE DELETE OR INSERT OR UPDATE
 ON M_SIROVINE
BEGIN
   replikacija.brisi_tab;
END;
/
SHOW ERROR


PROMPT Creating Trigger 'BUR_M_SIROVINE'
CREATE OR REPLACE TRIGGER BUR_M_SIROVINE
 BEFORE UPDATE
 ON M_SIROVINE
 FOR EACH ROW
BEGIN
   pra_ozn_valjanosti.provjeri_ozn_valjanosti
      (:OLD.ozn_valjanosti, :NEW.ozn_valjanosti);  
      
   :NEW.dat_valjan := TRUNC (:NEW.dat_valjan);
   :NEW.dat_ponisten := TRUNC (:NEW.dat_ponisten);   

   pra_rastav.rastav (:NEW.id, :NEW.ozn_valjanosti);

   :NEW.dat_azur_nc := TRUNC (:NEW.dat_azur_nc);

   pra_sifre_artikala.proizvodi (:NEW.sifra);
   pra_sifre_artikala.namirnice (:NEW.sifra);

   /*
   Ako je u toku dnevni obraun/ponitavanje ili auriranje ZNC sirovina,
   audit polja se ne mijenjaju.
   */
   IF    bm_gas3010.obrada_u_toku
      OR bm_gas3020.obrada_u_toku
      OR bm_gas3090.obrada_u_toku
   THEN
      RETURN;
   END IF;

   gas_zaj.upisi_audit (
      :NEW.unos_korisnik, :NEW.unos_dat,
      :NEW.izmjena_korisnik, :NEW.izmjena_dat);
END;
/
SHOW ERROR


PROMPT Creating Trigger 'BIR_M_SIROVINE'
CREATE OR REPLACE TRIGGER BIR_M_SIROVINE
 BEFORE INSERT
 ON M_SIROVINE
 FOR EACH ROW
BEGIN
  -- IRN 2888
  IF SYS_CONTEXT ('LOGINFO_CTX', 'SSOUSER') = 'ITNEW'
    AND SYS_CONTEXT ('LOGINFO_CTX', 'VLASNIKPODATKA') = pra_zmp_zaj.vrijednost_parametra ('0999')
  THEN
    RETURN; -- izlaz iz trigera
  END IF;
  
  IF :NEW.dat_valjan IS NULL THEN
    :NEW.dat_valjan := TRUNC (SYSDATE, 'RRRR');
  END IF;

  :NEW.dat_valjan := TRUNC (:NEW.dat_valjan);
  :NEW.dat_ponisten := TRUNC (:NEW.dat_ponisten); 
   
  pra_ozn_valjanosti.provjeri_ozn_valjanosti (NULL, :NEW.ozn_valjanosti);

  pra_rastav.rastav (:NEW.id, :NEW.ozn_valjanosti);

  :NEW.dat_azur_nc := TRUNC (:NEW.dat_azur_nc);

  pra_sifre_artikala.proizvodi (:NEW.sifra);
  pra_sifre_artikala.namirnice (:NEW.sifra);

  :NEW.id := gas_zaj.sekvenca (:NEW.id);
  gas_zaj.upisi_audit (
    :NEW.unos_korisnik, :NEW.unos_dat,
    :NEW.izmjena_korisnik, :NEW.izmjena_dat);
END;
/
SHOW ERROR







