-- D:\mish_CVS\misH_skripte\m_proizvodi.trg
--
-- Generated for Oracle 10g on Thu Jul 24  11:54:49 2025 by Server Generator 6.5.96.5.6
 



PROMPT Creating Trigger 'AR_M_PROIZVODI'
CREATE OR REPLACE TRIGGER AR_M_PROIZVODI
 AFTER DELETE OR INSERT OR UPDATE
 ON M_PROIZVODI
 FOR EACH ROW
BEGIN
   /*
   Ako je u toku dnevni obraun/ponitavanje
   ili kalkulacija PC proizvoda,
   replikacija proizvoda se ne radi.
   */
  -- IRN 2888
  IF SYS_CONTEXT ('LOGINFO_CTX', 'SSOUSER') = 'ITNEW'
    AND SYS_CONTEXT ('LOGINFO_CTX', 'VLASNIKPODATKA') = pra_zmp_zaj.vrijednost_parametra ('0999')
  THEN
    RETURN; -- izlaz iz trigera
  END IF;
   
   IF    bm_gas3010.obrada_u_toku
      OR bm_gas3020.obrada_u_toku
      OR bm_gas3090.obrada_u_toku
   THEN
      RETURN;
   END IF;

   replikacija.napuni_tab (:OLD.id, :NEW.id);
END AR_M_PROIZVODI;
/
SHOW ERROR


PROMPT Creating Trigger 'BS_M_PROIZVODI'
CREATE OR REPLACE TRIGGER BS_M_PROIZVODI
 BEFORE DELETE OR INSERT OR UPDATE
 ON M_PROIZVODI
BEGIN
   replikacija.brisi_tab;
END BS_M_PROIZVODI;
/
SHOW ERROR


PROMPT Creating Trigger 'AUS_M_PROIZVODI'
CREATE OR REPLACE TRIGGER AUS_M_PROIZVODI
 AFTER UPDATE
 ON M_PROIZVODI
DECLARE

   zapis_l tab_m_proizvodi.proizvodi_rec_type;
BEGIN
   tab_m_proizvodi.postavi_iterator;
   WHILE tab_m_proizvodi.ima_jos LOOP
      zapis_l := tab_m_proizvodi.slijedeci_red;
      
     IF zapis_l.ozn_proizvoda = '1' THEN
        pra_sastav.proizvodi (
           id_p     => zapis_l.id,
           razina_p => zapis_l.razina);

        pra_sastav.pro_provjeri_kvazi_nam (
           pro_id_p     => zapis_l.id,
           pro_nam_id_p => zapis_l.pro_nam_id);
     END IF;
   END LOOP;
END AUS_M_PROIZVODI;
/
SHOW ERROR


PROMPT Creating Trigger 'AS_M_PROIZVODI'
CREATE OR REPLACE TRIGGER AS_M_PROIZVODI
 AFTER DELETE OR INSERT OR UPDATE
 ON M_PROIZVODI
BEGIN
   replikacija.azuriraj_retke (
      aplikacija_p => 'ZMP',
      tablica_p    => 'm_proizvodi');
END AS_M_PROIZVODI;
/
SHOW ERROR


PROMPT Creating Trigger 'BUR_M_PROIZVODI'
CREATE OR REPLACE TRIGGER BUR_M_PROIZVODI
 BEFORE UPDATE
 ON M_PROIZVODI
 FOR EACH ROW
DECLARE

   proizvodi_rec_l tab_m_proizvodi.proizvodi_rec_type;
BEGIN
   pra_ozn_valjanosti.provjeri_ozn_valjanosti 
      (:OLD.ozn_valjanosti, :NEW.ozn_valjanosti);

   pra_sifre_artikala.namirnice (:NEW.sifra);
   pra_sifre_artikala.sirovine (:NEW.sifra);
   pra_sastav.provjeri_upis_sastava(:NEW.id, :NEW.ozn_proizvoda);

   pra_sifra_proizvoda_kasa.proizvodi (
      :OLD.id,
      :OLD.sif_proizvoda_kasa,
      :NEW.sif_proizvoda_kasa);

   proizvodi_rec_l.id := :NEW.id;
   proizvodi_rec_l.razina := :NEW.razina;  
   proizvodi_rec_l.ozn_proizvoda := :NEW.ozn_proizvoda; 
   IF :NEW.pro_nam_id IS NOT NULL
      AND NVL (:OLD.pro_nam_id, -1) <> NVL (:NEW.pro_nam_id, -1)
   THEN
      /* Podaci za provjeru kvazi namirnice */
      proizvodi_rec_l.pro_nam_id := :NEW.pro_nam_id;
   END IF;
   
   tab_m_proizvodi.upisi_u_tablicu (proizvodi_rec_l);

   /*
   Ako je u toku dnevni obraun/ponitavanje ili kalkulacija PC proizvoda,
   audit polja se ne mijenjaju.
   */
   IF    bm_gas3010.obrada_u_toku
      OR bm_gas3020.obrada_u_toku
      OR bm_gas3090.obrada_u_toku
   THEN
      RETURN;
   END IF;                               
   
   pra_zmp_s2.provjeri_kpd (:NEW.kpd_id);
    
   gas_zaj.upisi_audit (
      :NEW.unos_korisnik, :NEW.unos_dat,
      :NEW.izmjena_korisnik, :NEW.izmjena_dat);
END BUR_M_PROIZVODI;
/
SHOW ERROR


PROMPT Creating Trigger 'BUS_M_PROIZVODI'
CREATE OR REPLACE TRIGGER BUS_M_PROIZVODI
 BEFORE UPDATE
 ON M_PROIZVODI
BEGIN
   tab_m_proizvodi.brisi_tablicu;
END BUS_M_PROIZVODI;
/
SHOW ERROR


PROMPT Creating Trigger 'BIR_M_PROIZVODI'
CREATE OR REPLACE TRIGGER BIR_M_PROIZVODI
 BEFORE INSERT
 ON M_PROIZVODI
 FOR EACH ROW
BEGIN
   -- IRN 2888
   IF SYS_CONTEXT ('LOGINFO_CTX', 'SSOUSER') = 'ITNEW'
     AND SYS_CONTEXT ('LOGINFO_CTX', 'VLASNIKPODATKA') = pra_zmp_zaj.vrijednost_parametra ('0999')
   THEN
     RETURN; -- izlaz iz trigera
   END IF;
    
   pra_ozn_valjanosti.provjeri_ozn_valjanosti
      (NULL, :NEW.ozn_valjanosti);

   pra_sifre_artikala.namirnice (:NEW.sifra);
   pra_sifre_artikala.sirovine (:NEW.sifra);
   pra_sastav.provjeri_upis_sastava(:NEW.id, :NEW.ozn_proizvoda);

   pra_sifra_proizvoda_kasa.proizvodi (
      :OLD.id,
      :OLD.sif_proizvoda_kasa,
      :NEW.sif_proizvoda_kasa);

   pra_zmp_s2.provjeri_kpd (:NEW.kpd_id);
   
   :NEW.id := gas_zaj.sekvenca (:NEW.id);

   gas_zaj.upisi_audit (
      :NEW.unos_korisnik,:NEW.unos_dat,
      :NEW.izmjena_korisnik,:NEW.izmjena_dat);
END BIR_M_PROIZVODI;
/
SHOW ERROR























