-- C:\mish_cvs\misH_skripte\gas_zaj.pkb
--
-- Generated for Oracle 10g on Wed Jun 18  13:54:13 2025 by Server Generator 6.5.96.5.6
 

PROMPT Creating Package Body 'GAS_ZAJ'
CREATE OR REPLACE PACKAGE BODY GAS_ZAJ IS

FUNCTION GODINA_VLASNIKA
 RETURN VARCHAR2
 IS
godina_L sgas_vlasnik.godina%TYPE;
BEGIN
   SELECT godina INTO godina_L
     FROM sgas_vlasnik;

   RETURN godina_L;
END;
FUNCTION SISTEMSKI_DATUM
 RETURN DATE
 IS
datum_L DATE;
BEGIN
   SELECT SYSDATE INTO datum_L 
     FROM DUAL;

   RETURN TRUNC (datum_L); 
END;
FUNCTION SEKVENCA
 (ID_P NUMBER
 )
 RETURN NUMBER
 IS
BEGIN
   RETURN pra_zmp_zaj.i3_sekvenca (id_p);
END;
PROCEDURE UPISI_AUDIT
 (KORISNIK_UNOS_P IN OUT VARCHAR2
 ,DATUM_UNOS_P IN OUT DATE
 ,KORISNIK_IZMJENE_P IN OUT VARCHAR2
 ,DATUM_IZMJENE_P IN OUT DATE
 )
 IS
BEGIN
   IF korisnik_unos_p IS NULL THEN
      korisnik_unos_p := zmp_zaj.korisnik (-1);
      datum_unos_p    := SYSDATE;
   END IF;
   korisnik_izmjene_p := zmp_zaj.korisnik (-1);
   datum_izmjene_p := SYSDATE;
END;
PROCEDURE VRATI_PORUKU
 (SIFRA_P IN S_PORUKE.SIFRA%TYPE
 ,VAR0_P IN VARCHAR2 := NULL
 ,VAR1_P IN VARCHAR2 := NULL
 ,VAR2_P IN VARCHAR2 := NULL
 ,VAR3_P IN VARCHAR2 := NULL
 ,VAR4_P IN VARCHAR2 := NULL
 ,VAR5_P IN VARCHAR2 := NULL
 ,VAR6_P IN VARCHAR2 := NULL
 ,VAR7_P IN VARCHAR2 := NULL
 ,VAR8_P IN VARCHAR2 := NULL
 ,VAR9_P IN VARCHAR2 := NULL
 )
 IS
tekst_L s_poruke.tekst%TYPE;
vrsta_L s_poruke.vrsta%TYPE;
BEGIN
   pra_zmp_zaj.vrati_poruku_zaj (
      'GAS', sifra_P,
      var0_p, var1_p, var2_p, var3_p, var4_p,
      var5_p, var6_p, var7_p, var8_p, var9_p);
END;
PROCEDURE BATCH_ZABRANA
 (DAT_DOKUMENTA_P IN L_OBRACUN.DATUM%TYPE
 ,OZN_OBRACUNA_P IN L_OBRACUN.OZNAKA%TYPE
 )
 IS
brojac_L                  NUMBER;
dat_zadnjeg_do_L l_obracun.datum%TYPE;
dat_inv_L                 l_obracun.datum%TYPE;
CURSOR c_primjena  IS    
  SELECT vla.dat_primjene_domval
    FROM s_vlasnik vla
   WHERE pra_zmp_zaj.zmppar_vrijednost('ZMP', '0002') = 'HR';

dat_primjena_l t_ulazdok.datum%TYPE;
BEGIN   
    OPEN c_primjena;
   FETCH c_primjena INTO dat_primjena_l;
   CLOSE c_primjena;    
                  
    IF dat_primjena_l IS NOT  NULL AND TRUNC(SYSDATE) >= dat_primjena_l THEN
      IF (dat_dokumenta_p >= dat_primjena_l AND  pra_pka_domval.hrk_arhiva = -1 )
         OR  (dat_dokumenta_p < dat_primjena_l AND  pra_pka_domval.hrk_arhiva = 0 )
      THEN
         IF  pra_pka_domval.hrk_arhiva = -1 THEN
             RAISE_APPLICATION_ERROR (-20000, '  Nije dozvoljeno auriranje dokumenata ili pokretanje obrada za datum > 31.12.2022 na HRK emi');
         ELSE
             IF NOT DELETING THEN
               RAISE_APPLICATION_ERROR (-20000, '  Nije dozvoljeno auriranje dokumenata ili pokretanje obrada za datum < 01.01.2023 na EUR emi');
             END IF;
         END IF;
      END IF;
    END IF;

   
   SELECT MAX (datum) INTO dat_inv_L
     FROM l_obracun
    WHERE oznaka = '40';   
     
   /* dozvoljava se unos i izmjena dokumenata na SYSDATE za minibar, VGE, vage ... ukuliko nije napravljena inventura  
       osim za HNB koji svaki dan radi prijepis na POS i izraun pnc je na novou sheme
   */     
   IF UPPER (pra_zmp_zaj.tekuci_cvor) <> 'HNBGASTRO' THEN
       IF TRUNC(dat_dokumenta_p) = TRUNC(SYSDATE) AND dat_inv_l < TRUNC(SYSDATE) THEN 
          RETURN;
       END IF;
   END IF;
   
   zakljucaj_dokument;

   SELECT COUNT (1) INTO brojac_L
     FROM l_obracun
    WHERE datum  = dat_dokumenta_P
      AND oznaka = ozn_obracuna_P;

   IF brojac_L <> 0 THEN
      vrati_poruku (-20029); -- datum dokumenta jednak je datumu obrauna
   END IF;

   SELECT MAX (datum) INTO dat_zadnjeg_do_L
     FROM l_obracun
    WHERE oznaka = '00';

   IF dat_zadnjeg_do_L IS NOT NULL
      AND dat_zadnjeg_do_L > dat_dokumenta_P
   THEN
      vrati_poruku (-20040); -- datum dokumenta manji je od datuma zadnjeg dnevnog obrauna
   END IF;
END;
PROCEDURE ZAKLJUCAJ_DOKUMENT
 IS
BEGIN
   /*
   Tablica se zakljuava u djeljivom modu.
   Zakljuavanje ne uspijeva ako je obraun zakljuao tablicu u ekskluzivnom modu.
   */
   IF sys_context('LOGINFO_CTX', 'VLASNIKPODATKA') IS NULL THEN
      LOCK TABLE l_obracun IN SHARE MODE NOWAIT;
   ELSE
      EXECUTE IMMEDIATE
         'LOCK TABLE lock_' || sys_context('LOGINFO_CTX', 'VLASNIKPODATKA') || ' IN SHARE MODE NOWAIT';
   END IF;
EXCEPTION
   WHEN OTHERS THEN
      IF SQLCODE = -54 THEN
         vrati_poruku (-20034);
      ELSIF SQLCODE = -942 THEN
         NULL; -- greka "table or view does not exists" se ne alje dalje
      ELSE
         RAISE;
      END IF;
END;
PROCEDURE ZAKLJUCAJ_OBRACUN
 IS
BEGIN
   /*
   Tablica se zakljuava u ekskluzivnom modu.
   Zakljuavanje ne uspijeva ako je ve zakljuana u djeljivom ili ekskluzivnom modu.
   */
   IF sys_context('LOGINFO_CTX', 'VLASNIKPODATKA') IS NULL THEN
      LOCK TABLE l_obracun IN EXCLUSIVE MODE NOWAIT;
   ELSE
      EXECUTE IMMEDIATE
         'LOCK TABLE lock_' || sys_context('LOGINFO_CTX', 'VLASNIKPODATKA') || ' IN EXCLUSIVE MODE NOWAIT';
   END IF;
EXCEPTION
   WHEN OTHERS THEN
      IF SQLCODE = -54 THEN
         vrati_poruku (-20039);
      ELSIF SQLCODE = -942 THEN
         NULL; -- greka "table or view does not exists" se ne alje dalje
      ELSE
         RAISE;
      END IF;
END;
FUNCTION TEKUCA_GODINA
 (DATUM_P L_OBRACUN.DATUM%TYPE
 )
 RETURN BOOLEAN
 IS
BEGIN
   IF TRUNC (NVL (datum_P, TO_DATE ('01.01.9999', 'dd.mm.yyyy')), 'YEAR') =
      TRUNC (SYSDATE, 'YEAR')
   THEN
      RETURN TRUE;
   ELSE
      RETURN FALSE;
   END IF;
END;
FUNCTION PODREDEN
 (OJ_ID_POD_P IN M_MT.ID%TYPE
 ,OJ_ID_NAD_P IN M_MT.ID%TYPE
 )
 RETURN INTEGER
 IS
BEGIN
   IF oj_id_pod_p = oj_id_nad_p THEN
      RETURN (0);
   ELSE
      RETURN pra_zmp.oj_pripada_oj (oj_id_pod_p, oj_id_nad_p);
   END IF;
END;
FUNCTION OJ_VLASNIKA
 RETURN NUMBER
 IS
oj_id_L  m_oj.id%TYPE;
BEGIN
   SELECT oj_id INTO oj_id_L
     FROM sgas_vlasnik;

   RETURN oj_id_L;
END;
FUNCTION AKTIVNI_GAT
 (DATUM_P IN DATE
 ,MT_ID_P IN m_mt.id%TYPE
 )
 RETURN INTEGER
 IS
aktivni_gat_l   VARCHAR2(1);
aktivna_l          INTEGER := 0;
datum_l           DATE;
BEGIN
  IF datum_p IS NULL AND mt_id_p IS NULL THEN
    SELECT obrada_gas
      INTO aktivni_gat_l
      FROM nst_gas_obrada;

    IF aktivni_gat_l  =  'D'  THEN
       aktivna_l := -1;
    END IF;
  ELSE
    SELECT MIN(datum)
      INTO datum_l
      FROM tnst_kalk_gas
     WHERE mt_id = mt_id_p;

    IF datum_p  >=  datum_l  AND gas_zaj.aktivni_gat( NULL, NULL) =  -1 THEN
        aktivna_l := -1;
    END IF;
   END IF;

   RETURN aktivna_L;
END;
PROCEDURE VRATI_GODINU
 (DATUM_P IN DATE
 ,GODINA_P OUT VARCHAR2
 )
 IS
brojac_l NUMBER;
godina_l t_ulazdok.godina%TYPE;
BEGIN
  IF datum_p IS NULL THEN
     RETURN;
  END IF;

  godina_P := TO_CHAR(datum_p, 'YYYY');
   
  IF ABS(godina_P - TO_CHAR(SYSDATE, 'YYYY')) > 1 THEN
     gas_zaj.vrati_poruku (-20106,TO_CHAR(datum_P, 'DD.MM.RRRR'));
  END IF;  
END;
FUNCTION GODINA
 RETURN VARCHAR2
 IS
godina_l t_ulazdok.godina%type;
BEGIN     
   IF pra_zmp_zaj.zmppar_vrijednost ('GAS', '1005') <> 'nebitno'  THEN
      godina_l := pra_zmp_zaj.zmppar_vrijednost ('GAS', '1005');
   END IF;
   return godina_l;
END;
PROCEDURE PROVJERI_OBR_TEM
 (DATUM_P IN DATE
 )
 IS
brojac_l NUMBER;
datum_l DATE;
BEGIN
   IF pra_zmp_zaj.zmppar_vrijednost('GAS','1007') = 'da' THEN
         SELECT COUNT(*) INTO brojac_l
          FROM mgas_razdoblja gasraz,
               sgas_vlasnik vlasnik
         WHERE datum_P <= datum_poc 
           AND gasraz.oznaka = 'T'
           AND pra_zmp.oj_pripada_oj (gasraz.oj_id,(SELECT oj_id FROM sgas_vlasnik)) = -1;

         IF brojac_l > 0    THEN
            SELECT MAX(datum_poc) INTO datum_l
              FROM mgas_razdoblja gasraz,
                   sgas_vlasnik vlasnik
             WHERE datum_P <= datum_poc  
               AND gasraz.oznaka = 'T'
               AND pra_zmp.oj_pripada_oj (gasraz.oj_id,(SELECT oj_id FROM sgas_vlasnik)) = -1;
	         gas_zaj.vrati_poruku  (-20227, TO_CHAR(datum_l,'DD.MM.YYYY'));
         END IF;
    END IF;
END;
PROCEDURE POREZI
 (GPOR_ID_P IN M_GPOREZ.ID%TYPE
 ,DATUM_P IN T_ULAZDOK.DATUM%TYPE
 ,PDV_P OUT M_GPOREZ.PPOT%TYPE
 ,PPOT_P OUT M_GPOREZ.PPOT%TYPE
 )
 IS
gpor_sifra_l  m_gporez.sifra%TYPE;
gpor_naziv_l m_gporez.naziv%TYPE;
BEGIN
 IF gpor_id_p IS NULL OR datum_p IS NULL THEN
    RETURN;
 END IF;
 
 SELECT sifra, naziv
   INTO gpor_sifra_l, gpor_naziv_l
   FROM m_gporez
  WHERE id = gpor_id_p;
    
 SELECT vpispz.stopa, gpor.ppot 
   INTO pdv_p, ppot_p 
   FROM m_gporez gpor,
        mgas_gpor_raz grazgpor,
        s_vpisporukap vpispp,
        s_vpisporukaz vpispz
  WHERE gpor.id = gpor_id_p
    AND gpor.id = grazgpor.gpor_id
    AND datum_p BETWEEN grazgpor.dat_valjan AND NVL(grazgpor.dat_ponisten,TO_DATE('01.01.2999','DD.MM.YYYY'))
    AND vpispp.id = grazgpor.vpispp_id
    AND vpispp.vpispz_id = vpispz.id; 
EXCEPTION  
   WHEN NO_DATA_FOUND THEN
    gas_zaj.vrati_poruku  ('-20429',gpor_sifra_l||' '||gpor_naziv_l);
END;
FUNCTION MIJENJANI_DOKUMENTI
 (DATUM_P IN L_OBRACUN.DATUM%TYPE
 )
 RETURN DATE
 IS
datum_do_l l_obracun.datum%TYPE;
  datum_l    l_obracun.datum%TYPE:= NULL;
BEGIN                      
    
  /* Ako se provjera radi iz dnevnog obrauna tada se uzima zadnji datum do.
     Iz temeljnice se alje samo zavrni datum i kontrolira se samo zavrni datum, prethodni datumi su provjernim dnevnim obraunom. 
  */
  IF datum_p IS NULL THEN  
     SELECT MAX(datum)
       INTO datum_do_l
       FROM l_obracun;  
  ELSE 
     datum_do_l := datum_p;
  END IF;  
   SELECT MIN(datum)
     INTO datum_l 
     FROM
     (SELECT MIN(ulaz.datum) datum
        FROM t_ulazdok ulaz,
             t_ulazdok_art ulazart, 
             l_obracun l 
       WHERE l.datum = datum_do_l  
         AND ulaz.datum = l.datum
         AND ulaz.id = ulazart.ulaz_id
         AND oznaka = '00'
         AND (l.izmjena_dat < ulaz.izmjena_dat OR l.izmjena_dat < ulazart.izmjena_dat)
       UNION
      SELECT MIN(pri.datum) datum
        FROM t_prijelaz pri,
             t_prijelaz_art priart, 
             l_obracun l 
       WHERE l.datum = datum_do_l  
         AND pri.datum = l.datum
         AND pri.id = priart.pri_id
         AND oznaka = '00'
         AND (l.izmjena_dat < pri.izmjena_dat OR l.izmjena_dat < priart.izmjena_dat)
       UNION
      SELECT MIN(izl.datum) datum
        FROM t_izlaz izl,
             t_izlaz_art izlart, 
             l_obracun l 
       WHERE l.datum = datum_do_l  
         AND izl.datum = l.datum
         AND izl.id = izlart.izl_id
         AND oznaka = '00'
         AND izlart.kol_izlaz <> 0
         AND (l.izmjena_dat < izl.izmjena_dat OR l.izmjena_dat < izlart.izmjena_dat)  
       UNION
      SELECT MIN(rn.datum) datum
        FROM t_rnkase rn,
             t_rnkase_pro rnpro, 
             l_obracun l 
       WHERE l.datum = datum_do_l  
         AND rn.datum = l.datum
         AND rn.id = rnpro.rn_id
         AND oznaka = '00'
         AND l.izmjena_dat < rnpro.izmjena_dat  
       UNION 
      SELECT MIN(otp.datum) datum
        FROM t_otpis otp,
             t_otpis_art otpart, 
             l_obracun l 
       WHERE l.datum = datum_do_l  
         AND otp.datum = l.datum
         AND otp.id = otpart.otp_id
         AND oznaka = '00'
         AND (l.izmjena_dat < otp.izmjena_dat OR l.izmjena_dat < otpart.izmjena_dat)    
       UNION   
      SELECT MIN(otp.datum) datum
        FROM t_otpisamb otp,
             t_otpisamb_amb otpamb, 
             l_obracun l 
       WHERE l.datum = datum_do_l  
         AND otp.datum = l.datum
         AND otp.id = otpamb.otpamb_id
         AND oznaka = '00'
         AND (l.izmjena_dat < otp.izmjena_dat OR l.izmjena_dat < otpamb.izmjena_dat)
       UNION
      SELECT MIN(gasrnal.datum) datum
        FROM tgas_rnalog gasrnal,
             tgas_rnalog_art gasrnalart, 
             l_obracun l 
       WHERE l.datum = datum_do_l  
         AND gasrnal.datum = l.datum
         AND gasrnal.id = gasrnalart.rnal_id
         AND oznaka = '00'
         AND (l.izmjena_dat < gasrnal.izmjena_dat OR l.izmjena_dat < gasrnalart.izmjena_dat)  
       UNION
      SELECT MIN(izldok.datum) datum
        FROM tgas_izlazdok izldok,
             tgas_izlazdok_art izldokart, 
             l_obracun l 
       WHERE l.datum = datum_do_l  
         AND izldok.datum = l.datum
         AND izldok.id = izldokart.gasizldok_id
         AND oznaka = '00'
         AND (l.izmjena_dat < izldok.izmjena_dat OR l.izmjena_dat < izldokart.izmjena_dat));  
     RETURN datum_l;
END;
PROCEDURE PROVJERI_DATUM_ZAV
 (MT_ID_P IN M_MT.ID%TYPE
 ,DATUM_P IN DATE
 )
 IS
  datum_l DATE;
BEGIN
  SELECT NVL(gasrazdob.datum_poc, TO_DATE('01.01.0001', 'dd.mm.rrrr')) INTO datum_l 
    FROM mgas_razdoblja gasrazdob
   WHERE gasrazdob.oznaka = 'T'
     AND pra_zmp.oj_pripada_oj (mt_id_p, gasrazdob.oj_id) = -1
     AND datum_p <= NVL(gasrazdob.datum_poc, TO_DATE('01.01.0001', 'dd.mm.rrrr'));

  IF datum_p <= datum_l THEN
    vrati_poruku(-20512, to_char(datum_l,'dd.mm.yyyy'));
  END IF;
  
  EXCEPTION 
    WHEN NO_DATA_FOUND THEN
      NULL;
END;
FUNCTION BROJ_GAS_SHEMA
 RETURN INTEGER
 IS
broj_l NUMBER(2);
BEGIN
   SELECT COUNT(*) INTO broj_l 
     FROM smet_instalacije 
    WHERE metapl_sifra = 'GAS';
    
   RETURN broj_l; 
 END;
FUNCTION VRATI_OJ_PODUZECA
 (MT_ID_P IN m_oj.id%TYPE
 )
 RETURN NUMBER
 IS
  oj_id_l NUMBER;
  level_l NUMBER;
  CURSOR c_oj (mt_id_p IN NUMBER, level_l IN NUMBER) IS
   SELECT xx.ID
   	 FROM (SELECT x.id,
                  x.sifra,
                  x.lev,
                  MAX(x.lev) OVER(PARTITION BY x.kol) max_lev
            FROM (SELECT id, sifra, LEVEL lev, 1 kol
                    FROM m_oj
                  START WITH id = mt_id_p
                  CONNECT BY PRIOR oj_id = ID) x) xx
           WHERE xx.lev = xx.max_lev - level_l;
BEGIN
   IF pra_zmp_zaj.zmppar_vrijednost('MATMOB','0002') = 'nebitno' THEN 
     level_l := 0;
   ELSE  
     level_l := to_number(pra_zmp_zaj.zmppar_vrijednost('MATMOB','0002'));
   END IF;  
   OPEN c_oj (mt_id_p, level_l);
   FETCH c_oj INTO oj_id_l;
   CLOSE c_oj;
   
   RETURN oj_id_l;
 END;

END GAS_ZAJ;
/
SHOW ERROR

