PROMPT Creating Package Body 'FM_REC4625'
CREATE OR REPLACE PACKAGE BODY FM_REC4625 IS
-- Private Declaration 

prog_tab_m prog_tab_type;
brojac_m INTEGER;
--
so_id_m irec_prog_stavke.so_id%TYPE;
oj_id_m m_oj.id%TYPE;
ms_id_m irec_prog_stavke.ms_id%TYPE;
vsj_id_m irec_prog_stavke.vsj_id%TYPE;
dat_poc_m irec_prog_stavke.datum%TYPE;
dat_zav_m irec_prog_stavke.datum%TYPE;
ozn_sprodaje_m irec_prog_stavke.ozn_sprodaje%TYPE;
vms_id_m m_msegmenti.vms_id%TYPE;
gms_id_m m_msegmenti.zmpgms_id%TYPE;
ozn_podatka_m VARCHAR2(20);
ozn_grupe_m VARCHAR2(5);
dat_povijesti_m irec_prog_stavke_h.na_dan%TYPE;
ozn_prihoda1_m NUMBER;
ozn_prihoda2_m NUMBER;
ozn_prihoda3_m NUMBER;
ozn_prihoda4_m NUMBER;
rbr_poc_m NUMBER;
ozn_perioda_m VARCHAR2(1);

-- END Private Declaration


PROCEDURE BRISI_PROG_TAB
 IS
BEGIN
  prog_tab_m.DELETE;
  brojac_m := 1;
END;
PROCEDURE CITAJ_PROG_TAB
 (PROG_TAB_P IN OUT prog_tab_type
 )
 IS
BEGIN
  prog_tab_p := prog_tab_m;
END;
PROCEDURE PUNI_PROG_TAB
 (SO_ID_P IN irec_prog_stavke.so_id%TYPE
 ,OJ_ID_P IN m_oj.id%TYPE
 ,MS_ID_P IN irec_prog_stavke.ms_id%TYPE
 ,VSJ_ID_P IN irec_prog_stavke.vsj_id%TYPE
 ,DAT_POC_P IN irec_prog_stavke.datum%TYPE
 ,DAT_ZAV_P IN irec_prog_stavke.datum%TYPE
 ,OZN_SPRODAJE_P IN irec_prog_stavke.ozn_sprodaje%TYPE
 ,VMS_ID_P IN m_msegmenti.vms_id%TYPE
 ,GMS_ID_P IN m_msegmenti.zmpgms_id%TYPE
 ,OZN_PODATKA_P IN VARCHAR2
 ,OZN_GRUPE_P IN VARCHAR2
 ,DAT_POVIJESTI_P IN irec_prog_stavke_h.na_dan%TYPE
 ,OZN_PRIHODA1_P IN NUMBER
 ,OZN_PRIHODA2_P IN NUMBER
 ,OZN_PRIHODA3_P IN NUMBER
 ,OZN_PRIHODA4_P IN NUMBER
 ,RBR_POC_P IN NUMBER
 ,OZN_PERIODA_P IN VARCHAR2
 )
 IS

--
  i INTEGER := 0;
  datum_l DATE := zmp_zaj.set_dates (dat_poc_p, dat_zav_p);
BEGIN

  brisi_prog_tab;

  -- puni varijable paketa
  so_id_m := so_id_p;
  oj_id_m := oj_id_p;
  ms_id_m := ms_id_p;
  vsj_id_m := vsj_id_p;
  dat_poc_m := dat_poc_p;
  dat_zav_m := dat_zav_p;
  ozn_sprodaje_m := ozn_sprodaje_p;
  vms_id_m := vms_id_p;
  gms_id_m := gms_id_p;
  ozn_podatka_m := ozn_podatka_p;
  ozn_grupe_m := ozn_grupe_p;
  dat_povijesti_m := dat_povijesti_p;
  ozn_prihoda1_m := ozn_prihoda1_p;
  ozn_prihoda2_m := ozn_prihoda2_p;
  ozn_prihoda3_m := ozn_prihoda3_p;
  ozn_prihoda4_m := ozn_prihoda4_p;
  rbr_poc_m := rbr_poc_p;
  ozn_perioda_m := ozn_perioda_p;

  -- puni sifre odabrane grupe npr. MS
  puni_sifre;

  -- puni PL/SQL tablicu po odabranom periodu i grupiranju npr. dnevno po MS
  FOR prog_c IN (
    SELECT
      datum,
      SUM (podatak1) AS podatak1,
      SUM (podatak2) AS podatak2,
      SUM (podatak3) AS podatak3,
      SUM (podatak4) AS podatak4,
      SUM (podatak5) AS podatak5,
      SUM (podatak6) AS podatak6,
      SUM (podatak7) AS podatak7,
      SUM (podatak8) AS podatak8,
      SUM (podatak9) AS podatak9,
      SUM (podatak10) AS podatak10,
      SUM (podatak11) AS podatak11,
      SUM (podatak12) AS podatak12,
      SUM (podatak13) AS podatak13,
      SUM (podatak14) AS podatak14,
      SUM (podatak15) AS podatak15,
      SUM (podatak16) AS podatak16,
      SUM (podatak17) AS podatak17,
      SUM (podatak18) AS podatak18,
      SUM (podatak19) AS podatak19,
      SUM (podatak20) AS podatak20,
      SUM (podatak21) AS podatak21,
      SUM (podatak22) AS podatak22,
      SUM (podatak23) AS podatak23,
      SUM (podatak24) AS podatak24,
      SUM (podatak25) AS podatak25,
      SUM (podatak26) AS podatak26,
      SUM (podatak27) AS podatak27,
      SUM (podatak28) AS podatak28,
      SUM (podatak29) AS podatak29,
      SUM (podatak30) AS podatak30,
      CASE
        WHEN ozn_podatka_m IN ('ADR_SJ', 'ADR_POS', 'PLAN_ADR_SJ', 'PLAN_ADR_POS') THEN
          CASE
            WHEN (SUM (izn_prihoda) = 0 OR SUM (djelitelj) = 0)
            THEN
              0
            ELSE
              ROUND (SUM (izn_prihoda) / SUM (djelitelj), 2)
            END
        ELSE
          SUM (ostalo)
      END AS ostalo,
      CASE
        WHEN ozn_podatka_m IN ('ADR_SJ', 'ADR_POS', 'PLAN_ADR_SJ', 'PLAN_ADR_POS') THEN
          CASE
            WHEN (SUM (izn_prihoda_uk) = 0 OR SUM (djelitelj_uk) = 0)
            THEN
              0
            ELSE
              ROUND (SUM (izn_prihoda_uk) / SUM (djelitelj_uk), 2)
            END
        ELSE
          SUM (ukupno)
      END AS ukupno
    FROM
      (
      SELECT
        prom.datum,
        DECODE (mat.rbr, rbr_poc_m,      SUM (prom.podatak), NULL) AS podatak1,
        DECODE (mat.rbr, rbr_poc_m + 1,  SUM (prom.podatak), NULL) AS podatak2,
        DECODE (mat.rbr, rbr_poc_m + 2,  SUM (prom.podatak), NULL) AS podatak3,
        DECODE (mat.rbr, rbr_poc_m + 3,  SUM (prom.podatak), NULL) AS podatak4,
        DECODE (mat.rbr, rbr_poc_m + 4,  SUM (prom.podatak), NULL) AS podatak5,
        DECODE (mat.rbr, rbr_poc_m + 5,  SUM (prom.podatak), NULL) AS podatak6,
        DECODE (mat.rbr, rbr_poc_m + 6,  SUM (prom.podatak), NULL) AS podatak7,
        DECODE (mat.rbr, rbr_poc_m + 7,  SUM (prom.podatak), NULL) AS podatak8,
        DECODE (mat.rbr, rbr_poc_m + 8,  SUM (prom.podatak), NULL) AS podatak9,
        DECODE (mat.rbr, rbr_poc_m + 9,  SUM (prom.podatak), NULL) AS podatak10,
        DECODE (mat.rbr, rbr_poc_m + 10, SUM (prom.podatak), NULL) AS podatak11,
        DECODE (mat.rbr, rbr_poc_m + 11, SUM (prom.podatak), NULL) AS podatak12,
        DECODE (mat.rbr, rbr_poc_m + 12, SUM (prom.podatak), NULL) AS podatak13,
        DECODE (mat.rbr, rbr_poc_m + 13, SUM (prom.podatak), NULL) AS podatak14,
        DECODE (mat.rbr, rbr_poc_m + 14, SUM (prom.podatak), NULL) AS podatak15,
        DECODE (mat.rbr, rbr_poc_m + 15, SUM (prom.podatak), NULL) AS podatak16,
        DECODE (mat.rbr, rbr_poc_m + 16, SUM (prom.podatak), NULL) AS podatak17,
        DECODE (mat.rbr, rbr_poc_m + 17, SUM (prom.podatak), NULL) AS podatak18,
        DECODE (mat.rbr, rbr_poc_m + 18, SUM (prom.podatak), NULL) AS podatak19,
        DECODE (mat.rbr, rbr_poc_m + 19, SUM (prom.podatak), NULL) AS podatak20,
        DECODE (mat.rbr, rbr_poc_m + 20, SUM (prom.podatak), NULL) AS podatak21,
        DECODE (mat.rbr, rbr_poc_m + 21, SUM (prom.podatak), NULL) AS podatak22,
        DECODE (mat.rbr, rbr_poc_m + 22, SUM (prom.podatak), NULL) AS podatak23,
        DECODE (mat.rbr, rbr_poc_m + 23, SUM (prom.podatak), NULL) AS podatak24,
        DECODE (mat.rbr, rbr_poc_m + 24, SUM (prom.podatak), NULL) AS podatak25,
        DECODE (mat.rbr, rbr_poc_m + 25, SUM (prom.podatak), NULL) AS podatak26,
        DECODE (mat.rbr, rbr_poc_m + 26, SUM (prom.podatak), NULL) AS podatak27,
        DECODE (mat.rbr, rbr_poc_m + 27, SUM (prom.podatak), NULL) AS podatak28,
        DECODE (mat.rbr, rbr_poc_m + 28, SUM (prom.podatak), NULL) AS podatak29,
        DECODE (mat.rbr, rbr_poc_m + 29, SUM (prom.podatak), NULL) AS podatak30,
        CASE
          WHEN mat.rbr < rbr_poc_m OR mat.rbr > rbr_poc_m + 29
          THEN
            SUM (prom.podatak)
          ELSE
            NULL
        END AS ostalo,
        DECODE (mat.rbr, NULL, NULL, SUM (prom.podatak)) AS ukupno,
        CASE
          WHEN mat.rbr < rbr_poc_m OR mat.rbr > rbr_poc_m + 29
          THEN
            SUM (prom.izn_prihoda)
          ELSE
            NULL
        END AS izn_prihoda,
        CASE
          WHEN mat.rbr < rbr_poc_m OR mat.rbr > rbr_poc_m + 29
          THEN
            SUM (prom.djelitelj)
          ELSE
            NULL
        END AS djelitelj,
        DECODE (mat.rbr, NULL, NULL, SUM (prom.izn_prihoda)) AS izn_prihoda_uk,
        DECODE (mat.rbr, NULL, NULL, SUM (prom.djelitelj)) AS djelitelj_uk
      FROM
        (
        SELECT
          kal.datum,
          st2.sifra,
          DECODE (REPLACE (ozn_podatka_m, 'PLAN_'),
            'KOL_SJ', SUM (st2.kol_sj),
            'BR_OSOBA', SUM (st2.br_osoba),
            'KOL_SJ_DOL', SUM (st2.kol_sj_dol),
            'BR_OSOBA_DOL', SUM (st2.br_osoba_dol),
            'PRIHOD', SUM (st2.izn_prihoda),
            'ADR_SJ',
              CASE
                WHEN (SUM (st2.izn_prihoda) = 0 OR SUM (st2.kol_sj) = 0)
                THEN
                  0
                ELSE
                  ROUND (SUM (st2.izn_prihoda) / SUM (st2.kol_sj), 2)
              END,
            'ADR_POS',
              CASE
                WHEN (SUM (st2.izn_prihoda) = 0 OR SUM (st2.br_osoba) = 0)
                THEN
                  0
                ELSE
                  ROUND (SUM (st2.izn_prihoda) / SUM (st2.br_osoba), 2)
              END
          ) podatak,
          SUM (st2.izn_prihoda) AS izn_prihoda,
          DECODE (REPLACE (ozn_podatka_m, 'PLAN_'), 'ADR_SJ', SUM (st2.kol_sj), 'ADR_POS', SUM (st2.br_osoba))
            AS djelitelj
        FROM
          (
          -- Prognoza
          SELECT
            DECODE (ozn_perioda_m, 'G', TRUNC (st.datum, 'YYYY'), 'M', TRUNC (st.datum, 'MM'), st.datum) AS datum,
            DECODE (ozn_grupe_m, 'SO', so.sifra, 'VSJ', vsj.sifra, 'MS', ms.sifra, 'GMS', zmpgms.sifra, 'VMS', vms.sifra) AS sifra,
            SUM (st.kol_sj) AS kol_sj,
            SUM (st.br_osoba) AS br_osoba,
            SUM (st.kol_sj_dol) AS kol_sj_dol,
            SUM (st.br_osoba_dol) AS br_osoba_dol,
            DECODE (ozn_prihoda1_m, -1, SUM (st.izn_prihodann_1), 0)
              + DECODE (ozn_prihoda2_m, -1, SUM (st.izn_prihodann_2), 0)
              + DECODE (ozn_prihoda3_m, -1, SUM (st.izn_prihodann_3), 0)
              + DECODE (ozn_prihoda4_m, -1, SUM (st.izn_prihodann_4), 0)
              AS izn_prihoda
          FROM
            irec_prog_stavke st,
            m_so so,
            s_vsj vsj,
            m_msegmenti ms,
            mzmp_gms zmpgms,
            s_vmsegmenata vms
          WHERE
            ozn_podatka_m IN ('KOL_SJ', 'BR_OSOBA', 'KOL_SJ_DOL', 'BR_OSOBA_DOL', 'PRIHOD', 'ADR_SJ', 'ADR_POS')
            AND (dat_povijesti_m IS NULL OR st.datum < dat_povijesti_m) -- povijest se prikazuje od dat_povijesti_m na dalje
            AND st.datum BETWEEN dat_poc_m AND dat_zav_m
            AND st.so_id = so.id
            AND st.vsj_id = vsj.id(+)
            AND st.ms_id = ms.id
            AND ms.zmpgms_id = zmpgms.id(+)
            AND ms.vms_id = vms.id
            AND
              (
                 (ozn_sprodaje_m = 'O' AND st.ozn_sprodaje = 'O')
              OR (ozn_sprodaje_m = 'F' AND st.ozn_sprodaje IN ('O', 'F'))
              OR (ozn_sprodaje_m = 'P' AND st.ozn_sprodaje IN ('O', 'F', 'B', 'Z'))
              OR (ozn_sprodaje_m = 'H' AND st.ozn_sprodaje IN ('O', 'F', 'A', 'Z'))
              OR (ozn_sprodaje_m = 'A' AND st.ozn_sprodaje IN ('O', 'F', 'B', 'A', 'Z'))
              )
            AND (oj_id_m IS NULL OR EXISTS (SELECT id1 FROM prec_global WHERE id1 = st.so_id AND opis2 = 'SO'))
            AND (so_id_m IS NULL OR st.so_id = so_id_m)
            AND (ms_id_m IS NULL OR st.ms_id = ms_id_m)
            AND (gms_id_m IS NULL OR ms.zmpgms_id = gms_id_m)
            AND (vsj_id_m IS NULL OR st.vsj_id = vsj_id_m)
            AND (vms_id_m IS NULL OR ms.vms_id = vms_id_m)
          GROUP BY
            DECODE (ozn_perioda_m, 'G', TRUNC (st.datum, 'YYYY'), 'M', TRUNC (st.datum, 'MM'), st.datum),
            DECODE (ozn_grupe_m, 'SO', so.sifra, 'VSJ', vsj.sifra, 'MS', ms.sifra, 'GMS', zmpgms.sifra, 'VMS', vms.sifra)
          UNION
          -- Povijest prognoze
          SELECT
            DECODE (ozn_perioda_m, 'G', TRUNC (st.datum, 'YYYY'), 'M', TRUNC (st.datum, 'MM'), st.datum) AS datum,
            DECODE (ozn_grupe_m, 'SO', so.sifra, 'VSJ', vsj.sifra, 'MS', ms.sifra, 'GMS', zmpgms.sifra, 'VMS', vms.sifra) AS sifra,
            SUM (st.kol_sj) AS kol_sj,
            SUM (st.br_osoba) AS br_osoba,
            SUM (st.kol_sj_dol) AS kol_sj_dol,
            SUM (st.br_osoba_dol) AS br_osoba_dol,
            DECODE (ozn_prihoda1_m, -1, SUM (st.izn_prihodann_1), 0)
              + DECODE (ozn_prihoda2_m, -1, SUM (st.izn_prihodann_2), 0)
              + DECODE (ozn_prihoda3_m, -1, SUM (st.izn_prihodann_3), 0)
              + DECODE (ozn_prihoda4_m, -1, SUM (st.izn_prihodann_4), 0)
              AS izn_prihoda
          FROM
            irec_prog_stavke_h st,
            m_so so,
            s_vsj vsj,
            m_msegmenti ms,
            mzmp_gms zmpgms,
            s_vmsegmenata vms
          WHERE
            ozn_podatka_m IN ('KOL_SJ', 'BR_OSOBA', 'KOL_SJ_DOL', 'BR_OSOBA_DOL', 'PRIHOD', 'ADR_SJ', 'ADR_POS')
            AND dat_povijesti_m IS NOT NULL
            AND st.datum >= dat_povijesti_m -- podaci za prethodno razdoblje itaju se iz prognoze
            AND st.na_dan = dat_povijesti_m
            AND st.datum BETWEEN dat_poc_m AND dat_zav_m
            AND st.so_id = so.id
            AND st.vsj_id = vsj.id(+)
            AND st.ms_id = ms.id
            AND ms.zmpgms_id = zmpgms.id(+)
            AND ms.vms_id = vms.id
            AND
              (
                 (ozn_sprodaje_m = 'O' AND st.ozn_sprodaje = 'O')
              OR (ozn_sprodaje_m = 'F' AND st.ozn_sprodaje IN ('O', 'F'))
              OR (ozn_sprodaje_m = 'P' AND st.ozn_sprodaje IN ('O', 'F', 'B', 'Z'))
              OR (ozn_sprodaje_m = 'H' AND st.ozn_sprodaje IN ('O', 'F', 'A', 'Z'))
              OR (ozn_sprodaje_m = 'A' AND st.ozn_sprodaje IN ('O', 'F', 'B', 'A', 'Z'))
              )
            AND (oj_id_m IS NULL OR EXISTS (SELECT id1 FROM prec_global WHERE id1 = st.so_id AND opis2 = 'SO'))
            AND (so_id_m IS NULL OR st.so_id = so_id_m)
            AND (ms_id_m IS NULL OR st.ms_id = ms_id_m)
            AND (gms_id_m IS NULL OR ms.zmpgms_id = gms_id_m)
            AND (vsj_id_m IS NULL OR st.vsj_id = vsj_id_m)
            AND (vms_id_m IS NULL OR ms.vms_id = vms_id_m)
          GROUP BY
            DECODE (ozn_perioda_m, 'G', TRUNC (st.datum, 'YYYY'), 'M', TRUNC (st.datum, 'MM'), st.datum),
            DECODE (ozn_grupe_m, 'SO', so.sifra, 'VSJ', vsj.sifra, 'MS', ms.sifra, 'GMS', zmpgms.sifra, 'VMS', vms.sifra)
          UNION
          -- Plan
          SELECT
            DECODE (ozn_perioda_m, 'G', TRUNC (st.datum, 'YYYY'), 'M', TRUNC (st.datum, 'MM'), st.datum) AS datum,
            DECODE (ozn_grupe_m, 'SO', so.sifra, 'MS', ms.sifra, 'GMS', zmpgms.sifra, 'VMS', vms.sifra) AS sifra,
            SUM (st.kol_sj) AS kol_sj,
            SUM (st.br_osoba) AS br_osoba,
            TO_NUMBER (NULL) AS kol_sj_dol,
            TO_NUMBER (NULL) AS br_osoba_dol,
            DECODE (ozn_prihoda1_m, -1, SUM (st.izn_prihodann_1), 0)
              + DECODE (ozn_prihoda2_m, -1, SUM (st.izn_prihodann_2), 0)
              + DECODE (ozn_prihoda3_m, -1, SUM (st.izn_prihodann_3), 0)
              + DECODE (ozn_prihoda4_m, -1, SUM (st.izn_prihodann_4), 0)
              AS izn_prihoda
          FROM
            trec_plgprodaje st,
            m_so so,
            m_msegmenti ms,
            mzmp_gms zmpgms,
            s_vmsegmenata vms
          WHERE
            ozn_podatka_m IN ('PLAN_KOL_SJ', 'PLAN_BR_OSOBA', 'PLAN_PRIHOD', 'PLAN_ADR_SJ', 'PLAN_ADR_POS')
            AND dat_povijesti_m IS NULL
            AND st.datum BETWEEN dat_poc_m AND dat_zav_m
            AND st.so_id = so.id
            AND st.ms_id = ms.id
            AND ms.zmpgms_id = zmpgms.id(+)
            AND ms.vms_id = vms.id
            AND (oj_id_m IS NULL OR EXISTS (SELECT id1 FROM prec_global WHERE id1 = st.so_id AND opis2 = 'SO'))
            AND (so_id_m IS NULL OR st.so_id = so_id_m)
            AND (ms_id_m IS NULL OR st.ms_id = ms_id_m)
            AND (gms_id_m IS NULL OR ms.zmpgms_id = gms_id_m)
            AND (vms_id_m IS NULL OR ms.vms_id = vms_id_m)
          GROUP BY
            DECODE (ozn_perioda_m, 'G', TRUNC (st.datum, 'YYYY'), 'M', TRUNC (st.datum, 'MM'), st.datum),
            DECODE (ozn_grupe_m, 'SO', so.sifra, 'MS', ms.sifra, 'GMS', zmpgms.sifra, 'VMS', vms.sifra)
          ) st2,
          (
          SELECT
            DISTINCT (DECODE (ozn_perioda_m, 'G', TRUNC (datum, 'YYYY'), 'M', TRUNC (datum, 'MM'), datum)) AS datum
          FROM
            v_zmp_kalendar
          WHERE
            datum BETWEEN dat_poc_m AND dat_zav_m
          ) kal
        WHERE
          st2.datum(+) = kal.datum
        GROUP BY
          kal.datum,
          st2.sifra
        ORDER BY
          kal.datum,
          st2.sifra
        ) prom,
        (
        SELECT
          id1 AS rbr,
          opis1 AS sifra
        FROM
          prec_global
        WHERE
          opis2 = 'MAT'
        ) mat
      WHERE
        prom.sifra = mat.sifra(+) -- prometni podaci za neko razdoblje ne moraju postojati
      GROUP BY
        prom.datum,
        mat.rbr
      )
    GROUP BY datum
    ORDER BY datum
    )
  LOOP

    prog_tab_m (i).datum     := prog_c.datum;
    prog_tab_m (i).podatak1  := prog_c.podatak1;
    prog_tab_m (i).podatak2  := prog_c.podatak2;
    prog_tab_m (i).podatak3  := prog_c.podatak3;
    prog_tab_m (i).podatak4  := prog_c.podatak4;
    prog_tab_m (i).podatak5  := prog_c.podatak5;
    prog_tab_m (i).podatak6  := prog_c.podatak6;
    prog_tab_m (i).podatak7  := prog_c.podatak7;
    prog_tab_m (i).podatak8  := prog_c.podatak8;
    prog_tab_m (i).podatak9  := prog_c.podatak9;
    prog_tab_m (i).podatak10 := prog_c.podatak10;
    prog_tab_m (i).podatak11 := prog_c.podatak11;
    prog_tab_m (i).podatak12 := prog_c.podatak12;
    prog_tab_m (i).podatak13 := prog_c.podatak13;
    prog_tab_m (i).podatak14 := prog_c.podatak14;
    prog_tab_m (i).podatak15 := prog_c.podatak15;
    prog_tab_m (i).podatak16 := prog_c.podatak16;
    prog_tab_m (i).podatak17 := prog_c.podatak17;
    prog_tab_m (i).podatak18 := prog_c.podatak18;
    prog_tab_m (i).podatak19 := prog_c.podatak19;
    prog_tab_m (i).podatak20 := prog_c.podatak20;
    prog_tab_m (i).podatak21 := prog_c.podatak21;
    prog_tab_m (i).podatak22 := prog_c.podatak22;
    prog_tab_m (i).podatak23 := prog_c.podatak23;
    prog_tab_m (i).podatak24 := prog_c.podatak24;
    prog_tab_m (i).podatak25 := prog_c.podatak25;
    prog_tab_m (i).podatak26 := prog_c.podatak26;
    prog_tab_m (i).podatak27 := prog_c.podatak27;
    prog_tab_m (i).podatak28 := prog_c.podatak28;
    prog_tab_m (i).podatak29 := prog_c.podatak29;
    prog_tab_m (i).podatak30 := prog_c.podatak30;
    prog_tab_m (i).ostalo    := prog_c.ostalo;
    prog_tab_m (i).ukupno    := prog_c.ukupno;

    i := i + 1;

  END LOOP;

  -- puni ADR (prosjenu cijenu) po SJ ili po postelji
  puni_adr;

END;
PROCEDURE PUNI_SIFRE
 IS

--
  i INTEGER := 0;
BEGIN

  -- brii retke prec_global
  DELETE FROM prec_global WHERE opis2 = 'MAT';

  -- puni retke prec_global
  FOR mat_c IN (
    SELECT
      rownum AS rbr,
      sifra
    FROM
      (
      -- Smjetajni objekti
      SELECT sifra FROM m_so WHERE ozn_grupe_m = 'SO'
        AND dat_valjan <= dat_zav_m
        AND (dat_ponisten IS NULL OR dat_ponisten > dat_poc_m)
        AND (pra_zmp_zaj.centar = -1 OR metcvor_sifra = pra_zmp_zaj.tekuci_cvor)
        AND (oj_id_m IS NULL OR EXISTS (SELECT 1 FROM prec_global g WHERE g.id1 = m_so.id AND g.opis2 = 'SO'))
      UNION
      -- Vrste smjetajnih jedinica
      SELECT sifra FROM s_vsj WHERE ozn_grupe_m = 'VSJ'
        AND id IN (
            SELECT DISTINCT vsj_id
              FROM m_sj
             WHERE dat_valjan <= dat_zav_m
               AND (dat_ponisten IS NULL OR dat_ponisten > dat_poc_m)
               AND (so_id_m IS NULL OR so_id = so_id_m)
               AND (oj_id_m IS NULL OR EXISTS (SELECT 1 FROM prec_global g WHERE g.id1 = m_sj.so_id AND g.opis2 = 'SO'))
               AND (
                   so_id_m IS NOT NULL
                   OR oj_id_m IS NOT NULL
                   OR so_id IN (
                      SELECT id
                        FROM m_so
                       WHERE dat_valjan <= dat_zav_m
                         AND (dat_ponisten IS NULL OR dat_ponisten > dat_poc_m)
                         AND (pra_zmp_zaj.centar = -1 OR metcvor_sifra = pra_zmp_zaj.tekuci_cvor)
                      )
                   )
            )
      UNION
      -- Marketinki segmenti
      SELECT sifra FROM m_msegmenti WHERE ozn_grupe_m = 'MS'
        AND dat_valjan <= dat_zav_m
        AND (dat_ponisten IS NULL OR dat_ponisten > dat_poc_m)
        AND (gms_id_m IS NULL OR zmpgms_id = gms_id_m)
        AND (vms_id_m IS NULL OR vms_id = vms_id_m)
      UNION
      -- Grupe marketinkih segmenata
      SELECT sifra FROM mzmp_gms WHERE ozn_grupe_m = 'GMS'
      UNION
      -- Vrste marketinkih segmenata
      SELECT sifra FROM s_vmsegmenata WHERE ozn_grupe_m = 'VMS'
      ORDER BY sifra
      )
    )
  LOOP
    -- prec_global ita se u puni_prog_tab i puni_adr, te modulu rec4625
    INSERT INTO prec_global (id1, opis1, opis2)
      VALUES (mat_c.rbr, mat_c.sifra, 'MAT');
  END LOOP;
END;
PROCEDURE PUNI_ADR
 IS

--
  i INTEGER := 0;
BEGIN

  -- brii retke prec_global
  DELETE FROM prec_global WHERE opis2 = 'ADR';

  IF ozn_podatka_m NOT IN ('ADR_SJ', 'ADR_POS', 'PLAN_ADR_SJ', 'PLAN_ADR_POS') THEN
    RETURN;
  END IF;

  -- puni prec_global s podatkom ADR (prosjena cijena) po odabranim grupama
  FOR prog_c IN (
    SELECT
      SUM (podatak1) AS podatak1,
      SUM (podatak2) AS podatak2,
      SUM (podatak3) AS podatak3,
      SUM (podatak4) AS podatak4,
      SUM (podatak5) AS podatak5,
      SUM (podatak6) AS podatak6,
      SUM (podatak7) AS podatak7,
      SUM (podatak8) AS podatak8,
      SUM (podatak9) AS podatak9,
      SUM (podatak10) AS podatak10,
      SUM (podatak11) AS podatak11,
      SUM (podatak12) AS podatak12,
      SUM (podatak13) AS podatak13,
      SUM (podatak14) AS podatak14,
      SUM (podatak15) AS podatak15,
      SUM (podatak16) AS podatak16,
      SUM (podatak17) AS podatak17,
      SUM (podatak18) AS podatak18,
      SUM (podatak19) AS podatak19,
      SUM (podatak20) AS podatak20,
      SUM (podatak21) AS podatak21,
      SUM (podatak22) AS podatak22,
      SUM (podatak23) AS podatak23,
      SUM (podatak24) AS podatak24,
      SUM (podatak25) AS podatak25,
      SUM (podatak26) AS podatak26,
      SUM (podatak27) AS podatak27,
      SUM (podatak28) AS podatak28,
      SUM (podatak29) AS podatak29,
      SUM (podatak30) AS podatak30,
      CASE
        WHEN (SUM (izn_prihoda) = 0 OR SUM (djelitelj) = 0)
        THEN
          0
        ELSE
          ROUND (SUM (izn_prihoda) / SUM (djelitelj), 2)
      END AS ostalo,
      CASE
        WHEN (SUM (izn_prihoda_uk) = 0 OR SUM (djelitelj_uk) = 0)
        THEN
          0
        ELSE
          ROUND (SUM (izn_prihoda_uk) / SUM (djelitelj_uk), 2)
      END AS ukupno
    FROM
      (
      SELECT
        DECODE (mat.rbr, rbr_poc_m,      SUM (prom.podatak), NULL) AS podatak1,
        DECODE (mat.rbr, rbr_poc_m + 1,  SUM (prom.podatak), NULL) AS podatak2,
        DECODE (mat.rbr, rbr_poc_m + 2,  SUM (prom.podatak), NULL) AS podatak3,
        DECODE (mat.rbr, rbr_poc_m + 3,  SUM (prom.podatak), NULL) AS podatak4,
        DECODE (mat.rbr, rbr_poc_m + 4,  SUM (prom.podatak), NULL) AS podatak5,
        DECODE (mat.rbr, rbr_poc_m + 5,  SUM (prom.podatak), NULL) AS podatak6,
        DECODE (mat.rbr, rbr_poc_m + 6,  SUM (prom.podatak), NULL) AS podatak7,
        DECODE (mat.rbr, rbr_poc_m + 7,  SUM (prom.podatak), NULL) AS podatak8,
        DECODE (mat.rbr, rbr_poc_m + 8,  SUM (prom.podatak), NULL) AS podatak9,
        DECODE (mat.rbr, rbr_poc_m + 9,  SUM (prom.podatak), NULL) AS podatak10,
        DECODE (mat.rbr, rbr_poc_m + 10, SUM (prom.podatak), NULL) AS podatak11,
        DECODE (mat.rbr, rbr_poc_m + 11, SUM (prom.podatak), NULL) AS podatak12,
        DECODE (mat.rbr, rbr_poc_m + 12, SUM (prom.podatak), NULL) AS podatak13,
        DECODE (mat.rbr, rbr_poc_m + 13, SUM (prom.podatak), NULL) AS podatak14,
        DECODE (mat.rbr, rbr_poc_m + 14, SUM (prom.podatak), NULL) AS podatak15,
        DECODE (mat.rbr, rbr_poc_m + 15, SUM (prom.podatak), NULL) AS podatak16,
        DECODE (mat.rbr, rbr_poc_m + 16, SUM (prom.podatak), NULL) AS podatak17,
        DECODE (mat.rbr, rbr_poc_m + 17, SUM (prom.podatak), NULL) AS podatak18,
        DECODE (mat.rbr, rbr_poc_m + 18, SUM (prom.podatak), NULL) AS podatak19,
        DECODE (mat.rbr, rbr_poc_m + 19, SUM (prom.podatak), NULL) AS podatak20,
        DECODE (mat.rbr, rbr_poc_m + 20, SUM (prom.podatak), NULL) AS podatak21,
        DECODE (mat.rbr, rbr_poc_m + 21, SUM (prom.podatak), NULL) AS podatak22,
        DECODE (mat.rbr, rbr_poc_m + 22, SUM (prom.podatak), NULL) AS podatak23,
        DECODE (mat.rbr, rbr_poc_m + 23, SUM (prom.podatak), NULL) AS podatak24,
        DECODE (mat.rbr, rbr_poc_m + 24, SUM (prom.podatak), NULL) AS podatak25,
        DECODE (mat.rbr, rbr_poc_m + 25, SUM (prom.podatak), NULL) AS podatak26,
        DECODE (mat.rbr, rbr_poc_m + 26, SUM (prom.podatak), NULL) AS podatak27,
        DECODE (mat.rbr, rbr_poc_m + 27, SUM (prom.podatak), NULL) AS podatak28,
        DECODE (mat.rbr, rbr_poc_m + 28, SUM (prom.podatak), NULL) AS podatak29,
        DECODE (mat.rbr, rbr_poc_m + 29, SUM (prom.podatak), NULL) AS podatak30,
        CASE
          WHEN mat.rbr < rbr_poc_m OR mat.rbr > rbr_poc_m + 29
          THEN
            SUM (prom.izn_prihoda)
          ELSE
            NULL
        END AS izn_prihoda,
        CASE
          WHEN mat.rbr < rbr_poc_m OR mat.rbr > rbr_poc_m + 29
          THEN
            SUM (prom.djelitelj)
          ELSE
            NULL
        END AS djelitelj,
        SUM (prom.izn_prihoda) AS izn_prihoda_uk,
        SUM (prom.djelitelj) AS djelitelj_uk
      FROM
        (
        SELECT
          st2.sifra,
          DECODE (REPLACE (ozn_podatka_m, 'PLAN_'),
            'ADR_SJ',
              CASE
                WHEN (SUM (st2.izn_prihoda) = 0 OR SUM (st2.kol_sj) = 0)
                THEN
                  0
                ELSE
                  ROUND (SUM (st2.izn_prihoda) / SUM (st2.kol_sj), 2)
              END,
            'ADR_POS',
              CASE
                WHEN (SUM (st2.izn_prihoda) = 0 OR SUM (st2.br_osoba) = 0)
                THEN
                  0
                ELSE
                  ROUND (SUM (st2.izn_prihoda) / SUM (st2.br_osoba), 2)
              END
          ) AS podatak,
          SUM (st2.izn_prihoda) izn_prihoda,
          DECODE (REPLACE (ozn_podatka_m, 'PLAN_'), 'ADR_SJ', SUM (st2.kol_sj), 'ADR_POS', SUM (st2.br_osoba))
            AS djelitelj
        FROM
          (
          -- Prognoza
          SELECT
            DECODE (ozn_grupe_m, 'SO', so.sifra, 'VSJ', vsj.sifra, 'MS', ms.sifra, 'GMS', zmpgms.sifra, 'VMS', vms.sifra) AS sifra,
            SUM (st.kol_sj) AS kol_sj,
            SUM (st.br_osoba) AS br_osoba,
            DECODE (ozn_prihoda1_m, -1, SUM (st.izn_prihodann_1), 0)
              + DECODE (ozn_prihoda2_m, -1, SUM (st.izn_prihodann_2), 0)
              + DECODE (ozn_prihoda3_m, -1, SUM (st.izn_prihodann_3), 0)
              + DECODE (ozn_prihoda4_m, -1, SUM (st.izn_prihodann_4), 0)
              AS izn_prihoda
          FROM
            irec_prog_stavke st,
            m_so so,
            s_vsj vsj,
            m_msegmenti ms,
            mzmp_gms zmpgms,
            s_vmsegmenata vms
          WHERE
            ozn_podatka_m IN ('ADR_SJ', 'ADR_POS')
            AND (dat_povijesti_m IS NULL OR st.datum < dat_povijesti_m) -- povijest se prikazuje od dat_povijesti_m na dalje
            AND st.datum BETWEEN dat_poc_m AND dat_zav_m
            AND st.so_id = so.id
            AND st.vsj_id = vsj.id(+)
            AND st.ms_id = ms.id
            AND ms.zmpgms_id = zmpgms.id(+)
            AND ms.vms_id = vms.id
            AND
              (
                 (ozn_sprodaje_m = 'O' AND st.ozn_sprodaje = 'O')
              OR (ozn_sprodaje_m = 'F' AND st.ozn_sprodaje IN ('O', 'F'))
              OR (ozn_sprodaje_m = 'P' AND st.ozn_sprodaje IN ('O', 'F', 'B', 'Z'))
              OR (ozn_sprodaje_m = 'H' AND st.ozn_sprodaje IN ('O', 'F', 'A', 'Z'))
              OR (ozn_sprodaje_m = 'A' AND st.ozn_sprodaje IN ('O', 'F', 'B', 'A', 'Z'))
              )
            AND (oj_id_m IS NULL OR EXISTS (SELECT id1 FROM prec_global WHERE id1 = st.so_id AND opis2 = 'SO'))
            AND (so_id_m IS NULL OR st.so_id = so_id_m)
            AND (ms_id_m IS NULL OR st.ms_id = ms_id_m)
            AND (gms_id_m IS NULL OR ms.zmpgms_id = gms_id_m)
            AND (vsj_id_m IS NULL OR st.vsj_id = vsj_id_m)
            AND (vms_id_m IS NULL OR ms.vms_id = vms_id_m)
          GROUP BY
            DECODE (ozn_grupe_m, 'SO', so.sifra, 'VSJ', vsj.sifra, 'MS', ms.sifra, 'GMS', zmpgms.sifra, 'VMS', vms.sifra)
          UNION
          -- Povijest prognoze
          SELECT
            DECODE (ozn_grupe_m, 'SO', so.sifra, 'VSJ', vsj.sifra, 'MS', ms.sifra, 'GMS', zmpgms.sifra, 'VMS', vms.sifra) AS sifra,
            SUM (st.kol_sj) AS kol_sj,
            SUM (st.br_osoba) AS br_osoba,
            DECODE (ozn_prihoda1_m, -1, SUM (st.izn_prihodann_1), 0)
              + DECODE (ozn_prihoda2_m, -1, SUM (st.izn_prihodann_2), 0)
              + DECODE (ozn_prihoda3_m, -1, SUM (st.izn_prihodann_3), 0)
              + DECODE (ozn_prihoda4_m, -1, SUM (st.izn_prihodann_4), 0)
              AS izn_prihoda
          FROM
            irec_prog_stavke_h st,
            m_so so,
            s_vsj vsj,
            m_msegmenti ms,
            mzmp_gms zmpgms,
            s_vmsegmenata vms
          WHERE
            ozn_podatka_m IN ('ADR_SJ', 'ADR_POS')
            AND dat_povijesti_m IS NOT NULL
            AND st.datum >= dat_povijesti_m -- podaci za prethodno razdoblje itaju se iz prognoze
            AND st.na_dan = dat_povijesti_m
            AND st.datum BETWEEN dat_poc_m AND dat_zav_m
            AND st.so_id = so.id
            AND st.vsj_id = vsj.id(+)
            AND st.ms_id = ms.id
            AND ms.zmpgms_id = zmpgms.id(+)
            AND ms.vms_id = vms.id
            AND
              (
                 (ozn_sprodaje_m = 'O' AND st.ozn_sprodaje = 'O')
              OR (ozn_sprodaje_m = 'F' AND st.ozn_sprodaje IN ('O', 'F'))
              OR (ozn_sprodaje_m = 'P' AND st.ozn_sprodaje IN ('O', 'F', 'B', 'Z'))
              OR (ozn_sprodaje_m = 'H' AND st.ozn_sprodaje IN ('O', 'F', 'A', 'Z'))
              OR (ozn_sprodaje_m = 'A' AND st.ozn_sprodaje IN ('O', 'F', 'B', 'A', 'Z'))
              )
            AND (oj_id_m IS NULL OR EXISTS (SELECT id1 FROM prec_global WHERE id1 = st.so_id AND opis2 = 'SO'))
            AND (so_id_m IS NULL OR st.so_id = so_id_m)
            AND (ms_id_m IS NULL OR st.ms_id = ms_id_m)
            AND (gms_id_m IS NULL OR ms.zmpgms_id = gms_id_m)
            AND (vsj_id_m IS NULL OR st.vsj_id = vsj_id_m)
            AND (vms_id_m IS NULL OR ms.vms_id = vms_id_m)
          GROUP BY
            DECODE (ozn_grupe_m, 'SO', so.sifra, 'VSJ', vsj.sifra, 'MS', ms.sifra, 'GMS', zmpgms.sifra, 'VMS', vms.sifra)
          UNION
          -- Plan
          SELECT
            DECODE (ozn_grupe_m, 'SO', so.sifra, 'MS', ms.sifra, 'GMS', zmpgms.sifra, 'VMS', vms.sifra) AS sifra,
            SUM (st.kol_sj) AS kol_sj,
            SUM (st.br_osoba) AS br_osoba,
            DECODE (ozn_prihoda1_m, -1, SUM (st.izn_prihodann_1), 0)
              + DECODE (ozn_prihoda2_m, -1, SUM (st.izn_prihodann_2), 0)
              + DECODE (ozn_prihoda3_m, -1, SUM (st.izn_prihodann_3), 0)
              + DECODE (ozn_prihoda4_m, -1, SUM (st.izn_prihodann_4), 0)
              AS izn_prihoda
          FROM
            trec_plgprodaje st,
            m_so so,
            m_msegmenti ms,
            mzmp_gms zmpgms,
            s_vmsegmenata vms
          WHERE
            ozn_podatka_m IN ('PLAN_ADR_SJ', 'PLAN_ADR_POS')
            AND dat_povijesti_m IS NULL
            AND st.datum BETWEEN dat_poc_m AND dat_zav_m
            AND st.so_id = so.id
            AND st.ms_id = ms.id
            AND ms.zmpgms_id = zmpgms.id(+)
            AND ms.vms_id = vms.id
            AND (oj_id_m IS NULL OR EXISTS (SELECT id1 FROM prec_global WHERE id1 = st.so_id AND opis2 = 'SO'))
            AND (so_id_m IS NULL OR st.so_id = so_id_m)
            AND (ms_id_m IS NULL OR st.ms_id = ms_id_m)
            AND (gms_id_m IS NULL OR ms.zmpgms_id = gms_id_m)
            AND (vms_id_m IS NULL OR ms.vms_id = vms_id_m)
          GROUP BY
            DECODE (ozn_grupe_m, 'SO', so.sifra, 'MS', ms.sifra, 'GMS', zmpgms.sifra, 'VMS', vms.sifra)
          ) st2
        GROUP BY
          st2.sifra
        ORDER BY
          st2.sifra
        ) prom,
        (
        SELECT
          id1 AS rbr,
          opis1 AS sifra
        FROM
          prec_global
        WHERE
          opis2 = 'MAT'
        ) mat
      WHERE
        prom.sifra = mat.sifra
      GROUP BY
        mat.rbr
      )
    )
  LOOP
    INSERT INTO prec_global (id1, iznos1, opis2) VALUES (1, prog_c.podatak1, 'ADR');
    INSERT INTO prec_global (id1, iznos1, opis2) VALUES (2, prog_c.podatak2, 'ADR');
    INSERT INTO prec_global (id1, iznos1, opis2) VALUES (3, prog_c.podatak3, 'ADR');
    INSERT INTO prec_global (id1, iznos1, opis2) VALUES (4, prog_c.podatak4, 'ADR');
    INSERT INTO prec_global (id1, iznos1, opis2) VALUES (5, prog_c.podatak5, 'ADR');
    INSERT INTO prec_global (id1, iznos1, opis2) VALUES (6, prog_c.podatak6, 'ADR');
    INSERT INTO prec_global (id1, iznos1, opis2) VALUES (7, prog_c.podatak7, 'ADR');
    INSERT INTO prec_global (id1, iznos1, opis2) VALUES (8, prog_c.podatak8, 'ADR');
    INSERT INTO prec_global (id1, iznos1, opis2) VALUES (9, prog_c.podatak9, 'ADR');
    INSERT INTO prec_global (id1, iznos1, opis2) VALUES (10, prog_c.podatak10, 'ADR');
    INSERT INTO prec_global (id1, iznos1, opis2) VALUES (11, prog_c.podatak11, 'ADR');
    INSERT INTO prec_global (id1, iznos1, opis2) VALUES (12, prog_c.podatak12, 'ADR');
    INSERT INTO prec_global (id1, iznos1, opis2) VALUES (13, prog_c.podatak13, 'ADR');
    INSERT INTO prec_global (id1, iznos1, opis2) VALUES (14, prog_c.podatak14, 'ADR');
    INSERT INTO prec_global (id1, iznos1, opis2) VALUES (15, prog_c.podatak15, 'ADR');
    INSERT INTO prec_global (id1, iznos1, opis2) VALUES (16, prog_c.podatak16, 'ADR');
    INSERT INTO prec_global (id1, iznos1, opis2) VALUES (17, prog_c.podatak17, 'ADR');
    INSERT INTO prec_global (id1, iznos1, opis2) VALUES (18, prog_c.podatak18, 'ADR');
    INSERT INTO prec_global (id1, iznos1, opis2) VALUES (19, prog_c.podatak19, 'ADR');
    INSERT INTO prec_global (id1, iznos1, opis2) VALUES (20, prog_c.podatak20, 'ADR');
    INSERT INTO prec_global (id1, iznos1, opis2) VALUES (21, prog_c.podatak21, 'ADR');
    INSERT INTO prec_global (id1, iznos1, opis2) VALUES (22, prog_c.podatak22, 'ADR');
    INSERT INTO prec_global (id1, iznos1, opis2) VALUES (23, prog_c.podatak23, 'ADR');
    INSERT INTO prec_global (id1, iznos1, opis2) VALUES (24, prog_c.podatak24, 'ADR');
    INSERT INTO prec_global (id1, iznos1, opis2) VALUES (25, prog_c.podatak25, 'ADR');
    INSERT INTO prec_global (id1, iznos1, opis2) VALUES (26, prog_c.podatak26, 'ADR');
    INSERT INTO prec_global (id1, iznos1, opis2) VALUES (27, prog_c.podatak27, 'ADR');
    INSERT INTO prec_global (id1, iznos1, opis2) VALUES (28, prog_c.podatak28, 'ADR');
    INSERT INTO prec_global (id1, iznos1, opis2) VALUES (29, prog_c.podatak29, 'ADR');
    INSERT INTO prec_global (id1, iznos1, opis2) VALUES (30, prog_c.podatak30, 'ADR');
    INSERT INTO prec_global (id1, iznos1, opis2) VALUES (31, prog_c.ostalo, 'ADR');
    INSERT INTO prec_global (id1, iznos1, opis2) VALUES (32, prog_c.ukupno, 'ADR');

  END LOOP;

END;

END FM_REC4625;
/
SHOW ERROR

