-- C:\Users\dgajic\Desktop\IRN 4085 - rezvanjsus\fm_rec2120.pkb
--
-- Generated for Oracle 10g on Mon Oct 06  10:01:22 2025 by Server Generator 6.5.96.5.6
 

PROMPT Creating Package Body 'FM_REC2120'
CREATE OR REPLACE PACKAGE BODY FM_REC2120 IS

FUNCTION POSTOJI_REZERVACIJA
 (SO_ID_P IN t_rezervacije.so_id%TYPE
 ,AGE_ID_P IN t_rezervacije.age_id%TYPE
 ,IME_P IN T_REZERVACIJE.IME%TYPE
 ,PREZIME_P IN T_REZERVACIJE.PREZIME%TYPE
 ,DAT_DOLASKA_P IN T_REZERVACIJE.DAT_DOLASKA%TYPE
 ,DAT_ODLASKA_P IN T_REZERVACIJE.DAT_ODLASKA%TYPE
 ,ID_P IN T_REZERVACIJE.ID%TYPE
 )
 RETURN NUMBER
 IS
/*
Upozori da postoji rezervacija na isto ime, prezime i boravak
15.02.2002. G.J.
*/
  br_redaka_l NUMBER;
  RECparam_1115 VARCHAR2(2) := pra_rec_zaj.vrijednost_parametra ('1115');
BEGIN
  IF prezime_p IS NULL
    OR dat_dolaska_p IS NULL
    OR dat_odlaska_p IS NULL
  THEN
    RETURN (0);
  END IF;

  /*
  18.09.2008. G.J. IRN 669
  Rezervacije; Kod provjere rezervacije na isto ime i boravak, treba uzimati u obzir: 
    0 = nita, 
    1 = samo agenciju, 
    2 = samo SO, 
    3 = i agenciju i SO.
  */
  IF RECparam_1115 = '3' THEN
    SELECT COUNT (ROWID) INTO br_redaka_l
      FROM t_rezervacije
     WHERE oznaka = 'V'
       AND ozn_vstorna IS NULL
       AND so_id = so_id_p
       AND NVL (age_id, 0) = NVL (age_id_p, 0)
       AND NVL (UPPER (ime), 'III-III') = NVL (ime_p, 'III-III')
       AND UPPER (prezime) = prezime_p
       AND dat_dolaska = dat_dolaska_p
       AND dat_odlaska = dat_odlaska_p
       AND id <> NVL (id_p, 0);
  
  ELSIF RECparam_1115 = '2' THEN
    SELECT COUNT (ROWID) INTO br_redaka_l
      FROM t_rezervacije
     WHERE oznaka = 'V'
       AND ozn_vstorna IS NULL
       AND so_id = so_id_p
       AND NVL (UPPER (ime), 'III-III') = NVL (ime_p, 'III-III')
       AND UPPER (prezime) = prezime_p
       AND dat_dolaska = dat_dolaska_p
       AND dat_odlaska = dat_odlaska_p
       AND id <> NVL (id_p, 0);
  
  ELSIF RECparam_1115 = '1' THEN
    SELECT COUNT (ROWID) INTO br_redaka_l
      FROM t_rezervacije
     WHERE oznaka = 'V'
       AND ozn_vstorna IS NULL
       AND NVL (age_id, 0) = NVL (age_id_p, 0)
       AND NVL (UPPER (ime), 'III-III') = NVL (ime_p, 'III-III')
       AND UPPER (prezime) = prezime_p
       AND dat_dolaska = dat_dolaska_p
       AND dat_odlaska = dat_odlaska_p
       AND id <> NVL (id_p, 0);
  ELSE
    SELECT COUNT (ROWID) INTO br_redaka_l
      FROM t_rezervacije
     WHERE oznaka = 'V'
       AND ozn_vstorna IS NULL
       AND NVL (UPPER (ime), 'III-III') = NVL (ime_p, 'III-III')
       AND UPPER (prezime) = prezime_p
       AND dat_dolaska = dat_dolaska_p
       AND dat_odlaska = dat_odlaska_p
       AND id <> NVL (id_p, 0);
  END IF;

  IF br_redaka_l > 0 THEN
    RETURN (-1);
  ELSE
    RETURN (0);
  END IF;

END;
FUNCTION REZVSJ_PRIPADAJU_SO
 (REZ_ID_P IN T_REZ_VSJ.REZ_ID%TYPE
 ,SO_ID_P IN M_SJ.SO_ID%TYPE
 ,DAT_POC_P IN M_SJ.DAT_VALJAN%TYPE
 ,DAT_ZAV_P IN M_SJ.DAT_VALJAN%TYPE
 )
 RETURN NUMBER
 IS

OZN_VSJ_PRIPADA_SO_L NUMBER := -1;
/*
Provjeri pripadaju li sve rezervirane vrste SJ novom SO
*/
BEGIN
  FOR rezvsj IN (
    SELECT vsj_id
      FROM t_rez_vsj
     WHERE rez_id = rez_id_p)
  LOOP
    IF pra_rec_s.vsj_pripada_so 
      (rezvsj.vsj_id, so_id_p, dat_poc_p, dat_zav_p) = 0 
    THEN
      ozn_vsj_pripada_so_l := 0;
      EXIT;
    END IF;
  END LOOP;
  RETURN (ozn_vsj_pripada_so_l);
END;
PROCEDURE PROVJERI_STATUS_SJ
 (DAT_DOLASKA_P IN T_REZERVACIJE.DAT_DOLASKA%TYPE
 ,DAT_ODLASKA_P IN T_REZERVACIJE.DAT_ODLASKA%TYPE
 ,REZVSJ_ID_P IN T_REZ_VSJ.ID%TYPE
 ,RECREZSJ_ID_P IN TREC_REZ_SJ.ID%TYPE
 ,SJ_ID_P IN T_REZ_VSJ.SJ_ID%TYPE
 )
 IS
--
  CURSOR sjiu_c (datum_k i_statusisj.datum%TYPE) IS
    SELECT TO_CHAR (dat_zav, 'DD.MM.RRRR')
      FROM trec_odrzavanje -- IRN 1313
     WHERE oznaka = 'V' -- IRN 1793
       AND sj_id = sj_id_p
       AND datum_k BETWEEN dat_poc AND dat_zav - 1
       AND ozn_i = 3;
 
  -- IRN 4085
  CURSOR sj_c IS
    SELECT broj, TO_CHAR (dat_ponisten, 'DD.MM.RRRR')
      FROM m_sj
     WHERE id = sj_id_p
       AND dat_ponisten IS NOT NULL
       AND dat_ponisten <= dat_dolaska_p;

  CURSOR zaksj_c (datum_k i_statusisj.datum%TYPE) IS
    SELECT zak.god_poslovna || '-' || vzak.sifra || '-' || zak.rbr, TO_CHAR (zak.dat_zav, 'DD.MM.RRRR')
      FROM t_zak_sj zaksj,
           t_zakup zak,
           s_vzakupa vzak
     WHERE zaksj.sj_id = sj_id_p
       AND zaksj.zak_id = zak.id
       AND zak.vzak_id = vzak.id
       AND zak.oznaka = 'V'
       AND datum_k BETWEEN zak.dat_poc AND zak.dat_zav - 1;

  -- 12.11.2007. G.J.
  CURSOR gostbor_c (datum_k i_statusisj.datum%TYPE, gost_id_k i_statusisj.gost_id%TYPE) IS
    SELECT TO_CHAR (recgostbor.dat_zav, 'DD.MM.RRRR')
      FROM trec_gost_boravci recgostbor,
           t_gosti gost
     WHERE recgostbor.gost_id = gost_id_k
       AND recgostbor.gost_id = gost.id
       AND (gost.rezvsj_id IS NULL OR gost.rezvsj_id <> NVL (rezvsj_id_p, 0))
       AND datum_k BETWEEN recgostbor.dat_poc AND recgostbor.dat_zav - 1
       AND recgostbor.sj_id = sj_id_p
    UNION -- IRN 1237
    SELECT TO_CHAR (recgostbor.dat_zav, 'DD.MM.RRRR')
      FROM trec_gost_boravci recgostbor,
           t_gosti gost
     WHERE recgostbor.gost_id = gost_id_k
       AND recgostbor.gost_id = gost.id
       AND (gost.recrezsj_id IS NULL OR gost.recrezsj_id <> NVL (recrezsj_id_p, 0))
       AND datum_k BETWEEN recgostbor.dat_poc AND recgostbor.dat_zav - 1
       AND recgostbor.sj_id = sj_id_p;

  CURSOR rezsj_c (datum_k i_statusisj.datum%TYPE) IS
    SELECT rez.god_poslovna || '-' || rez.rbr, TO_CHAR (rez.dat_odlaska, 'DD.MM.RRRR')
      FROM t_rez_vsj rezvsj,
           t_rezervacije rez
     WHERE rezvsj.sj_id = sj_id_p
       AND rezvsj.rez_id = rez.id
       AND rez.oznaka = 'V'
       AND rez.ozn_vstorna IS NULL
       AND datum_k BETWEEN rez.dat_dolaska AND rez.dat_odlaska - 1
       AND (rezvsj.br_osoba - NVL (rezvsj.br_osobaz, 0) > 0 OR rezvsj.br_osoba = 0 AND NVL (rezvsj.br_osobaz, 0) = 0)
       AND rezvsj.id <> NVL (rezvsj_id_p, 0)
    UNION ALL
    SELECT rez.god_poslovna || '-' || rez.rbr, TO_CHAR (rez.dat_odlaska, 'DD.MM.RRRR')
      FROM trec_rez_sj recrezsj,
           t_rez_vsj rezvsj,
           t_rezervacije rez
     WHERE recrezsj.sj_id = sj_id_p
       AND recrezsj.rezvsj_id = rezvsj.id
       AND rezvsj.rez_id = rez.id
       AND pra_zmp_s.vsj_je_sastavljena(rezvsj.vsj_id) = 0
       AND rez.oznaka = 'V'
       AND rez.ozn_vstorna IS NULL
       AND datum_k BETWEEN rez.dat_dolaska AND rez.dat_odlaska - 1
       AND (recrezsj.br_osoba - NVL (recrezsj.br_osobaz, 0) > 0 OR recrezsj.br_osoba = 0 AND NVL (recrezsj.br_osobaz, 0) = 0)
       AND recrezsj.id <> NVL (recrezsj_id_p, 0);

  datum10_l VARCHAR2(10);
  rbr_l VARCHAR2(100);
  sj_broj_l m_sj.broj%TYPE; -- IRN 4085
BEGIN
    
  OPEN sj_c;
  FETCH sj_c INTO sj_broj_l, datum10_l;
  IF sj_c%FOUND THEN
    CLOSE sj_c;
    -- Smjetajna jedinica #0 ponitena je od #1.
    pra_rec_zaj.vrati_poruku (-20453, sj_broj_l, datum10_l);
  END IF;
  CLOSE sj_c; 

  FOR stsj_c IN (
    SELECT sj.broj AS sj_broj, stsj.ozn_i, stsj.ozn_u, stsj.ozn_r, stsj.ozn_z, stsj.datum, stsj.gost_id
      FROM i_statusisj stsj,
           m_sj sj
     WHERE stsj.sj_id = sj.id
       AND stsj.sj_id = sj_id_p
       AND stsj.datum >= dat_dolaska_p
       AND stsj.datum < dat_odlaska_p)
  LOOP
    IF stsj_c.ozn_i = 3 THEN
      OPEN sjiu_c (stsj_c.datum);
      FETCH sjiu_c INTO datum10_l;
      IF sjiu_c%FOUND THEN
        CLOSE sjiu_c;
        -- Smjetajna jedinica #0 izvan upotrebe je do #1.
        pra_rec_zaj.vrati_poruku (-20452, stsj_c.sj_broj, datum10_l);
      END IF;
      CLOSE sjiu_c;
    ELSIF stsj_c.ozn_u = -1 THEN
      OPEN zaksj_c (stsj_c.datum);
      FETCH zaksj_c INTO rbr_l, datum10_l;
      IF zaksj_c%FOUND THEN
        CLOSE zaksj_c;
        -- Smjetajna jedinica #0 vezana je ugovorom o zakupu #1 do #2.
        pra_rec_zaj.vrati_poruku (-20454, stsj_c.sj_broj, rbr_l, datum10_l);
      END IF;
      CLOSE zaksj_c;
    ELSIF stsj_c.ozn_z > 0 THEN
      OPEN gostbor_c (stsj_c.datum, stsj_c.gost_id);
      FETCH gostbor_c INTO datum10_l;
      IF gostbor_c%FOUND THEN
        CLOSE gostbor_c;
        -- Smjetajna jedinica #0 zauzeta je do #1.
        pra_rec_zaj.vrati_poruku (-20455, stsj_c.sj_broj, datum10_l);
      END IF;
      CLOSE gostbor_c;
    ELSIF stsj_c.ozn_r > 0 THEN
      OPEN rezsj_c (stsj_c.datum);
      FETCH rezsj_c INTO rbr_l, datum10_l;
      IF rezsj_c%FOUND THEN
        CLOSE rezsj_c;
        -- Smjetajna jedinica #0 rezervirana (#1) je do #2.
        pra_rec_zaj.vrati_poruku (-20456, stsj_c.sj_broj, rbr_l, datum10_l);
      END IF;
      CLOSE rezsj_c;
    END IF;
  END LOOP;
END;
PROCEDURE FIKSIRAJ_CIJENE
 (REZ_ID_P IN T_REZERVACIJE.ID%TYPE
 )
 IS
--
  rez_so_id_l t_rezervacije.so_id%TYPE;
  rez_recvpro_id_l mrec_vprograma.id%TYPE;
  rez_ponso_id_l t_pon_so.id%TYPE;
  rez_cje_id_l t_cjenici.id%TYPE;
  ponso_cje_id_l t_cjenici.id%TYPE;
  rez_dolaz_l t_rezervacije.dat_dolaska%TYPE;
  rez_odlaz_l t_rezervacije.dat_odlaska%TYPE;
  rez_ozn_cje_poseb_l t_rezervacije.ozn_cje_poseb%TYPE;

  ban_id_l m_banke.id%TYPE;
  vtec_id_l s_vtecajeva.id%TYPE;
  ozn_postoji_cijena_l NUMBER;
  recrezcjeusl_rec_l trec_rez_cjeusl%ROWTYPE;

  cje_id_l t_cjenici.id%TYPE;
  cje_usl_obr_l t_cje_usl.cje_usl_obr%TYPE;

  param_l szmp_parametri.vrijednost%TYPE := UPPER (pra_zmp_zaj.zmppar_vrijednost ('REC', '1140'));
BEGIN
  IF rez_id_p IS NULL THEN
    RETURN;
  END IF;

  BEGIN
    SELECT rez.so_id,
           rez.ponso_id,
           rez.recvpro_id,
           rez.cje_id,
           pra_rec_s4.cje_id_ponudeni (rez.ponso_id, rez.recvpro_id),
           rez.dat_dolaska,
           rez.dat_odlaska,
           rez.ozn_cje_poseb
      INTO rez_so_id_l,
           rez_ponso_id_l,
           rez_recvpro_id_l,
           rez_cje_id_l,
           ponso_cje_id_l,
           rez_dolaz_l,
           rez_odlaz_l,
           rez_ozn_cje_poseb_l
      FROM t_rezervacije rez
     WHERE fm_rec2120.ms_u_param (rez.ms_id, param_l) = -1
       AND rez.id = rez_id_p;
  EXCEPTION
    WHEN NO_DATA_FOUND THEN
      RETURN;  -- MS rezervacije nije naveden u REC parametru......
  END;

  vtec_id_l := pra_rec_s2.vtec_id_vapldok (oznaka_p => 'PR', age_id_p => NULL);
  ban_id_l := pra_rec_s2.ban_id_vapldok (oznaka_p => 'PR', age_id_p => NULL);

  DELETE FROM prec_troskovi;

  FOR usl_c IN (
    SELECT vsj_id,
           usl_id,
           usl_id1,
           ozn_1dan,
           recara_id,
           ozn_ugo,
           ozn_cje_vsj
      FROM (SELECT DECODE (usl.ozn_cje_vsj, -1, rezvsj.vsjc_id, NULL) vsj_id,
                   rezusl.usl_id usl_id,
                   rezusl.usl_id1 usl_id1,
                   NVL (rezusl.dat_poc, rez_dolaz_l) dat_poc,
                   NVL (rezusl.dat_zav, rez_odlaz_l) dat_zav,
                   usl.ozn_1dan ozn_1dan,
                   recara.id recara_id,
                   ozn_ugo,
                   usl.ozn_cje_vsj ozn_cje_vsj
              FROM t_rez_usl rezusl,
                   t_rez_vsj rezvsj,
                   s_usluge usl,
                   mrec_ara_usl recarausl,
                   mrec_aranzmani recara
             WHERE rezusl.rez_id = rez_id_p
               AND rezvsj.rez_id = rez_id_p
               AND usl.id = rezusl.usl_id
               AND (usl.ozn_cje_poseb = 0
                    OR rez_ozn_cje_poseb_l = 0
                    OR UPPER (pra_rec_zaj.vrijednost_parametra ('1068')) = 'NEBITNO')
               AND recarausl.usl_id (+) = rezusl.usl_id
               AND recarausl.recara_id (+) = rezusl.recara_id
               AND DECODE (recarausl.ozn_cje_ara, -1, recarausl.recara_id, -1) = recara.id (+)
            UNION
            SELECT DECODE (usl.ozn_cje_vsj, -1, rezvsj.vsjc_id, NULL),
                   rezgusl.usl_id,
                   rezgusl.usl_id1,
                   NVL (rezgusl.dat_poc, rez_dolaz_l),
                   NVL (rezgusl.dat_zav, rez_odlaz_l),
                   usl.ozn_1dan,
                   recara.id,
                   ozn_ugo,
                   usl.ozn_cje_vsj ozn_cje_vsj
              FROM t_rez_vsj rezvsj,
                   t_rez_gost rezgost,
                   t_rez_gusl rezgusl,
                   s_usluge usl,
                   mrec_ara_usl recarausl,
                   mrec_aranzmani recara
             WHERE rezvsj.rez_id = rez_id_p
               AND rezgost.rezvsj_id = rezvsj.id
               AND rezgusl.rezgost_id = rezgost.id
               AND usl.id = rezgusl.usl_id
               AND (usl.ozn_cje_poseb = 0
                    OR rez_ozn_cje_poseb_l = 0
                    OR UPPER (pra_rec_zaj.vrijednost_parametra ('1068')) = 'NEBITNO')
               AND recarausl.usl_id (+) = rezgusl.usl_id
               AND recarausl.recara_id (+) = rezgusl.recara_id
               AND DECODE (recarausl.ozn_cje_ara, -1, recarausl.recara_id, -1) = recara.id (+)
            )
    )
  LOOP

    IF usl_c.ozn_ugo = 0 THEN
      cje_id_l := rez_cje_id_l;
    ELSIF rez_ponso_id_l IS NOT NULL THEN
      cje_id_l := ponso_cje_id_l;
    END IF;

    BEGIN
      SELECT cje_usl_obr
        INTO cje_usl_obr_l
        FROM t_cje_usl
       WHERE cje_id = cje_id_l
         AND so_id = rez_so_id_l
         AND NVL (vsj_id, 0) = DECODE (usl_c.ozn_cje_vsj, -1, usl_c.vsj_id, 0, 0)
         AND usl_id = usl_c.usl_id
         AND NVL (recara_id, -1) = NVL (usl_c.recara_id, -1)
         AND datum = (
             SELECT MAX (datum)
               FROM t_cje_usl
              WHERE cje_id = cje_id_l
                AND so_id = rez_so_id_l
                AND NVL (vsj_id, 0) = DECODE (usl_c.ozn_cje_vsj, -1, usl_c.vsj_id, 0, 0)
                AND usl_id = usl_c.usl_id
                AND NVL (recara_id, -1) = NVL (usl_c.recara_id, -1)
                AND datum <= rez_dolaz_l);
    EXCEPTION
      WHEN NO_DATA_FOUND THEN
        NULL;
    END;

    IF (usl_c.usl_id1 IS NOT NULL AND cje_usl_obr_l IS NULL) OR usl_c.usl_id1 IS NULL THEN
      pra_rec_iud.citaj_ozn_cijene_g := 0; -- IRN 3988
      
      pra_rec_iud2.puni_zajtro (
        zag_id_p => rez_ponso_id_l,
        rez_id_p => rez_id_p, -- 727
        recvpro_id_p => rez_recvpro_id_l,
        ponso_id_p => rez_ponso_id_l,
        so_id_p => rez_so_id_l,
        vsj_id_p => usl_c.vsj_id,
        usl_id_p => usl_c.usl_id,
        vtec_id_p => vtec_id_l,
        cje_id_p => rez_cje_id_l,
        ozn_cje_poseb_p => rez_ozn_cje_poseb_l,
        dat_poc_p => rez_dolaz_l,
        dat_zav_p => rez_odlaz_l,
        kolicina_p => 1,
        stopa_placanja_p => 100,
        br_uputnice_p => NULL,
        ozn_smjesta_p => 0,
        recara_id_p => usl_c.recara_id,
        vpispz_id_p => NULL,
        stopa_pdv_p  => NULL, -- 727
        ban_id_p => ban_id_l, -- 727
        ozn_ugo_p => usl_c.ozn_ugo, -- 727
        cje_id1_p => ponso_cje_id_l, -- 727
        usl_id1_p => usl_c.usl_id1, -- 727
        vpispz_id1_p => NULL, -- 727
        stopa_pdv1_p => NULL, -- 727
        ozn_tab_p => 'RECTRO',
        ozn_postoji_cijena_p => ozn_postoji_cijena_l);
    END IF;

  END LOOP;

  DELETE FROM trec_rez_cjeusl WHERE rez_id = rez_id_p;  -- IRN 3988

  FOR recrezcjeusl_c IN (
    -- IRN 3988
    SELECT usl_id, vsj_id, dat_poc, GREATEST (dat_poc, dat_zav) dat_zav, recara_id, MAX (cijena) cijena_usluge, obr_zdana
      FROM prec_troskovi
     GROUP BY usl_id, vsj_id, dat_poc, GREATEST (dat_poc, dat_zav), recara_id, obr_zdana
    HAVING MAX (NVL (cijenacp, cijena)) <> 0)
  LOOP
    recrezcjeusl_rec_l.rez_id := rez_id_p;
    recrezcjeusl_rec_l.vsj_id := recrezcjeusl_c.vsj_id;
    recrezcjeusl_rec_l.usl_id := recrezcjeusl_c.usl_id;
    recrezcjeusl_rec_l.dat_poc := recrezcjeusl_c.dat_poc;
    IF recrezcjeusl_c.dat_zav <= rez_odlaz_l AND recrezcjeusl_c.obr_zdana = 0 THEN -- IRN 3988
      recrezcjeusl_rec_l.dat_zav := recrezcjeusl_c.dat_zav - 1;
    ELSE
      recrezcjeusl_rec_l.dat_zav := recrezcjeusl_c.dat_zav;
    END IF;
    recrezcjeusl_rec_l.cijena_usluge := recrezcjeusl_c.cijena_usluge;
    recrezcjeusl_rec_l.recara_id := recrezcjeusl_c.recara_id;

    pra_rec_iud2.insert_recrezcje_cvor (
      metcvor_sifra_p => NULL,
      recrezcje_rec_p => recrezcjeusl_rec_l);
  END LOOP;

  DELETE FROM prec_troskovi;
  COMMIT;
END;
FUNCTION MS_U_PARAM
 (MS_ID_P IN T_REZERVACIJE.MS_ID%TYPE
 ,PARAM_STRING_P IN SZMP_PARAMETRI.VRIJEDNOST%TYPE
 )
 RETURN NUMBER
 IS
--   
  CURSOR in_c IS
    SELECT id 
	  FROM m_msegmenti
	 WHERE UPPER(sifra) IN
	         (SELECT UPPER(RTRIM(LTRIM(SUBSTR(',' || param_string_p,
                                              INSTR (',' || param_string_p, ',', 1, n) + 1,
                                              ABS (INSTR (',' || param_string_p, ',', 1, n) + 1
                                                   -
                                                   NVL (LEAD (INSTR (',' || param_string_p, ',', 1, n)) OVER (ORDER BY n), LENGTH (',' || param_string_p) + 1)
                                                   )
                                              )
                                       )
                                 )
                           )
                FROM (SELECT ROWNUM n
                        FROM dual
                  CONNECT BY LEVEL <= LENGTH (',' || param_string_p) - LENGTH (REPLACE (',' || param_string_p, ','))
                      )
              )
       AND id = ms_id_p;
  retval_l NUMBER(2);
  nebitno_l m_msegmenti.id%TYPE;
BEGIN                
  OPEN in_c;
  FETCH in_c INTO nebitno_l;
  IF in_c%NOTFOUND THEN
    retval_l := 0;
  ELSE
    retval_l := -1;
  END IF;
  CLOSE in_c;
  RETURN retval_l;
END;
FUNCTION POSTOJI_REZERVACIJA_UPUT
 (SO_ID_P IN t_rezervacije.so_id%TYPE
 ,AGE_ID_P IN t_rezervacije.age_id%TYPE
 ,BR_UPUTNICE_P IN t_rezervacije.br_uputnice%TYPE
 ,GOD_POSLOVNA_P IN t_rezervacije.god_poslovna%TYPE
 ,ID_P IN T_REZERVACIJE.ID%TYPE
 )
 RETURN NUMBER
 IS
/*
Upozori da postoji rezervacija za isti broj uputnice i poslovnu godinu i ostale podatke ovisno o REC param 1188
Provjeravaju se sve valjane rezervacije (i ako su djelomino ponitene)
Provjerava se upper vrijednost uputnice.
*/
  br_redaka_l NUMBER := 0;
  RECparam_1188 szmp_parametri.vrijednost%TYPE := pra_rec_zaj.vrijednost_parametra ('1188');
BEGIN
  IF br_uputnice_p IS NULL
    OR god_poslovna_p IS NULL
    OR RECparam_1188 = 'nebitno'
  THEN
    RETURN (0);
  END IF;

 /*
 REC 1188 Rezervacije; Kod provjere rezervacije na isti broj uputnice i poslovne godine, treba uzimati u obzir: 
 0 = nita, 
 1 = samo agenciju, 
 2 = samo SO, 
 3 = i agenciju i SO, 
 nebitno = ne provjeravati.
 */
 IF RECparam_1188 = '3' THEN
    SELECT COUNT (ROWID) INTO br_redaka_l
      FROM t_rezervacije
     WHERE oznaka = 'V'
       --AND ozn_vstorna IS NULL -- provjeravaju se i rezervacije koje su djelomino ponitene
       AND so_id = so_id_p
       AND NVL (age_id, 0) = NVL (age_id_p, 0)
       AND UPPER (br_uputnice) = UPPER (br_uputnice_p)
       AND god_poslovna = god_poslovna_p
       AND id <> NVL (id_p, 0);

  ELSIF RECparam_1188 = '2' THEN
    SELECT COUNT (ROWID) INTO br_redaka_l
      FROM t_rezervacije
     WHERE oznaka = 'V'
      -- AND ozn_vstorna IS NULL
       AND so_id = so_id_p
       AND UPPER (br_uputnice) = UPPER (br_uputnice_p)
       AND god_poslovna = god_poslovna_p
       AND id <> NVL (id_p, 0);

  ELSIF RECparam_1188 = '1' THEN
    SELECT COUNT (ROWID) INTO br_redaka_l
      FROM t_rezervacije
     WHERE oznaka = 'V'
       --AND ozn_vstorna IS NULL
       AND NVL (age_id, 0) = NVL (age_id_p, 0)
       AND UPPER (br_uputnice) = UPPER (br_uputnice_p)
       AND god_poslovna = god_poslovna_p
       AND id <> NVL (id_p, 0);
  
  ELSIF RECparam_1188 = '0' THEN
    SELECT COUNT (ROWID) INTO br_redaka_l
      FROM t_rezervacije
     WHERE oznaka = 'V'
      -- AND ozn_vstorna IS NULL
       AND UPPER (br_uputnice) = UPPER (br_uputnice_p)
       AND god_poslovna = god_poslovna_p
       AND id <> NVL (id_p, 0);
  END IF;

  IF br_redaka_l > 0 THEN
    RETURN (-1);
  ELSE
    RETURN (0);
  END IF;

END;

END FM_REC2120;
/
SHOW ERROR

