PROMPT Creating Package Body 'FM_REC2030'
CREATE OR REPLACE PACKAGE BODY FM_REC2030 IS
-- IRN 2918 VS
so_tab_m     so_array_table;
brojac_so_m  BINARY_INTEGER := 0;
akt_tab_m    akt_array_table;
brojac_akt_m BINARY_INTEGER := 0;
-- END IRN 2918 VS

PROCEDURE POMAKNI_DATUM
 (DATUM_P IN OUT t_ponude.dat_poc%TYPE
 ,DAT_POC_OLD_P IN t_ponude.dat_poc%TYPE
 ,DAT_POC_P IN t_ponude.dat_poc%TYPE
 ,DAT_ZAV_P IN t_ponude.dat_zav%TYPE
 ,PRODUZI_PON_P IN BOOLEAN := false
 ,DAT_ZAV_RAZ_P IN t_ponude.dat_zav%TYPE := NULL
 );
PROCEDURE DOHVATI_PONOJR_ID
 (PONOJR_ID_P IN OUT t_pon_ojr.id%TYPE
 ,PON_ID_P IN t_ponude.id%TYPE
 ,ZMPOJR_ID_P IN t_pon_ojr.zmpojr_id%TYPE
 ,IZN_PREDUJMA_GAS_P IN t_pon_ojr.izn_predujma_gas%TYPE
 );


PROCEDURE POMAKNI_DATUM
 (DATUM_P IN OUT t_ponude.dat_poc%TYPE
 ,DAT_POC_OLD_P IN t_ponude.dat_poc%TYPE
 ,DAT_POC_P IN t_ponude.dat_poc%TYPE
 ,DAT_ZAV_P IN t_ponude.dat_zav%TYPE
 ,PRODUZI_PON_P IN BOOLEAN := false
 ,DAT_ZAV_RAZ_P IN t_ponude.dat_zav%TYPE := NULL
 )
 IS
BEGIN
  IF datum_p IS NULL OR dat_poc_p IS NULL OR dat_poc_old_p IS NULL THEN
    RETURN;
  END IF;

  IF produzi_pon_p THEN
    datum_p := dat_zav_raz_p + (datum_p - TRUNC (datum_p));
    RETURN;
  END IF;

  datum_p := datum_p + (TRUNC (dat_poc_p) - TRUNC (dat_poc_old_p));

  IF dat_zav_p IS NOT NULL AND datum_p > dat_zav_p THEN
    datum_p := dat_zav_p + (datum_p - TRUNC (datum_p));
  END IF;

  IF dat_zav_p IS NOT NULL AND datum_p > dat_zav_p THEN
    datum_p := dat_zav_p + (datum_p - TRUNC (datum_p));
  END IF;
END;
PROCEDURE DOHVATI_PONOJR_ID
 (PONOJR_ID_P IN OUT t_pon_ojr.id%TYPE
 ,PON_ID_P IN t_ponude.id%TYPE
 ,ZMPOJR_ID_P IN t_pon_ojr.zmpojr_id%TYPE
 ,IZN_PREDUJMA_GAS_P IN t_pon_ojr.izn_predujma_gas%TYPE
 )
 IS
--
  test_l       NUMBER;
  ponojr_id_l  t_pon_ojr.id%TYPE;
  ponojr_rec_l t_pon_ojr%ROWTYPE;
BEGIN
  SELECT COUNT (1) INTO test_l
    FROM t_pon_ojr
   WHERE zmpojr_id = zmpojr_id_p
     AND pon_id = pon_id_p;

  -- ako je potrebno unijeti knjigu racuna
  IF test_l = 0 THEN
    ponojr_id_l := pra_rec_zaj.sekvenca (NULL);
    ponojr_rec_l.id := ponojr_id_l;
    ponojr_rec_l.pon_id := pon_id_p;
    ponojr_rec_l.zmpojr_id := zmpojr_id_p;
    ponojr_rec_l.izn_predujma_gas := izn_predujma_gas_p;
    ponojr_rec_l.unos_korisnik := NULL;
    ponojr_rec_l.unos_dat := NULL;
    ponojr_rec_l.izmjena_korisnik := NULL;
    ponojr_rec_l.izmjena_dat := NULL;
    INSERT INTO t_pon_ojr VALUES ponojr_rec_l;
  ELSE
    SELECT id INTO ponojr_id_l
      FROM t_pon_ojr
     WHERE zmpojr_id = zmpojr_id_p
       AND pon_id = pon_id_p;
  END IF;

  ponojr_id_p := ponojr_id_l;
END;
FUNCTION POSLUJE_SO
 (SO_ID_P IN t_pon_so.so_id%TYPE
 ,DAT_POC_P IN t_pon_so.dat_poc%TYPE
 ,DAT_ZAV_P IN t_pon_so.dat_zav%TYPE
 )
 RETURN NUMBER
 IS
-- Upozori ako je ponueno razdoblje izvan razdoblja poslovanja SO
  br_redaka_l NUMBER := 0;
BEGIN
  IF so_id_p IS NULL OR dat_poc_p IS NULL OR dat_zav_p IS NULL THEN
    RETURN (-1);
  END IF;

  SELECT COUNT (1) INTO br_redaka_l
    FROM trec_so_poslovanja
   WHERE so_id = so_id_p
     AND dat_poc_p BETWEEN dat_otvaranja AND dat_zatvaranja
     AND dat_zav_p BETWEEN dat_otvaranja AND dat_zatvaranja;

  IF br_redaka_l > 0 THEN
    RETURN (-1);
  ELSE
    RETURN (0);
  END IF;

END;
FUNCTION POSTOJE_VSJ
 (PON_ID_P IN t_ponude.id%TYPE
 ,SO_ID_OLD_P IN m_so.id%TYPE
 ,SO_ID_NEW_P IN m_so.id%TYPE
 ,DAT_POC_P IN DATE
 ,DAT_ZAV_P IN DATE
 )
 RETURN INTEGER
 IS
-- vrati -1 ako novi SO ima sve ponuene vrste SJ
  postoje_vsj_l INTEGER(1) := -1;
BEGIN
  IF pon_id_p IS NULL OR so_id_old_p IS NULL OR so_id_new_p IS NULL THEN
    RETURN 0;
  END IF;

  FOR ponvsj IN (
    SELECT ponvsj.vsj_id
      FROM t_pon_vsj ponvsj,
           t_pon_so ponso,
           t_pon_ojr ponojr,
           t_ponude pon
     WHERE pon.id = ponojr.pon_id
       AND ponojr.id = ponso.ponojr_id
       AND ponso.id = ponvsj.ponso_id
       AND pon.id = pon_id_p
       AND ponso.so_id = so_id_old_p)
  LOOP
    -- IRN 3304; pra_rec_s.vsj_pripada_so umjesto fm_rec2040.postoji_vsj_u_so 
    IF pra_rec_s.vsj_pripada_so (ponvsj.vsj_id, so_id_new_p, dat_poc_p, dat_zav_p, 0) = 0 THEN
      postoje_vsj_l := 0;
      EXIT;
    END IF;
  END LOOP;

  RETURN postoje_vsj_l;
END;
FUNCTION POSTOJI_PON_REZ
 (PONSO_ID_P IN t_ponude.id%TYPE
 ,METCVOR_SIFRA_P IN smet_cvorovi.sifra%TYPE
 )
 RETURN NUMBER
 IS
--
  metcvor_sifra_l VARCHAR2(21);
  naredba_l       VARCHAR2(1000);
  br_redaka_l     NUMBER;
BEGIN
  IF metcvor_sifra_p IS NOT NULL THEN
    metcvor_sifra_l := '@' || metcvor_sifra_p;
  END IF;

  naredba_l :=
    'SELECT COUNT(1)' ||
    '  FROM t_rezervacije<CVOR>' ||
    ' WHERE ponso_id = ' || ponso_id_p ||
    '   AND oznaka = ''V'' ' ||
    '   AND ozn_vstorna IS NULL';

  EXECUTE IMMEDIATE REPLACE (naredba_l, '<CVOR>', metcvor_sifra_l) INTO br_redaka_l;

  IF br_redaka_l > 0 THEN
    RETURN (-1);
  END IF;
  RETURN (0);
END;
PROCEDURE KOPIRAJ_PONUDU
 (PON_ID_OLD_P IN t_ponude.id%TYPE
 ,PON_ID_NEW_P IN t_ponude.id%TYPE
 ,GOD_POSLOVNA_NEW_P IN t_ponude.god_poslovna%TYPE
 ,DAT_POC_OLD_P IN t_ponude.dat_poc%TYPE := NULL
 ,DAT_ZAV_OLD_P IN t_ponude.dat_zav%TYPE := NULL
 ,DAT_POC_P IN t_ponude.dat_poc%TYPE := NULL
 ,DAT_ZAV_P IN t_ponude.dat_zav%TYPE := NULL
 ,KOPIRANJE_AKTIVNOSTI_P IN BOOLEAN := TRUE
 ,SAMO_DODMOG_P IN BOOLEAN := FALSE
 ,NAZIV_GRUPE_P IN t_ponude.naz_grupe%TYPE
 ,OZN_KOPIRATI_RECPONVSJA_P IN NUMBER
 )
 IS
/*
Kopiraj ponude i njene stavke u novu ponudu
t_ponude, t_pon_ojr, t_pon_so, t_pon_sousl, t_pon_vsj, t_pon_vsjusl, trec_pon_vsja, trec_pon_bor, trec_pon_rok, trec_pon_vpro, trec_pon_cjeusl
*/
  pon_rec_l            t_ponude%ROWTYPE;
  ponso_rec_l          t_pon_so%ROWTYPE;
  ponsousl_rec_l       t_pon_sousl%ROWTYPE;
  ponvsj_rec_l         t_pon_vsj%ROWTYPE;
  ponvsjusl_rec_l      t_pon_vsjusl%ROWTYPE;
  recponvsja_rec_l     trec_pon_vsja%ROWTYPE;
  ponsopred_rec_l      t_ponso_pred%ROWTYPE;
  recponbor_rec_l      trec_pon_bor%ROWTYPE;
  recponrok_rec_l      trec_pon_rok%ROWTYPE;
  recponvpro_rec_l     trec_pon_vpro%ROWTYPE;
  recponvproraz_rec_l  trec_ponvpro_razdoblja%ROWTYPE;
  recponcje_rec_l      trec_pon_cjeusl%ROWTYPE;
  pondog_rec_l         t_pon_dog%ROWTYPE;
  pondogslu_rec_l      t_pon_dogslu%ROWTYPE;
  ponpros_rec_l        t_pon_pros%ROWTYPE;
  ponopr_rec_l         t_pon_opr%ROWTYPE;
  ponnap_rec_l         t_pon_nap%ROWTYPE;
  pondog_id_l          t_pon_dog.id%TYPE;
  ponpros_id_l         t_pon_pros.id%TYPE;
  ponojr_id_l          t_pon_ojr.id%TYPE;
  ponso_id_l           t_pon_so.id%TYPE;
  ponvsj_id_l          t_pon_vsj.id%TYPE;
  recponvpro_id_l      trec_pon_vpro.id%TYPE;
  ponojr_akt_id_l      t_pon_ojr.id%TYPE;
  zmpojr_id_new_l      t_pon_ojr.zmpojr_id%TYPE;
  zmpojr_akt_id_new_l  t_pon_ojr.zmpojr_id%TYPE;
  so_id_new_l          t_pon_so.so_id%TYPE;
  dog_tab_l            dog_array_table; -- IRN 2918
  brojac_dog_l         BINARY_INTEGER := 0; -- IRN 2918
  test_l               NUMBER;
  nova_ponuda_l        NUMBER;
  kopiraj_aktivnosti_l BOOLEAN := kopiranje_aktivnosti_p;
  datum_kraj_p         DATE := TRUNC (dat_poc_old_p) + (TRUNC (dat_zav_p) - TRUNC (dat_poc_p));
  dat_zav_pon_l        DATE;
  dat_zav_l            DATE;

  CURSOR recponcje_cur (
    ponso_id_k    trec_pon_cjeusl.ponso_id%TYPE,
    vsj_id_k      trec_pon_cjeusl.vsj_id%TYPE,
    usl_id_k      trec_pon_cjeusl.usl_id%TYPE,
    recara_id_k   trec_pon_cjeusl.recara_id%TYPE,
    dat_poc_k     trec_pon_cjeusl.dat_poc%TYPE)
  IS
    SELECT 1
      FROM trec_pon_cjeusl
     WHERE ponso_id = ponso_id_k
       AND vsj_id = vsj_id_k
       AND usl_id = usl_id_k
       AND NVL (recara_id, 0) = NVL (recara_id_k, 0)
       AND dat_poc = dat_poc_k;

  ima_l NUMBER (1);
BEGIN
  /* samo vor-centar moe kopirati ponudu na druge vorove */
  IF pra_zmp_zaj.centar = 0 THEN
    pra_rec_zaj.vrati_poruku (-20545);
  END IF;
  IF pon_id_old_p IS NULL OR pon_id_new_p IS NULL THEN
    RETURN;
  END IF;

  SELECT COUNT (1) INTO nova_ponuda_l FROM t_ponude WHERE id = pon_id_new_p;

  /* ako je potrebno unijeti ponudu */
  IF nova_ponuda_l = 0 THEN
    -- upis u T_PONUDE
    SELECT * INTO pon_rec_l FROM t_ponude WHERE id = pon_id_old_p;
    pon_rec_l.id := pon_id_new_p;       -- novi id
    pon_rec_l.crmid := NULL;            -- bez veze na crm
    pon_rec_l.god_poslovna := god_poslovna_new_p; -- nova poslovna godina
    pon_rec_l.rbr := NULL;              -- rbr ce se napuniti u BIR trigeru
    pon_rec_l.ozn_valjanosti := 'V';
    pon_rec_l.oznaka := pra_rec_zaj.vrijednost_parametra ('1116'); -- Ponude; Inicijalna oznaka za ponudu: * = u izradi, V = valjana.
    pon_rec_l.naz_grupe := naziv_grupe_p;
    pon_rec_l.ozn_book := NULL;
    pon_rec_l.ozn_rezervacije := 0;
    pon_rec_l.ozn_irs := 0;
    pon_rec_l.ozn_vstorna := NULL;
    pon_rec_l.opis_storna := NULL;
    IF pon_rec_l.oznaka = 'V' THEN
      pon_rec_l.ozn_book := 1;
    END IF;
    pon_rec_l.unos_korisnik := NULL;
    pon_rec_l.unos_dat := NULL;
    pon_rec_l.izmjena_korisnik := NULL;
    pon_rec_l.izmjena_dat := NULL;
    pon_rec_l.dat_ozn_book := NULL;
    pon_rec_l.dat_statusa := NULL;
    dat_zav_pon_l := dat_zav_p;
    dat_zav_l := dat_zav_p + (NVL (pon_rec_l.dat_odl_max, pon_rec_l.dat_zav) - TRUNC (pon_rec_l.dat_zav));

    pon_rec_l.dat_zav := dat_zav_p;
    pomakni_datum (pon_rec_l.dat_poc, dat_poc_old_p, dat_poc_p, dat_zav_pon_l);
    pomakni_datum (pon_rec_l.dat_odl_max, dat_poc_old_p, dat_poc_p, dat_zav_l);
    pomakni_datum (pon_rec_l.dat_dol_min, dat_poc_old_p, dat_poc_p, dat_zav_l);
    -- pomakni_datum (pon_rec_l.dat_vpro_rez, dat_poc_old_p, dat_poc_p, dat_zav_l);
    pon_rec_l.datum := TRUNC (SYSDATE);
    pomakni_datum (pon_rec_l.dat_dospijeca, dat_poc_old_p, dat_poc_p, dat_zav_l);
    IF pon_rec_l.dat_dospijeca < pon_rec_l.datum THEN
      pon_rec_l.dat_dospijeca := NULL;
    END IF;

    pomakni_datum (pon_rec_l.dat_dosppopisa, dat_poc_old_p, dat_poc_p, dat_poc_p);
    IF pon_rec_l.dat_dosppopisa < pon_rec_l.datum THEN
      pon_rec_l.dat_dosppopisa := NULL;
    END IF;

    pomakni_datum (pon_rec_l.dat_opcije, dat_poc_old_p, dat_poc_p, NULL);
    IF pon_rec_l.dat_opcije < pon_rec_l.datum THEN
      pon_rec_l.dat_opcije := NULL;
    END IF;

    INSERT INTO t_ponude VALUES pon_rec_l;

  ELSE -- nova_ponuda_l
    SELECT dat_zav, NVL (dat_odl_max, dat_zav)
      INTO dat_zav_pon_l, dat_zav_l
      FROM t_ponude pon
     WHERE pon.id = pon_id_new_p;
  END IF;

  IF kopiraj_aktivnosti_l THEN
    brojac_dog_l := 0; -- IRN 2918 VS
    FOR pondog IN (
      SELECT *
        FROM t_pon_dog
       WHERE pon_id = pon_id_old_p
         AND ponojr_id IS NULL
         AND dat_poc <= datum_kraj_p)
    LOOP
      pondog_id_l := pra_rec_zaj.sekvenca (NULL);
      -- IRN 2918 VS
      -- dog_conversion (pondog.id) := pondog_id_l;
      brojac_dog_l := brojac_dog_l + 1;
      dog_tab_l (brojac_dog_l).id_novi_dog := pondog_id_l;
      dog_tab_l (brojac_dog_l).id_stari_dog := pondog.id;
      -- END IRN 2918 VS
      pondog_rec_l := pondog;
      pondog_rec_l.id := pondog_id_l;
      pondog_rec_l.pon_id := pon_id_new_p;
      pondog_rec_l.unos_korisnik := NULL;
      pondog_rec_l.unos_dat := NULL;
      pondog_rec_l.izmjena_korisnik := NULL;
      pondog_rec_l.izmjena_dat := NULL;
      pomakni_datum (
        pondog_rec_l.sat_zav, dat_poc_old_p, dat_poc_p, dat_zav_l,
        pondog_rec_l.dat_poc < pondog_rec_l.dat_zav AND pondog_rec_l.dat_zav = dat_zav_old_p,
        dat_zav_pon_l);
      pomakni_datum (
        pondog_rec_l.dat_zav, dat_poc_old_p, dat_poc_p, dat_zav_l,
        pondog_rec_l.dat_poc < pondog_rec_l.dat_zav AND pondog_rec_l.dat_zav = dat_zav_old_p,
        dat_zav_pon_l);
      pomakni_datum (pondog_rec_l.dat_poc, dat_poc_old_p, dat_poc_p, dat_zav_l);
      pomakni_datum (pondog_rec_l.sat_poc, dat_poc_old_p, dat_poc_p, dat_zav_l);
      INSERT INTO t_pon_dog VALUES pondog_rec_l;

    END LOOP; -- T_PON_DOG
  END IF;

  -- T_PON_OJR
  FOR ponojr IN (
    SELECT * FROM t_pon_ojr WHERE pon_id = pon_id_old_p)
  LOOP
    -- upis u T_PON_SO
    FOR ponso IN (
      SELECT * FROM t_pon_so WHERE ponojr_id = ponojr.id AND dat_poc <= datum_kraj_p)
    LOOP

      -- IRN 2918
      -- so_id_new_l := so_id_list_p (ponso.so_id);
      IF brojac_so_m > 0 THEN
        FOR i IN so_tab_m.FIRST .. brojac_so_m
        LOOP
          IF so_tab_m (i).id_stari_so = ponso.so_id THEN
            so_id_new_l := so_tab_m (i).id_novi_so;
          END IF;
        END LOOP;
      END IF;
      -- END IRN 2918

      -- ako nije na listi, preskoci
      IF so_id_new_l IS NULL THEN
        GOTO foo_so;
      END IF;

      SELECT ojr_id INTO zmpojr_id_new_l
        FROM m_so
       WHERE id = so_id_new_l;

      dohvati_ponojr_id (ponojr_id_l, pon_id_new_p, zmpojr_id_new_l, ponojr.izn_predujma_gas);

      SELECT COUNT (1) INTO test_l
        FROM t_pon_so
       WHERE so_id = so_id_new_l
         AND ponojr_id = ponojr_id_l;

      /* ako je potrebno unijeti PONSO */
      IF test_l = 0 THEN
        ponso_id_l := pra_rec_zaj.sekvenca (NULL);
        ponso_rec_l := ponso;
        ponso_rec_l.id := ponso_id_l;
        ponso_rec_l.ponojr_id := ponojr_id_l;
        ponso_rec_l.so_id := so_id_new_l;
        ponso_rec_l.unos_korisnik := NULL;
        ponso_rec_l.unos_dat := NULL;
        ponso_rec_l.izmjena_korisnik := NULL;
        ponso_rec_l.izmjena_dat := NULL;
        pomakni_datum (
          ponso_rec_l.dat_odl_max, dat_poc_old_p, dat_poc_p, dat_zav_l,
          ponso_rec_l.dat_dol_min < ponso_rec_l.dat_odl_max AND ponso_rec_l.dat_odl_max = dat_zav_old_p,
          dat_zav_pon_l);
        pomakni_datum (
          ponso_rec_l.dat_zav, dat_poc_old_p, dat_poc_p, dat_zav_pon_l,
          ponso_rec_l.dat_poc < ponso_rec_l.dat_zav AND ponso_rec_l.dat_zav = dat_zav_old_p,
          dat_zav_pon_l);
        pomakni_datum (ponso_rec_l.dat_poc, dat_poc_old_p, dat_poc_p, dat_zav_pon_l);
        pomakni_datum (ponso_rec_l.dat_dol_min, dat_poc_old_p, dat_poc_p, dat_zav_l);
        INSERT INTO t_pon_so VALUES ponso_rec_l;
      ELSE
        SELECT id INTO ponso_id_l
          FROM t_pon_so
         WHERE so_id = so_id_new_l
           AND ponojr_id = ponojr_id_l;
      END IF;

      IF NOT samo_dodmog_p THEN
        -- upis u T_PON_SOUSL
        FOR ponsousl IN (
          SELECT * FROM t_pon_sousl WHERE ponso_id = ponso.id AND dat_poc <= datum_kraj_p)
        LOOP
          ponsousl_rec_l := ponsousl;
          ponsousl_rec_l.id := NULL;
          ponsousl_rec_l.ponso_id := ponso_id_l;
          ponsousl_rec_l.unos_korisnik := NULL;
          ponsousl_rec_l.unos_dat := NULL;
          ponsousl_rec_l.izmjena_korisnik := NULL;
          ponsousl_rec_l.izmjena_dat := NULL;
          pomakni_datum (
          ponsousl_rec_l.dat_zav, dat_poc_old_p, dat_poc_p, dat_zav_l,
          ponsousl_rec_l.dat_poc < ponsousl_rec_l.dat_zav AND ponsousl_rec_l.dat_zav = dat_zav_old_p,
          dat_zav_pon_l);
          pomakni_datum (ponsousl_rec_l.dat_poc, dat_poc_old_p, dat_poc_p, dat_zav_l);
          INSERT INTO t_pon_sousl VALUES ponsousl_rec_l;
        END LOOP;

        -- upis u T_PON_VSJ
        FOR ponvsj IN (
          SELECT * FROM t_pon_vsj WHERE ponso_id = ponso.id AND dat_poc <= datum_kraj_p)
        LOOP
          ponvsj_rec_l := ponvsj;
          pomakni_datum (
            ponvsj_rec_l.dat_zav, dat_poc_old_p, dat_poc_p, dat_zav_l,
            ponvsj_rec_l.dat_poc < ponvsj_rec_l.dat_zav AND ponvsj_rec_l.dat_zav = dat_zav_old_p,
            dat_zav_pon_l);
          pomakni_datum (ponvsj_rec_l.dat_poc, dat_poc_old_p, dat_poc_p, dat_zav_l);
          -- IRN 3304; pra_rec_s.vsj_pripada_so umjesto fm_rec2040.postoji_vsj_u_so
          IF pra_rec_s.vsj_pripada_so (ponvsj.vsj_id, so_id_new_l, ponvsj_rec_l.dat_poc, ponvsj_rec_l.dat_zav, 0) <> 0 THEN
            ponvsj_id_l := pra_rec_zaj.sekvenca (NULL); -- sekvenca se trai zbog upisa u T_PON_VSJUSL i TREC_PON_VSJA
            ponvsj_rec_l.id := ponvsj_id_l;
            ponvsj_rec_l.ponso_id := ponso_id_l;
            ponvsj_rec_l.unos_korisnik := NULL;
            ponvsj_rec_l.unos_dat := NULL;
            ponvsj_rec_l.izmjena_korisnik := NULL;
            ponvsj_rec_l.izmjena_dat := NULL;
            INSERT INTO t_pon_vsj VALUES ponvsj_rec_l;

            -- upis u T_PON_VSJUSL
            FOR ponvsjusl IN (
              SELECT * FROM t_pon_vsjusl WHERE ponvsj_id = ponvsj.id AND dat_poc <= datum_kraj_p)
            LOOP
              ponvsjusl_rec_l := ponvsjusl;
              ponvsjusl_rec_l.id := NULL;
              ponvsjusl_rec_l.ponvsj_id := ponvsj_id_l;
              ponvsjusl_rec_l.unos_korisnik := NULL;
              ponvsjusl_rec_l.unos_dat := NULL;
              ponvsjusl_rec_l.izmjena_korisnik := NULL;
              ponvsjusl_rec_l.izmjena_dat := NULL;
              pomakni_datum (
                ponvsjusl_rec_l.dat_zav, dat_poc_old_p, dat_poc_p, dat_zav_l,
                ponvsjusl_rec_l.dat_poc < ponvsjusl_rec_l.dat_zav AND ponvsjusl_rec_l.dat_zav = dat_zav_old_p,
                dat_zav_pon_l);
              pomakni_datum (ponvsjusl_rec_l.dat_poc, dat_poc_old_p, dat_poc_p, dat_zav_l);
              INSERT INTO t_pon_vsjusl VALUES ponvsjusl_rec_l;
            END LOOP;

            IF ozn_kopirati_recponvsja_p = -1 THEN -- IRN 1609
              -- upis u TREC_PON_VSJA
              FOR recponvsja IN (
                SELECT * FROM trec_pon_vsja WHERE ponvsj_id = ponvsj.id AND dat_poc <= datum_kraj_p)
              LOOP
                recponvsja_rec_l := recponvsja;
                recponvsja_rec_l.id := NULL;
                recponvsja_rec_l.ponvsj_id := ponvsj_id_l;
                recponvsja_rec_l.unos_korisnik := NULL;
                recponvsja_rec_l.unos_dat := NULL;
                recponvsja_rec_l.izmjena_korisnik := NULL;
                recponvsja_rec_l.izmjena_dat := NULL;
                pomakni_datum (
                  recponvsja_rec_l.dat_zav, dat_poc_old_p, dat_poc_p, dat_zav_l,
                  recponvsja_rec_l.dat_poc < recponvsja_rec_l.dat_zav AND recponvsja_rec_l.dat_zav = dat_zav_old_p,
                  dat_zav_pon_l);
                pomakni_datum (recponvsja_rec_l.dat_poc, dat_poc_old_p, dat_poc_p, dat_zav_l);
                INSERT INTO trec_pon_vsja VALUES recponvsja_rec_l;
              END LOOP;
            END IF;
          END IF;

          -- upis u TREC_PON_CJEUSL
          FOR recponcje IN (
            SELECT vsj_id, usl_id, recara_id, dat_poc, dat_zav, cijena_usluge
              FROM trec_pon_cjeusl
             WHERE ponso_id = ponso.id
               AND dat_poc <= datum_kraj_p
               AND vsj_id = ponvsj.vsjc_id
            MINUS
            SELECT vsj_id, usl_id, recara_id, dat_poc, dat_zav, cijena_usluge
              FROM trec_pon_cjeusl
             WHERE ponso_id = ponso_id_l)
          LOOP
            recponcje_rec_l.id := NULL;
            recponcje_rec_l.vsj_id := recponcje.vsj_id;
            recponcje_rec_l.usl_id := recponcje.usl_id;
            recponcje_rec_l.recara_id := recponcje.recara_id;
            recponcje_rec_l.dat_poc := recponcje.dat_poc;
            recponcje_rec_l.dat_zav := recponcje.dat_zav;
            recponcje_rec_l.cijena_usluge := recponcje.cijena_usluge;
            recponcje_rec_l.ponso_id := ponso_id_l;
            recponcje_rec_l.unos_korisnik := NULL;
            recponcje_rec_l.unos_dat := NULL;
            recponcje_rec_l.izmjena_korisnik := NULL;
            recponcje_rec_l.izmjena_dat := NULL;
            pomakni_datum (
              recponcje_rec_l.dat_zav, dat_poc_old_p, dat_poc_p, dat_zav_l,
              recponcje_rec_l.dat_poc < recponcje_rec_l.dat_zav AND recponcje_rec_l.dat_zav = dat_zav_old_p,
              dat_zav_pon_l);
            pomakni_datum (recponcje_rec_l.dat_poc, dat_poc_old_p, dat_poc_p, dat_zav_l);
            OPEN recponcje_cur (
              ponso_id_l,
              recponcje_rec_l.vsj_id,
              recponcje_rec_l.usl_id,
              recponcje_rec_l.recara_id,
              recponcje_rec_l.dat_poc); --, recponcje_rec_l.dat_zav, recponcje_rec_l.cijena_usluge);
            FETCH recponcje_cur INTO ima_l;
            IF recponcje_cur%NOTFOUND THEN
              INSERT INTO trec_pon_cjeusl VALUES recponcje_rec_l;
            END IF;
            CLOSE recponcje_cur;
          END LOOP;

        END LOOP; -- T_PON_VSJ

        -- upis u TREC_PON_CJEUSL
        FOR recponcje IN (
          SELECT *
            FROM trec_pon_cjeusl
           WHERE ponso_id = ponso.id
             AND dat_poc <= datum_kraj_p
             AND vsj_id IS NULL)
        LOOP
          recponcje_rec_l := recponcje;
          recponcje_rec_l.id := NULL;
          recponcje_rec_l.ponso_id := ponso_id_l;
          recponcje_rec_l.unos_korisnik := NULL;
          recponcje_rec_l.unos_dat := NULL;
          recponcje_rec_l.izmjena_korisnik := NULL;
          recponcje_rec_l.izmjena_dat := NULL;
          pomakni_datum (
            recponcje_rec_l.dat_zav, dat_poc_old_p, dat_poc_p, dat_zav_l,
            recponcje_rec_l.dat_poc < recponcje_rec_l.dat_zav AND recponcje_rec_l.dat_zav = dat_zav_old_p,
            dat_zav_pon_l);
          pomakni_datum (recponcje_rec_l.dat_poc, dat_poc_old_p, dat_poc_p, dat_zav_l);
          INSERT INTO trec_pon_cjeusl VALUES recponcje_rec_l;
        END LOOP;
      END IF;

      SELECT COUNT (1) INTO test_l FROM trec_pon_rok WHERE ponso_id = ponso_id_l;
      IF test_l = 0 THEN -- puni se samo ako je prazna
        -- upis u TREC_PON_ROK
        FOR recponrok IN (
          SELECT * FROM trec_pon_rok WHERE ponso_id = ponso.id AND dat_poc <= datum_kraj_p)
        LOOP
          recponrok_rec_l := recponrok;
          recponrok_rec_l.id := NULL;
          recponrok_rec_l.ponso_id := ponso_id_l;
          recponrok_rec_l.unos_korisnik := NULL;
          recponrok_rec_l.unos_dat := NULL;
          recponrok_rec_l.izmjena_korisnik := NULL;
          recponrok_rec_l.izmjena_dat := NULL;
          pomakni_datum (
            recponrok_rec_l.dat_zav, dat_poc_old_p, dat_poc_p, dat_zav_l,
            recponrok_rec_l.dat_poc < recponrok_rec_l.dat_zav AND recponrok_rec_l.dat_zav = dat_zav_old_p,
            dat_zav_pon_l);
          pomakni_datum (recponrok_rec_l.dat_poc, dat_poc_old_p, dat_poc_p, dat_zav_l);
          INSERT INTO trec_pon_rok VALUES recponrok_rec_l;
        END LOOP;
      END IF;

      SELECT COUNT (1) INTO test_l FROM trec_pon_bor WHERE ponso_id = ponso_id_l;
      IF test_l = 0 THEN -- puni se samo ako je prazna
        -- upis u TREC_PON_BOR
        FOR recponbor IN (
          SELECT * FROM trec_pon_bor WHERE ponso_id = ponso.id AND dat_poc <= datum_kraj_p)
        LOOP
          recponbor_rec_l := recponbor;
          recponbor_rec_l.id := NULL;
          recponbor_rec_l.ponso_id := ponso_id_l;
          recponbor_rec_l.unos_korisnik := NULL;
          recponbor_rec_l.unos_dat := NULL;
          recponbor_rec_l.izmjena_korisnik := NULL;
          recponbor_rec_l.izmjena_dat := NULL;
          pomakni_datum (
            recponbor_rec_l.dat_zav, dat_poc_old_p, dat_poc_p, dat_zav_l,
            recponbor_rec_l.dat_poc < recponbor_rec_l.dat_zav AND recponbor_rec_l.dat_zav = dat_zav_old_p,
            dat_zav_pon_l);
          pomakni_datum (recponbor_rec_l.dat_poc, dat_poc_old_p, dat_poc_p, dat_zav_l);
          INSERT INTO trec_pon_bor VALUES recponbor_rec_l;
        END LOOP;
      END IF;

      -- upis u TREC_PON_VPRO
      FOR recponvpro IN (
        SELECT *
          FROM trec_pon_vpro
         WHERE ponso_id = ponso.id
           AND recvpro_id NOT IN (
               SELECT recvpro_id
                 FROM trec_pon_vpro
                WHERE ponso_id = ponso_id_l))
      LOOP
        recponvpro_id_l := pra_rec_zaj.sekvenca (NULL);
        recponvpro_rec_l := recponvpro;
        recponvpro_rec_l.id := recponvpro_id_l;
        recponvpro_rec_l.ponso_id := ponso_id_l;
        recponvpro_rec_l.unos_korisnik := NULL;
        recponvpro_rec_l.unos_dat := NULL;
        recponvpro_rec_l.izmjena_korisnik := NULL;
        recponvpro_rec_l.izmjena_dat := NULL;
        INSERT INTO trec_pon_vpro VALUES recponvpro_rec_l;

        -- upis u TREC_PON_VPRO
        FOR recponvproraz IN (
          SELECT * FROM trec_ponvpro_razdoblja WHERE recponvpro_id = recponvpro.id)
        LOOP
          recponvproraz_rec_l := recponvproraz;
          recponvproraz_rec_l.id := NULL;
          recponvproraz_rec_l.recponvpro_id := recponvpro_id_l;
          recponvproraz_rec_l.unos_korisnik := NULL;
          recponvproraz_rec_l.unos_dat := NULL;
          recponvproraz_rec_l.izmjena_korisnik := NULL;
          recponvproraz_rec_l.izmjena_dat := NULL;
          pomakni_datum (
            recponvproraz_rec_l.dat_zav_vpro_rez, dat_poc_old_p, dat_poc_p, dat_zav_l,
            recponvproraz_rec_l.dat_poc_vpro_rez < recponvproraz_rec_l.dat_zav_vpro_rez AND recponvproraz_rec_l.dat_zav_vpro_rez = dat_zav_old_p,
            dat_zav_pon_l);
          pomakni_datum (recponvproraz_rec_l.dat_poc_vpro_rez, dat_poc_old_p, dat_poc_p, dat_zav_l);
          pomakni_datum (
            recponvproraz_rec_l.dat_zav_vpro_bor, dat_poc_old_p, dat_poc_p, dat_zav_l,
            recponvproraz_rec_l.dat_poc_vpro_bor < recponvproraz_rec_l.dat_zav_vpro_bor AND recponvproraz_rec_l.dat_zav_vpro_bor = dat_zav_old_p,
            dat_zav_pon_l);
          pomakni_datum (recponvproraz_rec_l.dat_poc_vpro_bor, dat_poc_old_p, dat_poc_p, dat_zav_l);
          INSERT INTO trec_ponvpro_razdoblja VALUES recponvproraz_rec_l;
        END LOOP;
      END LOOP;

      << foo_so >> NULL;
    END LOOP; -- T_PON_SO

    << foo_akt >> NULL;

    -- kopiranje aktivnosti

    -- IRN 2918
    -- zmpojr_akt_id_new_l := zmpojr_akt_id_list_p (ponojr.zmpojr_id);
    IF brojac_akt_m > 0 THEN
      FOR i IN akt_tab_m.FIRST .. brojac_akt_m
      LOOP
        IF akt_tab_m (i).id_stari_akt = ponojr.zmpojr_id THEN
          zmpojr_akt_id_new_l := akt_tab_m (i).id_novi_akt;
        END IF;
      END LOOP;
    END IF;
    -- END IRN 2918

    IF zmpojr_akt_id_new_l IS NULL OR NOT kopiraj_aktivnosti_l THEN
      GOTO foo;
    END IF;

    dohvati_ponojr_id (ponojr_id_l, pon_id_new_p, zmpojr_akt_id_new_l, ponojr.izn_predujma_gas);

    brojac_dog_l := 0; -- IRN 2918 VS
    FOR pondog IN (
      SELECT *
        FROM t_pon_dog
       WHERE pon_id = pon_id_old_p
         AND ponojr_id = ponojr.id
         AND dat_poc <= datum_kraj_p)
    LOOP
      pondog_id_l := pra_rec_zaj.sekvenca (NULL);
      -- IRN 2918 VS
      -- dog_conversion (pondog.id) := pondog_id_l;
      brojac_dog_l := brojac_dog_l + 1;
      dog_tab_l (brojac_dog_l).id_novi_dog := pondog_id_l;
      dog_tab_l (brojac_dog_l).id_stari_dog := pondog.id;
      -- END IRN 2918 VS
      pondog_rec_l := pondog;
      pondog_rec_l.id := pondog_id_l;
      pondog_rec_l.pon_id := pon_id_new_p;
      pondog_rec_l.ponojr_id := ponojr_id_l;
      pondog_rec_l.unos_korisnik := NULL;
      pondog_rec_l.unos_dat := NULL;
      pondog_rec_l.izmjena_korisnik := NULL;
      pondog_rec_l.izmjena_dat := NULL;
      pomakni_datum (
        pondog_rec_l.sat_zav, dat_poc_old_p, dat_poc_p, dat_zav_l,
        pondog_rec_l.dat_poc < pondog_rec_l.dat_zav AND pondog_rec_l.dat_zav = dat_zav_old_p,
        dat_zav_pon_l);
      pomakni_datum (
        pondog_rec_l.dat_zav, dat_poc_old_p, dat_poc_p, dat_zav_l,
        pondog_rec_l.dat_poc < pondog_rec_l.dat_zav AND pondog_rec_l.dat_zav = dat_zav_old_p,
        dat_zav_pon_l);
      pomakni_datum (pondog_rec_l.dat_poc, dat_poc_old_p, dat_poc_p, dat_zav_l);
      pomakni_datum (pondog_rec_l.sat_poc, dat_poc_old_p, dat_poc_p, dat_zav_l);
      INSERT INTO t_pon_dog VALUES pondog_rec_l;
    END LOOP; -- T_PON_DOG

    FOR ponpros IN (
      SELECT *
        FROM t_pon_pros
       WHERE ponojr_id = ponojr.id
         AND dat_poc <= datum_kraj_p)
    LOOP
      ponpros_id_l := pra_rec_zaj.sekvenca (NULL);
      pondog_id_l := NULL;
      IF ponpros.pondog_id IS NOT NULL THEN
        -- IRN 2918 VS
        -- pondog_id_l := dog_conversion (ponpros.pondog_id);
        FOR i IN dog_tab_l.FIRST .. dog_tab_l.LAST LOOP
          IF dog_tab_l (i).id_stari_dog = ponpros.pondog_id THEN
            pondog_id_l := dog_tab_l (i).id_novi_dog;
          END IF;
        END LOOP;
        -- END IRN 2918 VS
      END IF;
      ponpros_rec_l := ponpros;
      ponpros_rec_l.id := ponpros_id_l;
      ponpros_rec_l.pondog_id := pondog_id_l;
      ponpros_rec_l.ponojr_id := ponojr_id_l;
      ponpros_rec_l.ozn_statusa := NULL;
      ponpros_rec_l.unos_korisnik := NULL;
      ponpros_rec_l.unos_dat := NULL;
      ponpros_rec_l.izmjena_korisnik := NULL;
      ponpros_rec_l.izmjena_dat := NULL;
      pomakni_datum (
        ponpros_rec_l.sat_zav, dat_poc_old_p, dat_poc_p, dat_zav_l,
        ponpros_rec_l.dat_poc < ponpros_rec_l.dat_zav AND ponpros_rec_l.dat_zav = dat_zav_old_p,
        dat_zav_pon_l);
      pomakni_datum (
        ponpros_rec_l.dat_zav, dat_poc_old_p, dat_poc_p, dat_zav_l,
        ponpros_rec_l.dat_poc < ponpros_rec_l.dat_zav AND ponpros_rec_l.dat_zav = dat_zav_old_p,
        dat_zav_pon_l);
      pomakni_datum (ponpros_rec_l.dat_poc, dat_poc_old_p, dat_poc_p, dat_zav_l);
      pomakni_datum (ponpros_rec_l.sat_poc, dat_poc_old_p, dat_poc_p, dat_zav_l);
      INSERT INTO t_pon_pros VALUES ponpros_rec_l;

      FOR ponopr IN (
        SELECT *
          FROM t_pon_opr
         WHERE ponpros_id = ponpros.id
           AND dat_poc <= datum_kraj_p)
      LOOP
        pondog_id_l := NULL;
        IF ponopr.pondog_id IS NOT NULL THEN
          -- IRN 2918 VS
          -- pondog_id_l := dog_conversion (ponopr.pondog_id);
          FOR i IN dog_tab_l .FIRST .. dog_tab_l .LAST LOOP
            IF dog_tab_l (i).id_stari_dog = ponopr.pondog_id THEN
              pondog_id_l := dog_tab_l (i).id_novi_dog;
            END IF;
          END LOOP;
          -- END IRN 2918 VS
        END IF;

        ponopr_rec_l := ponopr;
        ponopr_rec_l.id := NULL;
        ponopr_rec_l.pondog_id := pondog_id_l;
        ponopr_rec_l.ponojr_id := ponojr_id_l;
        ponopr_rec_l.ponpros_id := ponpros_id_l;
        ponopr_rec_l.ozn_statusa := NULL;
        ponopr_rec_l.unos_korisnik := NULL;
        ponopr_rec_l.unos_dat := NULL;
        ponopr_rec_l.izmjena_korisnik := NULL;
        ponopr_rec_l.izmjena_dat := NULL;
        pomakni_datum (
          ponopr_rec_l.sat_zav, dat_poc_old_p, dat_poc_p, dat_zav_l,
          ponopr_rec_l.dat_poc < ponopr_rec_l.dat_zav AND ponopr_rec_l.dat_zav = dat_zav_old_p,
          dat_zav_pon_l);
        pomakni_datum (
          ponopr_rec_l.dat_zav, dat_poc_old_p, dat_poc_p, dat_zav_l,
          ponopr_rec_l.dat_poc < ponopr_rec_l.dat_zav AND ponopr_rec_l.dat_zav = dat_zav_old_p,
          dat_zav_pon_l);
        pomakni_datum (ponopr_rec_l.dat_poc, dat_poc_old_p, dat_poc_p, dat_zav_l);
        pomakni_datum (ponopr_rec_l.sat_poc, dat_poc_old_p, dat_poc_p, dat_zav_l);
        INSERT INTO t_pon_opr VALUES ponopr_rec_l;
      END LOOP; -- T_PON_OPR PONPROS
    END LOOP;   -- T_PON_PROS

    FOR ponopr_c IN (
      SELECT *
        FROM t_pon_opr
       WHERE ponojr_id = ponojr.id
         AND ponpros_id IS NULL
         AND dat_poc <= datum_kraj_p)
    LOOP
      pondog_id_l := NULL;
      IF ponopr_c.pondog_id IS NOT NULL THEN
        -- IRN 2918 VS
        -- pondog_id_l := dog_conversion (ponopr.pondog_id);
        FOR i IN dog_tab_l .FIRST .. dog_tab_l .LAST LOOP
          IF dog_tab_l (i).id_stari_dog = ponopr_c.pondog_id THEN
            pondog_id_l := dog_tab_l (i).id_novi_dog;
          END IF;
        END LOOP;
        -- END IRN 2918 VS
      END IF;
      ponopr_rec_l := ponopr_c;
      ponopr_rec_l.id := NULL;
      ponopr_rec_l.pondog_id := pondog_id_l;
      ponopr_rec_l.ponojr_id := ponojr_id_l;
      ponopr_rec_l.ozn_statusa := NULL;
      ponopr_rec_l.unos_korisnik := NULL;
      ponopr_rec_l.unos_dat := NULL;
      ponopr_rec_l.izmjena_korisnik := NULL;
      ponopr_rec_l.izmjena_dat := NULL;
      pomakni_datum (
        ponopr_rec_l.sat_zav, dat_poc_old_p, dat_poc_p, dat_zav_p,
        ponopr_rec_l.dat_poc < ponopr_rec_l.dat_zav AND ponopr_rec_l.dat_zav = dat_zav_old_p,
        dat_zav_pon_l);
      pomakni_datum (
        ponopr_rec_l.dat_zav, dat_poc_old_p, dat_poc_p, dat_zav_p,
        ponopr_rec_l.dat_poc < ponopr_rec_l.dat_zav AND ponopr_rec_l.dat_zav = dat_zav_old_p,
        dat_zav_pon_l);
      pomakni_datum (ponopr_rec_l.dat_poc, dat_poc_old_p, dat_poc_p, dat_zav_p);
      pomakni_datum (ponopr_rec_l.sat_poc, dat_poc_old_p, dat_poc_p, dat_zav_p);
      INSERT INTO t_pon_opr VALUES ponopr_rec_l;
    END LOOP; -- T_PON_OPR

    << foo >> NULL;
  END LOOP; -- T_PON_OJR

  /* ako je potrebno unijeti aktivnosti */
  IF kopiraj_aktivnosti_l THEN
    FOR ponnap IN (
      SELECT * FROM t_pon_nap WHERE pon_id = pon_id_old_p)
    LOOP
      pondog_id_l := NULL;
      IF ponnap.pondog_id IS NOT NULL THEN
        -- IRN 2918 VS
        -- pondog_id_l := dog_conversion (ponnap.pondog_id);
        FOR i IN dog_tab_l .FIRST .. dog_tab_l .LAST LOOP
          IF dog_tab_l (i).id_stari_dog = ponnap.pondog_id THEN
            pondog_id_l := dog_tab_l (i).id_novi_dog;
          END IF;
        END LOOP;
        -- END IRN 2918 VS
      END IF;

      ponnap_rec_l := ponnap;
      ponnap_rec_l.id := NULL;
      ponnap_rec_l.pon_id := pon_id_new_p;
      ponnap_rec_l.pondog_id := pondog_id_l;
      ponnap_rec_l.unos_korisnik := NULL;
      ponnap_rec_l.unos_dat := NULL;
      ponnap_rec_l.izmjena_korisnik := NULL;
      ponnap_rec_l.izmjena_dat := NULL;
      INSERT INTO t_pon_nap VALUES ponnap_rec_l;

      << foo_nap >> NULL;
    END LOOP; -- T_PON_NAP

    FOR pondogslu IN (
      SELECT *
        FROM t_pon_dogslu
       WHERE pondog_id IN (
             SELECT id
               FROM t_pon_dog
              WHERE pon_id = pon_id_old_p
                AND dat_poc <= datum_kraj_p))
    LOOP
      pondog_id_l := NULL;
      IF pondogslu.pondog_id IS NOT NULL THEN
        -- IRN 2918 VS
        -- pondog_id_l := dog_conversion (pondogslu.pondog_id);
        FOR i IN dog_tab_l .FIRST .. dog_tab_l .LAST LOOP
          IF dog_tab_l (i).id_stari_dog = pondogslu.pondog_id THEN
            pondog_id_l := dog_tab_l (i).id_novi_dog;
          END IF;
        END LOOP;
        -- END IRN 2918 VS
      END IF;

      pondogslu_rec_l := pondogslu;
      pondogslu_rec_l.id := NULL;
      pondogslu_rec_l.pondog_id := pondog_id_l;
      pondogslu_rec_l.unos_korisnik := NULL;
      pondogslu_rec_l.unos_dat := NULL;
      pondogslu_rec_l.izmjena_korisnik := NULL;
      pondogslu_rec_l.izmjena_dat := NULL;
      INSERT INTO t_pon_dogslu VALUES pondogslu_rec_l;

      << foo_dogslu >> NULL;
    END LOOP; -- T_PON_DOGSLU

  END IF;

  COMMIT;
  fm_rec2030.brisi_tablicu_so;
  fm_rec2030.brisi_tablicu_akt;
END;
PROCEDURE PUNI_P_PONSOREZ
 (PONSO_ID_P IN t_pon_so.id%TYPE
 )
 IS
--
  datum_l DATE;
BEGIN
  DELETE FROM p_ponsorez;

  FOR ponvsj_c IN (
    SELECT
      id, vsj_id, vsjc_id, dat_poc, dat_zav
    FROM
      t_pon_vsj
    WHERE
      ponso_id = ponso_id_p)
  LOOP
    datum_l := ponvsj_c.dat_poc;
    WHILE datum_l < ponvsj_c.dat_zav LOOP
      INSERT INTO p_ponsorez (
          ponso_id,
          datum,
          vsj_id,
          vsjc_id,
          rasp_kol_sj,
          ponvsj_id)
        VALUES (
          ponso_id_p,
          datum_l,
          ponvsj_c.vsj_id,
          ponvsj_c.vsjc_id,
          pra_t_ponude.raspolozivi_kapacitet (ponvsj_c.id, datum_l, 0),
          ponvsj_c.id);
      datum_l := datum_l + 1;
    END LOOP;
  END LOOP;

END;
PROCEDURE AZURIRAJ_P_PONSOREZ
 (PONSO_ID_P IN t_pon_so.id%TYPE
 ,DAT_POC_P IN t_rezervacije.dat_dolaska%TYPE
 ,DAT_ZAV_P IN t_rezervacije.dat_odlaska%TYPE
 ,VSJ_ID_P IN t_rez_vsj.vsj_id%TYPE
 ,VSJC_ID_P IN t_rez_vsj.vsjc_id%TYPE
 ,KOL_SJ_P IN t_rez_vsj.kol_sj%TYPE
 ,BR_OSOBA_P IN t_rez_vsj.br_osoba%TYPE
 ,UK_REZ_P IN NUMBER
 ,PONVSJ_ID_P IN t_pon_vsj.id%TYPE
 )
 IS
--
  CURSOR vsj_c IS
    SELECT br_postelja * kol_sj_p
      FROM s_vsj
     WHERE id = vsj_id_p;
  br_osoba_l NUMBER(4);
BEGIN
  IF br_osoba_p IS NULL THEN
    OPEN vsj_c;
    FETCH vsj_c INTO br_osoba_l;
    CLOSE vsj_c;
  END IF;

  UPDATE p_ponsorez
     SET kol_sj = kol_sj_p,
         br_osoba = NVL (br_osoba_p, br_osoba_l),
         uk_ozn_rez = uk_rez_p,
         ponvsj_id = ponvsj_id_p
   WHERE ponso_id = ponso_id_p
     AND datum BETWEEN dat_poc_p AND dat_zav_p
     AND vsj_id = vsj_id_p
     AND vsjc_id = vsjc_id_p;

END;
FUNCTION USL_UPISANA
 (METCVOR_SIFRA_P IN smet_cvorovi.sifra%TYPE
 ,REZ_ID_P IN t_rezervacije.id%TYPE
 ,USL_ID_P IN t_rez_usl.usl_id%TYPE
 ,DAT_POC_P IN VARCHAR2
 ,DAT_ZAV_P IN VARCHAR2
 ,RECARA_ID_P IN t_rez_usl.recara_id%TYPE
 ,USL_ID1_P IN t_rez_usl.usl_id1%TYPE
 )
 RETURN NUMBER
 IS
--
  metcvor_sifra_l VARCHAR2(21);
  naredba_l       VARCHAR2(1000);
  br_redaka_l     NUMBER;
BEGIN
  IF metcvor_sifra_p IS NOT NULL THEN
    metcvor_sifra_l := '@' || metcvor_sifra_p;
  END IF;

  naredba_l := 
    'SELECT COUNT (1) ' ||
    '  FROM t_rez_usl<CVOR> rezusl, ' ||
    '       t_rezervacije<CVOR> rez ' ||
    ' WHERE rez.id = ' || rez_id_p ||
    '   AND rezusl.rez_id = rez.id ' ||
    '   AND rezusl.usl_id = ' || usl_id_p ||
    '   AND NVL (rezusl.dat_poc, rez.dat_dolaska) >= TO_DATE (''' || dat_poc_p || ''', ''DD.MM.RRRR'')' ||
    '   AND NVL (rezusl.dat_zav, rez.dat_odlaska) <= TO_DATE (''' || dat_zav_p || ''', ''DD.MM.RRRR'')' ||
    '   AND NVL (rezusl.recara_id, 0) = ' || NVL (recara_id_p, 0) ||
    '   AND NVL (rezusl.usl_id1, 0) = ' || NVL (usl_id1_p, 0);

  EXECUTE IMMEDIATE REPLACE (naredba_l, '<CVOR>', metcvor_sifra_l) INTO br_redaka_l;

  IF br_redaka_l > 0 THEN
    RETURN (-1);
  END IF;
  RETURN (0);
END;
PROCEDURE BRISI_TABLICU_SO
 IS
-- IRN 2918
BEGIN
  brojac_so_m := 0;
END;
PROCEDURE UPISI_U_TABLICU_SO
 (SO_REC_STARI_P NUMBER
 ,SO_REC_NOVI_P NUMBER
 )
 IS
-- IRN 2918
BEGIN
  brojac_so_m := brojac_so_m + 1;
  so_tab_m(brojac_so_m).id_novi_so := so_rec_novi_p;
  so_tab_m(brojac_so_m).id_stari_so := so_rec_stari_p;
END;
PROCEDURE BRISI_TABLICU_AKT
 IS
-- IRN 2918
BEGIN
  brojac_akt_m := 0;
END;
PROCEDURE UPISI_U_TABLICU_AKT
 (AKT_REC_STARI_P NUMBER
 ,AKT_REC_NOVI_P NUMBER
 )
 IS
-- IRN 2918
BEGIN
  brojac_akt_m := brojac_akt_m + 1;
  akt_tab_m(brojac_akt_m).id_stari_akt := akt_rec_stari_p;
  akt_tab_m(brojac_akt_m).id_novi_akt := akt_rec_novi_p;
END;

END FM_REC2030;
/
SHOW ERROR

