-- C:\mish_cvs\misH_skripte\bm_gas3140.pkb
--
-- Generated for Oracle 10g on Mon Jun 09  10:28:30 2025 by Server Generator 6.5.96.5.6
 

PROMPT Creating Package Body 'BM_GAS3140'
CREATE OR REPLACE PACKAGE BODY BM_GAS3140 IS
obrada_u_toku_m BOOLEAN := FALSE;
popis_gresaka_m VARCHAR2 (2000);

PROCEDURE REPLICIRAJ_PROMET
 (METCVOR_SIFRA_P IN SMET_CVOROVI.SIFRA%TYPE
 ,MAX_DATUM_P IN DATE
 ,METCVOR_RBR_P IN SMET_CVOROVI.RBR%TYPE
 );
PROCEDURE REPLICIRAJ_TROSKOVE
 (METCVOR_SIFRA_P IN SMET_CVOROVI.SIFRA%TYPE
 ,MAX_DATUM_P IN DATE
 ,OJ_ID_P IN NUMBER
 );
PROCEDURE REPLICIRAJ_ZALIHE
 (METCVOR_SIFRA_P IN SMET_CVOROVI.SIFRA%TYPE
 ,MAX_DATUM_P IN DATE
 ,OJ_ID_P IN NUMBER
 );
PROCEDURE REPLICIRAJ_PROMET_PANSIONA
 (METCVOR_SIFRA_P IN SMET_CVOROVI.SIFRA%TYPE
 ,MAX_DATUM_P IN DATE
 ,OJ_ID_P IN NUMBER
 ,METCVOR_RBR_P IN SMET_CVOROVI.RBR%TYPE
 );
/* REPLICIRAJ_OTPREMNICE */
PROCEDURE REPLICIRAJ_OTPREMNICE
 (METCVOR_SIFRA_P IN SMET_CVOROVI.SIFRA%TYPE
 ,MAX_DATUM_P IN DATE
 ,OJ_ID_P IN NUMBER
 ,METCVOR_RBR_P IN SMET_CVOROVI.RBR%TYPE
 );
/* REPLICIRAJ_ZAMJENU */
PROCEDURE REPLICIRAJ_ZAMJENU
 (METCVOR_SIFRA_P IN SMET_CVOROVI.SIFRA%TYPE
 ,MAX_DATUM_P IN DATE
 ,OJ_ID_P IN NUMBER
 ,METCVOR_RBR_P IN SMET_CVOROVI.RBR%TYPE
 );
PROCEDURE REPLICIRAJ_MINIBAR
 (DATUM_ZA_BRISANJE_P IN DATE := NULL
 );
PROCEDURE REPLICIRAJ_TRNKASE
 (METCVOR_SIFRA_P IN SMET_CVOROVI.SIFRA%TYPE
 ,MAX_DATUM_P IN DATE
 ,METCVOR_RBR_P IN SMET_CVOROVI.RBR%TYPE
 );
PROCEDURE REPLICIRAJ_OTPIS
 (METCVOR_SIFRA_P IN SMET_CVOROVI.SIFRA%TYPE
 ,MAX_DATUM_P IN DATE
 ,OJ_ID_P IN NUMBER
 ,METCVOR_RBR_P IN SMET_CVOROVI.RBR%TYPE
 );
PROCEDURE REPLICIRAJ_INV_INVUI
 (METCVOR_SIFRA_P IN SMET_CVOROVI.SIFRA%TYPE
 ,MAX_DATUM_P IN DATE
 ,OJ_ID_P IN NUMBER
 );
PROCEDURE REPLICIRAJ_INV_TINV
 (METCVOR_SIFRA_P IN SMET_CVOROVI.SIFRA%TYPE
 ,MAX_DATUM_P IN DATE
 ,OJ_ID_P IN NUMBER
 );
PROCEDURE REPLICIRAJ_INV_TINVDOK
 (METCVOR_SIFRA_P IN SMET_CVOROVI.SIFRA%TYPE
 ,MAX_DATUM_P IN DATE
 ,OJ_ID_P IN NUMBER
 ,METCVOR_RBR_P IN SMET_CVOROVI.RBR%TYPE
 );


PROCEDURE REPLICIRAJ
 (POPIS_GRESAKA_P OUT VARCHAR2
 ,DATUM_ZA_BRISANJE_P IN DATE := NULL
 ,METCVOR_SIFRA_P IN VARCHAR2 := NULL
 )
 IS
BEGIN
   /* Samo centar moe pokrenuti prikupljanje */
   IF pra_zmp_zaj.centar = 0 THEN
      RETURN;
   END IF;
   
   /* popis_gresaka_m daje informaciju Forms modulu o greci u paketu */
   popis_gresaka_m := NULL;

   /*
   "Centralni_gastro" nije dobro ime funkcije.
   Rije je o centru na kojem se vodi samo GAS tehnologija, a GAS je po objektima.
   */
   IF bm_gas4032.centralni_gastro <> 1 THEN
      repliciraj_minibar (datum_za_brisanje_p);
      popis_gresaka_p := popis_gresaka_m; -- komunikacija prema Forms modulu
      RETURN;
   END IF;

   /* Zbog BIR triggera za punjenje zaglavlja i stavaka rauna na GAS centru */
   obrada_u_toku_m := TRUE;

   FOR metins IN (
      SELECT ins.metcvor_sifra, ojr.id id, cvor.rbr
        FROM smet_instalacije ins,
             smet_cvorovi     cvor,
             mzmp_ojr    ojr 
       WHERE ins.metapl_sifra  =  'GAS'
         AND ins.metcvor_sifra <> pra_zmp_zaj.tekuci_cvor
         AND ins.metcvor_sifra =  cvor.sifra
         AND ins.metcvor_sifra = ojr.metcvor_sifra_gas
         AND ojr.dat_ponisten IS NULL
         AND cvor.ozn_u_mrezi  =  -1
       ORDER BY ins.metcvor_sifra)
   LOOP
      IF replikacija.cvor_je_podcentar (metins.metcvor_sifra) <> 0 THEN
         GOTO kraj_petlje; -- ako je podcentar
      END IF;

      IF metcvor_sifra_p IS NOT NULL THEN
         IF UPPER (metcvor_sifra_p) <> UPPER (metins.metcvor_sifra) THEN
            GOTO kraj_petlje; -- radi samo za izabrani vor
         END IF;
      END IF;

      DECLARE
         oj_id_l sgas_vlasnik.oj_id%TYPE;
         max_datum_l DATE;
      BEGIN
         /* Ako veza ne radi, puknut e odmah na sljedeoj naredbi */
         EXECUTE IMMEDIATE
            'SELECT oj_id FROM sgas_vlasnik@' || metins.metcvor_sifra
            INTO oj_id_l;

         IF datum_za_brisanje_p IS NULL THEN
            /* Prikupljaju se podaci za datum vei od postojeeg */

            /* PROMET SA KASA */

            SELECT NVL (MAX (datum), '01.01.2000')
              INTO max_datum_l
              FROM t_rnkase
             WHERE kase_id IN
                   (SELECT id 
                      FROM mgmp_kase  
                     WHERE zmpojr_id IN (SELECT id FROM mzmp_ojr WHERE metcvor_sifra_gas = metins.metcvor_sifra OR metcvor_sifra = metins.metcvor_sifra)
                   );
            
             /* Prikuplja se promet za datum > max_datum_l */
            -- izmjena 16.12.2024 IRN - dodan rbr cvora u UK kod prepisa na centar
            repliciraj_promet (metins.metcvor_sifra, max_datum_l, metins.rbr);
            

            /* TROKOVI */

            SELECT NVL (MAX (datum), '01.01.2000')
              INTO max_datum_l
              FROM i_dnev_ui_nac
             WHERE mt_id IN (SELECT id FROM m_oj
                              START WITH id = metins.id
                            CONNECT BY PRIOR id = oj_id);

            /* Prikupljaju se trokovi za datum > max_datum_l */
            repliciraj_troskove (metins.metcvor_sifra, max_datum_l, metins.id); 
            

            /* ZALIHE */
            SELECT NVL (MAX (datum), '01.01.2000')
              INTO max_datum_l
              FROM i_dnev_ui
             WHERE mt_id IN (SELECT id FROM m_oj
                              START WITH id = metins.id
                            CONNECT BY PRIOR id = oj_id);
                                                                  
             DELETE i_zaliha
              WHERE mt_id IN (SELECT id FROM m_oj
                              START WITH id = metins.id
                            CONNECT BY PRIOR id = oj_id);                                                  
            /* Prikupljaju se zalihe za datum > max_datum_l */
            repliciraj_zalihe (metins.metcvor_sifra, max_datum_l, metins.id); 

         
            /* PROMET PANSIONA */

            SELECT NVL (MAX (datum), '01.01.2000')
              INTO max_datum_l
              FROM t_izlaz
             WHERE mt_id IN (SELECT id FROM m_oj
                              START WITH id = metins.id
                            CONNECT BY PRIOR id = oj_id);

            /* Prikuplja se promet za datum > max_datum_l */
            repliciraj_promet_pansiona (metins.metcvor_sifra, max_datum_l, metins.id, metins.rbr);


            /* OTPREMNICE */

            SELECT NVL (MAX (datum), '01.01.2000')
              INTO max_datum_l
              FROM tgas_izlazdok
             WHERE mt_id IN (SELECT id FROM m_oj
                              START WITH id = metins.id
                            CONNECT BY PRIOR id = oj_id);

            /* Prikuplja se promet za datum > max_datum_l */
            repliciraj_otpremnice (metins.metcvor_sifra, max_datum_l, metins.id, metins.rbr);


            /* ZAMJENA */

            SELECT NVL (MAX (datum), '01.01.2000')
              INTO max_datum_l
              FROM t_zamjena
             WHERE mt_id IN (SELECT id FROM m_oj
                              START WITH id = metins.id
                            CONNECT BY PRIOR id = oj_id);

            /* Prikuplja se promet za datum > max_datum_l */
            repliciraj_zamjenu (metins.metcvor_sifra, max_datum_l, metins.id, metins.rbr);
            
             /* OTPIS */   -- IRN 03058

            SELECT NVL (MAX (datum), '01.01.2000')
              INTO max_datum_l
              FROM t_otpis
             WHERE mt_id IN (SELECT id FROM m_oj
                              START WITH id = metins.id
                            CONNECT BY PRIOR id = oj_id);

            /* Prikuplja se promet za datum > max_datum_l */
            repliciraj_otpis (metins.metcvor_sifra, max_datum_l, metins.id, metins.rbr);   
            
            
             /* INVENTURE */   -- IRN 03101

            SELECT NVL (MAX (datum), '01.01.2000')
              INTO max_datum_l
              FROM i_inv_ui
             WHERE mt_id IN (SELECT id FROM m_oj
                              START WITH id = metins.id
                            CONNECT BY PRIOR id = oj_id);

            /* Prikuplja se promet za datum > max_datum_l */
            repliciraj_inv_invui (metins.metcvor_sifra, max_datum_l, metins.id);   
            
             SELECT NVL (MAX (datum), '01.01.2000')
              INTO max_datum_l
              FROM t_inv_razlike
             WHERE mt_id IN (SELECT id FROM m_oj
                              START WITH id = metins.id
                            CONNECT BY PRIOR id = oj_id);

            /* Prikuplja se promet za datum > max_datum_l */
            repliciraj_inv_tinv (metins.metcvor_sifra, max_datum_l, metins.id);    
            
            /* IRN 03517 */
             SELECT NVL (MAX (datum), '01.01.2000')
              INTO max_datum_l
              FROM t_inventura
             WHERE mt_id IN (SELECT id FROM m_oj
                              START WITH id = metins.id
                            CONNECT BY PRIOR id = oj_id);

            /* Prikuplja se promet za datum > max_datum_l */
            repliciraj_inv_tinvdok (metins.metcvor_sifra, max_datum_l, metins.id, metins.rbr);  
            
         ELSE
            /* Briu se i ponovno prikupljaju podaci od (ukljuujui) datuma za brisanje */

            /* PROMET SA KASA */

            DELETE t_rnkase_pro 
             WHERE rn_id IN
                   (SELECT id
                      FROM t_rnkase
                     WHERE datum >= datum_za_brisanje_p
                       AND kase_id IN
                           (SELECT id 
                              FROM mgmp_kase  
                             WHERE zmpojr_id IN (SELECT ID FROM mzmp_ojr WHERE metcvor_sifra_gas = metins.metcvor_sifra OR metcvor_sifra = metins.metcvor_sifra)
                           )
                   );
                                
             DELETE t_rnkase   
              WHERE datum >= datum_za_brisanje_p
                AND kase_id IN
                    (SELECT id  
                       FROM mgmp_kase 
                      WHERE zmpojr_id IN (SELECT id FROM mzmp_ojr WHERE metcvor_sifra_gas = metins.metcvor_sifra OR metcvor_sifra = metins.metcvor_sifra)
                    );

            /* Prikuplja se promet za datum > datum_za_brisanje_p - 1 (tj. ukljuuje se taj datum) */
            repliciraj_promet (metins.metcvor_sifra, datum_za_brisanje_p - 1, metins.rbr);


            /* TROKOVI */

            DELETE i_dnev_ui_nac
             WHERE datum >= datum_za_brisanje_p
               AND mt_id IN (SELECT id FROM m_oj
                              START WITH id = metins.id
                            CONNECT BY PRIOR id = oj_id);

            DELETE i_dnev_ui_nac_opera
             WHERE datum >= datum_za_brisanje_p
               AND mt_id IN (SELECT id FROM m_oj
                              START WITH id = metins.id
                            CONNECT BY PRIOR id = oj_id);

            /* Prikupljaju se trokovi za datum > datum_za_brisanje_p - 1 (tj. ukljuuje se taj datum) */
            repliciraj_troskove (metins.metcvor_sifra, datum_za_brisanje_p - 1, metins.id);


            /* ZALIHE */

            DELETE i_dnev_ui
             WHERE datum >= datum_za_brisanje_p
               AND mt_id IN (SELECT id FROM m_oj
                              START WITH id = metins.id
                            CONNECT BY PRIOR id = oj_id);    
                            
            DELETE i_dnev_ui_det
             WHERE datum >= datum_za_brisanje_p
               AND mt_id IN (SELECT id FROM m_oj
                              START WITH id = metins.id
                            CONNECT BY PRIOR id = oj_id);    
                            
            DELETE i_zaliha
             WHERE mt_id IN (SELECT id FROM m_oj
                              START WITH id = metins.id
                            CONNECT BY PRIOR id = oj_id);                
            
            /* Prikupljaju se zalihe za datum > datum_za_brisanje_p - 1 (tj. ukljuuje se taj datum) */
            repliciraj_zalihe (metins.metcvor_sifra, datum_za_brisanje_p - 1, metins.id);


            /* PROMET PANSIONA */

            DELETE t_izlaz_art
             WHERE izl_id IN
                   (SELECT id
                      FROM t_izlaz
                     WHERE datum >= datum_za_brisanje_p
                       AND mt_id IN (SELECT id FROM m_oj
                                      START WITH id = metins.id
                                    CONNECT BY PRIOR id = oj_id)
                   );
                                
             DELETE t_izlaz
              WHERE datum >= datum_za_brisanje_p
                AND mt_id IN (SELECT id FROM m_oj
                               START WITH id = metins.id
                             CONNECT BY PRIOR id = oj_id);

            /* Prikuplja se promet za datum > max_datum_l */
            repliciraj_promet_pansiona (metins.metcvor_sifra, datum_za_brisanje_p - 1, metins.id, metins.rbr);


            /* OTPREMNICE */

            DELETE tgas_izlazdok_art
             WHERE gasizldok_id IN
                   (SELECT id
                      FROM tgas_izlazdok
                     WHERE datum >= datum_za_brisanje_p
                       AND mt_id IN (SELECT id FROM m_oj
                                      START WITH id = metins.id
                                    CONNECT BY PRIOR id = oj_id)
                   );
                                
            DELETE tgas_izlazdok_amb
             WHERE gasizldok_id IN
                   (SELECT id
                      FROM tgas_izlazdok
                     WHERE datum >= datum_za_brisanje_p
                       AND mt_id IN (SELECT id FROM m_oj
                                      START WITH id = metins.id
                                    CONNECT BY PRIOR id = oj_id)
                   );

             DELETE tgas_izlazdok
              WHERE datum >= datum_za_brisanje_p
                AND mt_id IN (SELECT id FROM m_oj
                               START WITH id = metins.id
                             CONNECT BY PRIOR id = oj_id);

            /* Prikuplja se promet za datum > max_datum_l */
            repliciraj_otpremnice (metins.metcvor_sifra, datum_za_brisanje_p - 1, metins.id, metins.rbr);


            /* ZAMJENA */

            DELETE t_zamjena_art
             WHERE zam_id IN
                   (SELECT id
                      FROM t_zamjena
                     WHERE datum >= datum_za_brisanje_p
                       AND mt_id IN (SELECT id FROM m_oj
                                      START WITH id = metins.id
                                    CONNECT BY PRIOR id = oj_id)
                   );
                                
             DELETE t_zamjena
              WHERE datum >= datum_za_brisanje_p
                AND mt_id IN (SELECT id FROM m_oj
                               START WITH id = metins.id
                             CONNECT BY PRIOR id = oj_id);

            /* Prikuplja se promet za datum > max_datum_l */
            repliciraj_zamjenu (metins.metcvor_sifra, datum_za_brisanje_p - 1, metins.id, metins.rbr);      
            
            /* OTPIS */ -- IRN 03058

            DELETE t_otpis_art
             WHERE otp_id IN
                   (SELECT id
                      FROM t_otpis
                     WHERE datum >= datum_za_brisanje_p
                       AND mt_id IN (SELECT id FROM m_oj
                                      START WITH id = metins.id
                                    CONNECT BY PRIOR id = oj_id)
                   );

             DELETE t_otpis
              WHERE datum >= datum_za_brisanje_p
                AND mt_id IN (SELECT id FROM m_oj
                               START WITH id = metins.id
                             CONNECT BY PRIOR id = oj_id);
             /* Prikuplja se promet za datum > max_datum_l */
             repliciraj_otpis (metins.metcvor_sifra, datum_za_brisanje_p - 1, metins.id, metins.rbr);    
                     
             
             /* inventure */ -- IRN 03101

            DELETE i_inv_ui
             WHERE datum >= datum_za_brisanje_p
               AND mt_id IN (SELECT id FROM m_oj
                              START WITH id = metins.id
                            CONNECT BY PRIOR id = oj_id);    
                            
            /* Prikuplja se inventure za datum > max_datum_l */                
            repliciraj_inv_invui (metins.metcvor_sifra, datum_za_brisanje_p - 1, metins.id);    
                       
            DELETE t_inv_razlike
             WHERE datum >= datum_za_brisanje_p
               AND mt_id IN (SELECT id FROM m_oj
                              START WITH id = metins.id
                            CONNECT BY PRIOR id = oj_id);      
             
             /* Prikuplja se inventure za datum > max_datum_l */
             repliciraj_inv_tinv (metins.metcvor_sifra, datum_za_brisanje_p - 1, metins.id);    
             
              DELETE t_inventura_art
             WHERE inv_id IN
                   (SELECT id
                      FROM t_inventura
                     WHERE datum >= datum_za_brisanje_p
                       AND mt_id IN (SELECT id FROM m_oj
                                      START WITH id = metins.id
                                    CONNECT BY PRIOR id = oj_id)
                   );
             
             /* IRN 03517 */
             DELETE t_inventura
              WHERE datum >= datum_za_brisanje_p
                AND mt_id IN (SELECT id FROM m_oj
                               START WITH id = metins.id
                             CONNECT BY PRIOR id = oj_id);
             /* Prikuplja se promet za datum > max_datum_l */
             repliciraj_inv_tinvdok (metins.metcvor_sifra, datum_za_brisanje_p - 1, metins.id, metins.rbr);
                         
         END IF;   

         COMMIT; -- za tekui vor
      EXCEPTION
         WHEN OTHERS THEN
            ROLLBACK; -- za tekui vor
            popis_gresaka_m := popis_gresaka_m ||
               ' ' || metins.metcvor_sifra || ': ' || SUBSTR (SQLERRM, 1, 200);
      END;

      <<kraj_petlje>> NULL;
   END LOOP; -- za sve vorove      

   obrada_u_toku_m := FALSE;
   popis_gresaka_p := popis_gresaka_m; -- komunikacija prema Forms modulu
END;
FUNCTION OBRADA_U_TOKU
 RETURN BOOLEAN
 IS
BEGIN
   RETURN obrada_u_toku_M;
END;
PROCEDURE REPLICIRAJ_PROMET
 (METCVOR_SIFRA_P IN SMET_CVOROVI.SIFRA%TYPE
 ,MAX_DATUM_P IN DATE
 ,METCVOR_RBR_P IN SMET_CVOROVI.RBR%TYPE
 )
 IS
   naredba_l VARCHAR2 (32000);
BEGIN
   /*
   ID se formira kao: metcvor_rbr_p || rn.id, tj. "proireni UK" + PK.
   Redni broj vora koji je jedinstven za korisnika.
   */
  
   naredba_l :=
    'INSERT INTO t_rnkase
            (id, godina, kase_id, rbr, datum, kon_id, nac_id, vpla_id, popust, opis,
             unos_korisnik, unos_dat, izmjena_korisnik, izmjena_dat, vrijeme,
             oj_id, sj_id, age_id, br_gostiju, vpdog_id, pkaadr_ozn, ozn_valjanosti,
             rn_id, jir, zastitni_kod, paragon, paragon_set, paragon_serija,
             br_loy_kartice, datum_izdavanja, br_kartice, br_stola, vpla2_id, izn_placanja, izn_placanja2,
             priznanje, gpor_id, priznanje_trosak, vpla_napojnice_id, izn_napojnice, datum_napojnice, ozn_storna)
      SELECT :metcvor_rbr_p || rn.id, godina, kase_id, rbr, datum, kon_id, nac_id, rn.vpla_id, popust, opis,
             rn.unos_korisnik, rn.unos_dat, rn.izmjena_korisnik, rn.izmjena_dat, vrijeme,
             rn.oj_id, sj_id, age_id, br_gostiju, vpdog_id, pkaadr_ozn, ozn_valjanosti,
             DECODE (rn_id, NULL, NULL, :metcvor_rbr_p || rn.rn_id),
             jir, zastitni_kod, paragon, paragon_set, paragon_serija,
             br_loy_kartice, datum_izdavanja, br_kartice, br_stola, vpla2_id, izn_placanja, izn_placanja2,
             priznanje, rn.gpor_id, priznanje_trosak,vpla_napojnice_id, izn_napojnice, datum_napojnice, ozn_storna
        FROM t_rnkase@'  || metcvor_sifra_p || ' rn,
             mgmp_kase@' || metcvor_sifra_p || ' kase
       WHERE rn.kase_id = kase.id
         AND rn.datum > :max_datum_p
         AND rn.datum < TRUNC(SYSDATE)
       ORDER BY rn.id
    ';

   EXECUTE IMMEDIATE naredba_l USING  metcvor_rbr_p, metcvor_rbr_p, max_datum_p;

   naredba_l :=
    'INSERT INTO t_rnkase_pro
            (rn_id, rbr_stavke, pro_id, sifgr_id, gpor_id, gknji_id, gtehpro_id, mt_id,
             kolicina, cijena, pdv, ppot, zad_nab_cijena, pros_nab_cijena,
             unos_korisnik, unos_dat, izmjena_korisnik, izmjena_dat,
             vpispz_id, popust, matkalk_id, iznos_popust, iznos_pdv, iznos_ppot, iznos, iznos_pnaknade, iznos_popust2)
      SELECT :metcvor_rbr_p || rnpro.rn_id, rbr_stavke, pro_id, sifgr_id, rnpro.gpor_id , gknji_id, gtehpro_id, mt_id,
             kolicina, cijena, pdv, ppot, zad_nab_cijena, pros_nab_cijena,
             rnpro.unos_korisnik, rnpro.unos_dat, rnpro.izmjena_korisnik, rnpro.izmjena_dat,
             vpispz_id, rnpro.popust, matkalk_id, iznos_popust, iznos_pdv, iznos_ppot, iznos, iznos_pnaknade, iznos_popust2
        FROM t_rnkase@'     || metcvor_sifra_p || ' rn,
             t_rnkase_pro@' || metcvor_sifra_p || ' rnpro,
             mgmp_kase@'    || metcvor_sifra_p || ' kase
       WHERE rn.kase_id = kase.id
         AND rn.id = rnpro.rn_id
         AND rn.datum > :max_datum_p
         AND rn.datum < TRUNC(SYSDATE)
    ';

   EXECUTE IMMEDIATE naredba_l USING metcvor_rbr_p, max_datum_p;
END;
PROCEDURE REPLICIRAJ_TROSKOVE
 (METCVOR_SIFRA_P IN SMET_CVOROVI.SIFRA%TYPE
 ,MAX_DATUM_P IN DATE
 ,OJ_ID_P IN NUMBER
 )
 IS
   naredba_l VARCHAR2 (32000);
BEGIN
   naredba_l :=
   'INSERT INTO i_dnev_ui_nac
             (mt_id, nac_id, nam_id, datum, gknji_id, kol_izlaz, kol_storno_izlaz_sup, kol_izlaz_sup, pros_nab_cijena, zad_nab_cijena)
       SELECT mt_id, nac_id, nam_id, datum, gknji_id, kol_izlaz, kol_storno_izlaz_sup, kol_izlaz_sup, pros_nab_cijena, zad_nab_cijena
         FROM i_dnev_ui_nac@' || metcvor_sifra_p || '
        WHERE datum > :max_datum_p
          AND datum < TRUNC(SYSDATE)
          AND mt_id IN
              (SELECT id
                 FROM m_oj@' || metcvor_sifra_p || '
                START WITH id = :oj_id_p
              CONNECT BY PRIOR id = oj_id
              )
   ';

   EXECUTE IMMEDIATE naredba_l USING max_datum_p, oj_id_p;

   naredba_l :=
   'INSERT INTO i_dnev_ui_nac_opera
             (mt_id, opera_rc_id, nac_id, nam_id, datum, gknji_id, kol_izlaz, kol_storno_izlaz_sup, kol_izlaz_sup, pros_nab_cijena, zad_nab_cijena)
       SELECT mt_id, opera_rc_id, nac_id, nam_id, datum, gknji_id, kol_izlaz, kol_storno_izlaz_sup, kol_izlaz_sup, pros_nab_cijena, zad_nab_cijena
         FROM i_dnev_ui_nac_opera@' || metcvor_sifra_p || '
        WHERE datum > :max_datum_p
          AND datum < TRUNC(SYSDATE)
          AND mt_id IN
              (SELECT id
                 FROM m_oj@' || metcvor_sifra_p || '
                START WITH id = :oj_id_p
              CONNECT BY PRIOR id = oj_id
              )
   ';

   EXECUTE IMMEDIATE naredba_l USING max_datum_p, oj_id_p;
END;
PROCEDURE REPLICIRAJ_ZALIHE
 (METCVOR_SIFRA_P IN SMET_CVOROVI.SIFRA%TYPE
 ,MAX_DATUM_P IN DATE
 ,OJ_ID_P IN NUMBER
 )
 IS
   naredba_l VARCHAR2 (32000);
BEGIN
   naredba_l :=
   'INSERT INTO i_dnev_ui
             (mt_id, nam_id, datum,
              kol_ulaz, kol_izlaz, kol_int_ulaz, kol_int_izlaz, kol_storno_izlaz_sup, kol_izlaz_sup, kol_dnev_otpis, kol_inv_razlika, zaliha,
              izn_ulaz, izn_int_ulaz, izn_int_izlaz, pros_nab_cijena, zad_nab_cijena)
       SELECT mt_id, nam_id, datum,
              kol_ulaz, kol_izlaz, kol_int_ulaz, kol_int_izlaz, kol_storno_izlaz_sup, kol_izlaz_sup, kol_dnev_otpis, kol_inv_razlika, zaliha,
              izn_ulaz, izn_int_ulaz, izn_int_izlaz, pros_nab_cijena, zad_nab_cijena
         FROM i_dnev_ui@' || metcvor_sifra_p || '
        WHERE datum > :max_datum_p
          AND datum < TRUNC(SYSDATE)
          AND mt_id IN
              (SELECT id
                 FROM m_oj@' || metcvor_sifra_p || '
                START WITH id = :oj_id_p
              CONNECT BY PRIOR id = oj_id
              )';

   EXECUTE IMMEDIATE naredba_l USING max_datum_p, oj_id_p;   
   
   naredba_l :=
   'INSERT INTO i_dnev_ui_det
             ( mt_id, nam_id, datum, sir_id, pro_id, nam_id_supstitut,pro_id_supstitut,
				       kol_ulaz, kol_izlaz, kol_int_ulaz, kol_int_izlaz, kol_storno_izlaz_sup, kol_izlaz_sup, kol_dnev_otpis, kol_inv_razlika, zaliha,
				       izn_ulaz, izn_int_ulaz, izn_int_izlaz, pros_nab_cijena, zad_nab_cijena)
       SELECT mt_id, nam_id, datum, sir_id, pro_id, nam_id_supstitut,pro_id_supstitut,
				       kol_ulaz, kol_izlaz, kol_int_ulaz, kol_int_izlaz, kol_storno_izlaz_sup, kol_izlaz_sup, kol_dnev_otpis, kol_inv_razlika, zaliha,
				       izn_ulaz, izn_int_ulaz, izn_int_izlaz, pros_nab_cijena, zad_nab_cijena
         FROM i_dnev_ui_det@' || metcvor_sifra_p || '
        WHERE datum > :max_datum_p
          AND datum < TRUNC(SYSDATE)
          AND mt_id IN
              (SELECT id
                 FROM m_oj@' || metcvor_sifra_p || '
                START WITH id = :oj_id_p
              CONNECT BY PRIOR id = oj_id
              )';

   EXECUTE IMMEDIATE naredba_l USING max_datum_p, oj_id_p;
   
     naredba_l :=
     'INSERT INTO i_zaliha
              (mt_id, nam_id, zaliha, pros_nab_cijena, zad_nab_cijena)
        SELECT mt_id, nam_id, zaliha, pros_nab_cijena, zad_nab_cijena
          FROM i_zaliha@' || metcvor_sifra_p || '
         WHERE mt_id IN
              (SELECT id
                 FROM m_oj@' || metcvor_sifra_p || '
                START WITH id = :oj_id_p
               CONNECT BY PRIOR id = oj_id
               )';
   
   EXECUTE IMMEDIATE naredba_l USING oj_id_p;  
END;
PROCEDURE REPLICIRAJ_PROMET_PANSIONA
 (METCVOR_SIFRA_P IN SMET_CVOROVI.SIFRA%TYPE
 ,MAX_DATUM_P IN DATE
 ,OJ_ID_P IN NUMBER
 ,METCVOR_RBR_P IN SMET_CVOROVI.RBR%TYPE
 )
 IS
   naredba_l VARCHAR2 (32000);
BEGIN
   /*
   ID se formira kao: metcvor_sifra_p || rn.id, tj. "proireni UK" + PK.
   Redni broj vora koji je jedinstven za korisnika.
   */
   naredba_l :=
    'INSERT INTO t_izlaz
            (id, godina, mt_id, rbr, datum, sifgr_id, nac_id, gpor_id,
             pdv, ppot, br_gostiju_plan, br_gostiju_izlaz, priznanje, priznanje_trosak, marza, opis, opis80, ozn_valjanosti,
             unos_korisnik, unos_dat, izmjena_korisnik, izmjena_dat)
      SELECT :metcvor_rbr_p || zag.id, zag.godina, zag.mt_id, zag.rbr, zag.datum, zag.sifgr_id, zag.nac_id, zag.gpor_id,
             zag.pdv, zag.ppot, zag.br_gostiju_plan, zag.br_gostiju_izlaz, zag.priznanje, zag.priznanje_trosak, zag.marza, zag.opis, zag.opis80, zag.ozn_valjanosti,
             zag.unos_korisnik, zag.unos_dat, zag.izmjena_korisnik, zag.izmjena_dat
        FROM t_izlaz@' || metcvor_sifra_p || ' zag,
             m_mt@'    || metcvor_sifra_p || ' mt
       WHERE zag.mt_id = mt.id
         AND zag.datum > :max_datum_p
         AND zag.datum < TRUNC(SYSDATE)
         AND zag.mt_id IN
             (SELECT id
                FROM m_oj@' || metcvor_sifra_p || '
               START WITH id = :oj_id_p
             CONNECT BY PRIOR id = oj_id
             )
       ORDER BY zag.id
    ';

   EXECUTE IMMEDIATE naredba_l USING metcvor_rbr_p, max_datum_p, oj_id_p;

   naredba_l :=
    'INSERT INTO t_izlaz_art
            (izl_id, nam_id, pro_id, sir_id,
             kol_plan, kol_izlaz, pdv, ppot, zad_nab_cijena, pros_nab_cijena, kol_povrat,
             unos_korisnik, unos_dat, izmjena_korisnik, izmjena_dat)
      SELECT :metcvor_rbr_p || sta.izl_id, sta.nam_id, sta.pro_id, sta.sir_id,
             sta.kol_plan, sta.kol_izlaz, sta.pdv, sta.ppot, sta.zad_nab_cijena, sta.pros_nab_cijena, sta.kol_povrat,
             sta.unos_korisnik, sta.unos_dat, sta.izmjena_korisnik, sta.izmjena_dat
        FROM t_izlaz@'     || metcvor_sifra_p || ' zag,
             t_izlaz_art@' || metcvor_sifra_p || ' sta,
             m_mt@'        || metcvor_sifra_p || ' mt
       WHERE zag.mt_id = mt.id
         AND zag.id = sta.izl_id
         AND zag.datum > :max_datum_p
         AND zag.datum < TRUNC(SYSDATE)
         AND zag.mt_id IN
             (SELECT id
                FROM m_oj@' || metcvor_sifra_p || '
               START WITH id = :oj_id_p
             CONNECT BY PRIOR id = oj_id
             )
    ';

   EXECUTE IMMEDIATE naredba_l USING metcvor_rbr_p, max_datum_p, oj_id_p;
END;
/* REPLICIRAJ_OTPREMNICE */
PROCEDURE REPLICIRAJ_OTPREMNICE
 (METCVOR_SIFRA_P IN SMET_CVOROVI.SIFRA%TYPE
 ,MAX_DATUM_P IN DATE
 ,OJ_ID_P IN NUMBER
 ,METCVOR_RBR_P IN SMET_CVOROVI.RBR%TYPE
 )
 IS
   naredba_l VARCHAR2 (32000);
BEGIN
   /*
   ID se formira kao: metcvor_sifra_p || rn.id, tj. "proireni UK" + PK.
   Redni broj vora koji je jedinstven za korisnika.
   */

   -- gasenar_id (veza na eksterne narudbe) puni se sa NULL
   naredba_l :=
    'INSERT INTO tgas_izlazdok
            (id,
             godina, mt_id, ozn_vdokumenta, rbr, datum, gmpkom_id, nac_id,
             gasizldok_id,
             gmpkomad_id, gasenar_id, status, opis, napomena, ozn_valjanosti,
             unos_korisnik, unos_dat, izmjena_korisnik, izmjena_dat)
      SELECT :metcvor_rbr_p || zag.id,
             zag.godina, zag.mt_id, zag.ozn_vdokumenta, zag.rbr, zag.datum, zag.gmpkom_id, zag.nac_id,
             DECODE (zag.gasizldok_id, NULL, NULL,:metcvor_rbr_p || zag.gasizldok_id),
             zag.gmpkomad_id, NULL, zag.status, zag.opis, zag.napomena, zag.ozn_valjanosti,
             zag.unos_korisnik, zag.unos_dat, zag.izmjena_korisnik, zag.izmjena_dat
        FROM tgas_izlazdok@' || metcvor_sifra_p || ' zag,
             m_mt@'          || metcvor_sifra_p || ' mt
       WHERE zag.mt_id = mt.id
         AND zag.datum > :max_datum_p
         AND zag.datum < TRUNC(SYSDATE)
         AND zag.mt_id IN
             (SELECT id
                FROM m_oj@' || metcvor_sifra_p || '
               START WITH id = :oj_id_p
             CONNECT BY PRIOR id = oj_id
             )
       ORDER BY zag.id
    ';

   EXECUTE IMMEDIATE naredba_l USING metcvor_rbr_p, metcvor_rbr_p, max_datum_p, oj_id_p;

   naredba_l :=
    'INSERT INTO tgas_izlazdok_art
            (id,
             gasizldok_id,
             gpor_id, pro_id, vpispz_id, gknji_id, gtehpro_id,
             kolicina, prod_cijena, rabat, pdv, nab_cijena,
             unos_korisnik, unos_dat, izmjena_korisnik, izmjena_dat)
      SELECT :metcvor_rbr_p || sta.id,
             :metcvor_rbr_p || sta.gasizldok_id,
             sta.gpor_id, sta.pro_id, sta.vpispz_id, sta.gknji_id, sta.gtehpro_id,
             sta.kolicina, sta.prod_cijena, sta.rabat, sta.pdv, sta.nab_cijena,
             sta.unos_korisnik, sta.unos_dat, sta.izmjena_korisnik, sta.izmjena_dat
        FROM tgas_izlazdok@'     || metcvor_sifra_p || ' zag,
             tgas_izlazdok_art@' || metcvor_sifra_p || ' sta,
             m_mt@'              || metcvor_sifra_p || ' mt
       WHERE zag.mt_id = mt.id
         AND zag.id = sta.gasizldok_id
         AND zag.datum > :max_datum_p
         AND zag.datum < TRUNC(SYSDATE)
         AND zag.mt_id IN
             (SELECT id
                FROM m_oj@' || metcvor_sifra_p || '
               START WITH id = :oj_id_p
             CONNECT BY PRIOR id = oj_id
             )
    ';

   EXECUTE IMMEDIATE naredba_l USING metcvor_rbr_p, metcvor_rbr_p, max_datum_p, oj_id_p;

   naredba_l :=
    'INSERT INTO tgas_izlazdok_amb
            (gasizldok_id,
             amb_id, kolicina, prod_cijena,
             unos_korisnik, unos_dat, izmjena_korisnik, izmjena_dat)
      SELECT :metcvor_rbr_p || sta.gasizldok_id,
             sta.amb_id, sta.kolicina, sta.prod_cijena,
             sta.unos_korisnik, sta.unos_dat, sta.izmjena_korisnik, sta.izmjena_dat
        FROM tgas_izlazdok@'     || metcvor_sifra_p || ' zag,
             tgas_izlazdok_amb@' || metcvor_sifra_p || ' sta,
             m_mt@'              || metcvor_sifra_p || ' mt
       WHERE zag.mt_id = mt.id
         AND zag.id = sta.gasizldok_id
         AND zag.datum > :max_datum_p
         AND zag.datum < TRUNC(SYSDATE)
         AND zag.mt_id IN
             (SELECT id
                FROM m_oj@' || metcvor_sifra_p || '
               START WITH id = :oj_id_p
             CONNECT BY PRIOR id = oj_id
             )
    ';

   EXECUTE IMMEDIATE naredba_l USING metcvor_rbr_p, max_datum_p, oj_id_p;  
END;
/* REPLICIRAJ_ZAMJENU */
PROCEDURE REPLICIRAJ_ZAMJENU
 (METCVOR_SIFRA_P IN SMET_CVOROVI.SIFRA%TYPE
 ,MAX_DATUM_P IN DATE
 ,OJ_ID_P IN NUMBER
 ,METCVOR_RBR_P IN SMET_CVOROVI.RBR%TYPE
 )
 IS
   naredba_l VARCHAR2 (32000);
BEGIN
   /*
   ID se formira kao: metcvor_sifra_p || rn.id, tj. "proireni UK" + PK.
   Redni broj vora koji je jedinstven za korisnika.
   */

   naredba_l :=
    'INSERT INTO t_zamjena
            (id,
             godina, mt_id, rbr, datum, nac_id, opis, opis80, ozn_valjanosti,
             unos_korisnik, unos_dat, izmjena_korisnik, izmjena_dat)
      SELECT :metcvor_rbr_p || zag.id,
             zag.godina, zag.mt_id, zag.rbr, zag.datum, zag.nac_id, zag.opis, zag.opis80, zag.ozn_valjanosti,
             zag.unos_korisnik, zag.unos_dat, zag.izmjena_korisnik, zag.izmjena_dat
        FROM t_zamjena@' || metcvor_sifra_p || ' zag,
             m_mt@'      || metcvor_sifra_p || ' mt
       WHERE zag.mt_id = mt.id
         AND zag.datum > :max_datum_p
         AND zag.datum < TRUNC(SYSDATE)
         AND zag.mt_id IN
             (SELECT id
                FROM m_oj@' || metcvor_sifra_p || '
               START WITH id = :oj_id_p
             CONNECT BY PRIOR id = oj_id
             )
       ORDER BY zag.id
    ';

   EXECUTE IMMEDIATE naredba_l USING metcvor_rbr_p, max_datum_p, oj_id_p;

   naredba_l :=
    'INSERT INTO t_zamjena_art
            (zam_id,
             nam_id, pro_id, nam_id_supstitut, pro_id_supstitut,
             kolicina, kol_supstituta, pc, pc_supstitut, pros_nab_cijena, pros_nab_cijena_supstitut,
             unos_korisnik, unos_dat, izmjena_korisnik, izmjena_dat)
      SELECT :metcvor_rbr_p || sta.zam_id,
             sta.nam_id, sta.pro_id, sta.nam_id_supstitut, sta.pro_id_supstitut,
             sta.kolicina, sta.kol_supstituta, sta.pc, sta.pc_supstitut, sta.pros_nab_cijena, sta.pros_nab_cijena_supstitut,
             sta.unos_korisnik, sta.unos_dat, sta.izmjena_korisnik, sta.izmjena_dat
        FROM t_zamjena@'     || metcvor_sifra_p || ' zag,
             t_zamjena_art@' || metcvor_sifra_p || ' sta,
             m_mt@'          || metcvor_sifra_p || ' mt
       WHERE zag.mt_id = mt.id
         AND zag.id = sta.zam_id
         AND zag.datum > :max_datum_p
         AND zag.datum < TRUNC(SYSDATE)
         AND zag.mt_id IN
             (SELECT id
                FROM m_oj@' || metcvor_sifra_p || '
               START WITH id = :oj_id_p
             CONNECT BY PRIOR id = oj_id
             )
    ';

   EXECUTE IMMEDIATE naredba_l USING metcvor_rbr_p, max_datum_p, oj_id_p;
END;
PROCEDURE REPLICIRAJ_MINIBAR
 (DATUM_ZA_BRISANJE_P IN DATE := NULL
 )
 IS
   brojac_l NUMBER;
   max_datum_l DATE;
BEGIN
   /*
   Dodatak za MINIBAR privremeno (SUCENTAR);
   Ovo se radi samo ako je GAS centralni, a minibar se vodi preko REC2350 lokalno.
   */

   SELECT COUNT (*) INTO brojac_l
     FROM smet_instalacije
    WHERE metapl_sifra = 'GAS';

   IF brojac_l <> 1 THEN
      RETURN;
   END IF;

   FOR mbar IN (
      SELECT DISTINCT(metcvor_sifra) metcvor_sifra, cvor.rbr
        FROM mgmp_kase gmpkas,
             mzmp_ojr zmpojr,
             smet_cvorovi cvor
       WHERE ozn_kase = 'M'
         AND gmpkas.zmpojr_id = zmpojr.ID
         AND cvor.sifra = zmpojr.metcvor_sifra
         AND metcvor_sifra IS NOT NULL)
   LOOP     
      IF datum_za_brisanje_p IS NULL THEN
         SELECT NVL (MAX (datum), '01.01.2000')
                INTO max_datum_l
           FROM t_rnkase
          WHERE kase_id IN
                (SELECT id 
                   FROM mgmp_kase  
                  WHERE ozn_kase =  'M'
                    AND zmpojr_id IN (SELECT ID FROM mzmp_ojr WHERE metcvor_sifra = mbar.metcvor_sifra)
                );

         repliciraj_trnkase (mbar.metcvor_sifra, max_datum_l, mbar.rbr);                            
      ELSE
         DELETE t_rnkase_pro 
          WHERE rn_id IN
                (SELECT id
                   FROM t_rnkase
                  WHERE datum >= datum_za_brisanje_p
                    AND kase_id IN
                       (SELECT id 
                          FROM mgmp_kase  
                         WHERE ozn_kase = 'M'
                           AND zmpojr_id IN (SELECT ID FROM mzmp_ojr WHERE metcvor_sifra = mbar.metcvor_sifra)
                       )
                 );
                             
         DELETE t_rnkase   
          WHERE datum >= datum_za_brisanje_p
            AND kase_id IN
                (SELECT id  
                   FROM mgmp_kase 
                  WHERE ozn_kase =  'M' 
                    AND zmpojr_id IN (SELECT ID FROM mzmp_ojr WHERE metcvor_sifra = mbar.metcvor_sifra)
                );                             

         repliciraj_trnkase (mbar.metcvor_sifra, datum_za_brisanje_p - 1, mbar.rbr);                
      END IF;
   END LOOP;

   COMMIT;  
EXCEPTION
   WHEN OTHERS THEN
      ROLLBACK;  
      popis_gresaka_m := popis_gresaka_m || ' ' || SUBSTR (SQLERRM, 1, 200);
END;
PROCEDURE REPLICIRAJ_TRNKASE
 (METCVOR_SIFRA_P IN SMET_CVOROVI.SIFRA%TYPE
 ,MAX_DATUM_P IN DATE
 ,METCVOR_RBR_P IN SMET_CVOROVI.RBR%TYPE
 )
 IS
  naredba_l VARCHAR2 (32000);
BEGIN
   /*
   ID se formira kao: metcvor_rbr_p || rn.id, tj. "proireni UK" + PK.
   Redni broj vora koji je jedinstven za korisnika.
   */
  naredba_l :=
  'INSERT  INTO t_rnkase
            (id, godina, kase_id, rbr, datum, kon_id, nac_id, vpla_id,
             popust, opis, unos_korisnik, unos_dat, izmjena_korisnik, izmjena_dat, vrijeme,
             oj_id, sj_id, age_id, br_gostiju, vpdog_id, pkaadr_ozn, ozn_valjanosti, rn_id, izn_placanja, izn_placanja2,
             vpla_napojnice_id, izn_napojnice, datum_napojnice, ozn_storna)
      SELECT :metcvor_rbr_p || rn.id, godina, kase_id, rbr, datum, kon_id, nac_id, rn.vpla_id,
             popust, opis, rn.unos_korisnik, rn.unos_dat, rn.izmjena_korisnik, rn.izmjena_dat, vrijeme,
             rn.oj_id, sj_id, age_id, br_gostiju, vpdog_id, pkaadr_ozn, ozn_valjanosti, DECODE(rn_id, NULL, NULL, :metcvor_rbr_p||rn_id),  izn_placanja, izn_placanja2,
             vpla_napojnice_id, izn_napojnice, datum_napojnice, ozn_storna
        FROM t_rnkase@'     || metcvor_sifra_p || ' rn,
             mgmp_kase@'    || metcvor_sifra_p || ' kase
        WHERE rn.kase_id = kase.id
          AND ozn_kase = ''M''
          AND rn.datum > :max_datum_p
          AND rn.datum < TRUNC(SYSDATE)
          ORDER BY rn.id
          ';

     EXECUTE IMMEDIATE naredba_l USING  metcvor_rbr_p, metcvor_rbr_p, max_datum_p;

  naredba_l :=
  'INSERT  INTO t_rnkase_pro
            (rn_id, rbr_stavke, pro_id, sifgr_id, gpor_id , gknji_id, gtehpro_id, mt_id,
             kolicina, cijena, pdv, ppot, zad_nab_cijena , pros_nab_cijena, unos_dat, unos_korisnik,
             izmjena_korisnik, izmjena_dat, vpispz_id, popust, matkalk_id, iznos_popust, iznos_pdv,
             iznos_ppot, iznos, iznos_pnaknade )
      SELECT :metcvor_rbr_p||rnpro.rn_id, rbr_stavke, pro_id, sifgr_id, rnpro.gpor_id , gknji_id, gtehpro_id, mt_id,
             kolicina, cijena, pdv, ppot, zad_nab_cijena , pros_nab_cijena, rnpro.unos_dat, rnpro.unos_korisnik,
             rnpro.izmjena_korisnik, rnpro.izmjena_dat, vpispz_id, rnpro.popust, matkalk_id, iznos_popust, iznos_pdv,
             iznos_ppot, iznos, iznos_pnaknade
        FROM t_rnkase@'     || metcvor_sifra_p || ' rn,
             t_rnkase_pro@' || metcvor_sifra_p || ' rnpro,
             mgmp_kase@'    || metcvor_sifra_p || ' kase
        WHERE rn.kase_id = kase.id
          AND rn.id = rnpro.rn_id
          AND ozn_kase = ''M''
          AND rn.datum > :max_datum_p
          AND rn.datum < TRUNC(SYSDATE)
          ';
     EXECUTE IMMEDIATE naredba_l USING  metcvor_rbr_p,max_datum_p;

END;
PROCEDURE REPLICIRAJ_OTPIS
 (METCVOR_SIFRA_P IN SMET_CVOROVI.SIFRA%TYPE
 ,MAX_DATUM_P IN DATE
 ,OJ_ID_P IN NUMBER
 ,METCVOR_RBR_P IN SMET_CVOROVI.RBR%TYPE
 )
 IS
 naredba_l VARCHAR2 (32000);
BEGIN
   /*
   ID se formira kao: metcvor_sifra_p || rn.id, tj. "proireni UK" + PK.
   Redni broj vora koji je jedinstven za korisnika.
   */
  
   naredba_l :=
     'INSERT INTO t_otpis
            (id,
             godina, mt_id, rbr, datum, nac_id, opis, opis80, ozn_valjanosti,
             unos_korisnik, unos_dat, izmjena_korisnik, izmjena_dat,
             otp_id,
             ozn_otpis)
      SELECT :metcvor_rbr_p || zag.id,
             zag.godina, zag.mt_id, zag.rbr, zag.datum, zag.nac_id,zag.opis, zag.opis80, zag.ozn_valjanosti,
             zag.unos_korisnik, zag.unos_dat, zag.izmjena_korisnik, zag.izmjena_dat,
             DECODE(zag.otp_id, NULL, NULL, :metcvor_rbr_p || zag.otp_id),
             zag.ozn_otpis
        FROM t_otpis@' || metcvor_sifra_p || ' zag,
             m_mt@'    || metcvor_sifra_p || ' mt
       WHERE zag.mt_id = mt.id
         AND zag.datum > :max_datum_p
         AND zag.datum < TRUNC(SYSDATE)
         AND zag.mt_id IN
             (SELECT id
                FROM m_oj@' || metcvor_sifra_p || '
               START WITH id = :oj_id_p
             CONNECT BY PRIOR id = oj_id
             )
       ORDER BY zag.id
    ';

   EXECUTE IMMEDIATE naredba_l USING metcvor_rbr_p, metcvor_rbr_p, max_datum_p, oj_id_p;

   naredba_l :=
    'INSERT INTO t_otpis_art
            (otp_id,
             sir_id, nam_id, pro_id,
             odnos_jm_b, odnos_jm_n, kolicina, pros_nab_cijena, gpor_id, iznos_poreza, pdv,opis_stavke_id,
             unos_korisnik, unos_dat, izmjena_korisnik, izmjena_dat)
      SELECT  :metcvor_rbr_p || sta.otp_id,
             sta.sir_id, sta.nam_id, sta.pro_id,
             sta.odnos_jm_b, sta.odnos_jm_n, sta.kolicina, sta.pros_nab_cijena, sta.gpor_id, sta.iznos_poreza, sta.pdv, sta.opis_stavke_id,
             sta.unos_korisnik, sta.unos_dat, sta.izmjena_korisnik, sta.izmjena_dat
        FROM t_otpis@'     || metcvor_sifra_p || ' zag,
             t_otpis_art@' || metcvor_sifra_p || ' sta,
             m_mt@'        || metcvor_sifra_p || ' mt
       WHERE zag.mt_id = mt.id
         AND zag.id = sta.otp_id
         AND zag.datum > :max_datum_p
         AND zag.datum < TRUNC(SYSDATE)
         AND zag.mt_id IN
             (SELECT id
                FROM m_oj@' || metcvor_sifra_p || '
               START WITH id = :oj_id_p
             CONNECT BY PRIOR id = oj_id
             )
    ';

   EXECUTE IMMEDIATE naredba_l USING metcvor_rbr_p, max_datum_p, oj_id_p;
   
END;
PROCEDURE REPLICIRAJ_INV_INVUI
 (METCVOR_SIFRA_P IN SMET_CVOROVI.SIFRA%TYPE
 ,MAX_DATUM_P IN DATE
 ,OJ_ID_P IN NUMBER
 )
 IS
   naredba_l VARCHAR2 (32000);
BEGIN
   naredba_l :=
   'INSERT INTO i_inv_ui
             (mt_id, nam_id, datum,
              kol_poc_stanje, kol_ulaz, kol_izlaz, kol_int_ulaz, kol_int_izlaz, kol_storno_izlaz_sup,
              kol_izlaz_sup, kol_dnev_otpis, kol_inv_razlika, kol_zav_stanje, izn_poc_stanje, izn_ulaz,izn_izlaz,
              izn_int_ulaz, izn_int_izlaz, izn_storno_izlaz_sup, izn_izlaz_sup, izn_dnev_otpis, izn_zav_stanje,
              pros_nab_cijena, zad_nab_cijena, pc, post_otpisa, gpor_id, pdv, ppot)
       SELECT mt_id, nam_id, datum,
              kol_poc_stanje, kol_ulaz, kol_izlaz, kol_int_ulaz, kol_int_izlaz, kol_storno_izlaz_sup,
              kol_izlaz_sup, kol_dnev_otpis, kol_inv_razlika, kol_zav_stanje, izn_poc_stanje, izn_ulaz,izn_izlaz,
              izn_int_ulaz, izn_int_izlaz, izn_storno_izlaz_sup, izn_izlaz_sup, izn_dnev_otpis, izn_zav_stanje,
              pros_nab_cijena, zad_nab_cijena, pc, post_otpisa, gpor_id, pdv, ppot
         FROM i_inv_ui@' || metcvor_sifra_p || '
        WHERE datum > :max_datum_p
          AND datum < TRUNC(SYSDATE)
          AND mt_id IN
              (SELECT id
                 FROM m_oj@' || metcvor_sifra_p || '
                START WITH id = :oj_id_p
              CONNECT BY PRIOR id = oj_id
              )
   ';

   EXECUTE IMMEDIATE naredba_l USING max_datum_p, oj_id_p;
END;
PROCEDURE REPLICIRAJ_INV_TINV
 (METCVOR_SIFRA_P IN SMET_CVOROVI.SIFRA%TYPE
 ,MAX_DATUM_P IN DATE
 ,OJ_ID_P IN NUMBER
 )
 IS
   naredba_l VARCHAR2 (32000);
BEGIN
   
   naredba_l :=
   'INSERT INTO t_inv_razlike
             (mt_id, nam_id, datum,
              kol_inv_razlika, kol_tolerancije, kol_odg_osobe, kol_teret_pc,
              pros_nab_cijena, zad_nab_cijena, pc,  pdv, ppot, kol_inv_visak)
       SELECT mt_id, nam_id, datum,
              kol_inv_razlika, kol_tolerancije, kol_odg_osobe, kol_teret_pc,
              pros_nab_cijena, zad_nab_cijena, pc,  pdv, ppot, kol_inv_visak
         FROM t_inv_razlike@' || metcvor_sifra_p || '
        WHERE datum > :max_datum_p
          AND datum < TRUNC(SYSDATE)
          AND mt_id IN
              (SELECT id
                 FROM m_oj@' || metcvor_sifra_p || '
                START WITH id = :oj_id_p
              CONNECT BY PRIOR id = oj_id
              )
   ';

   EXECUTE IMMEDIATE naredba_l USING max_datum_p, oj_id_p;
END;
PROCEDURE REPLICIRAJ_INV_TINVDOK
 (METCVOR_SIFRA_P IN SMET_CVOROVI.SIFRA%TYPE
 ,MAX_DATUM_P IN DATE
 ,OJ_ID_P IN NUMBER
 ,METCVOR_RBR_P IN SMET_CVOROVI.RBR%TYPE
 )
 IS
   naredba_l VARCHAR2 (32000);
BEGIN
  /*
   ID se formira kao: metcvor_sifra_p || rn.id, tj. "proireni UK" + PK.
   Redni broj vora koji je jedinstven za korisnika.
   */
 
  naredba_l :=
   'INSERT INTO t_inventura
             (id, godina, mt_id, rbr, datum,  opis, opis80,  ozn_valjanosti,
              unos_korisnik, unos_dat, izmjena_korisnik, izmjena_dat)
       SELECT :metcvor_rbr_p || zag.id,
              zag.godina, zag.mt_id, zag.rbr, zag.datum,  zag.opis, zag.opis80,  zag.ozn_valjanosti,
              zag.unos_korisnik, zag.unos_dat, zag.izmjena_korisnik, zag.izmjena_dat
         FROM t_inventura@' || metcvor_sifra_p || ' zag,
              m_mt@'        || metcvor_sifra_p || ' mt
        WHERE datum > :max_datum_p
          AND datum < TRUNC(SYSDATE)
          AND zag.mt_id = mt.id
          AND mt_id IN
              (SELECT id
                 FROM m_oj@' || metcvor_sifra_p || '
                START WITH id = :oj_id_p
              CONNECT BY PRIOR id = oj_id
              )
   ';

   EXECUTE IMMEDIATE naredba_l USING metcvor_rbr_p, max_datum_p, oj_id_p;

    naredba_l :=
    'INSERT INTO t_inventura_art
            (inv_id, sir_id, nam_id, pro_id,  odnos_jm_b, odnos_jm_n,  kol_inventura,
              unos_korisnik, unos_dat,  izmjena_korisnik, izmjena_dat )
      SELECT :metcvor_rbr_p || sta.inv_id,
             sta.sir_id, sta.nam_id, sta.pro_id, sta.odnos_jm_b, sta.odnos_jm_n,sta.kol_inventura,
             sta.unos_korisnik, sta.unos_dat, sta.izmjena_korisnik, sta.izmjena_dat
        FROM t_inventura@'     || metcvor_sifra_p || ' zag,
             t_inventura_art@' || metcvor_sifra_p || ' sta,
             m_mt@'          || metcvor_sifra_p || ' mt
       WHERE zag.mt_id = mt.id
         AND zag.id = sta.inv_id
         AND zag.datum > :max_datum_p
         AND zag.datum < TRUNC(SYSDATE)
         AND zag.mt_id IN
             (SELECT id
                FROM m_oj@' || metcvor_sifra_p || '
               START WITH id = :oj_id_p
             CONNECT BY PRIOR id = oj_id
             )
    ';

   EXECUTE IMMEDIATE naredba_l USING metcvor_rbr_p, max_datum_p, oj_id_p;
END;

END BM_GAS3140;
/
SHOW ERROR

