PROMPT Pokrenuta skripta apex_on.sql

DECLARE
  workspace_id_l NUMBER;
  workspace_name_l VARCHAR2(10) := 'MISH_APEX';

BEGIN
  workspace_id_l := apex_util.find_security_group_id (workspace_name_l);
  apex_util.set_security_group_id ( workspace_id_l );

  FOR app_c IN (
    SELECT application_id AS id, application_name, availability_status
      FROM apex_applications
     WHERE workspace = workspace_name_l
       AND UPPER (owner) = UPPER ('&shema')
    )
  LOOP
    DBMS_OUTPUT.PUT_LINE ('APEX aplikacija na ON: ' || app_c.application_name || ' status: ' || app_c.availability_status);
    apex_util.set_application_status (
      p_application_id     => app_c.id,
      p_application_status => 'AVAILABLE_W_EDIT_LINK'
      );

  END LOOP;
  COMMIT;
END;
/
