-- D:\mish_CVS\misH_skripte\vge.pkb
--
-- Generated for Oracle 10g on Wed Nov 05  09:22:11 2025 by Server Generator 6.5.96.5.6
 

PROMPT Creating Package Body 'VGE'
CREATE OR REPLACE PACKAGE BODY VGE IS

FUNCTION R_KASE
 (METAPL_SIFRA_P mgmp_kase.metapl_sifra%type
 )
 RETURN SYS_REFCURSOR
 IS


 l_rc SYS_REFCURSOR;
BEGIN
   /* Valjane kase vrste VGE */
   OPEN l_rc FOR
      SELECT kase.id          AS id,
             kase.sifra       AS sifra,
             kase.naziv       AS naziv,
             oj.sifra         AS sifra_rc,
             kase.izmjena_dat AS izmjena_dat
        FROM mgmp_kase kase, m_kasa_np kasanp, m_oj oj
       WHERE metapl_sifra = metapl_sifra_p
         AND kase.id      = kasanp.kase_id
         AND kasanp.oj_id = oj.id(+)              
         AND (((pra_zmp_zaj.zmppar_vrijednost ('GAS', '1004') = '1')  AND oj.sifra is NOT NULL) 
                OR oj.sifra IS NULL)    
         AND NVL(kase.dat_ponisten, TRUNC (SYSDATE)) > TRUNC (SYSDATE - 1);
   RETURN l_rc;
END;
FUNCTION R_KNJIGOVODSTVENE_GRUPE
 RETURN SYS_REFCURSOR
 IS


 l_rc SYS_REFCURSOR;
BEGIN
   /* Knjigovodstvene grupe proizvoda  */
   OPEN l_rc FOR
      SELECT DISTINCT(gknji.id) AS id,
             gknji.sifra        AS sifra,
             gknji.naziv        AS naziv,
             gknji.izmjena_dat  AS izmjena_dat
        FROM m_proizvodi pro,
             m_gknjigo gknji
       WHERE pro.gknji_id    = gknji.id;
   RETURN l_rc;
END;
FUNCTION R_POREZNE_GRUPE
 RETURN SYS_REFCURSOR
 IS


 l_rc SYS_REFCURSOR;
BEGIN
    /* Porezne grupe proizvoda  */
  OPEN l_rc FOR
      SELECT DISTINCT(gpor.id) AS id,
             gpor.sifra        AS sifra,
             gpor.naziv        AS naziv,
             vpispz.stopa      AS stopa_pdv,
             gpor.ppot         AS stopa_ppot,
             gpor.izmjena_dat  AS izmjena_dat
        FROM m_proizvodi pro,
             m_gporez gpor,
             mgas_gpor_raz gporraz,
             s_vpisporukap vpispp,
             s_vpisporukaz vpispz
       WHERE pro.gpor_id      = gpor.ID
         AND gpor.ID =  gporraz.gpor_id
         AND SYSDATE BETWEEN gporraz.dat_valjan AND NVL(gporraz.dat_ponisten, SYSDATE)
         AND gporraz.vpispp_id   = vpispp.id
         AND vpispp.vpispz_id = vpispz.id;
   RETURN l_rc;
END;
FUNCTION R_VPLACANJA
 (KASE_ID_P m_kase.id%TYPE
 )
 RETURN SYS_REFCURSOR
 IS


l_rc SYS_REFCURSOR;
BEGIN
    /* Vrste plaanja za kasu (parametar kasa) */
   OPEN l_rc FOR
      SELECT DISTINCT(vpla.id) AS id,
             vpla.sifra        AS sifra,
             vpla.naziv        AS naziv,
             vppla.sifra       AS fis_oznaka,
             vpla.izmjena_dat  AS izmjena_dat
        FROM mgmp_kase kase,
             m_kasa_np kasanp,
             m_nac_vpla nacvpla,
             s_vplacanja vpla,
             s_vpplacanja vppla
       WHERE kase.id       = kase_id_p
         AND kasanp.kase_id  = kase.id
         AND kasanp.nac_id   = nacvpla.nac_id
         AND nacvpla.vpla_id = vpla.id
         AND vpla.vppla_id   = vppla.id;
   RETURN l_rc;
 END;
FUNCTION R_PROIZVODI
 (KASE_ID_P m_kase.id%TYPE
 ,PRO_SIFRA_P m_proizvodi.sifra%TYPE
 )
 RETURN SYS_REFCURSOR
 IS


l_rc SYS_REFCURSOR;
BEGIN
   /* Proizvod po ifri za kasu iz asortimana kase */
   OPEN l_rc FOR
      SELECT DISTINCT(pro.id)    AS id,
             pro.sifra           AS sifra,
             pro.naziv           AS naziv,
             pra_pos_gas.br_subtotal (UPPER (SUBSTR (gknji.naziv, 1, 2)) || ' '|| vpispz.stopa || '+' || gpor.ppot) AS subtotal,
                                      UPPER (SUBSTR (gknji.naziv, 1, 2)) || ' '|| vpispz.stopa || '+' || gpor.ppot  AS opera_sub,
             pro.gknji_id        AS gknji_id,
             pro.gpor_id         AS gpor_id,
             asokase.pc          AS cijena,
             asokase.izmjena_dat AS izmjena_dat
        FROM m_aso_kase asokase,
             m_proizvodi pro,
             m_gporez gpor,
             mgas_gpor_raz gporraz,
             s_vpisporukap vpispp,
             s_vpisporukaz vpispz,
             m_gknjigo gknji
       WHERE asokase.kase_id   = kase_id_p
         AND pro.sifra         = NVL(pro_sifra_p, pro.sifra)
         AND asokase.pro_id    = pro.id
         AND pro.gpor_id       = gpor.ID
         AND pro.gpor_id       = gporraz.gpor_id
         AND SYSDATE BETWEEN gporraz.dat_valjan AND NVL(gporraz.dat_ponisten, SYSDATE)
         AND pro.gknji_id      = gknji.ID
         AND gporraz.vpispp_id    = vpispp.id
         AND vpispp.vpispz_id  = vpispz.id
         AND NVL (pro.dat_ponisten, TRUNC (SYSDATE)) > TRUNC (SYSDATE - 1);

      RETURN l_rc;
END;
FUNCTION GET_RNKASE
 (GODINA_P IN t_rnkase.godina%TYPE
 ,KASE_ID_P IN mgmp_kase.id%TYPE
 )
 RETURN SYS_REFCURSOR
 IS


  l_rc SYS_REFCURSOR;
BEGIN
  /* TEST*/
  -- dodati da je kasa 'VGE' da podaci ne bi mogli biti dostupni svima
   
  OPEN L_RC FOR
     SELECT t.id,
            t.godina,
            t.kase_id,
            t.rbr,
            T.DATUM AS DATUM_BLAGAJNE,
            T.DATUM_IZDAVANJA AS DATUM_VRIJEME_RACUNA,
            t.vpla_id,
            t.zastitni_kod AS zki,
            t.jir,
            t.paragon AS opera_podaci
       FROM t_rnkase t,
            mgmp_kase k
      WHERE t.godina  = NVL(godina_p, TO_CHAR(SYSDATE, 'YYYY'))
        AND t.kase_id = k.id
        AND t.kase_id = kase_id_p;

  RETURN l_rc;
END;
FUNCTION GET_RNSTAVKE
 (RN_ID_P IN T_RNKASE.ID%TYPE
 )
 RETURN SYS_REFCURSOR
 IS


  l_rc SYS_REFCURSOR;
BEGIN
  -- dodati da je kasa 'VGE' da podaci ne bi mogli biti dostupni svima
  -- OPEN L_RC FOR SELECT * FROM T_RNKASE_PRO T WHERE T.RN_ID = RN_ID_P;
  /* TEST*/

OPEN l_rc FOR
   SELECT t.rn_id,
          t.rbr_stavke,
          t.pro_id,
          t.cijena,
          t.kolicina,
          t.pdv  AS stopa_pdv,
          t.ppot AS stopa_ppot,
          t.iznos_pdv,
          t.iznos_ppot,
          t.iznos_popust,
          t.iznos
     FROM t_rnkase_pro t
    WHERE t.rn_id = rn_id_p;

  RETURN l_rc;
END;
PROCEDURE RNKASE
 (GODINA_P IN t_rnkase.godina%TYPE
 ,KASE_ID_P IN mgmp_kase.ID%TYPE
 ,RBR_P IN t_rnkase.rbr%TYPE
 ,DATUM_BLAGAJNE_P IN t_rnkase.datum%TYPE
 ,DATUM_VRIJEME_RACUNA_P t_rnkase.datum_izdavanja%TYPE
 ,VPLA_ID_P IN t_rnkase.vpla_id%TYPE
 ,ZKI_P IN t_rnkase.zastitni_kod%TYPE
 ,JIR_P IN t_rnkase.jir%TYPE
 ,OPERA_PODACI_P IN t_rnkase.paragon%TYPE
 ,RN_ID_P OUT t_rnkase.id%TYPE
 ,KON_SIFRA_P IN m_konobari.sifra%TYPE
 ,KON_PODACI_P OUT VARCHAR2
 ,RBR_FISK_P IN t_rnkase.rbr_fisk%TYPE
 )
 IS
 /* Uzima se prvi konobar, svi rauni su vezani samo na jednog konobara */
  CURSOR kon_id_C (kon_sifra_p VARCHAR2)IS
  SELECT id, sifra || ' ' || ime_prezime || ' ' || oib
    FROM m_konobari
   WHERE sifra = kon_sifra_p
     AND oib IS NOT NULL;

/* Uzima se prvi nain potronje, dogovorno je samo jedan */
  CURSOR nac_id_C (kase_id_p VARCHAR2)IS
      SELECT nac.id
        FROM m_kasa_np kasanp, m_nacpot nac
       WHERE kasanp.kase_id = kase_id_p
         AND kasanp.nac_id = nac.id
       ORDER BY nac.sifra;

  CURSOR vpla_id_C (vpla_id_p VARCHAR2)IS
      SELECT vpla.ozn_irn
        FROM s_vplacanja vpla
       WHERE id = vpla_id_p;

  kon_id_l    m_konobari.id%TYPE;
  nac_id_l    m_nacpot.id%TYPE;
  rn_id_l     t_rnkase.id%TYPE;
  oj_id_l     m_oj.id%TYPE;
  ozn_irn_l   s_vplacanja.ozn_irn%TYPE;
  ozn_valjanosti_l  t_rnkase.ozn_valjanosti%TYPE;
  kon_podaci_l VARCHAR2(100);
BEGIN
   OPEN kon_id_C (kon_sifra_p);
    FETCH kon_id_C INTO kon_id_l, kon_podaci_l;
    CLOSE kon_id_C;

    OPEN nac_id_C (kase_id_p);
   FETCH nac_id_C INTO nac_id_l;
   CLOSE nac_id_C;

   OPEN vpla_id_C (vpla_id_p);
   FETCH vpla_id_C INTO ozn_irn_l ;
   CLOSE vpla_id_C;

   /* Za gotovinske (fiskalne) vrste plaanja rauni (ozn_valjanosti = 'P') se u Operu alju preko paketa OPERA_PSM */
   IF ozn_irn_l IS NULL THEN
      ozn_valjanosti_l := 'P';
   ELSE
      ozn_valjanosti_l := 'V';
   END IF;

   /* Ako je u parametru GAS '1004' upisano 1, tada se radi sa Opera sustavom */
   IF pra_zmp_zaj.zmppar_vrijednost ('GAS', '1004') = '1'  THEN
      /*
      Kod rauna na sobu, polje PARAGON sadri podatke: BROJ SJ, IFRA SO, HOTELID (Opera)
      sa graninikom toka-zarez, npr.: "Opera: 1234;56;78;
      */
      IF opera_podaci_p LIKE ('Opera: %')
      THEN
         DECLARE
            -- pozicije znaka toka-zarez u polju PARAGON
            pozicija_1_l INTEGER := INSTR (opera_podaci_p, ';', 1, 1);
            pozicija_2_l INTEGER := INSTR (opera_podaci_p, ';', 1, 2);
            oj_sifra_l m_oj.sifra%TYPE;
         --   oj_id_l m_oj.id%TYPE;
         BEGIN
            oj_sifra_l := SUBSTR (opera_podaci_p, pozicija_1_l + 1, pozicija_2_l - 1 - pozicija_1_l);

            SELECT id INTO oj_id_l
              FROM m_oj
             WHERE sifra = oj_sifra_l;
         EXCEPTION
            WHEN NO_DATA_FOUND THEN NULL;
         END;
      END IF;
   END IF;

   /* izmjena JF 03.12.2018 dodano polje izn_placanja koje e se napuniti sumom iznosa iz stavaka u proceduri RNKASE_PRO */
   INSERT INTO t_rnkase
       (godina, kase_id, rbr, datum, kon_id, nac_id, vpla_id,
        popust, vrijeme, jir, zastitni_kod, paragon, ozn_valjanosti, datum_izdavanja, oj_id,izn_placanja, rbr_fisk)
      VALUES
       (godina_p, kase_id_p, LPAD(rbr_p, 6,'0'), datum_blagajne_p, kon_id_l, nac_id_l, vpla_id_p,
       0, TO_CHAR(datum_vrijeme_racuna_p,'HH24MI'),jir_p, zki_p, opera_podaci_p, ozn_valjanosti_l, datum_vrijeme_racuna_P, oj_id_l,0, rbr_fisk_p)
      RETURN id INTO rn_id_l;

 rn_id_p := rn_id_l;
 kon_podaci_p := kon_podaci_l;
END;
PROCEDURE RNKASE_PRO
 (RN_ID_P IN t_rnkase_pro.rn_id%type
 ,RBR_STAVKE_P IN t_rnkase_pro.rbr_stavke%TYPE
 ,PRO_ID_P IN t_rnkase_pro.pro_id%TYPE
 ,CIJENA_P IN t_rnkase_pro.cijena%TYPE
 ,KOLICINA_P IN t_rnkase_pro.kolicina%TYPE
 ,STOPA_PDV_P IN t_rnkase_pro.pdv%TYPE
 ,STOPA_PPOT_P IN t_rnkase_pro.ppot%TYPE
 ,IZNOS_PDV_P IN t_rnkase_pro.iznos%TYPE
 ,IZNOS_PPOT_P IN t_rnkase_pro.iznos%TYPE
 ,IZNOS_POPUST_P IN t_rnkase_pro.iznos%type
 ,IZNOS_P IN t_rnkase_pro.iznos%type
 ,IZNOS_MARZE_P IN t_rnkase_pro.iznos_marze%TYPE
 ,IZNOS_PDV_MARZE_P IN t_rnkase_pro.iznos_pdv_marze%TYPE
 ,STOPA_PDV_MARZE_P IN t_rnkase_pro.stopa_pdv_marze%TYPE
 )
 IS
CURSOR pro_id_C (pro_id_p NUMBER, datum_p DATE) IS
      SELECT pro.gpor_id,
             pro.gknji_id,
             pro.gtehpro_id,
             vpispp.vpispz_id,
             pro.zad_nab_cijena,
             pro.pros_nab_cijena
        FROM m_proizvodi pro,
             m_gporez gpor,
             mgas_gpor_raz gporraz,
             s_vpisporukap vpispp,
             s_vpisporukaz vpispz
       WHERE pro.id = pro_id_p
         AND pro.gpor_id   = gpor.ID
         AND gpor.ID = gporraz.gpor_id
         AND datum_p BETWEEN gporraz.dat_valjan AND NVL(gporraz.dat_ponisten, SYSDATE)
         AND gporraz.vpispp_id   = vpispp.id
         AND vpispp.vpispz_id   = vpispz.id;

   CURSOR kase_id_c (rn_id_p NUMBER) IS
     SELECT kase_id, datum
       FROM t_rnkase
      WHERE id = rn_id_p;

   /* Nain potronje  ne aljmo, dogovorno je samo 1  */
    CURSOR mt_id_c (kase_id_l NUMBER, pro_id_p NUMBER) IS
     SELECT asokase.mt_id
       FROM m_aso_kase asokase
      WHERE kase_id = kase_id_l
        AND pro_id  = pro_id_p;

  gpor_id_l         t_rnkase_pro.gpor_id%type;
  gknji_id_l        t_rnkase_pro.gknji_id%TYPE;
  gtehpro_id_l      t_rnkase_pro.gtehpro_id%TYPE;
  mt_id_l           m_mt.id%type;
  vpispz_id_l       t_rnkase_pro.vpispz_id%type;
  pros_nab_cijena_l m_proizvodi.pros_nab_cijena%type;
  zad_nab_cijena_l  m_proizvodi.zad_nab_cijena%type;
  kase_id_l         t_rnkase.kase_id%TYPE;
 datum_l  t_rnkase.datum%TYPE;
BEGIN
  OPEN kase_id_C (rn_id_p);
    FETCH kase_id_c INTO kase_id_l, datum_l;
  CLOSE kase_id_c;
  
  OPEN pro_id_c (pro_id_p,  datum_l);
    FETCH pro_id_C INTO  gpor_id_l, gknji_id_l, gtehpro_id_l,vpispz_id_l, zad_nab_cijena_l, pros_nab_cijena_l;
  CLOSE pro_id_c;

  IF gpor_id_l IS NULL THEN
    RAISE_APPLICATION_ERROR (-20000, 'U GAS ne postoji proizvod sa ID: ' || pro_id_p);
  END IF;

  OPEN mt_id_C (kase_id_l, pro_id_p);
    FETCH mt_id_C INTO mt_id_l;
  CLOSE mt_id_c;
  
  IF mt_id_l IS NULL THEN
    RAISE_APPLICATION_ERROR (-20000, 'Proizvod sa ID: ' || pro_id_p || ' nije u GAS asortimanu kase sa ID: ' || kase_id_l);
  END IF;
  
  INSERT INTO t_rnkase_pro
     (rn_id, rbr_stavke, pro_id, sifgr_id, gpor_id, gknji_id, gtehpro_id, mt_id,
      kolicina, cijena, pdv, ppot, iznos_popust, iznos, iznos_pdv,
      iznos_ppot, zad_nab_cijena, pros_nab_cijena, vpispz_id,
      iznos_marze, iznos_pdv_marze, stopa_pdv_marze)
    VALUES
      (rn_id_p,  rbr_stavke_p, pro_id_p, NULL, gpor_id_l, gknji_id_l, gtehpro_id_l, mt_id_l,
       kolicina_p, cijena_p, stopa_pdv_p, stopa_ppot_p, iznos_popust_p, iznos_p, iznos_pdv_p,
       iznos_ppot_p, zad_nab_cijena_l, pros_nab_cijena_l,  vpispz_id_l,
       iznos_marze_p, iznos_pdv_marze_p, stopa_pdv_marze_p); 
       
  /* izmjena JF 03.12.2018 aurira izn_placanja iz iznosa stavaka u T_RNKASE za isti rn_id_p  */ 
  UPDATE t_rnkase t
     SET t.izn_placanja = t.izn_placanja + iznos_p
   WHERE t.id = rn_id_p;     
END;
PROCEDURE DELETE_RACUN_STAVKE_BY_KASE
 (GODINA_P IN t_rnkase.godina%TYPE
 ,KASE_ID_P IN mgmp_kase.id%TYPE
 )
 IS
BEGIN
  /* TEST*/
  FOR rn_kase IN  (
   SELECT t.id,
          t.godina,
          t.kase_id,
          t.rbr,
          t.datum,
          t.vpla_id ,
          t.zastitni_kod AS zki,
          t.jir,
          t.paragon AS opera_podaci
     FROM t_rnkase t
    WHERE t.godina = godina_p
      AND t.kase_id  = kase_id_p
  )
  LOOP
    DELETE FROM t_rnkase_pro WHERE rn_id = rn_kase.id;
    DELETE FROM t_rnkase WHERE id = rn_kase.id;
  END LOOP;

END;
PROCEDURE DELETE_RACUN_STAVKE_BY_ID
 (RN_ID t_rnkase.id%TYPE
 )
 IS
BEGIN
  /* TEST*/
  DELETE FROM t_rnkase_pro WHERE rn_id = rn_id;
  DELETE FROM t_rnkase WHERE id = rn_id;
END;
PROCEDURE UCITAJ_NAPOJNICU
 (GODINA_P IN VARCHAR2
 ,KASE_ID_P IN T_RNKASE.KASE_ID%TYPE
 ,RBR_P IN T_RNKASE.RBR%TYPE
 ,VPLA_NAPOJNICE_ID_P IN T_RNKASE.VPLA_NAPOJNICE_ID%TYPE
 ,IZN_NAPOJNICE_P IN T_RNKASE.IZN_NAPOJNICE%TYPE
 ,DATUM_NAPOJNICE_P IN T_RNKASE.DATUM_NAPOJNICE%TYPE
 ,KON_PODACI_P OUT VARCHAR2
 )
 IS
 rn_id_l t_rnkase.id%TYPE;
 ozn_prijepisa_l t_rnkase.ozn_prijepisa%TYPE;
 kase_sifra_l m_kase.sifra%TYPE;
 kon_id_l m_konobari.id%TYPE;
 kon_podaci_l VARCHAR2(100);
 ozn_irn_l s_vplacanja.ozn_irn%TYPE;
BEGIN
    SELECT rn.id, ozn_prijepisa, kase.sifra, kon.sifra || ' ' || kon.ime_prezime || ' ' || kon.oib kon_podaci, vpla.ozn_irn
      INTO rn_id_l, ozn_prijepisa_l, kase_sifra_l, kon_podaci_l, ozn_irn_l
      FROM t_rnkase rn,
           m_kase kase,
           m_konobari kon,
           s_vplacanja vpla
     WHERE rn.godina = godina_p
       AND rn.kase_id = kase_id_p
       AND rn.rbr = LPAD(rbr_p, 6,'0')
       AND rn.kase_id = kase.id
       AND rn.kon_id = kon.id 
       AND rn.vpla_id = vpla.id
       AND kase.metapl_sifra = 'VGE';

    /*
       Ako je napojnica ve poslana u Operu ne moe se raditi uitavanje napojnice
    */
    IF ozn_prijepisa_l = 'V' AND ozn_irn_l IS NULL THEN
       gas_zaj.vrati_poruku (-20518);
    END IF;
   
    IF ozn_irn_l IS NULL THEN
      ozn_prijepisa_l := 'P';
    ELSE
      ozn_prijepisa_l := NULL;
    END IF;
    
    UPDATE t_rnkase
       SET vpla_napojnice_id = vpla_napojnice_id_p,
           izn_napojnice     = izn_napojnice_p,
           datum_napojnice   = datum_napojnice_p,
           ozn_prijepisa     = ozn_prijepisa_l
     WHERE id = rn_id_l;
     
      kon_podaci_p := kon_podaci_l;

    EXCEPTION
     /* VGE raun #0 - #1 - #2 ne postoji. */
     WHEN NO_DATA_FOUND THEN
       SELECT sifra INTO kase_sifra_l
         FROM m_kase
        WHERE id = kase_id_p;
       gas_zaj.vrati_poruku (-20519 , godina_p, kase_sifra_l, rbr_p);

kon_podaci_p := kon_podaci_l;
END;
FUNCTION R_SO
 RETURN SYS_REFCURSOR
 IS


 l_rc SYS_REFCURSOR;
BEGIN    
    
 OPEN l_rc FOR  
 SELECT oj.id, oj.sifra, oj.naziv, oppro.tcpip AS  OPERA_URL_ADRESA, oppro.izmjena_dat AS izmjena_dat
      FROM m_oj oj,
           mzmp_ojr zmpojr,
           mop_proxy oppro
     WHERE oj.id = zmpojr.id
       AND TRUNC (SYSDATE) BETWEEN zmpojr.dat_valjan AND (NVL (zmpojr.dat_ponisten, TO_DATE ('31.12.9999', 'DD.MM.RRRR')) - 1)
       AND zmpojr.metcvor_sifra IS NOT NULL
       AND zmpojr.id = oppro.zmpojr_id
     ORDER BY oj.sifra;

  RETURN l_rc;
END;
FUNCTION R_T_RNKASE
 (ID_P T_RNKASE.ID%TYPE
 )
 RETURN SYS_REFCURSOR
 IS
l_rc SYS_REFCURSOR;
BEGIN
/* Podaci za sustav MPD */
  OPEN l_rc FOR
    SELECT nac.sifra    AS nac_sifra,
           vpla.sifra   AS vpla_sifra,
           vpla.naziv   AS vpla_naziv,
           kase.sifra   AS kase_sifra,
           kase.naziv   AS kase_naziv,
           oj.sifra     AS poslovni_prostor,
           vlasnik.oib  AS oib,
           (izn_placanja + NVL(izn_placanja2,0)) AS total_rnk
      FROM t_rnkase rn, 
           m_nacpot nac,
           s_vplacanja vpla,
           m_kase kase,
           m_oj oj,
           s_vlasnik vlasnik
     WHERE rn.id = id_p
       AND rn.nac_id = nac.id
       AND rn.vpla_id = vpla.id
       AND rn.kase_id = kase.id
       AND kase.zmpojr_id = oj.id;
  RETURN l_rc;
END;
FUNCTION R_T_RNKASE_PRO
 (ID_P T_RNKASE.ID%TYPE
 )
 RETURN SYS_REFCURSOR
 IS
l_rc SYS_REFCURSOR;
BEGIN 
 /* Podaci za sustav MPD */
 OPEN l_rc FOR
      SELECT rnpro.id                                 AS id,
          rnpro.rbr_stavke                         AS rbr_stavke,
          pro.sifra                                AS sifra_proizvoda,
          pro.naziv                                AS naziv_proizvoda,
          mt.sifra                                 AS sifra_mt,
          mt.naziv                                 AS naziv_mt,
          gpor.sifra                               AS gpor_sifra,
          gpor.naziv                               AS gpor_naziv,
         (rnpro.iznos - rnpro.iznos_pnaknade - rnpro.iznos_pdv - rnpro.iznos_ppot) AS osnovica,
          pra_pos_gas.br_subtotal (UPPER (SUBSTR (gknji.naziv, 1, 2)) || ' '|| rnpro.pdv || '+' || rnpro.ppot) AS subtotal,
          vpispz.sifra                             AS sifra_isporuke,
          vpispz.naziv                             AS naziv_isporuke,
          gknji.sifra                              AS sifra_gknjigo,
          gknji.naziv                              AS naziv_gknjigo,
          gtehpro.sifra                            AS sifra_gtehpro,
          gtehpro.naziv                            AS naziv_gtehpro,
          kpd.sifra                                AS kpd_sifra
     FROM t_rnkase_pro rnpro,
          m_proizvodi pro,
          m_mt mt,
          m_gporez gpor,
          m_gknjigo gknji,
          s_vpisporukaz vpispz,
          m_gtehpro gtehpro,
          s_kpd kpd
    WHERE rnpro.rn_id = id_p
      AND rnpro.pro_id = pro.id 
      AND rnpro.mt_id = mt.id
      AND rnpro.gpor_id = gpor.id
      AND rnpro.gknji_id = gknji.id
      AND rnpro.vpispz_id = vpispz.id
      AND rnpro.gtehpro_id = gtehpro.id (+)
      AND pro.kpd_id = kpd.id(+)
    UNION ALL
   SELECT rnpro.id                                 AS id,
          rnpro.rbr_stavke                         AS rbr_stavke,
          sifgr.sif_proizvoda_kasa AS sifra_proizvoda,
          sifgr.naziv              AS naziv_proizvoda,
          mt.sifra                                 AS sifra_mt,
          mt.naziv                                 AS naziv_mt,
          gpor.sifra                               AS gpor_sifra,
          gpor.naziv                               AS gpor_naziv,
         (rnpro.iznos - rnpro.iznos_pnaknade - rnpro.iznos_pdv - rnpro.iznos_ppot) AS osnovica,
          pra_pos_gas.br_subtotal (UPPER (SUBSTR (gknji.naziv, 1, 2)) || ' '|| rnpro.pdv || '+' || rnpro.ppot) AS subtotal,
          vpispz.sifra                             AS sifra_isporuke,
          vpispz.naziv                             AS naziv_isporuke,
          gknji.sifra                              AS sifra_gknjigo,
          gknji.naziv                              AS naziv_gknjigo,
          gtehpro.sifra                            AS sifra_gtehpro,
          gtehpro.naziv                            AS naziv_gtehpro,
          kpd.sifra                                AS kpd_sifra
     FROM t_rnkase_pro rnpro,
          m_sif_grupa sifgr,
          m_mt mt,
          m_gporez gpor,
          m_gknjigo gknji,
          s_vpisporukaz vpispz,
          m_gtehpro gtehpro,
          s_kpd kpd
    WHERE rnpro.rn_id = id_p
      AND rnpro.sifgr_id = sifgr.id
      AND rnpro.mt_id = mt.id
      AND rnpro.gpor_id = gpor.id
      AND rnpro.gknji_id = gknji.id
      AND rnpro.vpispz_id = vpispz.id
      AND rnpro.gtehpro_id = gtehpro.id (+)
      AND sifgr.kpd_id = kpd.id(+);
  RETURN l_rc;
END;
END;
/
SHOW ERROR

