PROMPT Creating View 'V_PSPP_RACUNI_CVOR'
CREATE OR REPLACE FORCE VIEW V_PSPP_RACUNI_CVOR
 (POD_SIFRA
 ,OZNAKA
 ,GOD_POSLOVNA
 ,OJ_SIFRA
 ,VAPLDOK_OZNAKA
 ,RBR
 ,ID
 ,RAC_ID
 ,DATUM
 ,IZNOS
 ,SO_SIFRA
 ,KD_SIFRA
 ,POSRED_SIFRA
 ,AGE_SIFRA
 ,KONTO
 ,STOPA_ZKAMATE
 ,VAL_SIFRA
 ,DAT_DOSPIJECA
 ,DAT_NOBVEZE
 ,IZN_PREDUJMA
 ,IZN_ODBITKA
 ,IZN_TECAJA
 ,IZN_DOMVAL
 ,IZN_BP
 ,IZN_OSN_1
 ,IZN_OSN_1_RACVAL
 ,IZN_OSN_2
 ,IZN_OSN_2_RACVAL
 ,IZN_OSN_3
 ,IZN_OSN_3_RACVAL
 ,IZN_OSN_4
 ,IZN_OSN_4_RACVAL
 ,IZN_OSN_5
 ,IZN_OSN_5_RACVAL
 ,IZN_OSN_OST
 ,IZN_OSN_OST_RACVAL
 ,IZN_PDV_3
 ,IZN_PDV_3_RACVAL
 ,IZN_PDV_4
 ,IZN_PDV_4_RACVAL
 ,IZN_PDV_5
 ,IZN_PDV_5_RACVAL
 ,IZN_PDV_OST
 ,IZN_PDV_OST_RACVAL
 ,IZN_PPOT
 ,IZN_PPOT_RACVAL
 ,POZIV_NA_BROJ
 ,STOPA_POPUSTA1
 ,IZN_POPUSTA1
 ,STOPA_POPUSTA2
 ,IZN_POPUSTA2
 ,STOPA_POPUSTA3
 ,IZN_POPUSTA3
 ,STOPA_POPUSTA4
 ,IZN_POPUSTA4
 ,UGO_GOD_POSLOVNA
 ,UGO_SO_SIFRA
 ,UGO_RBR
 ,OSTALO
 ,OSTALO2
 ,OSTALO3
 ,GLAVNI_RACUN
 ,BROJ_RACUNA
 ,STOPA_PROVIZIJE
 ,IZN_PROVIZIJE
 ,STOPA_PDV_PROVIZIJE
 ,IZN_PDV_PROVIZIJE
 ,KD_BR_POREZNI
 ,IZN_PNAKNADE
 ,IZN_PNAKNADE_RACVAL
 ,UNOS_DAT)
 AS SELECT pod_sifra,
  oznaka,
  god_poslovna,
  oj_sifra,
  vapldok_oznaka,
  rbr,
  id,
  rac_id,
  datum,
  iznos,
  so_sifra,
  kd_sifra,
  posred_sifra,
  age_sifra,
  konto,
  stopa_zkamate,
  val_sifra,
  dat_dospijeca,
  dat_nobveze,
  izn_predujma,
  izn_odbitka,
  izn_tecaja,
  izn_domval,
  izn_bp,
  izn_osn_1,
  izn_osn_1_racval,
  izn_osn_2,
  izn_osn_2_racval,
  izn_osn_3,
  izn_osn_3_racval,
  izn_osn_4,
  izn_osn_4_racval,
  izn_osn_5,
  izn_osn_5_racval,
  izn_osn_ost,
  izn_osn_ost_racval,
  izn_pdv_3,
  izn_pdv_3_racval,
  izn_pdv_4,
  izn_pdv_4_racval,
  izn_pdv_5,
  izn_pdv_5_racval,
  izn_pdv_ost,
  izn_pdv_ost_racval,
  izn_ppot,
  izn_ppot_racval,
  poziv_na_broj,
  stopa_popusta1,
  izn_popusta1,
  stopa_popusta2,
  izn_popusta2,
  stopa_popusta3,
  izn_popusta3,
  stopa_popusta4,
  izn_popusta4,
  TO_CHAR (NULL) AS ugo_god_poslovna, -- IRN 3332, ostaje iako je auriranje ugovora zabranjeno 2011. godine
  TO_CHAR (NULL) AS ugo_so_sifra,
  TO_CHAR (NULL) AS ugo_rbr,
  ostalo,
  ostalo2,
  ostalo3,
  glavni_racun,
  broj_racuna,
  stopa_provizije,
  izn_provizije,
  stopa_pdv_provizije,
  izn_pdv_provizije,
  kd_br_porezni,
  izn_pnaknade,
  izn_pnaknade_racval,
  unos_dat -- IRN 4096
FROM (
  -- dokumenti iz rec.t_racuni
  (
  SELECT ALL
    pra_rec_zaj.vrijednost_parametra ('0023') AS pod_sifra,
    'RAC' AS oznaka,
    rac.god_poslovna AS god_poslovna,
    rac.oj_sifra AS oj_sifra,
    vapldok.oznaka AS vapldok_oznaka,
    rac.rbr AS rbr,
    rac.id AS id,
    rac.rac_id AS rac_id,
    rac.datum AS datum,
    rac.iznos + pra_rec_s2.izn_predujma_racval (rac.id, rac.izn_tecaja)
    AS iznos,
    so.sifra AS so_sifra,
    kd.kd_sifra AS kd_sifra,
    posred.sifra AS posred_sifra,
    age.sifra AS age_sifra,
    pra_zmp_s.konto (rac.vdok_id, age.gkage_id, DECODE (rac.agep_id, NULL, NULL, posred.gkage_id), rac.vpdog_id, rac.val_id) AS konto,
    rac.stopa_zkamate AS stopa_zkamate,
    val.sifra_3n AS val_sifra,
    rac.dat_dospijeca AS dat_dospijeca,
    rac.dat_nobveze AS dat_nobveze,
    pra_rec_s2.izn_predujma_racval (rac.id, rac.izn_tecaja) AS izn_predujma,
    NVL (rac.izn_smjesta, 0) + NVL (rac.izn_popusta1, 0) + NVL (rac.izn_popusta2, 0) + NVL (rac.izn_popusta3, 0) + NVL (rac.izn_popusta4, 0) AS izn_odbitka,
    rac.izn_tecaja AS izn_tecaja,
    ROUND (rac.iznos * rac.izn_tecaja + NVL (rac_pred.izn_predujma_domval, 0), 2) AS izn_domval,
    pra_rec_s2.izn_bp (rac.id, rac.izn_tecaja) AS izn_bp,
    rac_pdv_1.izn_osn_1 AS izn_osn_1,
    ROUND (rac_pdv_1.izn_osn_1 / rac.izn_tecaja, 2) AS izn_osn_1_racval,
    rac_pdv_2.izn_osn_2 AS izn_osn_2,
    ROUND (rac_pdv_2.izn_osn_2 / rac.izn_tecaja, 2) AS izn_osn_2_racval,
    rac_pdv_3.izn_osn_3 AS izn_osn_3,
    ROUND (rac_pdv_3.izn_osn_3 / rac.izn_tecaja, 2) AS izn_osn_3_racval,
    rac_pdv_4.izn_osn_4 AS izn_osn_4,
    ROUND (rac_pdv_4.izn_osn_4 / rac.izn_tecaja, 2) AS izn_osn_4_racval,
    rac_pdv_5.izn_osn_5 AS izn_osn_5,
    ROUND (rac_pdv_5.izn_osn_5 / rac.izn_tecaja, 2) AS izn_osn_5_racval,
    rac_pdv.izn_osnovice
      - NVL (rac_pdv_1.izn_osn_1, 0)
      - NVL (rac_pdv_2.izn_osn_2, 0)
      - NVL (rac_pdv_3.izn_osn_3, 0)
      - NVL (rac_pdv_4.izn_osn_4, 0)
      - NVL (rac_pdv_5.izn_osn_5, 0)
    AS izn_osn_ost,
    ROUND (
      (rac_pdv.izn_osnovice
      - NVL (rac_pdv_1.izn_osn_1, 0)
      - NVL (rac_pdv_2.izn_osn_2, 0)
      - NVL (rac_pdv_3.izn_osn_3, 0)
      - NVL (rac_pdv_4.izn_osn_4, 0)
      - NVL (rac_pdv_5.izn_osn_5, 0))
      / rac.izn_tecaja,
      2)
    AS izn_osn_ost_racval,
    rac_pdv_3.izn_pdv_3 AS izn_pdv_3,
    ROUND (rac_pdv_3.izn_pdv_3 / rac.izn_tecaja, 2) AS izn_pdv_3_racval,
    rac_pdv_4.izn_pdv_4 AS izn_pdv_4,
    ROUND (rac_pdv_4.izn_pdv_4 / rac.izn_tecaja, 2) AS izn_pdv_4_racval,
    rac_pdv_5.izn_pdv_5 AS izn_pdv_5,
    ROUND (rac_pdv_5.izn_pdv_5 / rac.izn_tecaja, 2) AS izn_pdv_5_racval,
    rac_pdv.izn_pdv
      - NVL (rac_pdv_3.izn_pdv_3, 0)
      - NVL (rac_pdv_4.izn_pdv_4, 0)
      - NVL (rac_pdv_5.izn_pdv_5, 0)
    AS izn_pdv_ost,
    ROUND (
      (rac_pdv.izn_pdv
      - NVL (rac_pdv_3.izn_pdv_3, 0)
      - NVL (rac_pdv_4.izn_pdv_4, 0)
      - NVL (rac_pdv_5.izn_pdv_5, 0))
      / rac.izn_tecaja,
      2)
    AS izn_pdv_ost_racval,
    pra_rec_s.izn_ppot (rac.id) AS izn_ppot,
    ROUND (pra_rec_s.izn_ppot (rac.id) / rac.izn_tecaja, 2) AS izn_ppot_racval,
    rac.poziv_na_broj AS poziv_na_broj,
    rac.stopa_popusta1 AS stopa_popusta1,
    rac.izn_popusta1 AS izn_popusta1,
    rac.stopa_popusta2 AS stopa_popusta2,
    rac.izn_popusta2 AS izn_popusta2,
    rac.stopa_popusta3 AS stopa_popusta3,
    rac.izn_popusta3 AS izn_popusta3,
    rac.stopa_popusta4 AS stopa_popusta4,
    rac.izn_popusta4 AS izn_popusta4,
    ms.sifra AS ostalo,
    pra_pka_i3fiskal.recrac_nacin_plac (rac.id) AS ostalo2,
    NULL AS ostalo3,
    rac.glavni_racun AS glavni_racun,
    -- TO_NUMBER (rac.rbr) || '-' || oj.sifra || '-' || vdok.sifra2n AS broj_racuna,
    pra_pka_s.br_racuna_fsus (rac.oj_sifra, rac.vdok_sifra2n, rac.rbr, rac.datum) AS broj_racuna,
    rac.stopa_provizije AS stopa_provizije,
    rac.izn_provizije AS izn_provizije,
    rac.stopa_pdv_provizije AS stopa_pdv_provizije,
    (rac.izn_provizije - ROUND (rac.izn_provizije * 100 / (100 + rac.stopa_pdv_provizije), 2)) AS izn_pdv_provizije,
    kd.kd_br_porezni AS kd_br_porezni,
    pra_rec_s5.izn_pnaknade_po (rac.id) AS izn_pnaknade,
    ROUND (pra_rec_s5.izn_pnaknade_po (rac.id) / rac.izn_tecaja, 2) AS izn_pnaknade_racval,
    rac.unos_dat
  FROM
    t_racuni rac,
    (
    SELECT
      age.id kd_id, age.sifra kd_sifra, DECODE (zem.sifra_2a, domzem_sifra, age.oib, age.br_porezni) kd_br_porezni
    FROM
      m_agencije age, s_zemlje zem, (SELECT pra_rec_zaj.vrijednost_parametra ('0002') domzem_sifra FROM dual) param
    WHERE
      age.zem_id = zem.id
    ) kd,
    s_vapldok vapldok,
    s_vdokumenata vdok,
    -- m_oj oj,
    m_agencije age,
    m_agencije posred,
    s_valute val,
    m_msegmenti ms,
    m_so so,
    -- rac_pred
    (
    SELECT
      t_rac_pred.rac_id AS rac_id,
      SUM (ROUND (t_rac_pred.iznos * t_rac_pred.izn_tecaja, 2)) AS izn_predujma_domval
    FROM
      t_rac_pred
    GROUP BY
      t_rac_pred.rac_id
    ) rac_pred,
    -- rac_pdv
    (
    SELECT
      i_rac_pdv.rac_id AS rac_id,
      SUM (ROUND (i_rac_pdv.iznos, 2)) AS izn_osnovice,
      SUM (ROUND (i_rac_pdv.iznos * (100 + stopa_pdv) / 100, 2) - ROUND (i_rac_pdv.iznos, 2)) AS izn_pdv
    FROM
      i_rac_pdv
    GROUP BY
      i_rac_pdv.rac_id
    ) rac_pdv,
    -- rac_pdv_1 - ne podlijee oporezivanju
    (
    SELECT
      i_rac_pdv.rac_id AS rac_id,
      SUM (ROUND (i_rac_pdv.iznos, 2)) AS izn_osn_1
    FROM
      i_rac_pdv
    WHERE
      vpispz_id IN (
      SELECT vpisp.id
        FROM s_vpisporukaz vpisp, szmp_spisporuka zmpspisp, szmp_spknjiga zmpspknj
       WHERE zmpspknj.sifra = '10'
         AND vpisp.zmpspisp_id = zmpspisp.id
         AND zmpspisp.zmpspknj_id = zmpspknj.id)
    GROUP BY
      i_rac_pdv.rac_id
    ) rac_pdv_1,
    -- rac_pdv_2 - oporezivo po stopi od 0%
    (
    SELECT
      i_rac_pdv.rac_id AS rac_id,
      SUM (ROUND (i_rac_pdv.iznos, 2)) AS izn_osn_2
    FROM
      i_rac_pdv
    WHERE
      vpispz_id IN (
      SELECT vpisp.id
        FROM s_vpisporukaz vpisp, szmp_spisporuka zmpspisp, szmp_spknjiga zmpspknj
       WHERE zmpspknj.sifra = '20'
         AND vpisp.zmpspisp_id = zmpspisp.id
         AND zmpspisp.zmpspknj_id = zmpspknj.id)
    GROUP BY
      i_rac_pdv.rac_id
    ) rac_pdv_2,
    -- rac_pdv_3 - oporezivo po stopi od 10%
    (
    SELECT
      i_rac_pdv.rac_id AS rac_id,
      SUM (ROUND (i_rac_pdv.iznos, 2)) AS izn_osn_3,
      SUM (ROUND (i_rac_pdv.iznos * (100 + stopa_pdv) / 100, 2) - ROUND (i_rac_pdv.iznos, 2)) AS izn_pdv_3
    FROM
      i_rac_pdv
    WHERE
      vpispz_id IN (
      SELECT vpisp.id
        FROM s_vpisporukaz vpisp, szmp_spisporuka zmpspisp, szmp_spknjiga zmpspknj
       WHERE zmpspknj.sifra = '30'
         AND vpisp.zmpspisp_id = zmpspisp.id
         AND zmpspisp.zmpspknj_id = zmpspknj.id)
    GROUP BY
      i_rac_pdv.rac_id
    ) rac_pdv_3,
    -- rac_pdv_4 - oporezivo po stopi od 22%
    (
    SELECT
      i_rac_pdv.rac_id AS rac_id,
      SUM (ROUND (i_rac_pdv.iznos, 2)) AS izn_osn_4,
      SUM (ROUND (i_rac_pdv.iznos * (100 + stopa_pdv) / 100, 2) - ROUND (i_rac_pdv.iznos, 2)) AS izn_pdv_4
    FROM
      i_rac_pdv
    WHERE
      vpispz_id IN (
      SELECT vpisp.id
        FROM s_vpisporukaz vpisp, szmp_spisporuka zmpspisp, szmp_spknjiga zmpspknj
       WHERE zmpspknj.sifra = '40'
         AND vpisp.zmpspisp_id = zmpspisp.id
         AND zmpspisp.zmpspknj_id = zmpspknj.id)
    GROUP BY
      i_rac_pdv.rac_id
    ) rac_pdv_4,
    -- rac_pdv_5 - oporezivo po stopi od 23%
    (
    SELECT
      i_rac_pdv.rac_id AS rac_id,
      SUM (ROUND (i_rac_pdv.iznos, 2)) AS izn_osn_5,
      SUM (ROUND (i_rac_pdv.iznos * (100 + stopa_pdv) / 100, 2) - ROUND (i_rac_pdv.iznos, 2)) AS izn_pdv_5
    FROM
      i_rac_pdv
    WHERE
      vpispz_id IN (
      SELECT vpisp.id
        FROM s_vpisporukaz vpisp, szmp_spisporuka zmpspisp, szmp_spknjiga zmpspknj
       WHERE zmpspknj.sifra = '50'
         AND vpisp.zmpspisp_id = zmpspisp.id
         AND zmpspisp.zmpspknj_id = zmpspknj.id)
    GROUP BY
      i_rac_pdv.rac_id
    ) rac_pdv_5
  WHERE
    vapldok.id = rac.vapldok_id
    -- AND vapldok.oznaka = 'BI'
    AND rac.vdok_id = vdok.id
    AND kd.kd_id(+) = pra_rec2.agekupac_id (rac.vdok_id, rac.age_id, rac.agep_id, rac.vpdog_id)
    AND vdok.ozn_fin = -1
    -- AND oj.id = rac.oj_id
    AND so.id = rac.so_id
    AND age.id (+) = rac.age_id
    AND posred.id (+) = pra_rec2.agek_id (rac.age_id, rac.agep_id)
    AND val.id = rac.val_id
    AND rac_pred.rac_id(+) = rac.id
    AND rac_pdv.rac_id(+) = rac.id
    AND rac_pdv_1.rac_id(+) = rac.id
    AND rac_pdv_2.rac_id(+) = rac.id
    AND rac_pdv_3.rac_id(+) = rac.id
    AND rac_pdv_4.rac_id(+) = rac.id
    AND rac_pdv_5.rac_id(+) = rac.id
    AND rac.ms_id = ms.id(+)
    AND rac.datum >= TRUNC(SYSDATE) - (SELECT pra_pka_zaj.vrijednost_parametra ('1062') FROM dual))
  UNION ALL
  -- dokumenti iz pka.tpka_racuni
  (
  SELECT ALL
    pra_rec_zaj.vrijednost_parametra ('0023') AS pod_sifra,
    'PKARAC' AS oznaka,
    rac.god_poslovna AS god_poslovna,
    rac.oj_sifra AS oj_sifra,
    vapldok.oznaka AS vapldok_oznaka,
    rac.rbr AS rbr,
    rac.id AS id,
    rac.pkarac_id AS rac_id,
    rac.datum AS datum,
    rac.iznos + pra_pka_s.izn_predujma_racval (rac.id, rac.izn_tecaja) AS iznos,
    NULL AS so_sifra,
    gmpkom.kd_sifra AS kd_sifra,
    NULL AS posred_sifra,
    NULL AS age_sifra,
    pra_zmp_s.konto (rac.vdok_id, gmpkom.gkage_id, NULL, rac.vpdog_id, rac.val_id) AS konto,
    rac.stopa_zkamate AS stopa_zkamate,
    val.sifra_3n AS val_sifra,
    rac.dat_dospijeca AS dat_dospijeca,
    rac.dat_nobveze AS dat_nobveze,
    pra_pka_s.izn_predujma_racval (rac.id, rac.izn_tecaja) AS izn_predujma,
    NVL (rac.izn_smjesta, 0)
      + NVL (rac.izn_popusta, 0)
      + NVL (rac.izn_provizije, 0)
    AS izn_odbitka,
    rac.izn_tecaja AS izn_tecaja,
    ROUND (rac.iznos * rac.izn_tecaja + NVL (rac_pred.izn_predujma_domval, 0), 2) AS izn_domval,
    TO_NUMBER (NULL) AS izn_bp,
    rac_pdv_1.izn_osn_1 AS izn_osn_1,
    ROUND (rac_pdv_1.izn_osn_1 / rac.izn_tecaja, 2) AS izn_osn_1_racval,
    rac_pdv_2.izn_osn_2 AS izn_osn_2,
    ROUND (rac_pdv_2.izn_osn_2 / rac.izn_tecaja, 2) AS izn_osn_2_racval,
    rac_pdv_3.izn_osn_3 AS izn_osn_3,
    ROUND (rac_pdv_3.izn_osn_3 / rac.izn_tecaja, 2) AS izn_osn_3_racval,
    rac_pdv_4.izn_osn_4 AS izn_osn_4,
    ROUND (rac_pdv_4.izn_osn_4 / rac.izn_tecaja, 2) AS izn_osn_4_racval,
    rac_pdv_5.izn_osn_5 AS izn_osn_5,
    ROUND (rac_pdv_5.izn_osn_5 / rac.izn_tecaja, 2) AS izn_osn_5_racval,
    rac_pdv.izn_osnovice
      - NVL (rac_pdv_1.izn_osn_1, 0)
      - NVL (rac_pdv_2.izn_osn_2, 0)
      - NVL (rac_pdv_3.izn_osn_3, 0)
      - NVL (rac_pdv_4.izn_osn_4, 0)
      - NVL (rac_pdv_5.izn_osn_5, 0)
    AS izn_osn_ost,
    ROUND (
      (rac_pdv.izn_osnovice
      - NVL (rac_pdv_1.izn_osn_1, 0)
      - NVL (rac_pdv_2.izn_osn_2, 0)
      - NVL (rac_pdv_3.izn_osn_3, 0)
      - NVL (rac_pdv_4.izn_osn_4, 0)
      - NVL (rac_pdv_5.izn_osn_5, 0))
      / rac.izn_tecaja,
      2)
    AS izn_osn_ost_racval,
    rac_pdv_3.izn_pdv_3 AS izn_pdv_3,
    ROUND (rac_pdv_3.izn_pdv_3 / rac.izn_tecaja, 2) AS izn_pdv_3_racval,
    rac_pdv_4.izn_pdv_4 AS izn_pdv_4,
    ROUND (rac_pdv_4.izn_pdv_4 / rac.izn_tecaja, 2) AS izn_pdv_4_racval,
    rac_pdv_5.izn_pdv_5 AS izn_pdv_5,
    ROUND (rac_pdv_5.izn_pdv_5 / rac.izn_tecaja, 2) AS izn_pdv_5_racval,
    rac_pdv.izn_pdv
      - NVL (rac_pdv_3.izn_pdv_3, 0)
      - NVL (rac_pdv_4.izn_pdv_4, 0)
      - NVL (rac_pdv_5.izn_pdv_5, 0)
    AS izn_pdv_ost,
    ROUND (
      (rac_pdv.izn_pdv
      - NVL (rac_pdv_3.izn_pdv_3, 0)
      - NVL (rac_pdv_4.izn_pdv_4, 0)
      - NVL (rac_pdv_5.izn_pdv_5, 0))
      / rac.izn_tecaja,
      2)
    AS izn_pdv_ost_racval,
    pra_pka_s.izn_ppot_po (rac.id) AS izn_ppot,
    ROUND ((pra_pka_s.izn_ppot_po (rac.id)) / rac.izn_tecaja, 2) AS izn_ppot_racval,
    rac.poziv_na_broj AS poziv_na_broj,
    rac.stopa_popusta AS stopa_popusta1,
    rac.izn_popusta AS izn_popusta1,
    TO_NUMBER (NULL) AS stopa_popusta2,
    TO_NUMBER (NULL) AS izn_popusta2,
    TO_NUMBER (NULL) AS stopa_popusta3,
    TO_NUMBER (NULL) AS izn_popusta3,
    rac.stopa_provizije AS stopa_popusta4,
    rac.izn_provizije AS izn_popusta4,
    ms.sifra AS ostalo,
    pra_pka_i3fiskal.pkarac_nacin_plac (rac.id) AS ostalo2,
    NULL AS ostalo3,
    NULL AS glavni_racun,
    -- TO_NUMBER (rac.rbr) || '-' || oj.sifra || '-' || vdok.sifra2n AS broj_racuna,
    pra_pka_s.br_racuna_fsus (rac.oj_sifra, rac.vdok_sifra2n, rac.rbr, rac.datum) AS broj_racuna,
    NULL AS stopa_provizije,
    NULL AS izn_provizije,
    NULL AS stopa_pdv_provizije,
    NULL AS izn_pdv_provizije,
    gmpkom.kd_br_porezni AS kd_br_porezni,
    pra_pka_s.izn_pnaknade_po (rac.id) AS izn_pnaknade,
    ROUND ((pra_pka_s.izn_pnaknade_po (rac.id)) / rac.izn_tecaja, 2) AS izn_pnaknade_racval,
    rac.unos_dat
  FROM
    tpka_racuni rac,
    s_vapldok vapldok,
    s_vdokumenata vdok,
    -- m_oj oj,
    -- mgmp_komitenti gmpkom,
    m_msegmenti ms,
    (
    SELECT
      kom.id, kom.sifra kd_sifra, kom.gkage_id, DECODE (zem.sifra_2a, domzem_sifra, kom.oib, kom.br_porezni) kd_br_porezni
    FROM
      mgmp_komitenti kom, s_zemlje zem, (SELECT pra_rec_zaj.vrijednost_parametra ('0002') domzem_sifra FROM dual) param
    WHERE
      kom.zem_id = zem.id
    ) gmpkom,
    s_valute val,
    -- rac_pred
    (
    SELECT
      tpka_rac_pred.pkarac_id AS rac_id,
      SUM (ROUND (tpka_rac_pred.iznos * tpka_rac_pred.izn_tecaja, 2)) AS izn_predujma_domval
    FROM
      tpka_rac_pred
    GROUP BY
      tpka_rac_pred.pkarac_id
    ) rac_pred,
    -- rac_pdv
    (
    SELECT
      ipka_rac_pdv.pkarac_id AS rac_id,
      SUM (ROUND (ipka_rac_pdv.iznos, 2)) AS izn_osnovice,
      SUM (ROUND (ipka_rac_pdv.iznos * (100 + stopa_pdv) / 100, 2) - ROUND (ipka_rac_pdv.iznos, 2)) AS izn_pdv
    FROM
      ipka_rac_pdv
    GROUP BY
      ipka_rac_pdv.pkarac_id
    ) rac_pdv,
    -- rac_pdv_1 - ne podlijee oporezivanju
    (
    SELECT
      ipka_rac_pdv.pkarac_id AS rac_id,
      SUM (ROUND (ipka_rac_pdv.iznos, 2)) AS izn_osn_1
    FROM
      ipka_rac_pdv
    WHERE
      vpispz_id IN (
      SELECT vpisp.id
        FROM s_vpisporukaz vpisp, szmp_spisporuka zmpspisp, szmp_spknjiga zmpspknj
       WHERE zmpspknj.sifra = '10'
         AND vpisp.zmpspisp_id = zmpspisp.id
         AND zmpspisp.zmpspknj_id = zmpspknj.id)
    GROUP BY
      ipka_rac_pdv.pkarac_id
    ) rac_pdv_1,
    -- rac_pdv_2 - oporezivo po stopi od 0%
    (
    SELECT
      ipka_rac_pdv.pkarac_id AS rac_id,
      SUM (ROUND (ipka_rac_pdv.iznos, 2)) AS izn_osn_2
    FROM
      ipka_rac_pdv
    WHERE
      vpispz_id IN (
      SELECT vpisp.id
        FROM s_vpisporukaz vpisp, szmp_spisporuka zmpspisp, szmp_spknjiga zmpspknj
       WHERE zmpspknj.sifra = '20'
         AND vpisp.zmpspisp_id = zmpspisp.id
         AND zmpspisp.zmpspknj_id = zmpspknj.id)
    GROUP BY
      ipka_rac_pdv.pkarac_id
    ) rac_pdv_2,
    -- rac_pdv_3 - oporezivo po stopi od 10%
    (
    SELECT
      ipka_rac_pdv.pkarac_id AS rac_id,
      SUM (ROUND (ipka_rac_pdv.iznos, 2)) AS izn_osn_3,
      SUM (ROUND (ipka_rac_pdv.iznos * (100 + stopa_pdv) / 100, 2) - ROUND (ipka_rac_pdv.iznos, 2)) AS izn_pdv_3
    FROM
      ipka_rac_pdv
    WHERE
      vpispz_id IN (
      SELECT vpisp.id
        FROM s_vpisporukaz vpisp, szmp_spisporuka zmpspisp, szmp_spknjiga zmpspknj
       WHERE zmpspknj.sifra = '30'
         AND vpisp.zmpspisp_id = zmpspisp.id
         AND zmpspisp.zmpspknj_id = zmpspknj.id)
    GROUP BY
      ipka_rac_pdv.pkarac_id
    ) rac_pdv_3,
    -- rac_pdv_4 - oporezivo po stopi od 22%
    (
    SELECT
      ipka_rac_pdv.pkarac_id AS rac_id,
      SUM (ROUND (ipka_rac_pdv.iznos, 2)) AS izn_osn_4,
      SUM (ROUND (ipka_rac_pdv.iznos * (100 + stopa_pdv) / 100, 2) - ROUND (ipka_rac_pdv.iznos, 2)) AS izn_pdv_4
    FROM
      ipka_rac_pdv
    WHERE
      vpispz_id IN (
      SELECT vpisp.id
        FROM s_vpisporukaz vpisp, szmp_spisporuka zmpspisp, szmp_spknjiga zmpspknj
       WHERE zmpspknj.sifra = '40'
         AND vpisp.zmpspisp_id = zmpspisp.id
         AND zmpspisp.zmpspknj_id = zmpspknj.id)
    GROUP BY
      ipka_rac_pdv.pkarac_id
    ) rac_pdv_4,
    -- rac_pdv_5 - oporezivo po stopi od 23%
    (
    SELECT
      ipka_rac_pdv.pkarac_id AS rac_id,
      SUM (ROUND (ipka_rac_pdv.iznos, 2)) AS izn_osn_5,
      SUM (ROUND (ipka_rac_pdv.iznos * (100 + stopa_pdv) / 100, 2) - ROUND (ipka_rac_pdv.iznos, 2)) AS izn_pdv_5
    FROM
      ipka_rac_pdv
    WHERE
      vpispz_id IN (
      SELECT vpisp.id
        FROM s_vpisporukaz vpisp, szmp_spisporuka zmpspisp, szmp_spknjiga zmpspknj
       WHERE zmpspknj.sifra = '50'
         AND vpisp.zmpspisp_id = zmpspisp.id
         AND zmpspisp.zmpspknj_id = zmpspknj.id)
    GROUP BY
      ipka_rac_pdv.pkarac_id
    ) rac_pdv_5
  WHERE
    vapldok.id = rac.vapldok_id
    -- AND vapldok.oznaka = 'BI'
    AND rac.vdok_id = vdok.id
    AND vdok.ozn_fin = -1
    -- AND oj.id = rac.oj_id
    AND gmpkom.id (+) = rac.gmpkom_id
    AND val.id = rac.val_id
    AND rac_pred.rac_id(+) = rac.id
    AND rac_pdv.rac_id(+) = rac.id
    AND rac_pdv_1.rac_id(+) = rac.id
    AND rac_pdv_2.rac_id(+) = rac.id
    AND rac_pdv_3.rac_id(+) = rac.id
    AND rac_pdv_4.rac_id(+) = rac.id
    AND rac_pdv_5.rac_id(+) = rac.id
    AND rac.ms_id = ms.id(+)
    AND rac.datum >= TRUNC(SYSDATE) - (SELECT pra_pka_zaj.vrijednost_parametra ('1062') FROM DUAL))
  UNION ALL
  -- OB dokumenti iz pka.tpka_obracuni
  (
  SELECT ALL
    pra_rec_zaj.vrijednost_parametra ('0023') AS pod_sifra,
    'PKAOBR' AS oznaka,
    pkaobr.god_poslovna AS god_poslovna,
    oj.sifra AS oj_sifra,
    'OB' AS vapldok_oznaka,
    pkaobr.rbr AS rbr,
    pkaobr.id AS id,
    pkaobr.pkaobr_id AS rac_id,
    pkaobr.datum AS datum,
    CASE
      WHEN pkaobr.ozn_ds IN ('S') AND NVL (pkaobr.val_s_id, pkaobr.val_id) <> pkaobr.val_id
      THEN
        ROUND (pkaobr.iznos * pkaobr.izn_tecaja / pkaobr.izn_tecaja_s, 2)
      ELSE
        pkaobr.iznos
      END
    AS iznos,
    NULL AS so_sifra,
    kom.kd_sifra AS kd_sifra,
    NULL AS posred_sifra,
    NULL AS age_sifra,
    CASE
      WHEN pkaobr.ozn_ds IN ('S') AND NVL (pkaobr.val_s_id, pkaobr.val_id) <> pkaobr.val_id
      THEN
        pra_zmp_s.konto_ob (kom.gkage_id, pkaobr.val_s_id)
      ELSE
        pra_zmp_s.konto_ob (kom.gkage_id, pkaobr.val_id)
      END
    AS konto,
    pkaobr.stopa_zkamate AS stopa_zkamate,
    CASE
      WHEN pkaobr.ozn_ds IN ('S') AND NVL (pkaobr.val_s_id, pkaobr.val_id) <> pkaobr.val_id
      THEN
        val_s.sifra_3n
      ELSE
        val.sifra_3n
      END
    AS val_sifra,
    pkaobr.dat_dospijeca AS dat_dospijeca,
    pkaobr.dat_nobveze AS dat_nobveze,
    TO_NUMBER (NULL) AS izn_predujma,
    TO_NUMBER (NULL) AS izn_odbitka,
    CASE
      WHEN pkaobr.ozn_ds IN ('S') AND NVL (pkaobr.val_s_id, pkaobr.val_id) <> pkaobr.val_id
      THEN
        pkaobr.izn_tecaja_s
      ELSE
        pkaobr.izn_tecaja
      END
    AS izn_tecaja,
    ROUND (pkaobr.iznos * pkaobr.izn_tecaja, 2) AS izn_domval,
    TO_NUMBER (NULL) AS izn_bp,
    TO_NUMBER (NULL) AS izn_osn_1,
    TO_NUMBER (NULL) AS izn_osn_1_racval,
    TO_NUMBER (NULL) AS izn_osn_2,
    TO_NUMBER (NULL) AS izn_osn_2_racval,
    TO_NUMBER (NULL) AS izn_osn_3,
    TO_NUMBER (NULL) AS izn_osn_3_racval,
    TO_NUMBER (NULL) AS izn_osn_4,
    TO_NUMBER (NULL) AS izn_osn_4_racval,
    TO_NUMBER (NULL) AS izn_osn_5,
    TO_NUMBER (NULL) AS izn_osn_5_racval,
    TO_NUMBER (NULL) AS izn_osn_ost,
    TO_NUMBER (NULL) AS izn_osn_ost_racval,
    TO_NUMBER (NULL) AS izn_pdv_3,
    TO_NUMBER (NULL) AS izn_pdv_3_racval,
    TO_NUMBER (NULL) AS izn_pdv_4,
    TO_NUMBER (NULL) AS izn_pdv_4_racval,
    TO_NUMBER (NULL) AS izn_pdv_5,
    TO_NUMBER (NULL) AS izn_pdv_5_racval,
    TO_NUMBER (NULL) AS izn_pdv_ost,
    TO_NUMBER (NULL) AS izn_pdv_ost_racval,
    TO_NUMBER (NULL) AS izn_ppot,
    TO_NUMBER (NULL) AS izn_ppot_racval,
    pkaobr.poziv_na_broj AS poziv_na_broj,
    TO_NUMBER (NULL) AS stopa_popusta1,
    TO_NUMBER (NULL) AS izn_popusta1,
    TO_NUMBER (NULL) AS stopa_popusta2,
    TO_NUMBER (NULL) AS izn_popusta2,
    TO_NUMBER (NULL) AS stopa_popusta3,
    TO_NUMBER (NULL) AS izn_popusta3,
    TO_NUMBER (NULL) AS stopa_popusta4,
    TO_NUMBER (NULL) AS izn_popusta4,
    pkaobr.ozn_ds AS ostalo,
    NULL AS ostalo2,
    NULL AS ostalo3,
    pkaobr.br_uredjaja AS glavni_racun,
    -- vdok.sifra2n || pkaobr.god_poslovna || '-' || pkaoj1.sifra || '-' || pkaobr.rbr AS broj_racuna,
    vdok.sifra2n || pkaobr.god_poslovna || '-' || oj.sifra || '-' || pkaobr.rbr AS broj_racuna,
    NULL AS stopa_provizije,
    NULL AS izn_provizije,
    NULL AS stopa_pdv_provizije,
    NULL AS izn_pdv_provizije,
    kom.kd_br_porezni AS kd_br_porezni,
    TO_NUMBER (NULL) AS izn_pnaknade,
    TO_NUMBER (NULL) AS izn_pnaknade_racval,
    pkaobr.unos_dat
  FROM
    tpka_obracuni pkaobr,
    s_vapldok vapldok,
    s_vdokumenata vdok,
    m_oj oj,
    -- m_oj pkaoj1,
    -- mgmp_komitenti kom,
    (
    SELECT
      kom.id, kom.sifra kd_sifra, kom.gkage_id, DECODE (zem.sifra_2a, domzem_sifra, kom.oib, kom.br_porezni) kd_br_porezni
    FROM
      mgmp_komitenti kom, s_zemlje zem, (SELECT pra_rec_zaj.vrijednost_parametra ('0002') domzem_sifra FROM dual) param
    WHERE
      kom.zem_id = zem.id
    ) kom,
    s_valute val,
    s_valute val_s
  WHERE
    pkaobr.zmpojr_id = oj.id
    AND vapldok.metapl_sifra = 'PKA'
    AND vapldok.oznaka = 'OB'
    AND vapldok.vdok_id = vdok.id
    AND vdok.ozn_fin = -1
    -- AND pkaobr.zmpojr_id = pkaoj1.id
    AND pkaobr.gmpkom_id = kom.id
    AND pkaobr.val_id = val.id
    AND pkaobr.val_s_id = val_s.id(+)
    AND pkaobr.datum >= TRUNC (SYSDATE) - (SELECT pra_pka_zaj.vrijednost_parametra ('1062') FROM dual))
  )
WITH READ ONLY
/
