PROMPT Creating View 'V_CRM_REZERVACIJE_CVOR'
CREATE OR REPLACE FORCE VIEW V_CRM_REZERVACIJE_CVOR
 AS SELECT rez.god_poslovna || '-' || so.sifra || '-' || rez.rbr AS uidc, -- IRN 4108
  rez.crmid AS crmid,
  rez.god_poslovna AS god_poslovna,
  so.sifra AS so_sifra,
  so.naziv AS so_naziv,
  rez.rbr AS rbr,
  rez.oznaka AS oznaka,
  rez.ozn_vstorna AS ozn_vstorna,
  rez.dat_storna AS dat_storna,
  rez.opis_storna AS opis_storna, -- IRN 4108
  rez.datum AS datum,
  ms.sifra AS ms_sifra,
  ms.naziv AS ms_naziv,
  recvpro.sifra AS recvpro_sifra,
  recvpro.naziv AS recvpro_naziv,
  recagost.rbr AS recagost_rbr,
  age.id AS age_id,
  age.sifra AS age_sifra,
  age.naziv AS age_naziv,
  pon.god_poslovna AS pon_god_poslovna,
  sopon.sifra AS pon_so_sifra,
  sopon.naziv AS pon_so_naziv,
  pon.rbr AS pon_rbr,
  DECODE (pon.ozn_book, 3, 'P', 4, 'U', 5, 'Z') AS pon_ozn_book,
  cjepon.sifra AS pon_cje_sifra,
  cjepon.naziv AS pon_cje_naziv,
  valpon.sifra_3a AS pon_val_sifra_3a,
  pon.stopa_popusta AS stopa_popusta1,
  zmppop1.sifra AS sifra_popusta1,
  zmppop1.naziv AS naziv_popusta1,
  cje.id AS cje_id,
  cje.sifra AS cje_sifra,
  cje.naziv AS cje_naziv,
  valc.sifra_3a AS cje_val_sifra_3a,
  rez.ozn_cje_poseb AS ozn_cje_poseb,
  recnrez.sifra AS recnrez_sifra,
  recnrez.naziv AS recnrez_naziv,
  pkaadr.rbr AS pkaadr_rbr,
  pkaadr.ime AS pkaadr_ime,
  pkaadr.prezime AS pkaadr_prezime,
  pkaadr.naz_poduzeca AS pkaadr_naz_poduzeca,
  rez.titula AS titula,
  rez.ime AS ime,
  rez.prezime AS prezime,
  rez.ozn_abc AS ozn_abc,
  rez.dat_dolaska AS dat_dolaska,
  rez.sat_dolaska AS sat_dolaska,
  rez.dat_odlaska AS dat_odlaska,
  rez.ozn_b AS ozn_b,
  rez.ozn_f AS ozn_f,
  rez.dat_opcije AS dat_opcije,
  rez.opis_rezervacije_mjesta AS opis_rezervacije_mjesta,
  rez.izn_predujma AS izn_predujma,
  val.sifra_3a AS val_sifra_3a,
  rez.ozn_platitelj AS ozn_platitelj,
  rez.br_uputnice AS br_uputnice,
  rez.stopa_popusta AS stopa_popusta,
  zemd.sifra_2a AS zemd_sifra_2a,
  rez.ozn_vip AS ozn_vip,
  rez.br_osoba1 AS br_osoba1,
  rez.br_osoba2 AS br_osoba2,
  rez.napomena AS napomena,
  rez.napomena2 AS napomena2,
  jez.sifra_3a AS jez_sifra_3a,
  zem.sifra_2a AS zem_sifra_2a,
  reg.sifra AS reg_sifra,
  rez.naz_regije AS naz_regije,
  pos.broj AS pos_broj,
  rez.naz_mjesta AS naz_mjesta,
  rez.naz_ulice AS naz_ulice,
  rez.br_telefona AS br_telefona,
  rez.email AS email,
  rez.www AS www,
  rez.izn_kreditnog_limita AS izn_kreditnog_limita,
  rez.unos_korisnik AS unos_korisnik,
  rez.unos_dat AS unos_dat,
  rez.izmjena_korisnik AS izmjena_korisnik,
  rez.izmjena_dat AS izmjena_dat
FROM
  t_rezervacije rez,
  m_so so,
  m_msegmenti ms,
  mrec_vprograma recvpro,
  trec_agostiju recagost,
  m_agencije age,
  t_pon_so ponso,
  m_so sopon,
  t_pon_ojr ponojr,
  t_ponude pon,
  t_cjenici cje,
  s_valute valc,
  t_cjenici cjepon,
  s_valute valpon,
  mzmp_popusti zmppop1,
  mrec_nrezerviranja recnrez,
  s_valute val,
  s_zemlje zemd,
  s_jezici jez,
  s_zemlje zem,
  m_regije reg,
  m_poste pos,
  mpka_adrese pkaadr,
  (
  SELECT
    DECODE (pra_zmp_zaj.zmppar_vrijednost ('CRM', '1001'), 'nebitno',
      LEAST (TRUNC (SYSDATE, 'RRRR'), SYSDATE - 200),
      TO_DATE (pra_zmp_zaj.zmppar_vrijednost ('CRM', '1001'), 'DD.MM.RRRR')
    ) AS dat_poc
  FROM dual
  ) param
WHERE
  rez.so_id = so.id
  AND rez.ms_id = ms.id
  AND rez.recvpro_id = recvpro.id (+)
  AND rez.recagost_id = recagost.id (+)
  AND rez.age_id = age.id (+)
  AND rez.ponso_id = ponso.id (+)
  AND ponso.so_id = sopon.id (+)
  AND ponso.ponojr_id = ponojr.id (+)
  AND ponojr.pon_id = pon.id (+)
  AND pon.cje_id = cjepon.id (+)
  AND cjepon.val_id = valpon.id (+)
  AND pon.zmppop1_id = zmppop1.id (+)
  AND rez.cje_id = cje.id
  AND cje.val_id = valc.id
  AND rez.recnrez_id = recnrez.id (+)
  AND rez.val_id = val.id (+)
  AND rez.zemd_id = zemd.id (+)
  AND rez.jez_id = jez.id (+)
  AND rez.zem_id = zem.id (+)
  AND rez.reg_id = reg.id (+)
  AND rez.pos_id = pos.id (+)
  AND rez.pkaadr_id = pkaadr.id (+)
  AND rez.dat_dolaska >= param.dat_poc
  AND pra_zmp_s.oznaka ('V0027') = -1
WITH READ ONLY
/


COMMENT ON TABLE V_CRM_REZERVACIJE_CVOR IS 'Pogled na rezervacije na voru'
/
