PROMPT Creating View 'V_CRM_REZ_CJE_CVOR'
CREATE OR REPLACE FORCE VIEW V_CRM_REZ_CJE_CVOR
 AS SELECT mish_shema.rbr || '-' || recrezcje.id AS uidc, -- IRN 4108
  recrezcje.id AS id,
  rez.crmid AS rez_crmid,
  rez.god_poslovna || '-' || so.sifra || '-' || rez.rbr AS rez_uidc, -- IRN 4108
  rez.god_poslovna AS rez_god_poslovna,
  so.sifra AS so_sifra,
  rez.rbr AS rez_rbr,
  vsjc.sifra AS vsjc_sifra,
  usl.sifra AS usl_sifra,
  recrezcje.dat_poc AS dat_poc,
  recrezcje.dat_zav AS dat_zav,
  recrezcje.cijena_usluge AS cijena_usluge,
  recrezcje.izmjena_dat AS izmjena_dat
FROM
  trec_rez_cjeusl recrezcje,
  t_rezervacije rez,
  m_so so,
  s_vsj vsjc,
  s_usluge usl,
  ( -- IRN 4108
  SELECT
    DECODE (pra_zmp_zaj.zmppar_vrijednost ('CRM', '1001'), 'nebitno',
      LEAST (TRUNC (SYSDATE, 'RRRR'), SYSDATE - 200),
      TO_DATE (pra_zmp_zaj.zmppar_vrijednost ('CRM', '1001'), 'DD.MM.RRRR')
    ) AS dat_poc
  FROM
    dual
  ) param,
  ( -- IRN 4108
  SELECT
    pra_zmp_zaj.tekuci_cvor_rbr AS rbr
  FROM
    dual
  ) mish_shema
WHERE
  recrezcje.rez_id = rez.id
  AND rez.so_id = so.id
  AND recrezcje.vsj_id = vsjc.id (+)
  AND recrezcje.usl_id = usl.id
  AND rez.dat_dolaska >= param.dat_poc -- IRN 4108
  AND pra_zmp_s.oznaka ('V0028') = -1
WITH READ ONLY
/
