PROMPT Creating View 'V_CRM_RACUNI_CVOR'
CREATE OR REPLACE FORCE VIEW V_CRM_RACUNI_CVOR
 AS SELECT rac.god_poslovna || '-' || rac.oj_sifra || '-' || vapldok.oznaka || '-' || rac.rbr AS uidc, -- IRN 4108
  rac.god_poslovna AS god_poslovna,
  rac.oj_sifra AS oj_sifra,
  vapldok.oznaka AS vapldok_sifra,
  rac.rbr AS rbr,
  rac.oznaka AS oznaka,
  rac.datum AS datum,
  so.sifra AS so_sifra,
  ms.sifra AS ms_sifra,
  DECODE (rac.gost_id, NULL, NULL, gost.god_poslovna || '-' || mish_shema.rbr || '-' || gost.rbr
    ) AS gost_uidc, -- IRN 4108
  mish_shema.rbr AS mish_shema_rbr,
  DECODE (rac.gost_id, NULL, DECODE (rac.age_id, NULL, 'AD', 'AG'), 'GO'
    ) AS pla_vrsta,
  DECODE (rac.gost_id, NULL,
    DECODE (rac.age_id, NULL, pkaadr.rbr, age.sifra),
    gost.rbr || ' ' || gost.god_poslovna
    ) AS pla_sifra,
  DECODE (rac.gost_id, NULL,
    DECODE (rac.age_id, NULL,
      DECODE (pkaadr.naz_poduzeca, NULL, pkaadr.prezime || ', ' || pkaadr.ime, pkaadr.naz_poduzeca),
      age.naziv),
    gost.prezime || ', ' || gost.ime
    ) AS pla_naziv,
  agep.sifra AS agep_sifra,
  recagost.rbr AS recagost_rbr,
  tro.pon_god_poslovna AS pon_god_poslovna,
  tro.pon_rbr AS pon_rbr,
  tro.pon_so_sifra AS pon_so_sifra,
  rez.god_poslovna AS rez_god_poslovna,
  rezso.sifra AS rez_so_sifra,
  rez.rbr AS rez_rbr,
  val.sifra_3a AS val_sifra_3a,
  pra_rec_s2.iznos_racuna_bruto (rac.id, rac.iznos, rac.izn_tecaja) AS iznos,
  rac.izn_tecaja AS izn_tecaja,
  (rac.izn_popusta1 + rac.izn_popusta2 + rac.izn_popusta3 + rac.izn_popusta4 + rac.izn_smjesta) AS izn_odbitaka,
  rac.kol_loy_izlaz AS kol_loy_izlaz,
  DECODE (rac.rac_id, NULL, NULL, racp.god_poslovna || '-' || racp.oj_sifra || '-' || vapldokp.oznaka || '-' || racp.rbr
    ) AS racp_uidc, -- IRN 4108
  racp.god_poslovna AS racp_god_poslovna,
  racp.oj_sifra AS racp_oj_sifra,
  vapldokp.oznaka AS racp_vapldok_sifra,
  racp.rbr AS racp_rbr,
  rac.izmjena_dat AS izmjena_dat
FROM
  t_racuni rac,
  s_vapldok vapldok,
  m_so so,
  m_msegmenti ms,
  t_gosti gost,
  trec_agostiju recagost,
  t_rez_vsj rezvsj,
  t_rezervacije rez,
  m_so rezso,
  m_agencije age,
  mpka_adrese pkaadr,
  m_agencije agep,
  s_valute val,
  (
  SELECT
    tro.rac_id, MAX (pon.god_poslovna) pon_god_poslovna, MAX (pon.rbr) pon_rbr, MAX (so.sifra) pon_so_sifra
  FROM
    t_troskovi tro,
    t_pon_so ponso,
    m_so so,
    t_pon_ojr ponojr,
    t_ponude pon
  WHERE
    tro.ponso_id = ponso.id
    AND ponso.so_id = so.id
    AND ponso.ponojr_id = ponojr.id
    AND ponojr.pon_id = pon.id
  GROUP BY tro.rac_id
  ) tro,
  (
  SELECT
    DECODE (pra_zmp_zaj.zmppar_vrijednost ('CRM', '1001'), 'nebitno',
      LEAST (TRUNC (SYSDATE, 'RRRR'), SYSDATE - 200),
      TO_DATE (pra_zmp_zaj.zmppar_vrijednost ('CRM', '1001'), 'DD.MM.RRRR')
    ) AS dat_poc
  FROM
    dual
  ) param,
  t_racuni racp,
  s_vapldok vapldokp,
  (
  SELECT
    pra_zmp_zaj.tekuci_cvor_rbr AS rbr
  FROM
    dual
  ) mish_shema
WHERE rac.so_id = so.id
  AND rac.vapldok_id = vapldok.id
  AND rac.ms_id = ms.id (+)
  AND rac.gost_id = gost.id (+)
  AND gost.recagost_id = recagost.id (+)
  AND gost.rezvsj_id = rezvsj.id (+)
  AND rezvsj.rez_id = rez.id (+)
  AND rez.so_id = rezso.id (+)
  AND rac.age_id = age.id (+)
  AND rac.pkaadr_id = pkaadr.id (+)
  AND rac.agep_id = agep.id (+)
  AND rac.val_id = val.id (+)
  AND rac.id = tro.rac_id (+)
  AND rac.datum >= param.dat_poc
  AND vapldok.oznaka IN ('BI', 'GI')
  AND rac.rac_id = racp.id (+)
  AND racp.vapldok_id = vapldokp.id (+)
  AND pra_zmp_s.oznaka ('V0024') = -1
WITH READ ONLY
/
