PROMPT Creating View 'V_CRM_RAC_USL_CVOR'
CREATE OR REPLACE FORCE VIEW V_CRM_RAC_USL_CVOR
 AS SELECT mish_shema.rbr || '-' || tro.id AS uidc, -- IRN 4108
  rac.god_poslovna || '-' || rac.oj_sifra || '-' || vapldok.oznaka || '-' || rac.rbr AS rac_uidc, -- IRN 4108
  rac.god_poslovna AS rac_god_poslovna,
  rac.oj_sifra AS oj_sifra,
  vapldok.oznaka AS vapldok_oznaka,
  rac.rbr AS rac_rbr,
  DECODE (tro.gost_id, NULL, NULL, gost.god_poslovna || '-' || mish_shema.rbr || '-' || gost.rbr
    ) AS gost_uidc, -- IRN 4108
  mish_shema.rbr AS mish_shema_rbr,
  DECODE (tro.gost_id, NULL, DECODE (tro.age_id, NULL, 'AD', 'AG'), 'GO') AS kor_vrsta,
  DECODE (tro.gost_id, NULL,
    DECODE (tro.age_id, NULL, pkaadr.rbr, age.sifra),
    gost.rbr || ' ' || gost.god_poslovna) AS kor_sifra,
  DECODE (tro.gost_id, NULL,
    DECODE (tro.age_id, NULL,
      DECODE (pkaadr.naz_poduzeca, NULL, pkaadr.prezime || ', ' || pkaadr.ime, pkaadr.naz_poduzeca),
      age.naziv),
    gost.prezime || ', ' || gost.ime) AS kor_naziv,
  recagost.rbr AS recagost_rbr,
  rez.god_poslovna AS rez_god_poslovna,
  rezso.sifra AS rez_so_sifra,
  rez.rbr AS rez_rbr,
  ms.sifra AS ms_sifra,
  usl.sifra AS usl_sifra,
  usl.ozn_loyalty AS usl_ozn_loyalty,
  tro.recara_id AS recara_id,
  recara.sifra AS recara_sifra,
  uslc.sifra AS uslc_sifra,
  vsj.sifra AS vsjc_sifra,
  tro.dat_poc AS dat_poc,
  tro.dat_zav AS dat_zav,
  tro.kol_usluge AS kolicina,
  ROUND (tro.cijena_usluge * tro.izn_tecaja / rac.izn_tecaja, 2) AS cijena,
  tro.stopa_placanja AS stopa_placanja,
  ROUND (tro.cijena_usluge * tro.stopa_placanja / 100 * tro.izn_tecaja / rac.izn_tecaja, 2)
    * tro.kol_usluge
    * DECODE (tro.obr_po_danu, -1, (tro.dat_zav - tro.dat_poc - tro.obr_zdana), 1) AS iznos,
  DECODE (tro.ponso_id, NULL, 0, -1) AS ozn_ugo, -- IRN 3332
  tro.izn_odbitka AS izn_odbitaka,
  tro.izmjena_dat AS izmjena_dat
FROM
  t_troskovi tro,
  t_racuni rac,
  s_vapldok vapldok,
  s_usluge usl,
  mrec_aranzmani recara,
  s_usluge uslc,
  t_gosti gost,
  trec_agostiju recagost,
  t_rez_vsj rezvsj,
  t_rezervacije rez,
  m_so rezso,
  m_agencije age,
  mpka_adrese pkaadr,
  s_vsj vsj,
  m_msegmenti ms,
  (
  SELECT
    DECODE (pra_zmp_zaj.zmppar_vrijednost ('CRM', '1001'), 'nebitno',
      LEAST (TRUNC (SYSDATE, 'RRRR'), SYSDATE - 200),
      TO_DATE (pra_zmp_zaj.zmppar_vrijednost ('CRM', '1001'), 'DD.MM.RRRR')
    ) AS dat_poc
  FROM
    dual
  ) param,
  (
  SELECT
    pra_zmp_zaj.tekuci_cvor_rbr AS rbr
  FROM
    dual
  ) mish_shema
WHERE
  tro.rac_id = rac.id
  AND rac.vapldok_id = vapldok.id
  AND tro.usl_id = usl.id
  AND tro.recara_id = recara.id(+)
  AND tro.usl_id1 = uslc.id(+)
  AND tro.gost_id = gost.id(+)
  AND gost.recagost_id = recagost.id(+)
  AND gost.rezvsj_id = rezvsj.id(+)
  AND rezvsj.rez_id = rez.id(+)
  AND rez.so_id = rezso.id(+)
  AND tro.age_id = age.id(+)
  AND tro.pkaadr_id = pkaadr.id(+)
  AND tro.vsj_id = vsj.id(+)
  AND tro.ms_id = ms.id(+)
  AND rac.datum >= param.dat_poc
  AND vapldok.oznaka IN ('BI', 'GI')
  AND pra_zmp_s.oznaka ('V0026') = -1
WITH READ ONLY
/
