PROMPT Creating View 'V_CRM_RAC_RNK_CVOR'
CREATE OR REPLACE FORCE VIEW V_CRM_RAC_RNK_CVOR
 AS SELECT mish_shema.rbr || '-' || pkarnk.id AS uidc,
  pkarnk.id AS id,
  rac.god_poslovna || '-' || rac.oj_sifra || '-' || vapldok.oznaka || '-' || rac.rbr AS rac_uidc, -- IRN 4108
  rac.god_poslovna AS rac_god_poslovna,
  rac.oj_sifra AS oj_sifra,
  vapldok.oznaka AS vapldok_oznaka,
  rac.rbr AS rac_rbr,
  DECODE (pkarnk.gost_id, NULL, NULL, gost.god_poslovna || '-' || mish_shema.rbr || '-' || gost.rbr
    ) AS gost_uidc, -- IRN 4108
  mish_shema.rbr AS mish_shema_rbr,
  DECODE (pkarnk.gost_id, NULL, DECODE (pkarnk.age_id, NULL, 'AD', 'AG'), 'GO') AS kor_vrsta,
  DECODE (pkarnk.gost_id, NULL,
    DECODE (pkarnk.age_id, NULL, pkaadr.rbr, age.sifra),
    gost.rbr || ' ' || gost.god_poslovna) AS kor_sifra,
  DECODE (pkarnk.gost_id, NULL,
    DECODE (pkarnk.age_id, NULL,
      DECODE (pkaadr.naz_poduzeca, NULL, pkaadr.prezime || ', ' || pkaadr.ime, pkaadr.naz_poduzeca),
      age.naziv),
    gost.prezime || ', ' || gost.ime) AS kor_naziv,
  recagost.rbr AS recagost_rbr,
  rez.god_poslovna AS rez_god_poslovna,
  rezso.sifra AS rez_so_sifra,
  rez.rbr AS rez_rbr,
  pkarnk.god_poslovna AS god_poslovna,
  gmpkas.sifra AS gmpkas_sifra,
  gmpkas.naziv AS gmpkas_naziv,
  pkarnk.rbr AS rbr,
  pkarnk.recara_id AS recara_id,
  recara.sifra AS recara_sifra,
  pkarnk.datum AS datum,
  ROUND (pkarnk.izn_placanja / rac.izn_tecaja, 2) AS iznos,
  pkarnk.izmjena_dat AS izmjena_dat
FROM
  tpka_rnkasa pkarnk,
  t_racuni rac,
  s_vapldok vapldok,
  mgmp_kase gmpkas,
  mrec_aranzmani recara,
  t_gosti gost,
  trec_agostiju recagost,
  t_rez_vsj rezvsj,
  t_rezervacije rez,
  m_so rezso,
  m_agencije age,
  mpka_adrese pkaadr,
  (
  SELECT
    DECODE (pra_zmp_zaj.zmppar_vrijednost ('CRM', '1001'), 'nebitno',
      LEAST (TRUNC (SYSDATE, 'RRRR'), SYSDATE - 200),
      TO_DATE (pra_zmp_zaj.zmppar_vrijednost ('CRM', '1001'), 'DD.MM.RRRR')
    ) AS dat_poc
  FROM
    dual
  ) param,
  (
  SELECT
    pra_zmp_zaj.tekuci_cvor_rbr AS rbr
  FROM
    dual
  ) mish_shema
WHERE
  pkarnk.rac_id = rac.id
  AND rac.vapldok_id = vapldok.id
  AND pkarnk.gmpkas_id = gmpkas.id
  AND pkarnk.recara_id = recara.id(+)
  AND pkarnk.gost_id = gost.id(+)
  AND gost.recagost_id = recagost.id(+)
  AND gost.rezvsj_id = rezvsj.id(+)
  AND rezvsj.rez_id = rez.id(+)
  AND rez.so_id = rezso.id(+)
  AND pkarnk.age_id = age.id(+)
  AND pkarnk.pkaadr_id = pkaadr.id(+)
  AND rac.datum >= param.dat_poc
  AND vapldok.oznaka IN ('BI', 'GI')
  AND pra_zmp_s.oznaka ('V0025') = -1
WITH READ ONLY
/
