PROMPT Creating View 'V_CRM_GOSTI_CVOR'
CREATE OR REPLACE FORCE VIEW V_CRM_GOSTI_CVOR
 AS SELECT gost_god_poslovna || '-' || mish_shema.rbr || '-' || gost_rbr AS uidc,
  gost_god_poslovna AS god_poslovna,
  mish_shema.rbr AS mish_shema_rbr,
  so.sifra AS so_sifra,
  gost_rbr AS rbr,
  gost_titula AS titula,
  gost_ime AS ime,
  gost_prezime AS prezime,
  gost_ozn_prisutnosti AS ozn_prisutnosti,
  gost_ozn_vip AS ozn_vip,
  --
  sj_broj,
  vsj.sifra AS vsj_sifra,
  vsjc.sifra AS vsjc_sifra,
  --
  gost_dat_dolaska AS dat_dolaska,
  gost_dat_odlaska AS dat_odlaska,
  --
  ms.sifra AS ms_sifra,
  age.sifra AS age_sifra,
  gost_br_uputnice AS br_uputnice,
  recvpro.sifra AS recvpro_sifra,
  cje.sifra AS cje_sifra,
  gost_ozn_platitelj AS ozn_platitelj,
  gost_ozn_gratis AS ozn_gratis,
  gost_ozn_rnk AS ozn_rnk,
  --
  rez.god_poslovna AS rez_god_poslovna,
  rezso.sifra AS rez_so_sifra,
  rez.rbr AS rez_rbr,
  DECODE (gost_rezvsj_id, NULL, NULL, mish_shema.rbr || '-' || gost_rezvsj_id) AS rezvsj_uidc, -- IRN 4108
  --
  recagost.rbr AS recagost_rbr,
  --
  kgost_god_poslovna,
  knjm.sifra AS knjm_sifra,
  kgost_ozn_vknjiga AS ozn_vknjiga,
  kgost_rbr,
  --
  zem.sifra_2a AS zem_sifra_2a,
  reg.sifra AS reg_sifra,
  kgost_naz_regije AS naz_regije,
  pos.broj AS pos_broj,
  kgost_naz_mjesta AS naz_mjesta,
  kgost_naz_ulice AS naz_ulice,
  --
  kgost_br_telefona AS br_telefona,
  kgost_br_telefaksa AS br_telefaksa,
  kgost_email AS email,
  kgost_www AS www,
  jez.sifra_3a AS jez_sifra_3a,
  kgost_ozn_kontakt AS ozn_kontakt,
  --
  kgost_naz_poduzeca AS naz_poduzeca,
  --
  kgost_ozn_spola AS ozn_spola,
  kgost_dat_rodjenja AS dat_rodjenja,
  recgdgost.sifra AS recgdgost_sifra,
  vplabp.sifra AS vplabp_sifra,
  --
  zemr.sifra_2a AS zemr_sifra_2a,
  posr.broj AS posr_broj,
  kgost_naz_mjrodj AS naz_mjrodj,
  --
  zemd.sifra_2a AS zemd_sifra_2a,
  gpri.sifra AS gpri_sifra,
  vpisp.sifra AS vpisp_sifra,
  kgost_br_pisprave AS br_pisprave,
  kgost_reg_vozila AS reg_vozila,
  --
  gost_barcode AS barcode,
  --
  (
  SELECT
    SUM (ROUND (pra_rec_s2.iznos_racuna_bruto (rac.id, rac.iznos, rac.izn_tecaja) * rac.izn_tecaja, 2))
  FROM
    t_racuni rac
  WHERE
    rac.gost_id = gost.gost_id
  ) AS izn_racuna,
  fm_rec4140.izn_prihoda_izv_gost_gszur (gost.gost_id, NULL, NULL, NULL) AS izn_prihoda,
  --
  gost_napomena AS napomena,
  gost_ozn_brisano AS ozn_brisano,
  --
  vla.sifra_tekuceg_cvora AS metcvor_sifra,
  gost.gost_id AS id,
  gost.gost_ozn_dprivole AS ozn_dprivole,
  --
  gost_izmjena_dat AS izmjena_dat
FROM
  v_t_gosti gost,
  m_so so,
  s_zemlje zem, s_zemlje zemr, s_zemlje zemd,
  s_vsj vsj, s_vsj vsjc,
  mrec_gdgostiju recgdgost,
  s_vplabp_tz vplabp,
  s_vpisprava vpisp,
  trec_agostiju recagost,
  t_rezervacije rez, t_rez_vsj rezvsj,
  m_so rezso,
  m_regije reg,
  m_poste pos, m_poste posr,
  m_msegmenti ms,
  mrec_vprograma recvpro,
  m_knjigem knjm,
  s_jezici jez,
  s_gprijelazi gpri,
  t_cjenici cje,
  m_agencije age,
  s_vlasnik vla,
  (
  SELECT
    DECODE (zmppar.vrijednost, 'nebitno',
      LEAST (TRUNC (SYSDATE, 'RRRR'), SYSDATE - 200),
      TO_DATE (zmppar.vrijednost, 'DD.MM.RRRR')
    ) AS dat_poc
  FROM
    szmp_parametri zmppar,
    szmp_sustavi zmpsus
  WHERE
    zmppar.zmpsus_id = zmpsus.id
    AND zmpsus.sifra = 'CRM'
    AND zmppar.sifra = '1001'
  ) param,
  (
  SELECT
    pra_zmp_zaj.tekuci_cvor_rbr AS rbr
  FROM
    dual
  ) mish_shema
WHERE
  gost.gost_dat_dolaska >= param.dat_poc
  AND gost.sj_so_id = so.id
  AND kgost_zem_id = zem.id (+)
  AND kgost_zemr_id = zemr.id (+)
  AND gost_zem_id = zemd.id
  AND sj_vsj_id = vsj.id
  AND gost_vsj_id = vsjc.id (+)
  AND recgdgost_id = recgdgost.id (+)
  AND kgost_vplabp_id = vplabp.id (+)
  AND kgost_vpisp_id = vpisp.id (+)
  AND gost_recagost_id = recagost.id (+)
  AND gost_rezvsj_id = rezvsj.id (+)
  AND rezvsj.rez_id = rez.id (+)
  AND rez.so_id = rezso.id(+)
  AND kgost_reg_id = reg.id (+)
  AND kgost_pos_id = pos.id (+)
  AND kgost_posr_id = posr.id (+)
  AND gost_ms_id = ms.id
  AND gost_recvpro_id = recvpro.id (+)
  AND kgost_knjm_id = knjm.id (+)
  AND gost_jez_id = jez.id (+)
  AND kgost_gpri_id = gpri.id (+)
  AND gost_cje_id = cje.id (+)
  AND gost_age_id = age.id (+)
WITH READ ONLY
/
