PROMPT Creating Trigger 'BDR_TREC_ZAK_USL'
CREATE OR REPLACE TRIGGER BDR_TREC_ZAK_USL
 BEFORE DELETE
 ON TREC_ZAK_USL
 FOR EACH ROW
DECLARE

  vpdog_id_l   t_zakup.vpdog_id%TYPE;
  izn_tecaja_l t_zakup.izn_tecaja%TYPE;
  dat_poc_l    t_zakup.dat_poc%TYPE;
  dat_zav_l    t_zakup.dat_zav%TYPE;
  so_id_l      t_zakup.so_id%TYPE;
BEGIN
  pra_t_zakup.provjeri_zak_oznaka (:OLD.zak_id, NULL);

  pra_t_zakup.vrati_zak (:OLD.zak_id, vpdog_id_l, izn_tecaja_l, dat_poc_l, dat_zav_l, so_id_l);
  -- oduzmi proteklo razdoblje
  pra_t_zakup.dodaj_reczakpdv1 (
    :OLD.zak_id,
    izn_tecaja_l,
    dat_poc_l,
    dat_zav_l,
    dat_poc_l,
    LEAST (TRUNC (SYSDATE), dat_zav_l),
    :OLD.usl_id,
    :OLD.kolicina * -1,
    :OLD.cijena,
    :OLD.vpispz_id,
    :OLD.stopa_pdv,
    :OLD.obr_zdana,
    TRUNC (SYSDATE));
  -- oduzmi budue razdoblje po danima
  pra_t_zakup.dodaj_reczakpdv1 (
    :OLD.zak_id,
    izn_tecaja_l,
    dat_poc_l,
    dat_zav_l,
    GREATEST (TRUNC (SYSDATE), dat_poc_l),
    dat_zav_l,
    :OLD.usl_id,
    :OLD.kolicina * -1,
    :OLD.cijena,
    :OLD.vpispz_id,
    :OLD.stopa_pdv,
    :OLD.obr_zdana,
    NULL);
END;
/
SHOW ERROR


PROMPT Creating Trigger 'BIR_TREC_ZAK_USL'
CREATE OR REPLACE TRIGGER BIR_TREC_ZAK_USL
 BEFORE INSERT
 ON TREC_ZAK_USL
 FOR EACH ROW
DECLARE

  vpdog_id_l   t_zakup.vpdog_id%TYPE;
  izn_tecaja_l t_zakup.izn_tecaja%TYPE;
  dat_poc_l    t_zakup.dat_poc%TYPE;
  dat_zav_l    t_zakup.dat_zav%TYPE;
  so_id_l      t_zakup.so_id%TYPE; -- IRN 4118
  vpispz_id_l  trec_zak_usl.vpispz_id%TYPE;
  stopa_pdv_l  trec_zak_usl.stopa_pdv%TYPE;
  obr_zdana_l  trec_zak_usl.obr_zdana%TYPE;
BEGIN
  -- IRN 2888
  IF SYS_CONTEXT ('LOGINFO_CTX', 'SSOUSER') = 'ITNEW'
    AND SYS_CONTEXT ('LOGINFO_CTX', 'VLASNIKPODATKA') = pra_zmp_zaj.vrijednost_parametra ('0999')
  THEN
    RETURN;  -- izlaz iz trigera
  END IF;

  :NEW.id := pra_zmp_zaj.i3_sekvenca (:NEW.id);

  pra_t_zakup.provjeri_zak_oznaka (:NEW.zak_id, NULL);

  pra_t_zakup.vrati_zak (:NEW.zak_id, vpdog_id_l, izn_tecaja_l, dat_poc_l, dat_zav_l, so_id_l);
  pra_rec_s5.provjeri_recsousl (so_id_l, :NEW.usl_id); -- IRN 4118

  pra_zmp_s.vrati_vpispz (:NEW.usl_id, TRUNC (SYSDATE), vpdog_id_l, vpispz_id_l, stopa_pdv_l, obr_zdana_l); -- IRN 2613
  :NEW.vpispz_id := vpispz_id_l;
  :NEW.stopa_pdv := stopa_pdv_l;
  :NEW.obr_zdana := obr_zdana_l;
  -- dodaj PDV za proteklo razdoblje
  pra_t_zakup.dodaj_reczakpdv1 (
    :NEW.zak_id,
    izn_tecaja_l,
    dat_poc_l,
    dat_zav_l,
    dat_poc_l,
    LEAST (TRUNC (SYSDATE), dat_zav_l),
    :NEW.usl_id,
    :NEW.kolicina,
    :NEW.cijena,
    :NEW.vpispz_id,
    :NEW.stopa_pdv,
    :NEW.obr_zdana,
    TRUNC (SYSDATE));
  -- dodaj PDV za budue razdoblje
  pra_t_zakup.dodaj_reczakpdv1 (
    :NEW.zak_id,
    izn_tecaja_l,
    dat_poc_l,
    dat_zav_l,
    GREATEST (TRUNC (SYSDATE), dat_poc_l),
    dat_zav_l,
    :NEW.usl_id,
    :NEW.kolicina,
    :NEW.cijena,
    :NEW.vpispz_id,
    :NEW.stopa_pdv,
    :NEW.obr_zdana,
    NULL);

  pra_rec_zaj.upisi_audit (:NEW.unos_korisnik, :NEW.unos_dat, :NEW.izmjena_korisnik, :NEW.izmjena_dat);
END;
/
SHOW ERROR


PROMPT Creating Trigger 'BUR_TREC_ZAK_USL'
CREATE OR REPLACE TRIGGER BUR_TREC_ZAK_USL
 BEFORE UPDATE
 ON TREC_ZAK_USL
 FOR EACH ROW
DECLARE

  vpdog_id_l   t_zakup.vpdog_id%TYPE;
  izn_tecaja_l t_zakup.izn_tecaja%TYPE;
  dat_poc_l    t_zakup.dat_poc%TYPE;
  dat_zav_l    t_zakup.dat_zav%TYPE;
  so_id_l      t_zakup.so_id%TYPE; -- IRN 4118
  vpispz_id_l  trec_zak_usl.vpispz_id%TYPE;
  stopa_pdv_l  trec_zak_usl.stopa_pdv%TYPE;
  obr_zdana_l  trec_zak_usl.obr_zdana%TYPE;
BEGIN
  -- zabrani promjenu roditelja
  IF :NEW.zak_id <> :OLD.zak_id THEN
    pra_rec_zaj.vrati_poruku (-20096);
  END IF;

  pra_t_zakup.provjeri_zak_oznaka (:OLD.zak_id, NULL);

  pra_t_zakup.vrati_zak (:OLD.zak_id, vpdog_id_l, izn_tecaja_l, dat_poc_l, dat_zav_l, so_id_l);

  -- IRN 4118
  IF :NEW.usl_id <> :OLD.usl_id THEN
    pra_rec_s5.provjeri_recsousl (so_id_l, :NEW.usl_id);
  END IF;

  pra_zmp_s.vrati_vpispz (:NEW.usl_id, TRUNC (SYSDATE), vpdog_id_l, vpispz_id_l, stopa_pdv_l, obr_zdana_l); -- IRN 2613
  :NEW.vpispz_id := vpispz_id_l;
  :NEW.stopa_pdv := stopa_pdv_l;
  :NEW.obr_zdana := obr_zdana_l;

  -- Nije mogue mijenjati podatke vezane za PDV ako postoje valjani rauni
  IF (:NEW.vpispz_id <> :OLD.vpispz_id
    OR :NEW.stopa_pdv <> :OLD.stopa_pdv
    OR :NEW.obr_zdana <> :OLD.obr_zdana)
    AND pra_t_zakup.kol_rac (:OLD.zak_id) > 0
  THEN
    pra_rec_zaj.vrati_poruku (-20412);
  END IF;

  -- auriraj PDV (irec_zak_pdv)
  IF :NEW.usl_id <> :OLD.usl_id
    OR :NEW.kolicina <> :OLD.kolicina
    OR :NEW.cijena <> :OLD.cijena
    OR :NEW.vpispz_id <> :OLD.vpispz_id
    OR :NEW.stopa_pdv <> :OLD.stopa_pdv
    OR :NEW.obr_zdana <> :OLD.obr_zdana
  THEN
    -- auriraj proteklo razdoblje
    pra_t_zakup.dodaj_reczakpdv1 (
      :OLD.zak_id,
      izn_tecaja_l,
      dat_poc_l,
      dat_zav_l,
      dat_poc_l,
      LEAST (TRUNC (SYSDATE), dat_zav_l),
      :OLD.usl_id,
      :OLD.kolicina * -1,
      :OLD.cijena,
      :OLD.vpispz_id,
      :OLD.stopa_pdv,
      :OLD.obr_zdana,
      TRUNC (SYSDATE));
    pra_t_zakup.dodaj_reczakpdv1 (
      :NEW.zak_id,
      izn_tecaja_l,
      dat_poc_l,
      dat_zav_l,
      dat_poc_l,
      LEAST (TRUNC (SYSDATE), dat_zav_l),
      :NEW.usl_id,
      :NEW.kolicina,
      :NEW.cijena,
      :NEW.vpispz_id,
      :NEW.stopa_pdv,
      :NEW.obr_zdana,
      TRUNC (SYSDATE));
    -- auriraj budue razdoblje po danima
    pra_t_zakup.dodaj_reczakpdv1 (
      :OLD.zak_id,
      izn_tecaja_l,
      dat_poc_l,
      dat_zav_l,
      GREATEST (TRUNC (SYSDATE), dat_poc_l),
      dat_zav_l,
      :OLD.usl_id,
      :OLD.kolicina * -1,
      :OLD.cijena,
      :OLD.vpispz_id,
      :OLD.stopa_pdv,
      :OLD.obr_zdana,
      NULL);
    pra_t_zakup.dodaj_reczakpdv1 (
      :NEW.zak_id,
      izn_tecaja_l,
      dat_poc_l,
      dat_zav_l,
      GREATEST (TRUNC (SYSDATE), dat_poc_l),
      dat_zav_l,
      :NEW.usl_id,
      :NEW.kolicina,
      :NEW.cijena,
      :NEW.vpispz_id,
      :NEW.stopa_pdv,
      :NEW.obr_zdana,
      NULL);
  END IF;

  pra_rec_zaj.upisi_audit (:NEW.unos_korisnik, :NEW.unos_dat, :NEW.izmjena_korisnik, :NEW.izmjena_dat);
END;
/
SHOW ERROR
