PROMPT Creating Trigger 'BDR_TREC_IPON_USL'
CREATE OR REPLACE TRIGGER BDR_TREC_IPON_USL
 BEFORE DELETE
 ON TREC_IPON_USL
 FOR EACH ROW
DECLARE

  recipon_id_l trec_iponude.id%TYPE;
BEGIN
  SELECT recipon_id INTO recipon_id_l FROM trec_ipon_so WHERE id = :OLD.reciponso_id;
  pra_trec_iponude.provjeri_recipon_oznaka (recipon_id_l);
END;
/
SHOW ERROR


PROMPT Creating Trigger 'BIR_TREC_IPON_USL'
CREATE OR REPLACE TRIGGER BIR_TREC_IPON_USL
 BEFORE INSERT
 ON TREC_IPON_USL
 FOR EACH ROW
BEGIN
  -- IRN 2888
  IF SYS_CONTEXT ('LOGINFO_CTX', 'SSOUSER') = 'ITNEW'
    AND SYS_CONTEXT ('LOGINFO_CTX', 'VLASNIKPODATKA') = pra_zmp_zaj.vrijednost_parametra ('0999')
  THEN
    RETURN;  -- izlaz iz trigera
  END IF;
 
  :NEW.id := pra_zmp_zaj.i3_sekvenca (:NEW.id);

  :NEW.dat_poc := TRUNC (:NEW.dat_poc);
  :NEW.dat_zav := TRUNC (:NEW.dat_zav);

  -- IRN 4118
  FOR reciponso_c IN (SELECT recipon_id, so_id FROM trec_ipon_so WHERE id = :NEW.reciponso_id)
  LOOP
    pra_trec_iponude.provjeri_recipon_oznaka (reciponso_c.recipon_id);
    pra_rec_s5.provjeri_recsousl (reciponso_c.so_id, :NEW.usl_id);
  END LOOP;

  pra_rec_zaj.upisi_audit (:NEW.unos_korisnik, :NEW.unos_dat, :NEW.izmjena_korisnik, :NEW.izmjena_dat);
END;
/
SHOW ERROR


PROMPT Creating Trigger 'BUR_TREC_IPON_USL'
CREATE OR REPLACE TRIGGER BUR_TREC_IPON_USL
 BEFORE UPDATE
 ON TREC_IPON_USL
 FOR EACH ROW
BEGIN
  :NEW.dat_poc := TRUNC (:NEW.dat_poc);
  :NEW.dat_zav := TRUNC (:NEW.dat_zav);

  IF :NEW.reciponso_id <> :OLD.reciponso_id THEN
    pra_rec_zaj.vrati_poruku (-20096);
  END IF;

  FOR reciponso_c IN (SELECT recipon_id, so_id FROM trec_ipon_so WHERE id = :NEW.reciponso_id)
  LOOP
    pra_trec_iponude.provjeri_recipon_oznaka (reciponso_c.recipon_id);
    -- IRN 4118
    IF :NEW.usl_id <> :OLD.usl_id THEN
      pra_rec_s5.provjeri_recsousl (reciponso_c.so_id, :NEW.usl_id);
    END IF;
  END LOOP;

  pra_rec_zaj.upisi_audit (:NEW.unos_korisnik, :NEW.unos_dat, :NEW.izmjena_korisnik, :NEW.izmjena_dat);
END;
/
SHOW ERROR
