PROMPT Creating Trigger 'BDR_TREC_IPON_SO'
CREATE OR REPLACE TRIGGER BDR_TREC_IPON_SO
 BEFORE DELETE
 ON TREC_IPON_SO
 FOR EACH ROW
BEGIN
  pra_trec_iponude.provjeri_recipon_oznaka (:OLD.recipon_id);
END;
/
SHOW ERROR


PROMPT Creating Trigger 'BIR_TREC_IPON_SO'
CREATE OR REPLACE TRIGGER BIR_TREC_IPON_SO
 BEFORE INSERT
 ON TREC_IPON_SO
 FOR EACH ROW
DECLARE

  dat_dolaska_l trec_iponude.dat_dolaska%TYPE;
  dat_odlaska_l trec_iponude.dat_odlaska%TYPE;
  usl_id_l trec_iponude.usl_id%TYPE;
BEGIN
  -- IRN 2888
  IF SYS_CONTEXT ('LOGINFO_CTX', 'SSOUSER') = 'ITNEW'
    AND SYS_CONTEXT ('LOGINFO_CTX', 'VLASNIKPODATKA') = pra_zmp_zaj.vrijednost_parametra ('0999')
  THEN
    RETURN; -- izlaz iz trigera
  END IF;

  :NEW.id := pra_zmp_zaj.i3_sekvenca (:NEW.id);

  pra_trec_iponude.provjeri_recipon_oznaka (:NEW.recipon_id);

  -- vrati zaglavlje
  SELECT dat_dolaska, dat_odlaska, usl_id INTO dat_dolaska_l, dat_odlaska_l, usl_id_l
    FROM trec_iponude
   WHERE id = :NEW.recipon_id;

  pra_rec.provjeri_vsj (:NEW.vsj_id, :NEW.so_id, dat_dolaska_l, dat_odlaska_l);

  pra_rec_s5.provjeri_recsousl (:NEW.so_id, NVL (:NEW.usl_id, usl_id_l)); -- IRN 4118

  pra_rec.provjeri_sastojak (:NEW.usl_id, :NEW.sas_id);
  IF :NEW.usl_id IS NULL AND :NEW.sas_id IS NOT NULL THEN
    pra_rec.provjeri_sastojak (usl_id_l, :NEW.sas_id);
  END IF;

  pra_rec_zaj.upisi_audit (:NEW.unos_korisnik, :NEW.unos_dat, :NEW.izmjena_korisnik, :NEW.izmjena_dat);
END;
/
SHOW ERROR


PROMPT Creating Trigger 'BUR_TREC_IPON_SO'
CREATE OR REPLACE TRIGGER BUR_TREC_IPON_SO
 BEFORE UPDATE
 ON TREC_IPON_SO
 FOR EACH ROW
DECLARE

  dat_dolaska_l trec_iponude.dat_dolaska%TYPE;
  dat_odlaska_l trec_iponude.dat_odlaska%TYPE;
  usl_id_l trec_iponude.usl_id%TYPE;
BEGIN
  IF :NEW.recipon_id <> :OLD.recipon_id THEN
    -- Nema izmjene primarnog kljua (moe se izgubiti veza).
    pra_rec_zaj.vrati_poruku (-20096);
  END IF;

  -- IRN 1949
  IF :NEW.so_id <> :OLD.so_id
    OR :NEW.vsj_id <> :OLD.vsj_id
    OR :NEW.kol_sj <> :OLD.kol_sj
    OR NVL (:NEW.vsjc_id, 0) <> NVL (:OLD.vsjc_id, 0)
    OR NVL (:NEW.usl_id, 0) <> NVL (:OLD.usl_id, 0)
    OR NVL (:NEW.sas_id, 0) <> NVL (:OLD.sas_id, 0)
    OR NVL (:NEW.stopa_popusta2, 0) <> NVL (:OLD.stopa_popusta2, 0)
    OR NVL (:NEW.stopa_predujma, 0) <> NVL (:OLD.stopa_predujma, 0)
  THEN
    pra_trec_iponude.provjeri_recipon_oznaka (:NEW.recipon_id);
  END IF;

  -- vrati zaglavlje
  SELECT dat_dolaska, dat_odlaska, usl_id INTO dat_dolaska_l, dat_odlaska_l, usl_id_l
    FROM trec_iponude
   WHERE id = :NEW.recipon_id;

  pra_rec.provjeri_vsj (:NEW.vsj_id, :NEW.so_id, dat_dolaska_l, dat_odlaska_l);

  -- IRN 4118
  IF :NEW.so_id <> :OLD.so_id
    OR NVL (:NEW.usl_id, 0) <> NVL (:OLD.usl_id, 0)
  THEN
    pra_rec_s5.provjeri_recsousl (:NEW.so_id, NVL (:NEW.usl_id, usl_id_l));
  END IF;

  pra_rec.provjeri_sastojak (:NEW.usl_id, :NEW.sas_id);
  IF :NEW.usl_id IS NULL AND :NEW.sas_id IS NOT NULL THEN
    pra_rec.provjeri_sastojak (usl_id_l, :NEW.sas_id);
  END IF;

  pra_rec_zaj.upisi_audit (:NEW.unos_korisnik, :NEW.unos_dat, :NEW.izmjena_korisnik, :NEW.izmjena_dat);
END;
/
SHOW ERROR
